#
# Copyright (c) 2006-2026 Wade Alcorn - wade@bindshell.net
# Browser Exploitation Framework (BeEF) - https://beefproject.com
# See the file 'doc/COPYING' for copying permission
#
class Shell_shock_scanner < BeEF::Core::Command
  def self.options
    configuration = BeEF::Core::Configuration.instance
    lhost = configuration.beef_host
    lhost = '' if lhost == '0.0.0.0'
    [
      { 'name' => 'method', 'ui_label' => 'HTTP Method', 'value' => 'GET' },
      { 'name' => 'rproto',
        'type' => 'combobox',
        'ui_label' => 'Target Protocol',
        'store_type' => 'arraystore',
        'store_fields' => ['rproto'],
        'store_data' => [
          ['http'],
          ['https']
        ],
        'emptyText' => 'Select a protocol (HTTP/HTTPS)',
        'valueField' => 'rproto',
        'displayField' => 'rproto',
        'mode' => 'local',
        'autoWidth' => true },
      { 'name' => 'rhost', 'ui_label' => 'Target Host', 'value' => '127.0.0.1' },
      { 'name' => 'rport', 'ui_label' => 'Target Port', 'value' => '80' },
      { 'name' => 'lhost', 'ui_label' => 'Local Host',  'value' => lhost },
      { 'name' => 'lport', 'ui_label' => 'Local Port',  'value' => '4444' },
      { 'name' => 'wait', 'ui_label' => 'Wait between requests (s)', 'value' => '0.3', 'width' => '100px' }
    ]
  end

  def post_execute
    save({ 'result' => @datastore['result'] })
  end
end
