'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlideUp = exports.Fade = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactTransitionGroup = require('react-transition-group');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var easing = 'cubic-bezier(0.23, 1, 0.32, 1)'; // easeOutQuint
var verticalOffset = 40;

// ==============================
// Fade
// ==============================

var Fade = function Fade(_ref) {
  var Tag = _ref.component,
      onEntered = _ref.onEntered,
      onExited = _ref.onExited,
      inProp = _ref.in,
      originalProps = _ref.innerProps,
      props = _objectWithoutProperties(_ref, ['component', 'onEntered', 'onExited', 'in', 'innerProps']);

  var enter = 300;
  var exit = 500;
  var fadeStyle = {
    transition: 'opacity 200ms',
    opacity: 0
  };
  var fadeTransition = {
    entering: { opacity: 0 },
    entered: { opacity: 1 },
    exiting: { opacity: 0, transitionDuration: exit + 'ms' }
  };

  return _react2.default.createElement(
    _reactTransitionGroup.Transition,
    {
      appear: true,
      mountOnEnter: true,
      unmountOnExit: true,
      onEntered: onEntered,
      onExited: onExited,
      key: 'fade',
      'in': inProp,
      timeout: { enter: enter, exit: exit }
    },
    function (status) {
      var innerProps = _extends({}, originalProps, {
        style: _extends({}, fadeStyle, fadeTransition[status])
      });

      if (status === 'exited') return null;

      return _react2.default.createElement(Tag, _extends({ innerProps: innerProps }, props));
    }
  );
};

// ==============================
// Slide Up
// ==============================

exports.Fade = Fade;
var SlideUp = function SlideUp(_ref2) {
  var Tag = _ref2.component,
      onEntered = _ref2.onEntered,
      onExited = _ref2.onExited,
      inProp = _ref2.in,
      originalProps = _ref2.innerProps,
      props = _objectWithoutProperties(_ref2, ['component', 'onEntered', 'onExited', 'in', 'innerProps']);

  var enter = 300;
  var exit = 500;
  var restingTransform = 'translate3d(0, 0, 0)';
  var slideStyle = {
    transition: 'transform ' + enter + 'ms ' + easing + ', opacity ' + enter + 'ms ' + easing,
    transform: restingTransform
  };
  var slideTransition = {
    entering: {
      opacity: 0,
      transform: 'translate3d(0, ' + verticalOffset + 'px, 0) scale(0.9)'
    },
    entered: {
      opacity: 1,
      transform: restingTransform
    },
    exiting: {
      opacity: 0,
      transform: 'translate3d(0, ' + verticalOffset + 'px, 0) scale(0.9)',
      transition: 'transform ' + exit + 'ms ' + easing + ', opacity ' + exit + 'ms ' + easing
    }
  };

  return _react2.default.createElement(
    _reactTransitionGroup.Transition,
    {
      appear: true,
      'in': inProp,
      mountOnEnter: true,
      onEntered: onEntered,
      onExited: onExited,
      timeout: { enter: enter, exit: exit },
      unmountOnExit: true
    },
    function (status) {
      if (status === 'exited') return null;

      var innerProps = _extends({}, originalProps, {
        style: _extends({}, slideStyle, slideTransition[status])
      });

      return _react2.default.createElement(Tag, _extends({ innerProps: innerProps }, props));
    }
  );
};
exports.SlideUp = SlideUp;