'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _utils = require('./utils');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Keyboard = function () {
  function Keyboard(pager) {
    var _this = this;

    _classCallCheck(this, Keyboard);

    this._handleKeyDown = function (e) {
      // handle respective key controls
      switch (e.key) {
        // move to the previous view
        case 'ArrowUp':
        case 'ArrowLeft':
          _this.pager.prev();
          return;

        // move to the next view
        case 'ArrowDown':
        case 'ArrowRight':
        case ' ':
          _this.pager.next();
          return;

        // move to first view
        case 'Home':
          _this.pager.setCurrentView({ index: 0 });
          return;

        // move to last view
        case 'End':
          _this.pager.setCurrentView({ index: _this.pager.views.length - 1 });
          return;
      }

      // 1 - 9 keys mapped to respective slide number
      var maxNumKey = (0, _utils.clamp)(_this.pager.views.length, 0, 9);

      for (var i = 1; i <= maxNumKey; i++) {
        if (+e.key === i) {
          _this.pager.setCurrentView({ index: i - 1 });
        }
      }
    };

    this.pager = pager;
  }

  _createClass(Keyboard, [{
    key: 'getEvents',
    value: function getEvents() {
      var keyboardEvents = {};

      if (this.pager.options.accessibility) {
        keyboardEvents.onKeyDown = this._handleKeyDown;
      }

      return keyboardEvents;
    }
  }]);

  return Keyboard;
}();

exports.default = Keyboard;
module.exports = exports['default'];