'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = parseVue;

var _babylon = require('babylon');

var _utils = require('../utils');

var compiler = (0, _utils.tryRequire)('vue-template-compiler');

function parseVue(content) {
  if (!compiler) {
    return [];
  }
  var parsed = compiler.parseComponent(content);
  if (!parsed.script) {
    return [];
  }
  return (0, _babylon.parse)(parsed.script.content, {
    sourceType: 'module'
  });
}
module.exports = exports['default'];