# node-exploitsearch-client

A Node ([node.js™](http://nodejs.org/) / [io.js](https://iojs.org/en/index.html)) library for accessing the [Exploitsearch.net](http://www.exploitsearch.net/) site API.

![Demo](https://raw.githubusercontent.com/jesusprubio/node-exploitsearch-client/master/artifacts/demo.gif)

## Use

```javascript
var ExploitSearch = require('exploitsearch'),
  options = {
    timeout: 10000,
    // We only want exploits now, not vulns
    exploits: true
  },
  client;

client = new ExploitSearch(options);
client.search('freepbx', function (err, data) {
  if (err) {
    console.log('ERROR: client.search:');
    console.log(err);
  } else {
    console.log(data);
  }
});
```

[**Full example**](./examples/use.js)

## Developer guide

- Use [GitHub pull requests](https://help.github.com/articles/using-pull-requests).
- Conventions:
 - We use [ESLint](http://eslint.org/) and [Airbnb](https://github.com/airbnb/javascript) style guide.
 - Please run `grunt eslint` to be sure your code fits with them.

## License

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
