module.exports = function natcasesort(inputArr) {
  //      discuss at: https://locutus.io/php/natcasesort/
  // parity verified: PHP 8.3
  //     original by: Brett Zamir (https://brett-zamir.me)
  //     improved by: Brett Zamir (https://brett-zamir.me)
  //     improved by: Theriault (https://github.com/Theriault)
  //          note 1: This function deviates from PHP in returning a copy of the array instead
  //          note 1: of acting by reference and returning true; this was necessary because
  //          note 1: IE does not allow deleting and re-adding of properties without caching
  //          note 1: of property position; you can set the ini of "locutus.sortByReference" to true to
  //          note 1: get the PHP behavior, but use this only if you are in an environment
  //          note 1: such as Firefox extensions where for-in iteration order is fixed and true
  //          note 1: property deletion is supported. Note that we intend to implement the PHP
  //          note 1: behavior by default if IE ever does allow it; only gives shallow copy since
  //          note 1: is by reference in PHP anyways
  //          note 1: We cannot use numbers as keys and have them be reordered since they
  //          note 1: adhere to numerical order in some implementations
  //       example 1: var $array1 = {a:'IMG0.png', b:'img12.png', c:'img10.png', d:'img2.png', e:'img1.png', f:'IMG3.png'}
  //       example 1: natcasesort($array1)
  //       example 1: var $result = $array1
  //       returns 1: {a: 'IMG0.png', e: 'img1.png', d: 'img2.png', f: 'IMG3.png', c: 'img10.png', b: 'img12.png'}

  const strnatcasecmp = require('../strings/strnatcasecmp')
  const valArr = []
  let k
  let i
  let sortByReference = false
  let populateArr = {}

  const iniVal =
    (typeof require !== 'undefined' ? require('../info/ini_get')('locutus.sortByReference') : undefined) || 'on'
  sortByReference = iniVal === 'on'
  populateArr = sortByReference ? inputArr : populateArr

  // Get key and value arrays
  for (k in inputArr) {
    if (inputArr.hasOwnProperty(k)) {
      valArr.push([k, inputArr[k]])
      if (sortByReference) {
        delete inputArr[k]
      }
    }
  }
  valArr.sort(function (a, b) {
    return strnatcasecmp(a[1], b[1])
  })

  // Repopulate the old array
  for (i = 0; i < valArr.length; i++) {
    populateArr[valArr[i][0]] = valArr[i][1]
  }

  return sortByReference || populateArr
}
