/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.IScanIssue;
import burp.IScannerCheck;
import burp.IScannerInsertionPoint;
import java.util.List;
import uk.co.pentest.SHELLING.IntruderPayloadGenerator;
import uk.co.pentest.SHELLING.ShellingTab;

abstract class ShellingScannerCheck
implements IScannerCheck {
    protected IBurpExtenderCallbacks callbacks;
    protected IExtensionHelpers helpers;
    protected IntruderPayloadGenerator generator;
    protected IHttpService checkHttpService;
    protected static int counter = 0;

    public ShellingScannerCheck(IBurpExtenderCallbacks cb, ShellingTab tab) {
        this.callbacks = cb;
        this.helpers = this.callbacks.getHelpers();
    }

    protected boolean createCheckHttpService(String host, int port, boolean https) {
        if (host == null || port < 1 || port > 65535) {
            return false;
        }
        if (host.isEmpty() || port < 1 || port > 65535) {
            return false;
        }
        if (this.checkHttpService == null) {
            this.checkHttpService = this.helpers.buildHttpService(host, port, https);
        } else {
            String currHost = this.checkHttpService.getHost();
            int currPort = this.checkHttpService.getPort();
            String currHttps = this.checkHttpService.getProtocol();
            if (!currHost.equals(host) || currPort != port || !currHttps.equalsIgnoreCase("http" + (https ? "s" : ""))) {
                this.checkHttpService = this.helpers.buildHttpService(host, port, https);
            }
        }
        return true;
    }

    public List<IScanIssue> doPassiveScan(IHttpRequestResponse baseRequestResponse) {
        return null;
    }

    public abstract int consolidateDuplicateIssues(IScanIssue var1, IScanIssue var2);

    public abstract List<IScanIssue> doActiveScan(IHttpRequestResponse var1, IScannerInsertionPoint var2);
}

