/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.IScanIssue;
import java.net.URL;

public abstract class ShellingScannerIssue
implements IScanIssue {
    private IHttpRequestResponse[] httpMessages;
    private IHttpService httpService;
    private String remediationBackground;
    private URL url;
    private String confidence = "Certain";
    private String feedbackMethod;
    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;
    private String ISSUE_BACKGROUND = "Someone is having a good day.<br>";
    private String REM_BACKGROUND = "It's time to play.<br>";

    ShellingScannerIssue(IBurpExtenderCallbacks cb, IHttpRequestResponse exploitRR, String details, String feedbackMethod) {
        this.callbacks = cb;
        this.helpers = this.callbacks.getHelpers();
        this.url = this.helpers.analyzeRequest(exploitRR).getUrl();
        this.httpService = exploitRR.getHttpService();
        this.httpMessages = new IHttpRequestResponse[]{exploitRR};
        this.feedbackMethod = feedbackMethod;
        if (feedbackMethod == "time") {
            this.confidence = "Tentative";
        }
        this.ISSUE_BACKGROUND = this.ISSUE_BACKGROUND + details;
    }

    public String getConfidence() {
        return this.confidence;
    }

    public IHttpRequestResponse[] getHttpMessages() {
        return this.httpMessages;
    }

    public IHttpService getHttpService() {
        return this.httpService;
    }

    public String getIssueBackground() {
        return this.ISSUE_BACKGROUND;
    }

    public abstract String getIssueDetail();

    public String getIssueName() {
        return "Command Injection (SHELLING-" + this.feedbackMethod + ")";
    }

    public int getIssueType() {
        return 0;
    }

    public String getRemediationBackground() {
        return this.REM_BACKGROUND;
    }

    public String getRemediationDetail() {
        return null;
    }

    public String getSeverity() {
        return "High";
    }

    public URL getUrl() {
        return this.url;
    }
}

