# Gestures & Shortcuts - CAI Mobile UI

> **⚡ CAI-Pro Exclusive**  
> Master touch gestures and keyboard shortcuts for efficient mobile security testing.

## Touch Gestures

### Basic Navigation

| Gesture | Action | Context |
|---------|--------|---------|
| **Tap** | Select/Activate | Any interactive element |
| **Swipe Right** | Previous conversation | Chat screen |
| **Swipe Left** | Next conversation | Chat screen |
| **Pull Down** | Refresh/Cancel | During agent response |
| **Pinch Out** | Increase text size | Chat messages |
| **Pinch In** | Decrease text size | Chat messages |

### Message Interactions

| Gesture | Action | Result |
|---------|--------|--------|
| **Long Press Message** | Show actions | Copy/Share/Save menu |
| **Double Tap Code** | Quick copy | Copies code to clipboard |
| **Swipe Left on Message** | Show options | Retry/Delete buttons |
| **3D Touch/Haptic Touch** | Preview | Preview without opening |

### Advanced Gestures

| Gesture | Action | Where |
|---------|--------|-------|
| **Two-Finger Swipe Up** | Jump to top | Chat view |
| **Two-Finger Swipe Down** | Jump to bottom | Chat view |
| **Three-Finger Swipe** | Switch apps | Anywhere |
| **Shake Device** | Undo/Report | After action |

## iPad Keyboard Shortcuts

### Navigation

| Shortcut | Action |
|----------|--------|
| `⌘ + 1-9` | Jump to conversation 1-9 |
| `⌘ + ←` | Previous conversation |
| `⌘ + →` | Next conversation |
| `⌘ + ↑` | Scroll to top |
| `⌘ + ↓` | Scroll to bottom |

### Conversation Management

| Shortcut | Action |
|----------|--------|
| `⌘ + N` | New conversation |
| `⌘ + W` | Close current conversation |
| `⌘ + D` | Duplicate conversation |
| `⌘ + S` | Save/Export conversation |
| `⌘ + P` | Print conversation |

### Text Editing

| Shortcut | Action |
|----------|--------|
| `⌘ + /` | Focus message input |
| `⌘ + Return` | Send message |
| `⌘ + Shift + Return` | New line |
| `⌘ + A` | Select all |
| `⌘ + Z` | Undo |
| `⌘ + Shift + Z` | Redo |

### Agent & Model Control

| Shortcut | Action |
|----------|--------|
| `⌘ + K` | Quick agent switch |
| `⌘ + M` | Quick model switch |
| `⌘ + .` | Cancel current generation |
| `⌘ + R` | Retry last message |

### View Control

| Shortcut | Action |
|----------|--------|
| `⌘ + +` | Increase text size |
| `⌘ + -` | Decrease text size |
| `⌘ + 0` | Reset text size |
| `⌘ + L` | Clear conversation |
| `⌘ + F` | Find in conversation |

## Quick Actions

### From Lock Screen

- **Notification Actions**: Reply directly from notifications
- **Widget Actions**: Quick launch with specific agent
- **Siri Shortcuts**: "Start CAI security scan"

### From Home Screen

**3D Touch Menu**:
- New Conversation
- Continue Last Session
- Quick Scan Network
- View Recent Chats

### Control Center

Add CAI controls:
- Quick Connect/Disconnect
- Agent Status Toggle
- Cost Tracker Widget

## Gesture Customization

### Settings → Gestures

**Swipe Sensitivity**
- Light: 100pt minimum
- Normal: 75pt minimum (default)
- Heavy: 50pt minimum

**Long Press Duration**
- Fast: 0.3 seconds
- Normal: 0.5 seconds (default)
- Slow: 0.7 seconds

**Haptic Feedback**
- Off: No vibration
- Light: Subtle taps
- Medium: Standard feedback (default)
- Heavy: Strong vibration

## Accessibility Shortcuts

### VoiceOver Gestures

| Gesture | Action |
|---------|--------|
| **Two-Finger Tap** | Pause/Resume reading |
| **Three-Finger Tap** | Show item chooser |
| **Two-Finger Rotate** | Access rotor |
| **One-Finger Swipe** | Navigate items |

### Voice Control Commands

| Command | Action |
|---------|--------|
| "Show numbers" | Display tap targets |
| "Show grid" | Show screen grid |
| "Tap [element]" | Activate element |
| "Scroll down/up" | Navigate content |

## Pro Tips

### Speed Techniques

1. **Quick Agent Switch**: Swipe down from agent name
2. **Instant Copy**: Triple-tap any text
3. **Fast Scroll**: Tap status bar to jump to top
4. **Batch Actions**: Select multiple messages with two-finger tap

### Hidden Features

1. **Debug Menu**: Five-tap on version number
2. **FPS Counter**: Settings → Developer → Show FPS
3. **Network Logger**: Shake device while in settings
4. **Export Raw JSON**: Long press export button

### Gesture Combinations

1. **Cancel + Clear**: Pull down + shake
2. **Quick Share**: Long press + swipe up
3. **Multi-Select**: Two-finger tap + drag
4. **Focus Mode**: Triple-tap navigation bar

## Troubleshooting Gestures

### Common Issues

**Gestures not working:**
- Check Settings → Accessibility → Touch
- Disable any conflicting accessibility features
- Reset gesture settings to defaults

**Accidental triggers:**
- Increase swipe sensitivity
- Enable gesture confirmation
- Adjust long press duration

**iPad keyboard issues:**
- Ensure external keyboard connected
- Check Settings → Keyboard → Shortcuts
- Update to latest iOS version

## Platform-Specific Features

### iPhone-Only Gestures

- **Reachability**: Swipe down on bottom edge
- **Back Gesture**: Swipe from left edge
- **App Switcher**: Swipe up and hold

### iPad-Only Features

- **Split View**: Drag from dock
- **Slide Over**: Swipe from right edge
- **Picture in Picture**: Pinch video

## Next Steps

- 💬 [Master Chat Features](chat_features.md)
- 🎯 [Learn Agent Selection](agent_selection.md)
- 🛠️ [Configure Network & MCP](network_mcp.md)

---

*Efficient gestures lead to faster security testing*