/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import java.awt.Color;
import java.awt.FlowLayout;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;

public class DateTimePicker
extends JXDatePicker {
    private JSpinner _timeSpinner;
    private JPanel _timePanel;
    private String _timeFormat;
    private boolean _updatingSpinner = false;
    private boolean _updatingText = false;

    public DateTimePicker() {
        this.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel(){

            protected void setSelection(Date date) {
                date = DateTimePicker.this.appendTime(date);
                super.setSelection(date);
            }
        });
        this.getEditor().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            private void update() {
                if (!DateTimePicker.this._updatingSpinner) {
                    DateTimePicker.this._updatingText = true;
                    String string = DateTimePicker.this.getEditor().getText();
                    try {
                        Date date = DateTimePicker.this.getFormats()[0].parse(string);
                        DateTimePicker.this.setTimeSpinners(date);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    DateTimePicker.this._updatingText = false;
                }
            }
        });
    }

    public DateTimePicker(Date date) {
        this();
        this.setDate(date);
    }

    public void commitEdit() throws ParseException {
        super.commitEdit();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setTimeSpinners(this.getDate());
    }

    public JPanel getLinkPanel() {
        super.getLinkPanel();
        if (this._timePanel == null) {
            this._timePanel = this.createTimePanel();
        }
        this.setTimeSpinners(this.getDate());
        return this._timePanel;
    }

    private JPanel createTimePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        this._timeSpinner = new JSpinner(spinnerDateModel);
        if (this._timeFormat == null) {
            this._timeFormat = "HH:mm:ss.S";
        }
        this.updateTextFieldFormat();
        jPanel.add(new JLabel("Time:"));
        jPanel.add(this._timeSpinner);
        jPanel.setBackground(Color.WHITE);
        this._timeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!DateTimePicker.this._updatingText) {
                    DateTimePicker.this._updatingSpinner = true;
                    DateTimePicker.this.commitTime();
                    DateTimePicker.this._updatingSpinner = false;
                }
            }
        });
        return jPanel;
    }

    private void updateTextFieldFormat() {
        if (this._timeSpinner == null) {
            return;
        }
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this._timeSpinner, this._timeFormat);
        this._timeSpinner.setEditor(dateEditor);
    }

    private void commitTime() {
        Date date = this.getDate();
        if (date != null) {
            Date date2 = this.appendTime(date);
            this.setDate(date2);
            this.firePropertyChange("date", date, date2);
        }
    }

    private Date appendTime(Date date) {
        if (date != null) {
            Date date2 = (Date)this._timeSpinner.getValue();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date2);
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar2.setTime(date);
            gregorianCalendar2.set(11, gregorianCalendar.get(11));
            gregorianCalendar2.set(12, gregorianCalendar.get(12));
            gregorianCalendar2.set(13, gregorianCalendar.get(13));
            gregorianCalendar2.set(14, gregorianCalendar.get(14));
            date = gregorianCalendar2.getTime();
        }
        return date;
    }

    private void setTimeSpinners(Date date) {
        if (date != null) {
            this._timeSpinner.setValue(date);
        }
    }

    public String getTimeFormat() {
        return this._timeFormat;
    }

    public void setTimeFormat(String string) {
        this._timeFormat = string;
        this.updateTextFieldFormat();
    }
}

