/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view;

import com.paterva.maltego.layout.LayoutFactory;
import com.paterva.maltego.layout.view.LayoutHandler;
import com.paterva.maltego.layout.view.ViewLayouter;
import com.paterva.maltego.ui.graph.actions.PlaceLabelsAction;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.util.actions.SystemAction;
import yguard.A.A.Y;
import yguard.A.I.QA;
import yguard.A.I.S;

public class OnceOffLayoutViewHandler
implements LayoutHandler {
    private S _view;
    private boolean _isLayouting = false;
    private boolean _needsLayouting = false;
    private Set<Y> _nodesToLayout = new HashSet<Y>();
    private LayoutFactory.LayoutMode _layoutMode;
    private boolean _layoutAll;

    OnceOffLayoutViewHandler(S s) {
        this._view = s;
    }

    public void setLayoutMode(LayoutFactory.LayoutMode layoutMode, boolean bl, boolean bl2) {
        this._layoutMode = layoutMode;
        this._layoutAll = bl;
        if (bl2) {
            this.scheduleLayout(false);
        }
    }

    @Override
    public void onGraphChanged(QA qA, QA qA2) {
        if (this._layoutMode != null) {
            this.placeLabels(qA2);
        }
    }

    @Override
    public void onGraphUpdated(Set<Y> set) {
        this._nodesToLayout.addAll(set);
        this.scheduleLayout(true);
    }

    protected void placeLabels(QA qA) {
        PlaceLabelsAction placeLabelsAction = (PlaceLabelsAction)SystemAction.get(PlaceLabelsAction.class);
        if (placeLabelsAction != null) {
            placeLabelsAction.perform(qA, null);
        }
    }

    protected void scheduleLayout(boolean bl) {
        if (!this._isLayouting) {
            this.doLayout(bl);
        } else {
            this._needsLayouting = true;
        }
    }

    protected void doLayout(boolean bl) {
        if (this._layoutMode == null) {
            this._isLayouting = false;
            return;
        }
        this._isLayouting = true;
        if (!this._layoutAll) {
            ViewLayouter.layoutNodes(this._view, this._nodesToLayout, this._layoutMode, bl, new LayoutDoneHandler());
        } else {
            ViewLayouter.layoutAll(this._view, this._layoutMode, bl, new LayoutDoneHandler());
        }
        this._nodesToLayout.clear();
    }

    protected void doneLayouting() {
        if (this._needsLayouting) {
            this._needsLayouting = false;
            this.doLayout(true);
        } else {
            this._isLayouting = false;
        }
    }

    @Override
    public void prepareToShow() {
    }

    @Override
    public void onComponentShowing() {
    }

    @Override
    public void onComponentHidden() {
    }

    @Override
    public void onComponentClosed() {
    }

    protected class LayoutDoneHandler
    implements Runnable {
        protected LayoutDoneHandler() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OnceOffLayoutViewHandler.this.doneLayouting();
                }
            });
        }
    }
}

