/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.EntryDescriptor;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;

public abstract class Entry<T>
extends ZipEntry {
    private T _data;

    public Entry(T t, String string, String string2) {
        this(t, string, string2, null);
    }

    public Entry(T t, String string, String string2, String string3) {
        super(string + "/" + string2);
        this.setDisplayName(string3);
        this._data = t;
    }

    public Entry(String string) {
        super(string);
    }

    public T getData() {
        return this._data;
    }

    public String getTypeName() {
        String[] stringArray = Entry.parse(this.getName());
        return stringArray[1];
    }

    public String getType() {
        String[] stringArray = Entry.parse(this.getName());
        return stringArray[2];
    }

    public String getFolder() {
        String[] stringArray = Entry.parse(this.getName());
        return stringArray[0];
    }

    public static String[] parse(String string) {
        String[] stringArray = new String[3];
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf("/");
        if (n < 0 || n >= string.length() - 1) {
            stringArray[0] = "";
            n = -1;
        } else {
            stringArray[0] = string.substring(0, n);
        }
        int n2 = string.lastIndexOf(".");
        if (n2 < 0) {
            stringArray[2] = "";
            n2 = string.length();
        } else if (n2 >= string.length() - 1) {
            stringArray[2] = "";
            n2 = string.length() - 1;
        } else {
            stringArray[2] = string.substring(n2 + 1);
        }
        stringArray[1] = n2 > n ? string.substring(n + 1, n2) : "";
        return stringArray;
    }

    public String getDisplayName() {
        if (StringUtilities.isNullOrEmpty((String)this.getComment())) {
            return this.getTypeName();
        }
        return this.getComment();
    }

    public void setDisplayName(String string) {
        if (string != null) {
            this.setComment(string);
        } else {
            this.setComment("");
        }
    }

    public boolean equals(EntryDescriptor entryDescriptor) {
        if (entryDescriptor == null) {
            return false;
        }
        return entryDescriptor.getName().equals(this.getName());
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    protected abstract T read(InputStream var1) throws IOException;

    protected abstract void write(T var1, OutputStream var2) throws IOException;
}

