/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz.graph;

import com.paterva.maltego.archive.mtz.graph.EntityInputHandler;
import com.paterva.maltego.archive.mtz.graph.EntityOutputHandler;
import com.paterva.maltego.archive.mtz.graph.EntityRealizerSerializer;
import com.paterva.maltego.archive.mtz.graph.LinkInputHandler;
import com.paterva.maltego.archive.mtz.graph.LinkOutputHandler;
import com.paterva.maltego.archive.mtz.graph.LinkRealizerSerializer;
import com.paterva.maltego.entity.api.EntityFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import yguard.A.A.D;
import yguard.A.H.B.A.B;
import yguard.A.H.B.A.H;
import yguard.A.H.B.A.X;
import yguard.A.H.B.B.S;
import yguard.A.H.B.C.J;
import yguard.A.H.B.C.K;
import yguard.A.H.B.C.g;
import yguard.A.H.Q;
import yguard.A.I.QA;

public class MaltegoGraphIO {
    private MaltegoGraphIO() {
    }

    public static void write(D d2, OutputStream outputStream) throws IOException {
        Q q = MaltegoGraphIO.createOutputHandler();
        q.write((QA)d2, outputStream);
    }

    public static D read(InputStream inputStream, EntityFactory entityFactory) throws IOException {
        Q q = MaltegoGraphIO.createInputHandler(entityFactory);
        QA qA = new QA();
        q.read(qA, inputStream);
        return qA;
    }

    protected static Q createInputHandler(EntityFactory entityFactory) {
        Q q = new Q();
        g g2 = q.getGraphMLHandler();
        g2.addInputHandlerProvider((S)new EntityInputHandler(entityFactory));
        g2.addInputHandlerProvider((S)new LinkInputHandler());
        q.addNodeRealizerSerializer((J)new EntityRealizerSerializer());
        q.addEdgeRealizerSerializer((K)new LinkRealizerSerializer());
        return q;
    }

    protected static Q createOutputHandler() {
        MyGraphMLIOHandler myGraphMLIOHandler = new MyGraphMLIOHandler();
        g g2 = myGraphMLIOHandler.getGraphMLHandler();
        g2.addOutputHandlerProvider((X)new EntityOutputHandler());
        g2.addOutputHandlerProvider((X)new LinkOutputHandler());
        myGraphMLIOHandler.addNodeRealizerSerializer(new EntityRealizerSerializer());
        myGraphMLIOHandler.addEdgeRealizerSerializer(new LinkRealizerSerializer());
        return myGraphMLIOHandler;
    }

    private static class MyXmlWriter
    extends yguard.A.H.B.A.S {
        private OutputStream _out;

        public MyXmlWriter(Writer writer) throws B {
            super(writer);
            this.setWriteXmlDeclaration(false);
        }

        public MyXmlWriter(OutputStream outputStream, String string) throws B {
            super(outputStream, string);
            this._out = outputStream;
            this.setWriteXmlDeclaration(false);
        }

        public void flushDocument() throws B {
            if (this._out != null) {
                String string = "<?xml version=\"1.1\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n";
                try {
                    this._out.write(string.getBytes("UTF-8"));
                }
                catch (IOException iOException) {
                    throw new B("Could not write XML declaration", (Exception)iOException);
                }
            }
            super.flushDocument();
        }

        public H writeComment(String string) {
            if (string.toLowerCase().contains("yfiles")) {
                this.writeStartElement("", "VersionInfo", null);
                this.writeAttribute("createdBy", System.getProperty("maltego.product-name", "Maltego"));
                this.writeAttribute("version", System.getProperty("maltego.fullversion"));
                this.writeAttribute("subtitle", System.getProperty("maltego.version-subtitle"));
                this.writeEndElement();
            }
            return this;
        }
    }

    private static class MyGraphMLHandler
    extends g {
        private MyGraphMLHandler() {
        }

        protected H createXMLWriter(Writer writer) throws B {
            MyXmlWriter myXmlWriter = new MyXmlWriter(writer);
            this.configureXMLWriter((H)myXmlWriter);
            return myXmlWriter;
        }

        protected H createXMLWriter(OutputStream outputStream, String string) throws B {
            MyXmlWriter myXmlWriter = new MyXmlWriter(outputStream, string);
            this.configureXMLWriter((H)myXmlWriter);
            return myXmlWriter;
        }
    }

    private static class MyGraphMLIOHandler
    extends Q {
        private MyGraphMLIOHandler() {
        }

        protected g createGraphMLHandler() {
            return new MyGraphMLHandler();
        }
    }
}

