/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.registry.FileSystemRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.util.Collection;

public class DefaultEntityRegistry
extends EntityRegistry {
    private static final String MALTEGO_ENTITIES_FOLDER = "Maltego/Entities";
    private static final String MALTEGO_ENTITIES_EXT = "entity";
    private static final String DEFAULT_FOLDER = "Miscellaneous";
    private FileSystemRegistry<MaltegoEntitySpec> _delegate;

    public DefaultEntityRegistry() {
        this(MALTEGO_ENTITIES_FOLDER);
    }

    public DefaultEntityRegistry(String string) {
        this._delegate = new FileSystemRegistry(string, MALTEGO_ENTITIES_EXT);
    }

    public MaltegoEntitySpec get(String string) {
        return this._delegate.get(string);
    }

    public Collection<MaltegoEntitySpec> getAll() {
        return this._delegate.getAll();
    }

    public void put(MaltegoEntitySpec maltegoEntitySpec) {
        this.put(maltegoEntitySpec, maltegoEntitySpec.getDefaultCategory());
    }

    public void put(MaltegoEntitySpec maltegoEntitySpec, String string) {
        if (string == null) {
            string = DEFAULT_FOLDER;
        }
        if (this._delegate.contains(maltegoEntitySpec.getTypeName())) {
            this._delegate.update(maltegoEntitySpec);
            this.fireTypeUpdated((TypeSpec)maltegoEntitySpec);
        } else {
            this._delegate.add(maltegoEntitySpec, string);
            this.fireTypeAdded((TypeSpec)maltegoEntitySpec);
        }
    }

    public void remove(String string) {
        MaltegoEntitySpec maltegoEntitySpec = this.get(string);
        if (maltegoEntitySpec != null) {
            this._delegate.remove(string);
            this.fireTypeRemoved((TypeSpec)maltegoEntitySpec);
        }
    }

    public boolean contains(String string) {
        return this._delegate.contains(string);
    }

    public String[] allCategories() {
        return this._delegate.getFolders();
    }
}

