/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;

public class PropertyTypes {
    private static String[] _valueTypes = new String[]{"string", "date", "int", "double"};
    private static String[] _imageTypes = new String[]{"image", "url", "string", "attachments"};

    private PropertyTypes() {
    }

    public static TypeDescriptor[] valueTypes() {
        return PropertyTypes.getTypes(_valueTypes);
    }

    private static TypeDescriptor[] getTypes(String[] stringArray) {
        TypeRegistry typeRegistry = TypeRegistry.getDefault();
        ArrayList<TypeDescriptor> arrayList = new ArrayList<TypeDescriptor>();
        for (String string : stringArray) {
            arrayList.add(typeRegistry.getType(string));
        }
        return arrayList.toArray(new TypeDescriptor[arrayList.size()]);
    }

    public static TypeDescriptor[] allTypes() {
        return new TypeDescriptor[0];
    }

    public static DisplayDescriptor[] getValueProperties(TypeSpec typeSpec) {
        return PropertyTypes.getPropertiesOfType(typeSpec.getProperties(), _valueTypes);
    }

    public static DisplayDescriptor[] getImageProperties(TypeSpec typeSpec) {
        return PropertyTypes.getPropertiesOfType(typeSpec.getProperties(), _imageTypes);
    }

    public static DisplayDescriptor[] getDisplayValueProperties(TypeSpec typeSpec) {
        return PropertyTypes.getValueProperties(typeSpec);
    }

    private static DisplayDescriptor[] getPropertiesOfType(DisplayDescriptorCollection displayDescriptorCollection, String[] stringArray) {
        Object[] objectArray = Arrays.copyOf(stringArray, stringArray.length);
        Arrays.sort(objectArray);
        ArrayList<DisplayDescriptor> arrayList = new ArrayList<DisplayDescriptor>();
        for (DisplayDescriptor displayDescriptor : displayDescriptorCollection) {
            if (Arrays.binarySearch(objectArray, displayDescriptor.getTypeDescriptor().getTypeName()) < 0) continue;
            arrayList.add(displayDescriptor);
        }
        return arrayList.toArray(new DisplayDescriptor[arrayList.size()]);
    }
}

