/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public class CenterOnNodeAction
extends NodeAction
implements PropertyChangeListener {
    private GraphEditorRegistry _editors;

    public CenterOnNodeAction() {
        this(GraphEditorRegistry.getDefault());
    }

    public CenterOnNodeAction(GraphEditorRegistry graphEditorRegistry) {
        this._editors = graphEditorRegistry;
        this._editors.addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void performAction(Node[] nodeArray) {
        GraphViewCookie graphViewCookie;
        TopComponent topComponent = this._editors.getTopmost();
        if (this.checkEnabled(topComponent, nodeArray) && (graphViewCookie = (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class)) != null) {
            System.out.println("CENTER on " + nodeArray[0]);
            graphViewCookie.getGraphView().center(nodeArray[0]);
            graphViewCookie.getGraphView().setZoom(0.75);
        }
    }

    public void performAction(Node node) {
        this.performAction(new Node[]{node});
    }

    protected boolean enable(Node[] nodeArray) {
        return this.checkEnabled(this._editors.getTopmost(), nodeArray);
    }

    private boolean checkEnabled(TopComponent topComponent, Node[] nodeArray) {
        return topComponent != null && nodeArray.length == 1;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("topmost".equals(propertyChangeEvent.getPropertyName())) {
            this.setEnabled(this.checkEnabled((TopComponent)propertyChangeEvent.getNewValue(), this.getActivatedNodes()));
        }
    }

    public String getName() {
        return "Center node";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

