/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.propertyview;

import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.PropertyBag;
import com.paterva.maltego.propertyview.AddDynamicPropertyAction;
import com.paterva.maltego.propertyview.EditPropertyMappingsAction;
import com.paterva.maltego.propertyview.ManyNodesPrompt;
import com.paterva.maltego.propertyview.PropertyFilterNode;
import com.paterva.maltego.typing.editing.propertygrid.DisplayDescriptorProperty;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphHoverContext;
import com.paterva.maltego.ui.graph.actions.EditNodeAction;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.nodes.PartProperties;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class PropertyViewTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static PropertyViewTopComponent instance;
    static final String ICON_PATH = "com/paterva/maltego/propertyview/PropertyView16.png";
    private static final String PREFERRED_ID = "maltego.PropertyViewTopComponent";
    private Lookup.Result _selectionResult = null;
    private Lookup.Result _hoverResult = null;
    private PropertySheet _sheet = new PropertySheet();
    private ManyNodesPrompt _prompt = new ManyNodesPrompt(this);
    private RemovePropertyAction _removeAction = new RemovePropertyAction();
    private Node[] _selectedNodes;
    private JToolBar _toolbar;
    private static final String PROMPT_PANEL = "PromptPanel";
    private static final String SHEET_PANEL = "SheetPanel";
    private static final int PROMPT_LIMIT = 1000;
    private static final String PROP_SHOW_TOOLBAR = "propertyViewShowToolbar";
    private LookupListener _hoverListener;
    private LookupListener _selectionListener;

    public PropertyViewTopComponent() {
        this.initComponents();
        Logger.getLogger(PropertySheet.class.getName()).setLevel(Level.OFF);
        this.setName(NbBundle.getMessage(PropertyViewTopComponent.class, (String)"CTL_PropertyViewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(PropertyViewTopComponent.class, (String)"HINT_PropertyViewTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._sheet.setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));
        this._sheet.setDescriptionAreaVisible(false);
        jPanel.add((Component)this._sheet, "Center");
        this._toolbar = new JToolBar();
        this._toolbar.setRollover(true);
        this._toolbar.add((Action)SystemAction.get(AddDynamicPropertyAction.class));
        this._toolbar.add(this._removeAction);
        this._toolbar.add((Action)SystemAction.get(EditPropertyMappingsAction.class));
        this._toolbar.add(Box.createHorizontalGlue());
        this._toolbar.add((Action)SystemAction.get(EditNodeAction.class));
        jPanel.add((Component)this._toolbar, "Last");
        this.add(jPanel, SHEET_PANEL);
        this.add(this._prompt, PROMPT_PANEL);
        this._toolbar.setVisible(NbPreferences.forModule(PropertyViewTopComponent.class).getBoolean(PROP_SHOW_TOOLBAR, false));
        this._selectionListener = new SelectionLookupListener();
        this._hoverListener = new HoverLookupListener();
    }

    public Action[] getActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>(Arrays.asList(super.getActions()));
        arrayList.add(new AbstractAction("Show/Hide Toolbar"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyViewTopComponent.this._toolbar.setVisible(!PropertyViewTopComponent.this._toolbar.isVisible());
                NbPreferences.forModule(PropertyViewTopComponent.class).putBoolean(PropertyViewTopComponent.PROP_SHOW_TOOLBAR, PropertyViewTopComponent.this._toolbar.isVisible());
            }
        });
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private void initComponents() {
        this.setLayout(new CardLayout());
    }

    public static synchronized PropertyViewTopComponent getDefault() {
        if (instance == null) {
            instance = new PropertyViewTopComponent();
        }
        return instance;
    }

    public static synchronized PropertyViewTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(PropertyViewTopComponent.class.getName()).warning("Cannot find maltego.PropertyViewTopComponent component. It will not be located properly in the window system.");
            return PropertyViewTopComponent.getDefault();
        }
        if (topComponent instanceof PropertyViewTopComponent) {
            return (PropertyViewTopComponent)topComponent;
        }
        Logger.getLogger(PropertyViewTopComponent.class.getName()).warning("There seem to be multiple components with the 'maltego.PropertyViewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return PropertyViewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        Lookup.Template template = new Lookup.Template(Node.class);
        this._selectionResult = Utilities.actionsGlobalContext().lookup(template);
        this._hoverResult = GraphHoverContext.hoverContext().lookup(template);
        this._selectionResult.addLookupListener(this._selectionListener);
        this._hoverResult.addLookupListener(this._hoverListener);
        this._sheet.addPropertyChangeListener("selectedFeatureDescriptor", (PropertyChangeListener)this);
        this.checkRemoveEnabled();
    }

    public void componentClosed() {
        this._selectionResult.removeLookupListener(this._selectionListener);
        this._selectionResult = null;
        this._hoverResult.removeLookupListener(this._hoverListener);
        this._hoverResult = null;
        this._sheet.removePropertyChangeListener("selectedFeatureDescriptor", (PropertyChangeListener)this);
        this.setSelectedNodes(new Node[0]);
    }

    void writeProperties(Properties properties) {
        properties.setProperty("version", "1.0");
    }

    Object readProperties(Properties properties) {
        PropertyViewTopComponent propertyViewTopComponent = PropertyViewTopComponent.getDefault();
        propertyViewTopComponent.readPropertiesImpl(properties);
        return propertyViewTopComponent;
    }

    private void readPropertiesImpl(Properties properties) {
        String string = properties.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void onResultChanged(boolean bl) {
        this.updateSelectedNodes(bl);
        if (this._selectedNodes == null || this._selectedNodes.length < 1000) {
            this.showNodeProperties();
        } else {
            this.showPrompt();
        }
    }

    private void updateSelectedNodes(boolean bl) {
        if (GraphEditorRegistry.getDefault().getTopmost() != null) {
            Lookup.Result result = bl ? this._hoverResult : this._selectionResult;
            Collection collection = result.allInstances();
            if (collection.isEmpty()) {
                Lookup.Result result2 = !bl ? this._hoverResult : this._selectionResult;
                collection = result2.allInstances();
            }
            this.setSelectedNodes(PropertyViewTopComponent.getSelectedNodes(collection));
        } else {
            this.setSelectedNodes(new Node[0]);
        }
        ((AddDynamicPropertyAction)SystemAction.get(AddDynamicPropertyAction.class)).isEnabled();
        ((EditPropertyMappingsAction)SystemAction.get(EditPropertyMappingsAction.class)).isEnabled();
        ((EditNodeAction)SystemAction.get(EditNodeAction.class)).isEnabled();
    }

    private void setSelectedNodes(Node[] nodeArray) {
        MaltegoPart maltegoPart;
        if (this._selectedNodes != null) {
            for (Node node : this._selectedNodes) {
                maltegoPart = (MaltegoPart)node.getLookup().lookup(MaltegoPart.class);
                maltegoPart.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
        for (Node node : this._selectedNodes = nodeArray) {
            maltegoPart = (MaltegoPart)node.getLookup().lookup(MaltegoPart.class);
            maltegoPart.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void refresh() {
        if (this._selectedNodes != null) {
            this._sheet.setNodes(this._selectedNodes);
        }
        this.checkRemoveEnabled();
    }

    private static Node[] getSelectedNodes(Collection collection) {
        Node[] nodeArray = new Node[collection.size()];
        int n = 0;
        for (Object e : collection) {
            nodeArray[n] = new PropertyFilterNode((Node)e);
            ++n;
        }
        return nodeArray;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"activated".equals(propertyChangeEvent.getPropertyName())) {
            if ("value".equals(propertyChangeEvent.getPropertyName()) || "displayValue".equals(propertyChangeEvent.getPropertyName())) {
                GraphCookie graphCookie;
                TopComponent topComponent = GraphEditorRegistry.getDefault().getTopmost();
                if (topComponent != null && (graphCookie = (GraphCookie)topComponent.getLookup().lookup(GraphCookie.class)) instanceof GraphDataObject) {
                    ((GraphDataObject)graphCookie).setModified(true);
                }
                this._sheet.repaint();
            } else {
                this.checkRemoveEnabled();
            }
        }
    }

    public void showNodeProperties() {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        cardLayout.show((Container)((Object)this), SHEET_PANEL);
        this.refresh();
    }

    public void showPrompt() {
        this._prompt.setNodeCount(this._selectedNodes.length);
        CardLayout cardLayout = (CardLayout)this.getLayout();
        cardLayout.show((Container)((Object)this), PROMPT_PANEL);
    }

    private void checkRemoveEnabled() {
        FeatureDescriptor featureDescriptor;
        boolean bl = false;
        if (this._selectedNodes != null && this._selectedNodes.length > 0 && (featureDescriptor = this._sheet.getSelectedProperty()) instanceof DisplayDescriptorProperty) {
            bl = PartProperties.isDynamicProperty((DisplayDescriptorProperty)((DisplayDescriptorProperty)featureDescriptor));
        }
        this._removeAction.setEnabled(bl);
    }

    private class HoverLookupListener
    implements LookupListener {
        private HoverLookupListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            PropertyViewTopComponent.this.onResultChanged(true);
        }
    }

    private class SelectionLookupListener
    implements LookupListener {
        private SelectionLookupListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            PropertyViewTopComponent.this.onResultChanged(false);
        }
    }

    private class RemovePropertyAction
    extends AbstractAction {
        public RemovePropertyAction() {
            super("Remove");
            this.putValue("SmallIcon", new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/propertyview/Delete.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertyViewTopComponent.this._selectedNodes != null && PropertyViewTopComponent.this._selectedNodes.length > 0) {
                FeatureDescriptor featureDescriptor = PropertyViewTopComponent.this._sheet.getSelectedProperty();
                for (Node node : PropertyViewTopComponent.this._selectedNodes) {
                    PropertyBag propertyBag = (PropertyBag)node.getLookup().lookup(PropertyBag.class);
                    propertyBag.removeProperty(featureDescriptor.getName());
                }
                PropertyViewTopComponent.this.refresh();
            }
        }
    }
}

