/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.find;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openide.util.ImageUtilities;

class FindBar
extends JToolBar
implements ActionListener,
KeyListener,
AncestorListener {
    private JTextField _field = new JTextField(20);
    private JCheckBox _includeNotes = new JCheckBox("Notes");
    private JCheckBox _includeInfo = new JCheckBox("Display info");
    private JCheckBox _includeFields = new JCheckBox("Properties");
    private JCheckBox _bookmark = new JCheckBox("Bookmark results");
    private JCheckBox _zoomToResult = new JCheckBox("Zoom");
    private JComboBox _types;
    private Action _closeAction;
    private Action _findAction;

    public FindBar(Action action, Action action2) {
        this._closeAction = action2;
        this._findAction = action;
        this.setLayout(new BorderLayout());
        this.setAutoscrolls(true);
        this.setRollover(true);
        JButton jButton = new JButton(new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/find/Close.png")));
        jButton.addActionListener(this);
        jButton.setActionCommand("close");
        jButton.setMaximumSize(new Dimension(10, 10));
        jButton.setOpaque(false);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jButton.setAlignmentX(0.5f);
        jButton.setAlignmentY(0.5f);
        JButton jButton2 = new JButton("Find");
        jButton2.addActionListener(this);
        jButton2.setActionCommand("find");
        this._field.addActionListener(this);
        this._field.addKeyListener(this);
        this._includeFields.setToolTipText("Search all properties");
        this._includeNotes.setToolTipText("Search notes");
        this._includeInfo.setToolTipText("Search display information");
        this._zoomToResult.setToolTipText("Zoom to results");
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(5);
        flowLayout.setVgap(0);
        JPanel jPanel = new JPanel(flowLayout);
        this._types = new JComboBox();
        JLabel jLabel = new JLabel("Find");
        jLabel.setHorizontalAlignment(2);
        jPanel.add(jLabel);
        jPanel.add(this._field);
        jPanel.add(this._types);
        jPanel.add(jButton2);
        jPanel.add(this._includeFields);
        jPanel.add(this._includeNotes);
        jPanel.add(this._includeInfo);
        jPanel.add(this._zoomToResult);
        FlowLayout flowLayout2 = new FlowLayout(2, 0, 0);
        JPanel jPanel2 = new JPanel(flowLayout2);
        jPanel2.add(jButton);
        this.add((Component)jPanel, "West");
        this.add((Component)jPanel2, "East");
        this.addAncestorListener(this);
    }

    public boolean isIncludeNotes() {
        return this._includeNotes.isSelected();
    }

    public void setIncludeNotes(boolean bl) {
        this._includeNotes.setSelected(bl);
    }

    public boolean isBookmarkResults() {
        return this._bookmark.isSelected();
    }

    public void setBookmarkResults(boolean bl) {
        this._bookmark.setSelected(bl);
    }

    public boolean isIncludeFields() {
        return this._includeFields.isSelected();
    }

    public void setIncludeFields(boolean bl) {
        this._includeFields.setSelected(bl);
    }

    public boolean isIncludeDisplayInfo() {
        return this._includeInfo.isSelected();
    }

    public void setIncludeDisplayInfo(boolean bl) {
        this._includeInfo.setSelected(bl);
    }

    public boolean isZoomToResult() {
        return this._zoomToResult.isSelected();
    }

    public void setZoomToResult(boolean bl) {
        this._zoomToResult.setSelected(bl);
    }

    public Object[] getOptions() {
        Object[] objectArray = new Object[this._types.getItemCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this._types.getItemAt(i);
        }
        return objectArray;
    }

    public void setOptions(Object[] objectArray) {
        this._types.removeAllItems();
        for (Object object : objectArray) {
            this._types.addItem(object);
        }
        if (objectArray.length > 0) {
            this._types.setSelectedIndex(0);
        }
    }

    public void setSearchText(String string) {
        this._field.setText(string);
    }

    public String getSearchText() {
        return this._field.getText();
    }

    public Object getSelectedOption() {
        return this._types.getSelectedItem();
    }

    public void setSelectedOption(Object object) {
        this._types.setSelectedItem(object);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("close")) {
            this._closeAction.actionPerformed(actionEvent);
        } else {
            this._findAction.actionPerformed(actionEvent);
        }
    }

    private void close() {
        this._closeAction.actionPerformed(new ActionEvent(this, 0, "close"));
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.close();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.close();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FindBar.this._field.requestFocusInWindow();
            }
        });
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }
}

