/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.UserDataHolder;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.actions.ShowLabels;
import com.paterva.maltego.ui.graph.actions.ShowLabelsListener;
import com.paterva.maltego.ui.graph.view2d.LabelEditMode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.util.WeakListeners;
import yguard.A.I.EA;
import yguard.A.I.dA;
import yguard.A.I.o;
import yguard.A.I.q;

public class LinkEdgeRealizer
extends q
implements PropertyChangeListener,
ShowLabelsListener,
UserDataHolder {
    private MaltegoLink _link;

    public LinkEdgeRealizer() {
        this.init();
    }

    public LinkEdgeRealizer(o o2) {
        super(o2);
        this.init();
    }

    private void init() {
        ShowLabels.addListener(this);
    }

    protected void finalize() throws Throwable {
        if (this._link != null) {
            this._link.removePropertyChangeListener((PropertyChangeListener)this);
            this._link = null;
        }
        ShowLabels.removeListener(this);
        super.finalize();
    }

    public void removeLabels() {
        while (this.labelCount() > 0) {
            this.removeLabel(this.getLabel(0));
        }
    }

    public o createCopy() {
        return this.createCopy((o)this);
    }

    public o createCopy(o o2) {
        return new LinkEdgeRealizer(o2);
    }

    public Object getUserData() {
        return this._link;
    }

    public void setUserData(Object object) {
        if (this._link != null) {
            this._link.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (object instanceof MaltegoLink) {
            MaltegoLink maltegoLink;
            this._link = maltegoLink = (MaltegoLink)object;
            this._link.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this._link));
        } else {
            this._link = null;
        }
        this.update();
    }

    private void update() {
        this.updateText();
        this.updateColor();
        this.updateLineType();
    }

    private void updateText() {
        if (this._link != null) {
            if (ShowLabels.isShowLabelForLink(this._link)) {
                Object object = InheritanceHelper.getValue((SpecRegistry)LinkRegistry.getDefault(), (TypedPropertyBag)this._link);
                if (this.labelCount() == 0 || !(this.getLabel() instanceof LinkLabel)) {
                    this.removeLabels();
                    LinkLabel linkLabel = new LinkLabel();
                    linkLabel.setModel((byte)6);
                    this.addLabel(linkLabel);
                }
                ((LinkLabel)this.getLabel()).setTextInternal(object == null ? "" : object.toString());
                this.getLabel().setTextColor(this._link.getColor());
            } else {
                this.removeLabels();
            }
        }
    }

    private void updateColor() {
        if (this._link != null) {
            this.setLineColor(this._link.getColor());
            if (this.labelCount() > 0) {
                this.getLabel().setTextColor(this._link.getColor());
            }
        }
    }

    private void updateLineType() {
        if (this._link != null) {
            this.setLineType(dA.A((int)this._link.getThickness(), (byte)((byte)this._link.getStyle())));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("displayValue".equals(propertyChangeEvent.getPropertyName()) || "value".equals(propertyChangeEvent.getPropertyName())) {
            MaltegoLink maltegoLink = (MaltegoLink)propertyChangeEvent.getSource();
            assert (this._link == maltegoLink);
            this.update();
            this.repaint();
        }
    }

    @Override
    public void showLabelsChanged() {
        this.updateText();
        this.repaint();
    }

    protected void paintBends(Graphics2D graphics2D) {
    }

    protected void paintHighlightedBends(Graphics2D graphics2D) {
    }

    protected void paintPorts(Graphics2D graphics2D) {
    }

    private class LinkLabel
    extends EA
    implements LabelEditMode.EditableLabel {
        boolean isInitilized = false;

        @Override
        public boolean canEdit() {
            return LinkEdgeRealizer.this._link == null ? true : !this.getValueProperty().isReadonly();
        }

        public void setText(String string) {
            if (this.isInitilized) {
                PropertyDescriptor propertyDescriptor;
                this.setTextInternal(string);
                if (LinkEdgeRealizer.this._link != null && (propertyDescriptor = this.getValueProperty()) != null) {
                    Object object = Converter.convertFrom((String)string, (Class)propertyDescriptor.getType());
                    LinkEdgeRealizer.this._link.setValue(propertyDescriptor, object);
                }
            }
        }

        private PropertyDescriptor getValueProperty() {
            return InheritanceHelper.getValueProperty((SpecRegistry)LinkRegistry.getDefault(), (TypedPropertyBag)LinkEdgeRealizer.this._link);
        }

        void setTextInternal(String string) {
            super.setText(string);
            if (!this.isInitilized) {
                this.isInitilized = true;
            }
        }

        public void setTextColor(Color color) {
            Color color2 = this.getTextColor();
            if (!color2.equals(color)) {
                super.setTextColor(color);
                this.repaint();
            }
        }
    }
}

