/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.InputReaderTask;
import org.netbeans.api.extexecution.input.LineProcessors;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.extexecution.InputOutputManager;
import org.netbeans.modules.extexecution.RerunAction;
import org.netbeans.modules.extexecution.StopAction;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class ExecutionService {
    private static final Logger LOGGER = Logger.getLogger(ExecutionService.class.getName());
    private static final Set<Process> RUNNING_PROCESSES = new HashSet<Process>();
    private static final int EXECUTOR_SHUTDOWN_SLICE = 1000;
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    private final Callable<Process> processCreator;
    private final ExecutionDescriptor descriptor;
    private final String originalDisplayName;

    private ExecutionService(Callable<Process> processCreator, String displayName, ExecutionDescriptor descriptor) {
        this.processCreator = processCreator;
        this.originalDisplayName = displayName;
        this.descriptor = descriptor;
    }

    @NonNull
    public static ExecutionService newService(@NonNull Callable<Process> processCreator, @NonNull ExecutionDescriptor descriptor, @NonNull String displayName) {
        return new ExecutionService(processCreator, displayName, descriptor);
    }

    @NonNull
    public Future<Integer> run() {
        return this.run(null);
    }

    private Future<Integer> run(InputOutput required) {
        final InputOutputManager.InputOutputData ioData = this.getInputOutput(required);
        String displayName = ioData.getDisplayName();
        ProgressCancellable cancellable = this.descriptor.isControllable() ? new ProgressCancellable() : null;
        final ProgressHandle handle = this.createProgressHandle(ioData.getInputOutput(), displayName, cancellable);
        InputOutput io = ioData.getInputOutput();
        final OutputWriter out = io.getOut();
        final OutputWriter err = io.getErr();
        final Reader in = io.getIn();
        final CountDownLatch finishedLatch = new CountDownLatch(1);
        class ExecutedHolder {
            private boolean executed = false;

            ExecutedHolder() {
            }

            static /* synthetic */ boolean access$302(ExecutedHolder x0, boolean x1) {
                x0.executed = x1;
                return x0.executed;
            }
        }
        final ExecutedHolder executed = new ExecutedHolder();
        Callable<Integer> callable = new Callable<Integer>(){
            {
            }

            /*
             * Exception decompiling
             */
            @Override
            public Integer call() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        final FutureTask<Integer> current = new FutureTask<Integer>((Callable)callable){
            {
                super(x0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean ret = super.cancel(mayInterruptIfRunning);
                if (executed.executed) return ret;
                ExecutionService.this.cleanup(handle, ioData);
                Class<InputOutputManager> clazz = InputOutputManager.class;
                synchronized (InputOutputManager.class) {
                    if (ioData.getInputOutput() == ExecutionService.this.descriptor.getInputOutput()) return ret;
                    InputOutputManager.addInputOutput(ioData);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return ret;
                }
            }

            @Override
            protected void setException(Throwable t) {
                if (t instanceof WrappedException) {
                    super.setException(((WrappedException)t).getCause());
                } else {
                    super.setException(t);
                }
            }
        };
        final StopAction workingStopAction = ioData.getStopAction();
        final RerunAction workingRerunAction = ioData.getRerunAction();
        Mutex.EVENT.readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractAction abstractAction;
                if (workingStopAction != null) {
                    abstractAction = workingStopAction;
                    synchronized (abstractAction) {
                        workingStopAction.setTask(current);
                        workingStopAction.setEnabled(true);
                    }
                }
                if (workingRerunAction != null) {
                    abstractAction = workingRerunAction;
                    synchronized (abstractAction) {
                        workingRerunAction.setExecutionService(ExecutionService.this);
                        workingRerunAction.setRerunCondition(ExecutionService.this.descriptor.getRerunCondition());
                        workingRerunAction.setEnabled(false);
                    }
                }
            }
        });
        if (cancellable != null) {
            cancellable.setTask((Future<Integer>)current);
        }
        EXECUTOR_SERVICE.execute(current);
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputOutputManager.InputOutputData getInputOutput(InputOutput required) {
        InputOutputManager.InputOutputData result = null;
        Class<InputOutputManager> clazz = InputOutputManager.class;
        synchronized (InputOutputManager.class) {
            InputOutput io = this.descriptor.getInputOutput();
            if (io != null) {
                result = new InputOutputManager.InputOutputData(io, this.originalDisplayName, null, null, null);
            }
            if (result == null) {
                result = InputOutputManager.getInputOutput(required);
            }
            if (result == null) {
                result = InputOutputManager.getInputOutput(this.originalDisplayName, this.descriptor.isControllable(), this.descriptor.getOptionsPath());
            }
            if (result == null) {
                result = InputOutputManager.createInputOutput(this.originalDisplayName, this.descriptor.isControllable(), this.descriptor.getOptionsPath());
            }
            this.configureInputOutput(result.getInputOutput());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    private void configureInputOutput(InputOutput inputOutput) {
        if (inputOutput == InputOutput.NULL) {
            return;
        }
        if (this.descriptor.getInputOutput() == null || !this.descriptor.noReset()) {
            try {
                inputOutput.getOut().reset();
            }
            catch (IOException exc) {
                LOGGER.log(Level.INFO, null, exc);
            }
            inputOutput.setErrSeparated(false);
        }
        if (this.descriptor.isFrontWindow()) {
            inputOutput.select();
        }
        inputOutput.setInputVisible(this.descriptor.isInputVisible());
    }

    private ProgressHandle createProgressHandle(InputOutput inputOutput, String displayName, Cancellable cancellable) {
        if (!this.descriptor.showProgress() && !this.descriptor.showSuspended()) {
            return null;
        }
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)displayName, (Cancellable)cancellable, (Action)new ProgressAction(inputOutput));
        handle.setInitialDelay(0);
        handle.start();
        handle.switchToIndeterminate();
        if (this.descriptor.showSuspended()) {
            handle.suspend(NbBundle.getMessage(ExecutionService.class, (String)"Running"));
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(List<InputReaderTask> tasks, final ExecutorService processingExecutor, ProgressHandle progressHandle, InputOutputManager.InputOutputData inputOutputData, boolean managed) {
        boolean interrupted = false;
        if (processingExecutor != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        processingExecutor.shutdown();
                        return null;
                    }
                });
                for (InputReaderTask cancellable : tasks) {
                    cancellable.cancel();
                }
                while (!processingExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                    LOGGER.log(Level.INFO, "Awaiting processing finish");
                }
            }
            catch (InterruptedException ex) {
                interrupted = true;
            }
        }
        this.cleanup(progressHandle, inputOutputData);
        Class<InputOutputManager> clazz = InputOutputManager.class;
        synchronized (InputOutputManager.class) {
            if (managed) {
                InputOutputManager.addInputOutput(inputOutputData);
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return;
        }
    }

    private void cleanup(final ProgressHandle progressHandle, final InputOutputManager.InputOutputData inputOutputData) {
        Runnable ui = new Runnable(){

            @Override
            public void run() {
                if (inputOutputData.getStopAction() != null) {
                    inputOutputData.getStopAction().setEnabled(false);
                }
                if (inputOutputData.getRerunAction() != null) {
                    inputOutputData.getRerunAction().setEnabled(true);
                }
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
        };
        Mutex.EVENT.readAccess(ui);
    }

    private InputProcessor createOutProcessor(OutputWriter writer) {
        ExecutionDescriptor.LineConvertorFactory convertorFactory = this.descriptor.getOutConvertorFactory();
        InputProcessor outProcessor = null;
        outProcessor = this.descriptor.isOutLineBased() ? InputProcessors.bridge(LineProcessors.printing(writer, convertorFactory != null ? convertorFactory.newLineConvertor() : null, true)) : InputProcessors.printing(writer, convertorFactory != null ? convertorFactory.newLineConvertor() : null, true);
        ExecutionDescriptor.InputProcessorFactory descriptorOutFactory = this.descriptor.getOutProcessorFactory();
        if (descriptorOutFactory != null) {
            outProcessor = descriptorOutFactory.newInputProcessor(outProcessor);
        }
        return outProcessor;
    }

    private InputProcessor createErrProcessor(OutputWriter writer) {
        ExecutionDescriptor.LineConvertorFactory convertorFactory = this.descriptor.getErrConvertorFactory();
        InputProcessor errProcessor = null;
        errProcessor = this.descriptor.isErrLineBased() ? InputProcessors.bridge(LineProcessors.printing(writer, convertorFactory != null ? convertorFactory.newLineConvertor() : null, false)) : InputProcessors.printing(writer, convertorFactory != null ? convertorFactory.newLineConvertor() : null, false);
        ExecutionDescriptor.InputProcessorFactory descriptorErrFactory = this.descriptor.getErrProcessorFactory();
        if (descriptorErrFactory != null) {
            errProcessor = descriptorErrFactory.newInputProcessor(errProcessor);
        }
        return errProcessor;
    }

    private InputProcessor createInProcessor(OutputStream os) {
        return InputProcessors.copying(new OutputStreamWriter(os));
    }

    static /* synthetic */ Callable access$500(ExecutionService x0) {
        return x0.processCreator;
    }

    static /* synthetic */ InputProcessor access$600(ExecutionService x0, OutputWriter x1) {
        return x0.createOutProcessor(x1);
    }

    static /* synthetic */ InputProcessor access$700(ExecutionService x0, OutputWriter x1) {
        return x0.createErrProcessor(x1);
    }

    static /* synthetic */ InputProcessor access$800(ExecutionService x0, OutputStream x1) {
        return x0.createInProcessor(x1);
    }

    static /* synthetic */ Logger access$900() {
        return LOGGER;
    }

    static /* synthetic */ void access$1000(ExecutionService x0, List x1, ExecutorService x2, ProgressHandle x3, InputOutputManager.InputOutputData x4, boolean x5) {
        x0.cleanup(x1, x2, x3, x4, x5);
    }

    static {
        RerunAction.Accessor.setDefault(new RerunAction.Accessor(){

            @Override
            public Future<Integer> run(ExecutionService service, InputOutput required) {
                return service.run(required);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EXECUTOR_SERVICE.shutdown();
                Set set = RUNNING_PROCESSES;
                synchronized (set) {
                    for (Process process : RUNNING_PROCESSES) {
                        process.destroy();
                    }
                }
            }
        });
    }

    private static class WrappedException
    extends Exception {
        public WrappedException(Throwable cause) {
            super(cause);
        }
    }

    private static class ProgressAction
    extends AbstractAction {
        private final InputOutput io;

        public ProgressAction(InputOutput io) {
            this.io = io;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.io.select();
        }
    }

    private static class ProgressCancellable
    implements Cancellable {
        private Future<Integer> task;

        public synchronized void setTask(Future<Integer> task) {
            this.task = task;
        }

        public synchronized boolean cancel() {
            if (this.task != null) {
                this.task.cancel(true);
            }
            return true;
        }
    }
}

