/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.main;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.startlevel.StartLevel;

public class AutoProcessor {
    public static final String AUTO_DEPLOY_DIR_PROPERY = "felix.auto.deploy.dir";
    public static final String AUTO_DEPLOY_DIR_VALUE = "bundle";
    public static final String AUTO_DEPLOY_ACTION_PROPERY = "felix.auto.deploy.action";
    public static final String AUTO_DEPLOY_INSTALL_VALUE = "install";
    public static final String AUTO_DEPLOY_START_VALUE = "start";
    public static final String AUTO_DEPLOY_UPDATE_VALUE = "update";
    public static final String AUTO_DEPLOY_UNINSTALL_VALUE = "uninstall";
    public static final String AUTO_INSTALL_PROP = "felix.auto.install";
    public static final String AUTO_START_PROP = "felix.auto.start";
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;

    public static void process(Map configMap, BundleContext context) {
        configMap = configMap == null ? new HashMap() : configMap;
        AutoProcessor.processAutoDeploy(configMap, context);
        AutoProcessor.processAutoProperties(configMap, context);
    }

    private static void processAutoDeploy(Map configMap, BundleContext context) {
        String action = (String)configMap.get(AUTO_DEPLOY_ACTION_PROPERY);
        action = action == null ? "" : action;
        ArrayList<String> actionList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(action, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim().toLowerCase();
            if (!s.equals(AUTO_DEPLOY_INSTALL_VALUE) && !s.equals(AUTO_DEPLOY_START_VALUE) && !s.equals(AUTO_DEPLOY_UPDATE_VALUE) && !s.equals(AUTO_DEPLOY_UNINSTALL_VALUE)) continue;
            actionList.add(s);
        }
        if (actionList.size() > 0) {
            int i;
            HashMap<String, Bundle> installedBundleMap = new HashMap<String, Bundle>();
            Bundle[] bundles = context.getBundles();
            for (int i2 = 0; i2 < bundles.length; ++i2) {
                installedBundleMap.put(bundles[i2].getLocation(), bundles[i2]);
            }
            String autoDir = (String)configMap.get(AUTO_DEPLOY_DIR_PROPERY);
            autoDir = autoDir == null ? AUTO_DEPLOY_DIR_VALUE : autoDir;
            Object[] files = new File(autoDir).listFiles();
            ArrayList<Object> jarList = new ArrayList<Object>();
            if (files != null) {
                Arrays.sort(files);
                for (int i3 = 0; i3 < files.length; ++i3) {
                    if (!((File)files[i3]).getName().endsWith(".jar")) continue;
                    jarList.add(files[i3]);
                }
            }
            ArrayList<Bundle> startBundleList = new ArrayList<Bundle>();
            for (i = 0; i < jarList.size(); ++i) {
                Bundle b = (Bundle)installedBundleMap.remove(((File)jarList.get(i)).toURI().toString());
                try {
                    if (b == null && actionList.contains(AUTO_DEPLOY_INSTALL_VALUE)) {
                        b = context.installBundle(((File)jarList.get(i)).toURI().toString());
                    } else if (actionList.contains(AUTO_DEPLOY_UPDATE_VALUE)) {
                        b.update();
                    }
                    if (b == null) continue;
                    startBundleList.add(b);
                    continue;
                }
                catch (BundleException ex) {
                    System.err.println("Auto-deploy install: " + (Object)((Object)ex) + (ex.getCause() != null ? " - " + ex.getCause() : ""));
                }
            }
            if (actionList.contains(AUTO_DEPLOY_UNINSTALL_VALUE)) {
                Iterator it = installedBundleMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Bundle b = (Bundle)entry.getValue();
                    if (b.getBundleId() == 0L) continue;
                    try {
                        b.uninstall();
                    }
                    catch (BundleException ex) {
                        System.err.println("Auto-deploy uninstall: " + (Object)((Object)ex) + (ex.getCause() != null ? " - " + ex.getCause() : ""));
                    }
                }
            }
            if (actionList.contains(AUTO_DEPLOY_START_VALUE)) {
                for (i = 0; i < startBundleList.size(); ++i) {
                    try {
                        if (AutoProcessor.isFragment((Bundle)startBundleList.get(i))) continue;
                        ((Bundle)startBundleList.get(i)).start();
                        continue;
                    }
                    catch (BundleException ex) {
                        System.err.println("Auto-deploy start: " + (Object)((Object)ex) + (ex.getCause() != null ? " - " + ex.getCause() : ""));
                    }
                }
            }
        }
    }

    private static void processAutoProperties(Map configMap, BundleContext context) {
        String key;
        StartLevel sl = (StartLevel)context.getService(context.getServiceReference((class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = AutoProcessor.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName()));
        Iterator i = configMap.keySet().iterator();
        while (i.hasNext()) {
            key = ((String)i.next()).toLowerCase();
            if (!key.startsWith(AUTO_INSTALL_PROP) && !key.startsWith(AUTO_START_PROP)) continue;
            int startLevel = sl.getInitialBundleStartLevel();
            if (!key.equals(AUTO_INSTALL_PROP) && !key.equals(AUTO_START_PROP)) {
                try {
                    startLevel = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid property: " + key);
                }
            }
            StringTokenizer st = new StringTokenizer((String)configMap.get(key), "\" ", true);
            String location = AutoProcessor.nextLocation(st);
            while (location != null) {
                try {
                    Bundle b = context.installBundle(location, null);
                    sl.setBundleStartLevel(b, startLevel);
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties install: " + ex + (ex.getCause() != null ? " - " + ex.getCause() : ""));
                }
                location = AutoProcessor.nextLocation(st);
            }
        }
        i = configMap.keySet().iterator();
        while (i.hasNext()) {
            key = ((String)i.next()).toLowerCase();
            if (!key.startsWith(AUTO_START_PROP)) continue;
            StringTokenizer st = new StringTokenizer((String)configMap.get(key), "\" ", true);
            String location = AutoProcessor.nextLocation(st);
            while (location != null) {
                try {
                    Bundle b = context.installBundle(location, null);
                    if (b != null) {
                        b.start();
                    }
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties start: " + ex + (ex.getCause() != null ? " - " + ex.getCause() : ""));
                }
                location = AutoProcessor.nextLocation(st);
            }
        }
    }

    private static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuffer tokBuf = new StringBuffer(10);
            String tok = null;
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuffer(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }

    private static boolean isFragment(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

