# Certipy - AD CS Attack & Enumeration Toolkit

[![PyPI version](https://img.shields.io/pypi/v/certipy-ad?v5.0.3)](https://pypi.org/project/certipy-ad/)
![Python](https://img.shields.io/badge/python-3.12+-blue.svg)
![License](https://img.shields.io/github/license/ly4k/Certipy)

**Certipy** is a powerful offensive and defensive toolkit for enumerating and abusing Active Directory Certificate Services (AD CS). It helps red teamers, penetration testers, and defenders assess AD CS misconfigurations - including full support for identifying and exploiting all known **ESC1-ESC16** attack paths.

> [!WARNING]
> Use only in environments where you have explicit authorization. Unauthorized use may be illegal.

---

## 🔍 Features

* 🔎 Discover Certificate Authorities and Templates
* 🚩 Identify misconfigurations
* 🔐 Request and forge certificates
* 🎭 Perform authentication using certificates
* 📡 Relay NTLM authentication to AD CS HTTP(S)/RPC endpoints
* 🗝️ Support for Shadow Credentials, Golden Certificates, and Certificate Mapping Attacks
* 🧰 And much more!

---

## 📚 Full Wiki & Documentation

Read the full **step-by-step usage guide**, including installation, vulnerability explanations, examples, and mitigations in the [📘 Certipy Wiki](https://github.com/ly4k/Certipy/wiki).

---

## ⚙️ Installation

See the [Installation Guide](https://github.com/ly4k/Certipy/wiki/04-%E2%80%90-Installation) for instructions on how to install Certipy.

---

## 🚀 Quick Start

See the [Quick Start Guide](https://github.com/ly4k/Certipy/wiki/05-%E2%80%90-Usage) for a quick overview of the most common commands and usage examples.

---

## 🎯 Supported AD CS Vulnerabilities

Certipy supports detection and exploitation of AD CS vulnerabilities across the full range of ESC1-ESC16.

For detailed explanations and exploitation steps, refer to the [Certipy Wiki](https://github.com/ly4k/Certipy/wiki/06-%E2%80%90-Privilege-Escalation).

---

## 📎 Resources

See the [Resources](https://github.com/ly4k/Certipy/wiki/03-%E2%80%90-Resources) for selection of key resources related to AD CS security.

---

## 🤝 Contributing

Contributions are welcome! See [CONTRIBUTING.md](CONTRIBUTING.md) for guidelines on reporting issues, improving documentation, or submitting pull requests.

---

## 🌟 Sponsors

Thanks to these generous sponsors for supporting the development of this project. Your contributions help sustain ongoing work and improvements.

<!-- sponsors --><a href="https://github.com/mxrch"><img src="https:&#x2F;&#x2F;github.com&#x2F;mxrch.png" width="60px" alt="User avatar: mxrch" /></a><!-- sponsors -->

---

## 👤 Author

Developed by [@ly4k](https://github.com/ly4k), with valuable contributions from the community.

---

## 📘 Wiki

📖 Visit the [**Certipy Wiki**](https://github.com/ly4k/Certipy/wiki) for detailed documentation, usage examples, ESC vulnerability breakdowns, and mitigation advice.
