from typing import Dict, Any

import pytest

from checkov.common.bridgecrew.bc_source import SourceType
from checkov.common.bridgecrew.platform_integration import BcPlatformIntegration


@pytest.fixture()
def mock_bc_integration() -> BcPlatformIntegration:
    bc_integration = BcPlatformIntegration()
    bc_integration.bc_api_key = "abcd1234-abcd-1234-abcd-1234abcd1234"
    bc_integration.bc_api_url = "https://www.bridgecrew.cloud"
    bc_integration.setup_bridgecrew_credentials(
        repo_id="bridgecrewio/checkov",
        skip_fixes=True,
        skip_download=True,
        source=SourceType("Github", False),
        source_version="1.0",
        repo_branch="master",
        bc_api_url="https://www.bridgecrew.cloud"
    )
    return bc_integration


@pytest.fixture()
def package_scan_result() -> Dict[str, Any]:
    return {
        "repository": "/abs_path/to/app/requirements.txt",
        "passed": True,
        "packages": [
            {"type": "python", "name": "django", "version": "1.2", "path": "/abs_path/to/app/requirements.txt"}
        ],
        "complianceIssues": None,
        "complianceDistribution": {"critical": 0, "high": 0, "medium": 0, "low": 0, "total": 0},
        "vulnerabilities": [
            {
                "id": "CVE-2019-19844",
                "status": "fixed in 3.0.1, 2.2.9, 1.11.27",
                "cvss": 9.8,
                "vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H",
                "description": "Django before 1.11.27, 2.x before 2.2.9, and 3.x before 3.0.1 allows account takeover.",
                "severity": "critical",
                "packageName": "django",
                "packageVersion": "1.2",
                "link": "https://nvd.nist.gov/vuln/detail/CVE-2019-19844",
                "riskFactors": ["Critical severity", "Has fix", "Attack complexity: low", "Attack vector: network"],
                "impactedVersions": ["\u003c1.11.27"],
                "publishedDate": "2019-12-18T20:15:00+01:00",
                "discoveredDate": "2019-12-18T19:15:00Z",
                "fixDate": "2019-12-18T20:15:00+01:00",
            }
        ],
        "vulnerabilityDistribution": {"critical": 1, "high": 0, "medium": 0, "low": 0, "total": 0},
    }


@pytest.fixture()
def docker_image_scan_result() -> Dict[str, Any]:
    return {
        "results": [
            {
                "id": "sha256:e70f7611f4d093d5f73026d23f7ab612aa1794abfb210ef1c549b225380d053b",
                "distro": "Debian GNU/Linux 11 (bullseye)",
                "distroRelease": "bullseye",
                "collections": ["All"],
                "packages": [
                    {"type": "os", "name": "mawk", "version": "1.3.4.20200120-2", "licenses": ["GPL-2"]},
                    {"type": "os", "name": "gzip", "version": "1.10-4", "licenses": ["GPL-3+"]},
                ],
                "compliances": [
                    {
                        "id": 41,
                        "title": "(CIS_Docker_v1.2.0 - 4.1) Image should be created with a non-root user",
                        "severity": "high",
                        "description": "It is a good practice to run the container as a non-root user, if possible. "
                        "Though user\nnamespace mapping is now available, if a user is already defined in "
                        "the container image, the\ncontainer is run as that user by default and specific"
                        " user namespace remapping is not\nrequired",
                    }
                ],
                "complianceDistribution": {"critical": 0, "high": 1, "medium": 0, "low": 0, "total": 1},
                "complianceScanPassed": True,
                "vulnerabilities": [
                    {
                        "id": "CVE-2022-23990",
                        "status": "fixed in 2.2.10-2+deb11u1",
                        "cvss": 9.8,
                        "vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H",
                        "description": "Expat (aka libexpat) before 2.4.4 has an integer overflow in the doProlog "
                        "function.",
                        "severity": "critical",
                        "packageName": "expat",
                        "packageVersion": "2.2.10-2",
                        "link": "https://security-tracker.debian.org/tracker/CVE-2022-23990",
                        "riskFactors": [
                            "Attack complexity: low",
                            "Attack vector: network",
                            "Critical severity",
                            "Has fix",
                            "Recent vulnerability",
                        ],
                        "impactedVersions": ["<2.2.10-2+deb11u1"],
                        "publishedDate": "2022-01-26T21:15:00+02:00",
                        "discoveredDate": "2022-02-13T11:57:08+02:00",
                        "fixDate": "2022-01-26T21:15:00+02:00",
                    },
                    {
                        "id": "CVE-2022-23852",
                        "status": "fixed in 2.2.10-2+deb11u1",
                        "cvss": 9.8,
                        "vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H",
                        "description": "Expat (aka libexpat) before 2.4.4 has a signed integer overflow in XML_GetBuffer, "
                        "for configurations with a nonzero XML_CONTEXT_BYTES.",
                        "severity": "critical",
                        "packageName": "expat",
                        "packageVersion": "2.2.10-2",
                        "link": "https://security-tracker.debian.org/tracker/CVE-2022-23852",
                        "riskFactors": [
                            "Attack complexity: low",
                            "Attack vector: network",
                            "Critical severity",
                            "Has fix",
                            "Recent vulnerability",
                        ],
                        "impactedVersions": ["<2.2.10-2+deb11u1"],
                        "publishedDate": "2022-01-24T04:15:00+02:00",
                        "discoveredDate": "2022-02-13T11:57:08+02:00",
                        "fixDate": "2022-01-24T04:15:00+02:00",
                    },
                ],
                "vulnerabilityDistribution": {"critical": 5, "high": 5, "medium": 0, "low": 14, "total": 24},
                "vulnerabilityScanPassed": True,
            }
        ]
    }
