# CHIPSEC: Platform Security Assessment Framework
# Copyright (c) 2010-2016, Intel Corporation
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; Version 2.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# Contact information:
# chipsec@intel.com
#


"""
Base for HAL Components
"""
from enum import Enum
import chipsec.library.logger
from chipsec.library.exceptions import UnimplementedAPIError


class HALBase:
    class MfgIds(Enum):
        Intel = ['GenuineIntel']
        AMD = ['AuthenticAMD', 'AMD ISBETTER']
        Any = ['Any']

    def __init__(self, cs):
        self.cs = cs
        self.logger = chipsec.library.logger.logger()

    def __getattr__(self, name):
        raise UnimplementedAPIError(f'No function with the name {name}')
