# -*- coding: utf-8 -*-

# CHIPSEC: Platform Security Assessment Framework
# Copyright (c) 2010-2021, Intel Corporation
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; Version 2.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# Contact information:
# chipsec@intel.com
#


"""
PCI Vendor & Device ID data.

.. note:: 
    THIS FILE WAS GENERATED

    Auto generated from:

    https://github.com/pciutils/pciids

"""

VENDORS = {
    0x0001: "SafeNet (wrong ID)",
    0x0010: "Allied Telesis, Inc (Wrong ID)",
    0x0014: "Loongson Technology LLC",
    0x001C: "PEAK-System Technik GmbH",
    0x003D: "Lockheed Martin-Marietta Corp",
    0x0059: "Tiger Jet Network Inc. (Wrong ID)",
    0x0070: "Hauppauge computer works Inc.",
    0x0071: "Nebula Electronics Ltd.",
    0x0095: "Silicon Image, Inc. (Wrong ID)",
    0x00A7: "Teles AG (Wrong ID)",
    0x0100: "nCipher Security",
    0x0123: "General Dynamics",
    0x0128: "Dell (wrong ID)",
    0x018A: "LevelOne",
    0x01DE: "Oxide Computer Company",
    0x0200: "Dell (wrong ID)",
    0x021B: "Compaq Computer Corporation",
    0x025E: "Solidigm",
    0x0270: "Hauppauge computer works Inc. (Wrong ID)",
    0x0291: "Davicom Semiconductor, Inc. (Wrong ID)",
    0x02AC: "SpeedStream",
    0x02E0: "XFX Pine Group Inc. (Wrong ID)",
    0x0303: "Hewlett-Packard Company (Wrong ID)",
    0x0308: "ZyXEL Communications Corporation (Wrong ID)",
    0x0315: "SK-Electronics Co., Ltd.",
    0x0357: "TTTech Computertechnik AG (Wrong ID)",
    0x0432: "SCM Microsystems, Inc.",
    0x0497: "Dell Inc. (wrong ID)",
    0x060E: "Lightelligence",
    0x0675: "Dynalink",
    0x0721: "Sapphire, Inc.",
    0x0731: "Jingjia Microelectronics Co Ltd",
    0x0777: "Ubiquiti Networks, Inc.",
    0x0795: "Wired Inc.",
    0x07D1: "D-Link System Inc",
    0x0824: "T1042 [Freescale]",
    0x0925: "VIA Technologies, Inc. (Wrong ID)",
    0x0A89: "BREA Technologies Inc",
    0x0B0B: "Rhino Equipment Corp.",
    0x0BAE: "Bachmann electronic GmbH",
    0x0CCD: "Preferred Networks, Inc.",
    0x0E11: "Compaq Computer Corporation",
    0x0E55: "HaSoTec GmbH",
    0x0EAC: "SHF Communication Technologies AG",
    0x0F62: "Acrox Technologies Co., Ltd.",
    0x1000: "Broadcom / LSI",
    0x1001: "Kolter Electronic",
    0x1002: "Advanced Micro Devices, Inc. [AMD/ATI]",
    0x1003: "ULSI Systems",
    0x1004: "VLSI Technology Inc",
    0x1005: "Avance Logic Inc. [ALI]",
    0x1006: "Reply Group",
    0x1007: "NetFrame Systems Inc",
    0x1008: "Epson",
    0x100A: "Phoenix Technologies",
    0x100B: "National Semiconductor Corporation",
    0x100C: "Tseng Labs Inc",
    0x100D: "AST Research Inc",
    0x100E: "Weitek",
    0x1010: "Video Logic, Ltd.",
    0x1011: "Digital Equipment Corporation",
    0x1012: "Micronics Computers Inc",
    0x1013: "Cirrus Logic",
    0x1014: "IBM",
    0x1015: "LSI Logic Corp of Canada",
    0x1016: "ICL Personal Systems",
    0x1017: "SPEA Software AG",
    0x1018: "Unisys Systems",
    0x1019: "Elitegroup Computer Systems",
    0x101A: "AT&T GIS (NCR)",
    0x101B: "Vitesse Semiconductor",
    0x101C: "Western Digital",
    0x101D: "Maxim Integrated Products",
    0x101E: "American Megatrends Inc.",
    0x101F: "PictureTel",
    0x1020: "Hitachi Computer Products",
    0x1021: "OKI Electric Industry Co. Ltd.",
    0x1022: "Advanced Micro Devices, Inc. [AMD]",
    0x1023: "Trident Microsystems",
    0x1024: "Beijing Dajia Internet Information Technology Co.",
    0x1025: "Acer Incorporated [ALI]",
    0x1028: "Dell",
    0x1029: "Siemens Nixdorf IS",
    0x102A: "LSI Logic",
    0x102B: "Matrox Electronics Systems Ltd.",
    0x102C: "Chips and Technologies",
    0x102D: "Wyse Technology Inc.",
    0x102E: "Olivetti Advanced Technology",
    0x102F: "Toshiba America",
    0x1030: "TMC Research",
    0x1031: "Miro Computer Products AG",
    0x1032: "Compaq",
    0x1033: "NEC Corporation",
    0x1034: "Framatome Connectors USA Inc.",
    0x1035: "Comp. & Comm. Research Lab",
    0x1036: "Future Domain Corp.",
    0x1037: "Hitachi Micro Systems",
    0x1038: "AMP, Inc",
    0x1039: "Silicon Integrated Systems [SiS]",
    0x103A: "Seiko Epson Corporation",
    0x103B: "Tatung Corp. Of America",
    0x103C: "Hewlett-Packard Company",
    0x103E: "Solliday Engineering",
    0x103F: "Synopsys/Logic Modeling Group",
    0x1040: "Accelgraphics Inc.",
    0x1041: "Computrend",
    0x1042: "Micron",
    0x1043: "ASUSTeK Computer Inc.",
    0x1044: "Adaptec (formerly DPT)",
    0x1045: "OPTi Inc.",
    0x1046: "IPC Corporation, Ltd.",
    0x1047: "Genoa Systems Corp",
    0x1048: "Elsa AG",
    0x1049: "Fountain Technologies, Inc.",
    0x104A: "STMicroelectronics",
    0x104B: "BusLogic",
    0x104C: "Texas Instruments",
    0x104D: "Sony Corporation",
    0x104E: "Oak Technology, Inc",
    0x104F: "Co-time Computer Ltd",
    0x1050: "Winbond Electronics Corp",
    0x1051: "Anigma, Inc.",
    0x1052: "?Young Micro Systems",
    0x1053: "Young Micro Systems",
    0x1054: "Hitachi, Ltd",
    0x1055: "Microchip Technology / SMSC",
    0x1056: "ICL",
    0x1057: "Motorola",
    0x1058: "Electronics & Telecommunications RSH",
    0x1059: "Kontron",
    0x105A: "Promise Technology, Inc.",
    0x105B: "Foxconn International, Inc.",
    0x105C: "Wipro Infotech Limited",
    0x105D: "Number 9 Computer Company",
    0x105E: "Vtech Computers Ltd",
    0x105F: "Infotronic America Inc",
    0x1060: "United Microelectronics [UMC]",
    0x1061: "I.I.T.",
    0x1062: "Maspar Computer Corp",
    0x1063: "Ocean Office Automation",
    0x1064: "Alcatel",
    0x1065: "Texas Microsystems",
    0x1066: "PicoPower Technology",
    0x1067: "Mitsubishi Electric",
    0x1068: "Diversified Technology",
    0x1069: "Mylex Corporation",
    0x106A: "Aten Research Inc",
    0x106B: "Apple Inc.",
    0x106C: "Hynix Semiconductor",
    0x106D: "Sequent Computer Systems",
    0x106E: "DFI, Inc",
    0x106F: "City Gate Development Ltd",
    0x1070: "Daewoo Telecom Ltd",
    0x1071: "Mitac",
    0x1072: "GIT Co Ltd",
    0x1073: "Yamaha Corporation",
    0x1074: "NexGen Microsystems",
    0x1075: "Advanced Integrations Research",
    0x1076: "Chaintech Computer Co. Ltd",
    0x1077: "QLogic Corp.",
    0x1078: "Cyrix Corporation",
    0x1079: "I-Bus",
    0x107A: "NetWorth",
    0x107B: "Gateway, Inc.",
    0x107C: "LG Electronics [Lucky Goldstar Co. Ltd]",
    0x107D: "LeadTek Research Inc.",
    0x107E: "Interphase Corporation",
    0x107F: "Data Technology Corporation",
    0x1080: "Contaq Microsystems",
    0x1081: "Supermac Technology",
    0x1082: "EFA Corporation of America",
    0x1083: "Forex Computer Corporation",
    0x1084: "Parador",
    0x1086: "J. Bond Computer Systems",
    0x1087: "Cache Computer",
    0x1088: "Microcomputer Systems (M) Son",
    0x1089: "Data General Corporation",
    0x108A: "SBS Technologies",
    0x108C: "Oakleigh Systems Inc.",
    0x108D: "Olicom",
    0x108E: "Oracle/SUN",
    0x108F: "Systemsoft",
    0x1090: "Compro Computer Services, Inc.",
    0x1091: "Intergraph Corporation",
    0x1092: "Diamond Multimedia Systems",
    0x1093: "National Instruments",
    0x1094: "First International Computers [FIC]",
    0x1095: "Silicon Image, Inc.",
    0x1096: "Alacron",
    0x1097: "Appian Technology",
    0x1098: "Quantum Designs (H.K.) Ltd",
    0x1099: "Samsung Electronics Co., Ltd",
    0x109A: "Packard Bell",
    0x109B: "Gemlight Computer Ltd.",
    0x109C: "Megachips Corporation",
    0x109D: "Zida Technologies Ltd.",
    0x109E: "Brooktree Corporation",
    0x109F: "Trigem Computer Inc.",
    0x10A0: "Meidensha Corporation",
    0x10A1: "Juko Electronics Ind. Co. Ltd",
    0x10A2: "Quantum Corporation",
    0x10A3: "Everex Systems Inc",
    0x10A4: "Globe Manufacturing Sales",
    0x10A5: "Smart Link Ltd.",
    0x10A6: "Informtech Industrial Ltd.",
    0x10A7: "Benchmarq Microelectronics",
    0x10A8: "Sierra Semiconductor",
    0x10A9: "Silicon Graphics Intl. Corp.",
    0x10AA: "ACC Microelectronics",
    0x10AB: "Digicom",
    0x10AC: "Honeywell IAC",
    0x10AD: "Symphony Labs",
    0x10AE: "Cornerstone Technology",
    0x10AF: "Micro Computer Systems Inc",
    0x10B0: "CardExpert Technology",
    0x10B1: "Cabletron Systems Inc",
    0x10B2: "Raytheon Company",
    0x10B3: "Databook Inc",
    0x10B4: "STB Systems Inc",
    0x10B5: "PLX Technology, Inc.",
    0x10B6: "Madge Networks",
    0x10B7: "3Com Corporation",
    0x10B8: "Standard Microsystems Corp [SMC]",
    0x10B9: "ULi Electronics Inc.",
    0x10BA: "Mitsubishi Electric Corp.",
    0x10BB: "Dapha Electronics Corporation",
    0x10BC: "Advanced Logic Research",
    0x10BD: "Surecom Technology",
    0x10BE: "Tseng Labs International Co.",
    0x10BF: "Most Inc",
    0x10C0: "Boca Research Inc.",
    0x10C1: "ICM Co., Ltd.",
    0x10C2: "Auspex Systems Inc.",
    0x10C3: "Samsung Semiconductors, Inc.",
    0x10C4: "Award Software International Inc.",
    0x10C5: "Xerox Corporation",
    0x10C6: "Rambus Inc.",
    0x10C7: "Media Vision",
    0x10C8: "Neomagic Corporation",
    0x10C9: "Dataexpert Corporation",
    0x10CA: "Fujitsu Microelectr., Inc.",
    0x10CB: "Omron Corporation",
    0x10CC: "Mai Logic Incorporated",
    0x10CD: "Advanced System Products, Inc",
    0x10CE: "Radius",
    0x10CF: "Fujitsu Limited.",
    0x10D1: "FuturePlus Systems Corp.",
    0x10D2: "Molex Incorporated",
    0x10D3: "Jabil Circuit Inc",
    0x10D4: "Hualon Microelectronics",
    0x10D5: "Autologic Inc.",
    0x10D6: "Cetia",
    0x10D7: "BCM Advanced Research",
    0x10D8: "Advanced Peripherals Labs",
    0x10D9: "Macronix, Inc. [MXIC]",
    0x10DA: "Compaq IPG-Austin",
    0x10DB: "Rohm LSI Systems, Inc.",
    0x10DC: "CERN/ECP/EDU",
    0x10DD: "Evans & Sutherland",
    0x10DE: "NVIDIA Corporation",
    0x10DF: "Emulex Corporation",
    0x10E0: "Integrated Micro Solutions Inc.",
    0x10E1: "Tekram Technology Co.,Ltd.",
    0x10E2: "Aptix Corporation",
    0x10E3: "Tundra Semiconductor Corp.",
    0x10E4: "Tandem Computers",
    0x10E5: "Micro Industries Corporation",
    0x10E6: "Gainbery Computer Products Inc.",
    0x10E7: "Vadem",
    0x10E8: "Applied Micro Circuits Corp.",
    0x10E9: "Alps Electric Co., Ltd.",
    0x10EA: "Integraphics",
    0x10EB: "Artists Graphics",
    0x10EC: "Realtek Semiconductor Co., Ltd.",
    0x10ED: "Ascii Corporation",
    0x10EE: "Xilinx Corporation",
    0x10EF: "Racore Computer Products, Inc.",
    0x10F0: "Peritek Corporation",
    0x10F1: "Tyan Computer",
    0x10F2: "Achme Computer, Inc.",
    0x10F3: "Alaris, Inc.",
    0x10F4: "S-MOS Systems, Inc.",
    0x10F5: "NKK Corporation",
    0x10F6: "Creative Electronic Systems SA",
    0x10F7: "Matsushita Electric Industrial Co., Ltd.",
    0x10F8: "Altos India Ltd",
    0x10F9: "PC Direct",
    0x10FA: "Truevision",
    0x10FB: "Thesys Gesellschaft fuer Mikroelektronik mbH",
    0x10FC: "I-O Data Device, Inc.",
    0x10FD: "Soyo Computer, Inc",
    0x10FE: "Fast Multimedia AG",
    0x10FF: "NCube",
    0x1100: "Jazz Multimedia",
    0x1101: "Initio Corporation",
    0x1102: "Creative Labs",
    0x1103: "HighPoint Technologies, Inc.",
    0x1104: "RasterOps Corp.",
    0x1105: "Sigma Designs, Inc.",
    0x1106: "VIA Technologies, Inc.",
    0x1107: "Stratus Computers",
    0x1108: "Proteon, Inc.",
    0x1109: "Cogent Data Technologies, Inc.",
    0x110A: "Siemens AG",
    0x110B: "Chromatic Research Inc.",
    0x110C: "Mini-Max Technology, Inc.",
    0x110D: "Znyx Advanced Systems",
    0x110E: "CPU Technology",
    0x110F: "Ross Technology",
    0x1110: "Powerhouse Systems",
    0x1111: "Santa Cruz Operation",
    0x1112: "Osicom Technologies Inc",
    0x1113: "Accton Technology Corporation",
    0x1114: "Atmel Corporation",
    0x1115: "3D Labs",
    0x1116: "Data Translation",
    0x1117: "Datacube, Inc",
    0x1118: "Berg Electronics",
    0x1119: "ICP Vortex Computersysteme GmbH",
    0x111A: "Efficient Networks, Inc",
    0x111B: "Teledyne Electronic Systems",
    0x111C: "Tricord Systems Inc.",
    0x111D: "Microsemi / PMC / IDT",
    0x111E: "Eldec",
    0x111F: "Precision Digital Images",
    0x1120: "Dell EMC",
    0x1121: "Zilog",
    0x1122: "Multi-tech Systems, Inc.",
    0x1123: "Excellent Design, Inc.",
    0x1124: "Leutron Vision AG",
    0x1125: "Eurocore",
    0x1126: "Vigra",
    0x1127: "FORE Systems Inc",
    0x1129: "Firmworks",
    0x112A: "Hermes Electronics Company, Ltd.",
    0x112B: "Heidelberger Druckmaschinen AG",
    0x112C: "Zenith Data Systems",
    0x112D: "Ravicad",
    0x112E: "Infomedia Microelectronics Inc.",
    0x112F: "Dalsa Inc.",
    0x1130: "Computervision",
    0x1131: "Philips Semiconductors",
    0x1132: "Mitel Corp.",
    0x1133: "Dialogic Corporation",
    0x1134: "Mercury Computer Systems",
    0x1135: "FUJIFILM Business Innovation Corp.",
    0x1136: "Momentum Data Systems",
    0x1137: "Cisco Systems Inc",
    0x1138: "Ziatech Corporation",
    0x1139: "Dynamic Pictures, Inc",
    0x113A: "FWB Inc",
    0x113B: "Network Computing Devices",
    0x113C: "Cyclone Microsystems, Inc.",
    0x113D: "Leading Edge Products Inc",
    0x113E: "Sanyo Electric Co - Computer Engineering Dept",
    0x113F: "Equinox Systems, Inc.",
    0x1140: "Intervoice Inc",
    0x1141: "Crest Microsystem Inc",
    0x1142: "Alliance Semiconductor Corporation",
    0x1143: "NetPower, Inc",
    0x1144: "Cincinnati Milacron",
    0x1145: "Workbit Corporation",
    0x1146: "Force Computers",
    0x1147: "Interface Corp",
    0x1148: "SysKonnect",
    0x1149: "Win System Corporation",
    0x114A: "VMIC",
    0x114B: "Canopus Co., Ltd",
    0x114C: "Annabooks",
    0x114D: "IC Corporation",
    0x114E: "Nikon Systems Inc",
    0x114F: "Digi International",
    0x1150: "Thinking Machines Corp",
    0x1151: "JAE Electronics Inc.",
    0x1152: "Megatek",
    0x1153: "Land Win Electronic Corp",
    0x1154: "Melco Inc",
    0x1155: "Pine Technology Ltd",
    0x1156: "Periscope Engineering",
    0x1157: "Avsys Corporation",
    0x1158: "Voarx R & D Inc",
    0x1159: "MuTech Corporation",
    0x115A: "Harlequin Ltd",
    0x115B: "Parallax Graphics",
    0x115C: "Photron Ltd.",
    0x115D: "Xircom",
    0x115E: "Peer Protocols Inc",
    0x115F: "Maxtor Corporation",
    0x1160: "Megasoft Inc",
    0x1161: "PFU Limited",
    0x1162: "OA Laboratory Co Ltd",
    0x1163: "Rendition",
    0x1164: "Advanced Peripherals Technologies",
    0x1165: "Imagraph Corporation",
    0x1166: "Broadcom",
    0x1167: "Mutoh Industries Inc",
    0x1168: "Thine Electronics Inc",
    0x1169: "Centre for Development of Advanced Computing",
    0x116A: "Luminex Software, Inc.",
    0x116B: "Connectware Inc",
    0x116C: "Intelligent Resources Integrated Systems",
    0x116D: "Martin-Marietta",
    0x116E: "Electronics for Imaging",
    0x116F: "Workstation Technology",
    0x1170: "Inventec Corporation",
    0x1171: "Loughborough Sound Images Plc",
    0x1172: "Altera Corporation",
    0x1173: "Adobe Systems, Inc",
    0x1174: "Bridgeport Machines",
    0x1175: "Mitron Computer Inc.",
    0x1176: "SBE Incorporated",
    0x1177: "Silicon Engineering",
    0x1178: "Alfa, Inc.",
    0x1179: "Toshiba Corporation",
    0x117A: "A-Trend Technology",
    0x117B: "L G Electronics, Inc.",
    0x117C: "ATTO Technology, Inc.",
    0x117D: "Becton & Dickinson",
    0x117E: "T/R Systems",
    0x117F: "Integrated Circuit Systems",
    0x1180: "Ricoh Co Ltd",
    0x1181: "Telmatics International",
    0x1183: "Fujikura Ltd",
    0x1184: "Forks Inc",
    0x1185: "Dataworld International Ltd",
    0x1186: "D-Link System Inc",
    0x1187: "Advanced Technology Laboratories, Inc.",
    0x1188: "Shima Seiki Manufacturing Ltd.",
    0x1189: "Matsushita Electronics Co Ltd",
    0x118A: "Hilevel Technology",
    0x118B: "Hypertec Pty Limited",
    0x118C: "Corollary, Inc",
    0x118D: "BitFlow Inc",
    0x118E: "Hermstedt GmbH",
    0x118F: "Green Logic",
    0x1190: "Tripace",
    0x1191: "Artop Electronic Corp",
    0x1192: "Densan Company Ltd",
    0x1193: "Zeitnet Inc.",
    0x1194: "Toucan Technology",
    0x1195: "Ratoc System Inc",
    0x1196: "Hytec Electronics Ltd",
    0x1197: "Gage Applied Sciences, Inc.",
    0x1198: "Lambda Systems Inc",
    0x1199: "Attachmate Corporation",
    0x119A: "Mind Share, Inc.",
    0x119B: "Omega Micro Inc.",
    0x119C: "Information Technology Inst.",
    0x119D: "Bug, Inc. Sapporo Japan",
    0x119E: "Fujitsu Microelectronics Ltd.",
    0x119F: "Bull HN Information Systems",
    0x11A0: "Convex Computer Corporation",
    0x11A1: "Hamamatsu Photonics K.K.",
    0x11A2: "Sierra Research and Technology",
    0x11A3: "Deuretzbacher GmbH & Co. Eng. KG",
    0x11A4: "Barco Graphics NV",
    0x11A5: "Microunity Systems Eng. Inc",
    0x11A6: "Pure Data Ltd.",
    0x11A7: "Power Computing Corp.",
    0x11A8: "Systech Corp.",
    0x11A9: "InnoSys Inc.",
    0x11AA: "Actel",
    0x11AB: "Marvell Technology Group Ltd.",
    0x11AC: "Canon Information Systems Research Aust.",
    0x11AD: "Lite-On Communications Inc",
    0x11AE: "Aztech System Ltd",
    0x11AF: "Avid Technology Inc.",
    0x11B0: "V3 Semiconductor Inc.",
    0x11B1: "Apricot Computers",
    0x11B2: "Eastman Kodak",
    0x11B3: "Barr Systems Inc.",
    0x11B4: "Leitch Technology International",
    0x11B5: "Radstone Technology Plc",
    0x11B6: "United Video Corp",
    0x11B7: "Motorola",
    0x11B8: "XPoint Technologies, Inc",
    0x11B9: "Pathlight Technology Inc.",
    0x11BA: "Videotron Corp",
    0x11BB: "Pyramid Technology",
    0x11BC: "Network Peripherals Inc",
    0x11BD: "Pinnacle Systems Inc.",
    0x11BE: "International Microcircuits Inc",
    0x11BF: "Astrodesign, Inc.",
    0x11C0: "Hewlett Packard",
    0x11C1: "LSI Corporation",
    0x11C2: "Sand Microelectronics",
    0x11C3: "NEC Corporation",
    0x11C4: "Document Technologies, Inc",
    0x11C5: "Shiva Corporation",
    0x11C6: "Dainippon Screen Mfg. Co. Ltd",
    0x11C7: "D.C.M. Data Systems",
    0x11C8: "Dolphin Interconnect Solutions AS",
    0x11C9: "Magma",
    0x11CA: "LSI Systems, Inc",
    0x11CB: "Specialix Research Ltd.",
    0x11CC: "Michels & Kleberhoff Computer GmbH",
    0x11CD: "HAL Computer Systems, Inc.",
    0x11CE: "Netaccess",
    0x11CF: "Pioneer Electronic Corporation",
    0x11D0: "Lockheed Martin Federal Systems-Manassas",
    0x11D1: "Auravision",
    0x11D2: "Intercom Inc.",
    0x11D3: "Trancell Systems Inc",
    0x11D4: "Analog Devices",
    0x11D5: "Ikon Corporation",
    0x11D6: "Tekelec Telecom",
    0x11D7: "Trenton Technology, Inc.",
    0x11D8: "Image Technologies Development",
    0x11D9: "TEC Corporation",
    0x11DA: "Novell",
    0x11DB: "Sega Enterprises Ltd",
    0x11DC: "Questra Corporation",
    0x11DD: "Crosfield Electronics Limited",
    0x11DE: "Zoran Corporation",
    0x11DF: "New Wave PDG",
    0x11E0: "Cray Communications A/S",
    0x11E1: "GEC Plessey Semi Inc.",
    0x11E2: "Samsung Information Systems America",
    0x11E3: "Quicklogic Corporation",
    0x11E4: "Second Wave Inc",
    0x11E5: "IIX Consulting",
    0x11E6: "Mitsui-Zosen System Research",
    0x11E7: "Toshiba America, Elec. Company",
    0x11E8: "Digital Processing Systems Inc.",
    0x11E9: "Highwater Designs Ltd.",
    0x11EA: "Elsag Bailey",
    0x11EB: "Formation Inc.",
    0x11EC: "Coreco Inc",
    0x11ED: "Mediamatics",
    0x11EE: "Dome Imaging Systems Inc",
    0x11EF: "Nicolet Technologies B.V.",
    0x11F0: "Compu-Shack",
    0x11F1: "Symbios Logic Inc",
    0x11F2: "Picture Tel Japan K.K.",
    0x11F3: "Keithley Metrabyte",
    0x11F4: "Kinetic Systems Corporation",
    0x11F5: "Computing Devices International",
    0x11F6: "Compex",
    0x11F7: "Scientific Atlanta",
    0x11F8: "PMC-Sierra Inc.",
    0x11F9: "I-Cube Inc",
    0x11FA: "Kasan Electronics Company, Ltd.",
    0x11FB: "Datel Inc",
    0x11FC: "Silicon Magic",
    0x11FD: "High Street Consultants",
    0x11FE: "Pepperl+Fuchs",
    0x11FF: "Scion Corporation",
    0x1200: "CSS Corporation",
    0x1201: "Vista Controls Corp",
    0x1202: "Network General Corp.",
    0x1203: "Bayer Corporation, Agfa Division",
    0x1204: "Lattice Semiconductor Corporation",
    0x1205: "Array Corporation",
    0x1206: "Amdahl Corporation",
    0x1208: "Parsytec GmbH",
    0x1209: "SCI Systems Inc",
    0x120A: "Synaptel",
    0x120B: "Adaptive Solutions",
    0x120C: "Technical Corp.",
    0x120D: "Compression Labs, Inc.",
    0x120E: "Cyclades Corporation",
    0x120F: "Essential Communications",
    0x1210: "Hyperparallel Technologies",
    0x1211: "Braintech Inc",
    0x1213: "Applied Intelligent Systems, Inc.",
    0x1214: "Performance Technologies, Inc.",
    0x1215: "Interware Co., Ltd",
    0x1216: "Purup Prepress A/S",
    0x1217: "O2 Micro, Inc.",
    0x1218: "Hybricon Corp.",
    0x1219: "First Virtual Corporation",
    0x121A: "3Dfx Interactive, Inc.",
    0x121B: "Advanced Telecommunications Modules",
    0x121C: "Nippon Texaco., Ltd",
    0x121D: "LiPPERT ADLINK Technology GmbH",
    0x121E: "CSPI",
    0x121F: "Arcus Technology, Inc.",
    0x1220: "Ariel Corporation",
    0x1221: "Contec Co., Ltd",
    0x1222: "Ancor Communications, Inc.",
    0x1223: "Artesyn Communication Products",
    0x1224: "Interactive Images",
    0x1225: "Power I/O, Inc.",
    0x1227: "EIZO Rugged Solutions",
    0x1228: "Norsk Elektro Optikk A/S",
    0x1229: "Data Kinesis Inc.",
    0x122A: "Integrated Telecom",
    0x122B: "LG Industrial Systems Co., Ltd",
    0x122C: "Sican GmbH",
    0x122D: "Aztech System Ltd",
    0x122E: "Xyratex",
    0x122F: "Andrew Corporation",
    0x1230: "Fishcamp Engineering",
    0x1231: "Woodward McCoach, Inc.",
    0x1232: "GPT Limited",
    0x1233: "Bus-Tech, Inc.",
    0x1235: "SMART Modular Technologies",
    0x1236: "Sigma Designs Corporation",
    0x1237: "Alta Technology Corporation",
    0x1238: "Adtran",
    0x1239: "3DO Company",
    0x123A: "Visicom Laboratories, Inc.",
    0x123B: "Seeq Technology, Inc.",
    0x123C: "Century Systems, Inc.",
    0x123D: "Engineering Design Team, Inc.",
    0x123E: "Simutech, Inc.",
    0x123F: "LSI Logic",
    0x1240: "Marathon Technologies Corp.",
    0x1241: "DSC Communications",
    0x1242: "JNI Corporation",
    0x1243: "Delphax",
    0x1244: "AVM GmbH",
    0x1245: "A.P.D., S.A.",
    0x1246: "Dipix Technologies, Inc.",
    0x1247: "Xylon Research, Inc.",
    0x1248: "Central Data Corporation",
    0x1249: "Samsung Electronics Co., Ltd.",
    0x124A: "AEG Electrocom GmbH",
    0x124B: "SBS/Greenspring Modular I/O",
    0x124C: "Solitron Technologies, Inc.",
    0x124D: "Stallion Technologies, Inc.",
    0x124E: "Cylink",
    0x124F: "Infortrend Technology, Inc.",
    0x1250: "Hitachi Microcomputer System Ltd",
    0x1251: "VLSI Solutions Oy",
    0x1253: "Guzik Technical Enterprises",
    0x1254: "Linear Systems Ltd.",
    0x1255: "Optibase Ltd",
    0x1256: "Perceptive Solutions, Inc.",
    0x1257: "Vertex Networks, Inc.",
    0x1258: "Gilbarco, Inc.",
    0x1259: "Allied Telesis",
    0x125A: "ABB Power Systems",
    0x125B: "Asix Electronics Corporation",
    0x125C: "Aurora Technologies, Inc.",
    0x125D: "ESS Technology",
    0x125E: "Specialvideo Engineering SRL",
    0x125F: "Concurrent Technologies, Inc.",
    0x1260: "Intersil Corporation",
    0x1261: "Matsushita-Kotobuki Electronics Industries, Ltd.",
    0x1262: "ES Computer Company, Ltd.",
    0x1263: "Sonic Solutions",
    0x1264: "Aval Nagasaki Corporation",
    0x1265: "Casio Computer Co., Ltd.",
    0x1266: "Microdyne Corporation",
    0x1267: "S. A. Telecommunications",
    0x1268: "Tektronix",
    0x1269: "Thomson-CSF/TTM",
    0x126A: "Lexmark International, Inc.",
    0x126B: "Adax, Inc.",
    0x126C: "Northern Telecom",
    0x126D: "Splash Technology, Inc.",
    0x126E: "Sumitomo Metal Industries, Ltd.",
    0x126F: "Silicon Motion, Inc.",
    0x1270: "Olympus Optical Co., Ltd.",
    0x1271: "GW Instruments",
    0x1272: "Telematics International",
    0x1273: "Hughes Network Systems",
    0x1274: "Ensoniq",
    0x1275: "Network Appliance Corporation",
    0x1276: "Switched Network Technologies, Inc.",
    0x1277: "Comstream",
    0x1278: "Transtech Parallel Systems Ltd.",
    0x1279: "Transmeta Corporation",
    0x127A: "Rockwell International",
    0x127B: "Pixera Corporation",
    0x127C: "Crosspoint Solutions, Inc.",
    0x127D: "Vela Research",
    0x127E: "Winnov, L.P.",
    0x127F: "Fujifilm",
    0x1280: "Photoscript Group Ltd.",
    0x1281: "Yokogawa Electric Corporation",
    0x1282: "Davicom Semiconductor, Inc.",
    0x1283: "Integrated Technology Express, Inc.",
    0x1284: "Sahara Networks, Inc.",
    0x1285: "Platform Technologies, Inc.",
    0x1286: "Mazet GmbH",
    0x1287: "M-Pact, Inc.",
    0x1288: "Timestep Corporation",
    0x1289: "AVC Technology, Inc.",
    0x128A: "Asante Technologies, Inc.",
    0x128B: "Transwitch Corporation",
    0x128C: "Retix Corporation",
    0x128D: "G2 Networks, Inc.",
    0x128E: "Hoontech Corporation/Samho Multi Tech Ltd.",
    0x128F: "Tateno Dennou, Inc.",
    0x1290: "Sord Computer Corporation",
    0x1291: "NCS Computer Italia",
    0x1292: "Tritech Microelectronics Inc",
    0x1293: "Media Reality Technology",
    0x1294: "Rhetorex, Inc.",
    0x1295: "Imagenation Corporation",
    0x1296: "Kofax Image Products",
    0x1297: "Holco Enterprise Co, Ltd/Shuttle Computer",
    0x1298: "Spellcaster Telecommunications Inc.",
    0x1299: "Knowledge Technology Lab.",
    0x129A: "VMetro, inc.",
    0x129B: "Image Access",
    0x129C: "Jaycor",
    0x129D: "Compcore Multimedia, Inc.",
    0x129E: "Victor Company of Japan, Ltd.",
    0x129F: "OEC Medical Systems, Inc.",
    0x12A0: "Allen-Bradley Company",
    0x12A1: "Simpact Associates, Inc.",
    0x12A2: "Newgen Systems Corporation",
    0x12A3: "Lucent Technologies",
    0x12A4: "NTT Electronics Corporation",
    0x12A5: "Vision Dynamics Ltd.",
    0x12A6: "Scalable Networks, Inc.",
    0x12A7: "AMO GmbH",
    0x12A8: "News Datacom",
    0x12A9: "Xiotech Corporation",
    0x12AA: "SDL Communications, Inc.",
    0x12AB: "YUAN High-Tech Development Co., Ltd.",
    0x12AC: "Measurex Corporation",
    0x12AD: "Multidata GmbH",
    0x12AE: "Alteon Networks Inc.",
    0x12AF: "TDK USA Corp",
    0x12B0: "Jorge Scientific Corp",
    0x12B1: "GammaLink",
    0x12B2: "General Signal Networks",
    0x12B3: "Inter-Face Co Ltd",
    0x12B4: "FutureTel Inc",
    0x12B5: "Granite Systems Inc.",
    0x12B6: "Natural Microsystems",
    0x12B7: "Cognex Corporation",
    0x12B8: "Korg",
    0x12B9: "3Com Corp, Modem Division",
    0x12BA: "BittWare, Inc.",
    0x12BB: "Nippon Unisoft Corporation",
    0x12BC: "Array Microsystems",
    0x12BD: "Computerm Corp.",
    0x12BE: "Anchor Chips Inc.",
    0x12BF: "Fujifilm Microdevices",
    0x12C0: "Infimed",
    0x12C1: "GMM Research Corp",
    0x12C2: "Mentec Limited",
    0x12C3: "Holtek Microelectronics Inc",
    0x12C4: "Connect Tech Inc",
    0x12C5: "Picture Elements Incorporated",
    0x12C6: "Mitani Corporation",
    0x12C7: "Dialogic Corp",
    0x12C8: "G Force Co, Ltd",
    0x12C9: "Gigi Operations",
    0x12CA: "Integrated Computing Engines",
    0x12CB: "Antex Electronics Corporation",
    0x12CC: "Pluto Technologies International",
    0x12CD: "Aims Lab",
    0x12CE: "Netspeed Inc.",
    0x12CF: "Prophet Systems, Inc.",
    0x12D0: "GDE Systems, Inc.",
    0x12D1: "PSITech",
    0x12D2: "NVidia / SGS Thomson (Joint Venture)",
    0x12D3: "Vingmed Sound A/S",
    0x12D4: "Ulticom (Formerly DGM&S)",
    0x12D5: "Equator Technologies Inc",
    0x12D6: "Analogic Corp",
    0x12D7: "Biotronic SRL",
    0x12D8: "Pericom Semiconductor",
    0x12D9: "Aculab PLC",
    0x12DA: "True Time Inc.",
    0x12DB: "Annapolis Micro Systems, Inc",
    0x12DC: "Symicron Computer Communication Ltd.",
    0x12DD: "Management Graphics",
    0x12DE: "Rainbow Technologies",
    0x12DF: "SBS Technologies Inc",
    0x12E0: "Chase Research",
    0x12E1: "Nintendo Co, Ltd",
    0x12E2: "Datum Inc. Bancomm-Timing Division",
    0x12E3: "Imation Corp - Medical Imaging Systems",
    0x12E4: "Brooktrout Technology Inc",
    0x12E5: "Apex Semiconductor Inc",
    0x12E6: "Cirel Systems",
    0x12E7: "Sunsgroup Corporation",
    0x12E8: "Crisc Corp",
    0x12E9: "GE Spacenet",
    0x12EA: "Zuken",
    0x12EB: "Aureal Semiconductor",
    0x12EC: "3A International, Inc.",
    0x12ED: "Optivision Inc.",
    0x12EE: "Orange Micro",
    0x12EF: "Vienna Systems",
    0x12F0: "Pentek",
    0x12F1: "Sorenson Vision Inc",
    0x12F2: "Gammagraphx, Inc.",
    0x12F3: "Radstone Technology",
    0x12F4: "Megatel",
    0x12F5: "Forks",
    0x12F6: "Dawson France",
    0x12F7: "Cognex",
    0x12F8: "Electronic Design GmbH",
    0x12F9: "Four Fold Ltd",
    0x12FB: "Spectrum Signal Processing",
    0x12FC: "Capital Equipment Corp",
    0x12FD: "I2S",
    0x12FE: "ESD Electronic System Design GmbH",
    0x12FF: "Lexicon",
    0x1300: "Harman International Industries Inc",
    0x1302: "Computer Sciences Corp",
    0x1303: "Innovative Integration",
    0x1304: "Juniper Networks",
    0x1305: "Netphone, Inc",
    0x1306: "Duet Technologies",
    0x1307: "Measurement Computing",
    0x1308: "Jato Technologies Inc.",
    0x1309: "AB Semiconductor Ltd",
    0x130A: "Mitsubishi Electric Microcomputer",
    0x130B: "Colorgraphic Communications Corp",
    0x130C: "Ambex Technologies, Inc",
    0x130D: "Accelerix Inc",
    0x130E: "Yamatake-Honeywell Co. Ltd",
    0x130F: "Advanet Inc",
    0x1310: "Gespac",
    0x1311: "Videoserver, Inc",
    0x1312: "Acuity Imaging, Inc",
    0x1313: "Yaskawa Electric Co.",
    0x1315: "Wavesat",
    0x1316: "Teradyne Inc",
    0x1317: "ADMtek",
    0x1318: "Packet Engines Inc.",
    0x1319: "Fortemedia, Inc",
    0x131A: "Finisar Corp.",
    0x131C: "Nippon Electro-Sensory Devices Corp",
    0x131D: "Sysmic, Inc.",
    0x131E: "Xinex Networks Inc",
    0x131F: "Siig Inc",
    0x1320: "Crypto AG",
    0x1321: "Arcobel Graphics BV",
    0x1322: "MTT Co., Ltd",
    0x1323: "Dome Inc",
    0x1324: "Sphere Communications",
    0x1325: "Salix Technologies, Inc",
    0x1326: "Seachange international",
    0x1327: "Voss scientific",
    0x1328: "quadrant international",
    0x1329: "Productivity Enhancement",
    0x132A: "Microcom Inc.",
    0x132B: "Broadband Technologies",
    0x132C: "Micrel Inc",
    0x132D: "Integrated Silicon Solution, Inc.",
    0x1330: "MMC Networks",
    0x1331: "RadiSys Corporation",
    0x1332: "Micro Memory",
    0x1334: "Redcreek Communications, Inc",
    0x1335: "Videomail, Inc",
    0x1337: "Third Planet Publishing",
    0x1338: "BT Electronics",
    0x133A: "Vtel Corp",
    0x133B: "Softcom Microsystems",
    0x133C: "Holontech Corp",
    0x133D: "SS Technologies",
    0x133E: "Virtual Computer Corp",
    0x133F: "SCM Microsystems",
    0x1340: "Atalla Corp",
    0x1341: "Kyoto Microcomputer Co",
    0x1342: "Promax Systems Inc",
    0x1343: "Phylon Communications Inc",
    0x1344: "Micron Technology Inc",
    0x1345: "Arescom Inc",
    0x1347: "Odetics",
    0x1349: "Sumitomo Electric Industries, Ltd.",
    0x134A: "DTC Technology Corp.",
    0x134B: "ARK Research Corp.",
    0x134C: "Chori Joho System Co. Ltd",
    0x134D: "PCTel Inc",
    0x134E: "CSTI",
    0x134F: "Algo System Co Ltd",
    0x1350: "Systec Co. Ltd",
    0x1351: "Sonix Inc",
    0x1353: "dbeeSet Technology",
    0x1354: "Dwave System Inc",
    0x1355: "Kratos Analytical Ltd",
    0x1356: "The Logical Co",
    0x1359: "Prisa Networks",
    0x135A: "Brain Boxes",
    0x135B: "Giganet Inc",
    0x135C: "Quatech Inc",
    0x135D: "ABB Network Partner AB",
    0x135E: "Sealevel Systems Inc",
    0x135F: "I-Data International A-S",
    0x1360: "Meinberg Funkuhren",
    0x1361: "Soliton Systems K.K.",
    0x1362: "Fujifacom Corporation",
    0x1363: "Phoenix Technology Ltd",
    0x1364: "ATM Communications Inc",
    0x1365: "Hypercope GmbH",
    0x1366: "Teijin Seiki Co. Ltd",
    0x1367: "Hitachi Zosen Corporation",
    0x1368: "Skyware Corporation",
    0x1369: "Digigram",
    0x136A: "High Soft Tech",
    0x136B: "Kawasaki Steel Corporation",
    0x136C: "Adtek System Science Co Ltd",
    0x136D: "Gigalabs Inc",
    0x136F: "Applied Magic Inc",
    0x1370: "ATL Products",
    0x1371: "CNet Technology Inc",
    0x1373: "Silicon Vision Inc",
    0x1374: "Silicom Ltd.",
    0x1375: "Argosystems Inc",
    0x1376: "LMC",
    0x1377: "Electronic Equipment Production & Distribution GmbH",
    0x1378: "Telemann Co. Ltd",
    0x1379: "Asahi Kasei Microsystems Co Ltd",
    0x137A: "Mark of the Unicorn Inc",
    0x137B: "PPT Vision",
    0x137C: "Iwatsu Electric Co Ltd",
    0x137D: "Dynachip Corporation",
    0x137E: "Patriot Scientific Corporation",
    0x137F: "Japan Satellite Systems Inc",
    0x1380: "Sanritz Automation Co Ltd",
    0x1381: "Brains Co. Ltd",
    0x1382: "Marian - Electronic & Software",
    0x1383: "Controlnet Inc",
    0x1384: "Reality Simulation Systems Inc",
    0x1385: "Netgear",
    0x1386: "Video Domain Technologies",
    0x1387: "Systran Corp",
    0x1388: "Hitachi Information Technology Co Ltd",
    0x1389: "Applicom International",
    0x138A: "Fusion Micromedia Corp",
    0x138B: "Tokimec Inc",
    0x138C: "Silicon Reality",
    0x138D: "Future Techno Designs pte Ltd",
    0x138E: "Basler GmbH",
    0x138F: "Patapsco Designs Inc",
    0x1390: "Concept Development Inc",
    0x1391: "Development Concepts Inc",
    0x1392: "Medialight Inc",
    0x1393: "Moxa Technologies Co Ltd",
    0x1394: "Level One Communications",
    0x1395: "Ambicom Inc",
    0x1396: "Cipher Systems Inc",
    0x1397: "Cologne Chip Designs GmbH",
    0x1398: "Clarion co. Ltd",
    0x1399: "Rios systems Co Ltd",
    0x139A: "Alacritech Inc",
    0x139B: "Mediasonic Multimedia Systems Ltd",
    0x139C: "Quantum 3d Inc",
    0x139D: "EPL limited",
    0x139E: "Media4",
    0x139F: "Aethra s.r.l.",
    0x13A0: "Crystal Group Inc",
    0x13A1: "Kawasaki Heavy Industries Ltd",
    0x13A2: "Ositech Communications Inc",
    0x13A3: "Hifn Inc.",
    0x13A4: "Rascom Inc",
    0x13A5: "Audio Digital Imaging Inc",
    0x13A6: "Videonics Inc",
    0x13A7: "Teles AG",
    0x13A8: "Exar Corp.",
    0x13A9: "Siemens Medical Systems, Ultrasound Group",
    0x13AA: "Broadband Networks Inc",
    0x13AB: "Arcom Control Systems Ltd",
    0x13AC: "Motion Media Technology Ltd",
    0x13AD: "Nexus Inc",
    0x13AE: "ALD Technology Ltd",
    0x13AF: "T.Sqware",
    0x13B0: "Maxspeed Corp",
    0x13B1: "Tamura corporation",
    0x13B2: "Techno Chips Co. Ltd",
    0x13B3: "Lanart Corporation",
    0x13B4: "Wellbean Co Inc",
    0x13B5: "ARM",
    0x13B6: "Dlog GmbH",
    0x13B7: "Logic Devices Inc",
    0x13B8: "Nokia Telecommunications oy",
    0x13B9: "Elecom Co Ltd",
    0x13BA: "Oxford Instruments",
    0x13BB: "Sanyo Technosound Co Ltd",
    0x13BC: "Bitran Corporation",
    0x13BD: "Sharp corporation",
    0x13BE: "Miroku Jyoho Service Co. Ltd",
    0x13BF: "Sharewave Inc",
    0x13C0: "Microgate Corporation",
    0x13C1: "3ware Inc",
    0x13C2: "Technotrend Systemtechnik GmbH",
    0x13C3: "Janz Computer AG",
    0x13C4: "Phase Metrics",
    0x13C5: "Alphi Technology Corp",
    0x13C6: "Condor Engineering Inc",
    0x13C7: "Blue Chip Technology Ltd",
    0x13C8: "Apptech Inc",
    0x13C9: "Eaton Corporation",
    0x13CA: "Iomega Corporation",
    0x13CB: "Yano Electric Co Ltd",
    0x13CC: "BARCO",
    0x13CD: "Compatible Systems Corporation",
    0x13CE: "Cocom A/S",
    0x13CF: "Studio Audio & Video Ltd",
    0x13D0: "Techsan Electronics Co Ltd",
    0x13D1: "Abocom Systems Inc",
    0x13D2: "Shark Multimedia Inc",
    0x13D4: "Graphics Microsystems Inc",
    0x13D5: "Media 100 Inc",
    0x13D6: "K.I. Technology Co Ltd",
    0x13D7: "Toshiba Engineering Corporation",
    0x13D8: "Phobos corporation",
    0x13D9: "Apex PC Solutions Inc",
    0x13DA: "Intresource Systems pte Ltd",
    0x13DB: "Janich & Klass Computertechnik GmbH",
    0x13DC: "Netboost Corporation",
    0x13DD: "Multimedia Bundle Inc",
    0x13DE: "ABB Robotics Products AB",
    0x13DF: "E-Tech Inc",
    0x13E0: "GVC Corporation",
    0x13E1: "Silicom Multimedia Systems Inc",
    0x13E2: "Dynamics Research Corporation",
    0x13E3: "Nest Inc",
    0x13E4: "Calculex Inc",
    0x13E5: "Telesoft Design Ltd",
    0x13E6: "Argosy research Inc",
    0x13E7: "NAC Incorporated",
    0x13E8: "Chip Express Corporation",
    0x13E9: "Intraserver Technology Inc",
    0x13EA: "Dallas Semiconductor",
    0x13EB: "Hauppauge Computer Works Inc",
    0x13EC: "Zydacron Inc",
    0x13ED: "Raytheion E-Systems",
    0x13EE: "Hayes Microcomputer Products Inc",
    0x13EF: "Coppercom Inc",
    0x13F0: "Sundance Technology Inc / IC Plus Corp",
    0x13F1: "Oce' - Technologies B.V.",
    0x13F2: "Ford Microelectronics Inc",
    0x13F3: "Mcdata Corporation",
    0x13F4: "Troika Networks, Inc.",
    0x13F5: "Kansai Electric Co. Ltd",
    0x13F6: "C-Media Electronics Inc",
    0x13F7: "Wildfire Communications",
    0x13F8: "Ad Lib Multimedia Inc",
    0x13F9: "NTT Advanced Technology Corp.",
    0x13FA: "Pentland Systems Ltd",
    0x13FB: "Aydin Corp",
    0x13FC: "Computer Peripherals International",
    0x13FD: "Micro Science Inc",
    0x13FE: "Advantech Co. Ltd",
    0x13FF: "Silicon Spice Inc",
    0x1400: "Artx Inc",
    0x1401: "CR-Systems A/S",
    0x1402: "Meilhaus Electronic GmbH",
    0x1403: "Ascor Inc",
    0x1404: "Fundamental Software Inc",
    0x1405: "Excalibur Systems Inc",
    0x1406: "Oce' Printing Systems GmbH",
    0x1407: "Lava Computer mfg Inc",
    0x1408: "Aloka Co. Ltd",
    0x1409: "Timedia Technology Co Ltd",
    0x140A: "DSP Research Inc",
    0x140B: "Abaco Systems, Inc.",
    0x140C: "Elmic Systems Inc",
    0x140D: "Matsushita Electric Works Ltd",
    0x140E: "Goepel Electronic GmbH",
    0x140F: "Salient Systems Corp",
    0x1410: "Midas lab Inc",
    0x1411: "Ikos Systems Inc",
    0x1412: "VIA Technologies Inc.",
    0x1413: "Addonics",
    0x1414: "Microsoft Corporation",
    0x1415: "Oxford Semiconductor Ltd",
    0x1416: "Multiwave Innovation pte Ltd",
    0x1417: "Convergenet Technologies Inc",
    0x1418: "Kyushu electronics systems Inc",
    0x1419: "Excel Switching Corp",
    0x141A: "Apache Micro Peripherals Inc",
    0x141B: "Zoom Telephonics Inc",
    0x141D: "Digitan Systems Inc",
    0x141E: "Fanuc Ltd",
    0x141F: "Visiontech Ltd",
    0x1420: "Psion Dacom plc",
    0x1421: "Ads Technologies Inc",
    0x1422: "Ygrec Systems Co Ltd",
    0x1423: "Custom Technology Corp.",
    0x1424: "Videoserver Connections",
    0x1425: "Chelsio Communications Inc",
    0x1426: "Storage Technology Corp.",
    0x1427: "Better On-Line Solutions",
    0x1428: "Edec Co Ltd",
    0x1429: "Unex Technology Corp.",
    0x142A: "Kingmax Technology Inc",
    0x142B: "Radiolan",
    0x142C: "Minton Optic Industry Co Ltd",
    0x142D: "Pix stream Inc",
    0x142E: "Vitec Multimedia",
    0x142F: "Radicom Research Inc",
    0x1430: "ITT Aerospace/Communications Division",
    0x1431: "Gilat Satellite Networks",
    0x1432: "Edimax Computer Co.",
    0x1433: "Eltec Elektronik GmbH",
    0x1435: "RTD Embedded Technologies, Inc.",
    0x1436: "CIS Technology Inc",
    0x1437: "Nissin Inc Co",
    0x1438: "Atmel-dream",
    0x1439: "Outsource Engineering & Mfg. Inc",
    0x143A: "Stargate Solutions Inc",
    0x143B: "Canon Research Center, America",
    0x143C: "Amlogic Inc",
    0x143D: "Tamarack Microelectronics Inc",
    0x143E: "Jones Futurex Inc",
    0x143F: "Lightwell Co Ltd - Zax Division",
    0x1440: "ALGOL Corp.",
    0x1441: "AGIE Ltd",
    0x1442: "Phoenix Contact GmbH & Co.",
    0x1443: "Unibrain S.A.",
    0x1444: "TRW",
    0x1445: "Logical DO Ltd",
    0x1446: "Graphin Co Ltd",
    0x1447: "AIM GmBH",
    0x1448: "Alesis Studio Electronics",
    0x1449: "TUT Systems Inc",
    0x144A: "Adlink Technology",
    0x144B: "Verint Systems Inc.",
    0x144C: "Catalina Research Inc",
    0x144D: "Samsung Electronics Co Ltd",
    0x144E: "OLITEC",
    0x144F: "Askey Computer Corp.",
    0x1450: "Octave Communications Ind.",
    0x1451: "SP3D Chip Design GmBH",
    0x1453: "MYCOM Inc",
    0x1454: "Altiga Networks",
    0x1455: "Logic Plus Plus Inc",
    0x1456: "Advanced Hardware Architectures",
    0x1457: "Nuera Communications Inc",
    0x1458: "Gigabyte Technology Co., Ltd",
    0x1459: "DOOIN Electronics",
    0x145A: "Escalate Networks Inc",
    0x145B: "PRAIM SRL",
    0x145C: "Cryptek",
    0x145D: "Gallant Computer Inc",
    0x145E: "Aashima Technology B.V.",
    0x145F: "Baldor Electric Company",
    0x1460: "DYNARC INC",
    0x1461: "Avermedia Technologies Inc",
    0x1462: "Micro-Star International Co., Ltd. [MSI]",
    0x1463: "Fast Corporation",
    0x1464: "Interactive Circuits & Systems Ltd",
    0x1465: "GN NETTEST Telecom DIV.",
    0x1466: "Designpro Inc.",
    0x1467: "DIGICOM SPA",
    0x1468: "AMBIT Microsystem Corp.",
    0x1469: "Cleveland Motion Controls",
    0x146A: "Aeroflex",
    0x146B: "Parascan Technologies Ltd",
    0x146C: "Ruby Tech Corp.",
    0x146D: "Tachyon, INC.",
    0x146E: "Williams Electronics Games, Inc.",
    0x146F: "Multi Dimensional Consulting Inc",
    0x1470: "Bay Networks",
    0x1471: "Integrated Telecom Express Inc",
    0x1472: "DAIKIN Industries, Ltd",
    0x1473: "ZAPEX Technologies Inc",
    0x1474: "Doug Carson & Associates",
    0x1475: "PICAZO Communications",
    0x1476: "MORTARA Instrument Inc",
    0x1477: "Net Insight",
    0x1478: "DIATREND Corporation",
    0x1479: "TORAY Industries Inc",
    0x147A: "FORMOSA Industrial Computing",
    0x147B: "ABIT Computer Corp.",
    0x147C: "AWARE, Inc.",
    0x147D: "Interworks Computer Products",
    0x147E: "Matsushita Graphic Communication Systems, Inc.",
    0x147F: "NIHON UNISYS, Ltd.",
    0x1480: "SCII Telecom",
    0x1481: "BIOPAC Systems Inc",
    0x1482: "ISYTEC - Integrierte Systemtechnik GmBH",
    0x1483: "LABWAY Corporation",
    0x1484: "Logic Corporation",
    0x1485: "ERMA - Electronic GmBH",
    0x1486: "L3 Communications Telemetry & Instrumentation",
    0x1487: "MARQUETTE Medical Systems",
    0x1489: "KYE Systems Corporation",
    0x148A: "OPTO",
    0x148B: "INNOMEDIALOGIC Inc.",
    0x148C: "Tul Corporation / PowerColor",
    0x148D: "DIGICOM Systems, Inc.",
    0x148E: "OSI Plus Corporation",
    0x148F: "Plant Equipment, Inc.",
    0x1490: "Stone Microsystems PTY Ltd.",
    0x1491: "ZEAL Corporation",
    0x1492: "Time Logic Corporation",
    0x1493: "MAKER Communications",
    0x1494: "WINTOP Technology, Inc.",
    0x1495: "TOKAI Communications Industry Co. Ltd",
    0x1496: "JOYTECH Computer Co., Ltd.",
    0x1497: "SMA Regelsysteme GmBH",
    0x1498: "TEWS Technologies GmbH",
    0x1499: "EMTEC CO., Ltd",
    0x149A: "ANDOR Technology Ltd",
    0x149B: "SEIKO Instruments Inc",
    0x149C: "OVISLINK Corp.",
    0x149D: "NEWTEK Inc",
    0x149E: "Mapletree Networks Inc.",
    0x149F: "LECTRON Co Ltd",
    0x14A0: "SOFTING GmBH",
    0x14A1: "Systembase Co Ltd",
    0x14A2: "Millennium Engineering Inc",
    0x14A3: "Maverick Networks",
    0x14A4: "Lite-On Technology Corporation",
    0x14A5: "XIONICS Document Technologies Inc",
    0x14A6: "INOVA Computers GmBH & Co KG",
    0x14A7: "MYTHOS Systems Inc",
    0x14A8: "FEATRON Technologies Corporation",
    0x14A9: "HIVERTEC Inc",
    0x14AA: "Advanced MOS Technology Inc",
    0x14AB: "Siemens Industry Software Inc.",
    0x14AC: "Novaweb Technologies Inc",
    0x14AD: "Time Space Radio AB",
    0x14AE: "CTI, Inc",
    0x14AF: "Guillemot Corporation",
    0x14B0: "BST Communication Technology Ltd",
    0x14B1: "Nextcom K.K.",
    0x14B2: "ENNOVATE Networks Inc",
    0x14B3: "XPEED Inc",
    0x14B4: "PHILIPS Business Electronics B.V.",
    0x14B5: "Creamware GmBH",
    0x14B6: "Quantum Data Corp.",
    0x14B7: "PROXIM Inc",
    0x14B8: "Techsoft Technology Co Ltd",
    0x14B9: "Cisco Aironet Wireless Communications",
    0x14BA: "INTERNIX Inc.",
    0x14BB: "SEMTECH Corporation",
    0x14BC: "Globespan Semiconductor Inc.",
    0x14BD: "CARDIO Control N.V.",
    0x14BE: "L3 Communications",
    0x14BF: "SPIDER Communications Inc.",
    0x14C0: "COMPAL Electronics Inc",
    0x14C1: "MYRICOM Inc.",
    0x14C2: "DTK Computer",
    0x14C3: "MEDIATEK Corp.",
    0x14C4: "IWASAKI Information Systems Co Ltd",
    0x14C5: "Automation Products AB",
    0x14C6: "Data Race Inc",
    0x14C7: "Modular Technology Holdings Ltd",
    0x14C8: "Turbocomm Tech. Inc.",
    0x14C9: "ODIN Telesystems Inc",
    0x14CA: "PE Logic Corp.",
    0x14CB: "Billionton Systems Inc",
    0x14CC: "NAKAYO Telecommunications Inc",
    0x14CD: "Universal Global Scientific Industrial Co.,Ltd",
    0x14CE: "Whistle Communications",
    0x14CF: "TEK Microsystems Inc.",
    0x14D0: "Ericsson Axe R & D",
    0x14D1: "Computer Hi-Tech Co Ltd",
    0x14D2: "Titan Electronics Inc",
    0x14D3: "CIRTECH (UK) Ltd",
    0x14D4: "Panacom Technology Corp",
    0x14D5: "Nitsuko Corporation",
    0x14D6: "Accusys Inc",
    0x14D7: "Hirakawa Hewtech Corp",
    0x14D8: "HOPF Elektronik GmBH",
    0x14D9: "Alliance Semiconductor Corporation",
    0x14DA: "National Aerospace Laboratories",
    0x14DB: "AFAVLAB Technology Inc",
    0x14DC: "Amplicon Liveline Ltd",
    0x14DD: "Boulder Design Labs Inc",
    0x14DE: "Applied Integration Corporation",
    0x14DF: "ASIC Communications Corp",
    0x14E1: "INVERTEX",
    0x14E2: "INFOLIBRIA",
    0x14E3: "AMTELCO",
    0x14E4: "Broadcom Inc. and subsidiaries",
    0x14E5: "Pixelfusion Ltd",
    0x14E6: "SHINING Technology Inc",
    0x14E7: "3CX",
    0x14E8: "RAYCER Inc",
    0x14E9: "GARNETS System CO Ltd",
    0x14EA: "Planex Communications, Inc",
    0x14EB: "SEIKO EPSON Corp",
    0x14EC: "Agilent Technologies",
    0x14ED: "DATAKINETICS Ltd",
    0x14EE: "MASPRO KENKOH Corp",
    0x14EF: "CARRY Computer ENG. CO Ltd",
    0x14F0: "CANON RESEACH CENTRE FRANCE",
    0x14F1: "Conexant Systems, Inc.",
    0x14F2: "MOBILITY Electronics",
    0x14F3: "BroadLogic",
    0x14F4: "TOKYO Electronic Industry CO Ltd",
    0x14F5: "SOPAC Ltd",
    0x14F6: "COYOTE Technologies LLC",
    0x14F7: "WOLF Technology Inc",
    0x14F8: "AUDIOCODES Inc",
    0x14F9: "AG COMMUNICATIONS",
    0x14FA: "WANDEL & GOLTERMANN",
    0x14FB: "TRANSAS MARINE (UK) Ltd",
    0x14FC: "Quadrics Ltd",
    0x14FD: "JAPAN Computer Industry Inc",
    0x14FE: "ARCHTEK TELECOM Corp",
    0x14FF: "TWINHEAD INTERNATIONAL Corp",
    0x1500: "DELTA Electronics, Inc",
    0x1501: "BANKSOFT CANADA Ltd",
    0x1502: "MITSUBISHI ELECTRIC LOGISTICS SUPPORT Co Ltd",
    0x1503: "KAWASAKI LSI USA Inc",
    0x1504: "KAISER Electronics",
    0x1505: "ITA INGENIEURBURO FUR TESTAUFGABEN GmbH",
    0x1506: "CHAMELEON Systems Inc",
    0x1507: "Motorola ?? / HTEC",
    0x1508: "HONDA CONNECTORS/MHOTRONICS Inc",
    0x1509: "FIRST INTERNATIONAL Computer Inc",
    0x150A: "FORVUS RESEARCH Inc",
    0x150B: "YAMASHITA Systems Corp",
    0x150C: "KYOPAL CO Ltd",
    0x150D: "WARPSPPED Inc",
    0x150E: "C-PORT Corp",
    0x150F: "INTEC GmbH",
    0x1510: "BEHAVIOR TECH Computer Corp",
    0x1511: "CENTILLIUM Technology Corp",
    0x1512: "ROSUN Technologies Inc",
    0x1513: "Raychem",
    0x1514: "TFL LAN Inc",
    0x1515: "Advent design",
    0x1516: "MYSON Technology Inc",
    0x1517: "ECHOTEK Corp",
    0x1518: "Kontron",
    0x1519: "TELEFON AKTIEBOLAGET LM Ericsson",
    0x151A: "Globetek",
    0x151B: "COMBOX Ltd",
    0x151C: "DIGITAL AUDIO LABS Inc",
    0x151D: "Fujitsu Computer Products Of America",
    0x151E: "MATRIX Corp",
    0x151F: "TOPIC SEMICONDUCTOR Corp",
    0x1520: "CHAPLET System Inc",
    0x1521: "BELL Corp",
    0x1522: "MainPine Ltd",
    0x1523: "MUSIC Semiconductors",
    0x1524: "ENE Technology Inc",
    0x1525: "IMPACT Technologies",
    0x1526: "ISS, Inc",
    0x1527: "SOLECTRON",
    0x1528: "ACKSYS",
    0x1529: "ON Semiconductor",
    0x152A: "QUICKTURN DESIGN Systems",
    0x152B: "FLYTECH Technology CO Ltd",
    0x152C: "MACRAIGOR Systems LLC",
    0x152D: "QUANTA Computer Inc",
    0x152E: "MELEC Inc",
    0x152F: "PHILIPS - CRYPTO",
    0x1530: "ACQIS Technology Inc",
    0x1531: "CHRYON Corp",
    0x1532: "ECHELON Corp",
    0x1533: "BALTIMORE",
    0x1534: "ROAD Corp",
    0x1535: "EVERGREEN Technologies Inc",
    0x1536: "ACTIS Computer",
    0x1537: "DATALEX COMMUNCATIONS",
    0x1538: "ARALION Inc",
    0x1539: "ATELIER INFORMATIQUES et ELECTRONIQUE ETUDES S.A.",
    0x153A: "ONO SOKKI",
    0x153B: "TERRATEC Electronic GmbH",
    0x153C: "ANTAL Electronic",
    0x153D: "FILANET Corp",
    0x153E: "TECHWELL Inc",
    0x153F: "MIPS Technologies, Inc.",
    0x1540: "PROVIDEO MULTIMEDIA Co Ltd",
    0x1541: "MACHONE Communications",
    0x1542: "Concurrent Real-Time",
    0x1543: "SILICON Laboratories",
    0x1544: "DCM DATA Systems",
    0x1545: "VISIONTEK",
    0x1546: "IOI Technology Corp",
    0x1547: "MITUTOYO Corp",
    0x1548: "JET PROPULSION Laboratory",
    0x1549: "INTERCONNECT Systems Solutions",
    0x154A: "MAX Technologies Inc",
    0x154B: "COMPUTEX Co Ltd",
    0x154C: "VISUAL Technology Inc",
    0x154D: "PAN INTERNATIONAL Industrial Corp",
    0x154E: "SERVOTEST Ltd",
    0x154F: "STRATABEAM Technology",
    0x1550: "OPEN NETWORK Co Ltd",
    0x1551: "SMART Electronic DEVELOPMENT GmBH",
    0x1552: "RACAL AIRTECH Ltd",
    0x1553: "CHICONY Electronics Co Ltd",
    0x1554: "PROLINK Microsystems Corp",
    0x1555: "GESYTEC GmBH",
    0x1556: "PLDA",
    0x1557: "MEDIASTAR Co Ltd",
    0x1558: "CLEVO/KAPOK Computer",
    0x1559: "SI LOGIC Ltd",
    0x155A: "INNOMEDIA Inc",
    0x155B: "PROTAC INTERNATIONAL Corp",
    0x155C: "Cemax-Icon Inc",
    0x155D: "Mac System Co Ltd",
    0x155E: "LP Elektronik GmbH",
    0x155F: "Perle Systems Ltd",
    0x1560: "Terayon Communications Systems",
    0x1561: "Viewgraphics Inc",
    0x1562: "Symbol Technologies",
    0x1563: "A-Trend Technology Co Ltd",
    0x1564: "Yamakatsu Electronics Industry Co Ltd",
    0x1565: "Biostar Microtech Int'l Corp",
    0x1566: "Ardent Technologies Inc",
    0x1567: "Jungsoft",
    0x1568: "DDK Electronics Inc",
    0x1569: "Palit Microsystems Inc.",
    0x156A: "Avtec Systems",
    0x156B: "2wire Inc",
    0x156C: "Vidac Electronics GmbH",
    0x156D: "Alpha-Top Corp",
    0x156E: "Alfa Inc",
    0x156F: "M-Systems Flash Disk Pioneers Ltd",
    0x1570: "Lecroy Corp",
    0x1571: "Contemporary Controls",
    0x1572: "Otis Elevator Company",
    0x1573: "Lattice - Vantis",
    0x1574: "Fairchild Semiconductor",
    0x1575: "Voltaire Advanced Data Security Ltd",
    0x1576: "Viewcast COM",
    0x1578: "HITT",
    0x1579: "Dual Technology Corp",
    0x157A: "Japan Elecronics Ind Inc",
    0x157B: "Star Multimedia Corp",
    0x157C: "Eurosoft (UK)",
    0x157D: "Gemflex Networks",
    0x157E: "Transition Networks",
    0x157F: "PX Instruments Technology Ltd",
    0x1580: "Primex Aerospace Co",
    0x1581: "SEH Computertechnik GmbH",
    0x1582: "Cytec Corp",
    0x1583: "Inet Technologies Inc",
    0x1584: "Uniwill Computer Corp",
    0x1585: "Logitron",
    0x1586: "Lancast Inc",
    0x1587: "Konica Corp",
    0x1588: "Solidum Systems Corp",
    0x1589: "Atlantek Microsystems Pty Ltd",
    0x158A: "Digalog Systems Inc",
    0x158B: "Allied Data Technologies",
    0x158C: "Hitachi Semiconductor & Devices Sales Co Ltd",
    0x158D: "Point Multimedia Systems",
    0x158E: "Lara Technology Inc",
    0x158F: "Ditect Coop",
    0x1590: "Hewlett Packard Enterprise",
    0x1591: "ARN",
    0x1592: "Syba Tech Ltd",
    0x1593: "Bops Inc",
    0x1594: "Netgame Ltd",
    0x1595: "Diva Systems Corp",
    0x1596: "Folsom Research Inc",
    0x1597: "Memec Design Services",
    0x1598: "Granite Microsystems",
    0x1599: "Delta Electronics Inc",
    0x159A: "General Instrument",
    0x159B: "Faraday Technology Corp",
    0x159C: "Stratus Computer Systems",
    0x159D: "Ningbo Harrison Electronics Co Ltd",
    0x159E: "A-Max Technology Co Ltd",
    0x159F: "Galea Network Security",
    0x15A0: "Compumaster SRL",
    0x15A1: "Geocast Network Systems",
    0x15A2: "Catalyst Enterprises Inc",
    0x15A3: "Italtel",
    0x15A4: "X-Net OY",
    0x15A5: "Toyota Macs Inc",
    0x15A6: "Sunlight Ultrasound Technologies Ltd",
    0x15A7: "SSE Telecom Inc",
    0x15A8: "Shanghai Communications Technologies Center",
    0x15AA: "Moreton Bay",
    0x15AB: "Bluesteel Networks Inc",
    0x15AC: "North Atlantic Instruments",
    0x15AD: "VMware",
    0x15AE: "Amersham Pharmacia Biotech",
    0x15B0: "Zoltrix International Ltd",
    0x15B1: "Source Technology Inc",
    0x15B2: "Mosaid Technologies Inc",
    0x15B3: "Mellanox Technologies",
    0x15B4: "CCI/TRIAD",
    0x15B5: "Cimetrics Inc",
    0x15B6: "Texas Memory Systems Inc",
    0x15B7: "Sandisk Corp",
    0x15B8: "ADDI-DATA GmbH",
    0x15B9: "Maestro Digital Communications",
    0x15BA: "Impacct Technology Corp",
    0x15BB: "Portwell Inc",
    0x15BC: "Agilent Technologies",
    0x15BD: "DFI Inc",
    0x15BE: "Sola Electronics",
    0x15BF: "High Tech Computer Corp (HTC)",
    0x15C0: "BVM Ltd",
    0x15C1: "Quantel",
    0x15C2: "Newer Technology Inc",
    0x15C3: "Taiwan Mycomp Co Ltd",
    0x15C4: "EVSX Inc",
    0x15C5: "Procomp Informatics Ltd",
    0x15C6: "Technical University of Budapest",
    0x15C7: "Tateyama System Laboratory Co Ltd",
    0x15C8: "Penta Media Co Ltd",
    0x15C9: "Serome Technology Inc",
    0x15CA: "Bitboys OY",
    0x15CB: "AG Electronics Ltd",
    0x15CC: "Hotrail Inc",
    0x15CD: "Dreamtech Co Ltd",
    0x15CE: "Genrad Inc",
    0x15CF: "Hilscher Gesellschaft für Systemautomation mbH",
    0x15D1: "Infineon Technologies AG",
    0x15D2: "FIC (First International Computer Inc)",
    0x15D3: "NDS Technologies Israel Ltd",
    0x15D4: "Iwill Corp",
    0x15D5: "Tatung Co",
    0x15D6: "Entridia Corp",
    0x15D7: "Rockwell-Collins Inc",
    0x15D8: "Cybernetics Technology Co Ltd",
    0x15D9: "Super Micro Computer Inc",
    0x15DA: "Cyberfirm Inc",
    0x15DB: "Applied Computing Systems Inc",
    0x15DC: "Litronic Inc",
    0x15DD: "Sigmatel Inc",
    0x15DE: "Malleable Technologies Inc",
    0x15DF: "Infinilink Corp",
    0x15E0: "Cacheflow Inc",
    0x15E1: "Voice Technologies Group Inc",
    0x15E2: "Quicknet Technologies Inc",
    0x15E3: "Networth Technologies Inc",
    0x15E4: "VSN Systemen BV",
    0x15E5: "Valley technologies Inc",
    0x15E6: "Agere Inc",
    0x15E7: "Get Engineering Corp",
    0x15E8: "National Datacomm Corp",
    0x15E9: "Pacific Digital Corp",
    0x15EA: "Tokyo Denshi Sekei K.K.",
    0x15EB: "DResearch Digital Media Systems GmbH",
    0x15EC: "Beckhoff GmbH",
    0x15ED: "Macrolink Inc",
    0x15EE: "In Win Development Inc",
    0x15EF: "Intelligent Paradigm Inc",
    0x15F0: "B-Tree Systems Inc",
    0x15F1: "Times N Systems Inc",
    0x15F2: "Diagnostic Instruments Inc",
    0x15F3: "Digitmedia Corp",
    0x15F4: "Valuesoft",
    0x15F5: "Power Micro Research",
    0x15F6: "Extreme Packet Device Inc",
    0x15F7: "Banctec",
    0x15F8: "Koga Electronics Co",
    0x15F9: "Zenith Electronics Corp",
    0x15FA: "J.P. Axzam Corp",
    0x15FB: "Zilog Inc",
    0x15FC: "Techsan Electronics Co Ltd",
    0x15FD: "N-CUBED.NET",
    0x15FE: "Kinpo Electronics Inc",
    0x15FF: "Fastpoint Technologies Inc",
    0x1600: "Northrop Grumman - Canada Ltd",
    0x1601: "Tenta Technology",
    0x1602: "Prosys-tec Inc",
    0x1603: "Nokia Wireless Communications",
    0x1604: "Central System Research Co Ltd",
    0x1605: "Pairgain Technologies",
    0x1606: "Europop AG",
    0x1607: "Lava Semiconductor Manufacturing Inc",
    0x1608: "Automated Wagering International",
    0x1609: "Scimetric Instruments Inc",
    0x1612: "Telesynergy Research Inc.",
    0x1618: "Stone Ridge Technology",
    0x1619: "FarSite Communications Ltd",
    0x161F: "Rioworks",
    0x1621: "Lynx Studio Technology, Inc.",
    0x1626: "TDK Semiconductor Corp.",
    0x1629: "Kongsberg Spacetec AS",
    0x1631: "Packard Bell B.V.",
    0x1638: "Standard Microsystems Corp [SMC]",
    0x163C: "Smart Link Ltd.",
    0x1641: "MKNet Corp.",
    0x1642: "Bitland(ShenZhen) Information Technology Co., Ltd.",
    0x1657: "Cavium QLogic",
    0x165A: "Epix Inc",
    0x165C: "Gidel Ltd.",
    0x165D: "Hsing Tech. Enterprise Co., Ltd.",
    0x165F: "Linux Media Labs, LLC",
    0x1661: "Worldspace Corp.",
    0x1668: "Actiontec Electronics Inc",
    0x166D: "Broadcom Corporation",
    0x1677: "B&R Industrial Automation GmbH",
    0x1678: "NetEffect",
    0x1679: "Tokyo Electron Device Ltd.",
    0x167B: "ZyDAS Technology Corp.",
    0x167D: "Samsung Electro-Mechanics Co., Ltd.",
    0x167E: "ONNTO Corp.",
    0x1681: "Hercules",
    0x1682: "XFX Pine Group Inc.",
    0x1688: "CastleNet Technology Inc.",
    0x168A: "Utimaco IS GmbH",
    0x168C: "Qualcomm Atheros",
    0x1695: "EPoX Computer Co., Ltd.",
    0x169C: "Netcell Corporation",
    0x169D: "Club-3D VB (Wrong ID)",
    0x16A5: "Tekram Technology Co.,Ltd.",
    0x16AB: "Global Sun Technology Inc",
    0x16AE: "SafeNet Inc",
    0x16AF: "SparkLAN Communications, Inc.",
    0x16B4: "Aspex Semiconductor Ltd",
    0x16B8: "Sonnet Technologies, Inc.",
    0x16BE: "Creatix Polymedia GmbH",
    0x16C3: "Synopsys, Inc.",
    0x16C6: "Micrel-Kendin",
    0x16C8: "Octasic Inc.",
    0x16C9: "EONIC B.V. The Netherlands",
    0x16CA: "CENATEK Inc",
    0x16CD: "Advantech Co. Ltd",
    0x16CE: "Roland Corp.",
    0x16D5: "Acromag, Inc.",
    0x16DA: "Advantech Co., Ltd.",
    0x16DF: "PIKA Technologies Inc.",
    0x16E2: "Marvin Test Solutions",
    0x16E3: "European Space Agency",
    0x16E5: "Intellon Corp.",
    0x16EC: "U.S. Robotics",
    0x16ED: "Sycron N. V.",
    0x16F2: "ETAS GmbH",
    0x16F3: "Jetway Information Co., Ltd.",
    0x16F4: "Vweb Corp",
    0x16F6: "VideoTele.com, Inc.",
    0x1702: "Internet Machines Corporation (IMC)",
    0x1705: "Digital First, Inc.",
    0x170B: "NetOctave",
    0x170C: "YottaYotta Inc.",
    0x1719: "EZChip Technologies",
    0x1725: "Vitesse Semiconductor",
    0x172A: "Accelerated Encryption",
    0x1734: "Fujitsu Technology Solutions",
    0x1735: "Aten International Co. Ltd.",
    0x1737: "Linksys",
    0x173B: "Altima (nee Broadcom)",
    0x1743: "Peppercon AG",
    0x1745: "ViXS Systems, Inc.",
    0x1749: "RLX Technologies",
    0x174B: "PC Partner Limited / Sapphire Technology",
    0x174D: "WellX Telecom SA",
    0x175C: "AudioScience Inc",
    0x175E: "Sanera Systems, Inc.",
    0x1760: "TEDIA spol. s r. o.",
    0x1761: "Pickering Interfaces Ltd",
    0x1771: "InnoVISION Multimedia Ltd.",
    0x1775: "General Electric",
    0x177D: "Cavium, Inc.",
    0x1787: "Hightech Information System Ltd.",
    0x1789: "Ennyah Technologies Corp.",
    0x1796: "Research Centre Juelich",
    0x1797: "Intersil Techwell",
    0x1799: "Belkin",
    0x179A: "id Quantique",
    0x179C: "Data Patterns",
    0x17A0: "Genesys Logic, Inc",
    0x17AA: "Lenovo",
    0x17AB: "Phillips Components",
    0x17AF: "Hightech Information System Ltd.",
    0x17B3: "Hawking Technologies",
    0x17B4: "Indra Networks, Inc.",
    0x17C0: "Wistron Corp.",
    0x17C2: "Newisys, Inc.",
    0x17C3: "Protogate, Inc.",
    0x17CB: "Qualcomm Technologies, Inc",
    0x17CC: "NetChip Technology, Inc",
    0x17CD: "Cadence Design Systems, Inc.",
    0x17CF: "Z-Com, Inc.",
    0x17D3: "Areca Technology Corp.",
    0x17D5: "Exar Corp.",
    0x17DB: "Cray Inc",
    0x17DE: "KWorld Computer Co. Ltd.",
    0x17DF: "Dini Group",
    0x17E4: "Sectra AB",
    0x17E6: "MaxLinear",
    0x17EE: "Connect Components Ltd",
    0x17F2: "Albatron Corp.",
    0x17F3: "RDC Semiconductor, Inc.",
    0x17F7: "Topdek Semiconductor Inc.",
    0x17F9: "Gemtek Technology Co., Ltd",
    0x17FC: "IOGEAR, Inc.",
    0x17FE: "InProComm Inc.",
    0x17FF: "Benq Corporation",
    0x1800: "Qualcore Logic Inc.",
    0x1803: "ProdaSafe GmbH",
    0x1804: "Ralink corp. (wrong ID)",
    0x1805: "Euresys S.A.",
    0x1809: "Lumanate, Inc.",
    0x180C: "IEI Integration Corp",
    0x1813: "Ambient Technologies Inc",
    0x1814: "Ralink corp.",
    0x1815: "Devolo AG",
    0x1820: "InfiniCon Systems Inc.",
    0x1822: "Twinhan Technology Co. Ltd",
    0x182D: "SiteCom Europe BV",
    0x182E: "Raza Microelectronics, Inc.",
    0x182F: "Broadcom",
    0x1830: "Credence Systems Corporation",
    0x183B: "MikroM GmbH",
    0x1846: "Alcatel-Lucent",
    0x1849: "ASRock Incorporation",
    0x184A: "Thales Computers",
    0x1850: "Advantest Corporation",
    0x1851: "Microtune, Inc.",
    0x1852: "Anritsu Corp.",
    0x1853: "SMSC Automotive Infotainment System Group",
    0x1854: "LG Electronics, Inc.",
    0x185B: "Compro Technology, Inc.",
    0x185F: "Wistron NeWeb Corp.",
    0x1864: "SilverBack",
    0x1867: "Topspin Communications",
    0x186C: "Humusoft, s.r.o.",
    0x186F: "WiNRADiO Communications",
    0x1876: "L-3 Communications",
    0x187E: "ZyXEL Communications Corporation",
    0x1885: "Avvida Systems Inc.",
    0x1888: "Varisys Ltd",
    0x188A: "Ample Communications, Inc",
    0x1890: "Egenera, Inc.",
    0x1894: "KNC One",
    0x1896: "B&B Electronics Manufacturing Company, Inc.",
    0x1897: "AMtek",
    0x18A1: "Astute Networks Inc.",
    0x18A2: "Stretch Inc.",
    0x18A3: "AT&T",
    0x18AC: "DViCO Corporation",
    0x18B8: "Ammasso",
    0x18BC: "GeCube Technologies, Inc.",
    0x18C3: "Micronas Semiconductor Holding AG",
    0x18C8: "Cray Inc",
    0x18C9: "ARVOO Engineering BV",
    0x18CA: "XGI Technology Inc. (eXtreme Graphics Innovation)",
    0x18D2: "Sitecom Europe BV (Wrong ID)",
    0x18D4: "Celestica",
    0x18D8: "Dialogue Technology Corp.",
    0x18DD: "Artimi Inc",
    0x18DF: "LeWiz Communications",
    0x18E6: "MPL AG",
    0x18EB: "Advance Multimedia Internet Technology, Inc.",
    0x18EC: "Cesnet, z.s.p.o.",
    0x18EE: "Chenming Mold Ind. Corp.",
    0x18F1: "Spectrum GmbH",
    0x18F4: "Napatech A/S",
    0x18F6: "NextIO",
    0x18F7: "Commtech, Inc.",
    0x18FB: "Resilience Corporation",
    0x1904: "Hangzhou Silan Microelectronics Co., Ltd.",
    0x1905: "Micronas USA, Inc.",
    0x1912: "Renesas Technology Corp.",
    0x1919: "Soltek Computer Inc.",
    0x1923: "Sangoma Technologies Corp.",
    0x1924: "Solarflare Communications",
    0x192A: "BiTMICRO Networks Inc.",
    0x192E: "TransDimension",
    0x1931: "Option N.V.",
    0x1932: "DiBcom",
    0x193C: "MAXIM Integrated Products",
    0x193D: "New H3C Technologies Co., Ltd.",
    0x193F: "AHA Products Group",
    0x1942: "ClearSpeed Technology plc",
    0x1947: "C-guys, Inc.",
    0x1948: "Alpha Networks Inc.",
    0x194A: "DapTechnology B.V.",
    0x1954: "One Stop Systems, Inc.",
    0x1957: "Freescale Semiconductor Inc",
    0x1958: "Faster Technology, LLC.",
    0x1959: "PA Semi, Inc",
    0x1966: "Orad Hi-Tec Systems",
    0x1969: "Qualcomm Atheros",
    0x196A: "Sensory Networks Inc.",
    0x196D: "Club-3D BV",
    0x196E: "PNY",
    0x1971: "AGEIA Technologies, Inc.",
    0x1974: "Star Electronics GmbH & Co. KG",
    0x1976: "TRENDnet",
    0x1977: "Parsec",
    0x197B: "JMicron Technology Corp.",
    0x1982: "Distant Early Warning Communications Inc",
    0x1987: "Phison Electronics Corporation",
    0x1989: "Montilio Inc.",
    0x198A: "Nallatech Ltd.",
    0x1993: "Innominate Security Technologies AG",
    0x1999: "A-Logics",
    0x199A: "Pulse-LINK, Inc.",
    0x199D: "Xsigo Systems",
    0x199F: "Auvitek",
    0x19A2: "Emulex Corporation",
    0x19A8: "DAQDATA GmbH",
    0x19AC: "Kasten Chase Applied Research",
    0x19AE: "Progeny Systems Corporation",
    0x19BA: "ZyXEL Communications Corp.",
    0x19C1: "Exegy Inc.",
    0x19D1: "Motorola Expedience",
    0x19D4: "Quixant Limited",
    0x19DA: "ZOTAC International (MCO) Ltd.",
    0x19DE: "Pico Computing",
    0x19E2: "Vector Informatik GmbH",
    0x19E3: "DDRdrive LLC",
    0x19E5: "Huawei Technologies Co., Ltd.",
    0x19E7: "NET (Network Equipment Technologies)",
    0x19EE: "Netronome Systems, Inc.",
    0x19F1: "BFG Tech",
    0x19FF: "Eclipse Electronic Systems, Inc.",
    0x1A03: "ASPEED Technology, Inc.",
    0x1A05: "deltaww",
    0x1A07: "Kvaser AB",
    0x1A08: "Sierra semiconductor",
    0x1A0D: "SEAKR Engineering",
    0x1A0E: "DekTec Digital Video B.V.",
    0x1A17: "Force10 Networks, Inc.",
    0x1A1D: "GFaI e.V.",
    0x1A1E: "3Leaf Systems, Inc.",
    0x1A22: "Ambric Inc.",
    0x1A29: "Fortinet, Inc.",
    0x1A2B: "Ascom AG",
    0x1A30: "Lantiq",
    0x1A32: "Quanta Microsystems, Inc",
    0x1A3B: "AzureWave",
    0x1A41: "Tilera Corp.",
    0x1A4A: "SLAC National Accelerator Lab TID-AIR",
    0x1A51: "Hectronic AB",
    0x1A55: "Rohde & Schwarz DVS GmbH",
    0x1A56: "Rivet Networks",
    0x1A57: "Highly Reliable Systems",
    0x1A58: "Razer USA Ltd.",
    0x1A5D: "Celoxica",
    0x1A5E: "Aprius Inc.",
    0x1A5F: "System TALKS Inc.",
    0x1A68: "VirtenSys Limited",
    0x1A71: "XenSource, Inc.",
    0x1A73: "Violin Memory, Inc",
    0x1A76: "Wavesat",
    0x1A77: "Lightfleet Corporation",
    0x1A78: "Virident Systems Inc.",
    0x1A84: "Commex Technologies",
    0x1A88: "MEN Mikro Elektronik",
    0x1A8A: "StarBridge, Inc.",
    0x1A8C: "Verigy Pte. Ltd.",
    0x1A8E: "DRS Technologies",
    0x1AA8: "Ciprico, Inc.",
    0x1AA9: "Schweitzer Engineering Laboratories",
    0x1AAE: "Global Velocity, Inc.",
    0x1AB4: "Distributed Management Task Force, Inc. (DMTF)",
    0x1AB6: "CalDigit, Inc.",
    0x1AB8: "Parallels, Inc.",
    0x1AB9: "Espia Srl",
    0x1AC1: "Global Unichip Corp.",
    0x1AC8: "Aeroflex Gaisler",
    0x1ACC: "Point of View BV",
    0x1AD7: "Spectracom Corporation",
    0x1ADE: "Spin Master Ltd.",
    0x1AE0: "Google, Inc.",
    0x1AE3: "SANBlaze Technology, Inc.",
    0x1AE7: "First Wise Media GmbH",
    0x1AE8: "Basler AG",
    0x1AE9: "Wilocity Ltd.",
    0x1AEA: "Alcor Micro",
    0x1AEC: "Wolfson Microelectronics",
    0x1AED: "SanDisk",
    0x1AEE: "Caustic Graphics Inc.",
    0x1AF4: "Red Hat, Inc.",
    0x1AF5: "Netezza Corp.",
    0x1AFA: "J & W Electronics Co., Ltd.",
    0x1B00: "Montage Technology Co., Ltd.",
    0x1B03: "Magnum Semiconductor, Inc,",
    0x1B08: "MSC Technologies GmbH",
    0x1B0A: "Pegatron",
    0x1B13: "Jaton Corp",
    0x1B1A: "K&F Computing Research Co.",
    0x1B1C: "Corsair",
    0x1B21: "ASMedia Technology Inc.",
    0x1B26: "Netcope Technologies, a.s.",
    0x1B2C: "Opal-RT Technologies Inc.",
    0x1B36: "Red Hat, Inc.",
    0x1B37: "Signal Processing Devices Sweden AB",
    0x1B39: "sTec, Inc.",
    0x1B3A: "Westar Display Technologies",
    0x1B3E: "Teradata Corp.",
    0x1B40: "Schooner Information Technology, Inc.",
    0x1B47: "Numascale AS",
    0x1B4B: "Marvell Technology Group Ltd.",
    0x1B4C: "GALAX",
    0x1B55: "NetUP Inc.",
    0x1B66: "DELTACAST",
    0x1B6F: "Etron Technology, Inc.",
    0x1B73: "Fresco Logic",
    0x1B74: "OpenVox Communication Co. Ltd.",
    0x1B79: "Absolute Analysis",
    0x1B85: "OCZ Technology Group, Inc.",
    0x1B94: "Signatec / Dynamic Signals Corp",
    0x1B96: "Western Digital",
    0x1B9A: "XAVi Technologies Corp.",
    0x1BAA: "QNAP Systems, Inc.",
    0x1BAD: "ReFLEX CES",
    0x1BB0: "SimpliVity Corporation",
    0x1BB1: "Seagate Technology PLC",
    0x1BB3: "Bluecherry",
    0x1BB5: "Quantenna Communications, Inc.",
    0x1BBF: "Maxeler Technologies Ltd.",
    0x1BC0: "Innodisk Corporation",
    0x1BCF: "NEC Corporation",
    0x1BD0: "Astronics Corporation",
    0x1BD4: "Inspur Electronic Information Industry Co., Ltd.",
    0x1BEE: "IXXAT Automation GmbH",
    0x1BEF: "Lantiq",
    0x1BF4: "VTI Instruments Corporation",
    0x1BFD: "EeeTOP",
    0x1C09: "CSP, Inc.",
    0x1C1C: "Symphony",
    0x1C1F: "SoftLab-NSK",
    0x1C28: "Lite-On IT Corp. / Plextor",
    0x1C2C: "Silicom Denmark",
    0x1C32: "Highland Technology, Inc.",
    0x1C33: "Daktronics, Inc",
    0x1C36: "Annapurna Labs Ltd.",
    0x1C3B: "Accensus, LLC",
    0x1C44: "Enmotus Inc",
    0x1C58: "HGST, Inc.",
    0x1C5C: "SK hynix",
    0x1C5F: "Beijing Memblaze Technology Co. Ltd.",
    0x1C63: "Science and Research Centre of Computer Technology (JSC 'NICEVT')",
    0x1C7E: "TTTech Computertechnik AG",
    0x1C7F: "Elektrobit Austria GmbH",
    0x1C8A: "TSF5 Corporation",
    0x1C8C: "Mobiveil, Inc.",
    0x1CB0: "Shannon Systems",
    0x1CB1: "Collion UG & Co.KG",
    0x1CB5: "Focusrite Audio Engineering Ltd",
    0x1CB8: "Dawning Information Industry Co., Ltd.",
    0x1CC1: "ADATA Technology Co., Ltd.",
    0x1CC4: "Shenzhen Unionmemory Information System Ltd.",
    0x1CC5: "Embedded Intelligence, Inc.",
    0x1CC7: "Radian Memory Systems Inc.",
    0x1CCF: "Zoom Corporation",
    0x1CD2: "SesKion GmbH",
    0x1CD7: "Nanjing Magewell Electronics Co., Ltd.",
    0x1CDD: "secunet Security Networks AG",
    0x1CE4: "Exablaze",
    0x1CF0: "Akitio",
    0x1CF7: "Subspace Dynamics",
    0x1CFA: "Corsair Memory, Inc",
    0x1D00: "Pure Storage",
    0x1D05: "Tongfang Hongkong Limited",
    0x1D0F: "Amazon.com, Inc.",
    0x1D17: "Zhaoxin",
    0x1D18: "RME",
    0x1D1C: "Barefoot Networks, Inc.",
    0x1D1D: "CNEX Labs",
    0x1D21: "Allo",
    0x1D22: "Baidu Technology",
    0x1D26: "Kalray Inc.",
    0x1D37: "NovaSparks",
    0x1D40: "Techman Electronics (Changshu) Co., Ltd.",
    0x1D44: "DPT",
    0x1D49: "Lenovo",
    0x1D4C: "Diamanti, Inc.",
    0x1D5C: "Fantasia Trading LLC",
    0x1D61: "Technobox, Inc.",
    0x1D62: "Nebbiolo Technologies",
    0x1D65: "Imagine Communications Corp.",
    0x1D69: "Celeno Communications",
    0x1D6A: "Aquantia Corp.",
    0x1D6C: "Atomic Rules LLC",
    0x1D72: "Xiaomi",
    0x1D78: "DERA Storage",
    0x1D79: "Transcend Information, Inc.",
    0x1D7C: "Aerotech, Inc.",
    0x1D82: "NETINT Technologies Inc.",
    0x1D87: "Rockchip Electronics Co., Ltd",
    0x1D89: "YEESTOR Microelectronics Co., Ltd",
    0x1D8F: "Enyx",
    0x1D92: "Abaco Systems Inc.",
    0x1D93: "YADRO",
    0x1D94: "Chengdu Haiguang IC Design Co., Ltd.",
    0x1D95: "Graphcore Ltd",
    0x1D97: "Shenzhen Longsys Electronics Co., Ltd.",
    0x1D9B: "Meta Platforms, Inc.",
    0x1DA1: "Teko Telecom S.r.l.",
    0x1DA2: "Sapphire Technology Limited",
    0x1DA3: "Habana Labs Ltd.",
    0x1DA8: "Corigine, Inc.",
    0x1DAD: "Fungible",
    0x1DB2: "ATP ELECTRONICS INC",
    0x1DB7: "Phytium Technology Co., Ltd.",
    0x1DBB: "NGD Systems, Inc.",
    0x1DBE: "INNOGRIT Corporation",
    0x1DBF: "Guizhou Huaxintong Semiconductor Technology Co., Ltd",
    0x1DC2: "Alco Digital Devices Limited",
    0x1DC5: "FADU Inc.",
    0x1DCD: "Liqid Inc.",
    0x1DCF: "Beijing Sinead Technology Co., Ltd.",
    0x1DD3: "Sage Microelectronics Corp.",
    0x1DD4: "Swissbit AG",
    0x1DD8: "AMD Pensando Systems",
    0x1DDD: "Thorlabs",
    0x1DE0: "Groq",
    0x1DE1: "Tekram Technology Co.,Ltd.",
    0x1DE5: "Eideticom, Inc",
    0x1DED: "Alibaba (China) Co., Ltd.",
    0x1DEE: "Biwin Storage Technology Co., Ltd.",
    0x1DEF: "Ampere Computing, LLC",
    0x1DF3: "Ethernity Networks",
    0x1DF7: "opencpi.org",
    0x1DF8: "V&G Information System Co.,Ltd",
    0x1DFC: "JSC NT-COM",
    0x1E0F: "KIOXIA Corporation",
    0x1E17: "Arnold & Richter Cine Technik GmbH & Co. Betriebs KG",
    0x1E24: "Squirrels Research Labs",
    0x1E26: "Fujitsu Client Computing Limited",
    0x1E36: "Shanghai Enflame Technology Co. Ltd",
    0x1E38: "Blaize, Inc",
    0x1E39: "MEDION AG",
    0x1E3B: "DapuStor Corporation",
    0x1E3D: "Burlywood, Inc",
    0x1E44: "Valve Software",
    0x1E49: "Yangtze Memory Technologies Co.,Ltd",
    0x1E4B: "MAXIO Technology (Hangzhou) Ltd.",
    0x1E4C: "GSI Technology",
    0x1E50: "IP3 Tech (HK) Limited",
    0x1E57: "Beijing Panyi Technology Co., Ltd",
    0x1E59: "Oxford Nanopore Technologies",
    0x1E5D: "ASR Microelectronics",
    0x1E60: "Hailo Technologies Ltd.",
    0x1E67: "Untether AI",
    0x1E68: "Jiangsu Xinsheng Intelligent Technology Co., Ltd",
    0x1E6B: "Axiado Corp.",
    0x1E7B: "Dataland",
    0x1E7C: "Brainchip Inc",
    0x1E7E: "Pliops",
    0x1E7F: "Jiangsu Huacun Elec. Tech. Co., Ltd.",
    0x1E81: "Ramaxel Technology(Shenzhen) Limited",
    0x1E83: "Huaqin Technology Co.Ltd",
    0x1E85: "Heitec AG",
    0x1E89: "ID Quantique SA",
    0x1E93: "Beijing Bytedance Network Technology Co., Ltd.",
    0x1E94: "Calian SED",
    0x1E95: "Solid State Storage Technology Corporation",
    0x1E9F: "Lynxi Technologies Co., Ltd.",
    0x1EA0: "Tencent Technology (Shenzhen) Company Limited",
    0x1EA7: "Intelliprop, Inc",
    0x1EAB: "Hefei DATANG Storage Technology Co.,LTD.",
    0x1EAC: "Quectel Wireless Solutions Co., Ltd.",
    0x1EAE: "XFX Limited",
    0x1EB1: "VeriSilicon Inc",
    0x1EB4: "Quantum Nebula Microelectronics Technology Co.,Ltd.",
    0x1EBD: "EMERGETECH Company Ltd.",
    0x1EC8: "Innosilicon Co Ltd",
    0x1EC9: "Wingtech Group(HongKong)Limited",
    0x1ECA: "Lightmatter",
    0x1ED2: "FuriosaAI, Inc.",
    0x1ED3: "Yeston",
    0x1ED5: "Moore Threads Technology Co.,Ltd",
    0x1ED8: "Digiteq Automotive",
    0x1ED9: "Myrtle.ai",
    0x1EE1: "Suzhou Kuhan Information Technologies",
    0x1EE4: "PETAIO INC",
    0x1EE9: "SUSE LLC",
    0x1EEC: "Viscore Technologies Ltd",
    0x1EED: "XDX Computing Technology Ltd.",
    0x1EF6: "GrAI Matter Labs",
    0x1EF7: "Shenzhen Gunnir Technology Development Co., Ltd",
    0x1EFB: "Flexxon Pte Ltd",
    0x1F02: "Beijing Dayu Technology",
    0x1F03: "Shenzhen Shichuangyi Electronics Co., Ltd",
    0x1F0F: "NebulaMatrix Technology",
    0x1F24: "xFusion Digital Technologies Co., Ltd.",
    0x1F2F: "China Mobile (Hangzhou) Information Technology Co.Ltd.",
    0x1F3F: "3SNIC Ltd",
    0x1F40: "Netac Technology Co.,Ltd",
    0x1F44: "VVDN Technologies Private Limited",
    0x1F4B: "Axera Semiconductor Co., Ltd",
    0x1F52: "MangoBoost Inc.",
    0x1F60: "Accelecom",
    0x1FAA: "Hexaflake (Shanghai) Information Technology Co., Ltd.",
    0x1FAB: "Unifabrix Ltd.",
    0x1FC0: "Ascom (Finland) Oy",
    0x1FC1: "QLogic, Corp.",
    0x1FC9: "Tehuti Networks Ltd.",
    0x1FCC: "StreamLabs",
    0x1FCE: "Cognio Inc.",
    0x1FD4: "SUNIX Co., Ltd.",
    0x2000: "Smart Link Ltd.",
    0x2001: "Temporal Research Ltd",
    0x2003: "Smart Link Ltd.",
    0x2004: "Smart Link Ltd.",
    0x2048: "Beijing SpaceControl Technology Co.Ltd",
    0x20F4: "TRENDnet",
    0x2116: "ZyDAS Technology Corp.",
    0x21B4: "Hunan Goke Microelectronics Co., Ltd",
    0x21C3: "21st Century Computer Corp.",
    0x22B8: "Flex-Logix Technologies",
    0x22DB: "Missing Link Electronics, Inc.",
    0x2304: "Colorgraphic Communications Corp.",
    0x2348: "Racore",
    0x2646: "Kingston Technology Company, Inc.",
    0x270B: "Xantel Corporation",
    0x270F: "Chaintech Computer Co. Ltd",
    0x2711: "AVID Technology Inc.",
    0x2782: "Emdoor Digital Technology Co., Ltd",
    0x2955: "Connectix Virtual PC",
    0x2A15: "3D Vision(???)",
    0x2A18: "Video Transcode Controller",
    0x2BD8: "ROPEX Industrie-Elektronik GmbH",
    0x3000: "Hansol Electronics Inc.",
    0x3112: "Satelco Ingenieria S.A.",
    0x3130: "AUDIOTRAK",
    0x3142: "Post Impression Systems.",
    0x31AB: "Zonet",
    0x3388: "Hint Corp",
    0x3411: "Quantum Designs (H.K.) Inc",
    0x3442: "Bihl+Wiedemann GmbH",
    0x3475: "Arista Networks, Inc.",
    0x34BA: "Ice Lake-LP PCI Express Root Port #3",
    0x3513: "ARCOM Control Systems Ltd",
    0x37D9: "ITD Firm ltd.",
    0x3842: "eVga.com. Corp.",
    0x38EF: "4Links",
    0x3D3D: "3DLabs",
    0x4005: "Avance Logic Inc.",
    0x4033: "Addtron Technology Co, Inc.",
    0x4040: "NetXen Incorporated",
    0x4143: "Digital Equipment Corp",
    0x4144: "Alpha Data",
    0x4150: "ONA Electroerosion",
    0x415A: "Auzentech, Inc.",
    0x416C: "Aladdin Knowledge Systems",
    0x4242: "Universall Answer Generators",
    0x4254: "DVBSky",
    0x4321: "Tata Power Strategic Electronics Division",
    0x4348: "WCH.CN",
    0x434E: "Cornelis Networks",
    0x4444: "Internext Compression Inc",
    0x4468: "Bridgeport machines",
    0x4594: "Cogetec Informatique Inc",
    0x45FB: "Baldor Electric Company",
    0x4624: "Budker Institute of Nuclear Physics",
    0x4651: "TXIC",
    0x4680: "Umax Computer Corp",
    0x4843: "Hercules Computer Technology Inc",
    0x4916: "RedCreek Communications Inc",
    0x4943: "Growth Networks",
    0x494F: "ACCES I/O Products, Inc.",
    0x4978: "Axil Computer Inc",
    0x4A14: "NetVin",
    0x4B10: "Buslogic Inc.",
    0x4C48: "LUNG HWA Electronics",
    0x4C52: "LR-Link",
    0x4C53: "SBS Technologies",
    0x4CA1: "Seanix Technology Inc",
    0x4D51: "MediaQ Inc.",
    0x4D54: "Microtechnica Co Ltd",
    0x4D56: "MATRIX VISION GmbH",
    0x4DDC: "ILC Data Device Corp",
    0x4E58: "Nutanix, Inc.",
    0x5045: "University of Toronto",
    0x5046: "GemTek Technology Corporation",
    0x5053: "Voyetra Technologies",
    0x50B2: "TerraTec Electronic GmbH",
    0x5136: "S S Technologies",
    0x5143: "Qualcomm Inc",
    0x5145: "Ensoniq (Old)",
    0x5168: "Animation Technologies Inc.",
    0x5301: "Alliance Semiconductor Corp.",
    0x5333: "S3 Graphics Ltd.",
    0x5431: "AuzenTech, Inc.",
    0x544C: "Teralogic Inc",
    0x544D: "TBS Technologies",
    0x5452: "SCANLAB AG",
    0x5455: "Technische Universitaet Berlin",
    0x5456: "GoTView",
    0x5519: "Cnet Technologies, Inc.",
    0x5544: "Dunord Technologies",
    0x5555: "Genroco, Inc",
    0x5646: "Vector Fabrics BV",
    0x5654: "VoiceTronix Pty Ltd",
    0x5678: "Dawicontrol Computersysteme GmbH",
    0x5700: "Netpower",
    0x5845: "X-ES, Inc.",
    0x584D: "AuzenTech Co., Ltd.",
    0x5851: "Exacq Technologies",
    0x5853: "XenSource, Inc.",
    0x5854: "GoTView",
    0x5ACE: "Beholder International Ltd.",
    0x6205: "TBS Technologies (wrong ID)",
    0x6209: "TBS Technologies (wrong ID)",
    0x631C: "SmartInfra Ltd",
    0x6356: "UltraStor",
    0x6374: "c't Magazin fuer Computertechnik",
    0x6409: "Logitec Corp.",
    0x6549: "Teradici Corp.",
    0x6666: "Decision Computer International Co.",
    0x6688: "Zycoo Co., Ltd",
    0x6766: "Glenfly Tech Co., Ltd.",
    0x6899: "ZT Systems",
    0x6900: "Red Hat, Inc.",
    0x7063: "pcHDTV",
    0x7284: "HT OMEGA Inc.",
    0x7357: "IOxOS Technologies SA",
    0x7377: "Shenzhen Colorful Yugong Technology and Development Co.",
    0x7401: "EndRun Technologies",
    0x7470: "TP-LINK Technologies Co., Ltd.",
    0x7526: "HongQin (Beijing) Technology Co., Ltd.",
    0x7604: "O.N. Electronic Co Ltd.",
    0x78C0: "Herrick Technology Laboratories, Inc. [HTL]",
    0x7BDE: "MIDAC Corporation",
    0x7FED: "PowerTV",
    0x8008: "Quancom Electronic GmbH",
    0x807D: "Asustek Computer, Inc.",
    0x8086: "Intel Corporation",
    0x8088: "Beijing Wangxun Technology Co., Ltd.",
    0x80EE: "InnoTek Systemberatung GmbH",
    0x8322: "Sodick America Corp.",
    0x8384: "SigmaTel",
    0x8401: "TRENDware International Inc.",
    0x8686: "SAP",
    0x8800: "Trigem Computer Inc.",
    0x8820: "Stryker Corporation",
    0x8848: "MUCSE",
    0x8866: "T-Square Design Inc.",
    0x8888: "Silicon Magic",
    0x8912: "TRX",
    0x8C4A: "Winbond",
    0x8E0E: "Computone Corporation",
    0x8E2E: "KTI",
    0x9004: "Adaptec",
    0x9005: "Adaptec",
    0x907F: "Atronics",
    0x919A: "Gigapixel Corp",
    0x9412: "Holtek",
    0x9413: "Softlogic Co., Ltd.",
    0x9618: "JusonTech Corporation",
    0x9699: "Omni Media Technology Inc",
    0x9710: "MosChip Semiconductor Technology Ltd.",
    0x9850: "3Com (wrong ID)",
    0x9902: "Stargen Inc.",
    0x9A11: "Tiger Lake-H Gaussian & Neural Accelerator",
    0x9D32: "Beijing Starblaze Technology Co. Ltd.",
    0xC: "ff  Unassigned class",
    0xA000: "Asix Electronics Corporation (Wrong ID)",
    0xA0A0: "AOPEN Inc.",
    0xA0F1: "UNISYS Corporation",
    0xA200: "NEC Corporation",
    0xA259: "Hewlett Packard",
    0xA25B: "Hewlett Packard GmbH PL24-MKT",
    0xA304: "Sony",
    0xA727: "3Com Corporation",
    0xAA00: "iTuner",
    0xAA01: "iTuner",
    0xAA02: "iTuner",
    0xAA03: "iTuner",
    0xAA04: "iTuner",
    0xAA05: "iTuner",
    0xAA06: "iTuner",
    0xAA07: "iTuner",
    0xAA08: "iTuner",
    0xAA09: "iTuner",
    0xAA0A: "iTuner",
    0xAA0B: "iTuner",
    0xAA0C: "iTuner",
    0xAA0D: "iTuner",
    0xAA0E: "iTuner",
    0xAA0F: "iTuner",
    0xAA42: "Scitex Digital Video",
    0xAA55: "Ncomputing X300 PCI-Engine",
    0xAAAA: "Adnaco Technology Inc.",
    0xABCD: "Vadatech Inc.",
    0xAC1E: "Digital Receiver Technology Inc",
    0xAC3D: "Actuality Systems",
    0xAD00: "Alta Data Technologies LLC",
    0xAECB: "Adrienne Electronics Corporation",
    0xAFFE: "Sirrix AG security technologies",
    0xB100: "OpenVox Communication Co. Ltd.",
    0xB10B: "Uakron PCI Project",
    0xB1B3: "Shiva Europe Limited",
    0xB1D9: "ATCOM Technology co., LTD.",
    0xBD11: "Pinnacle Systems, Inc. (Wrong ID)",
    0xBDBD: "Blackmagic Design",
    0xC001: "TSI Telsys",
    0xC0A9: "Micron/Crucial Technology",
    0xC0DE: "Motorola",
    0xC0FE: "Motion Engineering, Inc.",
    0xCA01: "I-TEK OptoElectronics Co., LTD.",
    0xCA02: "I-TEK OptoElectronics Co., LTD.",
    0xCA3B: "Cambrionix Ltd.",
    0xCA50: "Varian Australia Pty Ltd",
    0xCACE: "CACE Technologies, Inc.",
    0xCAED: "Canny Edge",
    0xCAFE: "Chrysalis-ITS",
    0xCC53: "ScaleFlux Inc.",
    0xCCCC: "Catapult Communications",
    0xCCEC: "Curtiss-Wright Controls Embedded Computing",
    0xCDDD: "Tyzx, Inc.",
    0xCEBA: "KEBA AG",
    0xCF86: "Spectrum-4TOR",
    0xD063: "SolidRun",
    0xD161: "Digium, Inc.",
    0xD209: "Ultimarc",
    0xD4D4: "Dy4 Systems Inc",
    0xD531: "I+ME ACTIA GmbH",
    0xD84D: "Exsys",
    0xDADA: "Datapath Limited",
    0xDB10: "Diablo Technologies",
    0xDC93: "Dawicontrol GmbH",
    0xDCBA: "Dynamic Engineering",
    0xDD01: "Digital Devices GmbH",
    0xDEAD: "Indigita Corporation",
    0xDEAF: "Middle Digital Inc.",
    0xDEDA: "XIMEA",
    0xE000: "Winbond",
    0xE159: "Tiger Jet Network Inc. / ICP DAS",
    0xE1C5: "Elcus",
    0xE4BF: "EKF Elektronik GmbH",
    0xE4E4: "Xorcom",
    0xE55E: "Essence Technology, Inc.",
    0xEA01: "Eagle Technology",
    0xEA50: "Emerson Automation Solutions",
    0xEA60: "RME",
    0xEABB: "Aashima Technology B.V.",
    0xEACE: "Endace Measurement Systems, Ltd",
    0xEC80: "Belkin Corporation",
    0xECC0: "Echo Digital Audio Corporation",
    0xEDD8: "ARK Logic Inc",
    0xF043: "ASUSTeK Computer Inc. (Wrong ID)",
    0xF05B: "Foxconn International, Inc. (Wrong ID)",
    0xF15E: "SiFive, Inc.",
    0xF1D0: "AJA Video",
    0xF5F5: "F5 Networks, Inc.",
    0xF849: "ASRock Incorporation (Wrong ID)",
    0xFA57: "Interagon AS",
    0xFAB7: "Fabric7 Systems, Inc.",
    0xFEBD: "Ultraview Corp.",
    0xFEDA: "Broadcom Inc",
    0xFEDE: "Fedetec Inc.",
    0xFFFD: "XenSource, Inc.",
    0xFFFE: "VMWare Inc (temporary ID)",
    0xFFFF: "Illegal Vendor ID",
}


DEVICES = {

    # Loongson Technology LLC
    0x0014: {0x7A00: "Hyper Transport Bridge Controller",
             0x7A02: "APB (Advanced Peripheral Bus) Controller",
             0x7A03: "Gigabit Ethernet Controller",
             0x7A04: "OTG USB Controller",
             0x7A05: "Vivante GPU (Graphics Processing Unit)",
             0x7A06: "DC (Display Controller)",
             0x7A07: "HDA (High Definition Audio) Controller",
             0x7A08: "SATA AHCI Controller",
             0x7A09: "PCI-to-PCI Bridge",
             0x7A0B: "SPI Controller",
             0x7A0C: "LPC Controller",
             0x7A0F: "DMA (Direct Memory Access) Controller",
             0x7A10: "Hyper Transport Bridge Controller",
             0x7A14: "EHCI USB Controller",
             0x7A15: "Vivante GPU (Graphics Processing Unit)",
             0x7A19: "PCI-to-PCI Bridge",
             0x7A24: "OHCI USB Controller",
             0x7A29: "PCI-to-PCI Bridge",
             },

    # Oxide Computer Company
    0x01DE: {0x0000: "Propolis NVMe Controller",
             0x0001: "Propolis xHCI Controller",
             0x0002: "Propolis PCI-PCI Bridge",
             },

    # Solidigm
    0x025E: {0x0B60: "NVMe DC SSD [Sentinel Rock Plus controller]",
             0x0B70: "NVMe DC SSD [Yorktown controller]",
             },

    # Dynalink
    0x0675: {0x1700: "IS64PH ISDN Adapter",
             0x1702: "IS64PH ISDN Adapter",
             0x1703: "ISDN Adapter (PCI Bus, DV, W)",
             0x1704: "ISDN Adapter (PCI Bus, D, C)",
             },

    # Jingjia Microelectronics Co Ltd
    0x0731: {0x7200: "JM7200 Series GPU",
             0x9100: "JM9100",
             0x910A: "JH910",
             0x9200: "JM9200",
             0x920A: "JH920",
             0x920B: "JH920-I",
             0x920C: "JH920-M",
             0x9210: "JM9210",
             0x9211: "JM9210-I",
             0x9230: "JM9230",
             0x9231: "JM9231-I",
             0x9250: "JM9250",
             0x930A: "JH930-I",
             0x930B: "JH930-M",
             },

    # Wired Inc.
    0x0795: {0x6663: "Butane II (MPEG2 encoder board)",
             0x6666: "MediaPress (MPEG2 encoder board)",
             },

    # Rhino Equipment Corp.
    0x0B0B: {0x0105: "R1T1",
             0x0205: "R4FXO",
             0x0206: "RCB4FXO 4-channel FXO analog telephony card",
             0x0305: "R4T1",
             0x0405: "R8FXX",
             0x0406: "RCB8FXX 8-channel modular analog telephony card",
             0x0505: "R24FXX",
             0x0506: "RCB24FXS 24-Channel FXS analog telephony card",
             0x0605: "R2T1",
             0x0705: "R24FXS",
             0x0706: "RCB24FXO 24-Channel FXO analog telephony card",
             0x0905: "R1T3 Single T3 Digital Telephony Card",
             0x0906: "RCB24FXX 24-channel modular analog telephony card",
             0x0A06: "RCB672FXX 672-channel modular analog telephony card",
             },

    # Compaq Computer Corporation
    0x0E11: {0x0001: "PCI to EISA Bridge",
             0x0002: "PCI to ISA Bridge",
             0x0046: "Smart Array 64xx",
             0x0049: "NC7132 Gigabit Upgrade Module",
             0x004A: "NC6136 Gigabit Server Adapter",
             0x005A: "Remote Insight II board - Lights-Out",
             0x007C: "NC7770 1000BaseTX",
             0x007D: "NC6770 1000BaseTX",
             0x0085: "NC7780 1000BaseTX",
             0x00B1: "Remote Insight II board - PCI device",
             0x00BB: "NC7760",
             0x00CA: "NC7771",
             0x00CB: "NC7781",
             0x00CF: "NC7772",
             0x00D0: "NC7782",
             0x00D1: "NC7783",
             0x00E3: "NC7761",
             0x0508: "Netelligent 4/16 Token Ring",
             0x1000: "Triflex/Pentium Bridge, Model 1000",
             0x2000: "Triflex/Pentium Bridge, Model 2000",
             0x3032: "QVision 1280/p",
             0x3033: "QVision 1280/p",
             0x3034: "QVision 1280/p",
             0x4000: "4000 [Triflex]",
             0x4040: "Integrated Array",
             0x4048: "Compaq Raid LC2",
             0x4050: "Smart Array 4200",
             0x4051: "Smart Array 4250ES",
             0x4058: "Smart Array 431",
             0x4070: "Smart Array 5300",
             0x4080: "Smart Array 5i",
             0x4082: "Smart Array 532",
             0x4083: "Smart Array 5312",
             0x4091: "Smart Array 6i",
             0x409A: "Smart Array 641",
             0x409B: "Smart Array 642",
             0x409C: "Smart Array 6400",
             0x409D: "Smart Array 6400 EM",
             0x6010: "HotPlug PCI Bridge 6010",
             0x7020: "USB Controller",
             0xA0EC: "Fibre Channel Host Controller",
             0xA0F0: "Advanced System Management Controller",
             0xA0F3: "Triflex PCI to ISA Bridge",
             0xA0F7: "PCI Hotplug Controller",
             0xA0F8: "ZFMicro Chipset USB",
             0xA0FC: "FibreChannel HBA Tachyon",
             0xAE10: "Smart-2/P RAID Controller",
             0xAE29: "MIS-L",
             0xAE2A: "MPC",
             0xAE2B: "MIS-E",
             0xAE31: "System Management Controller",
             0xAE32: "Netelligent 10/100 TX PCI UTP",
             0xAE33: "Triflex Dual EIDE Controller",
             0xAE34: "Netelligent 10 T PCI UTP",
             0xAE35: "Integrated NetFlex-3/P",
             0xAE40: "Netelligent Dual 10/100 TX PCI UTP",
             0xAE43: "Netelligent Integrated 10/100 TX UTP",
             0xAE69: "CETUS-L",
             0xAE6C: "Northstar",
             0xAE6D: "NorthStar CPU to PCI Bridge",
             0xB011: "Netelligent 10/100 TX Embedded UTP",
             0xB012: "Netelligent 10 T/2 PCI UTP/Coax",
             0xB01E: "NC3120 Fast Ethernet NIC",
             0xB01F: "NC3122 Fast Ethernet NIC",
             0xB02F: "NC1120 Ethernet NIC",
             0xB030: "Netelligent 10/100 TX UTP",
             0xB04A: "10/100 TX PCI Intel WOL UTP Controller",
             0xB060: "Smart Array 5300 Controller",
             0xB0C6: "NC3161 Fast Ethernet NIC",
             0xB0C7: "NC3160 Fast Ethernet NIC",
             0xB0D7: "NC3121 Fast Ethernet NIC",
             0xB0DD: "NC3131 Fast Ethernet NIC",
             0xB0DE: "NC3132 Fast Ethernet Module",
             0xB0DF: "NC6132 Gigabit Module",
             0xB0E0: "NC6133 Gigabit Module",
             0xB0E1: "NC3133 Fast Ethernet Module",
             0xB123: "NC6134 Gigabit NIC",
             0xB134: "NC3163 Fast Ethernet NIC",
             0xB13C: "NC3162 Fast Ethernet NIC",
             0xB144: "NC3123 Fast Ethernet NIC",
             0xB163: "NC3134 Fast Ethernet NIC",
             0xB164: "NC3165 Fast Ethernet Upgrade Module",
             0xB178: "Smart Array 5i/532",
             0xB1A4: "NC7131 Gigabit Server Adapter",
             0xB200: "Memory Hot-Plug Controller",
             0xB203: "Integrated Lights Out Controller",
             0xB204: "Integrated Lights Out  Processor",
             0xC000: "Remote Insight Lights-Out Edition",
             0xF130: "NetFlex-3/P ThunderLAN 1.0",
             0xF150: "NetFlex-3/P ThunderLAN 2.3",
             },

    # Broadcom / LSI
    0x1000: {0x0001: "53c810",
             0x0002: "53c820",
             0x0003: "53c825",
             0x0004: "53c815",
             0x0005: "53c810AP",
             0x0006: "53c860",
             0x000A: "53c1510",
             0x000B: "53C896/897",
             0x000C: "53c895",
             0x000D: "53c885",
             0x000F: "53c875",
             0x0010: "53C1510",
             0x0012: "53c895a",
             0x0013: "53c875a",
             0x0014: "MegaRAID Tri-Mode SAS3516",
             0x0015: "MegaRAID Tri-Mode SAS3416",
             0x0016: "MegaRAID Tri-Mode SAS3508",
             0x0017: "MegaRAID Tri-Mode SAS3408",
             0x001B: "MegaRAID Tri-Mode SAS3504",
             0x001C: "MegaRAID Tri-Mode SAS3404",
             0x0020: "53c1010 Ultra3 SCSI Adapter",
             0x0021: "53c1010 66MHz  Ultra3 SCSI Adapter",
             0x002F: "MegaRAID SAS 2208 IOV [Thunderbolt]",
             0x0030: "53c1030 PCI-X Fusion-MPT Dual Ultra320 SCSI",
             0x0031: "53c1030ZC PCI-X Fusion-MPT Dual Ultra320 SCSI",
             0x0032: "53c1035 PCI-X Fusion-MPT Dual Ultra320 SCSI",
             0x0033: "1030ZC_53c1035 PCI-X Fusion-MPT Dual Ultra320 SCSI",
             0x0040: "53c1035 PCI-X Fusion-MPT Dual Ultra320 SCSI",
             0x0041: "53C1035ZC PCI-X Fusion-MPT Dual Ultra320 SCSI",
             0x0050: "SAS1064 PCI-X Fusion-MPT SAS",
             0x0052: "MegaRAID SAS-3 3216/3224 [Cutlass]",
             0x0053: "MegaRAID SAS-3 3216/3224 [Cutlass]",
             0x0054: "SAS1068 PCI-X Fusion-MPT SAS",
             0x0055: "SAS1068 PCI-X Fusion-MPT SAS",
             0x0056: "SAS1064ET PCI-Express Fusion-MPT SAS",
             0x0057: "M1064E MegaRAID SAS",
             0x0058: "SAS1068E PCI-Express Fusion-MPT SAS",
             0x0059: "MegaRAID SAS 8208ELP/8208ELP",
             0x005A: "SAS1066E PCI-Express Fusion-MPT SAS",
             0x005B: "MegaRAID SAS 2208 [Thunderbolt]",
             0x005C: "SAS1064A PCI-X Fusion-MPT SAS",
             0x005D: "MegaRAID SAS-3 3108 [Invader]",
             0x005E: "SAS1066 PCI-X Fusion-MPT SAS",
             0x005F: "MegaRAID SAS-3 3008 [Fury]",
             0x0060: "MegaRAID SAS 1078",
             0x0062: "SAS1078 PCI-Express Fusion-MPT SAS",
             0x0064: "SAS2116 PCI-Express Fusion-MPT SAS-2 [Meteor]",
             0x0065: "SAS2116 PCI-Express Fusion-MPT SAS-2 [Meteor]",
             0x006E: "SAS2308 PCI-Express Fusion-MPT SAS-2",
             0x0070: "SAS2004 PCI-Express Fusion-MPT SAS-2 [Spitfire]",
             0x0071: "MR SAS HBA 2004",
             0x0072: "SAS2008 PCI-Express Fusion-MPT SAS-2 [Falcon]",
             0x0073: "MegaRAID SAS 2008 [Falcon]",
             0x0074: "SAS2108 PCI-Express Fusion-MPT SAS-2 [Liberator]",
             0x0076: "SAS2108 PCI-Express Fusion-MPT SAS-2 [Liberator]",
             0x0077: "SAS2108 PCI-Express Fusion-MPT SAS-2 [Liberator]",
             0x0079: "MegaRAID SAS 2108 [Liberator]",
             0x007C: "MegaRAID SAS 1078DE",
             0x007E: "SSS6200 PCI-Express Flash SSD",
             0x0080: "SAS2208 PCI-Express Fusion-MPT SAS-2",
             0x0081: "SAS2208 PCI-Express Fusion-MPT SAS-2",
             0x0082: "SAS2208 PCI-Express Fusion-MPT SAS-2",
             0x0083: "SAS2208 PCI-Express Fusion-MPT SAS-2",
             0x0084: "SAS2208 PCI-Express Fusion-MPT SAS-2",
             0x0085: "SAS2208 PCI-Express Fusion-MPT SAS-2",
             0x0086: "SAS2308 PCI-Express Fusion-MPT SAS-2",
             0x0087: "SAS2308 PCI-Express Fusion-MPT SAS-2",
             0x008F: "53c875J",
             0x0090: "SAS3108 PCI-Express Fusion-MPT SAS-3",
             0x0091: "SAS3108 PCI-Express Fusion-MPT SAS-3",
             0x0094: "SAS3108 PCI-Express Fusion-MPT SAS-3",
             0x0095: "SAS3108 PCI-Express Fusion-MPT SAS-3",
             0x0096: "SAS3004 PCI-Express Fusion-MPT SAS-3",
             0x0097: "SAS3008 PCI-Express Fusion-MPT SAS-3",
             0x00A5: "Fusion-MPT 24GSAS/PCIe SAS40xx",
             0x00AB: "SAS3516 Fusion-MPT Tri-Mode RAID On Chip (ROC)",
             0x00AC: "SAS3416 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)",
             0x00AE: "SAS3508 Fusion-MPT Tri-Mode RAID On Chip (ROC)",
             0x00AF: "SAS3408 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)",
             0x00B2: "PCIe Switch management endpoint",
             0x00BE: "SAS3504 Fusion-MPT Tri-Mode RAID On Chip (ROC)",
             0x00BF: "SAS3404 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)",
             0x00C0: "SAS3324 PCI-Express Fusion-MPT SAS-3",
             0x00C1: "SAS3324 PCI-Express Fusion-MPT SAS-3",
             0x00C2: "SAS3324 PCI-Express Fusion-MPT SAS-3",
             0x00C3: "SAS3324 PCI-Express Fusion-MPT SAS-3",
             0x00C4: "SAS3224 PCI-Express Fusion-MPT SAS-3",
             0x00C5: "SAS3316 PCI-Express Fusion-MPT SAS-3",
             0x00C6: "SAS3316 PCI-Express Fusion-MPT SAS-3",
             0x00C7: "SAS3316 PCI-Express Fusion-MPT SAS-3",
             0x00C8: "SAS3316 PCI-Express Fusion-MPT SAS-3",
             0x00C9: "SAS3216 PCI-Express Fusion-MPT SAS-3",
             0x00CE: "MegaRAID SAS-3 3316 [Intruder]",
             0x00CF: "MegaRAID SAS-3 3324 [Intruder]",
             0x00D0: "SAS3716 Fusion-MPT Tri-Mode RAID Controller Chip (ROC)",
             0x00D1: "SAS3616 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)",
             0x00D3: "MegaRAID Tri-Mode SAS3716W",
             0x00E0: "Fusion-MPT 12GSAS/PCIe Unsupported SAS39xx",
             0x00E1: "Fusion-MPT 12GSAS/PCIe SAS39xx",
             0x00E2: "Fusion-MPT 12GSAS/PCIe Secure SAS39xx",
             0x00E3: "Fusion-MPT 12GSAS/PCIe Unsupported SAS39xx",
             0x00E4: "Fusion-MPT 12GSAS/PCIe Unsupported SAS38xx",
             0x00E5: "Fusion-MPT 12GSAS/PCIe SAS38xx",
             0x00E6: "Fusion-MPT 12GSAS/PCIe Secure SAS38xx",
             0x00E7: "Fusion-MPT 12GSAS/PCIe Unsupported SAS38xx",
             0x02B0: "Virtual Endpoint on PCIe Switch",
             0x02B1: "Virtual Endpoint on PCIe Switch (9749)",
             0x02B2: "Virtual PCIe Placeholder Endpoint",
             0x0407: "MegaRAID",
             0x0408: "MegaRAID",
             0x0409: "MegaRAID",
             0x0411: "MegaRAID SAS 1068",
             0x0413: "MegaRAID SAS 1068 [Verde ZCR]",
             0x0621: "FC909 Fibre Channel Adapter",
             0x0622: "FC929 Fibre Channel Adapter",
             0x0623: "FC929 LAN",
             0x0624: "FC919 Fibre Channel Adapter",
             0x0625: "FC919 LAN",
             0x0626: "FC929X Fibre Channel Adapter",
             0x0627: "FC929X LAN",
             0x0628: "FC919X Fibre Channel Adapter",
             0x0629: "FC919X LAN",
             0x0640: "FC949X Fibre Channel Adapter",
             0x0642: "FC939X Fibre Channel Adapter",
             0x0646: "FC949ES Fibre Channel Adapter",
             0x0701: "83C885 NT50 DigitalScape Fast Ethernet",
             0x0702: "Yellowfin G-NIC gigabit ethernet",
             0x0804: "SA2010",
             0x0805: "SA2010ZC",
             0x0806: "SA2020",
             0x0807: "SA2020ZC",
             0x0901: "61C102",
             0x1000: "63C815",
             0x10E0: "MegaRAID 12GSAS/PCIe Unsupported SAS39xx",
             0x10E1: "MegaRAID 12GSAS/PCIe SAS39xx",
             0x10E2: "MegaRAID 12GSAS/PCIe Secure SAS39xx",
             0x10E3: "MegaRAID 12GSAS/PCIe Unsupported SAS39xx",
             0x10E4: "MegaRAID 12GSAS/PCIe Unsupported SAS38xx",
             0x10E5: "MegaRAID 12GSAS/PCIe SAS38xx",
             0x10E6: "MegaRAID 12GSAS/PCIe Secure SAS38xx",
             0x10E7: "MegaRAID 12GSAS/PCIe Unsupported SAS38xx",
             0x1960: "MegaRAID",
             0x3050: "SAS2008 PCI-Express Fusion-MPT SAS-2",
             0x6001: "DX1 Multiformat Broadcast HD/SD Encoder/Decoder",
             0xC010: "PEX880xx PCIe Gen 4 Switch",
             0xC012: "PEX880xx PCIe Gen 4 Switch",
             0xC030: "PEX890xx PCIe Gen 5 Switch",
             0xC034: "PEX890xx PCIe Gen 5 Switch",
             },

    # Kolter Electronic
    0x1001: {0x0010: "PCI 1616 Measurement card with 32 digital I/O lines",
             0x0011: "OPTO-PCI Opto-Isolated digital I/O board",
             0x0012: "PCI-AD/DA Analogue I/O board",
             0x0013: "PCI-OPTO-RELAIS Digital I/O board with relay outputs",
             0x0014: "PCI-Counter/Timer Counter Timer board",
             0x0015: "PCI-DAC416 Analogue output board",
             0x0016: "PCI-MFB Analogue I/O board",
             0x0017: "PROTO-3 PCI Prototyping board",
             0x9100: "INI-9100/9100W SCSI Host",
             },

    # Advanced Micro Devices, Inc. [AMD/ATI]
    0x1002: {0x1304: "Kaveri",
             0x1305: "Kaveri",
             0x1306: "Kaveri",
             0x1307: "Kaveri",
             0x1308: "Kaveri HDMI/DP Audio Controller",
             0x1309: "Kaveri [Radeon R6/R7 Graphics]",
             0x130A: "Kaveri [Radeon R6 Graphics]",
             0x130B: "Kaveri [Radeon R4 Graphics]",
             0x130C: "Kaveri [Radeon R7 Graphics]",
             0x130D: "Kaveri [Radeon R6 Graphics]",
             0x130E: "Kaveri [Radeon R5 Graphics]",
             0x130F: "Kaveri [Radeon R7 Graphics]",
             0x1310: "Kaveri",
             0x1311: "Kaveri",
             0x1312: "Kaveri",
             0x1313: "Kaveri [Radeon R7 Graphics]",
             0x1314: "Wrestler HDMI Audio",
             0x1315: "Kaveri [Radeon R5 Graphics]",
             0x1316: "Kaveri [Radeon R5 Graphics]",
             0x1317: "Kaveri",
             0x1318: "Kaveri [Radeon R5 Graphics]",
             0x131B: "Kaveri [Radeon R4 Graphics]",
             0x131C: "Kaveri [Radeon R7 Graphics]",
             0x131D: "Kaveri [Radeon R6 Graphics]",
             0x13E9: "Ariel/Navi10Lite",
             0x13F9: "Oberon/Navi12Lite",
             0x13FE: "Cyan Skillfish [BC-250]",
             0x1478: "Navi 10 XL Upstream Port of PCI Express Switch",
             0x1479: "Navi 10 XL Downstream Port of PCI Express Switch",
             0x1506: "Mendocino",
             0x154C: "Kryptos [Radeon RX 350]",
             0x154E: "Garfield",
             0x1551: "Arlene",
             0x1552: "Pooky",
             0x1561: "Anubis",
             0x15BF: "Phoenix1",
             0x15C8: "Phoenix2",
             0x15D8: "Picasso/Raven 2 [Radeon Vega Series / Radeon Vega Mobile Series]",
             0x15DD: "Raven Ridge [Radeon Vega Series / Radeon Vega Mobile Series]",
             0x15DE: "Raven/Raven2/Fenghuang HDMI/DP Audio Controller",
             0x15DF: "Raven/Raven2/Fenghuang/Renoir Cryptographic Coprocessor",
             0x15E7: "Barcelo",
             0x15FF: "Fenghuang [Zhongshan Subor Z+]",
             0x1607: "Arden",
             0x1636: "Renoir",
             0x1637: "Renoir Radeon High Definition Audio Controller",
             0x1638: "Cezanne [Radeon Vega Series / Radeon Vega Mobile Series]",
             0x163F: "VanGogh [AMD Custom GPU 0405]",
             0x1640: "Rembrandt Radeon High Definition Audio Controller",
             0x164C: "Lucienne",
             0x164D: "Rembrandt",
             0x164E: "Raphael",
             0x164F: "Phoenix",
             0x1681: "Rembrandt [Radeon 680M]",
             0x1714: "BeaverCreek HDMI Audio [Radeon HD 6500D and 6400G-6600G series]",
             0x3150: "RV380/M24 [Mobility Radeon X600]",
             0x3151: "RV380 GL [FireMV 2400]",
             0x3152: "RV370/M22 [Mobility Radeon X300]",
             0x3154: "RV380/M24 GL [Mobility FireGL V3200]",
             0x3155: "RV380 GL [FireMV 2400]",
             0x3171: "RV380 GL [FireMV 2400] (Secondary)",
             0x3E50: "RV380 [Radeon X550/X600]",
             0x3E54: "RV380 GL [FireGL V3200]",
             0x3E70: "RV380 [Radeon X550/X600] (Secondary)",
             0x4136: "RS100 [Mobility IGP 320M]",
             0x4137: "RS200 [Radeon IGP 340]",
             0x4144: "R300 [Radeon 9500]",
             0x4146: "R300 [Radeon 9700 PRO]",
             0x4147: "R300 GL [FireGL Z1]",
             0x4148: "R350 [Radeon 9800/9800 SE]",
             0x4150: "RV350 [Radeon 9550/9600/X1050 Series]",
             0x4151: "RV350 [Radeon 9600 Series]",
             0x4152: "RV360 [Radeon 9600/X1050 Series]",
             0x4153: "RV350 [Radeon 9550]",
             0x4154: "RV350 GL [FireGL T2]",
             0x4155: "RV350 [Radeon 9600]",
             0x4157: "RV350 GL [FireGL T2]",
             0x4158: "68800AX [Graphics Ultra Pro PCI]",
             0x4164: "R300 [Radeon 9500 PRO] (Secondary)",
             0x4165: "R300 [Radeon 9700 PRO] (Secondary)",
             0x4166: "R300 [Radeon 9700 PRO] (Secondary)",
             0x4168: "RV350 [Radeon 9800 SE] (Secondary)",
             0x4170: "RV350 [Radeon 9550/9600/X1050 Series] (Secondary)",
             0x4171: "RV350 [Radeon 9600] (Secondary)",
             0x4172: "RV350 [Radeon 9600/X1050 Series] (Secondary)",
             0x4173: "RV350 [Radeon 9550] (Secondary)",
             0x4242: "R200 [All-In-Wonder Radeon 8500 DV]",
             0x4243: "R200 PCI Bridge [All-in-Wonder Radeon 8500DV]",
             0x4336: "RS100 [Radeon IGP 320M]",
             0x4337: "RS200M [Radeon IGP 330M/340M/345M/350M]",
             0x4341: "SB200 AC97 Audio Controller",
             0x4342: "SB200 PCI to PCI Bridge",
             0x4345: "SB200 EHCI USB Controller",
             0x4346: "Crayola 6 [XENOS Parent Die (XBOX 360)]",
             0x4347: "SB200 OHCI USB Controller #1",
             0x4348: "SB200 OHCI USB Controller #2",
             0x4349: "SB200 IDE Controller",
             0x434C: "SB200 PCI to LPC Bridge",
             0x434D: "SB200 AC97 Modem Controller",
             0x4353: "SB200 SMBus Controller",
             0x4354: "215CT [Mach64 CT PCI]",
             0x4358: "Mach64 CX [Graphics Xpression]",
             0x4361: "SB300 AC'97 Audio Controller",
             0x4362: "SB300 PCI to PCI Bridge",
             0x4363: "SB300 SMBus Controller",
             0x4365: "SB300 USB Controller (EHCI)",
             0x4367: "SB300 USB Controller (EHCI)",
             0x4368: "SB300 USB Controller (EHCI)",
             0x4369: "SB300 IDE Controller",
             0x436C: "SB300 PCI to LPC Bridge",
             0x436D: "SB300 AC97 Modem Controller",
             0x436E: "SB300 Serial ATA Controller",
             0x4370: "IXP SB400 AC'97 Audio Controller",
             0x4371: "IXP SB4x0 PCI-PCI Bridge",
             0x4372: "IXP SB4x0 SMBus Controller",
             0x4373: "IXP SB4x0 USB2 Host Controller",
             0x4374: "IXP SB4x0 USB Host Controller",
             0x4375: "IXP SB4x0 USB Host Controller",
             0x4376: "IXP SB4x0 IDE Controller",
             0x4377: "IXP SB4x0 PCI-ISA Bridge",
             0x4378: "IXP SB400 AC'97 Modem Controller",
             0x4379: "IXP SB4x0 Serial ATA Controller",
             0x437A: "IXP SB400 Serial ATA Controller",
             0x437B: "IXP SB4x0 High Definition Audio Controller",
             0x4380: "SB600 Non-Raid-5 SATA",
             0x4381: "SB600 SATA Controller (RAID 5 mode)",
             0x4382: "SB600 AC97 Audio",
             0x4383: "SBx00 Azalia (Intel HDA)",
             0x4384: "SBx00 PCI to PCI Bridge",
             0x4385: "SBx00 SMBus Controller",
             0x4386: "SB600 USB Controller (EHCI)",
             0x4387: "SB600 USB (OHCI0)",
             0x4388: "SB600 USB (OHCI1)",
             0x4389: "SB600 USB (OHCI2)",
             0x438A: "SB600 USB (OHCI3)",
             0x438B: "SB600 USB (OHCI4)",
             0x438C: "SB600 IDE",
             0x438D: "SB600 PCI to LPC Bridge",
             0x438E: "SB600 AC97 Modem",
             0x4390: "SB7x0/SB8x0/SB9x0 SATA Controller [IDE mode]",
             0x4391: "SB7x0/SB8x0/SB9x0 SATA Controller [AHCI mode]",
             0x4392: "SB7x0/SB8x0/SB9x0 SATA Controller [Non-RAID5 mode]",
             0x4393: "SB7x0/SB8x0/SB9x0 SATA Controller [RAID5 mode]",
             0x4394: "SB7x0/SB8x0/SB9x0 SATA Controller [AHCI mode]",
             0x4395: "SB8x0/SB9x0 SATA Controller [Storage mode]",
             0x4396: "SB7x0/SB8x0/SB9x0 USB EHCI Controller",
             0x4397: "SB7x0/SB8x0/SB9x0 USB OHCI0 Controller",
             0x4398: "SB7x0 USB OHCI1 Controller",
             0x4399: "SB7x0/SB8x0/SB9x0 USB OHCI2 Controller",
             0x439C: "SB7x0/SB8x0/SB9x0 IDE Controller",
             0x439D: "SB7x0/SB8x0/SB9x0 LPC host controller",
             0x43A0: "SB700/SB800/SB900 PCI to PCI bridge (PCIE port 0)",
             0x43A1: "SB700/SB800/SB900 PCI to PCI bridge (PCIE port 1)",
             0x43A2: "SB900 PCI to PCI bridge (PCIE port 2)",
             0x43A3: "SB900 PCI to PCI bridge (PCIE port 3)",
             0x4437: "RS250 [Mobility Radeon 7000 IGP]",
             0x4554: "210888ET [Mach64 ET]",
             0x4630: "XENOS Parent Die (XBOX 360)",
             0x4631: "XENOS Daughter Die (XBOX 360)",
             0x4654: "Mach64 VT",
             0x4742: "Rage 3 [3D Rage PRO AGP 2X]",
             0x4744: "Rage 3 [3D Rage PRO AGP 1X]",
             0x4749: "3D Rage PRO PCI",
             0x474D: "Rage XL AGP 2X",
             0x474E: "Rage XC AGP",
             0x474F: "Rage XL",
             0x4750: "3D Rage Pro PCI",
             0x4752: "Rage 3 [Rage XL PCI]",
             0x4753: "Rage XC",
             0x4754: "Mach64 GT/GT-B [3D Rage I/II]",
             0x4755: "Mach64 GT-B [3D Rage II+ DVD]",
             0x4756: "Rage 2 [3D Rage IIC PCI]",
             0x4757: "Rage 2 [3D Rage IIC AGP]",
             0x4758: "Mach64 GX [WinTurbo]",
             0x4759: "Rage 3 [3D Rage IIC PCI]",
             0x475A: "3D Rage IIC AGP",
             0x4845: "Xilleon 220 HBIU for HDTV2",
             0x4846: "Xilleon 220 IDE for HDTV2",
             0x4847: "Xilleon 220 USB for HDTV2",
             0x4848: "Xilleon 220 DAIO-0 for HDTV2",
             0x4849: "Xilleon 220 DAIO-1 for HDTV2",
             0x484A: "Xilleon 220 LPC for HDTV2",
             0x4850: "Xilleon 215 HBIU for X215",
             0x4851: "Xilleon 215 IDE for X215",
             0x4852: "Xilleon 215 USB for X215",
             0x4853: "Xilleon 215 DAIO-0 for X215",
             0x4854: "Xilleon 215 DAIO-1 for X215",
             0x4855: "Xilleon 225 HBIU for X225",
             0x4856: "Xilleon 225 IDE for X225",
             0x4857: "Xilleon 225 USB for X225",
             0x4858: "Xilleon 225 DAIO-0 for X225",
             0x4859: "Xilleon 225 DAIO-1 for X225",
             0x4860: "Xilleon 210 HBIU for X210",
             0x4861: "Xilleon 210 IDE for X210",
             0x4862: "Xilleon 210 USB for X210",
             0x4863: "Xilleon 210 DAIO-0 for X210",
             0x4864: "Xilleon 210 DAIO-1 for X210",
             0x4865: "Xilleon 226 HBIU for X226",
             0x4866: "Xilleon 226 IDE for X226",
             0x4867: "Xilleon 226 USB for X226",
             0x4868: "Xilleon 226 DAIO-0 for X226",
             0x4869: "Xilleon 226 DAIO-1 for X226",
             0x486A: "Xilleon 240S HBIU for X240S",
             0x486B: "Xilleon 240H HBIU for X240H",
             0x486C: "Xilleon 240S USB for X240S",
             0x486D: "Xilleon 240H USB for X240H",
             0x486E: "Xilleon 250 USB 1.1 for X250",
             0x486F: "Xilleon 260 USB 1.1 for X260",
             0x4870: "Xilleon 250 HBIU for X250",
             0x4871: "Xilleon 250 IDE for X250",
             0x4872: "Xilleon 234/235 HBIU for X234/X235",
             0x4873: "Xilleon 244/245 HBIU for X244/X245",
             0x4874: "Xilleon 234/235 USB 1.1 for X234/X235",
             0x4875: "Xilleon 260 HBIU for X260",
             0x4876: "Xilleon 260 IDE for X260",
             0x4877: "Xilleon 244/245 USB 1.1 for X244/X245",
             0x4878: "Xilleon 270 HBIU for X270",
             0x487B: "Xilleon 242 HBIU for X242",
             0x487D: "Xilleon 242 USB 1.1 for X242",
             0x4880: "Xilleon 254 HBIU for X254",
             0x4881: "Xilleon 254 USB 1.1 for X254",
             0x4882: "Xilleon 255 HBIU for X255",
             0x4883: "Xilleon 255 USB 1.1 for X255",
             0x4884: "Xilleon 243 HBIU for X243",
             0x4885: "Xilleon 243 USB 1.1 for X243",
             0x4886: "Xilleon 233 HBIU for X233",
             0x4887: "Xilleon 233 USB 1.1 for X233",
             0x4888: "Xilleon 143 HBIU for X143",
             0x4889: "Xilleon 143 HBIU for X143L",
             0x488A: "Xilleon 143 HBIU for X143S",
             0x4966: "RV250 [Radeon 9000 Series]",
             0x496E: "RV250 [Radeon 9000] (Secondary)",
             0x4A49: "R420 [Radeon X800 PRO/GTO AGP]",
             0x4A4A: "R420 [Radeon X800 GT AGP]",
             0x4A4B: "R420 [Radeon X800 AGP Series]",
             0x4A4D: "R420 GL [FireGL X3-256]",
             0x4A4E: "RV420/M18 [Mobility Radeon 9800]",
             0x4A4F: "R420 [Radeon X850 AGP]",
             0x4A50: "R420 [Radeon X800 XT Platinum Edition AGP]",
             0x4A54: "R420 [Radeon X800 VE AGP]",
             0x4A69: "R420 [Radeon X800 PRO/GTO] (Secondary)",
             0x4A6A: "R420 [Radeon X800] (Secondary)",
             0x4A6B: "R420 [Radeon X800 XT AGP] (Secondary)",
             0x4A70: "R420 [Radeon X800 XT Platinum Edition AGP] (Secondary)",
             0x4A74: "R420 [Radeon X800 VE] (Secondary)",
             0x4B49: "R481 [Radeon X850 XT AGP]",
             0x4B4B: "R481 [Radeon X850 PRO AGP]",
             0x4B4C: "R481 [Radeon X850 XT Platinum Edition AGP]",
             0x4B69: "R481 [Radeon X850 XT AGP] (Secondary)",
             0x4B6B: "R481 [Radeon X850 PRO AGP] (Secondary)",
             0x4B6C: "R481 [Radeon X850 XT Platinum Edition AGP] (Secondary)",
             0x4C42: "Mach64 LT [3D Rage LT PRO AGP]",
             0x4C46: "Rage Mobility 128 AGP 2X/Mobility M3",
             0x4C47: "3D Rage IIC PCI / Mobility Radeon 7500/7500C",
             0x4C49: "3D Rage LT PRO PCI",
             0x4C4D: "Rage Mobility AGP 2x Series",
             0x4C4E: "Rage Mobility L AGP 2x",
             0x4C50: "Rage 3 LT [3D Rage LT PRO PCI]",
             0x4C52: "M1 [Rage Mobility-M1 PCI]",
             0x4C54: "264LT [Mach64 LT]",
             0x4C57: "RV200/M7 [Mobility Radeon 7500]",
             0x4C58: "RV200/M7 GL [Mobility FireGL 7800]",
             0x4C59: "RV100/M6 [Rage/Radeon Mobility Series]",
             0x4C66: "RV250/M9 GL [Mobility FireGL 9000/Radeon 9000]",
             0x4C6E: "RV250/M9 [Mobility Radeon 9000] (Secondary)",
             0x4D46: "Rage Mobility 128 AGP 4X/Mobility M4",
             0x4D52: "Theater 550 PRO PCI [ATI TV Wonder 550]",
             0x4D53: "Theater 550 PRO PCIe",
             0x4E44: "R300 [Radeon 9700/9700 PRO]",
             0x4E45: "R300 [Radeon 9500 PRO/9700]",
             0x4E46: "R300 [Radeon 9600 TX]",
             0x4E47: "R300 GL [FireGL X1]",
             0x4E48: "R350 [Radeon 9800 Series]",
             0x4E49: "R350 [Radeon 9800]",
             0x4E4A: "R360 [Radeon 9800 XXL/XT]",
             0x4E4B: "R350 GL [FireGL X2 AGP Pro]",
             0x4E50: "RV350/M10 / RV360/M11 [Mobility Radeon 9600 (PRO) / 9700]",
             0x4E51: "RV350 [Radeon 9550/9600/X1050 Series]",
             0x4E52: "RV350/M10 [Mobility Radeon 9500/9700 SE]",
             0x4E54: "RV350/M10 GL [Mobility FireGL T2]",
             0x4E56: "RV360/M12 [Mobility Radeon 9550]",
             0x4E64: "R300 [Radeon 9700 PRO] (Secondary)",
             0x4E65: "R300 [Radeon 9500 PRO] (Secondary)",
             0x4E66: "RV350 [Radeon 9600] (Secondary)",
             0x4E67: "R300 GL [FireGL X1] (Secondary)",
             0x4E68: "R350 [Radeon 9800 PRO] (Secondary)",
             0x4E69: "R350 [Radeon 9800] (Secondary)",
             0x4E6A: "RV350 [Radeon 9800 XT] (Secondary)",
             0x4E71: "RV350/M10 [Mobility Radeon 9600] (Secondary)",
             0x4F72: "RV250 [Radeon 9000 Series]",
             0x4F73: "RV250 [Radeon 9000 Series] (Secondary)",
             0x5044: "All-In-Wonder 128 PCI",
             0x5046: "Rage 4 [Rage 128 PRO AGP 4X]",
             0x5050: "Rage 4 [Rage 128 PRO PCI / Xpert 128 PCI]",
             0x5052: "Rage 4 [Rage 128 PRO AGP 4X]",
             0x5144: "R100 [Radeon 7200 / All-In-Wonder Radeon]",
             0x5148: "R200 GL [FireGL 8800]",
             0x514C: "R200 [Radeon 8500/8500 LE]",
             0x514D: "R200 [Radeon 9100]",
             0x5157: "RV200 [Radeon 7500/7500 LE]",
             0x5159: "RV100 [Radeon 7000 / Radeon VE]",
             0x515E: "ES1000",
             0x5245: "Rage 128 GL PCI",
             0x5246: "Rage 128 (Rage 4) series",
             0x524B: "Rage 128 VR PCI",
             0x524C: "Rage 128 VR AGP",
             0x534D: "Rage 128 4X AGP 4x",
             0x5354: "Mach 64 VT",
             0x5446: "Rage 128 PRO Ultra AGP 4x",
             0x5452: "Rage 128 PRO Ultra4XL VR-R AGP",
             0x5460: "RV370/M22 [Mobility Radeon X300]",
             0x5461: "RV370/M22 [Mobility Radeon X300]",
             0x5462: "RV380/M24C [Mobility Radeon X600 SE]",
             0x5464: "RV370/M22 GL [Mobility FireGL V3100]",
             0x5549: "R423 [Radeon X800 GTO]",
             0x554A: "R423 [Radeon X800 XT Platinum Edition]",
             0x554B: "R423 [Radeon X800 GT/SE]",
             0x554D: "R480 [Radeon X800 GTO2/XL]",
             0x554E: "R430 [All-In-Wonder X800 GT]",
             0x554F: "R430 [Radeon X800]",
             0x5550: "R423 GL [FireGL V7100]",
             0x5551: "R423 GL [FireGL V5100]",
             0x5569: "R423 [Radeon X800 PRO] (Secondary)",
             0x556B: "R423 [Radeon X800 GT] (Secondary)",
             0x556D: "R480 [Radeon X800 GTO2/XL] (Secondary)",
             0x556F: "R430 [Radeon X800] (Secondary)",
             0x5571: "R423 GL [FireGL V5100] (Secondary)",
             0x564B: "RV410/M26 GL [Mobility FireGL V5000]",
             0x564F: "RV410/M26 [Mobility Radeon X700 XL]",
             0x5652: "RV410/M26 [Mobility Radeon X700]",
             0x5653: "RV410/M26 [Mobility Radeon X700]",
             0x5654: "Mach64 VT [Video Xpression]",
             0x5655: "264VT3 [Mach64 VT3]",
             0x5656: "Mach64 VT4 [Video Xpression+]",
             0x5657: "RV410 [Radeon X550 XTX / X700]",
             0x5830: "RS300 Host Bridge",
             0x5831: "RS300 Host Bridge",
             0x5832: "RS300 Host Bridge",
             0x5833: "RS300 Host Bridge",
             0x5834: "RS300 [Radeon 9100 IGP]",
             0x5835: "RS300M [Mobility Radeon 9100 IGP]",
             0x5838: "RS300 AGP Bridge",
             0x5854: "RS480 [Radeon Xpress 200 Series] (Secondary)",
             0x5874: "RS480 [Radeon Xpress 1150] (Secondary)",
             0x5940: "RV280 [Radeon 9200 PRO] (Secondary)",
             0x5941: "RV280 [Radeon 9200] (Secondary)",
             0x5944: "RV280 [Radeon 9200 SE PCI]",
             0x5950: "RS480/RS482/RS485 Host Bridge",
             0x5951: "RX480/RX482 Host Bridge",
             0x5952: "RD580 Host Bridge",
             0x5954: "RS480 [Radeon Xpress 200 Series]",
             0x5955: "RS480M [Mobility Radeon Xpress 200]",
             0x5956: "RD790 Host Bridge",
             0x5957: "RX780/RX790 Host Bridge",
             0x5958: "RD780 Host Bridge",
             0x5960: "RV280 [Radeon 9200 PRO / 9250]",
             0x5961: "RV280 [Radeon 9200]",
             0x5962: "RV280 [Radeon 9200]",
             0x5964: "RV280 [Radeon 9200 SE]",
             0x5965: "RV280 GL [FireMV 2200 PCI]",
             0x5974: "RS482/RS485 [Radeon Xpress 1100/1150]",
             0x5975: "RS482M [Mobility Radeon Xpress 200]",
             0x5978: "RX780/RD790 PCI to PCI bridge (external gfx0 port A)",
             0x5979: "RD790 PCI to PCI bridge (external gfx0 port B)",
             0x597A: "RD790 PCI to PCI bridge (PCI express gpp port A)",
             0x597B: "RX780/RD790 PCI to PCI bridge (PCI express gpp port B)",
             0x597C: "RD790 PCI to PCI bridge (PCI express gpp port C)",
             0x597D: "RX780/RD790 PCI to PCI bridge (PCI express gpp port D)",
             0x597E: "RD790 PCI to PCI bridge (PCI express gpp port E)",
             0x597F: "RD790 PCI to PCI bridge (PCI express gpp port F)",
             0x5980: "RD790 PCI to PCI bridge (external gfx1 port A)",
             0x5981: "RD790 PCI to PCI bridge (external gfx1 port B)",
             0x5982: "RD790 PCI to PCI bridge (NB-SB link)",
             0x5A10: "RD890 Northbridge only dual slot (2x16) PCI-e GFX Hydra part",
             0x5A11: "RD890 Northbridge only single slot PCI-e GFX Hydra part",
             0x5A12: "RD890 Northbridge only dual slot (2x8) PCI-e GFX Hydra part",
             0x5A13: "RD890S/SR5650 Host Bridge",
             0x5A14: "RD9x0/RX980 Host Bridge",
             0x5A15: "RD890 PCI to PCI bridge (PCI express gpp port A)",
             0x5A16: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GFX port 0)",
             0x5A17: "RD890/RD9x0 PCI to PCI bridge (PCI Express GFX port 1)",
             0x5A18: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 0)",
             0x5A19: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 1)",
             0x5A1A: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 2)",
             0x5A1B: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 3)",
             0x5A1C: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 4)",
             0x5A1D: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 5)",
             0x5A1E: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP2 Port 0)",
             0x5A1F: "RD890/RD990 PCI to PCI bridge (PCI Express GFX2 port 0)",
             0x5A20: "RD890/RD990 PCI to PCI bridge (PCI Express GFX2 port 1)",
             0x5A23: "RD890S/RD990 I/O Memory Management Unit (IOMMU)",
             0x5A31: "RC410 Host Bridge",
             0x5A33: "RS400 Host Bridge",
             0x5A34: "RS4xx PCI Express Port [ext gfx]",
             0x5A36: "RC4xx/RS4xx PCI Express Port 1",
             0x5A37: "RC4xx/RS4xx PCI Express Port 2",
             0x5A38: "RC4xx/RS4xx PCI Express Port 3",
             0x5A39: "RC4xx/RS4xx PCI Express Port 4",
             0x5A3F: "RC4xx/RS4xx PCI Bridge [int gfx]",
             0x5A41: "RS400 [Radeon Xpress 200]",
             0x5A42: "RS400M [Radeon Xpress 200M]",
             0x5A61: "RC410 [Radeon Xpress 200/1100]",
             0x5A62: "RC410M [Mobility Radeon Xpress 200M]",
             0x5B60: "RV370 [Radeon X300]",
             0x5B62: "RV370 [Radeon X600/X600 SE]",
             0x5B63: "RV370 [Radeon X300/X550/X1050 Series]",
             0x5B64: "RV370 GL [FireGL V3100]",
             0x5B65: "RV370 GL [FireMV 2200]",
             0x5B66: "RV370X",
             0x5B70: "RV370 [Radeon X300 SE]",
             0x5B72: "RV380 [Radeon X300/X550/X1050 Series] (Secondary)",
             0x5B73: "RV370 [Radeon X300/X550/X1050 Series] (Secondary)",
             0x5B74: "RV370 GL [FireGL V3100] (Secondary)",
             0x5B75: "RV370 GL [FireMV 2200] (Secondary)",
             0x5C61: "RV280/M9+ [Mobility Radeon 9200 AGP]",
             0x5C63: "RV280/M9+ [Mobility Radeon 9200 AGP]",
             0x5D44: "RV280 [Radeon 9200 SE] (Secondary)",
             0x5D45: "RV280 GL [FireMV 2200 PCI] (Secondary)",
             0x5D48: "R423/M28 [Mobility Radeon X800 XT]",
             0x5D49: "R423/M28 GL [Mobility FireGL V5100]",
             0x5D4A: "R423/M28 [Mobility Radeon X800]",
             0x5D4D: "R480 [Radeon X850 XT Platinum Edition]",
             0x5D4E: "R480 [Radeon X850 SE]",
             0x5D4F: "R480 [Radeon X800 GTO]",
             0x5D50: "R480 GL [FireGL V7200]",
             0x5D52: "R480 [Radeon X850 XT]",
             0x5D57: "R423 [Radeon X800 XT]",
             0x5D6D: "R480 [Radeon X850 XT Platinum Edition] (Secondary)",
             0x5D6F: "R480 [Radeon X800 GTO] (Secondary)",
             0x5D72: "R480 [Radeon X850 XT] (Secondary)",
             0x5D77: "R423 [Radeon X800 XT] (Secondary)",
             0x5E48: "RV410 GL [FireGL V5000]",
             0x5E49: "RV410 [Radeon X700 Series]",
             0x5E4A: "RV410 [Radeon X700 XT]",
             0x5E4B: "RV410 [Radeon X700 PRO]",
             0x5E4C: "RV410 [Radeon X700 SE]",
             0x5E4D: "RV410 [Radeon X700]",
             0x5E4F: "RV410 [Radeon X700]",
             0x5E6B: "RV410 [Radeon X700 PRO] (Secondary)",
             0x5E6D: "RV410 [Radeon X700] (Secondary)",
             0x5F57: "R423 [Radeon X800 XT]",
             0x6600: "Mars [Radeon HD 8670A/8670M/8750M / R7 M370]",
             0x6601: "Mars [Radeon HD 8730M]",
             0x6604: "Opal XT [Radeon R7 M265/M365X/M465]",
             0x6605: "Opal PRO [Radeon R7 M260X]",
             0x6606: "Mars XTX [Radeon HD 8790M]",
             0x6607: "Mars LE [Radeon HD 8530M / R5 M240]",
             0x6608: "Oland GL [FirePro W2100]",
             0x6609: "Oland GL [FirePro W2100 / Barco MXRT 2600]",
             0x6610: "Oland XT [Radeon HD 8670 / R5 340X OEM / R7 250/350/350X OEM]",
             0x6611: "Oland [Radeon HD 8570 / R5 430 OEM / R7 240/340 / Radeon 520 OEM]",
             0x6613: "Oland PRO [Radeon R7 240/340 / Radeon 520]",
             0x6617: "Oland LE [Radeon R7 240]",
             0x6631: "Oland",
             0x6640: "Saturn XT [FirePro M6100]",
             0x6641: "Saturn PRO [Radeon HD 8930M]",
             0x6646: "Bonaire XT [Radeon R9 M280X]",
             0x6647: "Saturn PRO/XT [Radeon R9 M270X/M280X]",
             0x6649: "Bonaire [FirePro W5100]",
             0x664D: "Bonaire [FirePro W5100 / Barco MXRT-5600]",
             0x6650: "Bonaire",
             0x6651: "Bonaire",
             0x6658: "Bonaire XTX [Radeon R7 260X/360]",
             0x665C: "Bonaire XT [Radeon HD 7790/8770 / R7 360 / R9 260/360 OEM]",
             0x665D: "Bonaire [Radeon R7 200 Series]",
             0x665F: "Tobago PRO [Radeon R7 360 / R9 360 OEM]",
             0x6660: "Sun XT [Radeon HD 8670A/8670M/8690M / R5 M330 / M430 / Radeon 520 Mobile]",
             0x6663: "Sun PRO [Radeon HD 8570A/8570M]",
             0x6664: "Jet XT [Radeon R5 M240]",
             0x6665: "Jet PRO [Radeon R5 M230 / R7 M260DX / Radeon 520/610 Mobile]",
             0x6667: "Jet ULT [Radeon R5 M230]",
             0x666F: "Sun LE [Radeon HD 8550M / R5 M230]",
             0x66A0: "Vega 20 [Radeon Instinct]",
             0x66A1: "Vega 20 [Radeon Pro VII/Radeon Instinct MI50 32GB]",
             0x66A2: "Vega 20",
             0x66A3: "Vega 20 [Radeon Pro Vega II/Radeon Pro Vega II Duo]",
             0x66A7: "Vega 20 [Radeon Pro Vega 20]",
             0x66AF: "Vega 20 [Radeon VII]",
             0x6704: "Cayman PRO GL [FirePro V7900]",
             0x6707: "Cayman LE GL [FirePro V5900]",
             0x6718: "Cayman XT [Radeon HD 6970]",
             0x6719: "Cayman PRO [Radeon HD 6950]",
             0x671C: "Antilles [Radeon HD 6990]",
             0x671D: "Antilles [Radeon HD 6990]",
             0x671F: "Cayman CE [Radeon HD 6930]",
             0x6720: "Blackcomb [Radeon HD 6970M/6990M]",
             0x6738: "Barts XT [Radeon HD 6870]",
             0x6739: "Barts PRO [Radeon HD 6850]",
             0x673E: "Barts LE [Radeon HD 6790]",
             0x6740: "Whistler [Radeon HD 6730M/6770M/7690M XT]",
             0x6741: "Whistler [Radeon HD 6630M/6650M/6750M/7670M/7690M]",
             0x6742: "Whistler LE [Radeon HD 6610M/7610M]",
             0x6743: "Whistler [Radeon E6760]",
             0x6749: "Turks GL [FirePro V4900]",
             0x674A: "Turks GL [FirePro V3900]",
             0x6750: "Onega [Radeon HD 6650A/7650A]",
             0x6751: "Turks [Radeon HD 7650A/7670A]",
             0x6758: "Turks XT [Radeon HD 6670/7670]",
             0x6759: "Turks PRO [Radeon HD 6570/7570/8550 / R5 230]",
             0x675B: "Turks [Radeon HD 7600 Series]",
             0x675D: "Turks PRO [Radeon HD 7570]",
             0x675F: "Turks LE [Radeon HD 5570/6510/7510/8510]",
             0x6760: "Seymour [Radeon HD 6400M/7400M Series]",
             0x6761: "Seymour LP [Radeon HD 6430M]",
             0x6763: "Seymour [Radeon E6460]",
             0x6764: "Seymour [Radeon HD 6400M Series]",
             0x6765: "Seymour [Radeon HD 6400M Series]",
             0x6766: "Caicos",
             0x6767: "Caicos",
             0x6768: "Caicos",
             0x6770: "Caicos [Radeon HD 6450A/7450A]",
             0x6771: "Caicos XTX [Radeon HD 8490 / R5 235X OEM]",
             0x6772: "Caicos [Radeon HD 7450A]",
             0x6778: "Caicos XT [Radeon HD 7470/8470 / R5 235/310 OEM]",
             0x6779: "Caicos [Radeon HD 6450/7450/8450 / R5 230 OEM]",
             0x677B: "Caicos PRO [Radeon HD 7450]",
             0x6780: "Tahiti XT GL [FirePro W9000]",
             0x6784: "Tahiti [FirePro Series Graphics Adapter]",
             0x6788: "Tahiti [FirePro Series Graphics Adapter]",
             0x678A: "Tahiti PRO GL [FirePro Series]",
             0x6798: "Tahiti XT [Radeon HD 7970/8970 OEM / R9 280X]",
             0x679A: "Tahiti PRO [Radeon HD 7950/8950 OEM / R9 280]",
             0x679B: "Malta [Radeon HD 7990/8990 OEM]",
             0x679E: "Tahiti LE [Radeon HD 7870 XT]",
             0x679F: "Tahiti",
             0x67A0: "Hawaii XT GL [FirePro W9100]",
             0x67A1: "Hawaii PRO GL [FirePro W8100]",
             0x67A2: "Hawaii GL",
             0x67A8: "Hawaii",
             0x67A9: "Hawaii",
             0x67AA: "Hawaii",
             0x67B0: "Hawaii XT / Grenada XT [Radeon R9 290X/390X]",
             0x67B1: "Hawaii PRO [Radeon R9 290/390]",
             0x67B8: "Hawaii XT [Radeon R9 290X Engineering Sample]",
             0x67B9: "Vesuvius [Radeon R9 295X2]",
             0x67BE: "Hawaii LE",
             0x67C0: "Ellesmere [Radeon Pro WX 7100 Mobile]",
             0x67C2: "Ellesmere [Radeon Pro V7300X / V7350x2]",
             0x67C4: "Ellesmere [Radeon Pro WX 7100]",
             0x67C7: "Ellesmere [Radeon Pro WX 5100]",
             0x67CA: "Ellesmere [Polaris10]",
             0x67CC: "Ellesmere [Polaris10]",
             0x67CF: "Ellesmere [Polaris10]",
             0x67D0: "Ellesmere [Radeon Pro V7300X / V7350x2]",
             0x67D4: "Ellesmere [Radeon Pro WX 7100 / Barco MXRT-8700]",
             0x67D7: "Ellesmere [Radeon Pro WX 5100 / Barco MXRT-6700]",
             0x67DF: "Ellesmere [Radeon RX 470/480/570/570X/580/580X/590]",
             0x67E0: "Baffin [Radeon Pro WX 4170]",
             0x67E1: "Baffin [Polaris11]",
             0x67E3: "Baffin [Radeon Pro WX 4100]",
             0x67E8: "Baffin [Radeon Pro WX 4130/4150]",
             0x67E9: "Baffin [Polaris11]",
             0x67EB: "Baffin [Radeon Pro V5300X]",
             0x67EF: "Baffin [Radeon RX 460/560D / Pro 450/455/460/555/555X/560/560X]",
             0x67FF: "Baffin [Radeon RX 550 640SP / RX 560/560X]",
             0x6800: "Wimbledon XT [Radeon HD 7970M]",
             0x6801: "Neptune XT [Radeon HD 8970M]",
             0x6802: "Wimbledon",
             0x6806: "Neptune",
             0x6808: "Pitcairn XT GL [FirePro W7000]",
             0x6809: "Pitcairn LE GL [FirePro W5000]",
             0x6810: "Curacao XT / Trinidad XT [Radeon R7 370 / R9 270X/370X]",
             0x6811: "Curacao PRO [Radeon R7 370 / R9 270/370 OEM]",
             0x6816: "Pitcairn",
             0x6817: "Pitcairn",
             0x6818: "Pitcairn XT [Radeon HD 7870 GHz Edition]",
             0x6819: "Pitcairn PRO [Radeon HD 7850 / R7 265 / R9 270 1024SP]",
             0x6820: "Venus XTX [Radeon HD 8890M / R9 M275X/M375X]",
             0x6821: "Venus XT [Radeon HD 8870M / R9 M270X/M370X]",
             0x6822: "Venus PRO [Radeon E8860]",
             0x6823: "Venus PRO [Radeon HD 8850M / R9 M265X]",
             0x6825: "Heathrow XT [Radeon HD 7870M]",
             0x6826: "Chelsea LP [Radeon HD 7700M Series]",
             0x6827: "Heathrow PRO [Radeon HD 7850M/8850M]",
             0x6828: "Cape Verde PRO [FirePro W600]",
             0x6829: "Cape Verde",
             0x682A: "Venus PRO",
             0x682B: "Cape Verde PRO / Venus LE / Tropo PRO-L [Radeon HD 8830M / R7 250 / R7 M465X]",
             0x682C: "Cape Verde GL [FirePro W4100]",
             0x682D: "Chelsea XT GL [FirePro M4000]",
             0x682F: "Chelsea LP [Radeon HD 7730M]",
             0x6835: "Cape Verde PRX [Radeon R9 255 OEM]",
             0x6837: "Cape Verde LE [Radeon HD 7730/8730]",
             0x683D: "Cape Verde XT [Radeon HD 7770/8760 / R7 250X]",
             0x683F: "Cape Verde PRO [Radeon HD 7750/8740 / R7 250E]",
             0x6840: "Thames [Radeon HD 7500M/7600M Series]",
             0x6841: "Thames [Radeon HD 7550M/7570M/7650M]",
             0x6842: "Thames LE [Radeon HD 7000M Series]",
             0x6843: "Thames [Radeon HD 7670M]",
             0x6860: "Vega 10 [Instinct MI25/MI25x2/V340/V320]",
             0x6861: "Vega 10 XT [Radeon PRO WX 9100]",
             0x6862: "Vega 10 XT [Radeon PRO SSG]",
             0x6863: "Vega 10 XTX [Radeon Vega Frontier Edition]",
             0x6864: "Vega 10 [Radeon Pro V340/Instinct MI25x2]",
             0x6867: "Vega 10 XL [Radeon Pro Vega 56]",
             0x6868: "Vega 10 [Radeon PRO WX 8100/8200]",
             0x6869: "Vega 10 XGA [Radeon Pro Vega 48]",
             0x686A: "Vega 10 LEA",
             0x686B: "Vega 10 XTXA [Radeon Pro Vega 64X]",
             0x686C: "Vega 10 [Instinct MI25 MxGPU/MI25x2 MxGPU/V340 MxGPU/V340L MxGPU]",
             0x686D: "Vega 10 GLXTA",
             0x686E: "Vega 10 GLXLA",
             0x687F: "Vega 10 XL/XT [Radeon RX Vega 56/64]",
             0x6880: "Lexington [Radeon HD 6550M]",
             0x6888: "Cypress XT [FirePro V8800]",
             0x6889: "Cypress PRO [FirePro V7800]",
             0x688A: "Cypress XT [FirePro V9800]",
             0x688C: "Cypress XT GL [FireStream 9370]",
             0x688D: "Cypress PRO GL [FireStream 9350]",
             0x6898: "Cypress XT [Radeon HD 5870]",
             0x6899: "Cypress PRO [Radeon HD 5850]",
             0x689B: "Cypress PRO [Radeon HD 6800 Series]",
             0x689C: "Hemlock [Radeon HD 5970]",
             0x689D: "Hemlock [Radeon HD 5970]",
             0x689E: "Cypress LE [Radeon HD 5830]",
             0x68A0: "Broadway XT [Mobility Radeon HD 5870]",
             0x68A1: "Broadway PRO [Mobility Radeon HD 5850]",
             0x68A8: "Granville [Radeon HD 6850M/6870M]",
             0x68A9: "Juniper XT [FirePro V5800]",
             0x68B8: "Juniper XT [Radeon HD 5770]",
             0x68B9: "Juniper LE [Radeon HD 5670 640SP Edition]",
             0x68BA: "Juniper XT [Radeon HD 6770]",
             0x68BE: "Juniper PRO [Radeon HD 5750]",
             0x68BF: "Juniper PRO [Radeon HD 6750]",
             0x68C0: "Madison [Mobility Radeon HD 5730 / 6570M]",
             0x68C1: "Madison [Mobility Radeon HD 5650/5750 / 6530M/6550M]",
             0x68C7: "Pinewood [Mobility Radeon HD 5570/6550A]",
             0x68C8: "Redwood XT GL [FirePro V4800]",
             0x68C9: "Redwood PRO GL [FirePro V3800]",
             0x68D8: "Redwood XT [Radeon HD 5670/5690/5730]",
             0x68D9: "Redwood PRO [Radeon HD 5550/5570/5630/6510/6610/7570]",
             0x68DA: "Redwood LE [Radeon HD 5550/5570/5630/6390/6490/7570]",
             0x68DE: "Redwood",
             0x68E0: "Park [Mobility Radeon HD 5430/5450/5470]",
             0x68E1: "Park [Mobility Radeon HD 5430]",
             0x68E4: "Robson CE [Radeon HD 6370M/7370M]",
             0x68E5: "Robson LE [Radeon HD 6330M]",
             0x68E8: "Cedar",
             0x68E9: "Cedar [ATI FirePro (FireGL) Graphics Adapter]",
             0x68F1: "Cedar GL [FirePro 2460]",
             0x68F2: "Cedar GL [FirePro 2270]",
             0x68F8: "Cedar [Radeon HD 7300 Series]",
             0x68F9: "Cedar [Radeon HD 5000/6000/7350/8350 Series]",
             0x68FA: "Cedar [Radeon HD 7350/8350 / R5 220]",
             0x68FE: "Cedar LE",
             0x6900: "Topaz XT [Radeon R7 M260/M265 / M340/M360 / M440/M445 / 530/535 / 620/625 Mobile]",
             0x6901: "Topaz PRO [Radeon R5 M255]",
             0x6907: "Meso XT [Radeon R5 M315]",
             0x6920: "Amethyst [Radeon R9 M395/ M395X Mac Edition]",
             0x6921: "Amethyst XT [Radeon R9 M295X / M390X]",
             0x6929: "Tonga XT GL [FirePro S7150]",
             0x692B: "Tonga PRO GL [FirePro W7100]",
             0x692F: "Tonga XTV GL [FirePro S7150V]",
             0x6938: "Tonga XT / Amethyst XT [Radeon R9 380X / R9 M295X]",
             0x6939: "Tonga PRO [Radeon R9 285/380]",
             0x693B: "Tonga PRO GL [FirePro W7100 / Barco MXRT-7600]",
             0x694C: "Polaris 22 XT [Radeon RX Vega M GH]",
             0x694E: "Polaris 22 XL [Radeon RX Vega M GL]",
             0x694F: "Polaris 22 MGL XL [Radeon Pro WX Vega M GL]",
             0x6980: "Polaris12",
             0x6981: "Lexa XT [Radeon PRO WX 3200]",
             0x6985: "Lexa XT [Radeon PRO WX 3100]",
             0x6986: "Polaris12",
             0x6987: "Lexa [Radeon 540X/550X/630 / RX 640 / E9171 MCM]",
             0x698F: "Lexa XT [Radeon PRO WX 3100 / Barco MXRT 4700]",
             0x6995: "Lexa XT [Radeon PRO WX 2100]",
             0x699F: "Lexa PRO [Radeon 540/540X/550/550X / RX 540X/550/550X]",
             0x69A0: "Vega 12",
             0x69A1: "Vega 12",
             0x69A2: "Vega 12",
             0x69A3: "Vega 12",
             0x69AF: "Vega 12 [Radeon Pro Vega 20]",
             0x6FDF: "Polaris 20 XL [Radeon RX 580 2048SP]",
             0x700F: "RS100 AGP Bridge",
             0x7010: "RS200/RS250 AGP Bridge",
             0x7100: "R520 [Radeon X1800 XT]",
             0x7101: "R520/M58 [Mobility Radeon X1800 XT]",
             0x7102: "R520/M58 [Mobility Radeon X1800]",
             0x7104: "R520 GL [FireGL V7200 / Barco MXTR-5100]",
             0x7109: "R520 [Radeon X1800 XL]",
             0x710A: "R520 [Radeon X1800 GTO]",
             0x710B: "R520 [Radeon X1800 GTO]",
             0x710E: "R520 GL [FireGL V7300]",
             0x710F: "R520 GL [FireGL V7350]",
             0x7120: "R520 [Radeon X1800] (Secondary)",
             0x7124: "R520 GL [FireGL V7200] (Secondary)",
             0x7129: "R520 [Radeon X1800] (Secondary)",
             0x712E: "R520 GL [FireGL V7300] (Secondary)",
             0x712F: "R520 GL [FireGL V7350] (Secondary)",
             0x7140: "RV515 [Radeon X1300/X1550/X1600 Series]",
             0x7142: "RV515 PRO [Radeon X1300/X1550 Series]",
             0x7143: "RV505 [Radeon X1300/X1550 Series]",
             0x7145: "RV515/M54 [Mobility Radeon X1400]",
             0x7146: "RV515 [Radeon X1300/X1550]",
             0x7147: "RV505 [Radeon X1550 64-bit]",
             0x7149: "RV515/M52 [Mobility Radeon X1300]",
             0x714A: "RV515/M52 [Mobility Radeon X1300]",
             0x7152: "RV515 GL [FireGL V3300]",
             0x7153: "RV515 GL [FireGL V3350]",
             0x715F: "RV505 CE [Radeon X1550 64-bit]",
             0x7162: "RV515 PRO [Radeon X1300/X1550 Series] (Secondary)",
             0x7163: "RV505 [Radeon X1550 Series] (Secondary)",
             0x7166: "RV515 [Radeon X1300/X1550 Series] (Secondary)",
             0x7167: "RV515 [Radeon X1550 64-bit] (Secondary)",
             0x7172: "RV515 GL [FireGL V3300] (Secondary)",
             0x7173: "RV515 GL [FireGL V3350] (Secondary)",
             0x7181: "RV516 [Radeon X1600/X1650 Series]",
             0x7183: "RV516 [Radeon X1300/X1550 Series]",
             0x7186: "RV516/M64 [Mobility Radeon X1450]",
             0x7187: "RV516 [Radeon X1300/X1550 Series]",
             0x7188: "RV516/M64-S [Mobility Radeon X2300]",
             0x718A: "RV516/M64 [Mobility Radeon X2300]",
             0x718B: "RV516/M62 [Mobility Radeon X1350]",
             0x718C: "RV516/M62-CSP64 [Mobility Radeon X1350]",
             0x718D: "RV516/M64-CSP128 [Mobility Radeon X1450]",
             0x7193: "RV516 [Radeon X1550 Series]",
             0x7196: "RV516/M62-S [Mobility Radeon X1350]",
             0x719B: "RV516 GL [FireMV 2250]",
             0x719F: "RV516 [Radeon X1550 Series]",
             0x71A0: "RV516 [Radeon X1300/X1550 Series] (Secondary)",
             0x71A1: "RV516 [Radeon X1600/X1650 Series] (Secondary)",
             0x71A3: "RV516 [Radeon X1300/X1550 Series] (Secondary)",
             0x71A7: "RV516 [Radeon X1300/X1550 Series] (Secondary)",
             0x71BB: "RV516 GL [FireMV 2250] (Secondary)",
             0x71C0: "RV530 [Radeon X1600 XT/X1650 GTO]",
             0x71C1: "RV535 [Radeon X1650 PRO]",
             0x71C2: "RV530 [Radeon X1600 PRO]",
             0x71C3: "RV530 [Radeon X1600 PRO]",
             0x71C4: "RV530/M56 GL [Mobility FireGL V5200]",
             0x71C5: "RV530/M56-P [Mobility Radeon X1600]",
             0x71C6: "RV530LE [Radeon X1600/X1650 PRO]",
             0x71C7: "RV535 [Radeon X1650 PRO]",
             0x71CE: "RV530 [Radeon X1300 XT/X1600 PRO]",
             0x71D2: "RV530 GL [FireGL V3400]",
             0x71D4: "RV530/M66 GL [Mobility FireGL V5250]",
             0x71D5: "RV530/M66-P [Mobility Radeon X1700]",
             0x71D6: "RV530/M66-XT [Mobility Radeon X1700]",
             0x71DE: "RV530/M66 [Mobility Radeon X1700/X2500]",
             0x71E0: "RV530 [Radeon X1600] (Secondary)",
             0x71E1: "RV535 [Radeon X1650 PRO] (Secondary)",
             0x71E2: "RV530 [Radeon X1600] (Secondary)",
             0x71E6: "RV530 [Radeon X1650] (Secondary)",
             0x71E7: "RV535 [Radeon X1650 PRO] (Secondary)",
             0x71F2: "RV530 GL [FireGL V3400] (Secondary)",
             0x7210: "RV550/M71 [Mobility Radeon HD 2300]",
             0x7211: "RV550/M71 [Mobility Radeon X2300 HD]",
             0x7240: "R580+ [Radeon X1950 XTX]",
             0x7244: "R580+ [Radeon X1950 XT]",
             0x7248: "R580 [Radeon X1950]",
             0x7249: "R580 [Radeon X1900 XT]",
             0x724B: "R580 [Radeon X1900 GT]",
             0x724E: "R580 GL [FireGL V7350]",
             0x7269: "R580 [Radeon X1900 XT] (Secondary)",
             0x726B: "R580 [Radeon X1900 GT] (Secondary)",
             0x726E: "R580 [AMD Stream Processor] (Secondary)",
             0x7280: "RV570 [Radeon X1950 PRO]",
             0x7288: "RV570 [Radeon X1950 GT]",
             0x7291: "RV560 [Radeon X1650 XT]",
             0x7293: "RV560 [Radeon X1650 GT]",
             0x72A0: "RV570 [Radeon X1950 PRO] (Secondary)",
             0x72A8: "RV570 [Radeon X1950 GT] (Secondary)",
             0x72B1: "RV560 [Radeon X1650 XT] (Secondary)",
             0x72B3: "RV560 [Radeon X1650 GT] (Secondary)",
             0x7300: "Fiji [Radeon R9 FURY / NANO Series]",
             0x7310: "Navi 10 [Radeon Pro W5700X]",
             0x7312: "Navi 10 [Radeon Pro W5700]",
             0x7314: "Navi 10 USB",
             0x7319: "Navi 10 [Radeon Pro 5700 XT]",
             0x731B: "Navi 10 [Radeon Pro 5700]",
             0x731E: "TDC-150",
             0x731F: "Navi 10 [Radeon RX 5600 OEM/5600 XT / 5700/5700 XT]",
             0x7340: "Navi 14 [Radeon RX 5500/5500M / Pro 5500M]",
             0x7341: "Navi 14 [Radeon Pro W5500]",
             0x7347: "Navi 14 [Radeon Pro W5500M]",
             0x734F: "Navi 14 [Radeon Pro W5300M]",
             0x7360: "Navi 12 [Radeon Pro 5600M/V520/BC-160]",
             0x7362: "Navi 12 [Radeon Pro V520/V540]",
             0x7388: "Arcturus GL-XL",
             0x738C: "Arcturus GL-XL [Instinct MI100]",
             0x738E: "Arcturus GL-XL [Instinct MI100]",
             0x73A1: "Navi 21 [Radeon Pro V620]",
             0x73A2: "Navi 21 Pro-XTA [Radeon Pro W6900X]",
             0x73A3: "Navi 21 GL-XL [Radeon PRO W6800]",
             0x73A4: "Navi 21 USB",
             0x73A5: "Navi 21 [Radeon RX 6950 XT]",
             0x73AB: "Navi 21 Pro-XLA [Radeon Pro W6800X/Radeon Pro W6800X Duo]",
             0x73AE: "Navi 21 [Radeon Pro V620 MxGPU]",
             0x73AF: "Navi 21 [Radeon RX 6900 XT]",
             0x73BF: "Navi 21 [Radeon RX 6800/6800 XT / 6900 XT]",
             0x73C3: "Navi 22",
             0x73C4: "Navi 22 USB",
             0x73CE: "Navi22-XL SRIOV MxGPU",
             0x73DF: "Navi 22 [Radeon RX 6700/6700 XT/6750 XT / 6800M/6850M XT]",
             0x73E0: "Navi 23",
             0x73E1: "Navi 23 WKS-XM [Radeon PRO W6600M]",
             0x73E3: "Navi 23 WKS-XL [Radeon PRO W6600]",
             0x73E4: "Navi 23 USB",
             0x73EF: "Navi 23 [Radeon RX 6650 XT / 6700S / 6800S]",
             0x73FF: "Navi 23 [Radeon RX 6600/6600 XT/6600M]",
             0x7408: "Aldebaran/MI200 [Instinct MI250X]",
             0x740C: "Aldebaran/MI200 [Instinct MI250X/MI250]",
             0x740F: "Aldebaran/MI200 [Instinct MI210]",
             0x7421: "Navi 24 [Radeon PRO W6500M]",
             0x7422: "Navi 24 [Radeon PRO W6400]",
             0x7423: "Navi 24 [Radeon PRO W6300/W6300M]",
             0x7424: "Navi 24 [Radeon RX 6300]",
             0x743F: "Navi 24 [Radeon RX 6400/6500 XT/6500M]",
             0x744C: "Navi 31 [Radeon RX 7900 XT/7900 XTX]",
             0x7480: "Navi 33 [Radeon RX 7600S]",
             0x7483: "Navi 33 [Radeon RX 7600M/7600M XT]",
             0x7833: "RS350 Host Bridge",
             0x7834: "RS350 [Radeon 9100 PRO/XT IGP]",
             0x7835: "RS350M [Mobility Radeon 9000 IGP]",
             0x7838: "RS350 AGP Bridge",
             0x7910: "RS690 Host Bridge",
             0x7911: "RS690/RS740 Host Bridge",
             0x7912: "RS690/RS740 PCI to PCI Bridge (Internal gfx)",
             0x7913: "RS690 PCI to PCI Bridge (PCI Express Graphics Port 0)",
             0x7915: "RS690 PCI to PCI Bridge (PCI Express Port 1)",
             0x7916: "RS690 PCI to PCI Bridge (PCI Express Port 2)",
             0x7917: "RS690 PCI to PCI Bridge (PCI Express Port 3)",
             0x7919: "RS690 HDMI Audio [Radeon Xpress 1200 Series]",
             0x791E: "RS690 [Radeon X1200]",
             0x791F: "RS690M [Radeon Xpress 1200/1250/1270]",
             0x7930: "RS600 Host Bridge",
             0x7932: "RS600 PCI to PCI Bridge (Internal gfx)",
             0x7933: "RS600 PCI to PCI Bridge (PCI Express Graphics Port 0)",
             0x7935: "RS600 PCI to PCI Bridge (PCI Express Port 1)",
             0x7936: "RS600 PCI to PCI Bridge (PCI Express Port 2)",
             0x7937: "RS690 PCI to PCI Bridge (PCI Express Port 3)",
             0x793B: "RS600 HDMI Audio [Radeon Xpress 1250]",
             0x793F: "RS690M [Radeon Xpress 1200/1250/1270] (Secondary)",
             0x7941: "RS600 [Radeon Xpress 1250]",
             0x7942: "RS600M [Radeon Xpress 1250]",
             0x796E: "RS740 [Radeon 2100]",
             0x9400: "R600 [Radeon HD 2900 PRO/XT]",
             0x9401: "R600 [Radeon HD 2900 XT]",
             0x9403: "R600 [Radeon HD 2900 PRO]",
             0x9405: "R600 [Radeon HD 2900 GT]",
             0x940A: "R600 GL [FireGL V8650]",
             0x940B: "R600 GL [FireGL V8600]",
             0x940F: "R600 GL [FireGL V7600]",
             0x9440: "RV770 [Radeon HD 4870]",
             0x9441: "R700 [Radeon HD 4870 X2]",
             0x9442: "RV770 [Radeon HD 4850]",
             0x9443: "R700 [Radeon HD 4850 X2]",
             0x9444: "RV770 GL [FirePro V8750]",
             0x9446: "RV770 GL [FirePro V7760]",
             0x944A: "RV770/M98L [Mobility Radeon HD 4850]",
             0x944B: "RV770/M98 [Mobility Radeon HD 4850 X2]",
             0x944C: "RV770 LE [Radeon HD 4830]",
             0x944E: "RV770 CE [Radeon HD 4710]",
             0x9450: "RV770 GL [FireStream 9270]",
             0x9452: "RV770 GL [FireStream 9250]",
             0x9456: "RV770 GL [FirePro V8700]",
             0x945A: "RV770/M98-XT [Mobility Radeon HD 4870]",
             0x9460: "RV790 [Radeon HD 4890]",
             0x9462: "RV790 [Radeon HD 4860]",
             0x946A: "RV770 GL [FirePro M7750]",
             0x9480: "RV730/M96 [Mobility Radeon HD 4650/5165]",
             0x9488: "RV730/M96-XT [Mobility Radeon HD 4670]",
             0x9489: "RV730/M96 GL [Mobility FireGL V5725]",
             0x9490: "RV730 XT [Radeon HD 4670]",
             0x9491: "RV730/M96-CSP [Radeon E4690]",
             0x9495: "RV730 [Radeon HD 4600 AGP Series]",
             0x9498: "RV730 PRO [Radeon HD 4650]",
             0x949C: "RV730 GL [FirePro V7750]",
             0x949E: "RV730 GL [FirePro V5700]",
             0x949F: "RV730 GL [FirePro V3750]",
             0x94A0: "RV740/M97 [Mobility Radeon HD 4830]",
             0x94A1: "RV740/M97-XT [Mobility Radeon HD 4860]",
             0x94A3: "RV740/M97 GL [FirePro M7740]",
             0x94B3: "RV740 PRO [Radeon HD 4770]",
             0x94B4: "RV740 PRO [Radeon HD 4750]",
             0x94C1: "RV610 [Radeon HD 2400 PRO/XT]",
             0x94C3: "RV610 [Radeon HD 2400 PRO]",
             0x94C4: "RV610 LE [Radeon HD 2400 PRO AGP]",
             0x94C5: "RV610 [Radeon HD 2400 LE]",
             0x94C7: "RV610 [Radeon HD 2350]",
             0x94C8: "RV610/M74 [Mobility Radeon HD 2400 XT]",
             0x94C9: "RV610/M72-S [Mobility Radeon HD 2400]",
             0x94CB: "RV610 [Radeon E2400]",
             0x94CC: "RV610 LE [Radeon HD 2400 PRO PCI]",
             0x9500: "RV670 [Radeon HD 3850 X2]",
             0x9501: "RV670 [Radeon HD 3870]",
             0x9504: "RV670/M88 [Mobility Radeon HD 3850]",
             0x9505: "RV670 [Radeon HD 3690/3850]",
             0x9506: "RV670/M88 [Mobility Radeon HD 3850 X2]",
             0x9507: "RV670 [Radeon HD 3830]",
             0x9508: "RV670/M88-XT [Mobility Radeon HD 3870]",
             0x9509: "RV670/M88 [Mobility Radeon HD 3870 X2]",
             0x950F: "R680 [Radeon HD 3870 X2]",
             0x9511: "RV670 GL [FireGL V7700]",
             0x9513: "RV670 [Radeon HD 3850 X2]",
             0x9515: "RV670 PRO [Radeon HD 3850 AGP]",
             0x9519: "RV670 GL [FireStream 9170]",
             0x9540: "RV710 [Radeon HD 4550]",
             0x954F: "RV710 [Radeon HD 4350/4550]",
             0x9552: "RV710/M92 [Mobility Radeon HD 4330/4350/4550]",
             0x9553: "RV710/M92 [Mobility Radeon HD 4530/4570/5145/530v/540v/545v]",
             0x9555: "RV711/M93 [Mobility Radeon HD 4350/4550/530v/540v/545v / FirePro RG220]",
             0x9557: "RV711/M93 GL [FirePro RG220]",
             0x955F: "RV710/M92 [Mobility Radeon HD 4330]",
             0x9580: "RV630 [Radeon HD 2600 PRO]",
             0x9581: "RV630/M76 [Mobility Radeon HD 2600]",
             0x9583: "RV630/M76 [Mobility Radeon HD 2600 XT/2700]",
             0x9586: "RV630 XT [Radeon HD 2600 XT AGP]",
             0x9587: "RV630 PRO [Radeon HD 2600 PRO AGP]",
             0x9588: "RV630 XT [Radeon HD 2600 XT]",
             0x9589: "RV630 PRO [Radeon HD 2600 PRO]",
             0x958A: "RV630 [Radeon HD 2600 X2]",
             0x958B: "RV630/M76 [Mobility Radeon HD 2600 XT]",
             0x958C: "RV630 GL [FireGL V5600]",
             0x958D: "RV630 GL [FireGL V3600]",
             0x9591: "RV635/M86 [Mobility Radeon HD 3650]",
             0x9593: "RV635/M86 [Mobility Radeon HD 3670]",
             0x9595: "RV635/M86 GL [Mobility FireGL V5700]",
             0x9596: "RV635 PRO [Radeon HD 3650 AGP]",
             0x9597: "RV635 PRO [Radeon HD 3650 AGP]",
             0x9598: "RV635 [Radeon HD 3650/3750/4570/4580]",
             0x9599: "RV635 PRO [Radeon HD 3650 AGP]",
             0x95C0: "RV620 PRO [Radeon HD 3470]",
             0x95C2: "RV620/M82 [Mobility Radeon HD 3410/3430]",
             0x95C4: "RV620/M82 [Mobility Radeon HD 3450/3470]",
             0x95C5: "RV620 LE [Radeon HD 3450]",
             0x95C6: "RV620 LE [Radeon HD 3450 AGP]",
             0x95C9: "RV620 LE [Radeon HD 3450 PCI]",
             0x95CC: "RV620 GL [FirePro V3700]",
             0x95CD: "RV620 GL [FirePro 2450]",
             0x95CF: "RV620 GL [FirePro 2260]",
             0x960F: "RS780 HDMI Audio [Radeon 3000/3100 / HD 3200/3300]",
             0x9610: "RS780 [Radeon HD 3200]",
             0x9611: "RS780C [Radeon 3100]",
             0x9612: "RS780M [Mobility Radeon HD 3200]",
             0x9613: "RS780MC [Mobility Radeon HD 3100]",
             0x9614: "RS780D [Radeon HD 3300]",
             0x9615: "RS780E [Radeon HD 3200]",
             0x9616: "RS780L [Radeon 3000]",
             0x9640: "Sumo [Radeon HD 6550D]",
             0x9641: "Sumo [Radeon HD 6620G]",
             0x9642: "SuperSumo [Radeon HD 6370D]",
             0x9643: "SuperSumo [Radeon HD 6380G]",
             0x9644: "SuperSumo [Radeon HD 6410D]",
             0x9645: "SuperSumo [Radeon HD 6410D]",
             0x9647: "Sumo [Radeon HD 6520G]",
             0x9648: "Sumo [Radeon HD 6480G]",
             0x9649: "SuperSumo [Radeon HD 6480G]",
             0x964A: "Sumo [Radeon HD 6530D]",
             0x964B: "Sumo",
             0x964C: "Sumo",
             0x964E: "Sumo",
             0x964F: "Sumo",
             0x970F: "RS880 HDMI Audio [Radeon HD 4200 Series]",
             0x9710: "RS880 [Radeon HD 4200]",
             0x9712: "RS880M [Mobility Radeon HD 4225/4250]",
             0x9713: "RS880M [Mobility Radeon HD 4100]",
             0x9714: "RS880 [Radeon HD 4290]",
             0x9715: "RS880 [Radeon HD 4250]",
             0x9802: "Wrestler [Radeon HD 6310]",
             0x9803: "Wrestler [Radeon HD 6310]",
             0x9804: "Wrestler [Radeon HD 6250]",
             0x9805: "Wrestler [Radeon HD 6250]",
             0x9806: "Wrestler [Radeon HD 6320]",
             0x9807: "Wrestler [Radeon HD 6290]",
             0x9808: "Wrestler [Radeon HD 7340]",
             0x9809: "Wrestler [Radeon HD 7310]",
             0x980A: "Wrestler [Radeon HD 7290]",
             0x9830: "Kabini [Radeon HD 8400 / R3 Series]",
             0x9831: "Kabini [Radeon HD 8400E]",
             0x9832: "Kabini [Radeon HD 8330]",
             0x9833: "Kabini [Radeon HD 8330E]",
             0x9834: "Kabini [Radeon HD 8210]",
             0x9835: "Kabini [Radeon HD 8310E]",
             0x9836: "Kabini [Radeon HD 8280 / R3 Series]",
             0x9837: "Kabini [Radeon HD 8280E]",
             0x9838: "Kabini [Radeon HD 8240 / R3 Series]",
             0x9839: "Kabini [Radeon HD 8180]",
             0x983D: "Temash [Radeon HD 8250/8280G]",
             0x9840: "Kabini HDMI/DP Audio",
             0x9850: "Mullins [Radeon R3 Graphics]",
             0x9851: "Mullins [Radeon R4/R5 Graphics]",
             0x9852: "Mullins [Radeon R2 Graphics]",
             0x9853: "Mullins [Radeon R2 Graphics]",
             0x9854: "Mullins [Radeon R3E Graphics]",
             0x9855: "Mullins [Radeon R6 Graphics]",
             0x9856: "Mullins [Radeon R1E/R2E Graphics]",
             0x9857: "Mullins [Radeon APU XX-2200M with R2 Graphics]",
             0x9858: "Mullins",
             0x9859: "Mullins",
             0x985A: "Mullins",
             0x985B: "Mullins",
             0x985C: "Mullins",
             0x985D: "Mullins",
             0x985E: "Mullins",
             0x985F: "Mullins",
             0x9874: "Wani [Radeon R5/R6/R7 Graphics]",
             0x9890: "Amur",
             0x98C0: "Nolan",
             0x98E4: "Stoney [Radeon R2/R3/R4/R5 Graphics]",
             0x9900: "Trinity [Radeon HD 7660G]",
             0x9901: "Trinity [Radeon HD 7660D]",
             0x9902: "Trinity HDMI Audio Controller",
             0x9903: "Trinity [Radeon HD 7640G]",
             0x9904: "Trinity [Radeon HD 7560D]",
             0x9905: "Trinity GL [FirePro A300]",
             0x9906: "Trinity GL [FirePro A320]",
             0x9907: "Trinity [Radeon HD 7620G]",
             0x9908: "Trinity [Radeon HD 7600G]",
             0x9909: "Trinity [Radeon HD 7500G]",
             0x990A: "Trinity [Radeon HD 7500G]",
             0x990B: "Richland [Radeon HD 8650G]",
             0x990C: "Richland [Radeon HD 8670D]",
             0x990D: "Richland [Radeon HD 8550G]",
             0x990E: "Richland [Radeon HD 8570D]",
             0x990F: "Richland [Radeon HD 8610G]",
             0x9910: "Trinity [Radeon HD 7660G]",
             0x9913: "Trinity [Radeon HD 7640G]",
             0x9917: "Trinity [Radeon HD 7620G]",
             0x9918: "Trinity [Radeon HD 7600G]",
             0x9919: "Trinity [Radeon HD 7500G]",
             0x991E: "Bishop [Xbox One S APU]",
             0x9920: "Liverpool [Playstation 4 APU]",
             0x9921: "Liverpool HDMI/DP Audio Controller",
             0x9922: "Starshp",
             0x9923: "Starsha2 [Kingston/Clayton]",
             0x9924: "Gladius",
             0x9925: "Kingston/Clayton/Jupiter/Gladius/Montego HDMI Controller",
             0x9926: "Jupiter",
             0x9990: "Trinity 2 [Radeon HD 7520G]",
             0x9991: "Trinity 2 [Radeon HD 7540D]",
             0x9992: "Trinity 2 [Radeon HD 7420G]",
             0x9993: "Trinity 2 [Radeon HD 7480D]",
             0x9994: "Trinity 2 [Radeon HD 7400G]",
             0x9995: "Richland [Radeon HD 8450G]",
             0x9996: "Richland [Radeon HD 8470D]",
             0x9997: "Richland [Radeon HD 8350G]",
             0x9998: "Richland [Radeon HD 8370D]",
             0x9999: "Richland [Radeon HD 8510G]",
             0x999A: "Richland [Radeon HD 8410G]",
             0x999B: "Richland [Radeon HD 8310G]",
             0x999C: "Richland [Radeon HD 8650D]",
             0x999D: "Richland [Radeon HD 8550D]",
             0x99A0: "Trinity 2 [Radeon HD 7520G]",
             0x99A2: "Trinity 2 [Radeon HD 7420G]",
             0x99A4: "Trinity 2 [Radeon HD 7400G]",
             0xAA00: "R600 HDMI Audio [Radeon HD 2900 GT/PRO/XT]",
             0xAA01: "RV635 HDMI Audio [Radeon HD 3650/3730/3750]",
             0xAA08: "RV630 HDMI Audio [Radeon HD 2600 PRO/XT / HD 3610]",
             0xAA10: "RV610 HDMI Audio [Radeon HD 2350 PRO / 2400 PRO/XT / HD 3410]",
             0xAA18: "RV670/680 HDMI Audio [Radeon HD 3690/3800 Series]",
             0xAA20: "RV635 HDMI Audio [Radeon HD 3650/3730/3750]",
             0xAA28: "RV620 HDMI Audio [Radeon HD 3450/3470/3550/3570]",
             0xAA30: "RV770 HDMI Audio [Radeon HD 4850/4870]",
             0xAA38: "RV710/730 HDMI Audio [Radeon HD 4000 series]",
             0xAA50: "Cypress HDMI Audio [Radeon HD 5830/5850/5870 / 6850/6870 Rebrand]",
             0xAA58: "Juniper HDMI Audio [Radeon HD 5700 Series]",
             0xAA60: "Redwood HDMI Audio [Radeon HD 5000 Series]",
             0xAA68: "Cedar HDMI Audio [Radeon HD 5400/6300/7300 Series]",
             0xAA80: "Cayman/Antilles HDMI Audio [Radeon HD 6930/6950/6970/6990]",
             0xAA88: "Barts HDMI Audio [Radeon HD 6790/6850/6870 / 7720 OEM]",
             0xAA90: "Turks HDMI Audio [Radeon HD 6500/6600 / 6700M Series]",
             0xAA98: "Caicos HDMI Audio [Radeon HD 6450 / 7450/8450/8490 OEM / R5 230/235/235X OEM]",
             0xAAA0: "Tahiti HDMI Audio [Radeon HD 7870 XT / 7950/7970]",
             0xAAB0: "Oland/Hainan/Cape Verde/Pitcairn HDMI Audio [Radeon HD 7000 Series]",
             0xAAB8: "Tiran HDMI Audio",
             0xAAC0: "Tobago HDMI Audio [Radeon R7 360 / R9 360 OEM]",
             0xAAC8: "Hawaii HDMI Audio [Radeon R9 290/290X / 390/390X]",
             0xAAD8: "Tonga HDMI Audio [Radeon R9 285/380]",
             0xAAE0: "Baffin HDMI/DP Audio [Radeon RX 550 640SP / RX 560/560X]",
             0xAAE8: "Fiji HDMI/DP Audio [Radeon R9 Nano / FURY/FURY X]",
             0xAAF0: "Ellesmere HDMI Audio [Radeon RX 470/480 / 570/580/590]",
             0xAAF8: "Vega 10 HDMI Audio [Radeon Vega 56/64]",
             0xAB00: "Baffin HDMI/DP Audio [Radeon RX 550 640SP / RX 560/560X]",
             0xAB08: "Polaris 22 HDMI Audio",
             0xAB10: "Lexa HDMI Audio",
             0xAB18: "Vega 12 HDMI Audio",
             0xAB20: "Vega 20 HDMI Audio [Radeon VII]",
             0xAB28: "Navi 21/23 HDMI/DP Audio Controller",
             0xAB38: "Navi 10 HDMI Audio",
             0xAC00: "Theater 506 World-Wide Analog Decoder",
             0xAC01: "Theater 506 World-Wide Analog Decoder",
             0xAC02: "TV Wonder HD 600 PCIe",
             0xAC03: "Theater 506 PCIe",
             0xAC04: "Theater 506 USB",
             0xAC05: "Theater 506 USB",
             0xAC06: "Theater 506 External USB",
             0xAC07: "Theater 506 External USB",
             0xAC08: "Theater 506A World-Wide Analog Decoder + Demodulator",
             0xAC09: "Theater 506A World-Wide Analog Decoder + Demodulator",
             0xAC0A: "Theater 506A PCIe",
             0xAC0B: "Theater 506A PCIe",
             0xAC0C: "Theater 506A USB",
             0xAC0D: "Theater 506A USB",
             0xAC0E: "Theater 506A External USB",
             0xAC0F: "Theater 506A External USB",
             0xAC12: "Theater HD T507 (DVB-T) TV tuner/capture device",
             0xCAB0: "RS100 Host Bridge",
             0xCAB2: "RS200 Host Bridge",
             0xCAB3: "RS250 Host Bridge",
             0xCBB2: "RS200 Host Bridge",
             },

    # VLSI Technology Inc
    0x1004: {0x0005: "82C592-FC1",
             0x0006: "82C593-FC1",
             0x0007: "82C594-AFC2",
             0x0008: "82C596/7 [Wildcat]",
             0x0009: "82C597-AFC2",
             0x000C: "82C541 [Lynx]",
             0x000D: "82C543 [Lynx]",
             0x0101: "82C532",
             0x0102: "82C534 [Eagle]",
             0x0103: "82C538",
             0x0104: "82C535",
             0x0105: "82C147",
             0x0200: "82C975",
             0x0280: "82C925",
             0x0304: "QSound ThunderBird PCI Audio",
             0x0305: "QSound ThunderBird PCI Audio Gameport",
             0x0306: "QSound ThunderBird PCI Audio Support Registers",
             0x0307: "SAA7785 ThunderBird PCI Audio",
             0x0308: "SAA7785 ThunderBird PCI Audio Gameport",
             0x0702: "VAS96011 [Golden Gate II]",
             0x0703: "Tollgate",
             },

    # Avance Logic Inc. [ALI]
    0x1005: {0x2064: "ALG2032/2064",
             0x2128: "ALG2364A",
             0x2301: "ALG2301",
             0x2302: "ALG2302",
             0x2364: "ALG2364",
             0x2464: "ALG2364A",
             0x2501: "ALG2564A/25128A",
             },

    # National Semiconductor Corporation
    0x100B: {0x0001: "DP83810",
             0x0002: "87415/87560 IDE",
             0x000E: "87560 Legacy I/O",
             0x000F: "FireWire Controller",
             0x0011: "NS87560 National PCI System I/O",
             0x0012: "USB Controller",
             0x0020: "DP83815 (MacPhyter) Ethernet Controller",
             0x0021: "PC87200 PCI to ISA Bridge",
             0x0022: "DP83820 10/100/1000 Ethernet Controller",
             0x0028: "Geode GX2 Host Bridge",
             0x002A: "CS5535 South Bridge",
             0x002B: "CS5535 ISA bridge",
             0x002D: "CS5535 IDE",
             0x002E: "CS5535 Audio",
             0x002F: "CS5535 USB",
             0x0030: "Geode GX2 Graphics Processor",
             0x0035: "DP83065 [Saturn] 10/100/1000 Ethernet Controller",
             0x0500: "SCx200 Bridge",
             0x0501: "SCx200 SMI",
             0x0502: "SCx200, SC1100 IDE controller",
             0x0503: "SCx200, SC1100 Audio Controller",
             0x0504: "SCx200 Video",
             0x0505: "SCx200 XBus",
             0x0510: "SC1100 Bridge",
             0x0511: "SC1100 SMI & ACPI",
             0x0515: "SC1100 XBus",
             0xD001: "87410 IDE",
             },

    # Tseng Labs Inc
    0x100C: {0x3202: "ET4000/W32p rev A",
             0x3205: "ET4000/W32p rev B",
             0x3206: "ET4000/W32p rev C",
             0x3207: "ET4000/W32p rev D",
             0x3208: "ET6000",
             0x4702: "ET6300",
             },

    # Weitek
    0x100E: {0x9000: "P9000 Viper",
             0x9001: "P9000 Viper",
             0x9002: "P9000 Viper",
             0x9100: "P9100 Viper Pro/SE",
             },

    # Digital Equipment Corporation
    0x1011: {0x0001: "DECchip 21050",
             0x0002: "DECchip 21040 [Tulip]",
             0x0004: "DECchip 21030 [TGA]",
             0x0007: "NVRAM [Zephyr NVRAM]",
             0x0008: "KZPSA [KZPSA]",
             0x0009: "DECchip 21140 [FasterNet]",
             0x000A: "21230 Video Codec",
             0x000D: "PBXGB [TGA2]",
             0x000F: "PCI-to-PDQ Interface Chip [PFI] FDDI (DEFPA)",
             0x0014: "DECchip 21041 [Tulip Pass 3]",
             0x0016: "ATMworks 350 Adapter [OPPO] (DGLPB)",
             0x0017: "PV-PCI Graphics Controller (ZLXp-L)",
             0x0018: "Memory Channel interface",
             0x0019: "DECchip 21142/43",
             0x001A: "Farallon PN9000SX Gigabit Ethernet",
             0x0021: "DECchip 21052",
             0x0022: "DECchip 21150",
             0x0023: "DECchip 21150",
             0x0024: "DECchip 21152",
             0x0025: "DECchip 21153",
             0x0026: "DECchip 21154",
             0x0034: "56k Modem Cardbus",
             0x0045: "DECchip 21553",
             0x0046: "DECchip 21554",
             0x1065: "StrongARM DC21285",
             },

    # Cirrus Logic
    0x1013: {0x0038: "GD 7548",
             0x0040: "GD 7555 Flat Panel GUI Accelerator",
             0x004C: "GD 7556 Video/Graphics LCD/CRT Ctrlr",
             0x00A0: "GD 5430/40 [Alpine]",
             0x00A2: "GD 5432 [Alpine]",
             0x00A4: "GD 5434-4 [Alpine]",
             0x00A8: "GD 5434-8 [Alpine]",
             0x00AC: "GD 5436 [Alpine]",
             0x00B0: "GD 5440",
             0x00B8: "GD 5446",
             0x00BC: "GD 5480",
             0x00D0: "GD 5462",
             0x00D2: "GD 5462 [Laguna I]",
             0x00D4: "GD 5464 [Laguna]",
             0x00D5: "GD 5464 BD [Laguna]",
             0x00D6: "GD 5465 [Laguna]",
             0x00E8: "GD 5436U",
             0x1100: "CL 6729",
             0x1110: "PD 6832 PCMCIA/CardBus Ctrlr",
             0x1112: "PD 6834 PCMCIA/CardBus Ctrlr",
             0x1113: "PD 6833 PCMCIA/CardBus Ctrlr",
             0x1200: "GD 7542 [Nordic]",
             0x1202: "GD 7543 [Viking]",
             0x1204: "GD 7541 [Nordic Light]",
             0x4000: "MD 5620 [CLM Data Fax Voice]",
             0x4400: "CD 4400",
             0x6001: "CS 4610/11 [CrystalClear SoundFusion Audio Accelerator]",
             0x6003: "CS 4614/22/24/30 [CrystalClear SoundFusion Audio Accelerator]",
             0x6004: "CS 4614/22/24 [CrystalClear SoundFusion Audio Accelerator]",
             0x6005: "Crystal CS4281 PCI Audio",
             },

    # IBM
    0x1014: {0x0002: "PCI to MCA Bridge",
             0x0005: "Processor to I/O Controller [Alta Lite]",
             0x0007: "Processor to I/O Controller [Alta MP]",
             0x000A: "PCI to ISA Bridge (IBM27-82376) [Fire Coral]",
             0x0017: "CPU to PCI Bridge",
             0x0018: "TR Auto LANstreamer",
             0x001B: "GXT-150P",
             0x001C: "Carrera",
             0x001D: "SCSI-2 FAST PCI Adapter (82G2675)",
             0x0020: "GXT1000 Graphics Adapter",
             0x0022: "PCI to PCI Bridge (IBM27-82351)",
             0x002D: "Processor to I/O Controller [Python]",
             0x002E: "SCSI RAID Adapter [ServeRAID]",
             0x0031: "2 Port Serial Adapter",
             0x0036: "PCI to 32-bit LocalBus Bridge [Miami]",
             0x0037: "PowerPC to PCI Bridge (IBM27-82660)",
             0x003A: "CPU to PCI Bridge",
             0x003C: "GXT250P/GXT255P Graphics Adapter",
             0x003E: "16/4 Token ring UTP/STP controller",
             0x0045: "SSA Adapter",
             0x0046: "MPIC interrupt controller",
             0x0047: "PCI to PCI Bridge",
             0x0048: "PCI to PCI Bridge",
             0x0049: "Warhead SCSI Controller",
             0x004E: "ATM Controller (14104e00)",
             0x004F: "ATM Controller (14104f00)",
             0x0050: "ATM Controller (14105000)",
             0x0053: "25 MBit ATM Controller",
             0x0054: "GXT500P/GXT550P Graphics Adapter",
             0x0057: "MPEG PCI Bridge",
             0x0058: "SSA Adapter [Advanced SerialRAID/X]",
             0x005E: "GXT800P Graphics Adapter",
             0x007C: "ATM Controller (14107c00)",
             0x007D: "3780IDSP [MWave]",
             0x008B: "EADS PCI to PCI Bridge",
             0x008E: "GXT3000P Graphics Adapter",
             0x0090: "GXT 3000P",
             0x0091: "SSA Adapter",
             0x0095: "20H2999 PCI Docking Bridge",
             0x0096: "Chukar chipset SCSI controller",
             0x009F: "PCI 4758 Cryptographic Accelerator",
             0x00A5: "ATM Controller (1410a500)",
             0x00A6: "ATM 155MBPS MM Controller (1410a600)",
             0x00B7: "GXT2000P Graphics Adapter",
             0x00B8: "GXT2000P Graphics Adapter",
             0x00BE: "ATM 622MBPS Controller (1410be00)",
             0x00DC: "Advanced Systems Management Adapter (ASMA)",
             0x00FC: "CPC710 Dual Bridge and Memory Controller (PCI-64)",
             0x0105: "CPC710 Dual Bridge and Memory Controller (PCI-32)",
             0x010F: "Remote Supervisor Adapter (RSA)",
             0x0142: "Yotta Video Compositor Input",
             0x0144: "Yotta Video Compositor Output",
             0x0156: "405GP PLB to PCI Bridge",
             0x015E: "622Mbps ATM PCI Adapter",
             0x0160: "64bit/66MHz PCI ATM 155 MMF",
             0x016E: "GXT4000P Graphics Adapter",
             0x0170: "GXT6000P Graphics Adapter",
             0x017D: "GXT300P Graphics Adapter",
             0x0180: "Snipe chipset SCSI controller",
             0x0188: "EADS-X PCI-X to PCI-X Bridge",
             0x01A7: "PCI-X to PCI-X Bridge",
             0x01BD: "ServeRAID Controller",
             0x01C1: "64bit/66MHz PCI ATM 155 UTP",
             0x01E6: "Cryptographic Accelerator",
             0x01EF: "PowerPC 440GP PCI Bridge",
             0x01FF: "10/100 Mbps Ethernet",
             0x0219: "Multiport Serial Adapter",
             0x021B: "GXT6500P Graphics Adapter",
             0x021C: "GXT4500P Graphics Adapter",
             0x0233: "GXT135P Graphics Adapter",
             0x025A: "Drone card",
             0x028C: "Citrine chipset SCSI controller",
             0x02A1: "Calgary PCI-X Host Bridge",
             0x02BD: "Obsidian chipset SCSI controller",
             0x0302: "Winnipeg PCI-X Host Bridge",
             0x0308: "CalIOC2 PCI-E Root Port",
             0x0311: "FC 5740/1954 4-Port 10/100/1000 Base-TX PCI-X Adapter for POWER",
             0x0314: "ZISC 036 Neural accelerator card",
             0x032D: "Axon - Cell Companion Chip",
             0x0339: "Obsidian-E PCI-E SCSI controller",
             0x033D: "PCI-E IPR SAS Adapter (FPGA)",
             0x034A: "PCI-E IPR SAS Adapter (ASIC)",
             0x03DC: "POWER8 Host Bridge (PHB3)",
             0x044B: "GenWQE Accelerator Adapter",
             0x04AA: "Flash Adapter 90 (PCIe2 0.9TB)",
             0x04C1: "POWER9 Host Bridge (PHB4)",
             0x04DA: "PCI-E IPR SAS+ Adapter (ASIC)",
             0x04ED: "Internal Shared Memory (ISM) virtual PCI device",
             0x3022: "QLA3022 Network Adapter",
             0x4022: "QLA3022 Network Adapter",
             0xFFFF: "MPIC-2 interrupt controller",
             },

    # AT&T GIS (NCR)
    0x101A: {0x0005: "100VG ethernet",
             0x0007: "BYNET BIC4G/2C/2G",
             0x0009: "PQS Memory Controller",
             0x000A: "BYNET BPCI Adapter",
             0x000B: "BYNET 4 Port BYA Switch (BYA4P)",
             0x000C: "BYNET 4 Port BYA Switch (BYA4G)",
             0x0010: "NCR AMC Memory Controller",
             0x1DC1: "BYNET BIC2M/BIC4M/BYA4M",
             0x1FA8: "BYNET Multi-port BIC Adapter (XBIC Based)",
             },

    # Western Digital
    0x101C: {0x0193: "33C193A",
             0x0196: "33C196A",
             0x0197: "33C197A",
             0x0296: "33C296A",
             0x3193: "7193",
             0x3197: "7197",
             0x3296: "33C296A",
             0x4296: "34C296",
             0x9710: "Pipeline 9710",
             0x9712: "Pipeline 9712",
             0xC24A: "90C",
             },

    # American Megatrends Inc.
    0x101E: {0x0009: "MegaRAID 428 Ultra RAID Controller (rev 03)",
             0x1960: "MegaRAID",
             0x9010: "MegaRAID 428 Ultra RAID Controller",
             0x9030: "EIDE Controller",
             0x9031: "EIDE Controller",
             0x9032: "EIDE & SCSI Controller",
             0x9033: "SCSI Controller",
             0x9040: "Multimedia card",
             0x9060: "MegaRAID 434 Ultra GT RAID Controller",
             0x9063: "MegaRAC",
             },

    # Advanced Micro Devices, Inc. [AMD]
    0x1022: {0x1100: "K8 [Athlon64/Opteron] HyperTransport Technology Configuration",
             0x1101: "K8 [Athlon64/Opteron] Address Map",
             0x1102: "K8 [Athlon64/Opteron] DRAM Controller",
             0x1103: "K8 [Athlon64/Opteron] Miscellaneous Control",
             0x1200: "Family 10h Processor HyperTransport Configuration",
             0x1201: "Family 10h Processor Address Map",
             0x1202: "Family 10h Processor DRAM Controller",
             0x1203: "Family 10h Processor Miscellaneous Control",
             0x1204: "Family 10h Processor Link Control",
             0x1300: "Family 11h Processor HyperTransport Configuration",
             0x1301: "Family 11h Processor Address Map",
             0x1302: "Family 11h Processor DRAM Controller",
             0x1303: "Family 11h Processor Miscellaneous Control",
             0x1304: "Family 11h Processor Link Control",
             0x1305: "Griffin Function 5",
             0x1306: "Griffin Function 6",
             0x1307: "Griffin Function 7",
             0x1308: "Kaveri Audio Controller",
             0x1314: "Wrestler/Bheem/Ontario/Krishna Audio Controller",
             0x13E0: "Ariel Root Complex",
             0x13E1: "Ariel IOMMU",
             0x13E2: "Ariel PCIe Dummy Host Bridge",
             0x13E3: "Ariel PCIe GPP Bridge",
             0x13E4: "Ariel PCIe Dummy Host Bridge",
             0x13E5: "Ariel Internal PCIe GPP Bridge 0 to Bus A",
             0x13E6: "Ariel Internal PCIe GPP Bridge 0 to Bus B",
             0x13E7: "Ariel SMBus Controller",
             0x13E8: "Ariel LPC Bridge",
             0x13E9: "Ariel Internal GPU",
             0x13EA: "Ariel HD Audio Controller",
             0x13EB: "Ariel HD Audio Coprocessor",
             0x13EC: "Ariel Cryptographic Coprocessor",
             0x13ED: "Ariel USB 3.1 Type C: Gen2 x 1port + DP Alt Mode",
             0x13EE: "Ariel USB 3.1 Type A: Gen2 x 2 ports",
             0x13EF: "Ariel ZCN/MP4",
             0x13F0: "Ariel Device 24: Function 0",
             0x13F1: "Ariel Device 24: Function 1",
             0x13F2: "Ariel Device 24: Function 2",
             0x13F3: "Ariel Device 24: Function 3",
             0x13F4: "Ariel Device 24: Function 4",
             0x13F5: "Ariel Device 24: Function 5",
             0x13F6: "Ariel Device 24: Function 6",
             0x13F7: "Ariel Device 24: Function 7",
             0x1400: "Family 15h (Models 10h-1fh) Processor Function 0",
             0x1401: "Family 15h (Models 10h-1fh) Processor Function 1",
             0x1402: "Family 15h (Models 10h-1fh) Processor Function 2",
             0x1403: "Family 15h (Models 10h-1fh) Processor Function 3",
             0x1404: "Family 15h (Models 10h-1fh) Processor Function 4",
             0x1405: "Family 15h (Models 10h-1fh) Processor Function 5",
             0x1410: "Family 15h (Models 10h-1fh) Processor Root Complex",
             0x1412: "Family 15h (Models 10h-1fh) Processor Root Port",
             0x1413: "Family 15h (Models 10h-1fh) Processor Root Port",
             0x1414: "Family 15h (Models 10h-1fh) Processor Root Port",
             0x1415: "Family 15h (Models 10h-1fh) Processor Root Port",
             0x1416: "Family 15h (Models 10h-1fh) Processor Root Port",
             0x1417: "Family 15h (Models 10h-1fh) Processor Root Port",
             0x1418: "Family 15h (Models 10h-1fh) Processor Root Port",
             0x1419: "Family 15h (Models 10h-1fh) I/O Memory Management Unit",
             0x141A: "Family 15h (Models 30h-3fh) Processor Function 0",
             0x141B: "Family 15h (Models 30h-3fh) Processor Function 1",
             0x141C: "Family 15h (Models 30h-3fh) Processor Function 2",
             0x141D: "Family 15h (Models 30h-3fh) Processor Function 3",
             0x141E: "Family 15h (Models 30h-3fh) Processor Function 4",
             0x141F: "Family 15h (Models 30h-3fh) Processor Function 5",
             0x1422: "Family 15h (Models 30h-3fh) Processor Root Complex",
             0x1423: "Family 15h (Models 30h-3fh) I/O Memory Management Unit",
             0x1424: "Family 15h (Models 30h-3fh) Processor Root Port",
             0x1425: "Kaveri P2P Bridge for GFX PCIe Port [1:0]",
             0x1426: "Family 15h (Models 30h-3fh) Processor Root Port",
             0x142E: "Liverpool Processor HT configuration",
             0x142F: "Liverpool Processor Address Maps",
             0x1430: "Liverpool Processor DRAM configuration",
             0x1431: "Liverpool Processor Misc configuration",
             0x1432: "Liverpool Processor PM configuration",
             0x1433: "Liverpool Processor NB Performance Monitor",
             0x1434: "Liverpool Processor SPLL Configuration",
             0x1436: "Liverpool Processor Root Complex",
             0x1437: "Liverpool I/O Memory Management Unit",
             0x1438: "Liverpool UMI PCIe Dummy Host Bridge",
             0x1439: "Family 16h Processor Functions 5:1",
             0x143A: "Kingston/Clayton/Gladius/Montego Root Complex",
             0x143B: "Kingston/Clayton/Gladius/Montego P2P Bridge for UMI Link",
             0x1440: "Matisse/Vermeer Data Fabric: Device 18h; Function 0",
             0x1441: "Matisse/Vermeer Data Fabric: Device 18h; Function 1",
             0x1442: "Matisse/Vermeer Data Fabric: Device 18h; Function 2",
             0x1443: "Matisse/Vermeer Data Fabric: Device 18h; Function 3",
             0x1444: "Matisse/Vermeer Data Fabric: Device 18h; Function 4",
             0x1445: "Matisse/Vermeer Data Fabric: Device 18h; Function 5",
             0x1446: "Matisse/Vermeer Data Fabric: Device 18h; Function 6",
             0x1447: "Matisse/Vermeer Data Fabric: Device 18h; Function 7",
             0x1448: "Renoir Device 24: Function 0",
             0x1449: "Renoir Device 24: Function 1",
             0x144A: "Renoir Device 24: Function 2",
             0x144B: "Renoir Device 24: Function 3",
             0x144C: "Renoir Device 24: Function 4",
             0x144D: "Renoir Device 24: Function 5",
             0x144E: "Renoir Device 24: Function 6",
             0x144F: "Renoir Device 24: Function 7",
             0x1450: "Family 17h (Models 00h-0fh) Root Complex",
             0x1451: "Family 17h (Models 00h-0fh) I/O Memory Management Unit",
             0x1452: "Family 17h (Models 00h-1fh) PCIe Dummy Host Bridge",
             0x1453: "Family 17h (Models 00h-0fh) PCIe GPP Bridge",
             0x1454: "Family 17h (Models 00h-0fh) Internal PCIe GPP Bridge 0 to Bus B",
             0x1455: "Zeppelin/Renoir PCIe Dummy Function",
             0x1456: "Family 17h (Models 00h-0fh) Platform Security Processor (PSP) 3.0 Device",
             0x1457: "Family 17h (Models 00h-0fh) HD Audio Controller",
             0x145A: "Zeppelin/Raven/Raven2 PCIe Dummy Function",
             0x145B: "Zeppelin Non-Transparent Bridge",
             0x145C: "Family 17h (Models 00h-0fh) USB 3.0 Host Controller",
             0x145D: "Zeppelin Switch Upstream (PCIE SW.US)",
             0x145E: "Zeppelin Switch Downstream (PCIE SW.DS)",
             0x145F: "Zeppelin USB 3.0 xHCI Compliant Host Controller",
             0x1460: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 0",
             0x1461: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 1",
             0x1462: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 2",
             0x1463: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 3",
             0x1464: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 4",
             0x1465: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 5",
             0x1466: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 6",
             0x1467: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 7",
             0x1468: "Zeppelin Cryptographic Coprocessor NTBCCP",
             0x1470: "Vega 10 PCIe Bridge",
             0x1471: "Vega 10 PCIe Bridge",
             0x1480: "Starship/Matisse Root Complex",
             0x1481: "Starship/Matisse IOMMU",
             0x1482: "Starship/Matisse PCIe Dummy Host Bridge",
             0x1483: "Starship/Matisse GPP Bridge",
             0x1484: "Starship/Matisse Internal PCIe GPP Bridge 0 to bus[E:B]",
             0x1485: "Starship/Matisse Reserved SPP",
             0x1486: "Starship/Matisse Cryptographic Coprocessor PSPCPP",
             0x1487: "Starship/Matisse HD Audio Controller",
             0x1488: "Starship Reserved SSP",
             0x1489: "Starship Reserved SSP",
             0x148A: "Starship/Matisse PCIe Dummy Function",
             0x148B: "Starship/Matisse Non-Transparent Bridge",
             0x148C: "Starship USB 3.0 Host Controller",
             0x148D: "Starship/Matisse Switch Upstream (PCIE SW.US)",
             0x148E: "Starship/Matisse Switch Downstream (PCIE SW.DS)",
             0x148F: "Starship Reserved SSP",
             0x1490: "Starship Device 24; Function 0",
             0x1491: "Starship Device 24; Function 1",
             0x1492: "Starship Device 24; Function 2",
             0x1493: "Starship Device 24; Function 3",
             0x1494: "Starship Device 24; Function 4",
             0x1495: "Starship Device 24; Function 5",
             0x1496: "Starship Device 24; Function 6",
             0x1497: "Starship Device 24; Function 7",
             0x1498: "Starship/Matisse PTDMA",
             0x1499: "Starship/Matisse NVMe",
             0x149A: "Starship PCIe GPP Bridge [1:0]",
             0x149B: "Starship Reserved SSP",
             0x149C: "Matisse USB 3.0 Host Controller",
             0x149D: "Vangogh CVIP",
             0x14B5: "Family 17h-19h PCIe Root Complex",
             0x14B6: "Family 17h-19h IOMMU",
             0x14B7: "Family 17h-19h PCIe Dummy Host Bridge",
             0x14B9: "Family 17h-19h Internal PCIe GPP Bridge",
             0x14BA: "Family 17h-19h PCIe GPP Bridge",
             0x14CD: "Family 19h USB4/Thunderbolt PCIe tunnel",
             0x1510: "Family 14h Processor Root Complex",
             0x1512: "Family 14h Processor Root Port",
             0x1513: "Family 14h Processor Root Port",
             0x1514: "Family 14h Processor Root Port",
             0x1515: "Family 14h Processor Root Port",
             0x1516: "Family 14h Processor Root Port",
             0x1530: "Family 16h Processor Function 0",
             0x1531: "Family 16h Processor Function 1",
             0x1532: "Family 16h Processor Function 2",
             0x1533: "Family 16h Processor Function 3",
             0x1534: "Family 16h Processor Function 4",
             0x1535: "Family 16h Processor Function 5",
             0x1536: "Family 16h Processor Root Complex",
             0x1537: "Kabini/Mullins PSP-Platform Security Processor",
             0x1538: "Family 16h Processor Function 0",
             0x1539: "Kabini P2P Bridge for PCIe Ports[4:0]",
             0x1540: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky HT Configuration",
             0x1541: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Address Maps",
             0x1542: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky DRAM Configuration",
             0x1543: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Miscellaneous Configuration",
             0x1544: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky PM Configuration",
             0x1545: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky NB Performance Monitor",
             0x1546: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Root Complex",
             0x1547: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky IOMMU",
             0x1548: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky UMI PCIe Dummy Host Bridge",
             0x1549: "Kryptos/Cato/Garfield/Garfield+ P2P Bridge for PCIe Port [3:0]",
             0x154A: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Audio Processor",
             0x154B: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Security Processor",
             0x154D: "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky/Anubis HDMI Controller",
             0x154F: "Anubis Audio Processor",
             0x1550: "Garfield+/Arlene/Pooky/Anubis SPLL Configuration",
             0x1553: "Arlene/Pooky P2P Bridge for PCIE (3:0)",
             0x155B: "Anubis Root Complex",
             0x155C: "Anubis IOMMU",
             0x155D: "Anubis UMI PCIe Dummy Bridge",
             0x155E: "Anubis P2P Bridge for PCIe Ports [4:0]",
             0x1560: "Anubis Security Processor",
             0x1566: "Family 16h (Models 30h-3fh) Processor Root Complex",
             0x1567: "Mullins IOMMU",
             0x156B: "Family 16h (Models 30h-3fh) Host Bridge",
             0x1570: "Family 15h (Models 60h-6fh) Processor Function 0",
             0x1571: "Family 15h (Models 60h-6fh) Processor Function 1",
             0x1572: "Family 15h (Models 60h-6fh) Processor Function 2",
             0x1573: "Family 15h (Models 60h-6fh) Processor Function 3",
             0x1574: "Family 15h (Models 60h-6fh) Processor Function 4",
             0x1575: "Family 15h (Models 60h-6fh) Processor Function 5",
             0x1576: "Family 15h (Models 60h-6fh) Processor Root Complex",
             0x1577: "Family 15h (Models 60h-6fh) I/O Memory Management Unit",
             0x1578: "Carrizo Platform Security Processor",
             0x1579: "Carrizo Audio Processor",
             0x157A: "Family 15h (Models 60h-6fh) Audio Controller",
             0x157B: "Family 15h (Models 60h-6fh) Host Bridge",
             0x157C: "Family 15h (Models 60h-6fh) Processor Root Port",
             0x157D: "Carrizo Audio Dummy Host Bridge",
             0x157E: "Carrizo Audio Controller",
             0x1580: "Family 16h (Models 30h-3fh) Processor Function 0",
             0x1581: "Family 16h (Models 30h-3fh) Processor Function 1",
             0x1582: "Family 16h (Models 30h-3fh) Processor Function 2",
             0x1583: "Family 16h (Models 30h-3fh) Processor Function 3",
             0x1584: "Family 16h (Models 30h-3fh) Processor Function 4",
             0x1585: "Family 16h (Models 30h-3fh) Processor Function 5",
             0x1590: "Amur/Nolan HT Configuration",
             0x1591: "Amur/Nolan Address Maps",
             0x1592: "Amur/Nolan DRAM Configuration",
             0x1593: "Amur/Nolan Miscellaneous Configuration",
             0x1594: "Amur/Nolan PM Configuration",
             0x1595: "Amur/Nolan NB Performance Monitor",
             0x1596: "Amur/Nolan Root Complex",
             0x1597: "Amur/Nolan IOMMU",
             0x1598: "Amur/Nolan Platform Security Processor",
             0x1599: "Amur/Nolan PCIe Dummy Host Bridge",
             0x159D: "Amur Function 6: Gasket",
             0x15B0: "Stoney HT Configuration",
             0x15B1: "Stoney Address Maps",
             0x15B2: "Stoney DRAM Configuration",
             0x15B3: "Stoney Miscellaneous Configuration",
             0x15B4: "Stoney PM Configuration",
             0x15B5: "Stoney NB Performance Monitor",
             0x15BC: "Stoney PCIe [GFX,GPP] Bridge [4:0]",
             0x15BE: "Stoney Audio Processor",
             0x15D0: "Raven/Raven2 Root Complex",
             0x15D1: "Raven/Raven2 IOMMU",
             0x15D2: "Raven/Raven2 PCIe Dummy Host Bridge",
             0x15D3: "Raven/Raven2 PCIe GPP Bridge [6:0]",
             0x15D4: "FireFlight USB 3.1",
             0x15D5: "FireFlight USB 3.1",
             0x15D6: "Rembrandt USB4 XHCI controller #5",
             0x15D7: "Rembrandt USB4 XHCI controller #6",
             0x15DA: "Raven/Raven2 PCIe Dummy Host Bridge",
             0x15DB: "Raven/Raven2 Internal PCIe GPP Bridge 0 to Bus A",
             0x15DC: "Raven/Raven2 Internal PCIe GPP Bridge 0 to Bus B",
             0x15DE: "Raven/Raven2/FireFlight HD Audio Controller",
             0x15DF: "Family 17h (Models 10h-1fh) Platform Security Processor",
             0x15E0: "Raven USB 3.1",
             0x15E1: "Raven USB 3.1",
             0x15E2: "ACP/ACP3X/ACP6x Audio Coprocessor",
             0x15E3: "Family 17h/19h HD Audio Controller",
             0x15E4: "Sensor Fusion Hub",
             0x15E5: "Raven2 USB 3.1",
             0x15E6: "Raven/Raven2/Renoir Non-Sensor Fusion Hub KMDF driver",
             0x15E8: "Raven/Raven2 Device 24: Function 0",
             0x15E9: "Raven/Raven2 Device 24: Function 1",
             0x15EA: "Raven/Raven2 Device 24: Function 2",
             0x15EB: "Raven/Raven2 Device 24: Function 3",
             0x15EC: "Raven/Raven2 Device 24: Function 4",
             0x15ED: "Raven/Raven2 Device 24: Function 5",
             0x15EE: "Raven/Raven2 Device 24: Function 6",
             0x15EF: "Raven/Raven2 Device 24: Function 7",
             0x15F0: "FireFlight Device 24: Function 0",
             0x15F1: "FireFlight Device 24: Function 1",
             0x15F2: "FireFlight Device 24: Function 2",
             0x15F3: "FireFlight Device 24: Function 3",
             0x15F4: "FireFlight Device 24: Function 4",
             0x15F5: "FireFlight Device 24: Function 5",
             0x15F6: "FireFlight Device 24: Function 6",
             0x15F7: "FireFlight Device 24: Function 7",
             0x15F8: "FireFlight Root Complex",
             0x15F9: "FireFlight IOMMU",
             0x15FA: "FireFlight PCIe Dummy Host Bridge",
             0x15FB: "FireFlight PCIe GPP Bride 3:0",
             0x15FC: "FireFlight PCIe Dummy Host Bridge",
             0x15FD: "FireFlight Internal PCIe GPP Bridge 0 to Bus A",
             0x15FE: "FireFlight Internal PCIe GPP Bridge 0 to Bus B",
             0x15FF: "FireFlight Bus A; Device 0: Function 0: Internal GPU",
             0x1600: "Family 15h Processor Function 0",
             0x1601: "Family 15h Processor Function 1",
             0x1602: "Family 15h Processor Function 2",
             0x1603: "Family 15h Processor Function 3",
             0x1604: "Family 15h Processor Function 4",
             0x1605: "Family 15h Processor Function 5",
             0x1606: "Arden Security Processor",
             0x1608: "Arden Device 18h: Function 0",
             0x1609: "Arden Device 18h: Function 1",
             0x160A: "Arden Device 18h: Function 2",
             0x160B: "Arden Device 18h: Function 3",
             0x160C: "Arden Device 18h: Function 4",
             0x160D: "Arden Device 18h: Function 5",
             0x160E: "Arden Device 18h: Function 6",
             0x160F: "Arden Device 18h: Function 7",
             0x161A: "Rembrandt USB4 XHCI controller #1",
             0x161B: "Rembrandt USB4 XHCI controller #2",
             0x161C: "Rembrandt USB4 XHCI controller #7",
             0x161D: "Rembrandt USB4 XHCI controller #3",
             0x161E: "Rembrandt USB4 XHCI controller #4",
             0x161F: "Rembrandt USB4 XHCI controller #8",
             0x1620: "Anubis HT Configuration",
             0x1621: "Anubis Address Maps",
             0x1622: "Anubis DRAM Configuration",
             0x1623: "Anubis Miscellaneous Configuration",
             0x1624: "Anubis PM Configuration",
             0x1625: "Anubis NB Performance Monitor",
             0x1626: "Arden Root Complex",
             0x1627: "Arden IOMMU",
             0x1628: "Arden PCIe Dummy Host Bridge",
             0x1629: "Arden PCIe GPP Bridge",
             0x162A: "Arden Internal PCIe GPP Bridge 0 to bus X",
             0x162B: "Arden PCIe Non-Transparent Bridge",
             0x162C: "VanGogh USB2",
             0x162E: "Rembrandt USB4/Thunderbolt NHI controller #1",
             0x162F: "Rembrandt USB4/Thunderbolt NHI controller #2",
             0x1630: "Renoir/Cezanne Root Complex",
             0x1631: "Renoir/Cezanne IOMMU",
             0x1632: "Renoir PCIe Dummy Host Bridge",
             0x1633: "Renoir PCIe GPP Bridge",
             0x1634: "Renoir/Cezanne PCIe GPP Bridge",
             0x1635: "Renoir Internal PCIe GPP Bridge to Bus",
             0x1637: "Renoir HD Audio Controller",
             0x1639: "Renoir/Cezanne USB 3.1",
             0x163A: "VanGogh USB0",
             0x163B: "VanGogh USB1",
             0x163C: "VanGogh SecUSB",
             0x163D: "VanGogh SecureFunction",
             0x163E: "VanGogh HSP",
             0x1641: "Renoir 10GbE Controller Port 0 (XGBE0/1)",
             0x1642: "Renoir WLAN",
             0x1643: "Renoir BT",
             0x1644: "Renoir I2S",
             0x1645: "VanGogh Root Complex",
             0x1646: "VanGogh IOMMU",
             0x1647: "VanGogh PCIe GPP Bridge",
             0x1648: "VanGogh Internal PCIe GPP Bridge to Bus",
             0x1649: "VanGogh PSP/CCP",
             0x164F: "Milan IOMMU",
             0x1650: "Milan Data Fabric; Function 0",
             0x1651: "Milan Data Fabric; Function 1",
             0x1652: "Milan Data Fabric; Function 2",
             0x1653: "Milan Data Fabric; Function 3",
             0x1654: "Milan Data Fabric; Function 4",
             0x1655: "Milan Data Fabric; Function 5",
             0x1656: "Milan Data Fabric; Function 6",
             0x1657: "Milan Data Fabric; Function 7",
             0x1660: "VanGogh Data Fabric; Function 0",
             0x1661: "VanGogh Data Fabric; Function 1",
             0x1662: "VanGogh Data Fabric; Function 2",
             0x1663: "VanGogh Data Fabric; Function 3",
             0x1664: "VanGogh Data Fabric; Function 4",
             0x1665: "VanGogh Data Fabric; Function 5",
             0x1666: "VanGogh Data Fabric; Function 6",
             0x1667: "VanGogh Data Fabric; Function 7",
             0x166A: "Cezanne Data Fabric; Function 0",
             0x166B: "Cezanne Data Fabric; Function 1",
             0x166C: "Cezanne Data Fabric; Function 2",
             0x166D: "Cezanne Data Fabric; Function 3",
             0x166E: "Cezanne Data Fabric; Function 4",
             0x166F: "Cezanne Data Fabric; Function 5",
             0x1670: "Cezanne Data Fabric; Function 6",
             0x1671: "Cezanne Data Fabric; Function 7",
             0x1679: "Rembrandt Data Fabric: Device 18h; Function 0",
             0x167A: "Rembrandt Data Fabric: Device 18h; Function 1",
             0x167B: "Rembrandt Data Fabric: Device 18h; Function 2",
             0x167C: "Rembrandt Data Fabric: Device 18h; Function 3",
             0x167D: "Rembrandt Data Fabric: Device 18h; Function 4",
             0x167E: "Rembrandt Data Fabric: Device 18h; Function 5",
             0x167F: "Rembrandt Data Fabric: Device 18h; Function 6",
             0x1680: "Rembrandt Data Fabric: Device 18h; Function 7",
             0x1700: "Family 12h/14h Processor Function 0",
             0x1701: "Family 12h/14h Processor Function 1",
             0x1702: "Family 12h/14h Processor Function 2",
             0x1703: "Family 12h/14h Processor Function 3",
             0x1704: "Family 12h/14h Processor Function 4",
             0x1705: "Family 12h Processor Root Complex",
             0x1706: "Llano P2P Bridge to external GPU",
             0x1707: "Family 12h Processor Root Port",
             0x1708: "Family 12h Processor Root Port",
             0x1709: "Family 12h Processor Root Port",
             0x170A: "Family 12h Processor Root Port",
             0x170B: "Family 12h Processor Root Port",
             0x170C: "Family 12h Processor Root Port",
             0x170D: "Family 12h Processor Root Port",
             0x1716: "Family 12h/14h Processor Function 5",
             0x1718: "Family 12h/14h Processor Function 6",
             0x1719: "Family 12h/14h Processor Function 7",
             0x2000: "79c970 [PCnet32 LANCE]",
             0x2001: "Am79C978 PCnet Home (HomePNA) 1/10 PCI Ethernet Adapter [Am79C971 PHY]",
             0x2003: "Am 1771 MBW [Alchemy]",
             0x2020: "53c974 [PCscsi]",
             0x2040: "79c974",
             0x2080: "CS5536 [Geode companion] Host Bridge",
             0x2081: "Geode LX Video",
             0x2082: "Geode LX AES Security Block",
             0x208F: "CS5536 GeodeLink PCI South Bridge",
             0x2090: "CS5536 [Geode companion] ISA",
             0x2091: "CS5536 [Geode companion] FLASH",
             0x2093: "CS5536 [Geode companion] Audio",
             0x2094: "CS5536 [Geode companion] OHC",
             0x2095: "CS5536 [Geode companion] EHC",
             0x2096: "CS5536 [Geode companion] UDC",
             0x2097: "CS5536 [Geode companion] UOC",
             0x209A: "CS5536 [Geode companion] IDE",
             0x2625: "Am79C973 [Lance/PCI PCNet/32]",
             0x2627: "Am79C975 [Lance/PCI PCNet/32]",
             0x3000: "ELanSC520 Microcontroller",
             0x43A0: "Hudson PCI to PCI bridge (PCIE port 0)",
             0x43A1: "Hudson PCI to PCI bridge (PCIE port 1)",
             0x43A2: "Hudson PCI to PCI bridge (PCIE port 2)",
             0x43A3: "Hudson PCI to PCI bridge (PCIE port 3)",
             0x43B0: "X370 Series Chipset PCIe Upstream Port",
             0x43B1: "X399 Series Chipset PCIe Bridge",
             0x43B4: "300 Series Chipset PCIe Port",
             0x43B5: "X370 Series Chipset SATA Controller",
             0x43B6: "X399 Series Chipset SATA Controller",
             0x43B7: "300 Series Chipset SATA Controller",
             0x43B9: "X370 Series Chipset USB 3.1 xHCI Controller",
             0x43BA: "X399 Series Chipset USB 3.1 xHCI Controller",
             0x43BB: "300 Series Chipset USB 3.1 xHCI Controller",
             0x43C6: "400 Series Chipset PCIe Bridge",
             0x43C7: "400 Series Chipset PCIe Port",
             0x43C8: "400 Series Chipset SATA Controller",
             0x43D5: "400 Series Chipset USB 3.1 xHCI Compliant Host Controller",
             0x43E9: "500 Series Chipset Switch Upstream Port",
             0x43EB: "500 Series Chipset SATA Controller",
             0x43EE: "500 Series Chipset USB 3.1 XHCI Controller",
             0x57A3: "Matisse PCIe GPP Bridge",
             0x57A4: "Matisse PCIe GPP Bridge",
             0x57AD: "Matisse Switch Upstream",
             0x7006: "AMD-751 [Irongate] System Controller",
             0x7007: "AMD-751 [Irongate] AGP Bridge",
             0x700A: "AMD-IGR4 AGP Host to PCI Bridge",
             0x700B: "AMD-IGR4 PCI to PCI Bridge",
             0x700C: "AMD-760 MP [IGD4-2P] System Controller",
             0x700D: "AMD-760 MP [IGD4-2P] AGP Bridge",
             0x700E: "AMD-760 [IGD4-1P] System Controller",
             0x700F: "AMD-760 [IGD4-1P] AGP Bridge",
             0x7400: "AMD-755 [Cobra] ISA",
             0x7401: "AMD-755 [Cobra] IDE",
             0x7403: "AMD-755 [Cobra] ACPI",
             0x7404: "AMD-755 [Cobra] USB",
             0x7408: "AMD-756 [Viper] ISA",
             0x7409: "AMD-756 [Viper] IDE",
             0x740B: "AMD-756 [Viper] ACPI",
             0x740C: "AMD-756 [Viper] USB",
             0x7410: "AMD-766 [ViperPlus] ISA",
             0x7411: "AMD-766 [ViperPlus] IDE",
             0x7413: "AMD-766 [ViperPlus] ACPI",
             0x7414: "AMD-766 [ViperPlus] USB",
             0x7440: "AMD-768 [Opus] ISA",
             0x7441: "AMD-768 [Opus] IDE",
             0x7443: "AMD-768 [Opus] ACPI",
             0x7445: "AMD-768 [Opus] Audio",
             0x7446: "AMD-768 [Opus] MC97 Modem",
             0x7448: "AMD-768 [Opus] PCI",
             0x7449: "AMD-768 [Opus] USB",
             0x7450: "AMD-8131 PCI-X Bridge",
             0x7451: "AMD-8131 PCI-X IOAPIC",
             0x7454: "AMD-8151 System Controller",
             0x7455: "AMD-8151 AGP Bridge",
             0x7458: "AMD-8132 PCI-X Bridge",
             0x7459: "AMD-8132 PCI-X IOAPIC",
             0x7460: "AMD-8111 PCI",
             0x7461: "AMD-8111 USB",
             0x7462: "AMD-8111 Ethernet",
             0x7463: "AMD-8111 USB EHCI",
             0x7464: "AMD-8111 USB OHCI",
             0x7468: "AMD-8111 LPC",
             0x7469: "AMD-8111 IDE",
             0x746A: "AMD-8111 SMBus 2.0",
             0x746B: "AMD-8111 ACPI",
             0x746D: "AMD-8111 AC97 Audio",
             0x746E: "AMD-8111 MC97 Modem",
             0x756B: "AMD-8111 ACPI",
             0x7800: "FCH SATA Controller [IDE mode]",
             0x7801: "FCH SATA Controller [AHCI mode]",
             0x7802: "FCH SATA Controller [RAID mode]",
             0x7803: "FCH SATA Controller [RAID mode]",
             0x7804: "FCH SATA Controller [AHCI mode]",
             0x7805: "FCH SATA Controller [RAID mode]",
             0x7806: "FCH SD Flash Controller",
             0x7807: "FCH USB OHCI Controller",
             0x7808: "FCH USB EHCI Controller",
             0x7809: "FCH USB OHCI Controller",
             0x780A: "Kabini/Mullins SATA Raid/AHCI Mode (DotHill driver)",
             0x780B: "FCH SMBus Controller",
             0x780C: "FCH IDE Controller",
             0x780D: "FCH Azalia Controller",
             0x780E: "FCH LPC Bridge",
             0x780F: "FCH PCI Bridge",
             0x7812: "FCH USB XHCI Controller",
             0x7813: "FCH SD Flash Controller",
             0x7814: "FCH USB XHCI Controller",
             0x7900: "FCH SATA Controller [IDE mode]",
             0x7901: "FCH SATA Controller [AHCI mode]",
             0x7902: "FCH SATA Controller [RAID mode]",
             0x7903: "FCH SATA Controller [RAID mode]",
             0x7904: "FCH SATA Controller [AHCI mode]",
             0x7906: "FCH SD Flash Controller",
             0x7908: "FCH USB EHCI Controller",
             0x790B: "FCH SMBus Controller",
             0x790E: "FCH LPC Bridge",
             0x790F: "FCH PCI Bridge",
             0x7914: "FCH USB XHCI Controller",
             0x9600: "RS780 Host Bridge",
             0x9601: "RS880 Host Bridge",
             0x9602: "RS780/RS880 PCI to PCI bridge (int gfx)",
             0x9603: "RS780 PCI to PCI bridge (ext gfx port 0)",
             0x9604: "RS780/RS880 PCI to PCI bridge (PCIE port 0)",
             0x9605: "RS780/RS880 PCI to PCI bridge (PCIE port 1)",
             0x9606: "RS780 PCI to PCI bridge (PCIE port 2)",
             0x9607: "RS780/RS880 PCI to PCI bridge (PCIE port 3)",
             0x9608: "RS780/RS880 PCI to PCI bridge (PCIE port 4)",
             0x9609: "RS780/RS880 PCI to PCI bridge (PCIE port 5)",
             0x960A: "RS780 PCI to PCI bridge (NB-SB link)",
             0x960B: "RS780 PCI to PCI bridge (ext gfx port 1)",
             },

    # Trident Microsystems
    0x1023: {0x0194: "82C194",
             0x2000: "4DWave DX",
             0x2001: "4DWave NX",
             0x2100: "CyberBlade XP4m32",
             0x2200: "XGI Volari XP5",
             0x8400: "CyberBlade/i7",
             0x8420: "CyberBlade/i7d",
             0x8500: "CyberBlade/i1",
             0x8520: "CyberBlade i1",
             0x8620: "CyberBlade/i1",
             0x8820: "CyberBlade XPAi1",
             0x9320: "TGUI 9320",
             0x9350: "GUI Accelerator",
             0x9360: "Flat panel GUI Accelerator",
             0x9382: "Cyber 9382 [Reference design]",
             0x9383: "Cyber 9383 [Reference design]",
             0x9385: "Cyber 9385 [Reference design]",
             0x9386: "Cyber 9386",
             0x9388: "Cyber 9388",
             0x9397: "Cyber 9397",
             0x939A: "Cyber 9397DVD",
             0x9420: "TGUI 9420",
             0x9430: "TGUI 9430",
             0x9440: "TGUI 9440",
             0x9460: "TGUI 9460",
             0x9470: "TGUI 9470",
             0x9520: "Cyber 9520",
             0x9525: "Cyber 9525",
             0x9540: "Cyber 9540",
             0x9660: "TGUI 9660/938x/968x",
             0x9680: "TGUI 9680",
             0x9682: "TGUI 9682",
             0x9683: "TGUI 9683",
             0x9685: "ProVIDIA 9685",
             0x9750: "3DImage 9750",
             0x9753: "TGUI 9753",
             0x9754: "TGUI 9754",
             0x9759: "TGUI 975",
             0x9783: "TGUI 9783",
             0x9785: "TGUI 9785",
             0x9850: "3DImage 9850",
             0x9880: "Blade 3D PCI/AGP",
             0x9910: "CyberBlade/XP",
             0x9930: "CyberBlade/XPm",
             0x9960: "CyberBlade XP2",
             },

    # Acer Incorporated [ALI]
    0x1025: {0x1435: "M1435",
             0x1445: "M1445",
             0x1449: "M1449",
             0x1451: "M1451",
             0x1461: "M1461",
             0x1489: "M1489",
             0x1511: "M1511",
             0x1512: "ALI M1512 Aladdin",
             0x1513: "M1513",
             0x1521: "ALI M1521 Aladdin III CPU Bridge",
             0x1523: "ALI M1523 ISA Bridge",
             0x1531: "M1531 Northbridge [Aladdin IV/IV+]",
             0x1533: "M1533 PCI-to-ISA Bridge",
             0x1535: "M1535 PCI Bridge + Super I/O + FIR",
             0x1541: "M1541 Northbridge [Aladdin V]",
             0x1542: "M1542 Northbridge [Aladdin V]",
             0x1543: "M1543 PCI-to-ISA Bridge + Super I/O + FIR",
             0x1561: "M1561 Northbridge [Aladdin 7]",
             0x1621: "M1621 Northbridge [Aladdin-Pro II]",
             0x1631: "M1631 Northbridge+3D Graphics [Aladdin TNT2]",
             0x1641: "M1641 Northbridge [Aladdin-Pro IV]",
             0x1647: "M1647 [MaGiK1] PCI North Bridge",
             0x1671: "M1671 Northbridge [ALADDiN-P4]",
             0x1672: "Northbridge [CyberALADDiN-P4]",
             0x3141: "M3141",
             0x3143: "M3143",
             0x3145: "M3145",
             0x3147: "M3147",
             0x3149: "M3149",
             0x3151: "M3151",
             0x3307: "M3307 MPEG-I Video Controller",
             0x3309: "M3309 MPEG-II Video w/ Software Audio Decoder",
             0x3321: "M3321 MPEG-II Audio/Video Decoder",
             0x5212: "M4803",
             0x5215: "ALI PCI EIDE Controller",
             0x5217: "M5217H",
             0x5219: "M5219",
             0x5225: "M5225",
             0x5229: "M5229",
             0x5235: "M5235",
             0x5237: "M5237 PCI USB Host Controller",
             0x5240: "EIDE Controller",
             0x5241: "PCMCIA Bridge",
             0x5242: "General Purpose Controller",
             0x5243: "PCI to PCI Bridge Controller",
             0x5244: "Floppy Disk Controller",
             0x5247: "M1541 PCI to PCI Bridge",
             0x5251: "M5251 P1394 Controller",
             0x5427: "PCI to AGP Bridge",
             0x5451: "M5451 PCI AC-Link Controller Audio Device",
             0x5453: "M5453 PCI AC-Link Controller Modem Device",
             0x7101: "M7101 PCI PMU Power Management Controller",
             0x9602: "AMD RS780/RS880 PCI to PCI bridge (int gfx)",
             },

    # Dell
    0x1028: {0x0001: "PowerEdge Expandable RAID Controller 2/Si",
             0x0002: "PowerEdge Expandable RAID Controller 3/Di",
             0x0003: "PowerEdge Expandable RAID Controller 3/Si",
             0x0004: "PowerEdge Expandable RAID Controller 3/Di [Iguana]",
             0x0006: "PowerEdge Expandable RAID Controller 3/Di",
             0x0007: "Remote Access Card III",
             0x0008: "Remote Access Card III",
             0x0009: "Remote Access Card III: BMC/SMIC device not present",
             0x000A: "PowerEdge Expandable RAID Controller 3/Di",
             0x000C: "Embedded Remote Access or ERA/O",
             0x000D: "Embedded Remote Access: BMC/SMIC device",
             0x000E: "PowerEdge Expandable RAID controller 4/Di",
             0x000F: "PowerEdge Expandable RAID controller 4/Di",
             0x0010: "Remote Access Card 4",
             0x0011: "Remote Access Card 4 Daughter Card",
             0x0012: "Remote Access Card 4 Daughter Card Virtual UART",
             0x0013: "PowerEdge Expandable RAID controller 4",
             0x0014: "Remote Access Card 4 Daughter Card SMIC interface",
             0x0015: "PowerEdge Expandable RAID controller 5",
             0x0016: "PowerEdge Expandable RAID controller S300",
             0x0073: "NV-RAM Adapter",
             0x1028: "PCIe Bridge riser",
             0x2600: "ENT NVMe RT1",
             },

    # LSI Logic
    0x102A: {0x0000: "HYDRA",
             0x0010: "ASPEN",
             0x001F: "AHA-2940U2/U2W /7890/7891 SCSI Controllers",
             0x00C5: "AIC-7899 U160/m SCSI Controller",
             0x00CF: "AIC-7899P U160/m",
             },

    # Matrox Electronics Systems Ltd.
    0x102B: {0x0010: "MGA-I [Impression?]",
             0x0100: "MGA 1064SG [Mystique]",
             0x0518: "MGA-II [Athena]",
             0x0519: "MGA 2064W [Millennium]",
             0x051A: "MGA 1064SG [Mystique]",
             0x051B: "MGA 2164W [Millennium II]",
             0x051E: "MGA 1064SG [Mystique] AGP",
             0x051F: "MGA 2164W [Millennium II] AGP",
             0x0520: "MGA G200",
             0x0521: "MGA G200 AGP",
             0x0522: "MGA G200e [Pilot] ServerEngines (SEP1)",
             0x0525: "MGA G400/G450",
             0x0527: "Parhelia",
             0x0528: "Parhelia",
             0x0530: "MGA G200EV",
             0x0532: "MGA G200eW WPCM450",
             0x0533: "MGA G200EH",
             0x0534: "G200eR2",
             0x0536: "Integrated Matrox G200eW3 Graphics Controller",
             0x0538: "MGA G200eH3",
             0x0540: "M91XX",
             0x0550: "SV2",
             0x0D10: "MGA Ultima/Impression",
             0x1000: "MGA G100 [Productiva]",
             0x1001: "MGA G100 [Productiva] AGP",
             0x2007: "MGA Mistral",
             0x2527: "Millennium G550",
             0x2537: "Millennium P650/P750",
             0x2538: "Millennium P650 PCIe",
             0x2539: "Millennium P690",
             0x4164: "Morphis QxT frame grabber",
             0x43B4: "Morphis Qxt encoding engine",
             0x4510: "Morphis COM port",
             0x4536: "VIA Framegrabber",
             0x4686: "Concord GX (customized Intel 82541)",
             0x475B: "Solios eCL/XCL-B frame grabber",
             0x475D: "Vio frame grabber family",
             0x475F: "Solios (single-Full) CL frame grabber",
             0x47A1: "Solios eA/XA frame grabber",
             0x47A2: "Solios COM port",
             0x47C1: "Solios (dual-Base/single-Medium) CL frame grabber",
             0x47C2: "Solios COM port",
             0x4949: "Radient frame grabber family",
             0x4CDC: "Morphis JPEG2000 accelerator",
             0x4F54: "Morphis (e)Quad frame grabber",
             0x4FC5: "Morphis (e)Dual frame grabber",
             0x5E10: "Morphis aux I/O",
             0x6573: "Shark 10/100 Multiport SwitchNIC",
             },

    # Chips and Technologies
    0x102C: {0x00B8: "F64310",
             0x00C0: "F69000 HiQVideo",
             0x00D0: "F65545",
             0x00D8: "F65545",
             0x00DC: "F65548",
             0x00E0: "F65550",
             0x00E4: "F65554",
             0x00E5: "F65555 HiQVPro",
             0x00F0: "F68554",
             0x00F4: "F68554 HiQVision",
             0x00F5: "F68555",
             0x0C30: "F69030",
             },

    # Toshiba America
    0x102F: {0x0009: "r4x00",
             0x000A: "TX3927 MIPS RISC PCI Controller",
             0x0020: "ATM Meteor 155",
             0x0030: "TC35815CF PCI 10/100 Mbit Ethernet Controller",
             0x0031: "TC35815CF PCI 10/100 Mbit Ethernet Controller with WOL",
             0x0032: "TC35815CF PCI 10/100 Mbit Ethernet Controller on TX4939",
             0x0105: "TC86C001 [goku-s] IDE",
             0x0106: "TC86C001 [goku-s] USB 1.1 Host",
             0x0107: "TC86C001 [goku-s] USB Device Controller",
             0x0108: "TC86C001 [goku-s] I2C/SIO/GPIO Controller",
             0x0180: "TX4927/38 MIPS RISC PCI Controller",
             0x0181: "TX4925 MIPS RISC PCI Controller",
             0x0182: "TX4937 MIPS RISC PCI Controller",
             0x01B4: "Celleb platform IDE interface",
             0x01B5: "SCC USB 2.0 EHCI controller",
             0x01B6: "SCC USB 1.1 OHCI controller",
             },

    # Miro Computer Products AG
    0x1031: {0x5601: "DC20 ASIC",
             0x5607: "Video I/O & motion JPEG compressor",
             0x5631: "Media 3D",
             0x6057: "MiroVideo DC10/DC30+",
             },

    # NEC Corporation
    0x1033: {0x0000: "Vr4181A USB Host or Function Control Unit",
             0x0001: "PCI to 486-like bus Bridge",
             0x0002: "PCI to VL98 Bridge",
             0x0003: "ATM Controller",
             0x0004: "R4000 PCI Bridge",
             0x0005: "PCI to 486-like bus Bridge",
             0x0006: "PC-9800 Graphic Accelerator",
             0x0007: "PCI to UX-Bus Bridge",
             0x0008: "PC-9800 Graphic Accelerator",
             0x0009: "PCI to PC9800 Core-Graph Bridge",
             0x0016: "PCI to VL Bridge",
             0x001A: "[Nile II]",
             0x0021: "Vrc4373 [Nile I]",
             0x0029: "PowerVR PCX1",
             0x002A: "PowerVR 3D",
             0x002C: "Star Alpha 2",
             0x002D: "PCI to C-bus Bridge",
             0x0035: "OHCI USB Controller",
             0x003B: "PCI to C-bus Bridge",
             0x003E: "NAPCCARD Cardbus Controller",
             0x0046: "PowerVR PCX2 [midas]",
             0x005A: "Vrc5074 [Nile 4]",
             0x0063: "uPD72862 [Firewarden] IEEE1394 OHCI 1.0 Link Controller",
             0x0067: "PowerVR Neon 250 Chipset",
             0x0072: "uPD72874 IEEE1394 OHCI 1.1 3-port PHY-Link Ctrlr",
             0x0074: "56k Voice Modem",
             0x009B: "Vrc5476",
             0x00A5: "VRC4173",
             0x00A6: "VRC5477 AC97",
             0x00CD: "uPD72870 [Firewarden] IEEE1394a OHCI 1.0 Link/3-port PHY Controller",
             0x00CE: "uPD72871 [Firewarden] IEEE1394a OHCI 1.0 Link/1-port PHY Controller",
             0x00DF: "Vr4131",
             0x00E0: "uPD72010x USB 2.0 Controller",
             0x00E7: "uPD72873 [Firewarden] IEEE1394a OHCI 1.1 Link/2-port PHY Controller",
             0x00F2: "uPD72874 [Firewarden] IEEE1394a OHCI 1.1 Link/3-port PHY Controller",
             0x00F3: "uPD6113x Multimedia Decoder/Processor [EMMA2]",
             0x010C: "VR7701",
             0x0125: "uPD720400 PCI Express - PCI/PCI-X Bridge",
             0x013A: "Dual Tuner/MPEG Encoder",
             0x0194: "uPD720200 USB 3.0 Host Controller",
             0x01E7: "uPD72873 [Firewarden] IEEE1394a OHCI 1.1 Link/2-port PHY Controller",
             0x01F2: "uPD72874 [Firewarden] IEEE1394a OHCI 1.1 Link/3-port PHY Controller",
             },

    # Silicon Integrated Systems [SiS]
    0x1039: {0x0001: "AGP Port (virtual PCI-to-PCI bridge)",
             0x0002: "AGP Port (virtual PCI-to-PCI bridge)",
             0x0003: "AGP Port (virtual PCI-to-PCI bridge)",
             0x0004: "PCI-to-PCI bridge",
             0x0006: "85C501/2/3",
             0x0008: "SiS85C503/5513 (LPC Bridge)",
             0x0009: "5595 Power Management Controller",
             0x000A: "PCI-to-PCI bridge",
             0x0016: "SiS961/2/3 SMBus controller",
             0x0018: "SiS85C503/5513 (LPC Bridge)",
             0x0163: "163 802.11b/g Wireless LAN Adapter",
             0x0180: "RAID bus controller 180 SATA/PATA  [SiS]",
             0x0181: "SATA",
             0x0182: "182 SATA/RAID Controller",
             0x0186: "AHCI Controller (0106)",
             0x0190: "190 Ethernet Adapter",
             0x0191: "191 Gigabit Ethernet Adapter",
             0x0200: "5597/5598/6326 VGA",
             0x0204: "82C204",
             0x0205: "SG86C205",
             0x0300: "300/305 PCI/AGP VGA Display Adapter",
             0x0310: "315H PCI/AGP VGA Display Adapter",
             0x0315: "315 PCI/AGP VGA Display Adapter",
             0x0325: "315PRO PCI/AGP VGA Display Adapter",
             0x0330: "330 [Xabre] PCI/AGP VGA Display Adapter",
             0x0406: "85C501/2",
             0x0496: "SiS85C496 PCI & CPU Memory Controller (PCM)",
             0x0530: "530 Host",
             0x0540: "540 Host",
             0x0550: "550 Host",
             0x0597: "5513C",
             0x0601: "85C601",
             0x0620: "620 Host",
             0x0630: "630 Host",
             0x0633: "633 Host",
             0x0635: "635 Host",
             0x0645: "SiS645 Host & Memory & AGP Controller",
             0x0646: "SiS645DX Host & Memory & AGP Controller",
             0x0648: "645xx",
             0x0649: "SiS649 Host",
             0x0650: "650/M650 Host",
             0x0651: "651 Host",
             0x0655: "655 Host",
             0x0660: "660 Host",
             0x0661: "661FX/M661FX/M661MX Host",
             0x0662: "662 Host",
             0x0671: "671MX",
             0x0730: "730 Host",
             0x0733: "733 Host",
             0x0735: "735 Host",
             0x0740: "740 Host",
             0x0741: "741/741GX/M741 Host",
             0x0745: "745 Host",
             0x0746: "746 Host",
             0x0755: "755 Host",
             0x0760: "760/M760 Host",
             0x0761: "761/M761 Host",
             0x0900: "SiS900 PCI Fast Ethernet",
             0x0961: "SiS961 [MuTIOL Media IO]",
             0x0962: "SiS962 [MuTIOL Media IO] LPC Controller",
             0x0963: "SiS963 [MuTIOL Media IO] LPC Controller",
             0x0964: "SiS964 [MuTIOL Media IO] LPC Controller",
             0x0965: "SiS965 [MuTIOL Media IO]",
             0x0966: "SiS966 [MuTIOL Media IO]",
             0x0968: "SiS968 [MuTIOL Media IO]",
             0x1180: "SATA Controller / IDE mode",
             0x1182: "SATA Controller / RAID mode",
             0x1183: "SATA Controller / IDE mode",
             0x1184: "AHCI Controller / RAID mode",
             0x1185: "AHCI IDE Controller (0106)",
             0x3602: "83C602",
             0x5107: "5107",
             0x5300: "SiS540 PCI Display Adapter",
             0x5315: "550 PCI/AGP VGA Display Adapter",
             0x5401: "486 PCI Chipset",
             0x5511: "5511/5512",
             0x5513: "5513 IDE Controller",
             0x5517: "5517",
             0x5571: "5571",
             0x5581: "5581 Pentium Chipset",
             0x5582: "5582",
             0x5591: "5591/5592 Host",
             0x5596: "5596 Pentium Chipset",
             0x5597: "5597 [SiS5582]",
             0x5600: "5600 Host",
             0x6204: "Video decoder & MPEG interface",
             0x6205: "VGA Controller",
             0x6236: "6236 3D-AGP",
             0x6300: "630/730 PCI/AGP VGA Display Adapter",
             0x6306: "530/620 PCI/AGP VGA Display Adapter",
             0x6325: "65x/M650/740 PCI/AGP VGA Display Adapter",
             0x6326: "86C326 5598/6326",
             0x6330: "661/741/760 PCI/AGP or 662/761Gx PCIE VGA Display Adapter",
             0x6350: "770/670 PCIE VGA Display Adapter",
             0x6351: "771/671 PCIE VGA Display Adapter",
             0x7001: "USB 1.1 Controller",
             0x7002: "USB 2.0 Controller",
             0x7007: "FireWire Controller",
             0x7012: "SiS7012 AC'97 Sound Controller",
             0x7013: "AC'97 Modem Controller",
             0x7016: "SiS7016 PCI Fast Ethernet Adapter",
             0x7018: "SiS PCI Audio Accelerator",
             0x7019: "SiS7019 Audio Accelerator",
             0x7502: "Azalia Audio Controller",
             },

    # Hewlett-Packard Company
    0x103C: {0x1005: "A4977A Visualize EG",
             0x1008: "Visualize FX",
             0x1028: "Tach TL Fibre Channel Host Adapter",
             0x1029: "Tach XL2 Fibre Channel Host Adapter",
             0x102A: "Tach TS Fibre Channel Host Adapter",
             0x1030: "J2585A DeskDirect 10/100VG NIC",
             0x1031: "J2585B HP 10/100VG PCI LAN Adapter",
             0x1040: "J2973A DeskDirect 10BaseT NIC",
             0x1041: "J2585B DeskDirect 10/100 NIC",
             0x1042: "J2970A DeskDirect 10BaseT/2 NIC",
             0x1048: "Diva Serial [GSP] Multiport UART",
             0x1054: "PCI Local Bus Adapter",
             0x1064: "79C970 PCnet Ethernet Controller",
             0x108B: "Visualize FXe",
             0x10C1: "NetServer Smart IRQ Router",
             0x10ED: "TopTools Remote Control",
             0x10F0: "rio System Bus Adapter",
             0x10F1: "rio I/O Controller",
             0x1219: "NetServer PCI Hot-Plug Controller",
             0x121A: "NetServer SMIC Controller",
             0x121B: "NetServer Legacy COM Port Decoder",
             0x121C: "NetServer PCI COM Port Decoder",
             0x1229: "zx1 System Bus Adapter",
             0x122A: "zx1 I/O Controller",
             0x122E: "PCI-X Local Bus Adapter",
             0x127B: "sx1000 System Bus Adapter",
             0x127C: "sx1000 I/O Controller",
             0x128D: "Diva [GSP] Management Board",
             0x1290: "Auxiliary Diva Serial Port",
             0x1291: "Auxiliary Diva Serial Port",
             0x12B4: "zx1 QuickSilver AGP8x Local Bus Adapter",
             0x12EB: "sx2000 System Bus Adapter",
             0x12EC: "sx2000 I/O Controller",
             0x12EE: "PCI-X 2.0 Local Bus Adapter",
             0x1302: "RMP-3 Shared Memory Driver",
             0x1303: "RMP-3 (Remote Management Processor)",
             0x22F6: "iLO5 Virtual USB Controller",
             0x2910: "E2910A PCIBus Exerciser",
             0x2925: "E2925A 32 Bit, 33 MHzPCI Exerciser & Analyzer",
             0x3206: "Adaptec Embedded Serial ATA HostRAID",
             0x3220: "Smart Array P600",
             0x3230: "Smart Array Controller",
             0x3238: "Smart Array E200i (SAS Controller)",
             0x3239: "Smart Array Gen9 Controllers",
             0x323A: "Smart Array G6 controllers",
             0x323B: "Smart Array Gen8 Controllers",
             0x323C: "Smart Array Gen8+ Controllers",
             0x3300: "Integrated Lights-Out Standard Virtual USB Controller",
             0x3301: "Integrated Lights-Out Standard Serial Port",
             0x3302: "Integrated Lights-Out Standard KCS Interface",
             0x3305: "Integrated Lights-Out (iLO2) Controller",
             0x3306: "Integrated Lights-Out Standard Slave Instrumentation & System Support",
             0x3307: "Integrated Lights-Out Standard Management Processor Support and Messaging",
             0x3308: "Integrated Lights-Out Standard MS Watchdog Timer",
             0x4030: "zx2 System Bus Adapter",
             0x4031: "zx2 I/O Controller",
             0x4037: "PCIe Local Bus Adapter",
             0x9602: "AMD RS780/RS880 PCI to PCI bridge (int gfx)",
             },

    # Micron
    0x1042: {0x1000: "PC Tech RZ1000",
             0x1001: "PC Tech RZ1001",
             0x3000: "Samurai_0",
             0x3010: "Samurai_1",
             0x3020: "Samurai_IDE",
             },

    # ASUSTeK Computer Inc.
    0x1043: {0x0464: "Radeon R9 270x GPU",
             0x0521: "RX580 [RX 580 Dual O8G]",
             0x0675: "ISDNLink P-IN100-ST-D",
             0x9602: "AMD RS780/RS880 PCI to PCI bridge (int gfx)",
             },

    # Adaptec (formerly DPT)
    0x1044: {0x1012: "Domino RAID Engine",
             0xA400: "SmartCache/Raid I-IV Controller",
             0xA500: "PCI Bridge",
             0xA501: "SmartRAID V Controller",
             0xA511: "SmartRAID V Controller",
             0xC066: "3010S Ultra3 Dual Channel",
             },

    # OPTi Inc.
    0x1045: {0xA0F8: "82C750 [Vendetta] USB Controller",
             0xC101: "92C264",
             0xC178: "92C178",
             0xC556: "82X556 [Viper]",
             0xC557: "82C557 [Viper-M]",
             0xC558: "82C558 [Viper-M ISA+IDE]",
             0xC567: "82C750 [Vendetta], device 0",
             0xC568: "82C750 [Vendetta], device 1",
             0xC569: "82C579 [Viper XPress+ Chipset]",
             0xC621: "82C621 [Viper-M/N+]",
             0xC700: "82C700 [FireStar]",
             0xC701: "82C701 [FireStar Plus]",
             0xC814: "82C814 [Firebridge 1]",
             0xC822: "82C822",
             0xC824: "82C824",
             0xC825: "82C825 [Firebridge 2]",
             0xC832: "82C832",
             0xC861: "82C861 OHCI USB Host",
             0xC881: "82C881 [FireLink] 1394 OHCI Link Controller",
             0xC895: "82C895",
             0xC935: "EV1935 ECTIVA MachOne PCIAudio",
             0xD568: "82C825 [Firebridge 2]",
             0xD721: "IDE [FireStar]",
             },

    # Elsa AG
    0x1048: {0x0C60: "Gladiac MX",
             0x0D22: "Quadro4 900XGL [ELSA GLoria4 900XGL]",
             0x1000: "QuickStep 1000",
             0x3000: "QuickStep 3000",
             0x8901: "Gloria XL",
             },

    # STMicroelectronics
    0x104A: {0x0000: "STLS2F Host Bridge",
             0x0008: "STG 2000X",
             0x0009: "STG 1764X",
             0x0010: "STG4000 [3D Prophet Kyro Series]",
             0x0201: "STPC Vega Northbridge",
             0x0209: "STPC Consumer/Industrial North- and Southbridge",
             0x020A: "STPC Atlas/ConsumerS/Consumer IIA Northbridge",
             0x020B: "STPC Consumer II ISA Bridge",
             0x0210: "STPC Atlas ISA Bridge",
             0x021A: "STPC Consumer S Southbridge",
             0x021B: "STPC Consumer IIA Southbridge",
             0x0220: "STPC Industrial PCI to PCCard bridge",
             0x0228: "STPC Atlas IDE",
             0x0229: "STPC Vega IDE",
             0x0230: "STPC Atlas/Vega OHCI USB Controller",
             0x0238: "STPC Vega LAN",
             0x0500: "ST70137 [Unicorn] ADSL DMT Transceiver",
             0x0564: "STPC Client Northbridge",
             0x0981: "21x4x DEC-Tulip compatible 10/100 Ethernet",
             0x1746: "STG 1764X",
             0x2774: "21x4x DEC-Tulip compatible 10/100 Ethernet",
             0x3520: "MPEG-II decoder card",
             0x55CC: "STPC Client Southbridge",
             },

    # BusLogic
    0x104B: {0x0140: "BT-946C (old) [multimaster  01]",
             0x1040: "BT-946C (BA80C30) [MultiMaster 10]",
             0x8130: "Flashpoint LT",
             },

    # Texas Instruments
    0x104C: {0x0500: "100 MBit LAN Controller",
             0x0508: "TMS380C2X Compressor Interface",
             0x1000: "Eagle i/f AS",
             0x104C: "PCI1510 PC card Cardbus Controller",
             0x3D04: "TVP4010 [Permedia]",
             0x3D07: "TVP4020 [Permedia 2]",
             0x8000: "PCILynx/PCILynx2 IEEE 1394 Link Layer Controller",
             0x8009: "TSB12LV22 IEEE-1394 Controller",
             0x8017: "PCI4410 FireWire Controller",
             0x8019: "TSB12LV23 IEEE-1394 Controller",
             0x8020: "TSB12LV26 IEEE-1394 Controller (Link)",
             0x8021: "TSB43AA22 IEEE-1394 Controller (PHY/Link Integrated)",
             0x8022: "TSB43AB22 IEEE-1394a-2000 Controller (PHY/Link) [iOHCI-Lynx]",
             0x8023: "TSB43AB22A IEEE-1394a-2000 Controller (PHY/Link) [iOHCI-Lynx]",
             0x8024: "TSB43AB23 IEEE-1394a-2000 Controller (PHY/Link)",
             0x8025: "TSB82AA2 IEEE-1394b Link Layer Controller",
             0x8026: "TSB43AB21 IEEE-1394a-2000 Controller (PHY/Link)",
             0x8027: "PCI4451 IEEE-1394 Controller",
             0x8029: "PCI4510 IEEE-1394 Controller",
             0x802B: "PCI7410,7510,7610 OHCI-Lynx Controller",
             0x802E: "PCI7x20 1394a-2000 OHCI Two-Port PHY/Link-Layer Controller",
             0x8031: "PCIxx21/PCIxx11/PCIx515 PC Card Controller",
             0x8032: "OHCI Compliant IEEE 1394 Host Controller",
             0x8033: "PCIxx21/PCIxx11 Flash Media Controller",
             0x8034: "PCIxx21/PCIxx11 SD Host Controller",
             0x8035: "PCIxx21/PCIxx11 Smart Card Controller",
             0x8036: "PCI6515 Cardbus Controller",
             0x8038: "PCI6515 SmartCard Controller",
             0x8039: "PCIxx12 Cardbus Controller",
             0x803A: "PCIxx12 OHCI Compliant IEEE 1394 Host Controller",
             0x803B: "PCIxx12 Flash Media Controller",
             0x803C: "PCIxx12 SDA Standard Compliant SD Host Controller",
             0x803D: "PCIxx12 GemCore based SmartCard controller",
             0x8101: "TSB43DB42 IEEE-1394a-2000 Controller (PHY/Link)",
             0x8201: "PCI1620 Firmware Loading Function",
             0x8204: "PCI7410/7510/7610 PCI Firmware Loading Function",
             0x8231: "XIO2000(A)/XIO2200A PCI Express-to-PCI Bridge",
             0x8232: "XIO3130 PCI Express Switch (Upstream)",
             0x8233: "XIO3130 PCI Express Switch (Downstream)",
             0x8235: "XIO2200A IEEE-1394a-2000 Controller (PHY/Link)",
             0x823E: "XIO2213A/B/XIO2221 PCI Express to PCI Bridge [Cheetah Express]",
             0x823F: "XIO2213A/B/XIO2221 IEEE-1394b OHCI Controller [Cheetah Express]",
             0x8240: "XIO2001 PCI Express-to-PCI Bridge",
             0x8241: "TUSB73x0 SuperSpeed USB 3.0 xHCI Host Controller",
             0x8400: "ACX 100 22Mbps Wireless Interface",
             0x8401: "ACX 100 22Mbps Wireless Interface",
             0x8888: "Multicore DSP+ARM KeyStone II SOC",
             0x9000: "Wireless Interface (of unknown type)",
             0x9065: "TMS320DM642",
             0x9066: "ACX 111 54Mbps Wireless Interface",
             0xA001: "TDC1570",
             0xA100: "TDC1561",
             0xA102: "TNETA1575 HyperSAR Plus w/PCI Host i/f & UTOPIA i/f",
             0xA106: "TMS320C6414 TMS320C6415 TMS320C6416",
             0xAC10: "PCI1050",
             0xAC11: "PCI1053",
             0xAC12: "PCI1130",
             0xAC13: "PCI1031",
             0xAC15: "PCI1131",
             0xAC16: "PCI1250",
             0xAC17: "PCI1220",
             0xAC18: "PCI1260",
             0xAC19: "PCI1221",
             0xAC1A: "PCI1210",
             0xAC1B: "PCI1450",
             0xAC1C: "PCI1225",
             0xAC1D: "PCI1251A",
             0xAC1E: "PCI1211",
             0xAC1F: "PCI1251B",
             0xAC20: "TI 2030",
             0xAC21: "PCI2031",
             0xAC22: "PCI2032 PCI Docking Bridge",
             0xAC23: "PCI2250 PCI-to-PCI Bridge",
             0xAC28: "PCI2050 PCI-to-PCI Bridge",
             0xAC2C: "PCI2060 PCI-to-PCI Bridge",
             0xAC30: "PCI1260 PC card Cardbus Controller",
             0xAC40: "PCI4450 PC card Cardbus Controller",
             0xAC41: "PCI4410 PC card Cardbus Controller",
             0xAC42: "PCI4451 PC card Cardbus Controller",
             0xAC44: "PCI4510 PC card Cardbus Controller",
             0xAC46: "PCI4520 PC card Cardbus Controller",
             0xAC47: "PCI7510 PC card Cardbus Controller",
             0xAC48: "PCI7610 PC Card Cardbus Controller",
             0xAC49: "PCI7410 PC Card Cardbus Controller",
             0xAC4A: "PCI7510/7610 CardBus Bridge",
             0xAC4B: "PCI7610 SD/MMC controller",
             0xAC4C: "PCI7610 Memory Stick controller",
             0xAC50: "PCI1410 PC card Cardbus Controller",
             0xAC51: "PCI1420 PC card Cardbus Controller",
             0xAC52: "PCI1451 PC card Cardbus Controller",
             0xAC53: "PCI1421 PC card Cardbus Controller",
             0xAC54: "PCI1620 PC Card Controller",
             0xAC55: "PCI1520 PC card Cardbus Controller",
             0xAC56: "PCI1510 PC card Cardbus Controller",
             0xAC60: "PCI2040 PCI to DSP Bridge Controller",
             0xAC8D: "PCI 7620",
             0xAC8E: "PCI7420 CardBus Controller",
             0xAC8F: "PCI7420/7620 SD/MS-Pro Controller",
             0xB001: "TMS320C6424",
             0xFE00: "FireWire Host Controller",
             0xFE03: "12C01A FireWire Host Controller",
             },

    # Sony Corporation
    0x104D: {0x8004: "DTL-H2500 [Playstation development board]",
             0x8009: "CXD1947Q i.LINK Controller",
             0x800C: "DTL-H800 [PS1 sound development board]",
             0x8039: "CXD3222 i.LINK Controller",
             0x8047: "PS2 TOOL MRP",
             0x8056: "Rockwell HCF 56K modem",
             0x808A: "Memory Stick Controller",
             0x80FF: "PS2 Performance Analyzer",
             0x814A: "PS2 Performance Analyzer",
             0x8183: "ATHENS [PS3 prototype developer interface card]",
             0x81B0: "BM-1 [PSP TOOL Board Management Device]",
             0x81C3: "VO-4 [PSP TOOL Video Output Device]",
             0x81CE: "SxS Pro memory card",
             0x81FF: "PS3 TOOL MRP",
             0x8200: "PS3 TOOL RSX Tracing FPGA",
             0x820E: "CXD9208GP [PS3 PS2 emulation subsystem adapter]",
             0x905C: "SxS Pro memory card",
             0x907F: "SxS Pro+ memory card",
             0x908F: "Aeolia ACPI",
             0x909E: "Aeolia Ethernet Controller (Marvell Yukon 2 Family)",
             0x909F: "Aeolia SATA AHCI Controller",
             0x90A0: "Aeolia SD/MMC Host Controller",
             0x90A1: "Aeolia PCI Express Glue and Miscellaneous Devices",
             0x90A2: "Aeolia DMA Controller",
             0x90A3: "Aeolia Memory (DDR3/SPM)",
             0x90A4: "Aeolia USB 3.0 xHCI Host Controller",
             0x90BC: "SxS Pro+ memory card",
             0x90C0: "PCIe x8 XAVC Codec Board",
             0x90C8: "Belize ACPI",
             0x90C9: "Belize Ethernet Controller",
             0x90CA: "Belize SATA AHCI Controller",
             0x90CB: "Belize SD/MMC Host Controller",
             0x90CC: "Belize PCI Express Glue and Miscellaneous Devices",
             0x90CD: "Belize DMA Controller",
             0x90CE: "Belize Memory (DDR3/SPM)",
             0x90CF: "Belize USB 3.0 xHCI Host Controller",
             0x90D7: "Baikal ACPI",
             0x90D8: "Baikal Ethernet Controller",
             0x90D9: "Baikal SATA AHCI Controller",
             0x90DA: "Baikal SD/MMC Host Controller",
             0x90DB: "Baikal PCI Express Glue and Miscellaneous Devices",
             0x90DC: "Baikal DMA Controller",
             0x90DD: "Baikal Memory (DDR3/SPM)",
             0x90DE: "Baikal USB 3.0 xHCI Host Controller",
             },

    # Oak Technology, Inc
    0x104E: {0x0017: "OTI-64017",
             0x0107: "OTI-107 [Spitfire]",
             0x0109: "Video Adapter",
             0x0111: "OTI-64111 [Spitfire]",
             0x0217: "OTI-64217",
             0x0317: "OTI-64317",
             },

    # Winbond Electronics Corp
    0x1050: {0x0000: "NE2000",
             0x0001: "W83769F",
             0x0033: "W89C33D 802.11 a/b/g BB/MAC",
             0x0105: "W82C105",
             0x0840: "W89C840",
             0x0940: "W89C940",
             0x5A5A: "W89C940F",
             0x6692: "W6692",
             0x9921: "W99200F MPEG-1 Video Encoder",
             0x9922: "W99200F/W9922PF MPEG-1/2 Video Encoder",
             0x9970: "W9970CF",
             },

    # Hitachi, Ltd
    0x1054: {0x3009: "2Gbps Fibre Channel to PCI HBA 3009",
             0x300A: "4Gbps Fibre Channel to PCI-X HBA 300a",
             0x300B: "4Gbps Fibre Channel to PCI-X HBA 300b",
             0x300F: "ColdFusion 3 Chipset Processor to I/O Controller",
             0x3010: "ColdFusion 3 Chipset Memory Controller Hub",
             0x3011: "ColdFusion 3e Chipset Processor to I/O Controller",
             0x3012: "ColdFusion 3e Chipset Memory Controller Hub",
             0x3017: "Unassigned Hitachi Shared FC Device 3017",
             0x301B: "Virtual VGA Device",
             0x301D: "PCIe-to-PCIe Bridge with Virtualization IO Assist Feature",
             0x3020: "FIVE-EX based Fibre Channel to PCIe HBA",
             0x302C: "M001 PCI Express Switch Upstream Port",
             0x302D: "M001 PCI Express Switch Downstream Port",
             0x3070: "Hitachi FIVE-FX Fibre Channel to PCIe HBA",
             0x3505: "SH7751 PCI Controller (PCIC)",
             0x350E: "SH7751R PCI Controller (PCIC)",
             },

    # Microchip Technology / SMSC
    0x1055: {0x7430: "LAN7430",
             0x7431: "LAN7431",
             0x9130: "SLC90E66 [Victory66] IDE",
             0x9460: "SLC90E66 [Victory66] ISA",
             0x9462: "SLC90E66 [Victory66] USB",
             0x9463: "SLC90E66 [Victory66] ACPI",
             0xE420: "LAN9420/LAN9420i",
             },

    # Motorola
    0x1057: {0x0001: "MPC105 [Eagle]",
             0x0002: "MPC106 [Grackle]",
             0x0003: "MPC8240 [Kahlua]",
             0x0004: "MPC107",
             0x0006: "MPC8245 [Unity]",
             0x0008: "MPC8540",
             0x0009: "MPC8560",
             0x0012: "MPC8548 [PowerQUICC III]",
             0x0100: "MC145575 [HFC-PCI]",
             0x0431: "KTI829c 100VG",
             0x1073: "Nokia N770",
             0x1219: "Nokia N800",
             0x1801: "DSP56301 Digital Signal Processor",
             0x18C0: "MPC8265A/8266/8272",
             0x18C1: "MPC8271/MPC8272",
             0x3052: "SM56 Data Fax Modem",
             0x3410: "DSP56361 Digital Signal Processor",
             0x4801: "Raven",
             0x4802: "Falcon",
             0x4803: "Hawk",
             0x4806: "CPX8216",
             0x480B: "MPC7410",
             0x4D68: "20268",
             0x5600: "SM56 PCI Modem",
             0x5608: "Wildcard X100P",
             0x5803: "MPC5200",
             0x5806: "MCF54 Coldfire",
             0x5808: "MPC8220",
             0x5809: "MPC5200B",
             0x6400: "MPC190 Security Processor (S1 family, encryption)",
             0x6405: "MPC184 Security Processor (S1 family)",
             },

    # Promise Technology, Inc.
    0x105A: {0x0D30: "PDC20265 (FastTrak100 Lite/Ultra100)",
             0x0D38: "20263",
             0x1275: "20275",
             0x3318: "PDC20318 (SATA150 TX4)",
             0x3319: "PDC20319 (FastTrak S150 TX4)",
             0x3371: "PDC20371 (FastTrak S150 TX2plus)",
             0x3373: "PDC20378 (FastTrak 378/SATA 378)",
             0x3375: "PDC20375 (SATA150 TX2plus)",
             0x3376: "PDC20376 (FastTrak 376)",
             0x3515: "PDC40719 [FastTrak TX4300/TX4310]",
             0x3519: "PDC40519 (FastTrak TX4200)",
             0x3570: "PDC20771 [FastTrak TX2300]",
             0x3571: "PDC20571 (FastTrak TX2200)",
             0x3574: "PDC20579 SATAII 150 IDE Controller",
             0x3577: "PDC40779 (SATA 300 779)",
             0x3D17: "PDC40718 (SATA 300 TX4)",
             0x3D18: "PDC20518/PDC40518 (SATAII 150 TX4)",
             0x3D73: "PDC40775 (SATA 300 TX2plus)",
             0x3D75: "PDC20575 (SATAII150 TX2plus)",
             0x3F20: "PDC42819 [FastTrak TX2650/TX4650]",
             0x4302: "80333 [SuperTrak EX4350]",
             0x4D30: "PDC20267 (FastTrak100/Ultra100)",
             0x4D33: "20246",
             0x4D38: "PDC20262 (FastTrak66/Ultra66)",
             0x4D68: "PDC20268 [Ultra100 TX2]",
             0x4D69: "20269",
             0x5275: "PDC20276 (MBFastTrak133 Lite)",
             0x5300: "DC5300",
             0x6268: "PDC20270 (FastTrak100 LP/TX2/TX4)",
             0x6269: "PDC20271 (FastTrak TX2000)",
             0x6300: "PDC81731 [FastTrak SX8300]",
             0x6621: "PDC20621 (FastTrak S150 SX4/FastTrak SX4000 lite)",
             0x6622: "PDC20621 [SATA150 SX4] 4 Channel IDE RAID Controller",
             0x6624: "PDC20621 [FastTrak SX4100]",
             0x6626: "PDC20618 (Ultra 618)",
             0x6629: "PDC20619 (FastTrak TX4000)",
             0x7275: "PDC20277 (SBFastTrak133 Lite)",
             0x8002: "SATAII150 SX8",
             0x8350: "80333 [SuperTrak EX8350/EX16350], 80331 [SuperTrak EX8300/EX16300]",
             0x8650: "81384 [SuperTrak EX SAS and SATA RAID Controller]",
             0x8760: "PM8010 [SuperTrak EX SAS and SATA 6G RAID Controller]",
             0xC350: "80333 [SuperTrak EX12350]",
             0xE350: "80333 [SuperTrak EX24350]",
             },

    # Number 9 Computer Company
    0x105D: {0x2309: "Imagine 128",
             0x2339: "Imagine 128-II",
             0x493D: "Imagine 128 T2R [Ticket to Ride]",
             0x5348: "Revolution 4",
             },

    # United Microelectronics [UMC]
    0x1060: {0x0001: "UM82C881",
             0x0002: "UM82C886",
             0x0101: "UM8673F",
             0x0881: "UM8881",
             0x0886: "UM8886F",
             0x0891: "UM8891A",
             0x1001: "UM886A",
             0x673A: "UM8886BF",
             0x673B: "EIDE Master/DMA",
             0x8710: "UM8710",
             0x886A: "UM8886A",
             0x8881: "UM8881F",
             0x8886: "UM8886F",
             0x888A: "UM8886A",
             0x8891: "UM8891A",
             0x9017: "UM9017F",
             0x9018: "UM9018",
             0x9026: "UM9026",
             0xE881: "UM8881N",
             0xE886: "UM8886N",
             0xE88A: "UM8886N",
             0xE891: "UM8891N",
             },

    # I.I.T.
    0x1061: {0x0001: "AGX016",
             0x0002: "IIT3204/3501",
             },

    # PicoPower Technology
    0x1066: {0x0000: "PT80C826",
             0x0001: "PT86C521 [Vesuvius v1] Host Bridge",
             0x0002: "PT86C523 [Vesuvius v3] PCI-ISA Bridge Master",
             0x0003: "PT86C524 [Nile] PCI-to-PCI Bridge",
             0x0004: "PT86C525 [Nile-II] PCI-to-PCI Bridge",
             0x0005: "National PC87550 System Controller",
             0x8002: "PT86C523 [Vesuvius v3] PCI-ISA Bridge Slave",
             },

    # Mitsubishi Electric
    0x1067: {0x0301: "AccelGraphics AccelECLIPSE",
             0x0304: "AccelGALAXY A2100 [OEM Evans & Sutherland]",
             0x0308: "Tornado 3000 [OEM Evans & Sutherland]",
             0x1002: "VG500 [VolumePro Volume Rendering Accelerator]",
             },

    # Mylex Corporation
    0x1069: {0x0001: "DAC960P",
             0x0002: "DAC960PD",
             0x0010: "DAC960PG",
             0x0020: "DAC960LA",
             0x0050: "AcceleRAID 352/170/160 support Device",
             0xB166: "AcceleRAID 600/500/400/Sapphire support Device",
             0xBA55: "eXtremeRAID 1100 support Device",
             0xBA56: "eXtremeRAID 2000/3000 support Device",
             0xBA57: "eXtremeRAID 4000/5000 support Device",
             },

    # Apple Inc.
    0x106B: {0x0001: "Bandit PowerPC host bridge",
             0x0002: "Grand Central I/O",
             0x0003: "Control Video",
             0x0004: "PlanB Video-In",
             0x0007: "O'Hare I/O",
             0x000B: "Apple Camera",
             0x000C: "DOS on Mac",
             0x000E: "Hydra Mac I/O",
             0x0010: "Heathrow Mac I/O",
             0x0017: "Paddington Mac I/O",
             0x0018: "UniNorth FireWire",
             0x0019: "KeyLargo USB",
             0x001E: "UniNorth Internal PCI",
             0x001F: "UniNorth PCI",
             0x0020: "UniNorth AGP",
             0x0021: "UniNorth GMAC (Sun GEM)",
             0x0022: "KeyLargo Mac I/O",
             0x0024: "UniNorth/Pangea GMAC (Sun GEM)",
             0x0025: "KeyLargo/Pangea Mac I/O",
             0x0026: "KeyLargo/Pangea USB",
             0x0027: "UniNorth/Pangea AGP",
             0x0028: "UniNorth/Pangea PCI",
             0x0029: "UniNorth/Pangea Internal PCI",
             0x002D: "UniNorth 1.5 AGP",
             0x002E: "UniNorth 1.5 PCI",
             0x002F: "UniNorth 1.5 Internal PCI",
             0x0030: "UniNorth/Pangea FireWire",
             0x0031: "UniNorth 2 FireWire",
             0x0032: "UniNorth 2 GMAC (Sun GEM)",
             0x0033: "UniNorth 2 ATA/100",
             0x0034: "UniNorth 2 AGP",
             0x0035: "UniNorth 2 PCI",
             0x0036: "UniNorth 2 Internal PCI",
             0x003B: "UniNorth/Intrepid ATA/100",
             0x003E: "KeyLargo/Intrepid Mac I/O",
             0x003F: "KeyLargo/Intrepid USB",
             0x0040: "K2 KeyLargo USB",
             0x0041: "K2 KeyLargo Mac/IO",
             0x0042: "K2 FireWire",
             0x0043: "K2 ATA/100",
             0x0045: "K2 HT-PCI Bridge",
             0x0046: "K2 HT-PCI Bridge",
             0x0047: "K2 HT-PCI Bridge",
             0x0048: "K2 HT-PCI Bridge",
             0x0049: "K2 HT-PCI Bridge",
             0x004A: "CPC945 HT Bridge",
             0x004B: "U3 AGP",
             0x004C: "K2 GMAC (Sun GEM)",
             0x004F: "Shasta Mac I/O",
             0x0050: "Shasta IDE",
             0x0051: "Shasta (Sun GEM)",
             0x0052: "Shasta Firewire",
             0x0053: "Shasta PCI Bridge",
             0x0054: "Shasta PCI Bridge",
             0x0055: "Shasta PCI Bridge",
             0x0056: "U4 PCIe",
             0x0057: "U3 HT Bridge",
             0x0058: "U3L AGP Bridge",
             0x0059: "U3H AGP Bridge",
             0x005B: "CPC945 PCIe Bridge",
             0x0066: "Intrepid2 AGP Bridge",
             0x0067: "Intrepid2 PCI Bridge",
             0x0068: "Intrepid2 PCI Bridge",
             0x0069: "Intrepid2 ATA/100",
             0x006A: "Intrepid2 Firewire",
             0x006B: "Intrepid2 GMAC (Sun GEM)",
             0x0074: "U4 HT Bridge",
             0x100C: "Apple Silicon PCI Express Root Port",
             0x1010: "Apple Silicon USB4/Thunderbolt PCI Express Root Port",
             0x1645: "Broadcom NetXtreme BCM5701 Gigabit Ethernet",
             0x1801: "T2 Bridge Controller",
             0x1802: "T2 Secure Enclave Processor",
             0x1803: "Apple Audio Device",
             0x2001: "S1X NVMe Controller",
             0x2002: "S3ELab NVMe Controller",
             0x2003: "S3X NVMe Controller",
             0x2005: "ANS2 NVMe Controller",
             },

    # Hynix Semiconductor
    0x106C: {0x8139: "8139c 100BaseTX Ethernet Controller",
             0x8801: "Dual Pentium ISA/PCI Motherboard",
             0x8802: "PowerPC ISA/PCI Motherboard",
             0x8803: "Dual Window Graphics Accelerator",
             0x8804: "LAN Controller",
             0x8805: "100-BaseT LAN",
             },

    # Yamaha Corporation
    0x1073: {0x0001: "3D GUI Accelerator",
             0x0002: "YGV615 [RPA3 3D-Graphics Controller]",
             0x0003: "YMF-740",
             0x0004: "YMF-724",
             0x0005: "DS1 Audio",
             0x0006: "DS1 Audio",
             0x0008: "DS1 Audio",
             0x000A: "DS1L Audio",
             0x000C: "YMF-740C [DS-1L Audio Controller]",
             0x000D: "YMF-724F [DS-1 Audio Controller]",
             0x0010: "YMF-744B [DS-1S Audio Controller]",
             0x0012: "YMF-754 [DS-1E Audio Controller]",
             0x0020: "DS-1 Audio",
             0x1000: "SW1000XG [XG Factory]",
             0x2000: "DS2416 Digital Mixing Card",
             },

    # QLogic Corp.
    0x1077: {0x1016: "ISP10160 Single Channel Ultra3 SCSI Processor",
             0x1020: "ISP1020 Fast-wide SCSI",
             0x1022: "ISP1022 Fast-wide SCSI",
             0x1080: "ISP1080 SCSI Host Adapter",
             0x1216: "ISP12160 Dual Channel Ultra3 SCSI Processor",
             0x1240: "ISP1240 SCSI Host Adapter",
             0x1280: "ISP1280 SCSI Host Adapter",
             0x1634: "FastLinQ QL45000 Series 40GbE Controller",
             0x1644: "FastLinQ QL45000 Series 100GbE Controller",
             0x1654: "FastLinQ QL45000 Series 50GbE Controller",
             0x1656: "FastLinQ QL45000 Series 25GbE Controller",
             0x165C: "FastLinQ QL45000 Series 10/25/40/50GbE Controller (FCoE)",
             0x165E: "FastLinQ QL45000 Series 10/25/40/50GbE Controller (iSCSI)",
             0x1664: "FastLinQ QL45000 Series Gigabit Ethernet Controller (SR-IOV VF)",
             0x2020: "ISP2020A Fast!SCSI Basic Adapter",
             0x2031: "ISP8324-based 16Gb Fibre Channel to PCI Express Adapter",
             0x2071: "ISP2714-based 16/32Gb Fibre Channel to PCIe Adapter",
             0x2081: "ISP2814-based 64/32G Fibre Channel to PCIe Controller",
             0x2089: "ISP2854-based 64/32G Fibre Channel to PCIe Controller with StorCryption",
             0x2100: "QLA2100 64-bit Fibre Channel Adapter",
             0x2200: "QLA2200 64-bit Fibre Channel Adapter",
             0x2261: "ISP2722-based 16/32Gb Fibre Channel to PCIe Adapter",
             0x2281: "ISP2812-based 64/32G Fibre Channel to PCIe Controller",
             0x2289: "ISP2852-based 64/32G Fibre Channel to PCIe Controller with StorCryption",
             0x2300: "QLA2300 64-bit Fibre Channel Adapter",
             0x2312: "ISP2312-based 2Gb Fibre Channel to PCI-X HBA",
             0x2322: "ISP2322-based 2Gb Fibre Channel to PCI-X HBA",
             0x2422: "ISP2422-based 4Gb Fibre Channel to PCI-X HBA",
             0x2432: "ISP2432-based 4Gb Fibre Channel to PCI Express HBA",
             0x2532: "ISP2532-based 8Gb Fibre Channel to PCI Express HBA",
             0x2971: "ISP2684",
             0x3022: "ISP4022-based Ethernet NIC",
             0x3032: "ISP4032-based Ethernet IPv6 NIC",
             0x4010: "ISP4010-based iSCSI TOE HBA",
             0x4022: "ISP4022-based iSCSI TOE HBA",
             0x4032: "ISP4032-based iSCSI TOE IPv6 HBA",
             0x5432: "SP232-based 4Gb Fibre Channel to PCI Express HBA",
             0x6312: "SP202-based 2Gb Fibre Channel to PCI-X HBA",
             0x6322: "SP212-based 2Gb Fibre Channel to PCI-X HBA",
             0x7220: "IBA7220 InfiniBand HCA",
             0x7322: "IBA7322 QDR InfiniBand HCA",
             0x8000: "10GbE Converged Network Adapter (TCP/IP Networking)",
             0x8001: "10GbE Converged Network Adapter (FCoE)",
             0x8020: "cLOM8214 1/10GbE Controller",
             0x8021: "8200 Series 10GbE Converged Network Adapter (FCoE)",
             0x8022: "8200 Series 10GbE Converged Network Adapter (iSCSI)",
             0x8030: "ISP8324 1/10GbE Converged Network Controller",
             0x8031: "8300 Series 10GbE Converged Network Adapter (FCoE)",
             0x8032: "8300 Series 10GbE Converged Network Adapter (iSCSI)",
             0x8070: "FastLinQ QL41000 Series 10/25/40/50GbE Controller",
             0x8080: "FastLinQ QL41000 Series 10/25/40/50GbE Controller (FCoE)",
             0x8084: "FastLinQ QL41000 Series 10/25/40/50GbE Controller (iSCSI)",
             0x8090: "FastLinQ QL41000 Series Gigabit Ethernet Controller (SR-IOV VF)",
             0x8430: "ISP8324 1/10GbE Converged Network Controller (NIC VF)",
             0x8431: "8300 Series 10GbE Converged Network Adapter (FCoE VF)",
             0x8432: "ISP2432M-based 10GbE Converged Network Adapter (CNA)",
             },

    # Cyrix Corporation
    0x1078: {0x0000: "5510 [Grappa]",
             0x0001: "PCI Master",
             0x0002: "5520 [Cognac]",
             0x0100: "5530 Legacy [Kahlua]",
             0x0101: "5530 SMI [Kahlua]",
             0x0102: "5530 IDE [Kahlua]",
             0x0103: "5530 Audio [Kahlua]",
             0x0104: "5530 Video [Kahlua]",
             0x0400: "ZFMicro PCI Bridge",
             0x0401: "ZFMicro Chipset SMI",
             0x0402: "ZFMicro Chipset IDE",
             0x0403: "ZFMicro Expansion Bus",
             },

    # Interphase Corporation
    0x107E: {0x0001: "5515 ATM Adapter [Flipper]",
             0x0002: "100 VG AnyLan Controller",
             0x0004: "5526 Fibre Channel Host Adapter",
             0x0005: "x526 Fibre Channel Host Adapter",
             0x0008: "5525/5575 ATM Adapter (155 Mbit) [Atlantic]",
             0x9003: "5535-4P-BRI-ST",
             0x9007: "5535-4P-BRI-U",
             0x9008: "5535-1P-SR",
             0x900C: "5535-1P-SR-ST",
             0x900E: "5535-1P-SR-U",
             0x9011: "5535-1P-PRI",
             0x9013: "5535-2P-PRI",
             0x9023: "5536-4P-BRI-ST",
             0x9027: "5536-4P-BRI-U",
             0x9031: "5536-1P-PRI",
             0x9033: "5536-2P-PRI",
             },

    # Contaq Microsystems
    0x1080: {0x0600: "82C599",
             0xC691: "Cypress CY82C691",
             0xC693: "82c693",
             },

    # SBS Technologies
    0x108A: {0x0001: "VME Bridge Model 617",
             0x0010: "VME Bridge Model 618",
             0x0040: "dataBLIZZARD",
             0x3000: "VME Bridge Model 2706",
             },

    # Olicom
    0x108D: {0x0001: "Token-Ring 16/4 PCI Adapter (3136/3137)",
             0x0002: "16/4 Token Ring",
             0x0004: "RapidFire OC-3139/3140 Token-Ring 16/4 PCI Adapter",
             0x0005: "GoCard 3250 Token-Ring 16/4 CardBus PC Card",
             0x0006: "OC-3530 RapidFire Token-Ring 100",
             0x0007: "RapidFire 3141 Token-Ring 16/4 PCI Fiber Adapter",
             0x0008: "RapidFire 3540 HSTR 100/16/4 PCI Adapter",
             0x0011: "OC-2315",
             0x0012: "OC-2325",
             0x0013: "OC-2183/2185",
             0x0014: "OC-2326",
             0x0019: "OC-2327/2250 10/100 Ethernet Adapter",
             0x0021: "OC-6151/6152 [RapidFire ATM 155]",
             0x0022: "ATM Adapter",
             },

    # Oracle/SUN
    0x108E: {0x0001: "EBUS",
             0x1000: "STP2003QFP [PCIO] EBUS",
             0x1001: "Happy Meal 10/100 Ethernet [hme]",
             0x1100: "RIO EBUS",
             0x1101: "RIO 10/100 Ethernet [eri]",
             0x1102: "RIO 1394",
             0x1103: "RIO USB",
             0x1647: "Broadcom 570x 10/100/1000 Ethernet [bge]",
             0x1648: "Broadcom 570x 10/100/1000 Ethernet [bge]",
             0x16A7: "Broadcom 570x 10/100/1000 Ethernet [bge]",
             0x16A8: "Broadcom 570x 10/100/1000 Ethernet [bge]",
             0x2BAD: "GEM 10/100/1000 Ethernet [ge]",
             0x5000: "Simba Advanced PCI Bridge",
             0x5043: "SunPCI Co-processor",
             0x5CA0: "Crypto Accelerator 6000 [mca]",
             0x6300: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6301: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6302: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6303: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6310: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6311: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6312: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6313: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6320: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6323: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6330: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6331: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6332: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6333: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6340: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6343: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6350: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6353: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x6722: "Intel 21554 PCI-PCI bus bridge [db21554]",
             0x676E: "SunPCiIII",
             0x7063: "SunPCiII / SunPCiIIpro",
             0x8000: "Psycho PCI Bus Module",
             0x8001: "Schizo PCI Bus Module",
             0x8002: "Schizo+ PCI Bus Module",
             0x80F0: "PCIe switch [px]",
             0x80F8: "PCIe switch [px]",
             0x9010: "PCIe/PCI bridge switch [pxb_plx]",
             0x9020: "PCIe/PCI bridge switch [pxb_plx]",
             0x9102: "Davicom Fast Ethernet driver for Davicom DM9102A [dmfe]",
             0xA000: "Psycho UPA-PCI Bus Module [pcipsy]",
             0xA001: "Psycho UPA-PCI Bus Module [pcipsy]",
             0xA801: "Schizo Fireplane-PCI bus bridge module [pcisch]",
             0xAAAA: "Multithreaded Shared 10GbE Ethernet Network Controller",
             0xABBA: "Cassini 10/100/1000",
             0xABCD: "Multithreaded 10-Gigabit Ethernet Network Controller",
             0xC416: "Sun Fire System/System Controller Interface chip [sbbc]",
             },

    # Compro Computer Services, Inc.
    0x1090: {0x4610: "PCI RTOM",
             0x4620: "GPIO HSD",
             },

    # Intergraph Corporation
    0x1091: {0x0020: "3D graphics processor",
             0x0021: "3D graphics processor w/Texturing",
             0x0040: "3D graphics frame buffer",
             0x0041: "3D graphics frame buffer",
             0x0060: "Proprietary bus bridge",
             0x00E4: "Powerstorm 4D50T",
             0x0720: "Motion JPEG codec",
             0x0780: "Intense3D Wildcat 3410 (MSMT496)",
             0x07A0: "Sun Expert3D-Lite Graphics Accelerator",
             0x1091: "Sun Expert3D Graphics Accelerator",
             },

    # Diamond Multimedia Systems
    0x1092: {0x0028: "Viper V770",
             0x00A0: "Speedstar Pro SE",
             0x00A8: "Speedstar 64",
             0x0550: "Viper V550",
             0x08D4: "Supra 2260 Modem",
             0x094C: "SupraExpress 56i Pro",
             0x1001: "Video Crunch It 1001 capture card",
             0x1092: "Viper V330",
             0x6120: "Maximum DVD",
             0x8810: "Stealth SE",
             0x8811: "Stealth 64/SE",
             0x8880: "Stealth",
             0x8881: "Stealth",
             0x88B0: "Stealth 64",
             0x88B1: "Stealth 64",
             0x88C0: "Stealth 64",
             0x88C1: "Stealth 64",
             0x88D0: "Stealth 64",
             0x88D1: "Stealth 64",
             0x88F0: "Stealth 64",
             0x88F1: "Stealth 64",
             0x9999: "DMD-I0928-1 'Monster sound' sound chip",
             },

    # National Instruments
    0x1093: {0x0160: "PCI-DIO-96",
             0x0162: "PCI-MIO-16XE-50",
             0x0FE1: "PXI-8320",
             0x1150: "PCI-6533 (PCI-DIO-32HS)",
             0x1170: "PCI-MIO-16XE-10",
             0x1180: "PCI-MIO-16E-1",
             0x1190: "PCI-MIO-16E-4",
             0x11B0: "PXI-6070E",
             0x11C0: "PXI-6040E",
             0x11D0: "PXI-6030E",
             0x1270: "PCI-6032E",
             0x1290: "PCI-6704",
             0x12B0: "PCI-6534",
             0x1310: "PCI-6602",
             0x1320: "PXI-6533",
             0x1330: "PCI-6031E",
             0x1340: "PCI-6033E",
             0x1350: "PCI-6071E",
             0x1360: "PXI-6602",
             0x13C0: "PXI-6508",
             0x1490: "PXI-6534",
             0x14E0: "PCI-6110",
             0x14F0: "PCI-6111",
             0x1580: "PXI-6031E",
             0x15B0: "PXI-6071E",
             0x1710: "PXI-6509",
             0x17C0: "PXI-5690",
             0x17D0: "PCI-6503",
             0x1870: "PCI-6713",
             0x1880: "PCI-6711",
             0x18B0: "PCI-6052E",
             0x18C0: "PXI-6052E",
             0x1920: "PXI-6704",
             0x1930: "PCI-6040E",
             0x19C0: "PCI-4472",
             0x1AA0: "PXI-4110",
             0x1AD0: "PCI-6133",
             0x1AE0: "PXI-6133",
             0x1E30: "PCI-6624",
             0x1E40: "PXI-6624",
             0x1E50: "PXI-5404",
             0x2410: "PCI-6733",
             0x2420: "PXI-6733",
             0x2430: "PCI-6731",
             0x2470: "PCI-4474",
             0x24A0: "PCI-4065",
             0x24B0: "PXI-4200",
             0x24F0: "PXI-4472",
             0x2510: "PCI-4472",
             0x2520: "PCI-4474",
             0x27A0: "PCI-6123",
             0x27B0: "PXI-6123",
             0x2880: "DAQCard-6601",
             0x2890: "PCI-6036E",
             0x28A0: "PXI-4461",
             0x28B0: "PCI-6013",
             0x28C0: "PCI-6014",
             0x28D0: "PCI-5122",
             0x28E0: "PXI-5122",
             0x29F0: "PXI-7334",
             0x2A00: "PXI-7344",
             0x2A60: "PCI-6023E",
             0x2A70: "PCI-6024E",
             0x2A80: "PCI-6025E",
             0x2AB0: "PXI-6025E",
             0x2B10: "PXI-6527",
             0x2B20: "PCI-6527",
             0x2B80: "PXI-6713",
             0x2B90: "PXI-6711",
             0x2C60: "PCI-6601",
             0x2C70: "PXI-6601",
             0x2C80: "PCI-6035E",
             0x2C90: "PCI-6703",
             0x2CA0: "PCI-6034E",
             0x2CB0: "PCI-7344",
             0x2CC0: "PXI-6608",
             0x2D20: "PXI-5600",
             0x2DB0: "PCI-6608",
             0x2DC0: "PCI-4070",
             0x2DD0: "PXI-4070",
             0x2EB0: "PXI-4472",
             0x2EC0: "PXI-6115",
             0x2ED0: "PCI-6115",
             0x2EE0: "PXI-6120",
             0x2EF0: "PCI-6120",
             0x2FD1: "PCI-7334",
             0x2FD2: "PCI-7350",
             0x2FD3: "PCI-7342",
             0x2FD5: "PXI-7350",
             0x2FD6: "PXI-7342",
             0x7003: "PCI-6551",
             0x7004: "PXI-6551",
             0x700B: "PXI-5421",
             0x700C: "PCI-5421",
             0x701A: "VXIpc-87xB",
             0x701B: "VXIpc-770",
             0x7023: "PXI-2593",
             0x7027: "PCI-MXI-2 Universal",
             0x702C: "PXI-7831R",
             0x702D: "PCI-7831R",
             0x702E: "PXI-7811R",
             0x702F: "PCI-7811R",
             0x7030: "PCI-CAN (Series 2)",
             0x7031: "PCI-CAN/2 (Series 2)",
             0x7032: "PCI-CAN/LS (Series 2)",
             0x7033: "PCI-CAN/LS2 (Series 2)",
             0x7034: "PCI-CAN/DS (Series 2)",
             0x7035: "PXI-8460 (Series 2, 1 port)",
             0x7036: "PXI-8460 (Series 2, 2 ports)",
             0x7037: "PXI-8461 (Series 2, 1 port)",
             0x7038: "PXI-8461 (Series 2, 2 ports)",
             0x7039: "PXI-8462 (Series 2)",
             0x703F: "PXI-2566",
             0x7040: "PXI-2567",
             0x7044: "MXI-4 Connection Monitor",
             0x7047: "PXI-6653",
             0x704C: "PXI-2530",
             0x704F: "PXI-4220",
             0x7050: "PXI-4204",
             0x7055: "PXI-7830R",
             0x7056: "PCI-7830R",
             0x705A: "PCI-CAN/XS (Series 2)",
             0x705B: "PCI-CAN/XS2 (Series 2)",
             0x705C: "PXI-8464 (Series 2, 1 port)",
             0x705D: "PXI-8464 (Series 2, 2 ports)",
             0x705E: "cRIO-9102",
             0x7060: "PXI-5610",
             0x7064: "PXI-1045 Trigger Routing Module",
             0x7065: "PXI-6652",
             0x7066: "PXI-6651",
             0x7067: "PXI-2529",
             0x7068: "PCI-CAN/SW (Series 2)",
             0x7069: "PCI-CAN/SW2 (Series 2)",
             0x706A: "PXI-8463 (Series 2, 1 port)",
             0x706B: "PXI-8463 (Series 2, 2 ports)",
             0x7073: "PCI-6723",
             0x7074: "PXI-7833R",
             0x7075: "PXI-6552",
             0x7076: "PCI-6552",
             0x707C: "PXI-1428",
             0x707E: "PXI-4462",
             0x7080: "PXI-8430/2 (RS-232) Interface",
             0x7081: "PXI-8431/2 (RS-485) Interface",
             0x7083: "PCI-7833R",
             0x7085: "PCI-6509",
             0x7086: "PXI-6528",
             0x7087: "PCI-6515",
             0x7088: "PCI-6514",
             0x708C: "PXI-2568",
             0x708D: "PXI-2569",
             0x70A9: "PCI-6528",
             0x70AA: "PCI-6229",
             0x70AB: "PCI-6259",
             0x70AC: "PCI-6289",
             0x70AD: "PXI-6251",
             0x70AE: "PXI-6220",
             0x70AF: "PCI-6221",
             0x70B0: "PCI-6220",
             0x70B1: "PXI-6229",
             0x70B2: "PXI-6259",
             0x70B3: "PXI-6289",
             0x70B4: "PCI-6250",
             0x70B5: "PXI-6221",
             0x70B6: "PCI-6280",
             0x70B7: "PCI-6254",
             0x70B8: "PCI-6251",
             0x70B9: "PXI-6250",
             0x70BA: "PXI-6254",
             0x70BB: "PXI-6280",
             0x70BC: "PCI-6284",
             0x70BD: "PCI-6281",
             0x70BE: "PXI-6284",
             0x70BF: "PXI-6281",
             0x70C0: "PCI-6143",
             0x70C3: "PCI-6511",
             0x70C4: "PXI-7330",
             0x70C5: "PXI-7340",
             0x70C6: "PCI-7330",
             0x70C7: "PCI-7340",
             0x70C8: "PCI-6513",
             0x70C9: "PXI-6515",
             0x70CA: "PCI-1405",
             0x70CC: "PCI-6512",
             0x70CD: "PXI-6514",
             0x70CE: "PXI-1405",
             0x70CF: "PCIe-GPIB",
             0x70D0: "PXI-2570",
             0x70D1: "PXI-6513",
             0x70D2: "PXI-6512",
             0x70D3: "PXI-6511",
             0x70D4: "PCI-6722",
             0x70D6: "PXI-4072",
             0x70D7: "PXI-6541",
             0x70D8: "PXI-6542",
             0x70D9: "PCI-6541",
             0x70DA: "PCI-6542",
             0x70DB: "PCI-8430/2 (RS-232) Interface",
             0x70DC: "PCI-8431/2 (RS-485) Interface",
             0x70DD: "PXI-8430/4 (RS-232) Interface",
             0x70DE: "PXI-8431/4 (RS-485) Interface",
             0x70DF: "PCI-8430/4 (RS-232) Interface",
             0x70E0: "PCI-8431/4 (RS-485) Interface",
             0x70E1: "PXI-2532",
             0x70E2: "PXI-8430/8 (RS-232) Interface",
             0x70E3: "PXI-8431/8 (RS-485) Interface",
             0x70E4: "PCI-8430/8 (RS-232) Interface",
             0x70E5: "PCI-8431/8 (RS-485) Interface",
             0x70E6: "PXI-8430/16 (RS-232) Interface",
             0x70E7: "PCI-8430/16 (RS-232) Interface",
             0x70E8: "PXI-8432/2 (Isolated RS-232) Interface",
             0x70E9: "PXI-8433/2 (Isolated RS-485) Interface",
             0x70EA: "PCI-8432/2 (Isolated RS-232) Interface",
             0x70EB: "PCI-8433/2 (Isolated RS-485) Interface",
             0x70EC: "PXI-8432/4 (Isolated RS-232) Interface",
             0x70ED: "PXI-8433/4 (Isolated RS-485) Interface",
             0x70EE: "PCI-8432/4 (Isolated RS-232) Interface",
             0x70EF: "PCI-8433/4 (Isolated RS-485) Interface",
             0x70F0: "PXI-5922",
             0x70F1: "PCI-5922",
             0x70F2: "PCI-6224",
             0x70F3: "PXI-6224",
             0x70F6: "cRIO-9101",
             0x70F7: "cRIO-9103",
             0x70F8: "cRIO-9104",
             0x70FF: "PXI-6723",
             0x7100: "PXI-6722",
             0x7104: "PCIx-1429",
             0x7105: "PCIe-1429",
             0x710A: "PXI-4071",
             0x710D: "PXI-6143",
             0x710E: "PCIe-GPIB",
             0x710F: "PXI-5422",
             0x7110: "PCI-5422",
             0x7111: "PXI-5441",
             0x7119: "PXI-6561",
             0x711A: "PXI-6562",
             0x711B: "PCI-6561",
             0x711C: "PCI-6562",
             0x7120: "PCI-7390",
             0x7121: "PXI-5122EX",
             0x7122: "PCI-5122EX",
             0x7123: "PXIe-5653",
             0x7124: "PCI-6510",
             0x7125: "PCI-6516",
             0x7126: "PCI-6517",
             0x7127: "PCI-6518",
             0x7128: "PCI-6519",
             0x7137: "PXI-2575",
             0x713C: "PXI-2585",
             0x713D: "PXI-2586",
             0x7142: "PXI-4224",
             0x7144: "PXI-5124",
             0x7145: "PCI-5124",
             0x7146: "PCI-6132",
             0x7147: "PXI-6132",
             0x7148: "PCI-6122",
             0x7149: "PXI-6122",
             0x714C: "PXI-5114",
             0x714D: "PCI-5114",
             0x7150: "PXI-2564",
             0x7152: "PCI-5640R",
             0x7156: "PXI-1044 Trigger Routing Module",
             0x715D: "PCI-1426",
             0x7167: "PXI-5412",
             0x7168: "PCI-5412",
             0x716B: "PCI-6230",
             0x716C: "PCI-6225",
             0x716D: "PXI-6225",
             0x716F: "PCI-4461",
             0x7170: "PCI-4462",
             0x7171: "PCI-6010",
             0x7174: "PXI-8360",
             0x7177: "PXI-6230",
             0x717D: "PCIe-6251",
             0x717F: "PCIe-6259",
             0x7187: "PCI-1410",
             0x718B: "PCI-6521",
             0x718C: "PXI-6521",
             0x7191: "PCI-6154",
             0x7193: "PXI-7813R",
             0x7194: "PCI-7813R",
             0x7195: "PCI-8254R",
             0x7197: "PXI-5402",
             0x7198: "PCI-5402",
             0x719F: "PCIe-6535",
             0x71A0: "PCIe-6536",
             0x71A3: "PXI-5650",
             0x71A4: "PXI-5652",
             0x71A5: "PXI-2594",
             0x71A7: "PXI-2595",
             0x71A9: "PXI-2596",
             0x71AA: "PXI-2597",
             0x71AB: "PXI-2598",
             0x71AC: "PXI-2599",
             0x71AD: "PCI-GPIB+",
             0x71AE: "PCIe-1430",
             0x71B7: "PXI-1056 Trigger Routing Module",
             0x71B8: "PXI-1045 Trigger Routing Module",
             0x71B9: "PXI-1044 Trigger Routing Module",
             0x71BB: "PXI-2584",
             0x71BC: "PCI-6221 (37-pin)",
             0x71BF: "PCIe-1427",
             0x71C5: "PCI-6520",
             0x71C6: "PXI-2576",
             0x71C7: "cRIO-9072",
             0x71DC: "PCI-1588",
             0x71E0: "PCI-6255",
             0x71E1: "PXI-6255",
             0x71E2: "PXI-5406",
             0x71E3: "PCI-5406",
             0x71FC: "PXI-4022",
             0x7209: "PCI-6233",
             0x720A: "PXI-6233",
             0x720B: "PCI-6238",
             0x720C: "PXI-6238",
             0x7260: "PXI-5142",
             0x7261: "PCI-5142",
             0x726D: "PXI-5651",
             0x7273: "PXI-4461",
             0x7274: "PXI-4462",
             0x7279: "PCI-6232",
             0x727A: "PXI-6232",
             0x727B: "PCI-6239",
             0x727C: "PXI-6239",
             0x727E: "SMBus Controller",
             0x7281: "PCI-6236",
             0x7282: "PXI-6236",
             0x7283: "PXI-2554",
             0x7288: "PXIe-5611",
             0x7293: "PCIe-8255R",
             0x729D: "cRIO-9074",
             0x72A4: "PCIe-4065",
             0x72A7: "PCIe-6537",
             0x72A8: "PXI-5152",
             0x72A9: "PCI-5152",
             0x72AA: "PXI-5105",
             0x72AB: "PCI-5105",
             0x72B8: "PXI-6682",
             0x72D0: "PXI-2545",
             0x72D1: "PXI-2546",
             0x72D2: "PXI-2547",
             0x72D3: "PXI-2548",
             0x72D4: "PXI-2549",
             0x72D5: "PXI-2555",
             0x72D6: "PXI-2556",
             0x72D7: "PXI-2557",
             0x72D8: "PXI-2558",
             0x72D9: "PXI-2559",
             0x72E8: "PXIe-6251",
             0x72E9: "PXIe-6259",
             0x72EF: "PXI-4498",
             0x72F0: "PXI-4496",
             0x72FB: "PXIe-6672",
             0x730E: "PXI-4130",
             0x730F: "PXI-5922EX",
             0x7310: "PCI-5922EX",
             0x731C: "PXI-2535",
             0x731D: "PXI-2536",
             0x7322: "PXIe-6124",
             0x7327: "PXI-6529",
             0x732C: "VXI-8360T",
             0x7331: "PXIe-5602",
             0x7332: "PXIe-5601",
             0x7333: "PXI-5900",
             0x7335: "PXI-2533",
             0x7336: "PXI-2534",
             0x7342: "PXI-4461",
             0x7349: "PXI-5154",
             0x734A: "PCI-5154",
             0x7357: "PXI-4065",
             0x7359: "PXI-4495",
             0x7370: "PXI-4461",
             0x7373: "sbRIO-9601",
             0x7374: "IOtech-9601",
             0x7375: "sbRIO-9602",
             0x7378: "sbRIO-9641",
             0x737D: "PXI-5124EX",
             0x7384: "PXI-7851R",
             0x7385: "PXI-7852R",
             0x7386: "PCIe-7851R",
             0x7387: "PCIe-7852R",
             0x7390: "PXI-7841R",
             0x7391: "PXI-7842R",
             0x7392: "PXI-7853R",
             0x7393: "PCIe-7841R",
             0x7394: "PCIe-7842R",
             0x7397: "sbRIO-9611",
             0x7398: "sbRIO-9612",
             0x7399: "sbRIO-9631",
             0x739A: "sbRIO-9632",
             0x739B: "sbRIO-9642",
             0x73A1: "PXIe-4498",
             0x73A2: "PXIe-4496",
             0x73A5: "PXIe-5641R",
             0x73A7: "PXI-8250 Chassis Monitor Module",
             0x73A8: "PXI-8511 CAN/LS",
             0x73A9: "PXI-8511 CAN/LS",
             0x73AA: "PXI-8512 CAN/HS",
             0x73AB: "PXI-8512 CAN/HS",
             0x73AC: "PXI-8513 CAN/XS",
             0x73AD: "PXI-8513 CAN/XS",
             0x73AF: "PXI-8516 LIN",
             0x73B1: "PXI-8517 FlexRay",
             0x73B2: "PXI-8531 CANopen",
             0x73B3: "PXI-8531 CANopen",
             0x73B4: "PXI-8532 DeviceNet",
             0x73B5: "PXI-8532 DeviceNet",
             0x73B6: "PCI-8511 CAN/LS",
             0x73B7: "PCI-8511 CAN/LS",
             0x73B8: "PCI-8512 CAN/HS",
             0x73B9: "PCI-8512 CAN/HS",
             0x73BA: "PCI-8513 CAN/XS",
             0x73BB: "PCI-8513 CAN/XS",
             0x73BD: "PCI-8516 LIN",
             0x73BF: "PCI-8517 FlexRay",
             0x73C0: "PCI-8531 CANopen",
             0x73C1: "PCI-8531 CANopen",
             0x73C2: "PCI-8532 DeviceNet",
             0x73C3: "PCI-8532 DeviceNet",
             0x73C5: "PXIe-2527",
             0x73C6: "PXIe-2529",
             0x73C8: "PXIe-2530",
             0x73C9: "PXIe-2532",
             0x73CA: "PXIe-2569",
             0x73CB: "PXIe-2575",
             0x73CC: "PXIe-2593",
             0x73D5: "PXI-7951R",
             0x73D6: "PXI-7952R",
             0x73D7: "PXI-7953R",
             0x73E1: "PXI-7854R",
             0x73EC: "PXI-7954R",
             0x73ED: "cRIO-9073",
             0x73F0: "PXI-5153",
             0x73F1: "PCI-5153",
             0x73F4: "PXI-2515",
             0x73F6: "cRIO-9111",
             0x73F7: "cRIO-9112",
             0x73F8: "cRIO-9113",
             0x73F9: "cRIO-9114",
             0x73FA: "cRIO-9116",
             0x73FB: "cRIO-9118",
             0x7404: "PXI-4132",
             0x7405: "PXIe-6674T",
             0x7406: "PXIe-6674",
             0x740E: "PCIe-8430/16 (RS-232) Interface",
             0x740F: "PCIe-8430/8 (RS-232) Interface",
             0x7410: "PCIe-8431/16 (RS-485) Interface",
             0x7411: "PCIe-8431/8 (RS-485) Interface",
             0x7414: "PCIe-GPIB+",
             0x741C: "PXI-5691",
             0x741D: "PXI-5695",
             0x743C: "CSC-3059",
             0x7448: "PXI-2510",
             0x7454: "PXI-2512",
             0x7455: "PXI-2514",
             0x7456: "PXIe-2512",
             0x7457: "PXIe-2514",
             0x745A: "PXI-6682H",
             0x745E: "PXI-5153EX",
             0x745F: "PCI-5153EX",
             0x7460: "PXI-5154EX",
             0x7461: "PCI-5154EX",
             0x746D: "PXIe-5650",
             0x746E: "PXIe-5651",
             0x746F: "PXIe-5652",
             0x7472: "PXI-2800",
             0x7495: "PXIe-5603",
             0x7497: "PXIe-5605",
             0x74AE: "PXIe-2515",
             0x74B4: "PXI-2531",
             0x74B5: "PXIe-2531",
             0x74C1: "PXIe-8430/16 (RS-232) Interface",
             0x74C2: "PXIe-8430/8 (RS-232) Interface",
             0x74C3: "PXIe-8431/16 (RS-485) Interface",
             0x74C4: "PXIe-8431/8 (RS-485) Interface",
             0x74D5: "PXIe-5630",
             0x74D9: "PCIe-8432/2 (Isolated RS-232) Interface",
             0x74DA: "PCIe-8433/2 (Isolated RS-485) Interface",
             0x74DB: "PCIe-8432/4 (Isolated RS-232) Interface",
             0x74DC: "PCIe-8433/4 (Isolated RS-485) Interface",
             0x74E8: "NI 9148",
             0x7515: "PCIe-8430/2 (RS-232) Interface",
             0x7516: "PCIe-8430/4 (RS-232) Interface",
             0x7517: "PCIe-8431/2 (RS-485) Interface",
             0x7518: "PCIe-8431/4 (RS-485) Interface",
             0x751B: "cRIO-9081",
             0x751C: "cRIO-9082",
             0x7528: "PXIe-4497",
             0x7529: "PXIe-4499",
             0x752A: "PXIe-4492",
             0x7539: "NI 9157",
             0x753A: "NI 9159",
             0x7598: "PXI-2571",
             0x75A4: "PXI-4131A",
             0x75B1: "PCIe-7854R",
             0x75BA: "PXI-2543",
             0x75BB: "PXIe-2543",
             0x75E5: "PXI-6683",
             0x75E6: "PXI-6683H",
             0x75EF: "PXIe-5632",
             0x761C: "VXI-8360LT",
             0x761F: "PXI-2540",
             0x7620: "PXIe-2540",
             0x7621: "PXI-2541",
             0x7622: "PXIe-2541",
             0x7626: "NI 9154",
             0x7627: "NI 9155",
             0x7638: "PXI-2720",
             0x7639: "PXI-2722",
             0x763A: "PXIe-2725",
             0x763B: "PXIe-2727",
             0x763C: "PXI-4465",
             0x764B: "PXIe-2790",
             0x764C: "PXI-2520",
             0x764D: "PXI-2521",
             0x764E: "PXI-2522",
             0x764F: "PXI-2523",
             0x7654: "PXI-2796",
             0x7655: "PXI-2797",
             0x7656: "PXI-2798",
             0x7657: "PXI-2799",
             0x765D: "PXI-2542",
             0x765E: "PXIe-2542",
             0x765F: "PXI-2544",
             0x7660: "PXIe-2544",
             0x766D: "PCIe-6535B",
             0x766E: "PCIe-6536B",
             0x766F: "PCIe-6537B",
             0x76A3: "PXIe-6535B",
             0x76A4: "PXIe-6536B",
             0x76A5: "PXIe-6537B",
             0x783E: "PXI-8368",
             0x9020: "PXI-2501",
             0x9030: "PXI-2503",
             0x9040: "PXI-2527",
             0x9050: "PXI-2565",
             0x9060: "PXI-2590",
             0x9070: "PXI-2591",
             0x9080: "PXI-2580",
             0x9090: "PCI-4021",
             0x90A0: "PXI-4021",
             0xA001: "PCI-MXI-2",
             0xB001: "PCI-1408",
             0xB011: "PXI-1408",
             0xB021: "PCI-1424",
             0xB022: "PXI-1424",
             0xB031: "PCI-1413",
             0xB041: "PCI-1407",
             0xB051: "PXI-1407",
             0xB061: "PCI-1411",
             0xB071: "PCI-1422",
             0xB081: "PXI-1422",
             0xB091: "PXI-1411",
             0xB0B1: "PCI-1409",
             0xB0C1: "PXI-1409",
             0xB0E1: "PCI-1428",
             0xC4C4: "PXIe/PCIe Device",
             0xC801: "PCI-GPIB",
             0xC811: "PCI-GPIB+",
             0xC821: "PXI-GPIB",
             0xC831: "PMC-GPIB",
             0xC840: "PCI-GPIB",
             0xD130: "PCI-232/2 Interface",
             0xD140: "PCI-232/4 Interface",
             0xD150: "PCI-232/8 Interface",
             0xD160: "PCI-485/2 Interface",
             0xD170: "PCI-485/4 Interface",
             0xD190: "PXI-8422/2 (Isolated RS-232) Interface",
             0xD1A0: "PXI-8422/4 (Isolated RS-232) Interface",
             0xD1B0: "PXI-8423/2 (Isolated RS-485) Interface",
             0xD1C0: "PXI-8423/4 (Isolated RS-485) Interface",
             0xD1D0: "PXI-8420/2 (RS-232) Interface",
             0xD1E0: "PXI-8420/4 (RS-232) Interface",
             0xD1F0: "PXI-8420/8 (RS-232) Interface",
             0xD1F1: "PXI-8420/16 (RS-232) Interface",
             0xD230: "PXI-8421/2 (RS-485) Interface",
             0xD240: "PXI-8421/4 (RS-485) Interface",
             0xD250: "PCI-232/2 (Isolated) Interface",
             0xD260: "PCI-485/2 (Isolated) Interface",
             0xD270: "PCI-232/4 (Isolated) Interface",
             0xD280: "PCI-485/4 (Isolated) Interface",
             0xD290: "PCI-485/8 Interface",
             0xD2A0: "PXI-8421/8 (RS-485) Interface",
             0xD2B0: "PCI-232/16 Interface",
             0xE111: "PCI-CAN",
             0xE131: "PXI-8461 (1 port)",
             0xE141: "PCI-CAN/LS",
             0xE151: "PXI-8460 (1 port)",
             0xE211: "PCI-CAN/2",
             0xE231: "PXI-8461 (2 ports)",
             0xE241: "PCI-CAN/LS2",
             0xE251: "PXI-8460 (2 ports)",
             0xE261: "PCI-CAN/DS",
             0xE271: "PXI-8462",
             0xF110: "VMEpc-650",
             0xF120: "VXIpc-650",
             0xFE00: "VXIpc-87x",
             0xFE41: "VXIpc-860",
             0xFE51: "VXIpc-74x",
             0xFE61: "VXIpc-850",
             0xFE70: "VXIpc-880",
             },

    # Silicon Image, Inc.
    0x1095: {0x0240: "Adaptec AAR-1210SA SATA HostRAID Controller",
             0x0242: "AAR-1220SA SATA RAID Controller",
             0x0640: "PCI0640",
             0x0643: "PCI0643",
             0x0646: "PCI0646",
             0x0647: "PCI0647",
             0x0648: "PCI0648",
             0x0649: "SiI 0649 Ultra ATA/100 PCI to ATA Host Controller",
             0x0650: "PBC0650A",
             0x0670: "USB0670",
             0x0673: "USB0673",
             0x0680: "PCI0680 Ultra ATA-133 Host Controller",
             0x3112: "SiI 3112 [SATALink/SATARaid] Serial ATA Controller",
             0x3114: "SiI 3114 [SATALink/SATARaid] Serial ATA Controller",
             0x3124: "SiI 3124 PCI-X Serial ATA Controller",
             0x3132: "SiI 3132 Serial ATA Raid II Controller",
             0x3512: "SiI 3512 [SATALink/SATARaid] Serial ATA Controller",
             0x3531: "SiI 3531 [SATALink/SATARaid] Serial ATA Controller",
             },

    # Quantum Designs (H.K.) Ltd
    0x1098: {0x0001: "QD-8500",
             0x0002: "QD-8580",
             },

    # Brooktree Corporation
    0x109E: {0x0310: "Bt848 Video Capture",
             0x032E: "Bt878 Video Capture",
             0x0350: "Bt848 Video Capture",
             0x0351: "Bt849A Video capture",
             0x0369: "Bt878 Video Capture",
             0x036C: "Bt879(??) Video Capture",
             0x036E: "Bt878 Video Capture",
             0x036F: "Bt879 Video Capture",
             0x0370: "Bt880 Video Capture",
             0x0878: "Bt878 Audio Capture",
             0x0879: "Bt879 Audio Capture",
             0x0880: "Bt880 Audio Capture",
             0x2115: "BtV 2115 Mediastream controller",
             0x2125: "BtV 2125 Mediastream controller",
             0x2164: "BtV 2164",
             0x2165: "BtV 2165",
             0x8230: "Bt8230 ATM Segment/Reassembly Ctrlr (SRC)",
             0x8472: "Bt8472",
             0x8474: "Bt8474",
             },

    # Smart Link Ltd.
    0x10A5: {0x3052: "SmartPCI562 56K Modem",
             0x5449: "SmartPCI561 modem",
             },

    # Silicon Graphics Intl. Corp.
    0x10A9: {0x0001: "Crosstalk to PCI Bridge",
             0x0002: "Linc I/O controller",
             0x0003: "IOC3 I/O controller",
             0x0004: "O2 MACE",
             0x0005: "RAD Audio",
             0x0006: "HPCEX",
             0x0007: "RPCEX",
             0x0008: "DiVO VIP",
             0x0009: "AceNIC Gigabit Ethernet",
             0x0010: "AMP Video I/O",
             0x0011: "GRIP",
             0x0012: "SGH PSHAC GSN",
             0x0208: "SSIM1 SAS Adapter",
             0x1001: "Magic Carpet",
             0x1002: "Lithium",
             0x1003: "Dual JPEG 1",
             0x1004: "Dual JPEG 2",
             0x1005: "Dual JPEG 3",
             0x1006: "Dual JPEG 4",
             0x1007: "Dual JPEG 5",
             0x1008: "Cesium",
             0x100A: "IOC4 I/O controller",
             0x1504: "SSIM1 Fibre Channel Adapter",
             0x2001: "Fibre Channel",
             0x2002: "ASDE",
             0x4001: "TIO-CE PCI Express Bridge",
             0x4002: "TIO-CE PCI Express Port",
             0x8001: "O2 1394",
             0x8002: "G-net NT",
             0x802B: "REACT external interrupt controller",
             },

    # ACC Microelectronics
    0x10AA: {0x0000: "ACCM 2188",
             0x2051: "2051 CPU bridge",
             0x5842: "2051 ISA bridge",
             },

    # Symphony Labs
    0x10AD: {0x0001: "W83769F",
             0x0003: "SL82C103",
             0x0005: "SL82C105",
             0x0103: "SL82c103",
             0x0105: "SL82c105",
             0x0565: "W83C553F/W83C554F",
             },

    # Databook Inc
    0x10B3: {0x3106: "DB87144",
             0xB106: "DB87144",
             },

    # PLX Technology, Inc.
    0x10B5: {0x0001: "i960 PCI bus interface",
             0x0557: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge",
             0x1000: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge",
             0x1024: "Acromag, Inc. IndustryPack Carrier Card",
             0x1042: "Brandywine / jxi2, Inc. - PMC-SyncClock32, IRIG A & B, Nasa 36",
             0x106A: "Dual OX16C952 4 port serial adapter [Megawolf Romulus/4]",
             0x1076: "VScom 800 8 port serial adaptor",
             0x1077: "VScom 400 4 port serial adaptor",
             0x1078: "VScom 210 2 port serial and 1 port parallel adaptor",
             0x1103: "VScom 200 2 port serial adaptor",
             0x1146: "VScom 010 1 port parallel adaptor",
             0x1147: "VScom 020 2 port parallel adaptor",
             0x2000: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge",
             0x2540: "IXXAT CAN-Interface PC-I 04/PCI",
             0x2724: "Thales PCSM Security Card",
             0x3376: "Cosateq 4 Port CAN Card",
             0x4000: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge",
             0x4001: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge",
             0x4002: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge",
             0x6140: "PCI6140 32-bit 33MHz PCI-to-PCI Bridge",
             0x6150: "PCI6150 32-bit 33MHz PCI-to-PCI Bridge",
             0x6152: "PCI6152 32-bit 66MHz PCI-to-PCI Bridge",
             0x6154: "PCI6154 64-bit 66MHz PCI-to-PCI Bridge",
             0x6254: "PCI6254 64-bit 66MHz PCI-to-PCI Bridge",
             0x6466: "PCI6466 64-bit 66MHz PCI-to-PCI Bridge",
             0x6520: "PCI6520 64-bit 133MHz PCI-X-to-PCI-X Bridge",
             0x6540: "PCI6540 64-bit 133MHz PCI-X-to-PCI-X Bridge",
             0x6541: "PCI6540/6466 PCI-PCI bridge (non-transparent mode, primary side)",
             0x6542: "PCI6540/6466 PCI-PCI bridge (non-transparent mode, secondary side)",
             0x8111: "PEX 8111 PCI Express-to-PCI Bridge",
             0x8112: "PEX8112 x1 Lane PCI Express-to-PCI Bridge",
             0x8114: "PEX 8114 PCI Express-to-PCI/PCI-X Bridge",
             0x8311: "PEX8311 x1 Lane PCI Express-to-Generic Local Bus Bridge",
             0x8505: "PEX 8505 5-lane, 5-port PCI Express Switch",
             0x8508: "PEX 8508 8-lane, 5-port PCI Express Switch",
             0x8509: "PEX 8509 8-lane, 8-port PCI Express Switch",
             0x8512: "PEX 8512 12-lane, 5-port PCI Express Switch",
             0x8516: "PEX Versatile PCI Express Switch",
             0x8517: "PEX 8517 16-lane, 5-port PCI Express Switch",
             0x8518: "PEX 8518 16-lane, 5-port PCI Express Switch",
             0x8524: "PEX 8524 24-lane, 6-port PCI Express Switch",
             0x8525: "PEX 8525 24-lane, 5-port PCI Express Switch",
             0x8532: "PEX Versatile PCI Express Switch",
             0x8533: "PEX 8533 32-lane, 6-port PCI Express Switch",
             0x8547: "PEX 8547 48-lane, 3-port PCI Express Switch",
             0x8548: "PEX 8548 48-lane, 9-port PCI Express Switch",
             0x8603: "PEX 8603 3-lane, 3-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8604: "PEX 8604 4-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8605: "PEX 8605 PCI Express 4-port Gen2 Switch",
             0x8606: "PEX 8606 6 Lane, 6 Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8608: "PEX 8608 8-lane, 8-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8609: "PEX 8609 8-lane, 8-Port PCI Express Gen 2 (5.0 GT/s) Switch with DMA",
             0x8612: "PEX 8612 12-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8613: "PEX 8613 12-lane, 3-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8614: "PEX 8614 12-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8615: "PEX 8615 12-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch with DMA",
             0x8616: "PEX 8616 16-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8617: "PEX 8617 16-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch with P2P",
             0x8618: "PEX 8618 16-lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8619: "PEX 8619 16-lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch with DMA",
             0x8624: "PEX 8624 24-lane, 6-Port PCI Express Gen 2 (5.0 GT/s) Switch [ExpressLane]",
             0x8625: "PEX 8625 24-lane, 24-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8632: "PEX 8632 32-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8636: "PEX 8636 36-lane, 24-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8647: "PEX 8647 48-Lane, 3-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8648: "PEX 8648 48-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8649: "PEX 8649 48-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8664: "PEX 8664 64-lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch",
             0x8680: "PEX 8680 80-lane, 20-Port PCI Express Gen 2 (5.0 GT/s) Multi-Root Switch",
             0x8696: "PEX 8696 96-lane, 24-Port PCI Express Gen 2 (5.0 GT/s) Multi-Root Switch",
             0x8717: "PEX 8717 16-lane, 8-Port PCI Express Gen 3 (8.0 GT/s) Switch with DMA",
             0x8718: "PEX 8718 16-Lane, 5-Port PCI Express Gen 3 (8.0 GT/s) Switch",
             0x8724: "PEX 8724 24-Lane, 6-Port PCI Express Gen 3 (8 GT/s) Switch, 19 x 19mm FCBGA",
             0x8725: "PEX 8725 24-Lane, 10-Port PCI Express Gen 3 (8.0 GT/s) Multi-Root Switch with DMA",
             0x8732: "PEX 8732 32-lane, 8-Port PCI Express Gen 3 (8.0 GT/s) Switch",
             0x8734: "PEX 8734 32-lane, 8-Port PCI Express Gen 3 (8.0GT/s) Switch",
             0x8747: "PEX 8747 48-Lane, 5-Port PCI Express Gen 3 (8.0 GT/s) Switch",
             0x8748: "PEX 8748 48-Lane, 12-Port PCI Express Gen 3 (8 GT/s) Switch, 27 x 27mm FCBGA",
             0x8749: "PEX 8749 48-Lane, 18-Port PCI Express Gen 3 (8.0 GT/s) Multi-Root Switch with DMA",
             0x87A0: "PEX PCI Express Switch NT0 Port Link Interface",
             0x87A1: "PEX PCI Express Switch NT1 Port Link Interface",
             0x87B0: "PEX PCI Express Switch NT0 Port Virtual Interface",
             0x87B1: "PEX PCI Express Switch NT1 Port Virtual Interface",
             0x87D0: "PEX PCI Express Switch DMA interface",
             0x9016: "PLX 9016 8-port serial controller",
             0x9030: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge",
             0x9036: "9036",
             0x9050: "PCI <-> IOBus Bridge",
             0x9052: "PCI9052 PCI <-> IOBus Bridge",
             0x9054: "PCI9054 32-bit 33MHz PCI <-> IOBus Bridge",
             0x9056: "PCI9056 32-bit 66MHz PCI <-> IOBus Bridge",
             0x9060: "PCI9060 32-bit 33MHz PCI <-> IOBus Bridge",
             0x906D: "9060SD",
             0x906E: "9060ES",
             0x9080: "PCI9080 32-bit; 33MHz PCI <-> IOBus Bridge",
             0x9656: "PCI9656 PCI <-> IOBus Bridge",
             0x9733: "PEX 9733 33-lane, 9-port PCI Express Gen 3 (8.0 GT/s) Switch",
             0x9749: "PEX 9749 49-lane, 13-port PCI Express Gen 3 (8.0 GT/s) Switch",
             0xA100: "Blackmagic Design DeckLink",
             0xBB04: "B&B 3PCIOSD1A Isolated PCI Serial",
             0xC001: "CronyxOmega-PCI (8-port RS232)",
             0xD00D: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge",
             0xD33D: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge",
             0xD44D: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge",
             },

    # Madge Networks
    0x10B6: {0x0001: "Smart 16/4 PCI Ringnode",
             0x0002: "Smart 16/4 PCI Ringnode Mk2",
             0x0003: "Smart 16/4 PCI Ringnode Mk3",
             0x0004: "Smart 16/4 PCI Ringnode Mk1",
             0x0006: "16/4 Cardbus Adapter",
             0x0007: "Presto PCI Adapter",
             0x0009: "Smart 100/16/4 PCI-HS Ringnode",
             0x000A: "Token Ring 100/16/4 Ringnode/Ringrunner",
             0x000B: "16/4 CardBus Adapter Mk2",
             0x000C: "RapidFire 3140V2 16/4 TR Adapter",
             0x1000: "Collage 25/155 ATM Client Adapter",
             0x1001: "Collage 155 ATM Server Adapter",
             },

    # 3Com Corporation
    0x10B7: {0x0001: "3c985 1000BaseSX (SX/TX)",
             0x0013: "AR5212 802.11abg NIC (3CRDAG675)",
             0x0910: "3C910-A01",
             0x1006: "MINI PCI type 3B Data Fax Modem",
             0x1007: "Mini PCI 56k Winmodem",
             0x1201: "3c982-TXM 10/100baseTX Dual Port A [Hydra]",
             0x1202: "3c982-TXM 10/100baseTX Dual Port B [Hydra]",
             0x1700: "3c940 10/100/1000Base-T [Marvell]",
             0x3390: "3c339 TokenLink Velocity",
             0x3590: "3c359 TokenLink Velocity XL",
             0x4500: "3c450 HomePNA [Tornado]",
             0x5055: "3c555 Laptop Hurricane",
             0x5057: "3c575 Megahertz 10/100 LAN CardBus [Boomerang]",
             0x5157: "3cCFE575BT Megahertz 10/100 LAN CardBus [Cyclone]",
             0x5257: "3cCFE575CT CardBus [Cyclone]",
             0x5900: "3c590 10BaseT [Vortex]",
             0x5920: "3c592 EISA 10mbps Demon/Vortex",
             0x5950: "3c595 100BaseTX [Vortex]",
             0x5951: "3c595 100BaseT4 [Vortex]",
             0x5952: "3c595 100Base-MII [Vortex]",
             0x5970: "3c597 EISA Fast Demon/Vortex",
             0x5B57: "3c595 Megahertz 10/100 LAN CardBus [Boomerang]",
             0x6000: "3CRSHPW796 [OfficeConnect Wireless CardBus]",
             0x6001: "3com 3CRWE154G72 [Office Connect Wireless LAN Adapter]",
             0x6055: "3c556 Hurricane CardBus [Cyclone]",
             0x6056: "3c556B CardBus [Tornado]",
             0x6560: "3cCFE656 CardBus [Cyclone]",
             0x6561: "3cCFEM656 10/100 LAN+56K Modem CardBus",
             0x6562: "3cCFEM656B 10/100 LAN+Winmodem CardBus [Cyclone]",
             0x6563: "3cCFEM656B 10/100 LAN+56K Modem CardBus",
             0x6564: "3cXFEM656C 10/100 LAN+Winmodem CardBus [Tornado]",
             0x7646: "3cSOHO100-TX Hurricane",
             0x7770: "3CRWE777 PCI Wireless Adapter [Airconnect]",
             0x7940: "3c803 FDDILink UTP Controller",
             0x7980: "3c804 FDDILink SAS Controller",
             0x7990: "3c805 FDDILink DAS Controller",
             0x80EB: "3c940B 10/100/1000Base-T",
             0x8811: "Token ring",
             0x9000: "3c900 10BaseT [Boomerang]",
             0x9001: "3c900 10Mbps Combo [Boomerang]",
             0x9004: "3c900B-TPO Etherlink XL [Cyclone]",
             0x9005: "3c900B-Combo Etherlink XL [Cyclone]",
             0x9006: "3c900B-TPC Etherlink XL [Cyclone]",
             0x900A: "3c900B-FL 10base-FL [Cyclone]",
             0x9050: "3c905 100BaseTX [Boomerang]",
             0x9051: "3c905 100BaseT4 [Boomerang]",
             0x9054: "3C905B-TX Fast Etherlink XL PCI",
             0x9055: "3c905B 100BaseTX [Cyclone]",
             0x9056: "3c905B-T4 Fast EtherLink XL [Cyclone]",
             0x9058: "3c905B Deluxe Etherlink 10/100/BNC [Cyclone]",
             0x905A: "3c905B-FX Fast Etherlink XL FX 100baseFx [Cyclone]",
             0x9200: "3c905C-TX/TX-M [Tornado]",
             0x9201: "3C920B-EMB Integrated Fast Ethernet Controller [Tornado]",
             0x9202: "3Com 3C920B-EMB-WNM Integrated Fast Ethernet Controller",
             0x9210: "3C920B-EMB-WNM Integrated Fast Ethernet Controller",
             0x9300: "3CSOHO100B-TX 910-A01 [tulip]",
             0x9800: "3c980-TX Fast Etherlink XL Server Adapter [Cyclone]",
             0x9805: "3c980-C 10/100baseTX NIC [Python-T]",
             0x9900: "3C990-TX [Typhoon]",
             0x9902: "3CR990-TX-95 [Typhoon 56-bit]",
             0x9903: "3CR990-TX-97 [Typhoon 168-bit]",
             0x9904: "3C990B-TX-M/3C990BSVR [Typhoon2]",
             0x9905: "3CR990-FX-95/97/95 [Typhon Fiber]",
             0x9908: "3CR990SVR95 [Typhoon Server 56-bit]",
             0x9909: "3CR990SVR97 [Typhoon Server 168-bit]",
             0x990A: "3C990SVR [Typhoon Server]",
             0x990B: "3C990SVR [Typhoon Server]",
             },

    # Standard Microsystems Corp [SMC]
    0x10B8: {0x0005: "83c170 EPIC/100 Fast Ethernet Adapter",
             0x0006: "83c175 EPIC/100 Fast Ethernet Adapter",
             0x1000: "FDC 37c665",
             0x1001: "FDC 37C922",
             0xA011: "83C170QF",
             0xB106: "SMC34C90",
             },

    # ULi Electronics Inc.
    0x10B9: {0x0101: "CMI8338/C3DX PCI Audio Device",
             0x0111: "C-Media CMI8738/C3DX Audio Device (OEM)",
             0x0780: "Multi-IO Card",
             0x0782: "Multi-IO Card",
             0x1435: "M1435",
             0x1445: "M1445",
             0x1449: "M1449",
             0x1451: "M1451",
             0x1461: "M1461",
             0x1489: "M1489 Cache-Memory PCI Controller (CMP) [FinALi 486] CPU to PCI bridge",
             0x1511: "M1511 [Aladdin]",
             0x1512: "M1512 [Aladdin]",
             0x1513: "M1513 [Aladdin]",
             0x1521: "M1521 [Aladdin III]",
             0x1523: "M1523",
             0x1531: "M1531 [Aladdin IV]",
             0x1533: "M1533/M1535/M1543 PCI to ISA Bridge [Aladdin IV/V/V+]",
             0x1541: "M1541",
             0x1543: "M1543",
             0x1563: "M1563 HyperTransport South Bridge",
             0x1573: "PCI to LPC Controller",
             0x1575: "M1575 South Bridge",
             0x1621: "M1621",
             0x1631: "ALI M1631 PCI North Bridge Aladdin Pro III",
             0x1632: "M1632M Northbridge+Trident",
             0x1641: "ALI M1641 PCI North Bridge Aladdin Pro IV",
             0x1644: "M1644/M1644T Northbridge+Trident",
             0x1646: "M1646 Northbridge+Trident",
             0x1647: "M1647 Northbridge [MAGiK 1 / MobileMAGiK 1]",
             0x1651: "M1651/M1651T Northbridge [Aladdin-Pro 5/5M,Aladdin-Pro 5T/5TM]",
             0x1671: "M1671 Super P4 Northbridge [AGP4X,PCI and SDR/DDR]",
             0x1672: "M1672 Northbridge [CyberALADDiN-P4]",
             0x1681: "M1681 P4 Northbridge [AGP8X,HyperTransport and SDR/DDR]",
             0x1687: "M1687 K8 Northbridge [AGP8X and HyperTransport]",
             0x1689: "M1689 K8 Northbridge [Super K8 Single Chip]",
             0x1695: "M1695 Host Bridge",
             0x1697: "M1697 HTT Host Bridge",
             0x3141: "M3141",
             0x3143: "M3143",
             0x3145: "M3145",
             0x3147: "M3147",
             0x3149: "M3149",
             0x3151: "M3151",
             0x3307: "M3307",
             0x3309: "M3309",
             0x3323: "M3325 Video/Audio Decoder",
             0x5212: "M4803",
             0x5215: "MS4803",
             0x5217: "M5217H",
             0x5219: "M5219",
             0x5225: "M5225",
             0x5228: "M5228 ALi ATA/RAID Controller",
             0x5229: "M5229 IDE",
             0x5235: "M5225",
             0x5237: "USB 1.1 Controller",
             0x5239: "USB 2.0 Controller",
             0x5243: "M1541 PCI to AGP Controller",
             0x5246: "AGP8X Controller",
             0x5247: "PCI to AGP Controller",
             0x5249: "M5249 HTT to PCI Bridge",
             0x524B: "PCI Express Root Port",
             0x524C: "PCI Express Root Port",
             0x524D: "PCI Express Root Port",
             0x524E: "PCI Express Root Port",
             0x5251: "M5251 P1394 OHCI 1.0 Controller",
             0x5253: "M5253 P1394 OHCI 1.1 Controller",
             0x5261: "M5261 Ethernet Controller",
             0x5263: "ULi 1689,1573 integrated ethernet.",
             0x5281: "ALi M5281 Serial ATA / RAID Host Controller",
             0x5287: "ULi 5287 SATA",
             0x5288: "ULi M5288 SATA",
             0x5289: "ULi 5289 SATA",
             0x5450: "Lucent Technologies Soft Modem AMR",
             0x5451: "M5451 PCI AC-Link Controller Audio Device",
             0x5453: "M5453 PCI AC-Link Controller Modem Device",
             0x5455: "M5455 PCI AC-Link Controller Audio Device",
             0x5457: "M5457 AC'97 Modem Controller",
             0x5459: "SmartLink SmartPCI561 56K Modem",
             0x545A: "SmartLink SmartPCI563 56K Modem",
             0x5461: "HD Audio Controller",
             0x5471: "M5471 Memory Stick Controller",
             0x5473: "M5473 SD-MMC Controller",
             0x7101: "M7101 Power Management Controller [PMU]",
             },

    # Mitsubishi Electric Corp.
    0x10BA: {0x0301: "AccelGraphics AccelECLIPSE",
             0x0304: "AccelGALAXY A2100 [OEM Evans & Sutherland]",
             0x0308: "Tornado 3000 [OEM Evans & Sutherland]",
             0x1002: "VG500 [VolumePro Volume Rendering Accelerator]",
             },

    # Neomagic Corporation
    0x10C8: {0x0001: "NM2070 [MagicGraph 128]",
             0x0002: "NM2090 [MagicGraph 128V]",
             0x0003: "NM2093 [MagicGraph 128ZV]",
             0x0004: "NM2160 [MagicGraph 128XD]",
             0x0005: "NM2200 [MagicGraph 256AV]",
             0x0006: "NM2360 [MagicMedia 256ZX]",
             0x0016: "NM2380 [MagicMedia 256XL+]",
             0x0025: "NM2230 [MagicGraph 256AV+]",
             0x0083: "NM2093 [MagicGraph 128ZV+]",
             0x8005: "NM2200 [MagicMedia 256AV Audio]",
             0x8006: "NM2360 [MagicMedia 256ZX Audio]",
             0x8016: "NM2380 [MagicMedia 256XL+ Audio]",
             },

    # Mai Logic Incorporated
    0x10CC: {0x0660: "Articia S Host Bridge",
             0x0661: "Articia S PCI Bridge",
             },

    # Advanced System Products, Inc
    0x10CD: {0x1100: "ASC1100",
             0x1200: "ASC1200 [(abp940) Fast SCSI-II]",
             0x1300: "ASC1300 / ASC3030 [ABP940-U / ABP960-U / ABP3925]",
             0x2300: "ABP940-UW",
             0x2500: "ABP940-U2W",
             0x2700: "ABP3950-U3W",
             },

    # Fujitsu Limited.
    0x10CF: {0x01EF: "PCEA4 PCI-Express Dual Port ESCON Adapter",
             0x1414: "On-board USB 1.1 companion controller",
             0x1415: "On-board USB 2.0 EHCI controller",
             0x1422: "E8410 nVidia graphics adapter",
             0x142D: "HD audio (Realtek ALC262)",
             0x1430: "82566MM Intel 1Gb copper LAN interface",
             0x1623: "PCEA4 PCI-Express Dual Port ESCON Adapter",
             0x2001: "mb86605",
             0x200C: "MB86613L IEEE1394 OHCI 1.0 Controller",
             0x2010: "MB86613S IEEE1394 OHCI 1.1 Controller",
             0x2019: "MB86295S [CORAL P]",
             0x201E: "MB86296S [CORAL PA]",
             0x202B: "MB86297A [Carmine Graphics Controller]",
             },

    # Macronix, Inc. [MXIC]
    0x10D9: {0x0431: "MX98715",
             0x0512: "MX98713",
             0x0531: "MX987x5",
             0x8625: "MX86250",
             0x8626: "Macronix MX86251 + 3Dfx Voodoo Rush",
             0x8888: "MX86200",
             },

    # Compaq IPG-Austin
    0x10DA: {0x0508: "TC4048 Token Ring 4/16",
             0x3390: "Tl3c3x9",
             },

    # CERN/ECP/EDU
    0x10DC: {0x0001: "STAR/RD24 SCI-PCI (PMC)",
             0x0002: "TAR/RD24 SCI-PCI (PMC)",
             0x0021: "HIPPI destination",
             0x0022: "HIPPI source",
             0x10DC: "ATT2C15-3 FPGA",
             },

    # NVIDIA Corporation
    0x10DE: {0x0008: "NV1 [STG2000X-B Series]",
             0x0009: "NV1 [NV1 Series]",
             0x0018: "NV3 [Riva 128]",
             0x0019: "NV3 [Riva 128ZX]",
             0x0020: "NV4 [Riva TNT]",
             0x0028: "NV5 [Riva TNT2 / TNT2 Pro]",
             0x0029: "NV5 [Riva TNT2 Ultra]",
             0x002A: "NV5 [Riva TNT2]",
             0x002B: "NV5 [Riva TNT2]",
             0x002C: "NV5 [Vanta / Vanta LT]",
             0x002D: "NV5 [Riva TNT2 Model 64 / Model 64 Pro]",
             0x0034: "MCP04 SMBus",
             0x0035: "MCP04 IDE",
             0x0036: "MCP04 Serial ATA Controller",
             0x0037: "MCP04 Ethernet Controller",
             0x0038: "MCP04 Ethernet Controller",
             0x003A: "MCP04 AC'97 Audio Controller",
             0x003B: "MCP04 USB Controller",
             0x003C: "MCP04 USB Controller",
             0x003D: "MCP04 PCI Bridge",
             0x003E: "MCP04 Serial ATA Controller",
             0x0040: "NV40 [GeForce 6800 Ultra]",
             0x0041: "NV40 [GeForce 6800]",
             0x0042: "NV40 [GeForce 6800 LE]",
             0x0043: "NV40 [GeForce 6800 XE]",
             0x0044: "NV40 [GeForce 6800 XT]",
             0x0045: "NV40 [GeForce 6800 GT]",
             0x0047: "NV40 [GeForce 6800 GS]",
             0x0048: "NV40 [GeForce 6800 XT]",
             0x004E: "NV40GL [Quadro FX 4000]",
             0x0050: "CK804 ISA Bridge",
             0x0051: "CK804 ISA Bridge",
             0x0052: "CK804 SMBus",
             0x0053: "CK804 IDE",
             0x0054: "CK804 Serial ATA Controller",
             0x0055: "CK804 Serial ATA Controller",
             0x0056: "CK804 Ethernet Controller",
             0x0057: "CK804 Ethernet Controller",
             0x0058: "CK804 AC'97 Modem",
             0x0059: "CK804 AC'97 Audio Controller",
             0x005A: "CK804 USB Controller",
             0x005B: "CK804 USB Controller",
             0x005C: "CK804 PCI Bridge",
             0x005D: "CK804 PCIE Bridge",
             0x005E: "CK804 Memory Controller",
             0x005F: "CK804 Memory Controller",
             0x0060: "nForce2 ISA Bridge",
             0x0064: "nForce2 SMBus (MCP)",
             0x0065: "nForce2 IDE",
             0x0066: "nForce2 Ethernet Controller",
             0x0067: "nForce2 USB Controller",
             0x0068: "nForce2 USB Controller",
             0x006A: "nForce2 AC97 Audio Controler (MCP)",
             0x006B: "nForce Audio Processing Unit",
             0x006C: "nForce2 External PCI Bridge",
             0x006D: "nForce2 PCI Bridge",
             0x006E: "nForce2 FireWire (IEEE 1394) Controller",
             0x0080: "MCP2A ISA bridge",
             0x0084: "MCP2A SMBus",
             0x0085: "MCP2A IDE",
             0x0086: "MCP2A Ethernet Controller",
             0x0087: "MCP2A USB Controller",
             0x0088: "MCP2A USB Controller",
             0x008A: "MCP2S AC'97 Audio Controller",
             0x008B: "MCP2A PCI Bridge",
             0x008C: "MCP2A Ethernet Controller",
             0x008E: "nForce2 Serial ATA Controller",
             0x0090: "G70 [GeForce 7800 GTX]",
             0x0091: "G70 [GeForce 7800 GTX]",
             0x0092: "G70 [GeForce 7800 GT]",
             0x0093: "G70 [GeForce 7800 GS]",
             0x0094: "High Definition Audio",
             0x0095: "G70 [GeForce 7800 SLI]",
             0x0097: "G70 [GeForce GTS 250]",
             0x0098: "G70M [GeForce Go 7800]",
             0x0099: "G70M [GeForce Go 7800 GTX]",
             0x009D: "G70GL [Quadro FX 4500]",
             0x00A0: "NV0A [Aladdin TNT2 IGP]",
             0x00C0: "NV41 [GeForce 6800 GS]",
             0x00C1: "NV41 [GeForce 6800]",
             0x00C2: "NV41 [GeForce 6800 LE]",
             0x00C3: "NV41 [GeForce 6800 XT]",
             0x00C5: "NV41",
             0x00C6: "NV41",
             0x00C7: "NV41",
             0x00C8: "NV41M [GeForce Go 6800]",
             0x00C9: "NV41M [GeForce Go 6800 Ultra]",
             0x00CC: "NV41GLM [Quadro FX Go1400]",
             0x00CD: "NV42GL [Quadro FX 3450/4000 SDI]",
             0x00CE: "NV41GL [Quadro FX 1400]",
             0x00CF: "NV41",
             0x00D0: "nForce3 LPC Bridge",
             0x00D1: "nForce3 Host Bridge",
             0x00D2: "nForce3 AGP Bridge",
             0x00D3: "CK804 Memory Controller",
             0x00D4: "nForce3 SMBus",
             0x00D5: "nForce3 IDE",
             0x00D6: "nForce3 Ethernet",
             0x00D7: "nForce3 USB 1.1",
             0x00D8: "nForce3 USB 2.0",
             0x00D9: "nForce3 Audio",
             0x00DA: "nForce3 Audio",
             0x00DD: "nForce3 PCI Bridge",
             0x00DF: "CK8S Ethernet Controller",
             0x00E0: "nForce3 250Gb LPC Bridge",
             0x00E1: "nForce3 250Gb Host Bridge",
             0x00E2: "nForce3 250Gb AGP Host to PCI Bridge",
             0x00E3: "nForce3 Serial ATA Controller",
             0x00E4: "nForce 250Gb PCI System Management",
             0x00E5: "CK8S Parallel ATA Controller (v2.5)",
             0x00E6: "CK8S Ethernet Controller",
             0x00E7: "CK8S USB Controller",
             0x00E8: "nForce3 EHCI USB 2.0 Controller",
             0x00EA: "nForce3 250Gb AC'97 Audio Controller",
             0x00ED: "nForce3 250Gb PCI-to-PCI Bridge",
             0x00EE: "nForce3 Serial ATA Controller 2",
             0x00F1: "NV43 [GeForce 6600 GT]",
             0x00F2: "NV43 [GeForce 6600]",
             0x00F3: "NV43 [GeForce 6200]",
             0x00F4: "NV43 [GeForce 6600 LE]",
             0x00F5: "G70/G71 [GeForce 7800 GS AGP]",
             0x00F6: "NV43 [GeForce 6800 GS/XT]",
             0x00F8: "NV45GL [Quadro FX 3400/4400]",
             0x00F9: "NV40 [GeForce 6800 GT/GTO/Ultra]",
             0x00FA: "NV39 [GeForce PCX 5750]",
             0x00FB: "NV35 [GeForce PCX 5900]",
             0x00FC: "NV37GL [Quadro FX 330/GeForce PCX 5300]",
             0x00FD: "NV37GL [Quadro PCI-E Series]",
             0x00FE: "NV38GL [Quadro FX 1300]",
             0x00FF: "NV19 [GeForce PCX 4300]",
             0x0100: "NV10 [GeForce 256 SDR]",
             0x0101: "NV10 [GeForce 256 DDR]",
             0x0103: "NV10GL [Quadro]",
             0x0110: "NV11 [GeForce2 MX/MX 400]",
             0x0111: "NV11 [GeForce2 MX200]",
             0x0112: "NV11M [GeForce2 Go]",
             0x0113: "NV11GL [Quadro2 MXR/EX/Go]",
             0x0140: "NV43 [GeForce 6600 GT]",
             0x0141: "NV43 [GeForce 6600]",
             0x0142: "NV43 [GeForce 6600 LE]",
             0x0143: "NV43 [GeForce 6600 VE]",
             0x0144: "NV43M [GeForce Go 6600]",
             0x0145: "NV43 [GeForce 6610 XL]",
             0x0146: "NV43M [GeForce Go6200 TE / 6600 TE]",
             0x0147: "NV43 [GeForce 6700 XL]",
             0x0148: "NV43M [GeForce Go 6600]",
             0x0149: "NV43M [GeForce Go 6600 GT]",
             0x014A: "NV43 [Quadro NVS 440]",
             0x014B: "NV43",
             0x014D: "NV43GL [Quadro FX 550]",
             0x014E: "NV43GL [Quadro FX 540]",
             0x014F: "NV43 [GeForce 6200]",
             0x0150: "NV15 [GeForce2 GTS/Pro]",
             0x0151: "NV15 [GeForce2 Ti]",
             0x0152: "NV15 [GeForce2 Ultra]",
             0x0153: "NV15GL [Quadro2 Pro]",
             0x0160: "NV44 [GeForce 6500]",
             0x0161: "NV44 [GeForce 6200 TurboCache]",
             0x0162: "NV44 [GeForce 6200 SE TurboCache]",
             0x0163: "NV44 [GeForce 6200 LE]",
             0x0164: "NV44M [GeForce Go 6200]",
             0x0165: "NV44 [Quadro NVS 285]",
             0x0166: "NV44M [GeForce Go 6400]",
             0x0167: "NV44M [GeForce Go 6200]",
             0x0168: "NV44M [GeForce Go 6400]",
             0x0169: "NV44 [GeForce 6250]",
             0x016A: "NV44 [GeForce 7100 GS]",
             0x016D: "NV44",
             0x016E: "NV44",
             0x016F: "NV44",
             0x0170: "NV17 [GeForce4 MX 460]",
             0x0171: "NV17 [GeForce4 MX 440]",
             0x0172: "NV17 [GeForce4 MX 420]",
             0x0173: "NV17 [GeForce4 MX 440-SE]",
             0x0174: "NV17M [GeForce4 440 Go]",
             0x0175: "NV17M [GeForce4 420 Go]",
             0x0176: "NV17M [GeForce4 420 Go 32M]",
             0x0177: "NV17M [GeForce4 460 Go]",
             0x0178: "NV17GL [Quadro4 550 XGL]",
             0x0179: "NV17M [GeForce4 440 Go 64M]",
             0x017A: "NV17GL [Quadro NVS]",
             0x017B: "NV17GL [Quadro4 550 XGL]",
             0x017C: "NV17GL [Quadro4 500 GoGL]",
             0x017F: "NV17",
             0x0181: "NV18 [GeForce4 MX 440 AGP 8x]",
             0x0182: "NV18 [GeForce4 MX 440SE AGP 8x]",
             0x0183: "NV18 [GeForce4 MX 420 AGP 8x]",
             0x0184: "NV18 [GeForce4 MX]",
             0x0185: "NV18 [GeForce4 MX 4000]",
             0x0186: "NV18M [GeForce4 448 Go]",
             0x0187: "NV18M [GeForce4 488 Go]",
             0x0188: "NV18GL [Quadro4 580 XGL]",
             0x0189: "NV18 [GeForce4 MX with AGP8X (Mac)]",
             0x018A: "NV18GL [Quadro NVS 280 SD]",
             0x018B: "NV18GL [Quadro4 380 XGL]",
             0x018C: "NV18GL [Quadro NVS 50 PCI]",
             0x018D: "NV18M [GeForce4 448 Go]",
             0x0190: "G80 [GeForce 8800 GTS / 8800 GTX]",
             0x0191: "G80 [GeForce 8800 GTX]",
             0x0192: "G80 [GeForce 8800 GTS]",
             0x0193: "G80 [GeForce 8800 GTS]",
             0x0194: "G80 [GeForce 8800 Ultra]",
             0x0197: "G80GL [Tesla C870]",
             0x019D: "G80GL [Quadro FX 5600]",
             0x019E: "G80GL [Quadro FX 4600]",
             0x01A0: "nForce 220/420 NV1A [GeForce2 MX]",
             0x01A4: "nForce CPU bridge",
             0x01AB: "nForce 420 Memory Controller (DDR)",
             0x01AC: "nForce 220/420 Memory Controller",
             0x01AD: "nForce 220/420 Memory Controller",
             0x01B0: "nForce Audio Processing Unit",
             0x01B1: "nForce AC'97 Audio Controller",
             0x01B2: "nForce ISA Bridge",
             0x01B4: "nForce PCI System Management",
             0x01B7: "nForce AGP to PCI Bridge",
             0x01B8: "nForce PCI-to-PCI bridge",
             0x01BC: "nForce IDE",
             0x01C1: "nForce AC'97 Modem Controller",
             0x01C2: "nForce USB Controller",
             0x01C3: "nForce Ethernet Controller",
             0x01D0: "G72 [GeForce 7350 LE]",
             0x01D1: "G72 [GeForce 7300 LE]",
             0x01D2: "G72 [GeForce 7550 LE]",
             0x01D3: "G72 [GeForce 7200 GS / 7300 SE]",
             0x01D5: "G72",
             0x01D6: "G72M [GeForce Go 7200]",
             0x01D7: "G72M [Quadro NVS 110M/GeForce Go 7300]",
             0x01D8: "G72M [GeForce Go 7400]",
             0x01D9: "G72M [GeForce Go 7450]",
             0x01DA: "G72M [Quadro NVS 110M]",
             0x01DB: "G72M [Quadro NVS 120M]",
             0x01DC: "G72GLM [Quadro FX 350M]",
             0x01DD: "G72 [GeForce 7500 LE]",
             0x01DE: "G72GL [Quadro FX 350]",
             0x01DF: "G72 [GeForce 7300 GS]",
             0x01E0: "nForce2 IGP2",
             0x01E8: "nForce2 AGP",
             0x01EA: "nForce2 Memory Controller 0",
             0x01EB: "nForce2 Memory Controller 1",
             0x01EC: "nForce2 Memory Controller 2",
             0x01ED: "nForce2 Memory Controller 3",
             0x01EE: "nForce2 Memory Controller 4",
             0x01EF: "nForce2 Memory Controller 5",
             0x01F0: "NV1F C17 [GeForce4 MX IGP]",
             0x0200: "NV20 [GeForce3]",
             0x0201: "NV20 [GeForce3 Ti 200]",
             0x0202: "NV20 [GeForce3 Ti 500]",
             0x0203: "NV20GL [Quadro DCC]",
             0x0211: "NV48 [GeForce 6800]",
             0x0212: "NV48 [GeForce 6800 LE]",
             0x0215: "NV48 [GeForce 6800 GT]",
             0x0218: "NV48 [GeForce 6800 XT]",
             0x0221: "NV44A [GeForce 6200]",
             0x0222: "NV44 [GeForce 6200 A-LE]",
             0x0224: "NV44",
             0x0240: "C51PV [GeForce 6150]",
             0x0241: "C51 [GeForce 6150 LE]",
             0x0242: "C51G [GeForce 6100]",
             0x0243: "C51 PCI Express Bridge",
             0x0244: "C51 [GeForce Go 6150]",
             0x0245: "C51 [Quadro NVS 210S/GeForce 6150LE]",
             0x0246: "C51 PCI Express Bridge",
             0x0247: "C51 [GeForce Go 6100]",
             0x0248: "C51 PCI Express Bridge",
             0x0249: "C51 PCI Express Bridge",
             0x024A: "C51 PCI Express Bridge",
             0x024B: "C51 PCI Express Bridge",
             0x024C: "C51 PCI Express Bridge",
             0x024D: "C51 PCI Express Bridge",
             0x024E: "C51 PCI Express Bridge",
             0x024F: "C51 PCI Express Bridge",
             0x0250: "NV25 [GeForce4 Ti 4600]",
             0x0251: "NV25 [GeForce4 Ti 4400]",
             0x0252: "NV25 [GeForce4 Ti]",
             0x0253: "NV25 [GeForce4 Ti 4200]",
             0x0258: "NV25GL [Quadro4 900 XGL]",
             0x0259: "NV25GL [Quadro4 750 XGL]",
             0x025B: "NV25GL [Quadro4 700 XGL]",
             0x0260: "MCP51 LPC Bridge",
             0x0261: "MCP51 LPC Bridge",
             0x0262: "MCP51 LPC Bridge",
             0x0263: "MCP51 LPC Bridge",
             0x0264: "MCP51 SMBus",
             0x0265: "MCP51 IDE",
             0x0266: "MCP51 Serial ATA Controller",
             0x0267: "MCP51 Serial ATA Controller",
             0x0268: "MCP51 Ethernet Controller",
             0x0269: "MCP51 Ethernet Controller",
             0x026A: "MCP51 MCI",
             0x026B: "MCP51 AC97 Audio Controller",
             0x026C: "MCP51 High Definition Audio",
             0x026D: "MCP51 USB Controller",
             0x026E: "MCP51 USB Controller",
             0x026F: "MCP51 PCI Bridge",
             0x0270: "MCP51 Host Bridge",
             0x0271: "MCP51 PMU",
             0x0272: "MCP51 Memory Controller 0",
             0x027E: "C51 Memory Controller 2",
             0x027F: "C51 Memory Controller 3",
             0x0280: "NV28 [GeForce4 Ti 4800]",
             0x0281: "NV28 [GeForce4 Ti 4200 AGP 8x]",
             0x0282: "NV28 [GeForce4 Ti 4800 SE]",
             0x0286: "NV28M [GeForce4 Ti 4200 Go AGP 8x]",
             0x0288: "NV28GL [Quadro4 980 XGL]",
             0x0289: "NV28GL [Quadro4 780 XGL]",
             0x028C: "NV28GLM [Quadro4 Go700]",
             0x0290: "G71 [GeForce 7900 GTX]",
             0x0291: "G71 [GeForce 7900 GT/GTO]",
             0x0292: "G71 [GeForce 7900 GS]",
             0x0293: "G71 [GeForce 7900 GX2]",
             0x0294: "G71 [GeForce 7950 GX2]",
             0x0295: "G71 [GeForce 7950 GT]",
             0x0297: "G71M [GeForce Go 7950 GTX]",
             0x0298: "G71M [GeForce Go 7900 GS]",
             0x0299: "G71M [GeForce Go 7900 GTX]",
             0x029A: "G71GLM [Quadro FX 2500M]",
             0x029B: "G71GLM [Quadro FX 1500M]",
             0x029C: "G71GL [Quadro FX 5500]",
             0x029D: "G71GL [Quadro FX 3500]",
             0x029E: "G71GL [Quadro FX 1500]",
             0x029F: "G71GL [Quadro FX 4500 X2]",
             0x02A0: "NV2A [XGPU]",
             0x02A5: "MCPX CPU Bridge",
             0x02A6: "MCPX Memory Controller",
             0x02E0: "G73 [GeForce 7600 GT AGP]",
             0x02E1: "G73 [GeForce 7600 GS AGP]",
             0x02E2: "G73 [GeForce 7300 GT AGP]",
             0x02E3: "G71 [GeForce 7900 GS AGP]",
             0x02E4: "G71 [GeForce 7950 GT AGP]",
             0x02E5: "G71 [GeForce 7600 GS AGP]",
             0x02F0: "C51 Host Bridge",
             0x02F1: "C51 Host Bridge",
             0x02F2: "C51 Host Bridge",
             0x02F3: "C51 Host Bridge",
             0x02F4: "C51 Host Bridge",
             0x02F5: "C51 Host Bridge",
             0x02F6: "C51 Host Bridge",
             0x02F7: "C51 Host Bridge",
             0x02F8: "C51 Memory Controller 5",
             0x02F9: "C51 Memory Controller 4",
             0x02FA: "C51 Memory Controller 0",
             0x02FB: "C51 PCI Express Bridge",
             0x02FC: "C51 PCI Express Bridge",
             0x02FD: "C51 PCI Express Bridge",
             0x02FE: "C51 Memory Controller 1",
             0x02FF: "C51 Host Bridge",
             0x0300: "NV30 [GeForce FX]",
             0x0301: "NV30 [GeForce FX 5800 Ultra]",
             0x0302: "NV30 [GeForce FX 5800]",
             0x0308: "NV30GL [Quadro FX 2000]",
             0x0309: "NV30GL [Quadro FX 1000]",
             0x0311: "NV31 [GeForce FX 5600 Ultra]",
             0x0312: "NV31 [GeForce FX 5600]",
             0x0314: "NV31 [GeForce FX 5600XT]",
             0x0316: "NV31M",
             0x0318: "NV31GL",
             0x031A: "NV31M [GeForce FX Go5600]",
             0x031B: "NV31M [GeForce FX Go5650]",
             0x031C: "NV31GLM [Quadro FX Go700]",
             0x0320: "NV34 [GeForce FX 5200]",
             0x0321: "NV34 [GeForce FX 5200 Ultra]",
             0x0322: "NV34 [GeForce FX 5200]",
             0x0323: "NV34 [GeForce FX 5200LE]",
             0x0324: "NV34M [GeForce FX Go5200 64M]",
             0x0325: "NV34M [GeForce FX Go5250]",
             0x0326: "NV34 [GeForce FX 5500]",
             0x0327: "NV34 [GeForce FX 5100]",
             0x0328: "NV34M [GeForce FX Go5200 32M/64M]",
             0x0329: "NV34M [GeForce FX Go5200]",
             0x032A: "NV34GL [Quadro NVS 280 PCI]",
             0x032B: "NV34GL [Quadro FX 500/600 PCI]",
             0x032C: "NV34M [GeForce FX Go5300 / Go5350]",
             0x032D: "NV34M [GeForce FX Go5100]",
             0x032E: "NV34",
             0x032F: "NV34 [GeForce FX 5200]",
             0x0330: "NV35 [GeForce FX 5900 Ultra]",
             0x0331: "NV35 [GeForce FX 5900]",
             0x0332: "NV35 [GeForce FX 5900XT]",
             0x0333: "NV38 [GeForce FX 5950 Ultra]",
             0x0334: "NV35 [GeForce FX 5900ZT]",
             0x0338: "NV35GL [Quadro FX 3000]",
             0x033F: "NV35GL [Quadro FX 700]",
             0x0341: "NV36 [GeForce FX 5700 Ultra]",
             0x0342: "NV36 [GeForce FX 5700]",
             0x0343: "NV36 [GeForce FX 5700LE]",
             0x0344: "NV36 [GeForce FX 5700VE]",
             0x0347: "NV36M [GeForce FX Go5700]",
             0x0348: "NV36M [GeForce FX Go5700]",
             0x034C: "NV36 [Quadro FX Go1000]",
             0x034D: "NV36",
             0x034E: "NV36GL [Quadro FX 1100]",
             0x0360: "MCP55 LPC Bridge",
             0x0361: "MCP55 LPC Bridge",
             0x0362: "MCP55 LPC Bridge",
             0x0363: "MCP55 LPC Bridge",
             0x0364: "MCP55 LPC Bridge",
             0x0365: "MCP55 LPC Bridge",
             0x0366: "MCP55 LPC Bridge",
             0x0367: "MCP55 LPC Bridge",
             0x0368: "MCP55 SMBus Controller",
             0x0369: "MCP55 Memory Controller",
             0x036A: "MCP55 Memory Controller",
             0x036B: "MCP55 SMU",
             0x036C: "MCP55 USB Controller",
             0x036D: "MCP55 USB Controller",
             0x036E: "MCP55 IDE",
             0x0370: "MCP55 PCI bridge",
             0x0371: "MCP55 High Definition Audio",
             0x0372: "MCP55 Ethernet",
             0x0373: "MCP55 Ethernet",
             0x0374: "MCP55 PCI Express bridge",
             0x0375: "MCP55 PCI Express bridge",
             0x0376: "MCP55 PCI Express bridge",
             0x0377: "MCP55 PCI Express bridge",
             0x0378: "MCP55 PCI Express bridge",
             0x037A: "MCP55 Memory Controller",
             0x037E: "MCP55 SATA Controller",
             0x037F: "MCP55 SATA Controller",
             0x038B: "G73 [GeForce 7650 GS]",
             0x0390: "G73 [GeForce 7650 GS]",
             0x0391: "G73 [GeForce 7600 GT]",
             0x0392: "G73 [GeForce 7600 GS]",
             0x0393: "G73 [GeForce 7300 GT]",
             0x0394: "G73 [GeForce 7600 LE]",
             0x0395: "G73 [GeForce 7300 GT]",
             0x0396: "G73",
             0x0397: "G73M [GeForce Go 7700]",
             0x0398: "G73M [GeForce Go 7600]",
             0x0399: "G73M [GeForce Go 7600 GT]",
             0x039A: "G73M [Quadro NVS 300M]",
             0x039B: "G73M [GeForce Go 7900 SE]",
             0x039C: "G73GLM [Quadro FX 550M]",
             0x039D: "G73",
             0x039E: "G73GL [Quadro FX 560]",
             0x039F: "G73",
             0x03A0: "C55 Host Bridge",
             0x03A1: "C55 Host Bridge",
             0x03A2: "C55 Host Bridge",
             0x03A3: "C55 Host Bridge",
             0x03A4: "C55 Host Bridge",
             0x03A5: "C55 Host Bridge",
             0x03A6: "C55 Host Bridge",
             0x03A7: "C55 Host Bridge",
             0x03A8: "C55 Memory Controller",
             0x03A9: "C55 Memory Controller",
             0x03AA: "C55 Memory Controller",
             0x03AB: "C55 Memory Controller",
             0x03AC: "C55 Memory Controller",
             0x03AD: "C55 Memory Controller",
             0x03AE: "C55 Memory Controller",
             0x03AF: "C55 Memory Controller",
             0x03B0: "C55 Memory Controller",
             0x03B1: "C55 Memory Controller",
             0x03B2: "C55 Memory Controller",
             0x03B3: "C55 Memory Controller",
             0x03B4: "C55 Memory Controller",
             0x03B5: "C55 Memory Controller",
             0x03B6: "C55 Memory Controller",
             0x03B7: "C55 PCI Express bridge",
             0x03B8: "C55 PCI Express bridge",
             0x03B9: "C55 PCI Express bridge",
             0x03BA: "C55 Memory Controller",
             0x03BB: "C55 PCI Express bridge",
             0x03BC: "C55 Memory Controller",
             0x03D0: "C61 [GeForce 6150SE nForce 430]",
             0x03D1: "C61 [GeForce 6100 nForce 405]",
             0x03D2: "C61 [GeForce 6100 nForce 400]",
             0x03D5: "C61 [GeForce 6100 nForce 420]",
             0x03D6: "C61 [GeForce 7025 / nForce 630a]",
             0x03E0: "MCP61 LPC Bridge",
             0x03E1: "MCP61 LPC Bridge",
             0x03E2: "MCP61 Host Bridge",
             0x03E3: "MCP61 LPC Bridge",
             0x03E4: "MCP61 High Definition Audio",
             0x03E5: "MCP61 Ethernet",
             0x03E6: "MCP61 Ethernet",
             0x03E7: "MCP61 SATA Controller",
             0x03E8: "MCP61 PCI Express bridge",
             0x03E9: "MCP61 PCI Express bridge",
             0x03EA: "MCP61 Memory Controller",
             0x03EB: "MCP61 SMBus",
             0x03EC: "MCP61 IDE",
             0x03EE: "MCP61 Ethernet",
             0x03EF: "MCP61 Ethernet",
             0x03F0: "MCP61 High Definition Audio",
             0x03F1: "MCP61 USB 1.1 Controller",
             0x03F2: "MCP61 USB 2.0 Controller",
             0x03F3: "MCP61 PCI bridge",
             0x03F4: "MCP61 SMU",
             0x03F5: "MCP61 Memory Controller",
             0x03F6: "MCP61 SATA Controller",
             0x03F7: "MCP61 SATA Controller",
             0x0400: "G84 [GeForce 8600 GTS]",
             0x0401: "G84 [GeForce 8600 GT]",
             0x0402: "G84 [GeForce 8600 GT]",
             0x0403: "G84 [GeForce 8600 GS]",
             0x0404: "G84 [GeForce 8400 GS]",
             0x0405: "G84M [GeForce 9500M GS]",
             0x0406: "G84 [GeForce 8300 GS]",
             0x0407: "G84M [GeForce 8600M GT]",
             0x0408: "G84M [GeForce 9650M GS]",
             0x0409: "G84M [GeForce 8700M GT]",
             0x040A: "G84GL [Quadro FX 370]",
             0x040B: "G84GLM [Quadro NVS 320M]",
             0x040C: "G84GLM [Quadro FX 570M]",
             0x040D: "G84GLM [Quadro FX 1600M]",
             0x040E: "G84GL [Quadro FX 570]",
             0x040F: "G84GL [Quadro FX 1700]",
             0x0410: "G92 [GeForce GT 330]",
             0x0414: "G92 [GeForce 9800 GT]",
             0x0418: "G92 [GeForce GT 330 OEM]",
             0x0420: "G86 [GeForce 8400 SE]",
             0x0421: "G86 [GeForce 8500 GT]",
             0x0422: "G86 [GeForce 8400 GS]",
             0x0423: "G86 [GeForce 8300 GS]",
             0x0424: "G86 [GeForce 8400 GS]",
             0x0425: "G86M [GeForce 8600M GS]",
             0x0426: "G86M [GeForce 8400M GT]",
             0x0427: "G86M [GeForce 8400M GS]",
             0x0428: "G86M [GeForce 8400M G]",
             0x0429: "G86M [Quadro NVS 140M]",
             0x042A: "G86M [Quadro NVS 130M]",
             0x042B: "G86M [Quadro NVS 135M]",
             0x042C: "G86 [GeForce 9400 GT]",
             0x042D: "G86GLM [Quadro FX 360M]",
             0x042E: "G86M [GeForce 9300M G]",
             0x042F: "G86 [Quadro NVS 290]",
             0x0440: "MCP65 LPC Bridge",
             0x0441: "MCP65 LPC Bridge",
             0x0442: "MCP65 LPC Bridge",
             0x0443: "MCP65 LPC Bridge",
             0x0444: "MCP65 Memory Controller",
             0x0445: "MCP65 Memory Controller",
             0x0446: "MCP65 SMBus",
             0x0447: "MCP65 SMU",
             0x0448: "MCP65 IDE",
             0x0449: "MCP65 PCI bridge",
             0x044A: "MCP65 High Definition Audio",
             0x044B: "MCP65 High Definition Audio",
             0x044C: "MCP65 AHCI Controller",
             0x044D: "MCP65 AHCI Controller",
             0x044E: "MCP65 AHCI Controller",
             0x044F: "MCP65 AHCI Controller",
             0x0450: "MCP65 Ethernet",
             0x0451: "MCP65 Ethernet",
             0x0452: "MCP65 Ethernet",
             0x0453: "MCP65 Ethernet",
             0x0454: "MCP65 USB 1.1 OHCI Controller",
             0x0455: "MCP65 USB 2.0 EHCI Controller",
             0x0456: "MCP65 USB Controller",
             0x0457: "MCP65 USB Controller",
             0x0458: "MCP65 PCI Express bridge",
             0x0459: "MCP65 PCI Express bridge",
             0x045A: "MCP65 PCI Express bridge",
             0x045B: "MCP65 PCI Express bridge",
             0x045C: "MCP65 SATA Controller",
             0x045D: "MCP65 SATA Controller",
             0x045E: "MCP65 SATA Controller",
             0x045F: "MCP65 SATA Controller",
             0x0531: "C67 [GeForce 7150M / nForce 630M]",
             0x0533: "C67 [GeForce 7000M / nForce 610M]",
             0x053A: "C68 [GeForce 7050 PV / nForce 630a]",
             0x053B: "C68 [GeForce 7050 PV / nForce 630a]",
             0x053E: "C68 [GeForce 7025 / nForce 630a]",
             0x0541: "MCP67 Memory Controller",
             0x0542: "MCP67 SMBus",
             0x0543: "MCP67 Co-processor",
             0x0547: "MCP67 Memory Controller",
             0x0548: "MCP67 ISA Bridge",
             0x054C: "MCP67 Ethernet",
             0x054D: "MCP67 Ethernet",
             0x054E: "MCP67 Ethernet",
             0x054F: "MCP67 Ethernet",
             0x0550: "MCP67 AHCI Controller",
             0x0554: "MCP67 AHCI Controller",
             0x0555: "MCP67 SATA Controller",
             0x055C: "MCP67 High Definition Audio",
             0x055D: "MCP67 High Definition Audio",
             0x055E: "MCP67 OHCI USB 1.1 Controller",
             0x055F: "MCP67 EHCI USB 2.0 Controller",
             0x0560: "MCP67 IDE Controller",
             0x0561: "MCP67 PCI Bridge",
             0x0562: "MCP67 PCI Express Bridge",
             0x0563: "MCP67 PCI Express Bridge",
             0x0568: "MCP78S [GeForce 8200] Memory Controller",
             0x0569: "MCP78S [GeForce 8200] PCI Express Bridge",
             0x056A: "MCP73 [nForce 630i] USB 2.0 Controller (EHCI)",
             0x056C: "MCP73 IDE Controller",
             0x056D: "MCP73 PCI Express bridge",
             0x056E: "MCP73 PCI Express bridge",
             0x056F: "MCP73 PCI Express bridge",
             0x05B1: "NF200 PCIe 2.0 switch",
             0x05B8: "NF200 PCIe 2.0 switch for GTX 295",
             0x05BE: "NF200 PCIe 2.0 switch for Quadro Plex S4 / Tesla S870 / Tesla S1070 / Tesla S2050",
             0x05E0: "GT200b [GeForce GTX 295]",
             0x05E1: "GT200 [GeForce GTX 280]",
             0x05E2: "GT200 [GeForce GTX 260]",
             0x05E3: "GT200b [GeForce GTX 285]",
             0x05E6: "GT200b [GeForce GTX 275]",
             0x05E7: "GT200GL [Tesla C1060 / M1060]",
             0x05EA: "GT200 [GeForce GTX 260]",
             0x05EB: "GT200 [GeForce GTX 295]",
             0x05ED: "GT200GL [Quadro Plex 2200 D2]",
             0x05F1: "GT200 [GeForce GTX 280]",
             0x05F2: "GT200 [GeForce GTX 260]",
             0x05F8: "GT200GL [Quadro Plex 2200 S4]",
             0x05F9: "GT200GL [Quadro CX]",
             0x05FD: "GT200GL [Quadro FX 5800]",
             0x05FE: "GT200GL [Quadro FX 4800]",
             0x05FF: "GT200GL [Quadro FX 3800]",
             0x0600: "G92 [GeForce 8800 GTS 512]",
             0x0601: "G92 [GeForce 9800 GT]",
             0x0602: "G92 [GeForce 8800 GT]",
             0x0603: "G92 [GeForce GT 230 OEM]",
             0x0604: "G92 [GeForce 9800 GX2]",
             0x0605: "G92 [GeForce 9800 GT]",
             0x0606: "G92 [GeForce 8800 GS]",
             0x0607: "G92 [GeForce GTS 240]",
             0x0608: "G92M [GeForce 9800M GTX]",
             0x0609: "G92M [GeForce 8800M GTS]",
             0x060A: "G92M [GeForce GTX 280M]",
             0x060B: "G92M [GeForce 9800M GT]",
             0x060C: "G92M [GeForce 8800M GTX]",
             0x060D: "G92 [GeForce 8800 GS]",
             0x060F: "G92M [GeForce GTX 285M]",
             0x0610: "G92 [GeForce 9600 GSO]",
             0x0611: "G92 [GeForce 8800 GT]",
             0x0612: "G92 [GeForce 9800 GTX / 9800 GTX+]",
             0x0613: "G92 [GeForce 9800 GTX+]",
             0x0614: "G92 [GeForce 9800 GT]",
             0x0615: "G92 [GeForce GTS 250]",
             0x0617: "G92M [GeForce 9800M GTX]",
             0x0618: "G92M [GeForce GTX 260M]",
             0x0619: "G92GL [Quadro FX 4700 X2]",
             0x061A: "G92GL [Quadro FX 3700]",
             0x061B: "G92GL [Quadro VX 200]",
             0x061C: "G92GLM [Quadro FX 3600M]",
             0x061D: "G92GLM [Quadro FX 2800M]",
             0x061E: "G92GLM [Quadro FX 3700M]",
             0x061F: "G92GLM [Quadro FX 3800M]",
             0x0620: "G94 [GeForce 9800 GT]",
             0x0621: "G94 [GeForce GT 230]",
             0x0622: "G94 [GeForce 9600 GT]",
             0x0623: "G94 [GeForce 9600 GS]",
             0x0624: "G94 [GeForce 9600 GT Green Edition]",
             0x0625: "G94 [GeForce 9600 GSO 512]",
             0x0626: "G94 [GeForce GT 130]",
             0x0627: "G94 [GeForce GT 140]",
             0x0628: "G94M [GeForce 9800M GTS]",
             0x062A: "G94M [GeForce 9700M GTS]",
             0x062B: "G94M [GeForce 9800M GS]",
             0x062C: "G94M [GeForce 9800M GTS]",
             0x062D: "G94 [GeForce 9600 GT]",
             0x062E: "G94 [GeForce 9600 GT]",
             0x062F: "G94 [GeForce 9800 S]",
             0x0630: "G94 [GeForce 9600 GT]",
             0x0631: "G94M [GeForce GTS 160M]",
             0x0632: "G94M [GeForce GTS 150M]",
             0x0633: "G94 [GeForce GT 220]",
             0x0635: "G94 [GeForce 9600 GSO]",
             0x0637: "G94 [GeForce 9600 GT]",
             0x0638: "G94GL [Quadro FX 1800]",
             0x063A: "G94GLM [Quadro FX 2700M]",
             0x063F: "G94 [GeForce 9600 GE]",
             0x0640: "G96C [GeForce 9500 GT]",
             0x0641: "G96C [GeForce 9400 GT]",
             0x0642: "G96 [D9M-10]",
             0x0643: "G96 [GeForce 9500 GT]",
             0x0644: "G96 [GeForce 9500 GS]",
             0x0645: "G96C [GeForce 9500 GS]",
             0x0646: "G96C [GeForce GT 120]",
             0x0647: "G96CM [GeForce 9600M GT]",
             0x0648: "G96CM [GeForce 9600M GS]",
             0x0649: "G96CM [GeForce 9600M GT]",
             0x064A: "G96M [GeForce 9700M GT]",
             0x064B: "G96M [GeForce 9500M G]",
             0x064C: "G96CM [GeForce 9650M GT]",
             0x064E: "G96C [GeForce 9600 GSO / 9800 GT]",
             0x0651: "G96CM [GeForce G 110M]",
             0x0652: "G96CM [GeForce GT 130M]",
             0x0653: "G96CM [GeForce GT 120M]",
             0x0654: "G96CM [GeForce GT 220M]",
             0x0655: "G96 [GeForce GT 120 Mac Edition]",
             0x0656: "G96 [GeForce GT 120 Mac Edition]",
             0x0658: "G96GL [Quadro FX 380]",
             0x0659: "G96CGL [Quadro FX 580]",
             0x065A: "G96GLM [Quadro FX 1700M]",
             0x065B: "G96C [GeForce 9400 GT]",
             0x065C: "G96GLM [Quadro FX 770M]",
             0x065D: "G96 [GeForce 9500 GA / 9600 GT / GTS 250]",
             0x065F: "G96C [GeForce G210]",
             0x06C0: "GF100 [GeForce GTX 480]",
             0x06C4: "GF100 [GeForce GTX 465]",
             0x06CA: "GF100M [GeForce GTX 480M]",
             0x06CB: "GF100 [GeForce GTX 480]",
             0x06CD: "GF100 [GeForce GTX 470]",
             0x06D0: "GF100GL",
             0x06D1: "GF100GL [Tesla C2050 / C2070]",
             0x06D2: "GF100GL [Tesla M2070]",
             0x06D8: "GF100GL [Quadro 6000]",
             0x06D9: "GF100GL [Quadro 5000]",
             0x06DA: "GF100GLM [Quadro 5000M]",
             0x06DC: "GF100GL [Quadro 6000]",
             0x06DD: "GF100GL [Quadro 4000]",
             0x06DE: "GF100GL [Tesla T20 Processor]",
             0x06DF: "GF100GL [Tesla M2070-Q]",
             0x06E0: "G98 [GeForce 9300 GE]",
             0x06E1: "G98 [GeForce 9300 GS]",
             0x06E2: "G98 [GeForce 8400]",
             0x06E3: "G98 [GeForce 8300 GS]",
             0x06E4: "G98 [GeForce 8400 GS Rev. 2]",
             0x06E5: "G98M [GeForce 9300M GS]",
             0x06E6: "G98 [GeForce G 100]",
             0x06E7: "G98 [GeForce 9300 SE]",
             0x06E8: "G98M [GeForce 9200M GS]",
             0x06E9: "G98M [GeForce 9300M GS]",
             0x06EA: "G98M [Quadro NVS 150M]",
             0x06EB: "G98M [Quadro NVS 160M]",
             0x06EC: "G98M [GeForce G 105M]",
             0x06ED: "G98 [GeForce 9600 GT / 9800 GT]",
             0x06EE: "G98 [GeForce 9600 GT / 9800 GT / GT 240]",
             0x06EF: "G98M [GeForce G 103M]",
             0x06F1: "G98M [GeForce G 105M]",
             0x06F8: "G98 [Quadro NVS 420]",
             0x06F9: "G98GL [Quadro FX 370 LP]",
             0x06FA: "G98 [Quadro NVS 450]",
             0x06FB: "G98GLM [Quadro FX 370M]",
             0x06FD: "G98 [Quadro NVS 295]",
             0x06FF: "G98 [HICx16 + Graphics]",
             0x0751: "MCP78S [GeForce 8200] Memory Controller",
             0x0752: "MCP78S [GeForce 8200] SMBus",
             0x0753: "MCP78S [GeForce 8200] Co-Processor",
             0x0754: "MCP78S [GeForce 8200] Memory Controller",
             0x0759: "MCP78S [GeForce 8200] IDE",
             0x075A: "MCP78S [GeForce 8200] PCI Bridge",
             0x075B: "MCP78S [GeForce 8200] PCI Express Bridge",
             0x075C: "MCP78S [GeForce 8200] LPC Bridge",
             0x075D: "MCP78S [GeForce 8200] LPC Bridge",
             0x0760: "MCP77 Ethernet",
             0x0761: "MCP77 Ethernet",
             0x0762: "MCP77 Ethernet",
             0x0763: "MCP77 Ethernet",
             0x0774: "MCP72XE/MCP72P/MCP78U/MCP78S High Definition Audio",
             0x0778: "MCP78S [GeForce 8200] PCI Express Bridge",
             0x077A: "MCP78S [GeForce 8200] PCI Bridge",
             0x077B: "MCP78S [GeForce 8200] OHCI USB 1.1 Controller",
             0x077C: "MCP78S [GeForce 8200] EHCI USB 2.0 Controller",
             0x077D: "MCP78S [GeForce 8200] OHCI USB 1.1 Controller",
             0x077E: "MCP78S [GeForce 8200] EHCI USB 2.0 Controller",
             0x07C0: "MCP73 Host Bridge",
             0x07C1: "MCP73 Host Bridge",
             0x07C2: "MCP73 Host Bridge",
             0x07C3: "MCP73 Host Bridge",
             0x07C5: "MCP73 Host Bridge",
             0x07C8: "MCP73 Memory Controller",
             0x07CB: "nForce 610i/630i memory controller",
             0x07CD: "nForce 610i/630i memory controller",
             0x07CE: "nForce 610i/630i memory controller",
             0x07CF: "nForce 610i/630i memory controller",
             0x07D0: "nForce 610i/630i memory controller",
             0x07D1: "nForce 610i/630i memory controller",
             0x07D2: "nForce 610i/630i memory controller",
             0x07D3: "nForce 610i/630i memory controller",
             0x07D6: "nForce 610i/630i memory controller",
             0x07D7: "MCP73 LPC Bridge",
             0x07D8: "MCP73 SMBus",
             0x07D9: "MCP73 Memory Controller",
             0x07DA: "MCP73 Co-processor",
             0x07DC: "MCP73 Ethernet",
             0x07DD: "MCP73 Ethernet",
             0x07DE: "MCP73 Ethernet",
             0x07DF: "MCP73 Ethernet",
             0x07E0: "C73 [GeForce 7150 / nForce 630i]",
             0x07E1: "C73 [GeForce 7100 / nForce 630i]",
             0x07E2: "C73 [GeForce 7050 / nForce 630i]",
             0x07E3: "C73 [GeForce 7050 / nForce 610i]",
             0x07E5: "C73 [GeForce 7100 / nForce 620i]",
             0x07F0: "MCP73 SATA Controller (IDE mode)",
             0x07F4: "GeForce 7100/nForce 630i SATA",
             0x07F8: "MCP73 SATA RAID Controller",
             0x07FC: "MCP73 High Definition Audio",
             0x07FE: "MCP73 OHCI USB 1.1 Controller",
             0x0840: "C77 [GeForce 8200M]",
             0x0844: "C77 [GeForce 9100M G]",
             0x0845: "C77 [GeForce 8200M G]",
             0x0846: "C77 [GeForce 9200]",
             0x0847: "C78 [GeForce 9100]",
             0x0848: "C77 [GeForce 8300]",
             0x0849: "C77 [GeForce 8200]",
             0x084A: "C77 [nForce 730a]",
             0x084B: "C77 [GeForce 8200]",
             0x084C: "C77 [nForce 780a/980a SLI]",
             0x084D: "C77 [nForce 750a SLI]",
             0x084F: "C77 [GeForce 8100 / nForce 720a]",
             0x0860: "C79 [GeForce 9300]",
             0x0861: "C79 [GeForce 9400]",
             0x0862: "C79 [GeForce 9400M G]",
             0x0863: "C79 [GeForce 9400M]",
             0x0864: "C79 [GeForce 9300]",
             0x0865: "C79 [GeForce 9300 / ION]",
             0x0866: "C79 [GeForce 9400M G]",
             0x0867: "C79 [GeForce 9400]",
             0x0868: "C79 [nForce 760i SLI]",
             0x0869: "MCP7A [GeForce 9400]",
             0x086A: "C79 [GeForce 9400]",
             0x086C: "C79 [GeForce 9300 / nForce 730i]",
             0x086D: "C79 [GeForce 9200]",
             0x086E: "C79 [GeForce 9100M G]",
             0x086F: "MCP79 [GeForce 8200M G]",
             0x0870: "C79 [GeForce 9400M]",
             0x0871: "C79 [GeForce 9200]",
             0x0872: "C79 [GeForce G102M]",
             0x0873: "C79 [GeForce G102M]",
             0x0874: "C79 [ION]",
             0x0876: "C79 [GeForce 9400M / ION]",
             0x087A: "C79 [GeForce 9400]",
             0x087D: "C79 [ION]",
             0x087E: "C79 [ION LE]",
             0x087F: "C79 [ION LE]",
             0x08A0: "MCP89 [GeForce 320M]",
             0x08A2: "MCP89 [GeForce 320M]",
             0x08A3: "MCP89 [GeForce 320M]",
             0x08A4: "MCP89 [GeForce 320M]",
             0x08A5: "MCP89 [GeForce 320M]",
             0x0A20: "GT216 [GeForce GT 220]",
             0x0A21: "GT216M [GeForce GT 330M]",
             0x0A22: "GT216 [GeForce 315]",
             0x0A23: "GT216 [GeForce 210]",
             0x0A24: "GT216 [GeForce 405]",
             0x0A26: "GT216 [GeForce 405]",
             0x0A27: "GT216 [GeForce 405]",
             0x0A28: "GT216M [GeForce GT 230M]",
             0x0A29: "GT216M [GeForce GT 330M]",
             0x0A2A: "GT216M [GeForce GT 230M]",
             0x0A2B: "GT216M [GeForce GT 330M]",
             0x0A2C: "GT216M [NVS 5100M]",
             0x0A2D: "GT216M [GeForce GT 320M]",
             0x0A30: "GT216 [GeForce 505]",
             0x0A32: "GT216 [GeForce GT 415]",
             0x0A34: "GT216M [GeForce GT 240M]",
             0x0A35: "GT216M [GeForce GT 325M]",
             0x0A38: "GT216GL [Quadro 400]",
             0x0A3C: "GT216GLM [Quadro FX 880M]",
             0x0A60: "GT218 [GeForce G210]",
             0x0A62: "GT218 [GeForce 205]",
             0x0A63: "GT218 [GeForce 310]",
             0x0A64: "GT218 [ION]",
             0x0A65: "GT218 [GeForce 210]",
             0x0A66: "GT218 [GeForce 310]",
             0x0A67: "GT218 [GeForce 315]",
             0x0A68: "GT218M [GeForce G 105M]",
             0x0A69: "GT218M [GeForce G 105M]",
             0x0A6A: "GT218M [NVS 2100M]",
             0x0A6C: "GT218M [NVS 3100M]",
             0x0A6E: "GT218M [GeForce 305M]",
             0x0A6F: "GT218M [ION]",
             0x0A70: "GT218M [GeForce 310M]",
             0x0A71: "GT218M [GeForce 305M]",
             0x0A72: "GT218M [GeForce 310M]",
             0x0A73: "GT218M [GeForce 305M]",
             0x0A74: "GT218M [GeForce G210M]",
             0x0A75: "GT218M [GeForce 310M]",
             0x0A76: "GT218M [ION 2]",
             0x0A78: "GT218GL [Quadro FX 380 LP]",
             0x0A7A: "GT218M [GeForce 315M]",
             0x0A7B: "GT218 [GeForce 505]",
             0x0A7C: "GT218GLM [Quadro FX 380M]",
             0x0A80: "MCP79 Host Bridge",
             0x0A81: "MCP79 Host Bridge",
             0x0A82: "MCP79 Host Bridge",
             0x0A83: "MCP79 Host Bridge",
             0x0A84: "MCP79 Host Bridge",
             0x0A85: "MCP79 Host Bridge",
             0x0A86: "MCP79 Host Bridge",
             0x0A87: "MCP79 Host Bridge",
             0x0A88: "MCP79 Memory Controller",
             0x0A89: "MCP79 Memory Controller",
             0x0A98: "MCP79 Memory Controller",
             0x0AA0: "MCP79 PCI Express Bridge",
             0x0AA2: "MCP79 SMBus",
             0x0AA3: "MCP79 Co-processor",
             0x0AA4: "MCP79 Memory Controller",
             0x0AA5: "MCP79 OHCI USB 1.1 Controller",
             0x0AA6: "MCP79 EHCI USB 2.0 Controller",
             0x0AA7: "MCP79 OHCI USB 1.1 Controller",
             0x0AA8: "MCP79 OHCI USB 1.1 Controller",
             0x0AA9: "MCP79 EHCI USB 2.0 Controller",
             0x0AAA: "MCP79 EHCI USB 2.0 Controller",
             0x0AAB: "MCP79 PCI Bridge",
             0x0AAC: "MCP79 LPC Bridge",
             0x0AAD: "MCP79 LPC Bridge",
             0x0AAE: "MCP79 LPC Bridge",
             0x0AAF: "MCP79 LPC Bridge",
             0x0AB0: "MCP79 Ethernet",
             0x0AB1: "MCP79 Ethernet",
             0x0AB2: "MCP79 Ethernet",
             0x0AB3: "MCP79 Ethernet",
             0x0AB4: "MCP79 SATA Controller",
             0x0AB5: "MCP79 SATA Controller",
             0x0AB6: "MCP79 SATA Controller",
             0x0AB7: "MCP79 SATA Controller",
             0x0AB8: "MCP79 AHCI Controller",
             0x0AB9: "MCP79 AHCI Controller",
             0x0ABA: "MCP79 AHCI Controller",
             0x0ABB: "MCP79 AHCI Controller",
             0x0ABC: "MCP79 RAID Controller",
             0x0ABD: "MCP79 RAID Controller",
             0x0ABE: "MCP79 RAID Controller",
             0x0ABF: "MCP79 RAID Controller",
             0x0AC0: "MCP79 High Definition Audio",
             0x0AC1: "MCP79 High Definition Audio",
             0x0AC2: "MCP79 High Definition Audio",
             0x0AC3: "MCP79 High Definition Audio",
             0x0AC4: "MCP79 PCI Express Bridge",
             0x0AC5: "MCP79 PCI Express Bridge",
             0x0AC6: "MCP79 PCI Express Bridge",
             0x0AC7: "MCP79 PCI Express Bridge",
             0x0AC8: "MCP79 PCI Express Bridge",
             0x0AD0: "MCP78S [GeForce 8200] SATA Controller (non-AHCI mode)",
             0x0AD4: "MCP78S [GeForce 8200] AHCI Controller",
             0x0AD8: "MCP78S [GeForce 8200] SATA Controller (RAID mode)",
             0x0BE2: "GT216 HDMI Audio Controller",
             0x0BE3: "High Definition Audio Controller",
             0x0BE4: "High Definition Audio Controller",
             0x0BE5: "GF100 High Definition Audio Controller",
             0x0BE9: "GF106 High Definition Audio Controller",
             0x0BEA: "GF108 High Definition Audio Controller",
             0x0BEB: "GF104 High Definition Audio Controller",
             0x0BEE: "GF116 High Definition Audio Controller",
             0x0BF0: "Tegra2 PCIe x4 Bridge",
             0x0BF1: "Tegra2 PCIe x2 Bridge",
             0x0CA0: "GT215 [GeForce GT 330]",
             0x0CA2: "GT215 [GeForce GT 320]",
             0x0CA3: "GT215 [GeForce GT 240]",
             0x0CA4: "GT215 [GeForce GT 340]",
             0x0CA5: "GT215 [GeForce GT 220]",
             0x0CA7: "GT215 [GeForce GT 330]",
             0x0CA8: "GT215M [GeForce GTS 260M]",
             0x0CA9: "GT215M [GeForce GTS 250M]",
             0x0CAC: "GT215 [GeForce GT 220/315]",
             0x0CAF: "GT215M [GeForce GT 335M]",
             0x0CB0: "GT215M [GeForce GTS 350M]",
             0x0CB1: "GT215M [GeForce GTS 360M]",
             0x0CBC: "GT215GLM [Quadro FX 1800M]",
             0x0D60: "MCP89 HOST Bridge",
             0x0D68: "MCP89 Memory Controller",
             0x0D69: "MCP89 Memory Controller",
             0x0D76: "MCP89 PCI Express Bridge",
             0x0D79: "MCP89 SMBus",
             0x0D7A: "MCP89 Co-Processor",
             0x0D7B: "MCP89 Memory Controller",
             0x0D7D: "MCP89 Ethernet",
             0x0D80: "MCP89 LPC Bridge",
             0x0D85: "MCP89 SATA Controller",
             0x0D88: "MCP89 SATA Controller (AHCI mode)",
             0x0D89: "MCP89 SATA Controller (AHCI mode)",
             0x0D8D: "MCP89 SATA Controller (RAID mode)",
             0x0D94: "MCP89 High Definition Audio",
             0x0D9C: "MCP89 OHCI USB 1.1 Controller",
             0x0D9D: "MCP89 EHCI USB 2.0 Controller",
             0x0DC0: "GF106 [GeForce GT 440]",
             0x0DC4: "GF106 [GeForce GTS 450]",
             0x0DC5: "GF106 [GeForce GTS 450 OEM]",
             0x0DC6: "GF106 [GeForce GTS 450 OEM]",
             0x0DCD: "GF106M [GeForce GT 555M]",
             0x0DCE: "GF106M [GeForce GT 555M]",
             0x0DD1: "GF106M [GeForce GTX 460M]",
             0x0DD2: "GF106M [GeForce GT 445M]",
             0x0DD3: "GF106M [GeForce GT 435M]",
             0x0DD6: "GF106M [GeForce GT 550M]",
             0x0DD8: "GF106GL [Quadro 2000]",
             0x0DDA: "GF106GLM [Quadro 2000M]",
             0x0DE0: "GF108 [GeForce GT 440]",
             0x0DE1: "GF108 [GeForce GT 430]",
             0x0DE2: "GF108 [GeForce GT 420]",
             0x0DE3: "GF108M [GeForce GT 635M]",
             0x0DE4: "GF108 [GeForce GT 520]",
             0x0DE5: "GF108 [GeForce GT 530]",
             0x0DE7: "GF108 [GeForce GT 610]",
             0x0DE8: "GF108M [GeForce GT 620M]",
             0x0DE9: "GF108M [GeForce GT 620M/630M/635M/640M LE]",
             0x0DEA: "GF108M [GeForce 610M]",
             0x0DEB: "GF108M [GeForce GT 555M]",
             0x0DEC: "GF108M [GeForce GT 525M]",
             0x0DED: "GF108M [GeForce GT 520M]",
             0x0DEE: "GF108M [GeForce GT 415M]",
             0x0DEF: "GF108M [NVS 5400M]",
             0x0DF0: "GF108M [GeForce GT 425M]",
             0x0DF1: "GF108M [GeForce GT 420M]",
             0x0DF2: "GF108M [GeForce GT 435M]",
             0x0DF3: "GF108M [GeForce GT 420M]",
             0x0DF4: "GF108M [GeForce GT 540M]",
             0x0DF5: "GF108M [GeForce GT 525M]",
             0x0DF6: "GF108M [GeForce GT 550M]",
             0x0DF7: "GF108M [GeForce GT 520M]",
             0x0DF8: "GF108GL [Quadro 600]",
             0x0DF9: "GF108GLM [Quadro 500M]",
             0x0DFA: "GF108GLM [Quadro 1000M]",
             0x0DFC: "GF108GLM [NVS 5200M]",
             0x0E08: "GF119 HDMI Audio Controller",
             0x0E09: "GF110 High Definition Audio Controller",
             0x0E0A: "GK104 HDMI Audio Controller",
             0x0E0B: "GK106 HDMI Audio Controller",
             0x0E0C: "GF114 HDMI Audio Controller",
             0x0E0F: "GK208 HDMI/DP Audio Controller",
             0x0E12: "TegraK1 PCIe x4 Bridge",
             0x0E13: "TegraK1 PCIe x1 Bridge",
             0x0E1A: "GK110 High Definition Audio Controller",
             0x0E1B: "GK107 HDMI Audio Controller",
             0x0E1C: "Tegra3+ PCIe x4 Bridge",
             0x0E1D: "Tegra3+ PCIe x2 Bridge",
             0x0E22: "GF104 [GeForce GTX 460]",
             0x0E23: "GF104 [GeForce GTX 460 SE]",
             0x0E24: "GF104 [GeForce GTX 460 OEM]",
             0x0E30: "GF104M [GeForce GTX 470M]",
             0x0E31: "GF104M [GeForce GTX 485M]",
             0x0E3A: "GF104GLM [Quadro 3000M]",
             0x0E3B: "GF104GLM [Quadro 4000M]",
             0x0F00: "GF108 [GeForce GT 630]",
             0x0F01: "GF108 [GeForce GT 620]",
             0x0F02: "GF108 [GeForce GT 730]",
             0x0F03: "GF108 [GeForce GT 610]",
             0x0F06: "GF108 [GeForce GT 730]",
             0x0FB0: "GM200 High Definition Audio",
             0x0FB8: "GP108 High Definition Audio Controller",
             0x0FB9: "GP107GL High Definition Audio Controller",
             0x0FBA: "GM206 High Definition Audio Controller",
             0x0FBB: "GM204 High Definition Audio Controller",
             0x0FBC: "GM107 High Definition Audio Controller [GeForce 940MX]",
             0x0FC0: "GK107 [GeForce GT 640 OEM]",
             0x0FC1: "GK107 [GeForce GT 640]",
             0x0FC2: "GK107 [GeForce GT 630 OEM]",
             0x0FC5: "GK107 [GeForce GT 1030]",
             0x0FC6: "GK107 [GeForce GTX 650]",
             0x0FC8: "GK107 [GeForce GT 740]",
             0x0FC9: "GK107 [GeForce GT 730]",
             0x0FCD: "GK107M [GeForce GT 755M]",
             0x0FCE: "GK107M [GeForce GT 640M LE]",
             0x0FD1: "GK107M [GeForce GT 650M]",
             0x0FD2: "GK107M [GeForce GT 640M]",
             0x0FD3: "GK107M [GeForce GT 640M LE]",
             0x0FD4: "GK107M [GeForce GTX 660M]",
             0x0FD5: "GK107M [GeForce GT 650M Mac Edition]",
             0x0FD6: "GK107M",
             0x0FD8: "GK107M [GeForce GT 640M Mac Edition]",
             0x0FD9: "GK107M [GeForce GT 645M]",
             0x0FDB: "GK107M",
             0x0FDF: "GK107M [GeForce GT 740M]",
             0x0FE0: "GK107M [GeForce GTX 660M Mac Edition]",
             0x0FE1: "GK107M [GeForce GT 730M]",
             0x0FE2: "GK107M [GeForce GT 745M]",
             0x0FE3: "GK107M [GeForce GT 745M]",
             0x0FE4: "GK107M [GeForce GT 750M]",
             0x0FE5: "GK107 [GeForce K340 USM]",
             0x0FE6: "GK107 [GRID K1 NVS USM]",
             0x0FE7: "GK107GL [GRID K100 vGPU]",
             0x0FE8: "GK107M [N14P-GS]",
             0x0FE9: "GK107M [GeForce GT 750M Mac Edition]",
             0x0FEA: "GK107M [GeForce GT 755M Mac Edition]",
             0x0FEC: "GK107M [GeForce 710A]",
             0x0FED: "GK107M [GeForce 820M]",
             0x0FEE: "GK107M [GeForce 810M]",
             0x0FEF: "GK107GL [GRID K340]",
             0x0FF1: "GK107 [NVS 1000]",
             0x0FF2: "GK107GL [GRID K1]",
             0x0FF3: "GK107GL [Quadro K420]",
             0x0FF5: "GK107GL [GRID K1 Tesla USM]",
             0x0FF6: "GK107GLM [Quadro K1100M]",
             0x0FF7: "GK107GL [GRID K140Q vGPU]",
             0x0FF8: "GK107GLM [Quadro K500M]",
             0x0FF9: "GK107GL [Quadro K2000D]",
             0x0FFA: "GK107GL [Quadro K600]",
             0x0FFB: "GK107GLM [Quadro K2000M]",
             0x0FFC: "GK107GLM [Quadro K1000M]",
             0x0FFD: "GK107 [NVS 510]",
             0x0FFE: "GK107GL [Quadro K2000]",
             0x0FFF: "GK107GL [Quadro 410]",
             0x1001: "GK110B [GeForce GTX TITAN Z]",
             0x1003: "GK110 [GeForce GTX Titan LE]",
             0x1004: "GK110 [GeForce GTX 780]",
             0x1005: "GK110 [GeForce GTX TITAN]",
             0x1007: "GK110 [GeForce GTX 780 Rev. 2]",
             0x1008: "GK110 [GeForce GTX 780 Ti 6GB]",
             0x100A: "GK110B [GeForce GTX 780 Ti]",
             0x100C: "GK110B [GeForce GTX TITAN Black]",
             0x101E: "GK110GL [Tesla K20X]",
             0x101F: "GK110GL [Tesla K20]",
             0x1020: "GK110GL [Tesla K20X]",
             0x1021: "GK110GL [Tesla K20Xm]",
             0x1022: "GK110GL [Tesla K20c]",
             0x1023: "GK110BGL [Tesla K40m]",
             0x1024: "GK180GL [Tesla K40c]",
             0x1026: "GK110GL [Tesla K20s]",
             0x1027: "GK110BGL [Tesla K40st]",
             0x1028: "GK110GL [Tesla K20m]",
             0x1029: "GK110BGL [Tesla K40s]",
             0x102A: "GK110BGL [Tesla K40t]",
             0x102D: "GK210GL [Tesla K80]",
             0x102E: "GK110BGL [Tesla K40d]",
             0x102F: "GK110BGL [Tesla Stella Solo]",
             0x103A: "GK110GL [Quadro K6000]",
             0x103C: "GK110GL [Quadro K5200]",
             0x103F: "GK110BGL [Tesla Stella SXM]",
             0x1040: "GF119 [GeForce GT 520]",
             0x1042: "GF119 [GeForce 510]",
             0x1045: "GF119",
             0x1048: "GF119 [GeForce 605]",
             0x1049: "GF119 [GeForce GT 620 OEM]",
             0x104A: "GF119 [GeForce GT 610]",
             0x104B: "GF119 [GeForce GT 625 OEM]",
             0x104C: "GF119 [GeForce GT 705]",
             0x104D: "GF119 [GeForce GT 710]",
             0x1050: "GF119M [GeForce GT 520M]",
             0x1051: "GF119M [GeForce GT 520MX]",
             0x1052: "GF119M [GeForce GT 520M]",
             0x1054: "GF119M [GeForce 410M]",
             0x1055: "GF119M [GeForce 410M]",
             0x1056: "GF119M [NVS 4200M]",
             0x1057: "GF119M [Quadro NVS 4200M]",
             0x1058: "GF119M [GeForce 610M]",
             0x1059: "GF119M [GeForce 610M]",
             0x105A: "GF119M [GeForce 610M]",
             0x105B: "GF119M [GeForce 705M]",
             0x107C: "GF119 [NVS 315]",
             0x107D: "GF119 [NVS 310]",
             0x1080: "GF110 [GeForce GTX 580]",
             0x1081: "GF110 [GeForce GTX 570]",
             0x1082: "GF110 [GeForce GTX 560 Ti OEM]",
             0x1084: "GF110 [GeForce GTX 560 OEM]",
             0x1086: "GF110 [GeForce GTX 570 Rev. 2]",
             0x1087: "GF110 [GeForce GTX 560 Ti 448 Cores]",
             0x1088: "GF110 [GeForce GTX 590]",
             0x1089: "GF110 [GeForce GTX 580 Rev. 2]",
             0x108B: "GF110 [GeForce GTX 580]",
             0x108E: "GF110GL [Tesla C2090]",
             0x1091: "GF110GL [Tesla M2090]",
             0x1094: "GF110GL [Tesla M2075]",
             0x1096: "GF110GL [Tesla C2050 / C2075]",
             0x109A: "GF100GLM [Quadro 5010M]",
             0x109B: "GF100GL [Quadro 7000]",
             0x10C0: "GT218 [GeForce 9300 GS Rev. 2]",
             0x10C3: "GT218 [GeForce 8400 GS Rev. 3]",
             0x10C5: "GT218 [GeForce 405]",
             0x10D8: "GT218 [NVS 300]",
             0x10EF: "GP102 HDMI Audio Controller",
             0x10F0: "GP104 High Definition Audio Controller",
             0x10F1: "GP106 High Definition Audio Controller",
             0x10F7: "TU102 High Definition Audio Controller",
             0x10F8: "TU104 HD Audio Controller",
             0x10F9: "TU106 High Definition Audio Controller",
             0x1140: "GF117M [GeForce 610M/710M/810M/820M / GT 620M/625M/630M/720M]",
             0x1180: "GK104 [GeForce GTX 680]",
             0x1182: "GK104 [GeForce GTX 760 Ti]",
             0x1183: "GK104 [GeForce GTX 660 Ti]",
             0x1184: "GK104 [GeForce GTX 770]",
             0x1185: "GK104 [GeForce GTX 660 OEM]",
             0x1186: "GK104 [GeForce GTX 660 Ti]",
             0x1187: "GK104 [GeForce GTX 760]",
             0x1188: "GK104 [GeForce GTX 690]",
             0x1189: "GK104 [GeForce GTX 670]",
             0x118A: "GK104GL [GRID K520]",
             0x118B: "GK104GL [GRID K2 GeForce USM]",
             0x118C: "GK104 [GRID K2 NVS USM]",
             0x118D: "GK104GL [GRID K200 vGPU]",
             0x118E: "GK104 [GeForce GTX 760 OEM]",
             0x118F: "GK104GL [Tesla K10]",
             0x1191: "GK104 [GeForce GTX 760 Rev. 2]",
             0x1193: "GK104 [GeForce GTX 760 Ti OEM]",
             0x1194: "GK104GL [Tesla K8]",
             0x1195: "GK104 [GeForce GTX 660 Rev. 2]",
             0x1198: "GK104M [GeForce GTX 880M]",
             0x1199: "GK104M [GeForce GTX 870M]",
             0x119A: "GK104M [GeForce GTX 860M]",
             0x119D: "GK104M [GeForce GTX 775M Mac Edition]",
             0x119E: "GK104M [GeForce GTX 780M Mac Edition]",
             0x119F: "GK104M [GeForce GTX 780M]",
             0x11A0: "GK104M [GeForce GTX 680M]",
             0x11A1: "GK104M [GeForce GTX 670MX]",
             0x11A2: "GK104M [GeForce GTX 675MX Mac Edition]",
             0x11A3: "GK104M [GeForce GTX 680MX]",
             0x11A7: "GK104M [GeForce GTX 675MX]",
             0x11A8: "GK104GLM [Quadro K5100M]",
             0x11A9: "GK104M [GeForce GTX 870M]",
             0x11AF: "GK104GLM [GRID IceCube]",
             0x11B0: "GK104GL [GRID K240Q / K260Q vGPU]",
             0x11B1: "GK104GL [GRID K2 Tesla USM]",
             0x11B4: "GK104GL [Quadro K4200]",
             0x11B6: "GK104GLM [Quadro K3100M]",
             0x11B7: "GK104GLM [Quadro K4100M]",
             0x11B8: "GK104GLM [Quadro K5100M]",
             0x11B9: "GK104GLM",
             0x11BA: "GK104GL [Quadro K5000]",
             0x11BB: "GK104GL [Quadro 4100]",
             0x11BC: "GK104GLM [Quadro K5000M]",
             0x11BD: "GK104GLM [Quadro K4000M]",
             0x11BE: "GK104GLM [Quadro K3000M]",
             0x11BF: "GK104GL [GRID K2]",
             0x11C0: "GK106 [GeForce GTX 660]",
             0x11C2: "GK106 [GeForce GTX 650 Ti Boost]",
             0x11C3: "GK106 [GeForce GTX 650 Ti OEM]",
             0x11C4: "GK106 [GeForce GTX 645 OEM]",
             0x11C5: "GK106 [GeForce GT 740]",
             0x11C6: "GK106 [GeForce GTX 650 Ti]",
             0x11C7: "GK106 [GeForce GTX 750 Ti]",
             0x11C8: "GK106 [GeForce GTX 650 OEM]",
             0x11CB: "GK106 [GeForce GT 740]",
             0x11E0: "GK106M [GeForce GTX 770M]",
             0x11E1: "GK106M [GeForce GTX 765M]",
             0x11E2: "GK106M [GeForce GTX 765M]",
             0x11E3: "GK106M [GeForce GTX 760M]",
             0x11E7: "GK106M",
             0x11FA: "GK106GL [Quadro K4000]",
             0x11FC: "GK106GLM [Quadro K2100M]",
             0x1200: "GF114 [GeForce GTX 560 Ti]",
             0x1201: "GF114 [GeForce GTX 560]",
             0x1202: "GF114 [GeForce GTX 560 Ti OEM]",
             0x1203: "GF114 [GeForce GTX 460 SE v2]",
             0x1205: "GF114 [GeForce GTX 460 v2]",
             0x1206: "GF114 [GeForce GTX 555]",
             0x1207: "GF114 [GeForce GT 645 OEM]",
             0x1208: "GF114 [GeForce GTX 560 SE]",
             0x1210: "GF114M [GeForce GTX 570M]",
             0x1211: "GF114M [GeForce GTX 580M]",
             0x1212: "GF114M [GeForce GTX 675M]",
             0x1213: "GF114M [GeForce GTX 670M]",
             0x1241: "GF116 [GeForce GT 545 OEM]",
             0x1243: "GF116 [GeForce GT 545]",
             0x1244: "GF116 [GeForce GTX 550 Ti]",
             0x1245: "GF116 [GeForce GTS 450 Rev. 2]",
             0x1246: "GF116M [GeForce GT 550M]",
             0x1247: "GF116M [GeForce GT 555M/635M]",
             0x1248: "GF116M [GeForce GT 555M/635M]",
             0x1249: "GF116 [GeForce GTS 450 Rev. 3]",
             0x124B: "GF116 [GeForce GT 640 OEM]",
             0x124D: "GF116M [GeForce GT 555M/635M]",
             0x1251: "GF116M [GeForce GT 560M]",
             0x1280: "GK208 [GeForce GT 635]",
             0x1281: "GK208 [GeForce GT 710]",
             0x1282: "GK208 [GeForce GT 640 Rev. 2]",
             0x1284: "GK208 [GeForce GT 630 Rev. 2]",
             0x1286: "GK208 [GeForce GT 720]",
             0x1287: "GK208B [GeForce GT 730]",
             0x1288: "GK208B [GeForce GT 720]",
             0x1289: "GK208 [GeForce GT 710]",
             0x128A: "GK208B",
             0x128B: "GK208B [GeForce GT 710]",
             0x128C: "GK208B",
             0x1290: "GK208M [GeForce GT 730M]",
             0x1291: "GK208M [GeForce GT 735M]",
             0x1292: "GK208M [GeForce GT 740M]",
             0x1293: "GK208M [GeForce GT 730M]",
             0x1294: "GK208M [GeForce GT 740M]",
             0x1295: "GK208M [GeForce 710M]",
             0x1296: "GK208M [GeForce 825M]",
             0x1298: "GK208M [GeForce GT 720M]",
             0x1299: "GK208BM [GeForce 920M]",
             0x129A: "GK208BM [GeForce 910M]",
             0x12A0: "GK208",
             0x12B9: "GK208GLM [Quadro K610M]",
             0x12BA: "GK208GLM [Quadro K510M]",
             0x1340: "GM108M [GeForce 830M]",
             0x1341: "GM108M [GeForce 840M]",
             0x1344: "GM108M [GeForce 845M]",
             0x1346: "GM108M [GeForce 930M]",
             0x1347: "GM108M [GeForce 940M]",
             0x1348: "GM108M [GeForce 945M / 945A]",
             0x1349: "GM108M [GeForce 930M]",
             0x134B: "GM108M [GeForce 940MX]",
             0x134D: "GM108M [GeForce 940MX]",
             0x134E: "GM108M [GeForce 930MX]",
             0x134F: "GM108M [GeForce 920MX]",
             0x137A: "GM108GLM [Quadro K620M / Quadro M500M]",
             0x137B: "GM108GLM [Quadro M520 Mobile]",
             0x137D: "GM108M [GeForce 940A]",
             0x1380: "GM107 [GeForce GTX 750 Ti]",
             0x1381: "GM107 [GeForce GTX 750]",
             0x1382: "GM107 [GeForce GTX 745]",
             0x1389: "GM107GL [GRID M30]",
             0x1390: "GM107M [GeForce 845M]",
             0x1391: "GM107M [GeForce GTX 850M]",
             0x1392: "GM107M [GeForce GTX 860M]",
             0x1393: "GM107M [GeForce 840M]",
             0x1398: "GM107M [GeForce 845M]",
             0x1399: "GM107M [GeForce 945M]",
             0x139A: "GM107M [GeForce GTX 950M]",
             0x139B: "GM107M [GeForce GTX 960M]",
             0x139C: "GM107M [GeForce 940M]",
             0x139D: "GM107M [GeForce GTX 750 Ti]",
             0x13B0: "GM107GLM [Quadro M2000M]",
             0x13B1: "GM107GLM [Quadro M1000M]",
             0x13B2: "GM107GLM [Quadro M600M]",
             0x13B3: "GM107GLM [Quadro K2200M]",
             0x13B4: "GM107GLM [Quadro M620 Mobile]",
             0x13B6: "GM107GLM [Quadro M1200 Mobile]",
             0x13B9: "GM107GL [NVS 810]",
             0x13BA: "GM107GL [Quadro K2200]",
             0x13BB: "GM107GL [Quadro K620]",
             0x13BC: "GM107GL [Quadro K1200]",
             0x13BD: "GM107GL [Tesla M10]",
             0x13C0: "GM204 [GeForce GTX 980]",
             0x13C1: "GM204",
             0x13C2: "GM204 [GeForce GTX 970]",
             0x13C3: "GM204",
             0x13D7: "GM204M [GeForce GTX 980M]",
             0x13D8: "GM204M [GeForce GTX 960 OEM / 970M]",
             0x13D9: "GM204M [GeForce GTX 965M]",
             0x13DA: "GM204M [GeForce GTX 980 Mobile]",
             0x13E7: "GM204GL [GeForce GTX 980 Engineering Sample]",
             0x13F0: "GM204GL [Quadro M5000]",
             0x13F1: "GM204GL [Quadro M4000]",
             0x13F2: "GM204GL [Tesla M60]",
             0x13F3: "GM204GL [Tesla M6]",
             0x13F8: "GM204GLM [Quadro M5000M / M5000 SE]",
             0x13F9: "GM204GLM [Quadro M4000M]",
             0x13FA: "GM204GLM [Quadro M3000M]",
             0x13FB: "GM204GLM [Quadro M5500]",
             0x1401: "GM206 [GeForce GTX 960]",
             0x1402: "GM206 [GeForce GTX 950]",
             0x1404: "GM206 [GeForce GTX 960 FAKE]",
             0x1406: "GM206 [GeForce GTX 960 OEM]",
             0x1407: "GM206 [GeForce GTX 750 v2]",
             0x1427: "GM206M [GeForce GTX 965M]",
             0x1430: "GM206GL [Quadro M2000]",
             0x1431: "GM206GL [Tesla M4]",
             0x1436: "GM206GLM [Quadro M2200 Mobile]",
             0x15F0: "GP100GL [Quadro GP100]",
             0x15F1: "GP100GL",
             0x15F7: "GP100GL [Tesla P100 PCIe 12GB]",
             0x15F8: "GP100GL [Tesla P100 PCIe 16GB]",
             0x15F9: "GP100GL [Tesla P100 SXM2 16GB]",
             0x1617: "GM204M [GeForce GTX 980M]",
             0x1618: "GM204M [GeForce GTX 970M]",
             0x1619: "GM204M [GeForce GTX 965M]",
             0x161A: "GM204M [GeForce GTX 980 Mobile]",
             0x1667: "GM204M [GeForce GTX 965M]",
             0x1725: "GP100",
             0x172E: "GP100",
             0x172F: "GP100",
             0x174D: "GM108M [GeForce MX130]",
             0x174E: "GM108M [GeForce MX110]",
             0x1789: "GM107GL [GRID M3-3020]",
             0x179C: "GM107 [GeForce 940MX]",
             0x17C2: "GM200 [GeForce GTX TITAN X]",
             0x17C8: "GM200 [GeForce GTX 980 Ti]",
             0x17F0: "GM200GL [Quadro M6000]",
             0x17F1: "GM200GL [Quadro M6000 24GB]",
             0x17FD: "GM200GL [Tesla M40]",
             0x1AD0: "Tegra PCIe x8 Endpoint",
             0x1AD1: "Tegra PCIe x4/x8 Endpoint/Root Complex",
             0x1AD2: "Tegra PCIe x1 Root Complex",
             0x1AD3: "Xavier SATA Controller",
             0x1AD6: "TU102 USB 3.1 Host Controller",
             0x1AD7: "TU102 USB Type-C UCSI Controller",
             0x1AD8: "TU104 USB 3.1 Host Controller",
             0x1AD9: "TU104 USB Type-C UCSI Controller",
             0x1ADA: "TU106 USB 3.1 Host Controller",
             0x1ADB: "TU106 USB Type-C UCSI Controller",
             0x1AEB: "TU116 High Definition Audio Controller",
             0x1AEC: "TU116 USB 3.1 Host Controller",
             0x1AED: "TU116 USB Type-C UCSI Controller",
             0x1AEF: "GA102 High Definition Audio Controller",
             0x1AF1: "GA100 [A100 NVSwitch]",
             0x1B00: "GP102 [TITAN X]",
             0x1B01: "GP102 [GeForce GTX 1080 Ti 10GB]",
             0x1B02: "GP102 [TITAN Xp]",
             0x1B04: "GP102",
             0x1B06: "GP102 [GeForce GTX 1080 Ti]",
             0x1B07: "GP102 [P102-100]",
             0x1B30: "GP102GL [Quadro P6000]",
             0x1B38: "GP102GL [Tesla P40]",
             0x1B39: "GP102GL [Tesla P10]",
             0x1B70: "GP102GL",
             0x1B78: "GP102GL",
             0x1B80: "GP104 [GeForce GTX 1080]",
             0x1B81: "GP104 [GeForce GTX 1070]",
             0x1B82: "GP104 [GeForce GTX 1070 Ti]",
             0x1B83: "GP104 [GeForce GTX 1060 6GB]",
             0x1B84: "GP104 [GeForce GTX 1060 3GB]",
             0x1B87: "GP104 [P104-100]",
             0x1BA0: "GP104M [GeForce GTX 1080 Mobile]",
             0x1BA1: "GP104M [GeForce GTX 1070 Mobile]",
             0x1BA2: "GP104M [GeForce GTX 1070 Mobile]",
             0x1BA9: "GP104M",
             0x1BAA: "GP104M",
             0x1BAD: "GP104 [GeForce GTX 1070 Engineering Sample]",
             0x1BB0: "GP104GL [Quadro P5000]",
             0x1BB1: "GP104GL [Quadro P4000]",
             0x1BB3: "GP104GL [Tesla P4]",
             0x1BB4: "GP104GL [Tesla P6]",
             0x1BB5: "GP104GLM [Quadro P5200 Mobile]",
             0x1BB6: "GP104GLM [Quadro P5000 Mobile]",
             0x1BB7: "GP104GLM [Quadro P4000 Mobile]",
             0x1BB8: "GP104GLM [Quadro P3000 Mobile]",
             0x1BB9: "GP104GLM [Quadro P4200 Mobile]",
             0x1BBB: "GP104GLM [Quadro P3200 Mobile]",
             0x1BC7: "GP104 [P104-101]",
             0x1BE0: "GP104BM [GeForce GTX 1080 Mobile]",
             0x1BE1: "GP104BM [GeForce GTX 1070 Mobile]",
             0x1C00: "GP106",
             0x1C01: "GP106",
             0x1C02: "GP106 [GeForce GTX 1060 3GB]",
             0x1C03: "GP106 [GeForce GTX 1060 6GB]",
             0x1C04: "GP106 [GeForce GTX 1060 5GB]",
             0x1C06: "GP106 [GeForce GTX 1060 6GB Rev. 2]",
             0x1C07: "GP106 [P106-100]",
             0x1C09: "GP106 [P106-090]",
             0x1C20: "GP106M [GeForce GTX 1060 Mobile]",
             0x1C21: "GP106M [GeForce GTX 1050 Ti Mobile]",
             0x1C22: "GP106M [GeForce GTX 1050 Mobile]",
             0x1C23: "GP106M [GeForce GTX 1060 Mobile Rev. 2]",
             0x1C2D: "GP106M",
             0x1C30: "GP106GL [Quadro P2000]",
             0x1C31: "GP106GL [Quadro P2200]",
             0x1C35: "GP106M [Quadro P2000 Mobile]",
             0x1C36: "GP106 [P106M]",
             0x1C60: "GP106BM [GeForce GTX 1060 Mobile 6GB]",
             0x1C61: "GP106BM [GeForce GTX 1050 Ti Mobile]",
             0x1C62: "GP106BM [GeForce GTX 1050 Mobile]",
             0x1C70: "GP106GL",
             0x1C81: "GP107 [GeForce GTX 1050]",
             0x1C82: "GP107 [GeForce GTX 1050 Ti]",
             0x1C83: "GP107 [GeForce GTX 1050 3GB]",
             0x1C8C: "GP107M [GeForce GTX 1050 Ti Mobile]",
             0x1C8D: "GP107M [GeForce GTX 1050 Mobile]",
             0x1C8E: "GP107M",
             0x1C8F: "GP107M [GeForce GTX 1050 Ti Max-Q]",
             0x1C90: "GP107M [GeForce MX150]",
             0x1C91: "GP107M [GeForce GTX 1050 3 GB Max-Q]",
             0x1C92: "GP107M [GeForce GTX 1050 Mobile]",
             0x1C94: "GP107M [GeForce MX350]",
             0x1C96: "GP107M [GeForce MX350]",
             0x1CA7: "GP107GL",
             0x1CA8: "GP107GL",
             0x1CAA: "GP107GL",
             0x1CB1: "GP107GL [Quadro P1000]",
             0x1CB2: "GP107GL [Quadro P600]",
             0x1CB3: "GP107GL [Quadro P400]",
             0x1CB6: "GP107GL [Quadro P620]",
             0x1CBA: "GP107GLM [Quadro P2000 Mobile]",
             0x1CBB: "GP107GLM [Quadro P1000 Mobile]",
             0x1CBC: "GP107GLM [Quadro P600 Mobile]",
             0x1CBD: "GP107GLM [Quadro P620]",
             0x1CCC: "GP107BM [GeForce GTX 1050 Ti Mobile]",
             0x1CCD: "GP107BM [GeForce GTX 1050 Mobile]",
             0x1CFA: "GP107GL [Quadro P2000]",
             0x1CFB: "GP107GL [Quadro P1000]",
             0x1D01: "GP108 [GeForce GT 1030]",
             0x1D02: "GP108 [GeForce GT 1010]",
             0x1D10: "GP108M [GeForce MX150]",
             0x1D11: "GP108M [GeForce MX230]",
             0x1D12: "GP108M [GeForce MX150]",
             0x1D13: "GP108M [GeForce MX250]",
             0x1D16: "GP108M [GeForce MX330]",
             0x1D33: "GP108GLM [Quadro P500 Mobile]",
             0x1D34: "GP108GLM [Quadro P520]",
             0x1D52: "GP108BM [GeForce MX250]",
             0x1D56: "GP108BM [GeForce MX330]",
             0x1D81: "GV100 [TITAN V]",
             0x1DB1: "GV100GL [Tesla V100 SXM2 16GB]",
             0x1DB2: "GV100GL [Tesla V100 DGXS 16GB]",
             0x1DB3: "GV100GL [Tesla V100 FHHL 16GB]",
             0x1DB4: "GV100GL [Tesla V100 PCIe 16GB]",
             0x1DB5: "GV100GL [Tesla V100 SXM2 32GB]",
             0x1DB6: "GV100GL [Tesla V100 PCIe 32GB]",
             0x1DB7: "GV100GL [Tesla V100 DGXS 32GB]",
             0x1DB8: "GV100GL [Tesla V100 SXM3 32GB]",
             0x1DBA: "GV100GL [Quadro GV100]",
             0x1DBE: "GV100 Engineering Sample",
             0x1DF0: "GV100GL [Tesla PG500-216]",
             0x1DF2: "GV100GL [Tesla PG503-216]",
             0x1DF5: "GV100GL [Tesla V100 SXM2 16GB]",
             0x1DF6: "GV100GL [Tesla V100S PCIe 32GB]",
             0x1E02: "TU102 [TITAN RTX]",
             0x1E03: "TU102 [GeForce RTX 2080 Ti 12GB]",
             0x1E04: "TU102 [GeForce RTX 2080 Ti]",
             0x1E07: "TU102 [GeForce RTX 2080 Ti Rev. A]",
             0x1E09: "TU102 [CMP 50HX]",
             0x1E2D: "TU102 [GeForce RTX 2080 Ti Engineering Sample]",
             0x1E2E: "TU102 [GeForce RTX 2080 Ti 12GB Engineering Sample]",
             0x1E30: "TU102GL [Quadro RTX 6000/8000]",
             0x1E36: "TU102GL [Quadro RTX 6000]",
             0x1E37: "TU102GL [Tesla T10 16GB / GRID RTX T10-2/T10-4/T10-8]",
             0x1E38: "TU102GL [Tesla T10 24GB]",
             0x1E3C: "TU102GL",
             0x1E3D: "TU102GL",
             0x1E3E: "TU102GL",
             0x1E78: "TU102GL [Quadro RTX 6000/8000]",
             0x1E81: "TU104 [GeForce RTX 2080 SUPER]",
             0x1E82: "TU104 [GeForce RTX 2080]",
             0x1E84: "TU104 [GeForce RTX 2070 SUPER]",
             0x1E87: "TU104 [GeForce RTX 2080 Rev. A]",
             0x1E89: "TU104 [GeForce RTX 2060]",
             0x1E90: "TU104M [GeForce RTX 2080 Mobile]",
             0x1E91: "TU104M [GeForce RTX 2070 SUPER Mobile / Max-Q]",
             0x1E93: "TU104M [GeForce RTX 2080 SUPER Mobile / Max-Q]",
             0x1EAB: "TU104M",
             0x1EAE: "TU104M [GeForce GTX 2080 Engineering Sample]",
             0x1EB0: "TU104GL [Quadro RTX 5000]",
             0x1EB1: "TU104GL [Quadro RTX 4000]",
             0x1EB4: "TU104GL [T4G]",
             0x1EB5: "TU104GLM [Quadro RTX 5000 Mobile / Max-Q]",
             0x1EB6: "TU104GLM [Quadro RTX 4000 Mobile / Max-Q]",
             0x1EB8: "TU104GL [Tesla T4]",
             0x1EB9: "TU104GL",
             0x1EBA: "TU104GL [PG189 SKU600]",
             0x1EBE: "TU104GL",
             0x1EC2: "TU104 [GeForce RTX 2070 SUPER]",
             0x1EC7: "TU104 [GeForce RTX 2070 SUPER]",
             0x1ED0: "TU104BM [GeForce RTX 2080 Mobile]",
             0x1ED1: "TU104BM [GeForce RTX 2070 SUPER Mobile / Max-Q]",
             0x1ED3: "TU104BM [GeForce RTX 2080 SUPER Mobile / Max-Q]",
             0x1EF5: "TU104GLM [Quadro RTX 5000 Mobile Refresh]",
             0x1F02: "TU106 [GeForce RTX 2070]",
             0x1F03: "TU106 [GeForce RTX 2060 12GB]",
             0x1F04: "TU106",
             0x1F06: "TU106 [GeForce RTX 2060 SUPER]",
             0x1F07: "TU106 [GeForce RTX 2070 Rev. A]",
             0x1F08: "TU106 [GeForce RTX 2060 Rev. A]",
             0x1F09: "TU106 [GeForce GTX 1660 SUPER]",
             0x1F0A: "TU106 [GeForce GTX 1650]",
             0x1F0B: "TU106 [CMP 40HX]",
             0x1F10: "TU106M [GeForce RTX 2070 Mobile]",
             0x1F11: "TU106M [GeForce RTX 2060 Mobile]",
             0x1F12: "TU106M [GeForce RTX 2060 Max-Q]",
             0x1F14: "TU106M [GeForce RTX 2070 Mobile / Max-Q Refresh]",
             0x1F15: "TU106M [GeForce RTX 2060 Mobile]",
             0x1F2E: "TU106M",
             0x1F36: "TU106GLM [Quadro RTX 3000 Mobile / Max-Q]",
             0x1F42: "TU106 [GeForce RTX 2060 SUPER]",
             0x1F47: "TU106 [GeForce RTX 2060 SUPER]",
             0x1F50: "TU106BM [GeForce RTX 2070 Mobile / Max-Q]",
             0x1F51: "TU106BM [GeForce RTX 2060 Mobile]",
             0x1F54: "TU106BM [GeForce RTX 2070 Mobile]",
             0x1F55: "TU106BM [GeForce RTX 2060 Mobile]",
             0x1F76: "TU106GLM [Quadro RTX 3000 Mobile Refresh]",
             0x1F81: "TU117",
             0x1F82: "TU117 [GeForce GTX 1650]",
             0x1F83: "TU117 [GeForce GTX 1630]",
             0x1F91: "TU117M [GeForce GTX 1650 Mobile / Max-Q]",
             0x1F92: "TU117M [GeForce GTX 1650 Mobile]",
             0x1F94: "TU117M [GeForce GTX 1650 Mobile]",
             0x1F95: "TU117M [GeForce GTX 1650 Ti Mobile]",
             0x1F96: "TU117M [GeForce GTX 1650 Mobile / Max-Q]",
             0x1F97: "TU117M [GeForce MX450]",
             0x1F98: "TU117M [GeForce MX450]",
             0x1F99: "TU117M",
             0x1F9C: "TU117M [GeForce MX450]",
             0x1F9D: "TU117M [GeForce GTX 1650 Mobile / Max-Q]",
             0x1F9F: "TU117M [GeForce MX550]",
             0x1FA0: "TU117M [GeForce MX550]",
             0x1FA1: "TU117M",
             0x1FAE: "TU117GL",
             0x1FB0: "TU117GLM [Quadro T1000 Mobile]",
             0x1FB1: "TU117GL [T600]",
             0x1FB2: "TU117GLM [Quadro T400 Mobile]",
             0x1FB6: "TU117GLM [T600 Laptop GPU]",
             0x1FB7: "TU117GLM [T550 Laptop GPU]",
             0x1FB8: "TU117GLM [Quadro T2000 Mobile / Max-Q]",
             0x1FB9: "TU117GLM [Quadro T1000 Mobile]",
             0x1FBA: "TU117GLM [T600 Mobile]",
             0x1FBB: "TU117GLM [Quadro T500 Mobile]",
             0x1FBC: "TU117GLM [T1200 Laptop GPU]",
             0x1FBF: "TU117GL",
             0x1FD9: "TU117BM [GeForce GTX 1650 Mobile Refresh]",
             0x1FDD: "TU117BM [GeForce GTX 1650 Mobile Refresh]",
             0x1FF0: "TU117GL [T1000 8GB]",
             0x1FF2: "TU117GL [T400 4GB]",
             0x1FF9: "TU117GLM [Quadro T1000 Mobile]",
             0x2082: "GA100 [CMP 170HX]",
             0x20B0: "GA100 [A100 SXM4 40GB]",
             0x20B1: "GA100 [A100 PCIe 40GB]",
             0x20B2: "GA100 [A100 SXM4 80GB]",
             0x20B3: "GA100 [A100-SXM-64GB]",
             0x20B5: "GA100 [A100 PCIe 80GB]",
             0x20B6: "GA100GL [PG506-232]",
             0x20B7: "GA100GL [A30 PCIe]",
             0x20B8: "GA100 [A100X]",
             0x20B9: "GA100 [A30X]",
             0x20BB: "GA100 [DRIVE A100 PROD]",
             0x20BE: "GA100 [GRID A100A]",
             0x20BF: "GA100 [GRID A100B]",
             0x20C2: "GA100 [CMP 170HX]",
             0x20F0: "GA100 [A100-PG506-207]",
             0x20F1: "GA100 [A100 PCIe 40GB]",
             0x20F2: "GA100 [A100-PG506-217]",
             0x20F3: "GA100 [A800-SXM4-80GB]",
             0x20F5: "GA100 [A800 80GB PCIe]",
             0x20F6: "GA100 [A800 40GB PCIe]",
             0x2182: "TU116 [GeForce GTX 1660 Ti]",
             0x2183: "TU116",
             0x2184: "TU116 [GeForce GTX 1660]",
             0x2187: "TU116 [GeForce GTX 1650 SUPER]",
             0x2188: "TU116 [GeForce GTX 1650]",
             0x2189: "TU116 [CMP 30HX]",
             0x2191: "TU116M [GeForce GTX 1660 Ti Mobile]",
             0x2192: "TU116M [GeForce GTX 1650 Ti Mobile]",
             0x21AE: "TU116GL",
             0x21BF: "TU116GL",
             0x21C2: "TU116",
             0x21C4: "TU116 [GeForce GTX 1660 SUPER]",
             0x21D1: "TU116BM [GeForce GTX 1660 Ti Mobile]",
             0x2200: "GA102",
             0x2203: "GA102 [GeForce RTX 3090 Ti]",
             0x2204: "GA102 [GeForce RTX 3090]",
             0x2205: "GA102 [GeForce RTX 3080 Ti 20GB]",
             0x2206: "GA102 [GeForce RTX 3080]",
             0x2207: "GA102 [GeForce RTX 3070 Ti]",
             0x2208: "GA102 [GeForce RTX 3080 Ti]",
             0x220A: "GA102 [GeForce RTX 3080 12GB]",
             0x220D: "GA102 [CMP 90HX]",
             0x2216: "GA102 [GeForce RTX 3080 Lite Hash Rate]",
             0x222B: "GA102 [GeForce RTX 3090 Engineering Sample]",
             0x222F: "GA102 [GeForce RTX 3080 11GB / 12GB Engineering Sample]",
             0x2230: "GA102GL [RTX A6000]",
             0x2231: "GA102GL [RTX A5000]",
             0x2232: "GA102GL [RTX A4500]",
             0x2233: "GA102GL [RTX A5500]",
             0x2235: "GA102GL [A40]",
             0x2236: "GA102GL [A10]",
             0x2237: "GA102GL [A10G]",
             0x2238: "GA102GL [A10M]",
             0x223F: "GA102GL",
             0x228B: "GA104 High Definition Audio Controller",
             0x228E: "GA106 High Definition Audio Controller",
             0x2296: "Tegra PCIe Endpoint Virtual Network",
             0x22BA: "AD102 High Definition Audio Controller",
             0x2302: "GH100",
             0x2313: "GH100 [H100 CNX]",
             0x2321: "GH100",
             0x2322: "GH100 [H800]",
             0x2330: "GH100[H100 SXM5 80GB]",
             0x2331: "GH100 [H100 PCIe]",
             0x2336: "GH100 [H100]",
             0x2414: "GA103 [GeForce RTX 3060 Ti]",
             0x2420: "GA103M [GeForce RTX 3080 Ti Mobile]",
             0x2438: "GA103GLM [RTX A5500 Laptop GPU]",
             0x2460: "GA103M [GeForce RTX 3080 Ti Laptop GPU]",
             0x2482: "GA104 [GeForce RTX 3070 Ti]",
             0x2483: "GA104",
             0x2484: "GA104 [GeForce RTX 3070]",
             0x2486: "GA104 [GeForce RTX 3060 Ti]",
             0x2487: "GA104 [GeForce RTX 3060]",
             0x2488: "GA104 [GeForce RTX 3070 Lite Hash Rate]",
             0x2489: "GA104 [GeForce RTX 3060 Ti Lite Hash Rate]",
             0x248A: "GA104 [CMP 70HX]",
             0x249C: "GA104M [GeForce RTX 3080 Mobile / Max-Q 8GB/16GB]",
             0x249D: "GA104M [GeForce RTX 3070 Mobile / Max-Q]",
             0x249F: "GA104M",
             0x24A0: "GA104 [Geforce RTX 3070 Ti Laptop GPU]",
             0x24A4: "GA104M",
             0x24AC: "GA104 [GeForce RTX 30x0 Engineering Sample]",
             0x24AD: "GA104 [GeForce RTX 3060 Engineering Sample]",
             0x24AF: "GA104 [GeForce RTX 3070 Engineering Sample]",
             0x24B0: "GA104GL [RTX A4000]",
             0x24B1: "GA104GL [RTX A4000H]",
             0x24B6: "GA104GLM [RTX A5000 Mobile]",
             0x24B7: "GA104GLM [RTX A4000 Mobile]",
             0x24B8: "GA104GLM [RTX A3000 Mobile]",
             0x24B9: "GA104GLM [RTX A3000 12GB Laptop GPU]",
             0x24BA: "GA104GLM [RTX A4500 Laptop GPU]",
             0x24BB: "GA104GLM [RTX A3000 Laptop GPU]",
             0x24BF: "GA104 [GeForce RTX 3070 Engineering Sample]",
             0x24C9: "GA104 [GeForce RTX 3060 Ti]",
             0x24DC: "GA104M [GeForce RTX 3080 Mobile / Max-Q 8GB/16GB]",
             0x24DD: "GA104M [GeForce RTX 3070 Mobile / Max-Q]",
             0x24DF: "GA104M",
             0x24E0: "GA104M [Geforce RTX 3070 Ti Laptop GPU]",
             0x24FA: "GA104 [RTX A4500 Embedded GPU ]",
             0x2501: "GA106 [GeForce RTX 3060]",
             0x2503: "GA106 [GeForce RTX 3060]",
             0x2504: "GA106 [GeForce RTX 3060 Lite Hash Rate]",
             0x2505: "GA106",
             0x2507: "GA106 [Geforce RTX 3050]",
             0x2508: "GA106 [GeForce RTX 3050 OEM]",
             0x2509: "GA106 [GeForce RTX 3060 12GB Rev. 2]",
             0x2520: "GA106M [GeForce RTX 3060 Mobile / Max-Q]",
             0x2521: "GA106M [GeForce RTX 3060 Laptop GPU]",
             0x2523: "GA106M [GeForce RTX 3050 Ti Mobile / Max-Q]",
             0x252F: "GA106 [GeForce RTX 3060 Engineering Sample]",
             0x2531: "GA106 [RTX A2000]",
             0x2544: "GA106 [GeForce RTX 3060]",
             0x2560: "GA106M [GeForce RTX 3060 Mobile / Max-Q]",
             0x2561: "GA106M [GeForce RTX 3060 Laptop GPU]",
             0x2563: "GA106M [GeForce RTX 3050 Ti Mobile / Max-Q]",
             0x2571: "GA106 [RTX A2000 12GB]",
             0x2582: "GA107 [GeForce RTX 3050 8GB]",
             0x2583: "GA107 [GeForce RTX 3050 4GB]",
             0x25A0: "GA107M [GeForce RTX 3050 Ti Mobile]",
             0x25A2: "GA107M [GeForce RTX 3050 Mobile]",
             0x25A3: "GA107",
             0x25A4: "GA107",
             0x25A5: "GA107M [GeForce RTX 3050 Mobile]",
             0x25A6: "GA107M [GeForce MX570]",
             0x25A7: "GA107M [GeForce MX570]",
             0x25A9: "GA107M [GeForce RTX 2050]",
             0x25AA: "GA107M [GeForce MX570 A]",
             0x25AB: "GA107M [GeForce RTX 3050 4GB Laptop GPU]",
             0x25AC: "GN20-P0-R-K2 [GeForce RTX 3050 6GB Laptop GPU]",
             0x25AD: "GA107 [GeForce RTX 2050]",
             0x25AF: "GA107 [GeForce RTX 3050 Engineering Sample]",
             0x25B5: "GA107GLM [RTX A4 Mobile]",
             0x25B6: "GA107GL [A2 / A16]",
             0x25B8: "GA107GLM [RTX A2000 Mobile]",
             0x25B9: "GA107GLM [RTX A1000 Laptop GPU]",
             0x25BA: "GA107GLM [RTX A2000 8GB Laptop GPU]",
             0x25BB: "GA107GLM [RTX A500 Laptop GPU]",
             0x25BC: "GA107GLM [RTX A1000 6GB Laptop GPU]",
             0x25E0: "GA107BM [GeForce RTX 3050 Ti Mobile]",
             0x25E2: "GA107BM [GeForce RTX 3050 Mobile]",
             0x25E5: "GA107BM [GeForce RTX 3050 Mobile]",
             0x25EC: "GN20-P0-R-K2 [GeForce RTX 3050 6GB Laptop GPU]",
             0x25ED: "GA107 [GeForce RTX 2050]",
             0x25F9: "GA107 [RTX A1000 Embedded GPU ]",
             0x25FA: "GA107 [RTX A2000 Embedded GPU]",
             0x25FB: "GA107 [RTX A500 Embedded GPU]",
             0x2681: "AD102 [RTX TITAN Ada]",
             0x2684: "AD102 [GeForce RTX 4090]",
             0x26B1: "AD102GL [L6000 / RTX 6000 Ada Generation]",
             0x26B5: "AD102GL [L40]",
             0x26B8: "AD102GL [L40G]",
             0x26F5: "AD102GL [L40 CNX]",
             0x2704: "AD103 [GeForce RTX 4080]",
             0x2717: "GN21-X11 [GeForce RTX 4090 Laptop GPU]",
             0x2730: "AD103GLM [RTX 5000 Ada Generation Laptop GPU]",
             0x2757: "GN21-X11",
             0x2782: "AD104 [GeForce RTX 4070 Ti]",
             0x2785: "AD104",
             0x2786: "AD104 [GeForce RTX 4070]",
             0x27A0: "AD104M [GeForce RTX 4080 Max-Q / Mobile]",
             0x27B8: "AD104GL [L4]",
             0x27BA: "AD104",
             0x27BB: "AD104GLM [RTX 3500 Ada Generation Laptop GPU]",
             0x27E0: "AD104M [GeForce RTX 4080 Max-Q / Mobile]",
             0x2820: "AD106M [GeForce RTX 4070 Max-Q / Mobile]",
             0x2838: "AD106GLM [RTX 3000 Ada Generation Laptop GPU]",
             0x2860: "AD106M [GeForce RTX 4070 Max-Q / Mobile]",
             0x28A0: "AD107M [GeForce RTX 4060 Max-Q / Mobile]",
             0x28A1: "AD107M [GeForce RTX 4050 Max-Q / Mobile]",
             0x28B8: "AD107GLM [RTX 2000 Ada Generation Laptop GPU]",
             0x28E0: "AD107M [GeForce RTX 4060 Max-Q / Mobile]",
             0x28E1: "AD107M [GeForce RTX 4050 Max-Q / Mobile]",
             },

    # Emulex Corporation
    0x10DF: {0x0720: "OneConnect NIC (Skyhawk)",
             0x0722: "OneConnect iSCSI Initiator (Skyhawk)",
             0x0723: "OneConnect iSCSI Initiator + Target (Skyhawk)",
             0x0724: "OneConnect FCoE Initiator (Skyhawk)",
             0x0728: "OneConnect NIC (Skyhawk-VF)",
             0x072A: "OneConnect iSCSI Initiator (Skyhawk-VF)",
             0x072B: "OneConnect iSCSI Initiator + Target (Skyhawk-VF)",
             0x072C: "OneConnect FCoE Initiator (Skyhawk-VF)",
             0x1AE5: "LP6000 Fibre Channel Host Adapter",
             0xE100: "Proteus-X: LightPulse IOV Fibre Channel Host Adapter",
             0xE131: "LightPulse 8Gb/s PCIe Shared I/O Fibre Channel Adapter",
             0xE180: "Proteus-X: LightPulse IOV Fibre Channel Host Adapter",
             0xE200: "LPe15000/LPe16000 Series 8Gb/16Gb Fibre Channel Adapter",
             0xE208: "LightPulse 16Gb Fibre Channel Host Adapter (Lancer-VF)",
             0xE220: "OneConnect NIC (Lancer)",
             0xE240: "OneConnect iSCSI Initiator (Lancer)",
             0xE260: "OneConnect FCoE Initiator (Lancer)",
             0xE268: "OneConnect 10Gb FCoE Converged Network Adapter (Lancer-VF)",
             0xE300: "LPe31000/LPe32000 Series 16Gb/32Gb Fibre Channel Adapter",
             0xF011: "Saturn: LightPulse Fibre Channel Host Adapter",
             0xF015: "Saturn: LightPulse Fibre Channel Host Adapter",
             0xF085: "LP850 Fibre Channel Host Adapter",
             0xF095: "LP952 Fibre Channel Host Adapter",
             0xF098: "LP982 Fibre Channel Host Adapter",
             0xF0A1: "Thor LightPulse Fibre Channel Host Adapter",
             0xF0A5: "Thor LightPulse Fibre Channel Host Adapter",
             0xF0B5: "Viper LightPulse Fibre Channel Host Adapter",
             0xF0D1: "Helios LightPulse Fibre Channel Host Adapter",
             0xF0D5: "Helios LightPulse Fibre Channel Host Adapter",
             0xF0E1: "Zephyr LightPulse Fibre Channel Host Adapter",
             0xF0E5: "Zephyr LightPulse Fibre Channel Host Adapter",
             0xF0F5: "Neptune LightPulse Fibre Channel Host Adapter",
             0xF100: "LPe12000 Series 8Gb Fibre Channel Adapter",
             0xF111: "Saturn-X LightPulse Fibre Channel Host Adapter",
             0xF112: "Saturn-X LightPulse Fibre Channel Host Adapter",
             0xF180: "LPSe12002 EmulexSecure Fibre Channel Adapter",
             0xF400: "LPe35000/LPe36000 Series 32Gb/64Gb Fibre Channel Adapter",
             0xF500: "LPe37000/LPe38000 Series 32Gb/64Gb Fibre Channel Adapter",
             0xF700: "LP7000 Fibre Channel Host Adapter",
             0xF701: "LP7000 Fibre Channel Host Adapter Alternate ID (JX1:2-3, JX2:1-2)",
             0xF800: "LP8000 Fibre Channel Host Adapter",
             0xF801: "LP8000 Fibre Channel Host Adapter Alternate ID (JX1:2-3, JX2:1-2)",
             0xF900: "LP9000 Fibre Channel Host Adapter",
             0xF901: "LP9000 Fibre Channel Host Adapter Alternate ID (JX1:2-3, JX2:1-2)",
             0xF980: "LP9802 Fibre Channel Host Adapter",
             0xF981: "LP9802 Fibre Channel Host Adapter Alternate ID",
             0xF982: "LP9802 Fibre Channel Host Adapter Alternate ID",
             0xFA00: "Thor-X LightPulse Fibre Channel Host Adapter",
             0xFB00: "Viper LightPulse Fibre Channel Host Adapter",
             0xFC00: "Thor-X LightPulse Fibre Channel Host Adapter",
             0xFC10: "Helios-X LightPulse Fibre Channel Host Adapter",
             0xFC20: "Zephyr-X LightPulse Fibre Channel Host Adapter",
             0xFC40: "Saturn-X: LightPulse Fibre Channel Host Adapter",
             0xFC50: "Proteus-X: LightPulse IOV Fibre Channel Host Adapter",
             0xFD00: "Helios-X LightPulse Fibre Channel Host Adapter",
             0xFD11: "Helios-X LightPulse Fibre Channel Host Adapter",
             0xFD12: "Helios-X LightPulse Fibre Channel Host Adapter",
             0xFE00: "Zephyr-X LightPulse Fibre Channel Host Adapter",
             0xFE05: "Zephyr-X: LightPulse FCoE Adapter",
             0xFE11: "Zephyr-X LightPulse Fibre Channel Host Adapter",
             0xFE12: "Zephyr-X LightPulse FCoE Adapter",
             0xFF00: "Neptune LightPulse Fibre Channel Host Adapter",
             },

    # Integrated Micro Solutions Inc.
    0x10E0: {0x5026: "IMS5026/27/28",
             0x5027: "IMS5027",
             0x5028: "IMS5028",
             0x8849: "IMS8849",
             0x8853: "IMS8853",
             0x9128: "IMS9128 [Twin turbo 128]",
             },

    # Tekram Technology Co.,Ltd.
    0x10E1: {0x0391: "TRM-S1040",
             0x690C: "DC-690c",
             0xDC29: "DC-290",
             },

    # Tundra Semiconductor Corp.
    0x10E3: {0x0000: "CA91C042 [Universe]",
             0x0108: "Tsi108 Host Bridge for Single PowerPC",
             0x0148: "Tsi148 [Tempe]",
             0x0860: "CA91C860 [QSpan]",
             0x0862: "CA91C862A [QSpan-II]",
             0x8111: "Tsi381 PCIe to PCI Bridge",
             0x8260: "CA91L8200B [Dual PCI PowerSpan II]",
             0x8261: "CA91L8260B [Single PCI PowerSpan II]",
             0xA108: "Tsi109 Host Bridge for Dual PowerPC",
             },

    # Applied Micro Circuits Corp.
    0x10E8: {0x1072: "INES GPIB-PCI (AMCC5920 based)",
             0x2011: "Q-Motion Video Capture/Edit board",
             0x4750: "S5930 [Matchmaker]",
             0x5920: "S5920",
             0x8043: "LANai4.x [Myrinet LANai interface chip]",
             0x8062: "S5933_PARASTATION",
             0x807D: "S5933 [Matchmaker]",
             0x8088: "Kongsberg Spacetec Format Synchronizer",
             0x8089: "Kongsberg Spacetec Serial Output Board",
             0x809C: "S5933_HEPC3",
             0x80B9: "Harmonix Hi-Card P8 (4x active ISDN BRI)",
             0x80D7: "PCI-9112",
             0x80D8: "PCI-7200",
             0x80D9: "PCI-9118",
             0x80DA: "PCI-9812",
             0x80FC: "APCI1500 Signal processing controller (16 dig. inputs + 16 dig. outputs)",
             0x811A: "PCI-IEEE1355-DS-DE Interface",
             0x814C: "Fastcom ESCC-PCI (Commtech, Inc.)",
             0x8170: "S5933 [Matchmaker] (Chipset Development Tool)",
             0x81E6: "Multimedia video controller",
             0x828D: "APCI3001 Signal processing controller (up to 16 analog inputs)",
             0x8291: "Fastcom 232/8-PCI (Commtech, Inc.)",
             0x82C4: "Fastcom 422/4-PCI (Commtech, Inc.)",
             0x82C5: "Fastcom 422/2-PCI (Commtech, Inc.)",
             0x82C6: "Fastcom IG422/1-PCI (Commtech, Inc.)",
             0x82C7: "Fastcom IG232/2-PCI (Commtech, Inc.)",
             0x82CA: "Fastcom 232/4-PCI (Commtech, Inc.)",
             0x82DB: "AJA HDNTV HD SDI Framestore",
             0x82E2: "Fastcom DIO24H-PCI (Commtech, Inc.)",
             0x8406: "PCIcanx/PCIcan CAN interface [Kvaser AB]",
             0x8407: "PCIcan II CAN interface (A1021, PCB-07, PCB-08) [Kvaser AB]",
             0x8851: "S5933 on Innes Corp FM Radio Capture card",
             0xE004: "X-Gene PCIe bridge",
             },

    # Integraphics
    0x10EA: {0x1680: "IGA-1680",
             0x1682: "IGA-1682",
             0x1683: "IGA-1683",
             0x2000: "CyberPro 2000",
             0x2010: "CyberPro 2000A",
             0x5000: "CyberPro 5000",
             0x5050: "CyberPro 5050",
             0x5202: "CyberPro 5202",
             0x5252: "CyberPro5252",
             },

    # Artists Graphics
    0x10EB: {0x0101: "3GA",
             0x8111: "Twist3 Frame Grabber",
             },

    # Realtek Semiconductor Co., Ltd.
    0x10EC: {0x0139: "RTL-8139/8139C/8139C+ Ethernet Controller",
             0x3000: "Killer E3000 2.5GbE Controller",
             0x5208: "RTS5208 PCI Express Card Reader",
             0x5209: "RTS5209 PCI Express Card Reader",
             0x5227: "RTS5227 PCI Express Card Reader",
             0x5229: "RTS5229 PCI Express Card Reader",
             0x522A: "RTS522A PCI Express Card Reader",
             0x5249: "RTS5249 PCI Express Card Reader",
             0x524A: "RTS524A PCI Express Card Reader",
             0x5250: "RTS5250 PCI Express Card Reader",
             0x525A: "RTS525A PCI Express Card Reader",
             0x5260: "RTS5260 PCI Express Card Reader",
             0x5261: "RTS5261 PCI Express Card Reader",
             0x5286: "RTS5286 PCI Express Card Reader",
             0x5287: "RTL8411B PCI Express Card Reader",
             0x5288: "RTS5288 PCI Express Card Reader",
             0x5289: "RTL8411 PCI Express Card Reader",
             0x5762: "RTS5763DL NVMe SSD Controller",
             0x8029: "RTL-8029(AS)",
             0x8125: "RTL8125 2.5GbE Controller",
             0x8129: "RTL-8129",
             0x8136: "RTL810xE PCI Express Fast Ethernet controller",
             0x8137: "RTL8104E PCIe Fast Ethernet Controller",
             0x8138: "RT8139 (B/C) Cardbus Fast Ethernet Adapter",
             0x8139: "RTL-8100/8101L/8139 PCI Fast Ethernet Adapter",
             0x8161: "RTL8111/8168/8411 PCI Express Gigabit Ethernet Controller",
             0x8167: "RTL-8110SC/8169SC Gigabit Ethernet",
             0x8168: "RTL8111/8168/8411 PCI Express Gigabit Ethernet Controller",
             0x8169: "RTL8169 PCI Gigabit Ethernet Controller",
             0x816A: "RTL8111xP UART #1",
             0x816B: "RTL8111xP UART #2",
             0x816C: "RTL8111xP IPMI interface",
             0x816D: "RTL811x EHCI host controller",
             0x816E: "Realtek RealManage BMC",
             0x8171: "RTL8191SEvA Wireless LAN Controller",
             0x8172: "RTL8191SEvB Wireless LAN Controller",
             0x8173: "RTL8192SE Wireless LAN Controller",
             0x8174: "RTL8192SE Wireless LAN Controller",
             0x8176: "RTL8188CE 802.11b/g/n WiFi Adapter",
             0x8177: "RTL8191CE PCIe Wireless Network Adapter",
             0x8178: "RTL8192CE PCIe Wireless Network Adapter",
             0x8179: "RTL8188EE Wireless Network Adapter",
             0x8180: "RTL8180L 802.11b MAC",
             0x8185: "RTL-8185 IEEE 802.11a/b/g Wireless LAN Controller",
             0x818B: "RTL8192EE PCIe Wireless Network Adapter",
             0x8190: "RTL8190 802.11n PCI Wireless Network Adapter",
             0x8191: "RTL8192CE PCIe Wireless Network Adapter",
             0x8192: "RTL8192E/RTL8192SE Wireless LAN Controller",
             0x8193: "RTL8192DE Wireless LAN Controller",
             0x8196: "RTL8196 Integrated PCI-e Bridge",
             0x8197: "SmartLAN56 56K Modem",
             0x8199: "RTL8187SE Wireless LAN Controller",
             0x8723: "RTL8723AE PCIe Wireless Network Adapter",
             0x8812: "RTL8812AE 802.11ac PCIe Wireless Network Adapter",
             0x8813: "RTL8813AE 802.11ac PCIe Wireless Network Adapter",
             0x8821: "RTL8821AE 802.11ac PCIe Wireless Network Adapter",
             0x8852: "RTL8852AE 802.11ax PCIe Wireless Network Adapter",
             0xB723: "RTL8723BE PCIe Wireless Network Adapter",
             0xB822: "RTL8822BE 802.11a/b/g/n/ac WiFi adapter",
             0xC821: "RTL8821CE 802.11ac PCIe Wireless Network Adapter",
             0xC822: "RTL8822CE 802.11ac PCIe Wireless Network Adapter",
             0xC82F: "RTL8822CE 802.11ac PCIe Wireless Network Adapter",
             0xD723: "RTL8723DE 802.11b/g/n PCIe Adapter",
             },

    # Xilinx Corporation
    0x10EE: {0x0001: "EUROCOM for PCI (ECOMP)",
             0x0002: "Octal E1/T1 for PCI ETP Card",
             0x0007: "Default PCIe endpoint ID",
             0x0205: "Wildcard TE205P",
             0x0210: "Wildcard TE210P",
             0x0300: "Spartan 3 Designs (Xilinx IP)",
             0x0314: "Wildcard TE405P/TE410P (1st Gen)",
             0x0405: "Wildcard TE405P (2nd Gen)",
             0x0410: "Wildcard TE410P (2nd Gen)",
             0x0600: "Xilinx 6 Designs (Xilinx IP)",
             0x3FC0: "RME Digi96",
             0x3FC1: "RME Digi96/8",
             0x3FC2: "RME Digi96/8 Pro",
             0x3FC3: "RME Digi96/8 Pad",
             0x3FC4: "RME Digi9652 (Hammerfall)",
             0x3FC5: "RME Hammerfall DSP",
             0x3FC6: "RME Hammerfall DSP MADI",
             0x5000: "Alveo U200 XDMA Platform",
             0x5004: "Alveo U250 XDMA Platform",
             0x5005: "Alveo U250",
             0x500C: "Alveo U280 XDMA Platform",
             0x5020: "Alveo U50 XMDA Platform",
             0x505C: "Alveo U55C",
             0x6987: "SmartSSD",
             0x6988: "SmartSSD",
             0x7011: "7-Series FPGA Hard PCIe block (AXI/debug)",
             0x7038: "FPGA Card XC7VX690T",
             0x8019: "Memory controller",
             0x8380: "Ellips ProfiXpress Profibus Master",
             0x8381: "Ellips Santos Frame Grabber",
             0x9134: "SmartSSD",
             0x9234: "SmartSSD",
             0x9434: "SmartSSD",
             0xD000: "Alveo U200 Golden Image",
             0xD004: "Alveo U250 Golden Image",
             0xD00C: "Alveo U280 Golden Image",
             0xD020: "Alveo U50 Golden Image",
             0xD154: "Copley Controls CAN card (PCI-CAN-02)",
             0xEBF0: "SED Systems Modulator/Demodulator",
             0xEBF1: "SED Systems Audio Interface Card",
             0xEBF2: "SED Systems Common PCI Interface",
             0xEBF3: "SED Systems PCIe-AXI Bridge",
             },

    # Tyan Computer
    0x10F1: {0x2865: "Tyan Thunder K8E S2865",
             0x5300: "Tyan S5380 Mainboard",
             },

    # I-O Data Device, Inc.
    0x10FC: {0x0003: "Cardbus IDE Controller",
             0x0005: "Cardbus SCSI CBSC II",
             },

    # Initio Corporation
    0x1101: {0x0002: "INI-920 Ultra SCSI Adapter",
             0x1060: "INI-A100U2W",
             0x1622: "INI-1623 PCI SATA-II Controller",
             0x9100: "INI-9100/9100W",
             0x9400: "INI-940 Fast Wide SCSI Adapter",
             0x9401: "INI-935 Fast Wide SCSI Adapter",
             0x9500: "INI-950 SCSI Adapter",
             0x9502: "INI-950P Ultra Wide SCSI Adapter",
             },

    # Creative Labs
    0x1102: {0x0002: "EMU10k1 [Sound Blaster Live! Series]",
             0x0003: "SB AWE64(D)",
             0x0004: "EMU10k2/CA0100/CA0102/CA10200 [Sound Blaster Audigy Series]",
             0x0005: "EMU20k1 [Sound Blaster X-Fi Series]",
             0x0006: "EMU10k1X / CA0103 [SB Live! OEM / SB 5.1 / Ectiva 5.1]",
             0x0007: "CA0106/CA0111 [SB Live!/Audigy/X-Fi Series]",
             0x0008: "CA0108/CA10300 [Sound Blaster Audigy Series]",
             0x0009: "CA0110 [Sound Blaster X-Fi Xtreme Audio]",
             0x000B: "EMU20k2 [Sound Blaster X-Fi Titanium Series]",
             0x0012: "CA0132 Sound Core3D [Sound Blaster Recon3D / Z-Series / Sound BlasterX AE-5 Plus]",
             0x4001: "SB Audigy FireWire Port",
             0x7002: "SB Live! Game Port",
             0x7003: "SB Audigy Game Port",
             0x7004: "[SB Live! Value] Input device controller",
             0x7005: "SB Audigy LS Game Port",
             0x7006: "[SB X-Fi Xtreme Audio] CA0110-IBG PCIe to PCI Bridge",
             0x8938: "Ectiva EV1938",
             },

    # HighPoint Technologies, Inc.
    0x1103: {0x0003: "HPT343/345/346/363",
             0x0004: "HPT366/368/370/370A/372/372N",
             0x0005: "HPT372A/372N",
             0x0006: "HPT302/302N",
             0x0007: "HPT371/371N",
             0x0008: "HPT374",
             0x0009: "HPT372N",
             0x0620: "RocketRAID 620 2 Port SATA-III Controller",
             0x0622: "RocketRAID 622 2 Port SATA-III Controller",
             0x0640: "RocketRAID 640 4 Port SATA-III Controller",
             0x0641: "RocketRAID 640L 4 Port SATA-III Controller",
             0x0642: "RocketRAID 642L SATA-III Controller (2 eSATA ports + 2 internal SATA ports)",
             0x0644: "RocketRAID 644 4 Port SATA-III Controller (eSATA)",
             0x0645: "RocketRAID 644L 4 Port SATA-III Controller (eSATA)",
             0x0646: "RocketRAID 644LS SATA-III Controller (4 eSATA devices connected by 1 SAS cable)",
             0x1720: "RocketRAID 1720 (2x SATA II RAID Controller)",
             0x1740: "RocketRAID 1740",
             0x1742: "RocketRAID 1742",
             0x2210: "RocketRAID 2210 SATA-II Controller",
             0x2300: "RocketRAID 230x 4 Port SATA-II Controller",
             0x2310: "RocketRAID 2310 4 Port SATA-II Controller",
             0x2320: "RocketRAID 2320 SATA-II Controller",
             0x2322: "RocketRAID 2322 SATA-II Controller",
             0x2340: "RocketRAID 2340 16 Port SATA-II Controller",
             0x2640: "RocketRAID 2640 SAS/SATA Controller",
             0x2722: "RocketRAID 2722",
             0x2740: "RocketRAID 2740",
             0x2744: "RocketRaid 2744",
             0x2782: "RocketRAID 2782",
             0x3120: "RocketRAID 3120",
             0x3220: "RocketRAID 3220",
             0x3320: "RocketRAID 3320",
             0x4310: "RocketRaid 4310",
             0x7505: "SSD7505 PCIe Gen4 x16 4-Port M.2 NVMe RAID Controller",
             0x7540: "SSD7540 PCIe Gen4 x16 8-Port M.2 NVMe RAID Controller",
             },

    # Sigma Designs, Inc.
    0x1105: {0x1105: "REALmagic Xcard MPEG 1/2/3/4 DVD Decoder",
             0x8300: "REALmagic Hollywood Plus DVD Decoder",
             0x8400: "EM840x REALmagic DVD/MPEG-2 Audio/Video Decoder",
             0x8401: "EM8401 REALmagic DVD/MPEG-2 A/V Decoder",
             0x8470: "EM8470 REALmagic DVD/MPEG-4 A/V Decoder",
             0x8471: "EM8471 REALmagic DVD/MPEG-4 A/V Decoder",
             0x8475: "EM8475 REALmagic DVD/MPEG-4 A/V Decoder",
             0x8476: "EM8476 REALmagic DVD/MPEG-4 A/V Decoder",
             0x8485: "EM8485 REALmagic DVD/MPEG-4 A/V Decoder",
             0x8486: "EM8486 REALmagic DVD/MPEG-4 A/V Decoder",
             0xC621: "EM8621L Digital Media Processor",
             0xC622: "EM8622L MPEG-4.10 (H.264) and SMPTE 421M (VC-1) A/V Decoder",
             },

    # VIA Technologies, Inc.
    0x1106: {0x0102: "Embedded VIA Ethernet Controller",
             0x0130: "VT6305 1394.A Controller",
             0x0198: "P4X600 Host Bridge",
             0x0204: "K8M800 Host Bridge",
             0x0208: "PT890 Host Bridge",
             0x0238: "K8T890 Host Bridge",
             0x0258: "PT880 Host Bridge",
             0x0259: "CN333/CN400/PM880 Host Bridge",
             0x0269: "KT880 Host Bridge",
             0x0282: "K8T800Pro Host Bridge",
             0x0290: "K8M890 Host Bridge",
             0x0293: "PM896 Host Bridge",
             0x0296: "P4M800 Host Bridge",
             0x0305: "VT8363/8365 [KT133/KM133]",
             0x0308: "PT880 Ultra/PT894 Host Bridge",
             0x0314: "CN700/VN800/P4M800CE/Pro Host Bridge",
             0x0324: "CX700/VX700 Host Bridge",
             0x0327: "P4M890 Host Bridge",
             0x0336: "K8M890CE Host Bridge",
             0x0340: "PT900 Host Bridge",
             0x0351: "K8T890CF Host Bridge",
             0x0353: "VX800/820-Series Chipset Host-Bridge Controller",
             0x0364: "CN896/VN896/P4M900 Host Bridge",
             0x0391: "VT8371 [KX133]",
             0x0409: "VX855/VX875 Host Bridge: Host Control",
             0x0410: "VX900 Series Host Bridge: Host Control",
             0x0415: "VT6415 PATA IDE Host Controller",
             0x0501: "VT8501 [Apollo MVP4]",
             0x0505: "VT82C505",
             0x0561: "VT82C576MV",
             0x0571: "VT82C586A/B/VT82C686/A/B/VT823x/A/C PIPC Bus Master IDE",
             0x0576: "VT82C576 3V [Apollo Master]",
             0x0581: "CX700/VX700/VX800/820-Series Serial ATA RAID-Controller",
             0x0585: "VT82C585VP [Apollo VP1/VPX]",
             0x0586: "VT82C586/A/B PCI-to-ISA [Apollo VP]",
             0x0591: "VT8237A SATA 2-Port Controller",
             0x0595: "VT82C595 [Apollo VP2]",
             0x0596: "VT82C596 ISA [Mobile South]",
             0x0597: "VT82C597 [Apollo VP3]",
             0x0598: "VT82C598 [Apollo MVP3]",
             0x0601: "VT8601 [Apollo ProMedia]",
             0x0605: "VT8605 [ProSavage PM133]",
             0x0680: "VT82C680 [Apollo P6]",
             0x0686: "VT82C686 [Apollo Super South]",
             0x0691: "VT82C693A/694x [Apollo PRO133x]",
             0x0693: "VT82C693 [Apollo Pro Plus]",
             0x0698: "VT82C693A [Apollo Pro133 AGP]",
             0x0709: "VX11 Standard Host Bridge",
             0x070A: "VX11 PCI Express Root Port",
             0x070B: "VX11 PCI Express Root Port",
             0x070C: "VX11 PCI Express Root Port",
             0x070D: "VX11 PCI Express Root Port",
             0x070E: "VX11 PCI Express Root Port",
             0x0926: "VT82C926 [Amazon]",
             0x1000: "VT82C570MV",
             0x1106: "VT82C570MV",
             0x1122: "VX800/VX820 Chrome 9 HC3 Integrated Graphics",
             0x1204: "K8M800 Host Bridge",
             0x1208: "PT890 Host Bridge",
             0x1238: "K8T890 Host Bridge",
             0x1258: "PT880 Host Bridge",
             0x1259: "CN333/CN400/PM880 Host Bridge",
             0x1269: "KT880 Host Bridge",
             0x1282: "K8T800Pro Host Bridge",
             0x1290: "K8M890 Host Bridge",
             0x1293: "PM896 Host Bridge",
             0x1296: "P4M800 Host Bridge",
             0x1308: "PT894 Host Bridge",
             0x1314: "CN700/VN800/P4M800CE/Pro Host Bridge",
             0x1324: "CX700/VX700-Series Error Reporting",
             0x1327: "P4M890 Host Bridge",
             0x1336: "K8M890CE Host Bridge",
             0x1340: "PT900 Host Bridge",
             0x1351: "VT3351 Host Bridge",
             0x1353: "VX800/VX820 Error Reporting",
             0x1364: "CN896/VN896/P4M900 Host Bridge",
             0x1409: "VX855/VX875 Error Reporting",
             0x1410: "VX900 Series Error Reporting",
             0x1571: "VT82C576M/VT82C586",
             0x1595: "VT82C595/97 [Apollo VP2/97]",
             0x1732: "VT1732 [Envy24 II] PCI Multi-Channel Audio Controller",
             0x2106: "VIA Rhine Family Fast Ethernet Adapter (VT6105)",
             0x2204: "K8M800 Host Bridge",
             0x2208: "PT890 Host Bridge",
             0x2238: "K8T890 Host Bridge",
             0x2258: "PT880 Host Bridge",
             0x2259: "CN333/CN400/PM880 CPU Host Bridge",
             0x2269: "KT880 Host Bridge",
             0x2282: "K8T800Pro Host Bridge",
             0x2290: "K8M890 Host Bridge",
             0x2293: "PM896 Host Bridge",
             0x2296: "P4M800 Host Bridge",
             0x2308: "PT894 Host Bridge",
             0x2314: "CN700/VN800/P4M800CE/Pro Host Bridge",
             0x2324: "CX700/VX700-Series Host Interface Control",
             0x2327: "P4M890 Host Bridge",
             0x2336: "K8M890CE Host Bridge",
             0x2340: "PT900 Host Bridge",
             0x2351: "VT3351 Host Bridge",
             0x2353: "VX800/VX820 Host Bus Control",
             0x2364: "CN896/VN896/P4M900 Host Bridge",
             0x2409: "VX855/VX875 Host Bus Control",
             0x2410: "VX900 Series CPU Bus Controller",
             0x287A: "VT8251 PCI to PCI Bridge",
             0x287B: "VT8251 Host Bridge",
             0x287C: "VT8251 PCIE Root Port",
             0x287D: "VT8251 PCIE Root Port",
             0x287E: "VT8237/8251 Ultra VLINK Controller",
             0x3022: "CLE266",
             0x3038: "VT82xx/62xx/VX700/8x0/900 UHCI USB 1.1 Controller",
             0x3040: "VT82C586B ACPI",
             0x3043: "VT86C100A [Rhine]",
             0x3044: "VT6306/7/8 [Fire II(M)] IEEE 1394 OHCI Controller",
             0x3050: "VT82C596 Power Management",
             0x3051: "VT82C596 Power Management",
             0x3053: "VT6105M [Rhine-III]",
             0x3057: "VT82C686 [Apollo Super ACPI]",
             0x3058: "VT82C686 AC97 Audio Controller",
             0x3059: "VT8233/A/8235/8237 AC97 Audio Controller",
             0x3065: "VT6102/VT6103 [Rhine-II]",
             0x3068: "AC'97 Modem Controller",
             0x3074: "VT8233 PCI to ISA Bridge",
             0x3091: "VT8633 [Apollo Pro266]",
             0x3099: "VT8366/A/7 [Apollo KT266/A/333]",
             0x3101: "VT8653 Host Bridge",
             0x3102: "VT8662 Host Bridge",
             0x3103: "VT8615 Host Bridge",
             0x3104: "USB 2.0 EHCI-Compliant Host-Controller",
             0x3106: "VT6105/VT6106S [Rhine-III]",
             0x3108: "K8M800/K8N800/K8N800A [S3 UniChrome Pro]",
             0x3109: "VT8233C PCI to ISA Bridge",
             0x3112: "VT8361 [KLE133] Host Bridge",
             0x3113: "VPX/VPX2 PCI to PCI Bridge Controller",
             0x3116: "VT8375 [KM266/KL266] Host Bridge",
             0x3118: "CN400/PM800/PM880/PN800/PN880 [S3 UniChrome Pro]",
             0x3119: "VT6120/VT6121/VT6122 Gigabit Ethernet Adapter",
             0x3122: "VT8623 [Apollo CLE266] integrated CastleRock graphics",
             0x3123: "VT8623 [Apollo CLE266]",
             0x3128: "VT8753 [P4X266 AGP]",
             0x3133: "VT3133 Host Bridge",
             0x3142: "VT6651 WiFi Adapter, 802.11b",
             0x3147: "VT8233A ISA Bridge",
             0x3148: "P4M266 Host Bridge",
             0x3149: "VIA VT6420 SATA RAID Controller",
             0x3156: "P/KN266 Host Bridge",
             0x3157: "CX700/VX700 [S3 UniChrome Pro]",
             0x3164: "VT6410 ATA133 RAID controller",
             0x3168: "P4X333/P4X400/PT800 AGP Bridge",
             0x3177: "VT8235 ISA Bridge",
             0x3178: "ProSavageDDR P4N333 Host Bridge",
             0x3188: "VT8385 [K8T800 AGP] Host Bridge",
             0x3189: "VT8377 [KT400/KT600 AGP] Host Bridge",
             0x31B0: "VX11 Standard Host Bridge",
             0x31B1: "VX11 Standard Host Bridge",
             0x31B2: "VX11 DRAM Controller",
             0x31B3: "VX11 Power Management Controller",
             0x31B4: "VX11 I/O APIC",
             0x31B5: "VX11 Scratch Device",
             0x31B7: "VX11 Standard Host Bridge",
             0x31B8: "VX11 PCI to PCI Bridge",
             0x3204: "K8M800 Host Bridge",
             0x3205: "VT8378 [KM400/A] Chipset Host Bridge",
             0x3208: "PT890 Host Bridge",
             0x3213: "VPX/VPX2 PCI to PCI Bridge Controller",
             0x3218: "K8T800M Host Bridge",
             0x3227: "VT8237 ISA bridge [KT600/K8T800/K8T890/CN700 South]",
             0x3230: "K8M890CE/K8N890CE [Chrome 9]",
             0x3238: "K8T890 Host Bridge",
             0x3249: "VT6421 IDE/SATA Controller",
             0x324A: "CX700/VX700 PCI to PCI Bridge",
             0x324B: "CX700/VX700 Host Bridge",
             0x324E: "CX700/VX700 Internal Module Bus",
             0x3253: "VT6655 WiFi Adapter, 802.11a/b/g",
             0x3258: "PT880 Host Bridge",
             0x3259: "CN333/CN400/PM880 Host Bridge",
             0x3260: "VIA Chrome9 HC IGP",
             0x3269: "KT880 Host Bridge",
             0x3282: "K8T800Pro Host Bridge",
             0x3287: "VT8251 PCI to ISA Bridge",
             0x3288: "VX900/VT8xxx High Definition Audio Controller",
             0x3290: "K8M890 Host Bridge",
             0x3296: "P4M800 Host Bridge",
             0x3324: "CX700/VX700-Series DRAM Bus Control",
             0x3327: "P4M890 Host Bridge",
             0x3336: "K8M890CE Host Bridge",
             0x3337: "VT8237A PCI to ISA Bridge",
             0x3340: "PT900 Host Bridge",
             0x3343: "P4M890 [S3 UniChrome Pro]",
             0x3344: "CN700/P4M800 Pro/P4M800 CE/VN800 Graphics [S3 UniChrome Pro]",
             0x3349: "VT8251 AHCI/SATA 4-Port Controller",
             0x3351: "VT3351 Host Bridge",
             0x3353: "VX800/820 PCI to PCI Bridge",
             0x3364: "CN896/VN896/P4M900 Host Bridge",
             0x3365: "VT630x IEEE 1394 Host Controller [Fire II/M]",
             0x3371: "CN896/VN896/P4M900 [Chrome 9 HC]",
             0x3372: "VT8237S PCI to ISA Bridge",
             0x337A: "VT8237A PCI to PCI Bridge",
             0x337B: "VT8237A Host Bridge",
             0x3403: "VT6315 Series Firewire Controller",
             0x3409: "VX855/VX875 DRAM Bus Control",
             0x3410: "VX900 Series DRAM Bus Control",
             0x3432: "VL800/801 xHCI USB 3.0 Controller",
             0x3456: "VX11 Standard Host Bridge",
             0x345B: "VX11 Miscellaneous Bus",
             0x3483: "VL805/806 xHCI USB 3.0 Controller",
             0x3A01: "VX11 Graphics [Chrome 645/640]",
             0x4149: "VIA VT6420 (ATA133) Controller",
             0x4204: "K8M800 Host Bridge",
             0x4208: "PT890 Host Bridge",
             0x4238: "K8T890 Host Bridge",
             0x4258: "PT880 Host Bridge",
             0x4259: "CN333/CN400/PM880 Host Bridge",
             0x4269: "KT880 Host Bridge",
             0x4282: "K8T800Pro Host Bridge",
             0x4290: "K8M890 Host Bridge",
             0x4293: "PM896 Host Bridge",
             0x4296: "P4M800 Host Bridge",
             0x4308: "PT894 Host Bridge",
             0x4314: "CN700/VN800/P4M800CE/Pro Host Bridge",
             0x4324: "CX700/VX700-Series Power Management and Testing Control",
             0x4327: "P4M890 Host Bridge",
             0x4336: "K8M890CE Host Bridge",
             0x4340: "PT900 Host Bridge",
             0x4351: "VT3351 Host Bridge",
             0x4353: "VX800/VX820 Power Management Control",
             0x4364: "CN896/VN896/P4M900 Host Bridge",
             0x4409: "VX855/VX875 Power Management Control",
             0x4410: "VX900 Series Power Management and Chip Testing Control",
             0x5030: "VT82C596 ACPI [Apollo PRO]",
             0x5122: "VX855/VX875 Chrome 9 HCM Integrated Graphics",
             0x5208: "PT890 I/O APIC Interrupt Controller",
             0x5238: "K8T890 I/O APIC Interrupt Controller",
             0x5287: "VT8251 Serial ATA Controller",
             0x5290: "K8M890 I/O APIC Interrupt Controller",
             0x5308: "PT894 I/O APIC Interrupt Controller",
             0x5324: "CX700M2/VX700/VX800/820-Series Serial ATA & EIDE-Controller",
             0x5327: "P4M890 I/O APIC Interrupt Controller",
             0x5336: "K8M890CE I/O APIC Interrupt Controller",
             0x5340: "PT900 I/O APIC Interrupt Controller",
             0x5351: "VT3351 I/O APIC Interrupt Controller",
             0x5353: "VX800/VX820 APIC and Central Traffic Control",
             0x5364: "CN896/VN896/P4M900 I/O APIC Interrupt Controller",
             0x5372: "VT8237/8251 Serial ATA Controller",
             0x5409: "VX855/VX875 APIC and Central Traffic Control",
             0x5410: "VX900 Series APIC and Central Traffic Control",
             0x6100: "VT85C100A [Rhine II]",
             0x6287: "SATA RAID Controller",
             0x6290: "K8M890CE Host Bridge",
             0x6327: "P4M890 Security Device",
             0x6353: "VX800/VX820 Scratch Registers",
             0x6364: "CN896/VN896/P4M900 Security Device",
             0x6409: "VX855/VX875 Scratch Registers",
             0x6410: "VX900 Series Scratch Registers",
             0x7122: "VX900 Graphics [Chrome9 HD]",
             0x7204: "K8M800 Host Bridge",
             0x7205: "KM400/KN400/P4M800 [S3 UniChrome]",
             0x7208: "PT890 Host Bridge",
             0x7238: "K8T890 Host Bridge",
             0x7258: "PT880 Host Bridge",
             0x7259: "CN333/CN400/PM880 Host Bridge",
             0x7269: "KT880 Host Bridge",
             0x7282: "K8T800Pro Host Bridge",
             0x7290: "K8M890 Host Bridge",
             0x7293: "PM896 Host Bridge",
             0x7296: "P4M800 Host Bridge",
             0x7308: "PT894 Host Bridge",
             0x7314: "CN700/VN800/P4M800CE/Pro Host Bridge",
             0x7324: "CX700/VX700-Series North-South Module Interface Control",
             0x7327: "P4M890 Host Bridge",
             0x7336: "K8M890CE Host Bridge",
             0x7340: "PT900 Host Bridge",
             0x7351: "VT3351 Host Bridge",
             0x7353: "VX800/VX820 North-South Module Interface Control",
             0x7364: "CN896/VN896/P4M900 Host Bridge",
             0x7409: "VX855/VX875 North-South Module Interface Control",
             0x7410: "VX900 Series North-South Module Interface Control",
             0x8231: "VT8231 [PCI-to-ISA Bridge]",
             0x8235: "VT8235 ACPI",
             0x8305: "VT8363/8365 [KT133/KM133 AGP]",
             0x8324: "CX700/VX700-Series Bus Control and Power Management",
             0x8353: "VX800/VX820 Bus Control and Power Management",
             0x8391: "VT8371 [KX133 AGP]",
             0x8400: "MVP4",
             0x8409: "VX855/VX875 Bus Control and Power Management",
             0x8410: "VX900 Series Bus Control and Power Management",
             0x8500: "KLE133/PLE133/PLE133T",
             0x8501: "VT8501 [Apollo MVP4 AGP]",
             0x8596: "VT82C596 [Apollo PRO AGP]",
             0x8597: "VT82C597 [Apollo VP3 AGP]",
             0x8598: "VT82C598/694x [Apollo MVP3/Pro133x AGP]",
             0x8601: "VT8601 [Apollo ProMedia AGP]",
             0x8605: "VT8605 [PM133 AGP]",
             0x8691: "VT82C691 [Apollo Pro]",
             0x8693: "VT82C693 [Apollo Pro Plus] PCI Bridge",
             0x8A25: "PL133/PL133T [S3 ProSavage]",
             0x8A26: "KL133/KL133A/KM133/KM133A [S3 ProSavage]",
             0x8D01: "PN133/PN133T [S3 Twister]",
             0x8D04: "KM266/P4M266/P4M266A/P4N266 [S3 ProSavageDDR]",
             0x9001: "VX900 Series Serial-ATA Controller",
             0x9082: "Standard AHCI 1.0 SATA Controller",
             0x9140: "HDMI Audio Device",
             0x9201: "USB3.0 Controller",
             0x9380: "Ncore Coprocessor",
             0x9530: "VX800/820/900 Series Secure Digital Memory Card Controller",
             0x95D0: "VX800/820/900 Series SDIO Host Controller",
             0xA208: "PT890 PCI to PCI Bridge Controller",
             0xA238: "K8T890 PCI to PCI Bridge Controller",
             0xA327: "P4M890 PCI to PCI Bridge Controller",
             0xA353: "VX8xx/900 Series South-North Module Interface Control",
             0xA364: "CN896/VN896/P4M900 PCI to PCI Bridge Controller",
             0xA409: "VX855/VX875/VX900 Series USB Device Controller",
             0xA410: "VX900 Series PCI Express Root Port 0",
             0xB091: "VT8633 [Apollo Pro266 AGP]",
             0xB099: "VT8366/A/7 [Apollo KT266/A/333 AGP]",
             0xB101: "VT8653 AGP Bridge",
             0xB102: "VT8362 AGP Bridge",
             0xB103: "VT8615 AGP Bridge",
             0xB112: "VT8361 [KLE133] AGP Bridge",
             0xB113: "VPX/VPX2 I/O APIC Interrupt Controller",
             0xB115: "VT8363/8365 [KT133/KM133] PCI Bridge",
             0xB168: "VT8235 PCI Bridge",
             0xB188: "VT8237/8251 PCI bridge [K8M890/K8T800/K8T890 South]",
             0xB198: "VT8237/CX700/VX700-Series PCI to PCI Bridge",
             0xB213: "VPX/VPX2 I/O APIC Interrupt Controller",
             0xB353: "VX855/VX875/VX900 PCI to PCI Bridge",
             0xB410: "VX900 Series PCI Express Root Port 1",
             0xB999: "[K8T890 North / VT8237 South] PCI Bridge",
             0xC208: "PT890 PCI to PCI Bridge Controller",
             0xC238: "K8T890 PCI to PCI Bridge Controller",
             0xC327: "P4M890 PCI to PCI Bridge Controller",
             0xC340: "PT900 PCI to PCI Bridge Controller",
             0xC353: "VX800/820-Series PCI-Express Root (PCI-to-PCI Virtual Bridge)",
             0xC364: "CN896/VN896/P4M900 PCI to PCI Bridge Controller",
             0xC409: "VX855/VX875 EIDE Controller",
             0xC410: "VX900 Series PCI Express Root Port 2",
             0xD104: "VT8237R USB UDCI Controller",
             0xD208: "PT890 PCI to PCI Bridge Controller",
             0xD213: "VPX/VPX2 PCI to PCI Bridge Controller",
             0xD238: "K8T890 PCI to PCI Bridge Controller",
             0xD340: "PT900 PCI to PCI Bridge Controller",
             0xD410: "VX900 Series PCI Express Root Port 3",
             0xE208: "PT890 PCI to PCI Bridge Controller",
             0xE238: "K8T890 PCI to PCI Bridge Controller",
             0xE340: "PT900 PCI to PCI Bridge Controller",
             0xE353: "VX800/820-Series PCI-Express Root Port 0",
             0xE410: "VX900 Series PCI Express Physical Layer Electrical Sub-block",
             0xF208: "PT890 PCI to PCI Bridge Controller",
             0xF238: "K8T890 PCI to PCI Bridge Controller",
             0xF340: "PT900 PCI to PCI Bridge Controller",
             0xF353: "VX800/820-Series PCI-Express Root Port 1",
             0xF410: "VX900 Series PCI UART Port 0-3",
             },

    # Proteon, Inc.
    0x1108: {0x0100: "p1690plus_AA",
             0x0101: "p1690plus_AB",
             0x0105: "P1690Plus",
             0x0108: "P1690Plus",
             0x0138: "P1690Plus",
             0x0139: "P1690Plus",
             0x013C: "P1690Plus",
             0x013D: "P1690Plus",
             },

    # Siemens AG
    0x110A: {0x0002: "Pirahna 2-port",
             0x0005: "Tulip controller, power management, switch extender",
             0x0006: "FSC PINC (I/O-APIC)",
             0x0015: "FSC Multiprocessor Interrupt Controller",
             0x001D: "FSC Copernicus Management Controller",
             0x007B: "FSC Remote Service Controller, mailbox device",
             0x007C: "FSC Remote Service Controller, shared memory device",
             0x007D: "FSC Remote Service Controller, SMIC device",
             0x2101: "HST SAPHIR V Primary PCI (ISDN/PMx)",
             0x2102: "DSCC4 PEB/PEF 20534 DMA Supported Serial Communication Controller with 4 Channels",
             0x2104: "Eicon Diva 2.02 compatible passive ISDN card",
             0x3141: "SIMATIC NET CP 5611 / 5621",
             0x3142: "SIMATIC NET CP 5613 / 5614",
             0x3143: "SIMATIC NET CP 1613",
             0x4021: "SIMATIC NET CP 5512 (Profibus and MPI Cardbus Adapter)",
             0x4029: "SIMATIC NET CP 5613 A2",
             0x4035: "SIMATIC NET CP 1613 A2",
             0x4036: "SIMATIC NET CP 1616",
             0x4038: "SIMATIC NET CP 1604",
             0x4069: "SIMATIC NET CP 5623",
             0x407C: "SIMATIC NET CP 5612",
             0x407D: "SIMATIC NET CP 5613 A3",
             0x407E: "SIMATIC NET CP 5622",
             0x4083: "SIMATIC NET CP 5614 A3",
             0x4084: "SIMATIC NET CP 1626",
             0x4942: "FPGA I-Bus Tracer for MBD",
             0x6120: "SZB6120",
             },

    # Chromatic Research Inc.
    0x110B: {0x0001: "Mpact Media Processor",
             0x0004: "Mpact 2",
             },

    # Powerhouse Systems
    0x1110: {0x6037: "Firepower Powerized SMP I/O ASIC",
             0x6073: "Firepower Powerized SMP I/O ASIC",
             },

    # Osicom Technologies Inc
    0x1112: {0x2200: "FDDI Adapter",
             0x2300: "Fast Ethernet Adapter",
             0x2340: "4 Port Fast Ethernet Adapter",
             0x2400: "ATM Adapter",
             },

    # Accton Technology Corporation
    0x1113: {0x1211: "SMC2-1211TX",
             0x1216: "EN-1216 Ethernet Adapter",
             0x1217: "EN-1217 Ethernet Adapter",
             0x5105: "10Mbps Network card",
             0x9211: "EN-1207D Fast Ethernet Adapter",
             0x9511: "21x4x DEC-Tulip compatible Fast Ethernet",
             0xD301: "CPWNA100 (Philips wireless PCMCIA)",
             0xEC02: "SMC 1244TX v3",
             0xEE23: "SMCWPCIT-G 108Mbps Wireless PCI adapter",
             },

    # Data Translation
    0x1116: {0x0022: "DT3001",
             0x0023: "DT3002",
             0x0024: "DT3003",
             0x0025: "DT3004",
             0x0026: "DT3005",
             0x0027: "DT3001-PGL",
             0x0028: "DT3003-PGL",
             0x0051: "DT322",
             0x0060: "DT340",
             0x0069: "DT332",
             0x80C2: "DT3162",
             },

    # Datacube, Inc
    0x1117: {0x9500: "Max-1C SVGA card",
             0x9501: "Max-1C image processing",
             },

    # ICP Vortex Computersysteme GmbH
    0x1119: {0x0000: "GDT 6000/6020/6050",
             0x0001: "GDT 6000B/6010",
             0x0002: "GDT 6110/6510",
             0x0003: "GDT 6120/6520",
             0x0004: "GDT 6530",
             0x0005: "GDT 6550",
             0x0006: "GDT 6117/6517",
             0x0007: "GDT 6127/6527",
             0x0008: "GDT 6537",
             0x0009: "GDT 6557/6557-ECC",
             0x000A: "GDT 6115/6515",
             0x000B: "GDT 6125/6525",
             0x000C: "GDT 6535",
             0x000D: "GDT 6555/6555-ECC",
             0x0100: "GDT 6117RP/6517RP",
             0x0101: "GDT 6127RP/6527RP",
             0x0102: "GDT 6537RP",
             0x0103: "GDT 6557RP",
             0x0104: "GDT 6111RP/6511RP",
             0x0105: "GDT 6121RP/6521RP",
             0x0110: "GDT 6117RD/6517RD",
             0x0111: "GDT 6127RD/6527RD",
             0x0112: "GDT 6537RD",
             0x0113: "GDT 6557RD",
             0x0114: "GDT 6111RD/6511RD",
             0x0115: "GDT 6121RD/6521RD",
             0x0118: "GDT 6118RD/6518RD/6618RD",
             0x0119: "GDT 6128RD/6528RD/6628RD",
             0x011A: "GDT 6538RD/6638RD",
             0x011B: "GDT 6558RD/6658RD",
             0x0120: "GDT 6117RP2/6517RP2",
             0x0121: "GDT 6127RP2/6527RP2",
             0x0122: "GDT 6537RP2",
             0x0123: "GDT 6557RP2",
             0x0124: "GDT 6111RP2/6511RP2",
             0x0125: "GDT 6121RP2/6521RP2",
             0x0136: "GDT 6113RS/6513RS",
             0x0137: "GDT 6123RS/6523RS",
             0x0138: "GDT 6118RS/6518RS/6618RS",
             0x0139: "GDT 6128RS/6528RS/6628RS",
             0x013A: "GDT 6538RS/6638RS",
             0x013B: "GDT 6558RS/6658RS",
             0x013C: "GDT 6533RS/6633RS",
             0x013D: "GDT 6543RS/6643RS",
             0x013E: "GDT 6553RS/6653RS",
             0x013F: "GDT 6563RS/6663RS",
             0x0166: "GDT 7113RN/7513RN/7613RN",
             0x0167: "GDT 7123RN/7523RN/7623RN",
             0x0168: "GDT 7118RN/7518RN/7518RN",
             0x0169: "GDT 7128RN/7528RN/7628RN",
             0x016A: "GDT 7538RN/7638RN",
             0x016B: "GDT 7558RN/7658RN",
             0x016C: "GDT 7533RN/7633RN",
             0x016D: "GDT 7543RN/7643RN",
             0x016E: "GDT 7553RN/7653RN",
             0x016F: "GDT 7563RN/7663RN",
             0x01D6: "GDT 4x13RZ",
             0x01D7: "GDT 4x23RZ",
             0x01F6: "GDT 8x13RZ",
             0x01F7: "GDT 8x23RZ",
             0x01FC: "GDT 8x33RZ",
             0x01FD: "GDT 8x43RZ",
             0x01FE: "GDT 8x53RZ",
             0x01FF: "GDT 8x63RZ",
             0x0210: "GDT 6519RD/6619RD",
             0x0211: "GDT 6529RD/6629RD",
             0x0260: "GDT 7519RN/7619RN",
             0x0261: "GDT 7529RN/7629RN",
             0x02FF: "GDT MAXRP",
             0x0300: "GDT NEWRX",
             0x0301: "GDT NEWRX2",
             },

    # Efficient Networks, Inc
    0x111A: {0x0000: "155P-MF1 (FPGA)",
             0x0002: "155P-MF1 (ASIC)",
             0x0003: "ENI-25P ATM",
             0x0005: "SpeedStream (LANAI)",
             0x0007: "SpeedStream ADSL",
             0x1020: "SpeedStream PCI 10/100 Network Card",
             0x1203: "SpeedStream 1023 Wireless PCI Adapter",
             },

    # Microsemi / PMC / IDT
    0x111D: {0x0001: "IDT77201/77211 155Mbps ATM SAR Controller [NICStAR]",
             0x0003: "IDT77222/77252 155Mbps ATM MICRO ABR SAR Controller",
             0x0004: "IDT77V252 155Mbps ATM MICRO ABR SAR Controller",
             0x0005: "IDT77V222 155Mbps ATM MICRO ABR SAR Controller",
             0x8018: "PES12N3A 12-lane 3-Port PCI Express Switch",
             0x801C: "PES24N3A PCI Express Switch",
             0x8028: "PES4T4 PCI Express Switch",
             0x802B: "PES8T5A PCI Express Switch",
             0x802C: "PES16T4 PCI Express Switch",
             0x802D: "PES16T7 PCI Express Switch",
             0x802E: "PES24T6 PCI Express Switch",
             0x802F: "PES32T8 PCI Express Switch",
             0x8032: "PES48T12 PCI Express Switch",
             0x8034: "PES16/22/34H16 PCI Express Switch",
             0x8035: "PES32H8 PCI Express Switch",
             0x8036: "PES48H12 PCI Express Switch",
             0x8037: "PES64H16 PCI Express Switch",
             0x8039: "PES3T3 PCI Express Switch",
             0x803A: "PES4T4 PCI Express Switch",
             0x803C: "PES5T5 PCI Express Switch",
             0x803D: "PES6T5 PCI Express Switch",
             0x8048: "PES8NT2 PCI Express Switch",
             0x8049: "PES8NT2 PCI Express Switch",
             0x804A: "PES8NT2 PCI Express Internal NTB",
             0x804B: "PES8NT2 PCI Express External NTB",
             0x804C: "PES16NT2 PCI Express Switch",
             0x804D: "PES16NT2 PCI Express Switch",
             0x804E: "PES16NT2 PCI Express Internal NTB",
             0x804F: "PES16NT2 PCI Express External NTB",
             0x8058: "PES12NT3 PCI Express Switch",
             0x8059: "PES12NT3 PCI Express Switch",
             0x805A: "PES12NT3 PCI Express Internal NTB",
             0x805B: "PES12NT3 PCI Express External NTB",
             0x805C: "PES24NT3 PCI Express Switch",
             0x805D: "PES24NT3 PCI Express Switch",
             0x805E: "PES24NT3 PCI Express Internal NTB",
             0x805F: "PES24NT3 PCI Express External NTB",
             0x8060: "PES16T4G2 PCI Express Gen2 Switch",
             0x8061: "PES12T3G2 PCI Express Gen2 Switch",
             0x8068: "PES6T6G2 PCI Express Gen2 Switch",
             0x806A: "PES24T3G2 PCI Express Gen2 Switch",
             0x806C: "PES16T4A/4T4G2 PCI Express Gen2 Switch",
             0x806E: "PES24T6G2 PCI Express Gen2 Switch",
             0x806F: "HIO524G2 PCI Express Gen2 Switch",
             0x8077: "89HPES64H16G2 64-Lane 16-Port PCIe Gen2 System Interconnect Switch",
             0x8088: "PES32NT8BG2 PCI Express Switch",
             0x808A: "89HPES32NT24BG2 PCI Express Switch",
             0x808C: "89HPES32NT24AG2 PCI Express Switch",
             0x808E: "PES24NT24G2 PCI Express Switch",
             0x808F: "89HPES32NT8AG2 32-Lane 8-Port PCIe Gen2 System Interconnect Switch with Non-Transparent Bridging",
             0x8090: "89HPES16NT16G2 16-Lane 16-Port PCIe Gen2 System Interconnect Switch",
             0x8092: "89HPES12NT12G2 12-Lane 12-Port PCIe Gen2 System Interconnect Switch",
             0x80CF: "F32P08xG3 [PCIe boot mode]",
             0x80D2: "F32P08xG3 NVMe controller",
             },

    # Precision Digital Images
    0x111F: {0x4A47: "Precision MX Video engine interface",
             0x5243: "Frame capture bus interface",
             },

    # Dell EMC
    0x1120: {0x2306: "Unity Fibre Channel Controller",
             0x2501: "Unity Ethernet Controller",
             0x2505: "Unity Fibre Channel Controller",
             },

    # FORE Systems Inc
    0x1127: {0x0200: "ForeRunner PCA-200 ATM",
             0x0210: "PCA-200PC",
             0x0250: "ATM",
             0x0300: "ForeRunner PCA-200EPC ATM",
             0x0310: "ATM",
             0x0400: "ForeRunnerHE ATM Adapter",
             },

    # Dalsa Inc.
    0x112F: {0x0000: "MVC IC-PCI",
             0x0001: "MVC IM-PCI Video frame grabber/processor",
             0x0004: "PCDig Digital Image Capture",
             0x0008: "PC-CamLink PCI framegrabber",
             },

    # Philips Semiconductors
    0x1131: {0x1561: "USB 1.1 Host Controller",
             0x1562: "USB 2.0 Host Controller",
             0x3400: "SmartPCI56(UCB1500) 56K Modem",
             0x5400: "TriMedia TM1000/1100",
             0x5402: "TriMedia TM1300",
             0x5405: "TriMedia TM1500",
             0x5406: "TriMedia TM1700",
             0x540B: "PNX1005 Media Processor",
             0x7130: "SAA7130 Video Broadcast Decoder",
             0x7133: "SAA7131/SAA7133/SAA7135 Video Broadcast Decoder",
             0x7134: "SAA7134/SAA7135HL Video Broadcast Decoder",
             0x7145: "SAA7145",
             0x7146: "SAA7146",
             0x7160: "SAA7160",
             0x7162: "SAA7162",
             0x7164: "SAA7164",
             0x7231: "SAA7231",
             0x9730: "SAA9730 Integrated Multimedia and Peripheral Controller",
             },

    # Dialogic Corporation
    0x1133: {0x7701: "Eiconcard C90",
             0x7711: "Eiconcard C91",
             0x7901: "EiconCard S90",
             0x7902: "EiconCard S90",
             0x7911: "EiconCard S91",
             0x7912: "EiconCard S91",
             0x7921: "Eiconcard S92",
             0x7941: "EiconCard S94",
             0x7942: "EiconCard S94",
             0x7943: "EiconCard S94",
             0x7944: "EiconCard S94",
             0x7945: "Eiconcard S94",
             0x7948: "Eiconcard S94 64bit/66MHz",
             0x9711: "Eiconcard S91 V2",
             0x9911: "Eiconcard S91 V2",
             0x9941: "Eiconcard S94 V2",
             0x9A41: "Eiconcard S94 PCIe",
             0xB921: "EiconCard P92",
             0xB922: "EiconCard P92",
             0xB923: "EiconCard P92",
             0xE001: "Diva Pro 2.0 S/T",
             0xE002: "Diva 2.0 S/T PCI",
             0xE003: "Diva Pro 2.0 U",
             0xE004: "Diva 2.0 U PCI",
             0xE005: "Diva 2.01 S/T PCI",
             0xE006: "Diva CT S/T PCI",
             0xE007: "Diva CT U PCI",
             0xE008: "Diva CT Lite S/T PCI",
             0xE009: "Diva CT Lite U PCI",
             0xE00A: "Diva ISDN+V.90 PCI",
             0xE00B: "Diva ISDN PCI 2.02",
             0xE00C: "Diva 2.02 PCI U",
             0xE00D: "Diva Pro 3.0 PCI",
             0xE00E: "Diva ISDN+CT S/T PCI Rev 2",
             0xE010: "Diva Server BRI-2M PCI",
             0xE011: "Diva Server BRI S/T Rev 2",
             0xE012: "Diva Server 4BRI-8M PCI",
             0xE013: "4BRI",
             0xE014: "Diva Server PRI-30M PCI",
             0xE015: "Diva PRI PCI v2",
             0xE016: "Diva Server Voice 4BRI PCI",
             0xE017: "Diva Server Voice 4BRI Rev 2",
             0xE018: "BRI",
             0xE019: "Diva Server Voice PRI Rev 2",
             0xE01A: "Diva BRI-2FX PCI v2",
             0xE01B: "Diva Server Voice BRI-2M 2.0 PCI",
             0xE01C: "PRI",
             0xE01E: "2PRI",
             0xE020: "4PRI",
             0xE022: "Analog-2",
             0xE024: "Analog-4",
             0xE028: "Analog-8",
             0xE02A: "Diva IPM-300 PCI v1",
             0xE02C: "Diva IPM-600 PCI v1",
             0xE02E: "4BRI",
             0xE032: "BRI",
             0xE034: "Diva BRI-CTI PCI v2",
             },

    # Mercury Computer Systems
    0x1134: {0x0001: "Raceway Bridge",
             0x0002: "Dual PCI to RapidIO Bridge",
             0x000B: "POET Serial RapidIO Bridge",
             0x000D: "POET PSDMS Device",
             },

    # Cisco Systems Inc
    0x1137: {0x0023: "VIC 81 PCIe Upstream Port",
             0x0040: "VIC PCIe Upstream Port",
             0x0041: "VIC PCIe Downstream Port",
             0x0042: "VIC Management Controller",
             0x0043: "VIC Ethernet NIC",
             0x0044: "VIC Ethernet NIC Dynamic",
             0x0045: "VIC FCoE HBA",
             0x0046: "VIC SCSI Controller",
             0x004E: "VIC 82 PCIe Upstream Port",
             0x0071: "VIC SR-IOV VF",
             0x007A: "VIC 1300 PCIe Upstream Port",
             0x00CF: "VIC Userspace NIC",
             0x023E: "1GigE I350 LOM",
             },

    # Cyclone Microsystems, Inc.
    0x113C: {0x0000: "PCI-9060 i960 Bridge",
             0x0001: "PCI-SDK [PCI i960 Evaluation Platform]",
             0x0911: "PCI-911 [i960Jx-based Intelligent I/O Controller]",
             0x0912: "PCI-912 [i960CF-based Intelligent I/O Controller]",
             0x0913: "PCI-913",
             0x0914: "PCI-914 [I/O Controller w/ secondary PCI bus]",
             },

    # Equinox Systems, Inc.
    0x113F: {0x0808: "SST-64P Adapter",
             0x1010: "SST-128P Adapter",
             0x80C0: "SST-16P DB Adapter",
             0x80C4: "SST-16P RJ Adapter",
             0x80C8: "SST-16P Adapter",
             0x8888: "SST-4P Adapter",
             0x9090: "SST-8P Adapter",
             },

    # Alliance Semiconductor Corporation
    0x1142: {0x3210: "AP6410",
             0x6422: "ProVideo 6422",
             0x6424: "ProVideo 6424",
             0x6425: "ProMotion AT25",
             0x643D: "ProMotion AT3D",
             },

    # Workbit Corporation
    0x1145: {0x8007: "NinjaSCSI-32 Workbit",
             0xF007: "NinjaSCSI-32 KME",
             0xF010: "NinjaSCSI-32 Workbit",
             0xF012: "NinjaSCSI-32 Logitec",
             0xF013: "NinjaSCSI-32 Logitec",
             0xF015: "NinjaSCSI-32 Melco",
             0xF020: "NinjaSCSI-32 Sony PCGA-DVD51",
             0xF021: "NinjaPATA-32 Delkin Cardbus UDMA",
             0xF024: "NinjaPATA-32 Delkin Cardbus UDMA",
             0xF103: "NinjaPATA-32 Delkin Cardbus UDMA",
             },

    # SysKonnect
    0x1148: {0x4000: "FDDI Adapter",
             0x4200: "Token Ring adapter",
             0x4300: "SK-9872 Gigabit Ethernet Server Adapter (SK-NET GE-ZX dual link)",
             0x4320: "SK-98xx V2.0 Gigabit Ethernet Adapter [Marvell 88E8001]",
             0x4400: "SK-9Dxx Gigabit Ethernet Adapter",
             0x4500: "SK-9Mxx Gigabit Ethernet Adapter",
             0x9000: "SK-9Sxx Gigabit Ethernet Server Adapter PCI-X [Marvell 88E8022]",
             0x9843: "[Fujitsu] Gigabit Ethernet",
             0x9E00: "SK-9E21D 10/100/1000Base-T Adapter, Copper RJ-45",
             0x9E01: "SK-9E21M 10/100/1000Base-T Adapter",
             },

    # VMIC
    0x114A: {0x5565: "GE-IP PCI5565,PMC5565 Reflective Memory Node",
             0x5579: "VMIPCI-5579 (Reflective Memory Card)",
             0x5587: "VMIPCI-5587 (Reflective Memory Card)",
             0x6504: "VMIC PCI 7755 FPGA",
             0x7587: "VMIVME-7587",
             },

    # Digi International
    0x114F: {0x0002: "AccelePort EPC",
             0x0003: "RightSwitch SE-6",
             0x0004: "AccelePort Xem",
             0x0005: "AccelePort Xr",
             0x0006: "AccelePort Xr,C/X",
             0x0009: "AccelePort Xr/J",
             0x000A: "AccelePort EPC/J",
             0x000C: "DataFirePRIme T1 (1-port)",
             0x000D: "SyncPort 2-Port (x.25/FR)",
             0x0011: "AccelePort 8r EIA-232 (IBM)",
             0x0012: "AccelePort 8r EIA-422",
             0x0013: "AccelePort Xr",
             0x0014: "AccelePort 8r EIA-422",
             0x0015: "AccelePort Xem",
             0x0016: "AccelePort EPC/X",
             0x0017: "AccelePort C/X",
             0x001A: "DataFirePRIme E1 (1-port)",
             0x001B: "AccelePort C/X (IBM)",
             0x001C: "AccelePort Xr (SAIP)",
             0x001D: "DataFire RAS T1/E1/PRI",
             0x0023: "AccelePort RAS",
             0x0024: "DataFire RAS B4 ST/U",
             0x0026: "AccelePort 4r 920",
             0x0027: "AccelePort Xr 920",
             0x0028: "ClassicBoard 4",
             0x0029: "ClassicBoard 8",
             0x0034: "AccelePort 2r 920",
             0x0035: "DataFire DSP T1/E1/PRI cPCI",
             0x0040: "AccelePort Xp",
             0x0042: "AccelePort 2p",
             0x0043: "AccelePort 4p",
             0x0044: "AccelePort 8p",
             0x0045: "AccelePort 16p",
             0x004E: "AccelePort 32p",
             0x0070: "Datafire Micro V IOM2 (Europe)",
             0x0071: "Datafire Micro V (Europe)",
             0x0072: "Datafire Micro V IOM2 (North America)",
             0x0073: "Datafire Micro V (North America)",
             0x00B0: "Digi Neo 4",
             0x00B1: "Digi Neo 8",
             0x00C8: "Digi Neo 2 DB9",
             0x00C9: "Digi Neo 2 DB9 PRI",
             0x00CA: "Digi Neo 2 RJ45",
             0x00CB: "Digi Neo 2 RJ45 PRI",
             0x00CC: "Digi Neo 1 422",
             0x00CD: "Digi Neo 1 422 485",
             0x00CE: "Digi Neo 2 422 485",
             0x00D0: "ClassicBoard 4 422",
             0x00D1: "ClassicBoard 8 422",
             0x00F1: "Digi Neo PCI-E 4 port",
             0x00F4: "Digi Neo 4 (IBM version)",
             0x6001: "Avanstar",
             },

    # Voarx R & D Inc
    0x1158: {0x3011: "Tokenet/vg 1001/10m anylan",
             0x9050: "Lanfleet/Truevalue",
             0x9051: "Lanfleet/Truevalue",
             },

    # MuTech Corporation
    0x1159: {0x0001: "MV-1000",
             0x0002: "MV-1500",
             },

    # Xircom
    0x115D: {0x0003: "Cardbus Ethernet 10/100",
             0x0005: "Cardbus Ethernet 10/100",
             0x0007: "Cardbus Ethernet 10/100",
             0x000B: "Cardbus Ethernet 10/100",
             0x000C: "Mini-PCI V.90 56k Modem",
             0x000F: "Cardbus Ethernet 10/100",
             0x00D4: "Mini-PCI K56Flex Modem",
             0x0101: "Cardbus 56k modem",
             0x0103: "Cardbus Ethernet + 56k Modem",
             },

    # Rendition
    0x1163: {0x0001: "Verite 1000",
             0x2000: "Verite V2000/V2100/V2200",
             },

    # Broadcom
    0x1166: {0x0000: "CMIC-LE",
             0x0005: "CNB20-LE Host Bridge",
             0x0006: "CNB20HE Host Bridge",
             0x0007: "CNB20-LE Host Bridge",
             0x0008: "CNB20HE Host Bridge",
             0x0009: "CNB20LE Host Bridge",
             0x0010: "CIOB30",
             0x0011: "CMIC-HE",
             0x0012: "CMIC-WS Host Bridge (GC-LE chipset)",
             0x0013: "CNB20-HE Host Bridge",
             0x0014: "CMIC-LE Host Bridge (GC-LE chipset)",
             0x0015: "CMIC-GC Host Bridge",
             0x0016: "CMIC-GC Host Bridge",
             0x0017: "GCNB-LE Host Bridge",
             0x0031: "HT1100 HPX0 HT Host Bridge",
             0x0036: "BCM5785 [HT1000] PCI/PCI-X Bridge",
             0x0101: "CIOB-X2 PCI-X I/O Bridge",
             0x0103: "EPB PCI-Express to PCI-X Bridge",
             0x0104: "BCM5785 [HT1000] PCI/PCI-X Bridge",
             0x0110: "CIOB-E I/O Bridge with Gigabit Ethernet",
             0x0130: "BCM5780 [HT2000] PCI-X bridge",
             0x0132: "BCM5780 [HT2000] PCI-Express Bridge",
             0x0140: "HT2100 PCI-Express Bridge",
             0x0141: "HT2100 PCI-Express Bridge",
             0x0142: "HT2100 PCI-Express Bridge",
             0x0144: "HT2100 PCI-Express Bridge",
             0x0200: "OSB4 South Bridge",
             0x0201: "CSB5 South Bridge",
             0x0203: "CSB6 South Bridge",
             0x0205: "BCM5785 [HT1000] Legacy South Bridge",
             0x0211: "OSB4 IDE Controller",
             0x0212: "CSB5 IDE Controller",
             0x0213: "CSB6 RAID/IDE Controller",
             0x0214: "BCM5785 [HT1000] IDE",
             0x0217: "CSB6 IDE Controller",
             0x021B: "HT1100 HD Audio",
             0x0220: "OSB4/CSB5 OHCI USB Controller",
             0x0221: "CSB6 OHCI USB Controller",
             0x0223: "BCM5785 [HT1000] USB",
             0x0225: "CSB5 LPC bridge",
             0x0227: "GCLE-2 Host Bridge",
             0x0230: "CSB5 LPC bridge",
             0x0234: "BCM5785 [HT1000] LPC",
             0x0235: "BCM5785 [HT1000] XIOAPIC0-2",
             0x0238: "BCM5785 [HT1000] WDTimer",
             0x0240: "K2 SATA",
             0x0241: "RAIDCore RC4000",
             0x0242: "RAIDCore BC4000",
             0x024A: "BCM5785 [HT1000] SATA (Native SATA Mode)",
             0x024B: "BCM5785 [HT1000] SATA (PATA/IDE Mode)",
             0x0406: "HT1100 PCI-X Bridge",
             0x0408: "HT1100 Legacy Device",
             0x040A: "HT1100 ISA-LPC Bridge",
             0x0410: "HT1100 SATA Controller (Native SATA Mode)",
             0x0411: "HT1100 SATA Controller (PATA / IDE Mode)",
             0x0412: "HT1100 USB OHCI Controller",
             0x0414: "HT1100 USB EHCI Controller",
             0x0416: "HT1100 USB EHCI Controller (with Debug Port)",
             0x0420: "HT1100 PCI-Express Bridge",
             0x0421: "HT1100 SAS/SATA Controller",
             0x0422: "HT1100 PCI-Express Bridge",
             },

    # Luminex Software, Inc.
    0x116A: {0x6100: "Bus/Tag Channel",
             0x6800: "Escon Channel",
             0x7100: "Bus/Tag Channel",
             0x7800: "Escon Channel",
             },

    # Altera Corporation
    0x1172: {0x00A7: "Stratix V",
             0x0530: "Stratix IV",
             0x646C: "KT-500/KT-521 board",
             },

    # Toshiba Corporation
    0x1179: {0x0102: "Extended IDE Controller",
             0x0103: "EX-IDE Type-B",
             0x010E: "PXP04 NVMe SSD",
             0x010F: "NVMe Controller",
             0x0110: "NVMe SSD Controller Cx5",
             0x0113: "BG3 NVMe SSD Controller",
             0x0115: "XG4 NVMe SSD Controller",
             0x0116: "XG5 NVMe SSD Controller",
             0x011A: "XG6 NVMe SSD Controller",
             0x0404: "DVD Decoder card",
             0x0406: "Tecra Video Capture device",
             0x0407: "DVD Decoder card (Version 2)",
             0x0601: "CPU to PCI bridge",
             0x0602: "PCI to ISA bridge",
             0x0603: "ToPIC95 PCI to CardBus Bridge for Notebooks",
             0x0604: "PCI-Docking Host bridge",
             0x060A: "ToPIC95",
             0x060F: "ToPIC97",
             0x0617: "ToPIC100 PCI to Cardbus Bridge with ZV Support",
             0x0618: "CPU to PCI and PCI to ISA bridge",
             0x0701: "FIR Port Type-O",
             0x0803: "TC6371AF SD Host Controller",
             0x0804: "TC6371AF SmartMedia Controller",
             0x0805: "SD TypA Controller",
             0x0D01: "FIR Port Type-DO",
             },

    # ATTO Technology, Inc.
    0x117C: {0x002C: "ExpressSAS R380",
             0x002D: "ExpressSAS R348",
             0x0030: "Ultra320 SCSI Host Adapter",
             0x0033: "SAS Adapter",
             0x0041: "ExpressSAS R30F",
             0x0042: "ExpressSAS 6Gb/s SAS/SATA HBA",
             0x0049: "ExpressSAS 6Gb SAS/SATA RAID Adapter",
             0x0064: "Celerity FC 16Gb/s Gen 5 Fibre Channel HBA",
             0x0094: "Celerity FC 16/32Gb/s Gen 6 Fibre Channel HBA",
             0x00BB: "Celerity FC 32/64Gb/s Gen 7 Fibre Channel HBA",
             0x00C5: "ExpressNVM PCIe Gen4 Switch",
             0x00E6: "ExpressSAS GT 12Gb/s SAS/SATA HBA",
             0x8013: "ExpressPCI UL4D",
             0x8014: "ExpressPCI UL4S",
             0x8027: "ExpressPCI UL5D",
             0x8070: "ExpressSAS 12Gb/s SAS/SATA HBA",
             0x8072: "ExpressSAS 12Gb/s SAS/SATA HBA",
             },

    # Ricoh Co Ltd
    0x1180: {0x0465: "RL5c465",
             0x0466: "RL5c466",
             0x0475: "RL5c475",
             0x0476: "RL5c476 II",
             0x0477: "RL5c477",
             0x0478: "RL5c478",
             0x0511: "R5C511",
             0x0522: "R5C522 IEEE 1394 Controller",
             0x0551: "R5C551 IEEE 1394 Controller",
             0x0552: "R5C552 IEEE 1394 Controller",
             0x0554: "R5C554",
             0x0575: "R5C575 SD Bus Host Adapter",
             0x0576: "R5C576 SD Bus Host Adapter",
             0x0592: "R5C592 Memory Stick Bus Host Adapter",
             0x0811: "R5C811",
             0x0822: "R5C822 SD/SDIO/MMC/MS/MSPro Host Adapter",
             0x0832: "R5C832 IEEE 1394 Controller",
             0x0841: "R5C841 CardBus/SD/SDIO/MMC/MS/MSPro/xD/IEEE1394",
             0x0843: "R5C843 MMC Host Controller",
             0x0852: "xD-Picture Card Controller",
             0xE230: "R5U2xx (R5U230 / R5U231 / R5U241) [Memory Stick Host Controller]",
             0xE476: "CardBus bridge",
             0xE822: "MMC/SD Host Controller",
             0xE823: "PCIe SDXC/MMC Host Controller",
             0xE832: "R5C832 PCIe IEEE 1394 Controller",
             0xE852: "PCIe xD-Picture Card Controller",
             },

    # D-Link System Inc
    0x1186: {0x1002: "DL10050 Sundance Ethernet",
             0x1025: "AirPlus Xtreme G DWL-G650 Adapter",
             0x1026: "AirXpert DWL-AG650 Wireless Cardbus Adapter",
             0x1043: "AirXpert DWL-AG650 Wireless Cardbus Adapter",
             0x1300: "RTL8139 Ethernet",
             0x1340: "DFE-690TXD CardBus PC Card",
             0x1540: "DFE-680TX",
             0x1541: "DFE-680TXD CardBus PC Card",
             0x1561: "DRP-32TXD Cardbus PC Card",
             0x3300: "DWL-510 / DWL-610 802.11b [Realtek RTL8180L]",
             0x3A10: "AirXpert DWL-AG650 Wireless Cardbus Adapter(rev.B)",
             0x3A11: "AirXpert DWL-AG520 Wireless PCI Adapter(rev.B)",
             0x4000: "DL2000-based Gigabit Ethernet",
             0x4001: "DGE-550SX PCI-X Gigabit Ethernet Adapter",
             0x4200: "DFE-520TX Fast Ethernet PCI Adapter",
             0x4300: "DGE-528T Gigabit Ethernet Adapter",
             0x4302: "DGE-530T Gigabit Ethernet Adapter (rev.C1) [Realtek RTL8169]",
             0x4B00: "DGE-560T PCI Express Gigabit Ethernet Adapter",
             0x4B01: "DGE-530T Gigabit Ethernet Adapter (rev 11)",
             0x4B02: "DGE-560SX PCI Express Gigabit Ethernet Adapter",
             0x4B03: "DGE-550T Gigabit Ethernet Adapter V.B1",
             0x4C00: "Gigabit Ethernet Adapter",
             0x8400: "D-Link DWL-650+ CardBus PC Card",
             },

    # Corollary, Inc
    0x118C: {0x0014: "PCIB [C-bus II to PCI bus host bridge chip]",
             0x1117: "Intel 8-way XEON Profusion Chipset [Cache Coherency Filter]",
             },

    # BitFlow Inc
    0x118D: {0x0001: "Raptor-PCI framegrabber",
             0x0012: "Model 12 Road Runner Frame Grabber",
             0x0014: "Model 14 Road Runner Frame Grabber",
             0x0024: "Model 24 Road Runner Frame Grabber",
             0x0044: "Model 44 Road Runner Frame Grabber",
             0x0112: "Model 12 Road Runner Frame Grabber",
             0x0114: "Model 14 Road Runner Frame Grabber",
             0x0124: "Model 24 Road Runner Frame Grabber",
             0x0144: "Model 44 Road Runner Frame Grabber",
             0x0212: "Model 12 Road Runner Frame Grabber",
             0x0214: "Model 14 Road Runner Frame Grabber",
             0x0224: "Model 24 Road Runner Frame Grabber",
             0x0244: "Model 44 Road Runner Frame Grabber",
             0x0312: "Model 12 Road Runner Frame Grabber",
             0x0314: "Model 14 Road Runner Frame Grabber",
             0x0324: "Model 24 Road Runner Frame Grabber",
             0x0344: "Model 44 Road Runner Frame Grabber",
             0xB04E: "Claxon CXP4 CoaXPress frame grabber",
             },

    # Artop Electronic Corp
    0x1191: {0x0003: "SCSI Cache Host Adapter",
             0x0004: "ATP8400",
             0x0005: "ATP850UF",
             0x0006: "ATP860 NO-BIOS",
             0x0007: "ATP860",
             0x0008: "ATP865 NO-ROM",
             0x0009: "ATP865",
             0x000A: "ATP867-A",
             0x000B: "ATP867-B",
             0x000D: "ATP8620",
             0x000E: "ATP8620",
             0x8002: "AEC6710 SCSI-2 Host Adapter",
             0x8010: "AEC6712UW SCSI",
             0x8020: "AEC6712U SCSI",
             0x8030: "AEC6712S SCSI",
             0x8040: "AEC6712D SCSI",
             0x8050: "AEC6712SUW SCSI",
             0x8060: "AEC6712 SCSI",
             0x8080: "AEC67160 SCSI",
             0x8081: "AEC67160S SCSI",
             0x808A: "AEC67162 2-ch. LVD SCSI",
             },

    # Zeitnet Inc.
    0x1193: {0x0001: "1221",
             0x0002: "1225",
             },

    # Fujitsu Microelectronics Ltd.
    0x119E: {0x0001: "FireStream 155",
             0x0003: "FireStream 50",
             },

    # Bull HN Information Systems
    0x119F: {0x1081: "BXI Host Channel Adapter",
             0x1101: "BXI Host Channel Adapter v1.2",
             0x1121: "BXI Host Channel Adapter v1.3",
             },

    # Marvell Technology Group Ltd.
    0x11AB: {0x0100: "88F3700 [Armada 3700 Family] ARM SoC",
             0x0110: "88F60x0/88F70x0/88F80x0/CN913x ARM SoC",
             0x0146: "GT-64010/64010A System Controller",
             0x0F53: "88E6318 Link Street network controller",
             0x11AB: "MV88SE614x SATA II PCI-E controller",
             0x138F: "W8300 802.11 Adapter (rev 07)",
             0x1FA6: "Marvell W8300 802.11 Adapter",
             0x1FA7: "88W8310 and 88W8000G [Libertas] 802.11g client chipset",
             0x1FAA: "88w8335 [Libertas] 802.11b/g Wireless",
             0x2211: "88SB2211 PCI Express to PCI Bridge",
             0x2A01: "88W8335 [Libertas] 802.11b/g Wireless",
             0x2A02: "88W8361 [TopDog] 802.11n Wireless",
             0x2A08: "88W8362e [TopDog] 802.11a/b/g/n Wireless",
             0x2A0A: "88W8363 [TopDog] 802.11n Wireless",
             0x2A0C: "88W8363 [TopDog] 802.11n Wireless",
             0x2A24: "88W8363 [TopDog] 802.11n Wireless",
             0x2A2B: "88W8687 [TopDog] 802.11b/g Wireless",
             0x2A30: "88W8687 [TopDog] 802.11b/g Wireless",
             0x2A40: "88W8366 [TopDog] 802.11n Wireless",
             0x2A41: "88W8366 [TopDog] 802.11n Wireless",
             0x2A42: "88W8366 [TopDog] 802.11n Wireless",
             0x2A43: "88W8366 [TopDog] 802.11n Wireless",
             0x2A55: "88W8864 [Avastar] 802.11ac Wireless",
             0x2B36: "88W8764 [Avastar] 802.11n Wireless",
             0x2B38: "88W8897 [AVASTAR] 802.11ac Wireless",
             0x2B40: "88W8964 [Avastar] 802.11ac Wireless",
             0x4101: "OLPC Cafe Controller Secure Digital Controller",
             0x4146: "GT-64111 System Controller",
             0x4320: "88E8001 Gigabit Ethernet Controller",
             0x4340: "88E8021 PCI-X IPMI Gigabit Ethernet Controller",
             0x4341: "88E8022 PCI-X IPMI Gigabit Ethernet Controller",
             0x4342: "88E8061 PCI-E IPMI Gigabit Ethernet Controller",
             0x4343: "88E8062 PCI-E IPMI Gigabit Ethernet Controller",
             0x4344: "88E8021 PCI-X IPMI Gigabit Ethernet Controller",
             0x4345: "88E8022 PCI-X IPMI Gigabit Ethernet Controller",
             0x4346: "88E8061 PCI-E IPMI Gigabit Ethernet Controller",
             0x4347: "88E8062 PCI-E IPMI Gigabit Ethernet Controller",
             0x4350: "88E8035 PCI-E Fast Ethernet Controller",
             0x4351: "88E8036 PCI-E Fast Ethernet Controller",
             0x4352: "88E8038 PCI-E Fast Ethernet Controller",
             0x4353: "88E8039 PCI-E Fast Ethernet Controller",
             0x4354: "88E8040 PCI-E Fast Ethernet Controller",
             0x4355: "88E8040T PCI-E Fast Ethernet Controller",
             0x4356: "88EC033 PCI-E Fast Ethernet Controller",
             0x4357: "88E8042 PCI-E Fast Ethernet Controller",
             0x435A: "88E8048 PCI-E Fast Ethernet Controller",
             0x4360: "88E8052 PCI-E ASF Gigabit Ethernet Controller",
             0x4361: "88E8050 PCI-E ASF Gigabit Ethernet Controller",
             0x4362: "88E8053 PCI-E Gigabit Ethernet Controller",
             0x4363: "88E8055 PCI-E Gigabit Ethernet Controller",
             0x4364: "88E8056 PCI-E Gigabit Ethernet Controller",
             0x4365: "88E8070 based Ethernet Controller",
             0x4366: "88EC036 PCI-E Gigabit Ethernet Controller",
             0x4367: "88EC032 Ethernet Controller",
             0x4368: "88EC034 Ethernet Controller",
             0x4369: "88EC042 Ethernet Controller",
             0x436A: "88E8058 PCI-E Gigabit Ethernet Controller",
             0x436B: "88E8071 PCI-E Gigabit Ethernet Controller",
             0x436C: "88E8072 PCI-E Gigabit Ethernet Controller",
             0x436D: "88E8055 PCI-E Gigabit Ethernet Controller",
             0x4370: "88E8075 PCI-E Gigabit Ethernet Controller",
             0x4380: "88E8057 PCI-E Gigabit Ethernet Controller",
             0x4381: "Yukon Optima 88E8059 [PCIe Gigabit Ethernet Controller with AVB]",
             0x4611: "GT-64115 System Controller",
             0x4620: "GT-64120/64120A/64121A System Controller",
             0x4801: "GT-48001",
             0x5005: "Belkin F5D5005 Gigabit Desktop Network PCI Card",
             0x5040: "MV88SX5040 4-port SATA I PCI-X Controller",
             0x5041: "MV88SX5041 4-port SATA I PCI-X Controller",
             0x5080: "MV88SX5080 8-port SATA I PCI-X Controller",
             0x5081: "MV88SX5081 8-port SATA I PCI-X Controller",
             0x5181: "88f5181 [Orion-1] ARM SoC",
             0x5182: "88f5182 [Orion-NAS] ARM SoC",
             0x5281: "88f5281 [Orion-2] ARM SoC",
             0x6041: "MV88SX6041 4-port SATA II PCI-X Controller",
             0x6042: "88SX6042 PCI-X 4-Port SATA-II",
             0x6081: "MV88SX6081 8-port SATA II PCI-X Controller",
             0x6101: "88SE6101/6102 single-port PATA133 interface",
             0x6121: "88SE6111/6121 SATA II / PATA Controller",
             0x6141: "88SE614x SATA II PCI-E controller",
             0x6145: "88SE6145 SATA II PCI-E controller",
             0x6180: "88F6180 [Kirkwood] ARM SoC",
             0x6192: "88F6190/6192 [Kirkwood] ARM SoC",
             0x6281: "88F6281 [Kirkwood] ARM SoC",
             0x6381: "MV78xx0 [Discovery Innovation] ARM SoC",
             0x6440: "88SE6440 SAS/SATA PCIe controller",
             0x6450: "64560 System Controller",
             0x6460: "MV64360/64361/64362 System Controller",
             0x6480: "MV64460/64461/64462 System Controller",
             0x6485: "MV64460/64461/64462 System Controller, Revision B",
             0x6560: "88F6560 [Avanta] ARM SoC",
             0x6710: "88F6710 [Armada 370] ARM SoC",
             0x6820: "88F6820 [Armada 385] ARM SoC",
             0x6828: "88F6828 [Armada 388] ARM SoC",
             0x6920: "88F6920 [Armada 390] ARM SoC",
             0x7042: "88SX7042 PCI-e 4-port SATA-II",
             0x7810: "MV78100 [Discovery Innovation] ARM SoC",
             0x7820: "MV78200 [Discovery Innovation] ARM SoC",
             0x7823: "MV78230 [Armada XP] ARM SoC",
             0x7846: "MV78460 [Armada XP] ARM SoC",
             0xD40F: "Bobcat3 Ethernet Switch",
             0xF003: "GT-64010 Primary Image Piranha Image Generator",
             },

    # Lite-On Communications Inc
    0x11AD: {0x0002: "LNE100TX",
             0xC115: "LNE100TX [Linksys EtherFast 10/100]",
             },

    # Avid Technology Inc.
    0x11AF: {0x0001: "Cinema",
             0xEE40: "Digidesign Audiomedia III",
             },

    # V3 Semiconductor Inc.
    0x11B0: {0x0002: "V300PSC",
             0x0292: "V292PBC [Am29030/40 Bridge]",
             0x0960: "V96xPBC",
             0x880A: "Deltacast Delta-HD-22",
             0xC960: "V96DPC",
             },

    # Pinnacle Systems Inc.
    0x11BD: {0x002E: "PCTV 40i",
             0x0040: "Royal TS Function 1",
             0x0041: "RoyalTS Function 2",
             0x0042: "Royal TS Function 3",
             0x0051: "PCTV HD 800i",
             0xBEDE: "AV/DV Studio Capture Card",
             },

    # LSI Corporation
    0x11C1: {0x0440: "56k WinModem",
             0x0441: "56k WinModem",
             0x0442: "56k WinModem",
             0x0443: "LT WinModem",
             0x0444: "LT WinModem",
             0x0445: "LT WinModem",
             0x0446: "LT WinModem",
             0x0447: "LT WinModem",
             0x0448: "WinModem 56k",
             0x0449: "L56xM+S [Mars-2] WinModem 56k",
             0x044A: "F-1156IV WinModem (V90, 56KFlex)",
             0x044B: "LT WinModem",
             0x044C: "LT WinModem",
             0x044D: "LT WinModem",
             0x044E: "LT WinModem",
             0x044F: "V90 WildWire Modem",
             0x0450: "LT WinModem",
             0x0451: "LT WinModem",
             0x0452: "LT WinModem",
             0x0453: "LT WinModem",
             0x0454: "LT WinModem",
             0x0455: "LT WinModem",
             0x0456: "LT WinModem",
             0x0457: "LT WinModem",
             0x0458: "LT WinModem",
             0x0459: "LT WinModem",
             0x045A: "LT WinModem",
             0x045C: "LT WinModem",
             0x0461: "V90 WildWire Modem",
             0x0462: "V90 WildWire Modem",
             0x0480: "Venus Modem (V90, 56KFlex)",
             0x048C: "V.92 56K WinModem",
             0x048F: "V.92 56k WinModem",
             0x0620: "Lucent V.92 Data/Fax Modem",
             0x2600: "StarPro26XX family (SP2601, SP2603, SP2612) DSP",
             0x5400: "OR3TP12 FPSC",
             0x5656: "Venus Modem",
             0x5801: "USB",
             0x5802: "USS-312 USB Controller",
             0x5803: "USS-344S USB Controller",
             0x5811: "FW322/323 [TrueFire] 1394a Controller",
             0x5901: "FW643 [TrueFire] PCIe 1394b Controller",
             0x5903: "FW533 [TrueFire] PCIe 1394a Controller",
             0x8110: "T8110 H.100/H.110 TDM switch",
             0xAB10: "WL60010 Wireless LAN MAC",
             0xAB11: "WL60040 Multimode Wireles LAN MAC",
             0xAB20: "ORiNOCO PCI Adapter",
             0xAB21: "Agere Wireless PCI Adapter",
             0xAB30: "Hermes2 Mini-PCI WaveLAN a/b/g",
             0xED00: "ET-131x PCI-E Ethernet Controller",
             0xED01: "ET-131x PCI-E Ethernet Controller",
             },

    # Dolphin Interconnect Solutions AS
    0x11C8: {0x0658: "PSB32 SCI-Adapter D31x",
             0xD665: "PSB64 SCI-Adapter D32x",
             0xD667: "PSB66 SCI-Adapter D33x",
             },

    # Magma
    0x11C9: {0x0010: "16-line serial port w/- DMA",
             0x0011: "4-line serial port w/- DMA",
             },

    # Specialix Research Ltd.
    0x11CB: {0x2000: "PCI_9050",
             0x4000: "SUPI_1",
             0x8000: "T225",
             },

    # Auravision
    0x11D1: {0x01F7: "VxP524",
             0x01F9: "VxP951",
             },

    # Analog Devices
    0x11D4: {0x1535: "Blackfin BF535 processor",
             0x1805: "SM56 PCI modem",
             },

    # Ikon Corporation
    0x11D5: {0x0115: "10115",
             0x0117: "10117",
             },

    # Zoran Corporation
    0x11DE: {0x6017: "miroVIDEO DC30",
             0x6057: "ZR36057PQC Video cutting chipset",
             0x6120: "ZR36120",
             },

    # Quicklogic Corporation
    0x11E3: {0x0001: "COM-ON-AIR Dosch&Amand DECT",
             0x0560: "QL5064 Companion Design Demo Board",
             0x5030: "PC Watchdog",
             0x8417: "QL5064 [QuickPCI] PCI v2.2 bridge for SMT417 Dual TMS320C6416T PMC Module",
             },

    # Coreco Inc
    0x11EC: {0x000D: "Oculus-F/64P",
             0x1800: "Cobra/C6",
             },

    # Compu-Shack
    0x11F0: {0x4231: "FDDI",
             0x4232: "FASTline UTP Quattro",
             0x4233: "FASTline FO",
             0x4234: "FASTline UTP",
             0x4235: "FASTline-II UTP",
             0x4236: "FASTline-II FO",
             0x4731: "GIGAline",
             },

    # Compex
    0x11F6: {0x0112: "ENet100VG4",
             0x0113: "FreedomLine 100",
             0x1401: "ReadyLink 2000",
             0x2011: "RL100-ATX 10/100",
             0x2201: "ReadyLink 100TX (Winbond W89C840)",
             0x9881: "RL100TX Fast Ethernet",
             },

    # PMC-Sierra Inc.
    0x11F8: {0x5220: "BR522x [PMC-Sierra maxRAID SAS Controller]",
             0x7364: "PM7364 [FREEDM - 32 Frame Engine & Datalink Mgr]",
             0x7375: "PM7375 [LASAR-155 ATM SAR]",
             0x7384: "PM7384 [FREEDM - 84P672 Frm Engine & Datalink Mgr]",
             0x8000: "PM[SPC - SAS Protocol Controller]",
             0x8009: "PM8009 SPCve 8x6G",
             0x8018: "PM8018 Adaptec SAS Adaptor ASA-70165H PCIe Gen3 x8 6 Gbps 16-lane 4x SFF-8644",
             0x8032: "PM8032 Tachyon QE8",
             0x8053: "PM8053 SXP 12G 24-port SAS/SATA expander",
             0x8054: "PM8054 SXP 12G 36-port SAS/SATA expander",
             0x8055: "PM8055 SXP 12G 48-port SAS/SATA expander",
             0x8056: "PM8056 SXP 12G 68-port SAS/SATA expander",
             0x8060: "PM8060 SRCv 12G eight-port SAS/SATA RoC",
             0x8063: "PM8063 SRCv 12G 16-port SAS/SATA RoC",
             0x8070: "PM8070 Tachyon SPCv 12G eight-port SAS/SATA controller",
             0x8071: "PM8071 Tachyon SPCve 12G eight-port SAS/SATA controller",
             0x8072: "PM8072 Tachyon SPCv 12G 16-port SAS/SATA controller",
             0x8073: "PM8073 Tachyon SPCve 12G 16-port SAS/SATA controller",
             0x8531: "PM8531 PFX 24xG3 PCIe Fanout Switch",
             0x8532: "PM8532 PFX 32xG3 PCIe Fanout Switch",
             0x8533: "PM8533 PFX 48xG3 PCIe Fanout Switch",
             0x8534: "PM8534 PFX 64xG3 PCIe Fanout Switch",
             0x8535: "PM8535 PFX 80xG3 PCIe Fanout Switch",
             0x8536: "PM8536 PFX 96xG3 PCIe Fanout Switch",
             0x8546: "PM8546 B-FEIP PSX 96xG3 PCIe Storage Switch",
             0x8562: "PM8562 Switchtec PFX-L 32xG3 Fanout-Lite PCIe Gen3 Switch",
             },

    # Pepperl+Fuchs
    0x11FE: {0x0001: "RocketPort PCI 32-port w/external I/F",
             0x0002: "RocketPort PCI 8-port w/external I/F",
             0x0003: "RocketPort PCI 16-port w/external I/F",
             0x0004: "RocketPort PCI 4-port w/Quad Cable",
             0x0005: "RocketPort PCI 8-port w/Octa Cable",
             0x0006: "RocketPort PCI 8-port w/RJ11 connectors",
             0x0007: "RocketPort PCI 4-port w/RJ45 connectors",
             0x0008: "RocketPort PCI 8-port w/DB78 SNI connector (Siemens)",
             0x0009: "RocketPort PCI 16-port w/DB78 SNI connector (Siemens)",
             0x000A: "RocketPort PCI Plus 4-port w/Quad Cable",
             0x000B: "RocketPort PCI Plus 8-port w/Octa Cable",
             0x000C: "RocketModem II 6-port",
             0x000D: "RocketModem 4-port",
             0x000E: "RocketPort PCI Plus 2-port RS-232 w/DB9 connectors",
             0x000F: "RocketPort PCI Plus 2-port SMPTE w/DB9 connectors",
             0x0040: "RocketPort INFINITY 8-port w/Octa Cable RJ45",
             0x0041: "RocketPort INFINITY 32-port w/external I/F",
             0x0042: "RocketPort INFINITY 8-port w/external I/F",
             0x0043: "RocketPort INFINITY 16-port w/external I/F",
             0x0044: "RocketPort INFINITY 4-port w/Quad Cable DB",
             0x0045: "RocketPort INFINITY 8-port w/Octa Cable DB",
             0x0046: "RocketPort INFINITY 4-port w/external I/F",
             0x0047: "RocketPort INFINITY 4J (4-port) w/RJ45 connectors",
             0x0048: "RocketPort INFINITY 4J (4-port) w/RJ45 connectors",
             0x004A: "RocketPort INFINITY Plus 4-port",
             0x004B: "RocketPort INFINITY Plus 8-port",
             0x004C: "RocketModem INFINITY III 8-port",
             0x004D: "RocketModem INFINITY III 4-port",
             0x004E: "RocketPort INFINITY Plus 2-port",
             0x004F: "RocketPort INFINITY 2-port SMPTE w/DB9 connectors",
             0x0050: "RocketPort INFINITY Plus 4-port RJ45",
             0x0051: "RocketPort INFINITY Plus 8-port RJ11",
             0x0052: "RocketPort INFINITY 8-port SMPTE w/DB9 Connectors",
             0x0060: "RocketPort EXPRESS 8-port w/Octa Cable",
             0x0061: "RocketPort EXPRESS 32-port w/external I/F",
             0x0062: "RocketPort EXPRESS 8-Port w/external I/F",
             0x0063: "RocketPort EXPRESS 16-port w/external I/F",
             0x0064: "RocketPort EXPRESS 4-port w/Quad Cable",
             0x0065: "RocketPort EXPRESS 8-port w/Octa Cable",
             0x0066: "RocketPort EXPRESS 4-port w/external I/F",
             0x0067: "RocketPort EXPRESS 4J (4-port) w/RJ45 connectors",
             0x0068: "RocketPort EXPRESS 8J (8-port) w/RJ11 connectors",
             0x006F: "RocketPort EXPRESS SMPTE 2-port",
             0x0072: "RocketPort EXPRESS SMPTE 8-port w/external I/F",
             0x0801: "RocketPort uPCI 32-port w/external I/F",
             0x0802: "RocketPort uPCI 8-port w/external I/F",
             0x0803: "RocketPort uPCI 16-port w/external I/F",
             0x0805: "RocketPort uPCI 8-port w/Octa Cable",
             0x080B: "RocketPort Plus uPCI 8-port w/Octa Cable",
             0x080C: "RocketModem III 8-port",
             0x080D: "RocketModem III 4-port",
             0x080E: "RocketPort uPCI 2-port RS232 w/DB9 connectors",
             0x080F: "RocketPort uPCI SMPTE 2-port",
             0x0810: "RocketPort Plus uPCI 4J (4-port) w/RJ45 connectors",
             0x0811: "RocketPort Plus uPCI 8J (8-port) w/RJ11 connectors",
             0x0812: "RocketPort Plus uPCI 422 8-port",
             0x0813: "RocketModem IV uPCI 8-port",
             0x0814: "RocketModem IV uPCI 4-port",
             0x0903: "RocketPort Compact PCI 16 port w/external I/F",
             0x8015: "RocketPort 550 4-port",
             0x8805: "RocketPort uPCI 4-port w/Quad Cable",
             0x880B: "RocketPort Plus uPCI 4-port w/Quad Cable",
             0x8812: "RocketPort Plus uPCI 4-port RS422 w/Quad Cable",
             },

    # Cyclades Corporation
    0x120E: {0x0100: "Cyclom-Y below first megabyte",
             0x0101: "Cyclom-Y above first megabyte",
             0x0102: "Cyclom-4Y below first megabyte",
             0x0103: "Cyclom-4Y above first megabyte",
             0x0104: "Cyclom-8Y below first megabyte",
             0x0105: "Cyclom-8Y above first megabyte",
             0x0200: "Cyclades-Z below first megabyte",
             0x0201: "Cyclades-Z above first megabyte",
             0x0300: "PC300/RSV or /X21 (2 ports)",
             0x0301: "PC300/RSV or /X21 (1 port)",
             0x0310: "PC300/TE (2 ports)",
             0x0311: "PC300/TE (1 port)",
             0x0320: "PC300/TE-M (2 ports)",
             0x0321: "PC300/TE-M (1 port)",
             0x0400: "PC400",
             },

    # O2 Micro, Inc.
    0x1217: {0x00F7: "Firewire (IEEE 1394)",
             0x10F7: "1394 OHCI Compliant Host Controller",
             0x11F7: "OZ600 1394a-2000 Controller",
             0x13F7: "1394 OHCI Compliant Host Controller",
             0x6729: "OZ6729",
             0x673A: "OZ6730",
             0x6832: "OZ6832/6833 CardBus Controller",
             0x6836: "OZ6836/6860 CardBus Controller",
             0x6872: "OZ6812 CardBus Controller",
             0x6925: "OZ6922 CardBus Controller",
             0x6933: "OZ6933/711E1 CardBus/SmartCardBus Controller",
             0x6972: "OZ601/6912/711E0 CardBus/SmartCardBus Controller",
             0x7110: "OZ711Mx 4-in-1 MemoryCardBus Accelerator",
             0x7112: "OZ711EC1/M1 SmartCardBus/MemoryCardBus Controller",
             0x7113: "OZ711EC1 SmartCardBus Controller",
             0x7114: "OZ711M1/MC1 4-in-1 MemoryCardBus Controller",
             0x7120: "Integrated MMC/SD Controller",
             0x7130: "Integrated MS/xD Controller",
             0x7134: "OZ711MP1/MS1 MemoryCardBus Controller",
             0x7135: "Cardbus bridge",
             0x7136: "OZ711SP1 Memory CardBus Controller",
             0x71E2: "OZ711E2 SmartCardBus Controller",
             0x7212: "OZ711M2 4-in-1 MemoryCardBus Controller",
             0x7213: "OZ6933E CardBus Controller",
             0x7223: "OZ711M3/MC3 4-in-1 MemoryCardBus Controller",
             0x7233: "OZ711MP3/MS3 4-in-1 MemoryCardBus Controller",
             0x8120: "Integrated MMC/SD Controller",
             0x8130: "Integrated MS/MSPRO/xD Controller",
             0x8220: "OZ600FJ1/OZ900FJ1 SD/MMC Card Reader Controller",
             0x8221: "OZ600FJ0/OZ900FJ0/OZ600FJS SD/MMC Card Reader Controller",
             0x8320: "OZ600RJ1/OZ900RJ1 SD/MMC Card Reader Controller",
             0x8321: "OZ600RJ0/OZ900RJ0/OZ600RJS SD/MMC Card Reader Controller",
             0x8330: "OZ600 MS/xD Controller",
             0x8331: "O2 Flash Memory Card",
             0x8520: "SD/MMC Card Reader Controller",
             0x8621: "SD/MMC Card Reader Controller",
             },

    # 3Dfx Interactive, Inc.
    0x121A: {0x0001: "Voodoo",
             0x0002: "Voodoo 2",
             0x0003: "Voodoo Banshee",
             0x0004: "Voodoo Banshee [Velocity 100]",
             0x0005: "Voodoo 3",
             0x0009: "Voodoo 4 / Voodoo 5",
             0x0057: "Voodoo 3/3000 [Avenger]",
             },

    # Contec Co., Ltd
    0x1221: {0x9172: "PO-64L(PCI)H [Isolated Digital Output Board for PCI]",
             0x91A2: "PO-32L(PCI)H [Isolated Digital Output Board for PCI]",
             0x91C3: "DA16-16(LPCI)L [Un-insulated highly precise analog output board for Low Profile PCI]",
             0xB152: "DIO-96D2-LPCI",
             0xC103: "ADA16-32/2(PCI)F [High-Speed Analog I/O Board for PCI]",
             },

    # Artesyn Communication Products
    0x1223: {0x0003: "PM/Link",
             0x0004: "PM/T1",
             0x0005: "PM/E1",
             0x0008: "PM/SLS",
             0x0009: "BajaSpan Resource Target",
             0x000A: "BajaSpan Section 0",
             0x000B: "BajaSpan Section 1",
             0x000C: "BajaSpan Section 2",
             0x000D: "BajaSpan Section 3",
             0x000E: "PM/PPC",
             },

    # EIZO Rugged Solutions
    0x1227: {0x0006: "Raptor GFX 8P",
             0x0023: "Raptor GFX [1100T]",
             0x0045: "Raptor 4000-L [Linux version]",
             0x004A: "Raptor 4000-LR-L [Linux version]",
             },

    # Aztech System Ltd
    0x122D: {0x1206: "368DSP",
             0x1400: "Trident PCI288-Q3DII (NX)",
             0x50DC: "3328 Audio",
             0x80DA: "3328 Audio",
             },

    # Xyratex
    0x122E: {0x7722: "Napatech XL1",
             0x7724: "Napatech XL2/XA",
             0x7729: "Napatech XD",
             },

    # Woodward McCoach, Inc.
    0x1231: {0x04E1: "Desktop PCI Telephony 4",
             0x05E1: "Desktop PCI Telephony 5/6",
             0x0D00: "LightParser",
             0x0D02: "LightParser 2",
             0x0D13: "Desktop PCI L1/L3 Telephony",
             },

    # Sigma Designs Corporation
    0x1236: {0x0000: "RealMagic64/GX",
             0x6401: "REALmagic 64/GX (SD 6425)",
             },

    # Engineering Design Team, Inc.
    0x123D: {0x0000: "EasyConnect 8/32",
             0x0002: "EasyConnect 8/64",
             0x0003: "EasyIO",
             },

    # LSI Logic
    0x123F: {0x00E4: "MPEG",
             0x8120: "DVxplore Codec",
             0x8888: "Cinemaster C 3.0 DVD Decoder",
             },

    # JNI Corporation
    0x1242: {0x1560: "JNIC-1560 PCI-X Fibre Channel Controller",
             0x4643: "FCI-1063 Fibre Channel Adapter",
             0x6562: "FCX2-6562 Dual Channel PCI-X Fibre Channel Adapter",
             0x656A: "FCX-6562 PCI-X Fibre Channel Adapter",
             },

    # AVM GmbH
    0x1244: {0x0700: "B1 ISDN",
             0x0800: "C4 ISDN",
             0x0A00: "A1 ISDN [Fritz]",
             0x0E00: "Fritz!Card PCI v2.0 ISDN",
             0x0E80: "Fritz!Card PCI v2.1 ISDN",
             0x1100: "C2 ISDN",
             0x1200: "T1 ISDN",
             0x2700: "Fritz!Card DSL SL",
             0x2900: "Fritz!Card DSL v2.0",
             },

    # Stallion Technologies, Inc.
    0x124D: {0x0000: "EasyConnection 8/32",
             0x0002: "EasyConnection 8/64",
             0x0003: "EasyIO",
             0x0004: "EasyConnection/RA",
             },

    # Linear Systems Ltd.
    0x1254: {0x0065: "DVB Master FD",
             0x007C: "DVB Master Quad/o",
             },

    # Optibase Ltd
    0x1255: {0x1110: "MPEG Forge",
             0x1210: "MPEG Fusion",
             0x2110: "VideoPlex",
             0x2120: "VideoPlex CC",
             0x2130: "VideoQuest",
             },

    # Perceptive Solutions, Inc.
    0x1256: {0x4201: "PCI-2220I",
             0x4401: "PCI-2240I",
             0x5201: "PCI-2000",
             },

    # Allied Telesis
    0x1259: {0x2560: "AT-2560 Fast Ethernet Adapter (i82557B)",
             0x2801: "AT-2801FX (RTL-8139)",
             0xA117: "RTL81xx Fast Ethernet",
             0xA11E: "RTL81xx Fast Ethernet",
             0xA120: "21x4x DEC-Tulip compatible 10/100 Ethernet",
             },

    # Asix Electronics Corporation
    0x125B: {0x1400: "AX88141 Fast Ethernet Controller",
             0x9100: "AX99100 PCIe to Multi I/O Controller",
             },

    # Aurora Technologies, Inc.
    0x125C: {0x0101: "Saturn 4520P",
             0x0640: "Aries 16000P",
             },

    # ESS Technology
    0x125D: {0x0000: "ES336H Fax Modem (Early Model)",
             0x1948: "ES1948 Maestro-1",
             0x1968: "ES1968 Maestro 2",
             0x1969: "ES1938/ES1946/ES1969 Solo-1 Audiodrive",
             0x1978: "ES1978 Maestro 2E",
             0x1988: "ES1988 Allegro-1",
             0x1989: "ESS Modem",
             0x1998: "ES1983S Maestro-3i PCI Audio Accelerator",
             0x1999: "ES1983S Maestro-3i PCI Modem Accelerator",
             0x199A: "ES1983S Maestro-3i PCI Audio Accelerator",
             0x199B: "ES1983S Maestro-3i PCI Modem Accelerator",
             0x2808: "ES336H Fax Modem (Later Model)",
             0x2838: "ES2838/2839 SuperLink Modem",
             0x2898: "ES2898 Modem",
             },

    # Concurrent Technologies, Inc.
    0x125F: {0x2071: "CC PMC/232",
             0x2084: "CC PMC/23P",
             0x2091: "CC PMC/422",
             },

    # Intersil Corporation
    0x1260: {0x3872: "ISL3872 [Prism 3]",
             0x3873: "ISL3874 [Prism 2.5]/ISL3872 [Prism 3]",
             0x3877: "ISL3877 [Prism Indigo]",
             0x3886: "ISL3886 [Prism Javelin/Prism Xbow]",
             0x3890: "ISL3890 [Prism GT/Prism Duette]/ISL3886 [Prism Javelin/Prism Xbow]",
             0x8130: "HMP8130 NTSC/PAL Video Decoder",
             0x8131: "HMP8131 NTSC/PAL Video Decoder",
             0xFFFF: "ISL3886IK",
             },

    # Microdyne Corporation
    0x1266: {0x0001: "NE10/100 Adapter (i82557B)",
             0x1910: "NE2000Plus (RT8029) Ethernet Adapter",
             },

    # S. A. Telecommunications
    0x1267: {0x5352: "PCR2101",
             0x5A4B: "Telsat Turbo",
             },

    # Northern Telecom
    0x126C: {0x1211: "10/100BaseTX [RTL81xx]",
             0x126C: "802.11b Wireless Ethernet Adapter",
             },

    # Silicon Motion, Inc.
    0x126F: {0x0501: "SM501 VoyagerGX Rev. AA",
             0x0510: "SM501 VoyagerGX Rev. B",
             0x0710: "SM710 LynxEM",
             0x0712: "SM712 LynxEM+",
             0x0718: "SM718 LynxSE+",
             0x0720: "SM720 Lynx3DM",
             0x0730: "SM731 Cougar3DR",
             0x0750: "SM750",
             0x0810: "SM810 LynxE",
             0x0811: "SM811 LynxE",
             0x0820: "SM820 Lynx3D",
             0x0910: "SM910",
             0x2262: "SM2262/SM2262EN SSD Controller",
             0x2263: "SM2263EN/SM2263XT SSD Controller",
             },

    # Ensoniq
    0x1274: {0x1171: "ES1373 / Creative Labs CT5803 [AudioPCI]",
             0x1371: "ES1371/ES1373 / Creative Labs CT2518",
             0x5000: "ES1370 [AudioPCI]",
             0x5880: "5880B / Creative Labs CT5880",
             0x8001: "CT5880 [AudioPCI]",
             0x8002: "5880A [AudioPCI]",
             },

    # Transtech Parallel Systems Ltd.
    0x1278: {0x0701: "TPE3/TM3 PowerPC Node",
             0x0710: "TPE5 PowerPC PCI board",
             0x1100: "PMC-FPGA02",
             0x1101: "TS-C43 card with 4 ADSP-TS101 processors",
             },

    # Transmeta Corporation
    0x1279: {0x0060: "TM8000 Northbridge",
             0x0061: "TM8000 AGP bridge",
             0x0295: "Northbridge",
             0x0395: "LongRun Northbridge",
             0x0396: "SDRAM controller",
             0x0397: "BIOS scratchpad",
             },

    # Rockwell International
    0x127A: {0x1002: "HCF 56k Data/Fax Modem",
             0x1003: "HCF 56k Data/Fax Modem",
             0x1004: "HCF 56k Data/Fax/Voice Modem",
             0x1005: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem",
             0x1022: "HCF 56k Modem",
             0x1023: "HCF 56k Data/Fax Modem",
             0x1024: "HCF 56k Data/Fax/Voice Modem",
             0x1025: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem",
             0x1026: "HCF 56k PCI Speakerphone Modem",
             0x1032: "HCF 56k Modem",
             0x1033: "HCF 56k Modem",
             0x1034: "HCF 56k Modem",
             0x1035: "HCF 56k PCI Speakerphone Modem",
             0x1036: "HCF 56k Modem",
             0x1085: "HCF 56k Volcano PCI Modem",
             0x2004: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem",
             0x2005: "HCF 56k Data/Fax Modem",
             0x2013: "HSF 56k Data/Fax Modem",
             0x2014: "HSF 56k Data/Fax/Voice Modem",
             0x2015: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem",
             0x2016: "HSF 56k Data/Fax/Voice/Spkp Modem",
             0x4311: "Riptide HSF 56k PCI Modem",
             0x4320: "Riptide PCI Audio Controller",
             0x4321: "Riptide HCF 56k PCI Modem",
             0x4322: "Riptide PCI Game Controller",
             0x8234: "RapidFire 616X ATM155 Adapter",
             },

    # Davicom Semiconductor, Inc.
    0x1282: {0x6585: "DM562P V90 Modem",
             0x9009: "DM9009 Ethernet Controller",
             0x9100: "21x4x DEC-Tulip compatible 10/100 Ethernet",
             0x9102: "DM9102 Fast Ethernet Controller",
             0x9132: "Ethernet 100/10 MBit",
             },

    # Integrated Technology Express, Inc.
    0x1283: {0x673A: "IT8330G",
             0x8152: "IT8152F/G Advanced RISC-to-PCI Companion Chip",
             0x8211: "ITE 8211F Single Channel UDMA 133",
             0x8212: "IT8212 Dual channel ATA RAID controller",
             0x8213: "IT8213 IDE Controller",
             0x8330: "IT8330G",
             0x8872: "IT887xF PCI to ISA I/O chip with SMB, GPIO, Serial or Parallel Port",
             0x8888: "IT8888F/G PCI to ISA Bridge with SMB [Golden Gate]",
             0x8889: "IT8889F PCI to ISA Bridge",
             0x8892: "IT8892E PCIe to PCI Bridge",
             0x8893: "IT8893E PCIe to PCI Bridge",
             0xE886: "IT8330G",
             },

    # M-Pact, Inc.
    0x1287: {0x001E: "LS220D DVD Decoder",
             0x001F: "LS220C DVD Decoder",
             },

    # Hoontech Corporation/Samho Multi Tech Ltd.
    0x128E: {0x0008: "ST128 WSS/SB",
             0x0009: "ST128 SAM9407",
             0x000A: "ST128 Game Port",
             0x000B: "ST128 MPU Port",
             0x000C: "ST128 Ctrl Port",
             },

    # Imagenation Corporation
    0x1295: {0x0800: "PXR800",
             0x1000: "PXD1000",
             },

    # VMetro, inc.
    0x129A: {0x0615: "PBT-615 PCI-X Bus Analyzer",
             0x0715: "cPCI Bus Analyzer",
             0x1100: "PMC-FPGA05",
             0x1106: "XMC-FPGA05F, PCI interface",
             0x1107: "XMC-FPGA05F, PCIe interface",
             0x1108: "XMC-FPGA05D, PCI interface",
             0x1109: "XMC-FPGA05D, PCIe interface",
             },

    # YUAN High-Tech Development Co., Ltd.
    0x12AB: {0x0000: "MPG160/Kuroutoshikou ITVC15-STVLP",
             0x0002: "AU8830 [Vortex2] Based Sound Card With A3D Support",
             0x0003: "T507 (DVB-T) TV tuner/capture device",
             0x2300: "Club-3D Zap TV2100",
             0x3000: "MPG-200C PCI DVD Decoder Card",
             0x4789: "MPC788 MiniPCI Hybrid TV Tuner",
             0xFFF3: "MPG600/Kuroutoshikou ITVC16-STVLP",
             0xFFFF: "MPG600/Kuroutoshikou ITVC16-STVLP",
             },

    # Alteon Networks Inc.
    0x12AE: {0x0001: "AceNIC Gigabit Ethernet",
             0x0002: "AceNIC Gigabit Ethernet (Copper)",
             0x00FA: "Farallon PN9100-T Gigabit Ethernet",
             },

    # 3Com Corp, Modem Division
    0x12B9: {0x1006: "WinModem",
             0x1007: "USR 56k Internal WinModem",
             0x1008: "56K FaxModem Model 5610",
             },

    # Anchor Chips Inc.
    0x12BE: {0x3041: "AN3041Q CO-MEM",
             0x3042: "AN3042Q CO-MEM Lite",
             },

    # Holtek Microelectronics Inc
    0x12C3: {0x0058: "PCI NE2K Ethernet",
             0x5598: "PCI NE2K Ethernet",
             },

    # Connect Tech Inc
    0x12C4: {0x0001: "Blue HEAT/PCI 8 (RS232/CL/RJ11)",
             0x0002: "Blue HEAT/PCI 4 (RS232)",
             0x0003: "Blue HEAT/PCI 2 (RS232)",
             0x0004: "Blue HEAT/PCI 8 (UNIV, RS485)",
             0x0005: "Blue HEAT/PCI 4+4/6+2 (UNIV, RS232/485)",
             0x0006: "Blue HEAT/PCI 4 (OPTO, RS485)",
             0x0007: "Blue HEAT/PCI 2+2 (RS232/485)",
             0x0008: "Blue HEAT/PCI 2 (OPTO, Tx, RS485)",
             0x0009: "Blue HEAT/PCI 2+6 (RS232/485)",
             0x000A: "Blue HEAT/PCI 8 (Tx, RS485)",
             0x000B: "Blue HEAT/PCI 4 (Tx, RS485)",
             0x000C: "Blue HEAT/PCI 2 (20 MHz, RS485)",
             0x000D: "Blue HEAT/PCI 2 PTM",
             0x0100: "NT960/PCI",
             0x0201: "cPCI Titan - 2 Port",
             0x0202: "cPCI Titan - 4 Port",
             0x0300: "CTI PCI UART 2 (RS232)",
             0x0301: "CTI PCI UART 4 (RS232)",
             0x0302: "CTI PCI UART 8 (RS232)",
             0x0310: "CTI PCI UART 1+1 (RS232/485)",
             0x0311: "CTI PCI UART 2+2 (RS232/485)",
             0x0312: "CTI PCI UART 4+4 (RS232/485)",
             0x0320: "CTI PCI UART 2",
             0x0321: "CTI PCI UART 4",
             0x0322: "CTI PCI UART 8",
             0x0330: "CTI PCI UART 2 (RS485)",
             0x0331: "CTI PCI UART 4 (RS485)",
             0x0332: "CTI PCI UART 8 (RS485)",
             },

    # Picture Elements Incorporated
    0x12C5: {0x007E: "Imaging/Scanning Subsystem Engine",
             0x007F: "Imaging/Scanning Subsystem Engine",
             0x0081: "PCIVST [Grayscale Thresholding Engine]",
             0x0085: "Video Simulator/Sender",
             0x0086: "THR2 Multi-scale Thresholder",
             },

    # Dialogic Corp
    0x12C7: {0x0546: "Springware D/120JCT-LS",
             0x0647: "Springware D/240JCT-T1",
             0x0676: "Springware D/41JCT-LS",
             0x0685: "Springware D/480JCT-2T1",
             },

    # Antex Electronics Corporation
    0x12CB: {0x0027: "SC4 (StudioCard)",
             0x002E: "StudioCard 2000",
             },

    # NVidia / SGS Thomson (Joint Venture)
    0x12D2: {0x0008: "NV1",
             0x0009: "DAC64",
             0x0018: "Riva128",
             0x0019: "Riva128ZX",
             0x0020: "TNT",
             0x0028: "TNT2",
             0x0029: "UTNT2",
             0x002C: "VTNT2",
             0x00A0: "ITNT2",
             },

    # Equator Technologies Inc
    0x12D5: {0x0003: "BSP16",
             0x1000: "BSP15",
             },

    # Pericom Semiconductor
    0x12D8: {0x01A7: "7C21P100 2-port PCI-X to PCI-X Bridge",
             0x0303: "PCI Express Switch 3-3",
             0x0508: "PI7C9X20508GP PCI Express Switch 5Port-8Lane",
             0x2304: "PI7C9X2G304 EL/SL PCIe2 3-Port/4-Lane Packet Switch",
             0x2308: "PI7C9X2G308GP 8-lane PCI Express 2.0 Switch with 3 PCI Express ports",
             0x2404: "PI7C9X2G404 EL/SL PCIe2 4-Port/4-Lane Packet Switch",
             0x2608: "PI7C9X2G608GP PCIe2 6-Port/8-Lane Packet Switch",
             0x400A: "PI7C9X442SL PCI Express Bridge Port",
             0x400E: "PI7C9X442SL USB OHCI Controller",
             0x400F: "PI7C9X442SL USB EHCI Controller",
             0x71E2: "PI7C7300A/PI7C7300D PCI-to-PCI Bridge",
             0x71E3: "PI7C7300A/PI7C7300D PCI-to-PCI Bridge (Secondary Bus 2)",
             0x8140: "PI7C8140A PCI-to-PCI Bridge",
             0x8148: "PI7C8148A/PI7C8148B PCI-to-PCI Bridge",
             0x8150: "PCI to PCI Bridge",
             0x8152: "PI7C8152A/PI7C8152B/PI7C8152BI PCI-to-PCI Bridge",
             0x8154: "PI7C8154A/PI7C8154B/PI7C8154BI PCI-to-PCI Bridge",
             0x8619: "PI7C9X2G1616PR PCIe2 16-Port/16-Lane Packet Switch",
             0xE110: "PI7C9X110 PCI Express to PCI bridge",
             0xE111: "PI7C9X111SL PCIe-to-PCI Reversible Bridge",
             0xE130: "PCI Express to PCI-XPI7C9X130 PCI-X Bridge",
             },

    # Aculab PLC
    0x12D9: {0x0002: "PCI Prosody",
             0x0004: "cPCI Prosody",
             0x0005: "Aculab E1/T1 PCI card",
             0x1078: "Prosody X class e1000 device",
             },

    # Chase Research
    0x12E0: {0x0010: "ST16C654 Quad UART",
             0x0020: "ST16C654 Quad UART",
             0x0030: "ST16C654 Quad UART",
             },

    # Aureal Semiconductor
    0x12EB: {0x0001: "Vortex 1",
             0x0002: "Vortex 2",
             0x0003: "AU8810 Vortex Digital Audio Processor",
             0x8803: "Vortex 56k Software Modem",
             },

    # Spectrum Signal Processing
    0x12FB: {0x0001: "PMC-MAI",
             0x00F5: "F5 Dakar",
             0x02AD: "PMC-2MAI",
             0x2ADC: "ePMC-2ADC",
             0x3100: "PRO-3100",
             0x3500: "PRO-3500",
             0x4D4F: "Modena",
             0x8120: "ePMC-8120",
             0xDA62: "Daytona C6201 PCI (Hurricane)",
             0xDB62: "Ingliston XBIF",
             0xDC62: "Ingliston PLX9054",
             0xDD62: "Ingliston JTAG/ISP",
             0xEDDC: "ePMC-MSDDC",
             0xFA01: "ePMC-FPGA",
             },

    # Measurement Computing
    0x1307: {0x0001: "PCI-DAS1602/16",
             0x000B: "PCI-DIO48H",
             0x000C: "PCI-PDISO8",
             0x000D: "PCI-PDISO16",
             0x000F: "PCI-DAS1200",
             0x0010: "PCI-DAS1602/12",
             0x0014: "PCI-DIO24H",
             0x0015: "PCI-DIO24H/CTR3",
             0x0016: "PCI-DIO48H/CTR15",
             0x0017: "PCI-DIO96H",
             0x0018: "PCI-CTR05",
             0x0019: "PCI-DAS1200/JR",
             0x001A: "PCI-DAS1001",
             0x001B: "PCI-DAS1002",
             0x001C: "PCI-DAS1602JR/16",
             0x001D: "PCI-DAS6402/16",
             0x001E: "PCI-DAS6402/12",
             0x001F: "PCI-DAS16/M1",
             0x0020: "PCI-DDA02/12",
             0x0021: "PCI-DDA04/12",
             0x0022: "PCI-DDA08/12",
             0x0023: "PCI-DDA02/16",
             0x0024: "PCI-DDA04/16",
             0x0025: "PCI-DDA08/16",
             0x0026: "PCI-DAC04/12-HS",
             0x0027: "PCI-DAC04/16-HS",
             0x0028: "PCI-DIO24",
             0x0029: "PCI-DAS08",
             0x002C: "PCI-INT32",
             0x0033: "PCI-DUAL-AC5",
             0x0034: "PCI-DAS-TC",
             0x0035: "PCI-DAS64/M1/16",
             0x0036: "PCI-DAS64/M2/16",
             0x0037: "PCI-DAS64/M3/16",
             0x004C: "PCI-DAS1000",
             0x004D: "PCI-QUAD04",
             0x0052: "PCI-DAS4020/12",
             0x0053: "PCIM-DDA06/16",
             0x0054: "PCI-DIO96",
             0x005D: "PCI-DAS6023",
             0x005E: "PCI-DAS6025",
             0x005F: "PCI-DAS6030",
             0x0060: "PCI-DAS6031",
             0x0061: "PCI-DAS6032",
             0x0062: "PCI-DAS6033",
             0x0063: "PCI-DAS6034",
             0x0064: "PCI-DAS6035",
             0x0065: "PCI-DAS6040",
             0x0066: "PCI-DAS6052",
             0x0067: "PCI-DAS6070",
             0x0068: "PCI-DAS6071",
             0x006F: "PCI-DAS6036",
             0x0070: "PCI-DAC6702",
             0x0078: "PCI-DAS6013",
             0x0079: "PCI-DAS6014",
             0x0115: "PCIe-DAS1602/16",
             },

    # ADMtek
    0x1317: {0x0981: "21x4x DEC-Tulip compatible 10/100 Ethernet",
             0x0985: "NC100 Network Everywhere Fast Ethernet 10/100",
             0x1985: "21x4x DEC-Tulip compatible 10/100 Ethernet",
             0x2850: "HSP MicroModem 56",
             0x5120: "ADM5120 OpenGate System-on-Chip",
             0x8201: "ADM8211 802.11b Wireless Interface",
             0x8211: "ADM8211 802.11b Wireless Interface",
             0x9511: "21x4x DEC-Tulip compatible 10/100 Ethernet",
             },

    # Fortemedia, Inc
    0x1319: {0x0801: "Xwave QS3000A [FM801]",
             0x0802: "Xwave QS3000A [FM801 game port]",
             0x1000: "FM801 PCI Audio",
             0x1001: "FM801 PCI Joystick",
             },

    # Siig Inc
    0x131F: {0x1000: "CyberSerial (1-port) 16550",
             0x1001: "CyberSerial (1-port) 16650",
             0x1002: "CyberSerial (1-port) 16850",
             0x1010: "Duet 1S(16550)+1P",
             0x1011: "Duet 1S(16650)+1P",
             0x1012: "Duet 1S(16850)+1P",
             0x1020: "CyberParallel (1-port)",
             0x1021: "CyberParallel (2-port)",
             0x1030: "CyberSerial (2-port) 16550",
             0x1031: "CyberSerial (2-port) 16650",
             0x1032: "CyberSerial (2-port) 16850",
             0x1034: "Trio 2S(16550)+1P",
             0x1035: "Trio 2S(16650)+1P",
             0x1036: "Trio 2S(16850)+1P",
             0x1050: "CyberSerial (4-port) 16550",
             0x1051: "CyberSerial (4-port) 16650",
             0x1052: "CyberSerial (4-port) 16850",
             0x2000: "CyberSerial (1-port) 16550",
             0x2001: "CyberSerial (1-port) 16650",
             0x2002: "CyberSerial (1-port) 16850",
             0x2010: "Duet 1S(16550)+1P",
             0x2011: "Duet 1S(16650)+1P",
             0x2012: "Duet 1S(16850)+1P",
             0x2020: "CyberParallel (1-port)",
             0x2021: "CyberParallel (2-port)",
             0x2030: "CyberSerial (2-port) 16550",
             0x2031: "CyberSerial (2-port) 16650",
             0x2032: "CyberSerial (2-port) 16850",
             0x2040: "Trio 1S(16550)+2P",
             0x2041: "Trio 1S(16650)+2P",
             0x2042: "Trio 1S(16850)+2P",
             0x2050: "CyberSerial (4-port) 16550",
             0x2051: "CyberSerial (4-port) 16650",
             0x2052: "CyberSerial (4-port) 16850",
             0x2060: "Trio 2S(16550)+1P",
             0x2061: "Trio 2S(16650)+1P",
             0x2062: "Trio 2S(16850)+1P",
             0x2081: "CyberSerial (8-port) ST16654",
             },

    # RadiSys Corporation
    0x1331: {0x0030: "ENP-2611",
             0x8200: "82600 Host Bridge",
             0x8201: "82600 IDE",
             0x8202: "82600 USB",
             0x8210: "82600 PCI Bridge",
             },

    # Micro Memory
    0x1332: {0x5415: "MM-5415CN PCI Memory Module with Battery Backup",
             0x5425: "MM-5425CN PCI 64/66 Memory Module with Battery Backup",
             0x6140: "MM-6140D",
             },

    # Micron Technology Inc
    0x1344: {0x5150: "RealSSD P320h",
             0x5151: "RealSSD P320m",
             0x5152: "RealSSD P320s",
             0x5153: "RealSSD P325m",
             0x5160: "RealSSD P420h",
             0x5161: "RealSSD P420m",
             0x5163: "RealSSD P425m",
             0x5180: "9100 PRO NVMe SSD",
             0x5181: "9100 MAX NVMe SSD",
             0x5190: "9200 ECO NVMe SSD",
             0x5191: "9200 PRO NVMe SSD",
             0x5192: "9200 MAX NVMe SSD",
             0x51A2: "7300 PRO NVMe SSD",
             0x51A3: "7300 MAX NVMe SSD",
             0x51B1: "9300 PRO NVMe SSD",
             0x51B2: "9300 MAX NVMe SSD",
             0x51C0: "7400 PRO NVMe SSD",
             0x51C1: "7400 MAX NVMe SSD",
             0x51C3: "7450 PRO NVMe SSD",
             0x51C4: "7450 MAX NVMe SSD",
             },

    # DTC Technology Corp.
    0x134A: {0x0001: "Domex 536",
             0x0002: "Domex DMX3194UP SCSI Adapter",
             },

    # PCTel Inc
    0x134D: {0x2189: "HSP56 MicroModem",
             0x2486: "2304WT V.92 MDC Modem",
             0x7890: "HSP MicroModem 56",
             0x7891: "HSP MicroModem 56",
             0x7892: "HSP MicroModem 56",
             0x7893: "HSP MicroModem 56",
             0x7894: "HSP MicroModem 56",
             0x7895: "HSP MicroModem 56",
             0x7896: "HSP MicroModem 56",
             0x7897: "HSP MicroModem 56",
             },

    # dbeeSet Technology
    0x1353: {0x0002: "Proserver",
             0x0003: "PCI-FUT",
             0x0004: "PCI-S0",
             0x0005: "PCI-FUT-S0",
             0x0006: "OTDU-1U (FPGA Zynq-7000)",
             0x0007: "OTDU-EX",
             },

    # Quatech Inc
    0x135C: {0x0010: "QSC-100",
             0x0020: "DSC-100",
             0x0030: "DSC-200/300",
             0x0040: "QSC-200/300",
             0x0050: "ESC-100D",
             0x0060: "ESC-100M",
             0x00F0: "MPAC-100 Synchronous Serial Card (Zilog 85230)",
             0x0170: "QSCLP-100",
             0x0180: "DSCLP-100",
             0x0190: "SSCLP-100",
             0x01A0: "QSCLP-200/300",
             0x01B0: "DSCLP-200/300",
             0x01C0: "SSCLP-200/300",
             0x0258: "DSPSX-200/300",
             },

    # Sealevel Systems Inc
    0x135E: {0x5101: "Route 56.PCI - Multi-Protocol Serial Interface (Zilog Z16C32)",
             0x7101: "Single Port RS-232/422/485/530",
             0x7201: "Dual Port RS-232/422/485 Interface",
             0x7202: "Dual Port RS-232 Interface",
             0x7401: "Four Port RS-232 Interface",
             0x7402: "Four Port RS-422/485 Interface",
             0x7801: "Eight Port RS-232 Interface",
             0x7804: "Eight Port RS-232/422/485 Interface",
             0x8001: "8001 Digital I/O Adapter",
             },

    # Meinberg Funkuhren
    0x1360: {0x0101: "PCI32 DCF77 Radio Clock",
             0x0102: "PCI509 DCF77 Radio Clock",
             0x0103: "PCI510 DCF77 Radio Clock",
             0x0104: "PCI511 DCF77 Radio Clock",
             0x0105: "PEX511 DCF77 Radio Clock (PCI Express)",
             0x0106: "PZF180PEX High Precision DCF77 Radio Clock (PCI Express)",
             0x0201: "GPS167PCI GPS Receiver",
             0x0202: "GPS168PCI GPS Receiver",
             0x0203: "GPS169PCI GPS Receiver",
             0x0204: "GPS170PCI GPS Receiver",
             0x0205: "GPS170PEX GPS Receiver (PCI Express)",
             0x0206: "GPS180PEX GPS Receiver (PCI Express)",
             0x0207: "GLN180PEX GPS/GLONASS receiver (PCI Express)",
             0x0208: "GPS180AMC GPS Receiver (PCI Express / MicroTCA / AdvancedMC)",
             0x0209: "GNS181PEX GPS/Galileo/GLONASS/BEIDOU receiver (PCI Express)",
             0x0301: "TCR510PCI IRIG Timecode Reader",
             0x0302: "TCR167PCI IRIG Timecode Reader",
             0x0303: "TCR511PCI IRIG Timecode Reader",
             0x0304: "TCR511PEX IRIG Timecode Reader (PCI Express)",
             0x0305: "TCR170PEX IRIG Timecode Reader (PCI Express)",
             0x0306: "TCR180PEX IRIG Timecode Reader (PCI Express)",
             0x0501: "PTP270PEX PTP/IEEE1588 slave card (PCI Express)",
             0x0601: "FRC511PEX Free Running Clock (PCI Express)",
             },

    # High Soft Tech
    0x136A: {0x0004: "HST Saphir VII mini PCI",
             0x0007: "HST Saphir III E MultiLink 4",
             0x0008: "HST Saphir III E MultiLink 8",
             0x000A: "HST Saphir III E MultiLink 2",
             },

    # Silicom Ltd.
    0x1374: {0x0024: "Silicom Dual port Giga Ethernet BGE Bypass Server Adapter",
             0x0025: "Silicom Quad port Giga Ethernet BGE Bypass Server Adapter",
             0x0026: "Silicom Dual port Fiber Giga Ethernet 546 Bypass Server Adapter",
             0x0027: "Silicom Dual port Fiber LX Giga Ethernet 546 Bypass Server Adapter",
             0x0029: "Silicom Dual port Copper Giga Ethernet 546GB Bypass Server Adapter",
             0x002A: "Silicom Dual port Fiber Giga Ethernet 546 TAP/Bypass Server Adapter",
             0x002B: "Silicom Dual port Copper Fast Ethernet 546 TAP/Bypass Server Adapter (PXE2TBI)",
             0x002C: "Silicom Quad port Copper Giga Ethernet 546GB Bypass Server Adapter (PXG4BPI)",
             0x002D: "Silicom Quad port Fiber-SX Giga Ethernet 546GB Bypass Server Adapter (PXG4BPFI)",
             0x002E: "Silicom Quad port Fiber-LX Giga Ethernet 546GB Bypass Server Adapter (PXG4BPFI-LX)",
             0x002F: "Silicom Dual port Fiber-SX Giga Ethernet 546GB Low profile Bypass Server Adapter (PXG2BPFIL)",
             0x0030: "Silicom Dual port Fiber-LX Giga Ethernet 546GB Low profile Bypass Server Adapter",
             0x0031: "Silicom Quad port Copper Giga Ethernet PCI-E Bypass Server Adapter",
             0x0032: "Silicom Dual port Copper Fast Ethernet 546 TAP/Bypass Server Adapter",
             0x0034: "Silicom Dual port Copper Giga Ethernet PCI-E BGE Bypass Server Adapter",
             0x0035: "Silicom Quad port Copper Giga Ethernet PCI-E BGE Bypass Server Adapter",
             0x0036: "Silicom Dual port Fiber Giga Ethernet PCI-E BGE Bypass Server Adapter",
             0x0037: "Silicom Dual port Copper Ethernet PCI-E Intel based Bypass Server Adapter",
             0x0038: "Silicom Quad port Copper Ethernet PCI-E Intel based Bypass Server Adapter",
             0x0039: "Silicom Dual port Fiber-SX Ethernet PCI-E Intel based Bypass Server Adapter",
             0x003A: "Silicom Dual port Fiber-LX Ethernet PCI-E Intel based Bypass Server Adapter",
             0x003B: "Silicom Dual port Fiber Ethernet PMC Intel based Bypass Server Adapter (PMCX2BPFI)",
             0x003C: "Silicom Dual port Copper Ethernet PCI-X BGE based Bypass Server Adapter (PXG2BPRB)",
             0x003D: "2-port Copper GBE Bypass with Caviume 1010 PCI-X",
             0x003E: "Silicom Dual port Fiber Giga Ethernet PCI-E 571 TAP/Bypass Server Adapter (PEG2TBFI)",
             0x003F: "Silicom Dual port Copper Giga Ethernet PCI-X 546 TAP/Bypass Server Adapter (PXG2TBI)",
             0x0040: "Silicom Quad port Fiber-SX Giga Ethernet 571 Bypass Server Adapter (PEG4BPFI)",
             0x0042: "4-port Copper GBE PMC-X Bypass",
             0x0043: "Silicom Quad port Fiber-SX Giga Ethernet 546 Bypass Server Adapter (PXG4BPFID)",
             0x0045: "Silicom 6 port Copper Giga Ethernet 546 Bypass Server Adapter (PXG6BPI)",
             0x0046: "4-port bypass PCI-E w disconnect low profile",
             0x0047: "Silicom Dual port Fiber-SX Giga Ethernet 571 Bypass Disconnect Server Adapter (PEG2BPFID)",
             0x004A: "Silicom Quad port Fiber-LX Giga Ethernet 571 Bypass Server Adapter (PEG4BPFI-LX)",
             0x004D: "Dual port Copper Giga Ethernet PCI-E Bypass Server Adapter",
             0x0401: "Gigabit Ethernet ExpressModule Bypass Server Adapter",
             0x0420: "Gigabit Ethernet ExpressModule Bypass Server Adapter",
             0x0460: "Gigabit Ethernet Express Module Bypass Server Adapter",
             0x0461: "Gigabit Ethernet ExpressModule Bypass Server Adapter",
             0x0462: "Gigabit Ethernet ExpressModule Bypass Server Adapter",
             0x0470: "Octal-port Copper Gigabit Ethernet Express Module Bypass Server Adapter",
             0x0482: "Dual-port Fiber (SR) 10 Gigabit Ethernet ExpressModule Bypass Server Adapter",
             0x0483: "Dual-port Fiber (LR) 10 Gigabit Ethernet ExpressModule Bypass Server Adapter",
             },

    # Marian - Electronic & Software
    0x1382: {0x0001: "ARC88 audio recording card",
             0x2008: "Prodif 96 Pro sound system",
             0x2048: "Prodif Plus sound system",
             0x2088: "Marc 8 Midi sound system",
             0x20C8: "Marc A sound system",
             0x4008: "Marc 2 sound system",
             0x4010: "Marc 2 Pro sound system",
             0x4048: "Marc 4 MIDI sound system",
             0x4088: "Marc 4 Digi sound system",
             0x4248: "Marc X sound system",
             0x4424: "TRACE D4 Sound System",
             },

    # Netgear
    0x1385: {0x006B: "WA301 802.11b Wireless PCI Adapter",
             0x4100: "MA301 802.11b Wireless PCI Adapter",
             0x4601: "WAG511 802.11a/b/g Dual Band Wireless PC Card",
             0x620A: "GA620 Gigabit Ethernet",
             0x630A: "GA630 Gigabit Ethernet",
             },

    # Moxa Technologies Co Ltd
    0x1393: {0x0001: "UC7000 Serial",
             0x1020: "CP-102 (2-port RS-232 PCI)",
             0x1021: "CP-102UL (2-port RS-232 Universal PCI)",
             0x1022: "CP-102U (2-port RS-232 Universal PCI)",
             0x1023: "CP-102UF",
             0x1024: "CP-102E (2-port RS-232 Smart PCI Express Serial Board)",
             0x1025: "CP-102EL (2-port RS-232 Smart PCI Express Serial Board)",
             0x1040: "Smartio C104H/PCI",
             0x1041: "CP104U (4-port RS-232 Universal PCI)",
             0x1042: "CP104JU (4-port RS-232 Universal PCI)",
             0x1043: "CP104EL (4-port RS-232 Smart PCI Express)",
             0x1044: "POS104UL (4-port RS-232 Universal PCI)",
             0x1045: "CP-104EL-A (4-port RS-232 PCI Express Serial Board)",
             0x1080: "CB108 (8-port RS-232 PC/104-plus Module)",
             0x1140: "CT-114 series",
             0x1141: "Industrio CP-114",
             0x1142: "CB114 (4-port RS-232/422/485 PC/104-plus Module)",
             0x1143: "CP-114UL (4-port RS-232/422/485 Smart Universal PCI Serial Board)",
             0x1144: "CP-114EL (4-port RS-232/422/485 Smart PCI Express Serial Board)",
             0x1180: "CP118U (8-port RS-232/422/485 Smart Universal PCI)",
             0x1181: "CP118EL (8-port RS-232/422/485 Smart PCI Express)",
             0x1182: "CP-118EL-A (8-port RS-232/422/485 PCI Express Serial Board)",
             0x1320: "CP132 (2-port RS-422/485 PCI)",
             0x1321: "CP132U (2-Port RS-422/485 Universal PCI)",
             0x1322: "CP-132EL (2-port RS-422/485 Smart PCI Express Serial Board)",
             0x1340: "CP134U (4-Port RS-422/485 Universal PCI)",
             0x1341: "CB134I (4-port RS-422/485 PC/104-plus Module)",
             0x1380: "CP138U (8-port RS-232/422/485 Smart Universal PCI)",
             0x1680: "Smartio C168H/PCI",
             0x1681: "CP-168U V2 Smart Serial Board (8-port RS-232)",
             0x1682: "CP-168EL (8-port RS-232 Smart PCI Express)",
             0x1683: "CP-168EL-A (8-port RS-232 PCI Express Serial Board)",
             0x2040: "Intellio CP-204J",
             0x2180: "Intellio C218 Turbo PCI",
             0x3200: "Intellio C320 Turbo PCI",
             },

    # Cologne Chip Designs GmbH
    0x1397: {0x08B4: "ISDN network Controller [HFC-4S]",
             0x16B8: "ISDN network Controller [HFC-8S]",
             0x2BD0: "ISDN network controller [HFC-PCI]",
             0x30B1: "ISDN network Controller [HFC-E1]",
             0xB700: "ISDN network controller PrimuX S0 [HFC-PCI]",
             0xF001: "GSM Network Controller [HFC-4GSM]",
             },

    # Alacritech Inc
    0x139A: {0x0001: "Quad Port 10/100 Server Accelerator",
             0x0003: "Single Port 10/100 Server Accelerator",
             0x0005: "Single Port Gigabit Server Accelerator",
             },

    # Hifn Inc.
    0x13A3: {0x0005: "7751 Security Processor",
             0x0006: "6500 Public Key Processor",
             0x0007: "7811 Security Processor",
             0x0012: "7951 Security Processor",
             0x0014: "78XX Security Processor",
             0x0016: "8065 Security Processor",
             0x0017: "8165 Security Processor",
             0x0018: "8154 Security Processor",
             0x001D: "7956 Security Processor",
             0x001F: "7855 Security Processor",
             0x0020: "7955 Security Processor",
             0x0026: "8155 Security Processor",
             0x002E: "9630 Compression Processor",
             0x002F: "9725 Compression and Security Processor",
             0x0033: "8201 Acceleration Processor",
             0x0034: "8202 Acceleration Processor",
             0x0035: "8203 Acceleration Processor",
             0x0037: "8204 Acceleration Processor",
             0x9240: "XR9240 Compression and Security Coprocessor [Panther II]",
             },

    # Exar Corp.
    0x13A8: {0x0152: "XR17C/D152 Dual PCI UART",
             0x0154: "XR17C154 Quad UART",
             0x0158: "XR17C158 Octal UART",
             0x0252: "XR17V252 Dual UART PCI controller",
             0x0254: "XR17V254 Quad UART PCI controller",
             0x0258: "XR17V258 Octal UART PCI controller",
             0x0352: "XR17V3521 Dual PCIe UART",
             },

    # Microgate Corporation
    0x13C0: {0x0010: "SyncLink Adapter v1",
             0x0020: "SyncLink SCC Adapter",
             0x0030: "SyncLink Multiport Adapter",
             0x0070: "SyncLink GT Adapter",
             0x0080: "SyncLink GT4 Adapter",
             0x00A0: "SyncLink GT2 Adapter",
             0x0210: "SyncLink Adapter v2",
             },

    # 3ware Inc
    0x13C1: {0x1000: "5xxx/6xxx-series PATA-RAID",
             0x1001: "7xxx/8xxx-series PATA/SATA-RAID",
             0x1002: "9xxx-series SATA-RAID",
             0x1003: "9550SX SATA-II RAID PCI-X",
             0x1004: "9650SE SATA-II RAID PCIe",
             0x1005: "9690SA SAS/SATA-II RAID PCIe",
             0x1010: "9750 SAS2/SATA-II RAID PCIe",
             },

    # Technotrend Systemtechnik GmbH
    0x13C2: {0x000E: "Technotrend/Hauppauge DVB card rev2.3",
             0x1019: "TTechnoTrend-budget DVB S2-3200",
             },

    # Condor Engineering Inc
    0x13C6: {0x0520: "CEI-520 A429 Card",
             0x0620: "CEI-620 A429 Card",
             0x0820: "CEI-820 A429 Card",
             0x0830: "CEI-830 A429 Card",
             0x1004: "P-SER Multi-channel PMC to RS-485/422/232 adapter",
             },

    # Blue Chip Technology Ltd
    0x13C7: {0x0ADC: "PCI-ADC",
             0x0B10: "PCI-PIO",
             0x0D10: "PCI-DIO",
             0x524C: "PCI-RLY",
             0x5744: "PCI-WDT",
             },

    # Techsan Electronics Co Ltd
    0x13D0: {0x2103: "B2C2 FlexCopII DVB chip / Technisat SkyStar2 DVB card",
             0x2104: "B2C2 FlexCopIII DVB chip / Technisat SkyStar2 DVB card (rev 01)",
             0x2200: "B2C2 FlexCopIII DVB chip / Technisat SkyStar2 DVB card",
             },

    # Abocom Systems Inc
    0x13D1: {0xAB02: "ADMtek Centaur-C rev 17 [D-Link DFE-680TX] CardBus Fast Ethernet Adapter",
             0xAB03: "21x4x DEC-Tulip compatible 10/100 Ethernet",
             0xAB06: "RTL8139 [FE2000VX] CardBus Fast Ethernet Attached Port Adapter",
             0xAB08: "21x4x DEC-Tulip compatible 10/100 Ethernet",
             },

    # Sundance Technology Inc / IC Plus Corp
    0x13F0: {0x0200: "IC Plus IP100A Integrated 10/100 Ethernet MAC + PHY",
             0x0201: "ST201 Sundance Ethernet",
             0x1021: "TC902x Gigabit Ethernet",
             0x1023: "IP1000 Family Gigabit Ethernet",
             },

    # C-Media Electronics Inc
    0x13F6: {0x0011: "CMI8738",
             0x0100: "CM8338A",
             0x0101: "CM8338B",
             0x0111: "CMI8738/CMI8768 PCI Audio",
             0x0211: "CM8738",
             0x5011: "CM8888 [Oxygen Express]",
             0x8788: "CMI8788 [Oxygen HD Audio]",
             },

    # Advantech Co. Ltd
    0x13FE: {0x1240: "PCI-1240 4-channel stepper motor controller card",
             0x1600: "PCI-16xx series PCI multiport serial board (function 0)",
             0x1603: "PCI-1603 2-port isolated RS-232/current loop",
             0x1604: "PCI-1604 2-port RS-232",
             0x1680: "PCI-1680 Rev.A1 2-port CAN-bus with isolation protection",
             0x16FF: "PCI-16xx series PCI multiport serial board (function 1: RX/TX steering CPLD)",
             0x1711: "PCI-1711 16-channel data acquisition card 12-bit, 100kS/s",
             0x1713: "PCI-1713 32-channel isolated analog input card",
             0x1733: "PCI-1733 32-channel isolated digital input card",
             0x1734: "PCI-1734 32-channel isolated digital output card",
             0x1752: "PCI-1752 64-channel Isolated Digital Output Card",
             0x1754: "PCI-1754 64-channel Isolated Digital Input Card",
             0x1756: "PCI-1756 64-ch Isolated Digital I/O PCI Card",
             0xA004: "PCI-1612 4-port RS-232/422/485",
             0xC302: "MIOe-3680 2-Port CAN-Bus MIOe Module with Isolation Protection",
             },

    # Meilhaus Electronic GmbH
    0x1402: {0x0630: "ME-630",
             0x0940: "ME-94",
             0x0950: "ME-95",
             0x0960: "ME-96",
             0x1000: "ME-1000",
             0x100A: "ME-1000",
             0x100B: "ME-1000",
             0x1400: "ME-1400",
             0x140A: "ME-1400A",
             0x140B: "ME-1400B",
             0x140C: "ME-1400C",
             0x140D: "ME-1400D",
             0x140E: "ME-1400E",
             0x14EA: "ME-1400EA",
             0x14EB: "ME-1400EB",
             0x1604: "ME-1600/4U",
             0x1608: "ME-1600/8U",
             0x160C: "ME-1600/12U",
             0x160F: "ME-1600/16U",
             0x168F: "ME-1600/16U8I",
             0x4610: "ME-4610",
             0x4650: "ME-4650",
             0x4660: "ME-4660",
             0x4661: "ME-4660I",
             0x4662: "ME-4660",
             0x4663: "ME-4660I",
             0x4670: "ME-4670",
             0x4671: "ME-4670I",
             0x4672: "ME-4670S",
             0x4673: "ME-4670IS",
             0x4680: "ME-4680",
             0x4681: "ME-4680I",
             0x4682: "ME-4680S",
             0x4683: "ME-4680IS",
             0x6004: "ME-6000/4",
             0x6008: "ME-6000/8",
             0x600F: "ME-6000/16",
             0x6014: "ME-6000I/4",
             0x6018: "ME-6000I/8",
             0x601F: "ME-6000I/16",
             0x6034: "ME-6000ISLE/4",
             0x6038: "ME-6000ISLE/8",
             0x603F: "ME-6000ISLE/16",
             0x6044: "ME-6000/4/DIO",
             0x6048: "ME-6000/8/DIO",
             0x604F: "ME-6000/16/DIO",
             0x6054: "ME-6000I/4/DIO",
             0x6058: "ME-6000I/8/DIO",
             0x605F: "ME-6000I/16/DIO",
             0x6074: "ME-6000ISLE/4/DIO",
             0x6078: "ME-6000ISLE/8/DIO",
             0x607F: "ME-6000ISLE/16/DIO",
             0x6104: "ME-6100/4",
             0x6108: "ME-6100/8",
             0x610F: "ME-6100/16",
             0x6114: "ME-6100I/4",
             0x6118: "ME-6100I/8",
             0x611F: "ME-6100I/16",
             0x6134: "ME-6100ISLE/4",
             0x6138: "ME-6100ISLE/8",
             0x613F: "ME-6100ISLE/16",
             0x6144: "ME-6100/4/DIO",
             0x6148: "ME-6100/8/DIO",
             0x614F: "ME-6100/16/DIO",
             0x6154: "ME-6100I/4/DIO",
             0x6158: "ME-6100I/8/DIO",
             0x615F: "ME-6100I/16/DIO",
             0x6174: "ME-6100ISLE/4/DIO",
             0x6178: "ME-6100ISLE/8/DIO",
             0x617F: "ME-6100ISLE/16/DIO",
             0x6259: "ME-6200I/9/DIO",
             0x6359: "ME-6300I/9/DIO",
             0x810A: "ME-8100A",
             0x810B: "ME-8100B",
             0x820A: "ME-8200A",
             0x820B: "ME-8200B",
             },

    # Lava Computer mfg Inc
    0x1407: {0x0100: "Lava Dual Serial",
             0x0101: "Lava Quatro A",
             0x0102: "Lava Quatro B",
             0x0110: "Lava DSerial-PCI Port A",
             0x0111: "Lava DSerial-PCI Port B",
             0x0120: "Quattro-PCI A",
             0x0121: "Quattro-PCI B",
             0x0180: "Lava Octo A",
             0x0181: "Lava Octo B",
             0x0200: "Lava Port Plus",
             0x0201: "Lava Quad A",
             0x0202: "Lava Quad B",
             0x0220: "Lava Quattro PCI Ports A/B",
             0x0221: "Lava Quattro PCI Ports C/D",
             0x0400: "Lava 8255-PIO-PCI",
             0x0500: "Lava Single Serial",
             0x0520: "Lava RS422-SS-PCI",
             0x0600: "Lava Port 650",
             0x8000: "Lava Parallel",
             0x8001: "Dual parallel port controller A",
             0x8002: "Lava Dual Parallel port A",
             0x8003: "Lava Dual Parallel port B",
             0x8800: "BOCA Research IOPPAR",
             },

    # Timedia Technology Co Ltd
    0x1409: {0x7168: "PCI2S550 (Dual 16550 UART)",
             0x7268: "SUN1888 (Dual IEEE1284 parallel port)",
             },

    # VIA Technologies Inc.
    0x1412: {0x1712: "ICE1712 [Envy24] PCI Multi-Channel I/O Controller",
             0x1724: "VT1720/24 [Envy24PT/HT] PCI Multi-Channel Audio Controller",
             },

    # Microsoft Corporation
    0x1414: {0x0001: "MN-120 (ADMtek Centaur-C based)",
             0x0002: "MN-130 (ADMtek Centaur-P based)",
             0x008C: "Basic Render Driver",
             0x008E: "Basic Render Driver",
             0x5353: "Hyper-V virtual VGA",
             0x5801: "XMA Decoder (Xenon)",
             0x5802: "SATA Controller - CdRom (Xenon)",
             0x5803: "SATA Controller - Disk (Xenon)",
             0x5804: "OHCI Controller 0 (Xenon)",
             0x5805: "EHCI Controller 0 (Xenon)",
             0x5806: "OHCI Controller 1 (Xenon)",
             0x5807: "EHCI Controller 1 (Xenon)",
             0x580A: "Fast Ethernet Adapter (Xenon)",
             0x580B: "Secure Flash Controller (Xenon)",
             0x580D: "System Management Controller (Xenon)",
             0x5811: "Xenos GPU (Xenon)",
             },

    # Oxford Semiconductor Ltd
    0x1415: {0x8401: "OX9162 Mode 1 (8-bit bus)",
             0x8403: "OX9162 Mode 0 (parallel port)",
             0x9500: "OX16PCI954 (Quad 16950 UART) function 0 (Disabled)",
             0x9501: "OX16PCI954 (Quad 16950 UART) function 0 (Uart)",
             0x9505: "OXuPCI952 (Dual 16C950 UART)",
             0x950A: "EXSYS EX-41092 Dual 16950 Serial adapter",
             0x950B: "OXCB950 Cardbus 16950 UART",
             0x9510: "OX16PCI954 (Quad 16950 UART) function 1 (Disabled)",
             0x9511: "OX16PCI954 (Quad 16950 UART) function 1 (8bit bus)",
             0x9512: "OX16PCI954 (Quad 16950 UART) function 1 (32bit bus)",
             0x9513: "OX16PCI954 (Quad 16950 UART) function 1 (parallel port)",
             0x9521: "OX16PCI952 (Dual 16950 UART)",
             0x9523: "OX16PCI952 Integrated Parallel Port",
             0xC000: "OXPCIe840 Parallel Port",
             0xC004: "OXPCIe840 Parallel Port",
             0xC006: "OXPCIe840 GPIO",
             0xC100: "OXPCIe952 Parallel Port",
             0xC101: "OXPCIe952 Legacy 950 UART",
             0xC104: "OXPCIe952 Parallel Port",
             0xC105: "OXPCIe952 Legacy 950 UART",
             0xC106: "OXPCIe952 GPIO",
             0xC108: "OXPCIe952 Parallel Port",
             0xC109: "OXPCIe952 Legacy 950 UART",
             0xC10C: "OXPCIe952 Parallel Port",
             0xC10D: "OXPCIe952 Legacy 950 UART",
             0xC10E: "OXPCIe952 GPIO",
             0xC110: "OXPCIe952 Parallel Port",
             0xC114: "OXPCIe952 Parallel Port",
             0xC118: "OXPCIe952 Parallel Port",
             0xC11B: "OXPCIe952 Native 950 UART",
             0xC11C: "OXPCIe952 Parallel Port",
             0xC11E: "OXPCIe952 GPIO",
             0xC11F: "OXPCIe952 Native 950 UART",
             0xC120: "OXPCIe952 Legacy 950 UART",
             0xC124: "OXPCIe952 Legacy 950 UART",
             0xC126: "OXPCIe952 GPIO",
             0xC128: "OXPCIe952 Legacy 950 UART",
             0xC12C: "OXPCIe952 Legacy 950 UART",
             0xC12E: "OXPCIe952 GPIO",
             0xC134: "OXPCIe952 GPIO",
             0xC138: "OXPCIe952 Native 950 UART",
             0xC13C: "OXPCIe952 GPIO",
             0xC13D: "OXPCIe952 Native 950 UART",
             0xC140: "OXPCIe952 Legacy 950 UART #1",
             0xC141: "OXPCIe952 Legacy 950 UART #2",
             0xC144: "OXPCIe952 Legacy 950 UART #1",
             0xC145: "OXPCIe952 Legacy 950 UART #2",
             0xC146: "OXPCIe952 GPIO",
             0xC148: "OXPCIe952 Legacy 950 UART #1",
             0xC149: "OXPCIe952 Legacy 950 UART #2",
             0xC14C: "OXPCIe952 Legacy 950 UART #1",
             0xC14D: "OXPCIe952 Legacy 950 UART #2",
             0xC14E: "OXPCIe952 GPIO",
             0xC154: "OXPCIe952 GPIO",
             0xC158: "OXPCIe952 Dual Native 950 UART",
             0xC15C: "OXPCIe952 GPIO",
             0xC15D: "OXPCIe952 Dual Native 950 UART",
             0xC204: "OXPCIe954 GPIO",
             0xC208: "OXPCIe954 Quad Native 950 UART",
             0xC20C: "OXPCIe954 GPIO",
             0xC20D: "OXPCIe954 Quad Native 950 UART",
             0xC304: "OXPCIe958 GPIO",
             0xC308: "OXPCIe958 Quad Native 950 UART",
             0xC30C: "OXPCIe958 GPIO",
             0xC30D: "OXPCIe958 Quad Native 950 UART",
             0xC530: "OXPCIe200 Dual OHCI USB Controller (ULPI/R-ULPI)",
             0xC531: "OXPCIe200 Dual EHCI USB Controller (ULPI/R-ULPI)",
             0xC534: "OXPCIe200 Dual OHCI USB Controller (ULPI/R-ULPI)",
             0xC535: "OXPCIe200 Dual EHCI USB Controller (ULPI/R-ULPI)",
             0xC536: "OXPCIe200 GPIO",
             0xC538: "OXPCIe200 Dual OHCI USB Controller (ULPI/R-ULPI)",
             0xC539: "OXPCIe200 Dual EHCI USB Controller (ULPI/R-ULPI)",
             0xC53B: "OXPCIe200 Native 950 UART",
             0xC53C: "OXPCIe200 Dual OHCI USB Controller (ULPI/R-ULPI)",
             0xC53D: "OXPCIe200 Dual EHCI USB Controller (ULPI/R-ULPI)",
             0xC53E: "OXPCIe200 GPIO",
             0xC53F: "OXPCIe200 Native 950 UART",
             0xC540: "OXPCIe200 Dual OHCI USB Controller (R-ULPI)",
             0xC541: "OXPCIe200 Dual EHCI USB Controller (R-ULPI)",
             0xC544: "OXPCIe200 Dual OHCI USB Controller (R-ULPI)",
             0xC545: "OXPCIe200 Dual EHCI USB Controller (R-ULPI)",
             0xC546: "OXPCIe200 GPIO",
             0xC548: "OXPCIe200 Dual OHCI USB Controller (R-ULPI)",
             0xC549: "OXPCIe200 Dual EHCI USB Controller (R-ULPI)",
             0xC54B: "OXPCIe200 Native 950 UART",
             0xC54C: "OXPCIe200 Dual OHCI USB Controller (R-ULPI)",
             0xC54D: "OXPCIe200 Dual EHCI USB Controller (R-ULPI)",
             0xC54E: "OXPCIe200 Dual GPIO",
             0xC54F: "OXPCIe200 Native 950 UART",
             0xC560: "OXPCIe200 Dual OHCI USB Controller (ULPI/analog)",
             0xC561: "OXPCIe200 EHCI USB Controller (ULPI)",
             0xC564: "OXPCIe200 Dual OHCI USB Controller (ULPI/analog)",
             0xC565: "OXPCIe200 EHCI USB Controller (ULPI)",
             0xC566: "OXPCIe200 GPIO",
             0xC568: "OXPCIe200 Dual OHCI USB Controller (ULPI/analog)",
             0xC569: "OXPCIe200 EHCI USB Controller (ULPI)",
             0xC56B: "OXPCIe200 Native 950 UART",
             0xC56C: "OXPCIe200 Dual OHCI USB Controller (ULPI/analog)",
             0xC56D: "OXPCIe200 EHCI USB Controller (ULPI)",
             0xC56E: "OXPCIe200 GPIO",
             0xC56F: "OXPCIe200 Native 950 UART",
             0xC570: "OXPCIe200 Dual OHCI USB Controller (R-ULPI/analog)",
             0xC571: "OXPCIe200 EHCI USB Controller (R-ULPI)",
             0xC574: "OXPCIe200 Dual OHCI USB Controller (R-ULPI/analog)",
             0xC575: "OXPCIe200 EHCI USB Controller (R-ULPI)",
             0xC576: "OXPCIe200 GPIO",
             0xC578: "OXPCIe200 Dual OHCI USB Controller (R-ULPI/analog)",
             0xC579: "OXPCIe200 EHCI USB Controller (R-ULPI)",
             0xC57B: "OXPCIe200 Native 950 UART",
             0xC57C: "OXPCIe200 Dual OHCI USB Controller (R-ULPI/analog)",
             0xC57D: "OXPCIe200 EHCI USB Controller (R-ULPI)",
             0xC57E: "OXPCIe200 GPIO",
             0xC57F: "OXPCIe200 Native 950 UART",
             0xC5A0: "OXPCIe200 OHCI USB Controller (ULPI)",
             0xC5A1: "OXPCIe200 EHCI USB Controller (ULPI)",
             0xC5A2: "OXPCIe200 Programmable Memory Interface",
             0xC5A4: "OXPCIe200 OHCI USB Controller (ULPI)",
             0xC5A5: "OXPCIe200 EHCI USB Controller (ULPI)",
             0xC5A6: "OXPCIe200 Programmable Memory Interface & GPIO",
             0xC5A8: "OXPCIe200 OHCI USB Controller (ULPI)",
             0xC5A9: "OXPCIe200 EHCI USB Controller (ULPI)",
             0xC5AA: "OXPCIe200 Programmable Memory Interface",
             0xC5AB: "OXPCIe200 Native 950 UART",
             0xC5AC: "OXPCIe200 OHCI USB Controller (ULPI)",
             0xC5AD: "OXPCIe200 EHCI USB Controller (ULPI)",
             0xC5AE: "OXPCIe200 Programmable Memory Interface & GPIO",
             0xC5AF: "OXPCIe200 Native 950 UART",
             0xC5B0: "OXPCIe200 OHCI USB Controller (R-ULPI)",
             0xC5B1: "OXPCIe200 EHCI USB Controller (R-ULPI)",
             0xC5B2: "OXPCIe200 Programmable Memory Interface",
             0xC5B4: "OXPCIe200 OHCI USB Controller (R-ULPI)",
             0xC5B5: "OXPCIe200 EHCI USB Controller (R-ULPI)",
             0xC5B6: "OXPCIe200 Programmable Memory Interface & GPIO",
             0xC5B8: "OXPCIe200 OHCI USB Controller (R-ULPI)",
             0xC5B9: "OXPCIe200 EHCI USB Controller (R-ULPI)",
             0xC5BA: "OXPCIe200 Programmable Memory Interface",
             0xC5BB: "OXPCIe200 Native 950 UART",
             0xC5BC: "OXPCIe200 OHCI USB Controller (R-ULPI)",
             0xC5BD: "OXPCIe200 EHCI USB Controller (R-ULPI)",
             0xC5BE: "OXPCIe200 Programmable Memory Interface & GPIO",
             0xC5BF: "OXPCIe200 Native 950 UART",
             0xC5C0: "OXPCIe200 OHCI USB Controller (analog)",
             0xC5C2: "OXPCIe200 Programmable Memory Interface",
             0xC5C4: "OXPCIe200 OHCI USB Controller (analog)",
             0xC5C6: "OXPCIe200 Programmable Memory Interface & GPIO",
             0xC5C8: "OXPCIe200 OHCI USB Controller (analog)",
             0xC5CA: "OXPCIe200 Programmable Memory Interface",
             0xC5CB: "OXPCIe200 Native 950 UART",
             0xC5CC: "OXPCIe200 OHCI USB Controller (analog)",
             0xC5CE: "OXPCIe200 Programmable Memory Interface & GPIO",
             0xC5CF: "OXPCIe200 Native 950 UART",
             },

    # Psion Dacom plc
    0x1420: {0x8002: "Gold Card NetGlobal 56k+10/100Mb CardBus (Ethernet part)",
             0x8003: "Gold Card NetGlobal 56k+10/100Mb CardBus (Modem part)",
             },

    # Chelsio Communications Inc
    0x1425: {0x000B: "T210 Protocol Engine",
             0x000C: "T204 Protocol Engine",
             0x0022: "10GbE Ethernet Adapter",
             0x0030: "T310 10GbE Single Port Adapter",
             0x0031: "T320 10GbE Dual Port Adapter",
             0x0032: "T302 1GbE Dual Port Adapter",
             0x0033: "T304 1GbE Quad Port Adapter",
             0x0034: "B320 10GbE Dual Port Adapter",
             0x0035: "S310-CR 10GbE Single Port Adapter",
             0x0036: "S320-LP-CR 10GbE Dual Port Adapter",
             0x0037: "N320-G2-CR 10GbE Dual Port Adapter",
             0x4001: "T420-CR Unified Wire Ethernet Controller",
             0x4002: "T422-CR Unified Wire Ethernet Controller",
             0x4003: "T440-CR Unified Wire Ethernet Controller",
             0x4004: "T420-BCH Unified Wire Ethernet Controller",
             0x4005: "T440-BCH Unified Wire Ethernet Controller",
             0x4006: "T440-CH Unified Wire Ethernet Controller",
             0x4007: "T420-SO Unified Wire Ethernet Controller",
             0x4008: "T420-CX Unified Wire Ethernet Controller",
             0x4009: "T420-BT Unified Wire Ethernet Controller",
             0x400A: "T404-BT Unified Wire Ethernet Controller",
             0x400B: "B420-SR Unified Wire Ethernet Controller",
             0x400C: "B404-BT Unified Wire Ethernet Controller",
             0x400D: "T480 Unified Wire Ethernet Controller",
             0x400E: "T440-LP-CR Unified Wire Ethernet Controller",
             0x400F: "T440 [Amsterdam] Unified Wire Ethernet Controller",
             0x4080: "T480-4080 T480 Unified Wire Ethernet Controller",
             0x4081: "T440F-4081 T440-FCoE Unified Wire Ethernet Controller",
             0x4082: "T420-Unified Wire Ethernet Controller",
             0x4083: "T420X-4083 Unified Wire Ethernet Controller",
             0x4084: "T440-4084 Unified Wire Ethernet Controller",
             0x4085: "T420-4085 SFP+ Unified Wire Ethernet Controller",
             0x4086: "T440-4086 10Gbase-T Unified Wire Ethernet Controller",
             0x4087: "T440T-4087 Unified Wire Ethernet Controller",
             0x4088: "T440-4088 Unified Wire Ethernet Controller",
             0x4401: "T420-CR Unified Wire Ethernet Controller",
             0x4402: "T422-CR Unified Wire Ethernet Controller",
             0x4403: "T440-CR Unified Wire Ethernet Controller",
             0x4404: "T420-BCH Unified Wire Ethernet Controller",
             0x4405: "T440-BCH Unified Wire Ethernet Controller",
             0x4406: "T440-CH Unified Wire Ethernet Controller",
             0x4407: "T420-SO Unified Wire Ethernet Controller",
             0x4408: "T420-CX Unified Wire Ethernet Controller",
             0x4409: "T420-BT Unified Wire Ethernet Controller",
             0x440A: "T404-BT Unified Wire Ethernet Controller",
             0x440B: "B420-SR Unified Wire Ethernet Controller",
             0x440C: "B404-BT Unified Wire Ethernet Controller",
             0x440D: "T480 Unified Wire Ethernet Controller",
             0x440E: "T440-LP-CR Unified Wire Ethernet Controller",
             0x440F: "T440 [Amsterdam] Unified Wire Ethernet Controller",
             0x4480: "T480-4080 T480 Unified Wire Ethernet Controller",
             0x4481: "T440F-4081 T440-FCoE Unified Wire Ethernet Controller",
             0x4482: "T420-4082  Unified Wire Ethernet Controller",
             0x4483: "T420X-4083 Unified Wire Ethernet Controller",
             0x4484: "T440-4084 Unified Wire Ethernet Controller",
             0x4485: "T420-4085 SFP+ Unified Wire Ethernet Controller",
             0x4486: "T440-4086 10Gbase-T Unified Wire Ethernet Controller",
             0x4487: "T440T-4087 Unified Wire Ethernet Controller",
             0x4488: "T440-4088 Unified Wire Ethernet Controller",
             0x4501: "T420-CR Unified Wire Storage Controller",
             0x4502: "T422-CR Unified Wire Storage Controller",
             0x4503: "T440-CR Unified Wire Storage Controller",
             0x4504: "T420-BCH Unified Wire Storage Controller",
             0x4505: "T440-BCH Unified Wire Storage Controller",
             0x4506: "T440-CH Unified Wire Storage Controller",
             0x4507: "T420-SO Unified Wire Storage Controller",
             0x4508: "T420-CX Unified Wire Storage Controller",
             0x4509: "T420-BT Unified Wire Storage Controller",
             0x450A: "T404-BT Unified Wire Storage Controller",
             0x450B: "B420-SR Unified Wire Storage Controller",
             0x450C: "B404-BT Unified Wire Storage Controller",
             0x450D: "T480 Unified Wire Storage Controller",
             0x450E: "T440-LP-CR Unified Wire Storage Controller",
             0x450F: "T440 [Amsterdam] Unified Wire Storage Controller",
             0x4580: "T480-4080 T480 Unified Wire Storage Controller",
             0x4581: "T440F-4081 T440-FCoE Unified Wire Storage Controller",
             0x4582: "T420-4082  Unified Wire Storage Controller",
             0x4583: "T420X-4083 Unified Wire Storage Controller",
             0x4584: "T440-4084 Unified Wire Storage Controller",
             0x4585: "T420-4085 SFP+ Unified Wire Storage Controller",
             0x4586: "T440-4086 10Gbase-T Unified Wire Storage Controller",
             0x4587: "T440T-4087 Unified Wire Storage Controller",
             0x4588: "T440-4088 Unified Wire Storage Controller",
             0x4601: "T420-CR Unified Wire Storage Controller",
             0x4602: "T422-CR Unified Wire Storage Controller",
             0x4603: "T440-CR Unified Wire Storage Controller",
             0x4604: "T420-BCH Unified Wire Storage Controller",
             0x4605: "T440-BCH Unified Wire Storage Controller",
             0x4606: "T440-CH Unified Wire Storage Controller",
             0x4607: "T420-SO Unified Wire Storage Controller",
             0x4608: "T420-CX Unified Wire Storage Controller",
             0x4609: "T420-BT Unified Wire Storage Controller",
             0x460A: "T404-BT Unified Wire Storage Controller",
             0x460B: "B420-SR Unified Wire Storage Controller",
             0x460C: "B404-BT Unified Wire Storage Controller",
             0x460D: "T480 Unified Wire Storage Controller",
             0x460E: "T440-LP-CR Unified Wire Storage Controller",
             0x460F: "T440 [Amsterdam] Unified Wire Storage Controller",
             0x4680: "T480-4080 T480 Unified Wire Storage Controller",
             0x4681: "T440F-4081 T440-FCoE Unified Wire Storage Controller",
             0x4682: "T420-4082  Unified Wire Storage Controller",
             0x4683: "T420X-4083 Unified Wire Storage Controller",
             0x4684: "T440-4084 Unified Wire Storage Controller",
             0x4685: "T420-4085 SFP+ Unified Wire Storage Controller",
             0x4686: "T440-4086 10Gbase-T Unified Wire Storage Controller",
             0x4687: "T440T-4087 Unified Wire Storage Controller",
             0x4688: "T440-4088 Unified Wire Storage Controller",
             0x4701: "T420-CR Unified Wire Ethernet Controller",
             0x4702: "T422-CR Unified Wire Ethernet Controller",
             0x4703: "T440-CR Unified Wire Ethernet Controller",
             0x4704: "T420-BCH Unified Wire Ethernet Controller",
             0x4705: "T440-BCH Unified Wire Ethernet Controller",
             0x4706: "T440-CH Unified Wire Ethernet Controller",
             0x4707: "T420-SO Unified Wire Ethernet Controller",
             0x4708: "T420-CX Unified Wire Ethernet Controller",
             0x4709: "T420-BT Unified Wire Ethernet Controller",
             0x470A: "T404-BT Unified Wire Ethernet Controller",
             0x470B: "B420-SR Unified Wire Ethernet Controller",
             0x470C: "B404-BT Unified Wire Ethernet Controller",
             0x470D: "T480 Unified Wire Ethernet Controller",
             0x470E: "T440-LP-CR Unified Wire Ethernet Controller",
             0x470F: "T440 [Amsterdam] Unified Wire Ethernet Controller",
             0x4780: "T480-4080 T480 Unified Wire Ethernet Controller",
             0x4781: "T440F-4081 T440-FCoE Unified Wire Ethernet Controller",
             0x4782: "T420-4082  Unified Wire Ethernet Controller",
             0x4783: "T420X-4083 Unified Wire Ethernet Controller",
             0x4784: "T440-4084 Unified Wire Ethernet Controller",
             0x4785: "T420-4085 SFP+ Unified Wire Ethernet Controller",
             0x4786: "T440-4086 10Gbase-T Unified Wire Ethernet Controller",
             0x4787: "T440T-4087 Unified Wire Ethernet Controller",
             0x4788: "T440-4088 Unified Wire Ethernet Controller",
             0x4801: "T420-CR Unified Wire Ethernet Controller [VF]",
             0x4802: "T422-CR Unified Wire Ethernet Controller [VF]",
             0x4803: "T440-CR Unified Wire Ethernet Controller [VF]",
             0x4804: "T420-BCH Unified Wire Ethernet Controller [VF]",
             0x4805: "T440-BCH Unified Wire Ethernet Controller [VF]",
             0x4806: "T440-CH Unified Wire Ethernet Controller [VF]",
             0x4807: "T420-SO Unified Wire Ethernet Controller [VF]",
             0x4808: "T420-CX Unified Wire Ethernet Controller [VF]",
             0x4809: "T420-BT Unified Wire Ethernet Controller [VF]",
             0x480A: "T404-BT Unified Wire Ethernet Controller [VF]",
             0x480B: "B420-SR Unified Wire Ethernet Controller [VF]",
             0x480C: "B404-BT Unified Wire Ethernet Controller [VF]",
             0x480D: "T480 Unified Wire Ethernet Controller [VF]",
             0x480E: "T440-LP-CR Unified Wire Ethernet Controller [VF]",
             0x480F: "T440 [Amsterdam] Unified Wire Ethernet Controller [VF]",
             0x4880: "T480-4080 T480 Unified Wire Ethernet Controller [VF]",
             0x4881: "T440F-4081 T440-FCoE Unified Wire Ethernet Controller [VF]",
             0x4882: "T420-4082 Unified Wire Ethernet Controller [VF]",
             0x4883: "T420X-4083 Unified Wire Ethernet Controller [VF]",
             0x4884: "T440-4084 Unified Wire Ethernet Controller [VF]",
             0x4885: "T420-4085 SFP+ Unified Wire Ethernet Controller [VF]",
             0x4886: "T440-4086 10Gbase-T Unified Wire Ethernet Controller [VF]",
             0x4887: "T440T-4087 Unified Wire Ethernet Controller [VF]",
             0x4888: "T440-4088 Unified Wire Ethernet Controller [VF]",
             0x5001: "T520-CR Unified Wire Ethernet Controller",
             0x5002: "T522-CR Unified Wire Ethernet Controller",
             0x5003: "T540-CR Unified Wire Ethernet Controller",
             0x5004: "T520-BCH Unified Wire Ethernet Controller",
             0x5005: "T540-BCH Unified Wire Ethernet Controller",
             0x5006: "T540-CH Unified Wire Ethernet Controller",
             0x5007: "T520-SO Unified Wire Ethernet Controller",
             0x5008: "T520-CX Unified Wire Ethernet Controller",
             0x5009: "T520-BT Unified Wire Ethernet Controller",
             0x500A: "T504-BT Unified Wire Ethernet Controller",
             0x500B: "B520-SR Unified Wire Ethernet Controller",
             0x500C: "B504-BT Unified Wire Ethernet Controller",
             0x500D: "T580-CR Unified Wire Ethernet Controller",
             0x500E: "T540-LP-CR Unified Wire Ethernet Controller",
             0x500F: "T540 [Amsterdam] Unified Wire Ethernet Controller",
             0x5010: "T580-LP-CR Unified Wire Ethernet Controller",
             0x5011: "T520-LL-CR Unified Wire Ethernet Controller",
             0x5012: "T560-CR Unified Wire Ethernet Controller",
             0x5013: "T580-CHR Unified Wire Ethernet Controller",
             0x5014: "T580-SO-CR Unified Wire Ethernet Controller",
             0x5015: "T502-BT Unified Wire Ethernet Controller",
             0x5016: "T580-OCP-SO Unified Wire Ethernet Controller",
             0x5017: "T520-OCP-SO Unified Wire Ethernet Controller",
             0x5018: "T540-BT Unified Wire Ethernet Controller",
             0x5019: "T540-LP-BT Unified Wire Ethernet Controller",
             0x501A: "T540-SO-BT Unified Wire Ethernet Controller",
             0x501B: "T540-SO-CR Unified Wire Ethernet Controller",
             0x5080: "T540-5080 Unified Wire Ethernet Controller",
             0x5081: "T540-5081 Unified Wire Ethernet Controller",
             0x5082: "T504-5082 Unified Wire Ethernet Controller",
             0x5083: "T540-5083 Unified Wire Ethernet Controller",
             0x5084: "T540-5084 Unified Wire Ethernet Controller",
             0x5085: "T580-5085 Unified Wire Ethernet Controller",
             0x5086: "T580-5086 Unified Wire Ethernet Controller",
             0x5087: "T580-5087 Unified Wire Ethernet Controller",
             0x5088: "T570-5088 Unified Wire Ethernet Controller",
             0x5089: "T520-5089 Unified Wire Ethernet Controller",
             0x5090: "T540-5090 Unified Wire Ethernet Controller",
             0x5091: "T522-5091 Unified Wire Ethernet Controller",
             0x5092: "T520-5092 Unified Wire Ethernet Controller",
             0x5093: "T580-5093 Unified Wire Ethernet Controller",
             0x5094: "T540-5094 Unified Wire Ethernet Controller",
             0x5095: "T540-5095 Unified Wire Ethernet Controller",
             0x5096: "T580-5096 Unified Wire Ethernet Controller",
             0x5097: "T520-5097 Unified Wire Ethernet Controller",
             0x5098: "T580-5098 Unified Wire Ethernet Controller",
             0x5099: "T580-5099 Unified Wire Ethernet Controller",
             0x509A: "T520-509A Unified Wire Ethernet Controller",
             0x509B: "T540-509B Unified Wire Ethernet Controller",
             0x509C: "T520-509C Unified Wire Ethernet Controller",
             0x509D: "T540-509D Unified Wire Ethernet Controller",
             0x509E: "T520-509E Unified Wire Ethernet Controller",
             0x509F: "T540-509F Unified Wire Ethernet Controller",
             0x50A0: "T540-50A0 Unified Wire Ethernet Controller",
             0x50A1: "T540-50A1 Unified Wire Ethernet Controller",
             0x50A2: "T580-50A2 Unified Wire Ethernet Controller",
             0x50A3: "T580-50A3 Unified Wire Ethernet Controller",
             0x50A4: "T540-50A4 Unified Wire Ethernet Controller",
             0x50A5: "T522-50A5 Unified Wire Ethernet Controller",
             0x50A6: "T522-50A6 Unified Wire Ethernet Controller",
             0x50A7: "T580-50A7 Unified Wire Ethernet Controller",
             0x50A8: "T580-50A8 Unified Wire Ethernet Controller",
             0x50A9: "T580-50A9 Unified Wire Ethernet Controller",
             0x50AA: "T580-50AA Unified Wire Ethernet Controller",
             0x50AB: "T520-50AB Unified Wire Ethernet Controller",
             0x50AC: "T540-50AC Unified Wire Ethernet Controller",
             0x50AD: "T520-50AD Unified Wire Ethernet Controller",
             0x50AE: "T540-50AE Unified Wire Ethernet Controller",
             0x50AF: "T580-50AF Unified Wire Ethernet Controller",
             0x50B0: "T520-50B0 Unified Wire Ethernet Controller",
             0x5401: "T520-CR Unified Wire Ethernet Controller",
             0x5402: "T522-CR Unified Wire Ethernet Controller",
             0x5403: "T540-CR Unified Wire Ethernet Controller",
             0x5404: "T520-BCH Unified Wire Ethernet Controller",
             0x5405: "T540-BCH Unified Wire Ethernet Controller",
             0x5406: "T540-CH Unified Wire Ethernet Controller",
             0x5407: "T520-SO Unified Wire Ethernet Controller",
             0x5408: "T520-CX Unified Wire Ethernet Controller",
             0x5409: "T520-BT Unified Wire Ethernet Controller",
             0x540A: "T504-BT Unified Wire Ethernet Controller",
             0x540B: "B520-SR Unified Wire Ethernet Controller",
             0x540C: "B504-BT Unified Wire Ethernet Controller",
             0x540D: "T580-CR Unified Wire Ethernet Controller",
             0x540E: "T540-LP-CR Unified Wire Ethernet Controller",
             0x540F: "T540 [Amsterdam] Unified Wire Ethernet Controller",
             0x5410: "T580-LP-CR Unified Wire Ethernet Controller",
             0x5411: "T520-LL-CR Unified Wire Ethernet Controller",
             0x5412: "T560-CR Unified Wire Ethernet Controller",
             0x5413: "T580-CHR Unified Wire Ethernet Controller",
             0x5414: "T580-SO-CR Unified Wire Ethernet Controller",
             0x5415: "T502-BT Unified Wire Ethernet Controller",
             0x5416: "T580-OCP-SO Unified Wire Ethernet Controller",
             0x5417: "T520-OCP-SO Unified Wire Ethernet Controller",
             0x5418: "T540-BT Unified Wire Ethernet Controller",
             0x5419: "T540-LP-BT Unified Wire Ethernet Controller",
             0x541A: "T540-SO-BT Unified Wire Ethernet Controller",
             0x541B: "T540-SO-CR Unified Wire Ethernet Controller",
             0x5480: "T540-5080 Unified Wire Ethernet Controller",
             0x5481: "T540-5081 Unified Wire Ethernet Controller",
             0x5482: "T504-5082 Unified Wire Ethernet Controller",
             0x5483: "T540-5083 Unified Wire Ethernet Controller",
             0x5484: "T540-5084 Unified Wire Ethernet Controller",
             0x5485: "T580-5085 Unified Wire Ethernet Controller",
             0x5486: "T580-5086 Unified Wire Ethernet Controller",
             0x5487: "T580-5087 Unified Wire Ethernet Controller",
             0x5488: "T570-5088 Unified Wire Ethernet Controller",
             0x5489: "T520-5089 Unified Wire Ethernet Controller",
             0x5490: "T540-5090 Unified Wire Ethernet Controller",
             0x5491: "T522-5091 Unified Wire Ethernet Controller",
             0x5492: "T520-5092 Unified Wire Ethernet Controller",
             0x5493: "T580-5093 Unified Wire Ethernet Controller",
             0x5494: "T540-5094 Unified Wire Ethernet Controller",
             0x5495: "T540-5095 Unified Wire Ethernet Controller",
             0x5496: "T580-5096 Unified Wire Ethernet Controller",
             0x5497: "T520-5097 Unified Wire Ethernet Controller",
             0x5498: "T580-5098 Unified Wire Ethernet Controller",
             0x5499: "T580-5099 Unified Wire Ethernet Controller",
             0x549A: "T520-509A Unified Wire Ethernet Controller",
             0x549B: "T540-509B Unified Wire Ethernet Controller",
             0x549C: "T520-509C Unified Wire Ethernet Controller",
             0x549D: "T540-509D Unified Wire Ethernet Controller",
             0x549E: "T520-509E Unified Wire Ethernet Controller",
             0x549F: "T540-509F Unified Wire Ethernet Controller",
             0x54A0: "T540-50A0 Unified Wire Ethernet Controller",
             0x54A1: "T540-50A1 Unified Wire Ethernet Controller",
             0x54A2: "T580-50A2 Unified Wire Ethernet Controller",
             0x54A3: "T580-50A3 Unified Wire Ethernet Controller",
             0x54A4: "T540-50A4 Unified Wire Ethernet Controller",
             0x54A5: "T522-50A5 Unified Wire Ethernet Controller",
             0x54A6: "T522-50A6 Unified Wire Ethernet Controller",
             0x54A7: "T580-50A7 Unified Wire Ethernet Controller",
             0x54A8: "T580-50A8 Unified Wire Ethernet Controller",
             0x54A9: "T580-50A9 Unified Wire Ethernet Controller",
             0x54AA: "T580-50AA Unified Wire Ethernet Controller",
             0x54AB: "T520-50AB Unified Wire Ethernet Controller",
             0x54AC: "T540-50AC Unified Wire Ethernet Controller",
             0x54AD: "T520-50AD Unified Wire Ethernet Controller",
             0x54AE: "T540-50AE Unified Wire Ethernet Controller",
             0x54AF: "T580-50AF Unified Wire Ethernet Controller",
             0x54B0: "T520-50B0 Unified Wire Ethernet Controller",
             0x5501: "T520-CR Unified Wire Storage Controller",
             0x5502: "T522-CR Unified Wire Storage Controller",
             0x5503: "T540-CR Unified Wire Storage Controller",
             0x5504: "T520-BCH Unified Wire Storage Controller",
             0x5505: "T540-BCH Unified Wire Storage Controller",
             0x5506: "T540-CH Unified Wire Storage Controller",
             0x5507: "T520-SO Unified Wire Storage Controller",
             0x5508: "T520-CX Unified Wire Storage Controller",
             0x5509: "T520-BT Unified Wire Storage Controller",
             0x550A: "T504-BT Unified Wire Storage Controller",
             0x550B: "B520-SR Unified Wire Storage Controller",
             0x550C: "B504-BT Unified Wire Storage Controller",
             0x550D: "T580-CR Unified Wire Storage Controller",
             0x550E: "T540-LP-CR Unified Wire Storage Controller",
             0x550F: "T540 [Amsterdam] Unified Wire Storage Controller",
             0x5510: "T580-LP-CR Unified Wire Storage Controller",
             0x5511: "T520-LL-CR Unified Wire Storage Controller",
             0x5512: "T560-CR Unified Wire Storage Controller",
             0x5513: "T580-CHR Unified Wire Storage Controller",
             0x5514: "T580-SO-CR Unified Wire Storage Controller",
             0x5515: "T502-BT Unified Wire Storage Controller",
             0x5516: "T580-OCP-SO Unified Wire Storage Controller",
             0x5517: "T520-OCP-SO Unified Wire Storage Controller",
             0x5518: "T540-BT Unified Wire Storage Controller",
             0x5519: "T540-LP-BT Unified Wire Storage Controller",
             0x551A: "T540-SO-BT Unified Wire Storage Controller",
             0x551B: "T540-SO-CR Unified Wire Storage Controller",
             0x5580: "T540-5080 Unified Wire Storage Controller",
             0x5581: "T540-5081 Unified Wire Storage Controller",
             0x5582: "T504-5082 Unified Wire Storage Controller",
             0x5583: "T540-5083 Unified Wire Storage Controller",
             0x5584: "T540-5084 Unified Wire Storage Controller",
             0x5585: "T580-5085 Unified Wire Storage Controller",
             0x5586: "T580-5086 Unified Wire Storage Controller",
             0x5587: "T580-5087 Unified Wire Storage Controller",
             0x5588: "T570-5088 Unified Wire Storage Controller",
             0x5589: "T520-5089 Unified Wire Storage Controller",
             0x5590: "T540-5090 Unified Wire Storage Controller",
             0x5591: "T522-5091 Unified Wire Storage Controller",
             0x5592: "T520-5092 Unified Wire Storage Controller",
             0x5593: "T580-5093 Unified Wire Storage Controller",
             0x5594: "T540-5094 Unified Wire Storage Controller",
             0x5595: "T540-5095 Unified Wire Storage Controller",
             0x5596: "T580-5096 Unified Wire Storage Controller",
             0x5597: "T520-5097 Unified Wire Storage Controller",
             0x5598: "T580-5098 Unified Wire Storage Controller",
             0x5599: "T580-5099 Unified Wire Storage Controller",
             0x559A: "T520-509A Unified Wire Storage Controller",
             0x559B: "T540-509B Unified Wire Storage Controller",
             0x559C: "T520-509C Unified Wire Storage Controller",
             0x559D: "T540-509D Unified Wire Storage Controller",
             0x559E: "T520-509E Unified Wire Storage Controller",
             0x559F: "T540-509F Unified Wire Storage Controller",
             0x55A0: "T540-50A0 Unified Wire Storage Controller",
             0x55A1: "T540-50A1 Unified Wire Storage Controller",
             0x55A2: "T580-50A2 Unified Wire Storage Controller",
             0x55A3: "T580-50A3 Unified Wire Storage Controller",
             0x55A4: "T540-50A4 Unified Wire Storage Controller",
             0x55A5: "T522-50A5 Unified Wire Storage Controller",
             0x55A6: "T522-50A6 Unified Wire Storage Controller",
             0x55A7: "T580-50A7 Unified Wire Storage Controller",
             0x55A8: "T580-50A8 Unified Wire Storage Controller",
             0x55A9: "T580-50A9 Unified Wire Storage Controller",
             0x55AA: "T580-50AA Unified Wire Storage Controller",
             0x55AB: "T520-50AB Unified Wire Storage Controller",
             0x55AC: "T540-50AC Unified Wire Storage Controller",
             0x55AD: "T520-50AD Unified Wire Storage Controller",
             0x55AE: "T540-50AE Unified Wire Storage Controller",
             0x55AF: "T580-50AF Unified Wire Storage Controller",
             0x55B0: "T520-50B0 Unified Wire Storage Controller",
             0x5601: "T520-CR Unified Wire Storage Controller",
             0x5602: "T522-CR Unified Wire Storage Controller",
             0x5603: "T540-CR Unified Wire Storage Controller",
             0x5604: "T520-BCH Unified Wire Storage Controller",
             0x5605: "T540-BCH Unified Wire Storage Controller",
             0x5606: "T540-CH Unified Wire Storage Controller",
             0x5607: "T520-SO Unified Wire Storage Controller",
             0x5608: "T520-CX Unified Wire Storage Controller",
             0x5609: "T520-BT Unified Wire Storage Controller",
             0x560A: "T504-BT Unified Wire Storage Controller",
             0x560B: "B520-SR Unified Wire Storage Controller",
             0x560C: "B504-BT Unified Wire Storage Controller",
             0x560D: "T580-CR Unified Wire Storage Controller",
             0x560E: "T540-LP-CR Unified Wire Storage Controller",
             0x560F: "T540 [Amsterdam] Unified Wire Storage Controller",
             0x5610: "T580-LP-CR Unified Wire Storage Controller",
             0x5611: "T520-LL-CR Unified Wire Storage Controller",
             0x5612: "T560-CR Unified Wire Storage Controller",
             0x5613: "T580-CHR Unified Wire Storage Controller",
             0x5614: "T580-SO-CR Unified Wire Storage Controller",
             0x5615: "T502-BT Unified Wire Storage Controller",
             0x5616: "T580-OCP-SO Unified Wire Storage Controller",
             0x5617: "T520-OCP-SO Unified Wire Storage Controller",
             0x5618: "T540-BT Unified Wire Storage Controller",
             0x5619: "T540-LP-BT Unified Wire Storage Controller",
             0x561A: "T540-SO-BT Unified Wire Storage Controller",
             0x561B: "T540-SO-CR Unified Wire Storage Controller",
             0x5680: "T540-5080 Unified Wire Storage Controller",
             0x5681: "T540-5081 Unified Wire Storage Controller",
             0x5682: "T504-5082 Unified Wire Storage Controller",
             0x5683: "T540-5083 Unified Wire Storage Controller",
             0x5684: "T540-5084 Unified Wire Storage Controller",
             0x5685: "T580-5085 Unified Wire Storage Controller",
             0x5686: "T580-5086 Unified Wire Storage Controller",
             0x5687: "T580-5087 Unified Wire Storage Controller",
             0x5688: "T570-5088 Unified Wire Storage Controller",
             0x5689: "T520-5089 Unified Wire Storage Controller",
             0x5690: "T540-5090 Unified Wire Storage Controller",
             0x5691: "T522-5091 Unified Wire Storage Controller",
             0x5692: "T520-5092 Unified Wire Storage Controller",
             0x5693: "T580-5093 Unified Wire Storage Controller",
             0x5694: "T540-5094 Unified Wire Storage Controller",
             0x5695: "T540-5095 Unified Wire Storage Controller",
             0x5696: "T580-5096 Unified Wire Storage Controller",
             0x5697: "T520-5097 Unified Wire Storage Controller",
             0x5698: "T580-5098 Unified Wire Storage Controller",
             0x5699: "T580-5099 Unified Wire Storage Controller",
             0x569A: "T520-509A Unified Wire Storage Controller",
             0x569B: "T540-509B Unified Wire Storage Controller",
             0x569C: "T520-509C Unified Wire Storage Controller",
             0x569D: "T540-509D Unified Wire Storage Controller",
             0x569E: "T520-509E Unified Wire Storage Controller",
             0x569F: "T540-509F Unified Wire Storage Controller",
             0x56A0: "T540-50A0 Unified Wire Storage Controller",
             0x56A1: "T540-50A1 Unified Wire Storage Controller",
             0x56A2: "T580-50A2 Unified Wire Storage Controller",
             0x56A3: "T580-50A3 Unified Wire Storage Controller",
             0x56A4: "T540-50A4 Unified Wire Storage Controller",
             0x56A5: "T522-50A5 Unified Wire Storage Controller",
             0x56A6: "T522-50A6 Unified Wire Storage Controller",
             0x56A7: "T580-50A7 Unified Wire Storage Controller",
             0x56A8: "T580-50A8 Unified Wire Storage Controller",
             0x56A9: "T580-50A9 Unified Wire Storage Controller",
             0x56AA: "T580-50AA Unified Wire Storage Controller",
             0x56AB: "T520-50AB Unified Wire Storage Controller",
             0x56AC: "T540-50AC Unified Wire Storage Controller",
             0x56AD: "T520-50AD Unified Wire Storage Controller",
             0x56AE: "T540-50AE Unified Wire Storage Controller",
             0x56AF: "T580-50AF Unified Wire Storage Controller",
             0x56B0: "T520-50B0 Unified Wire Storage Controller",
             0x5701: "T520-CR Unified Wire Ethernet Controller",
             0x5702: "T522-CR Unified Wire Ethernet Controller",
             0x5703: "T540-CR Unified Wire Ethernet Controller",
             0x5704: "T520-BCH Unified Wire Ethernet Controller",
             0x5705: "T540-BCH Unified Wire Ethernet Controller",
             0x5706: "T540-CH Unified Wire Ethernet Controller",
             0x5707: "T520-SO Unified Wire Ethernet Controller",
             0x5708: "T520-CX Unified Wire Ethernet Controller",
             0x5709: "T520-BT Unified Wire Ethernet Controller",
             0x570A: "T504-BT Unified Wire Ethernet Controller",
             0x570B: "B520-SR Unified Wire Ethernet Controller",
             0x570C: "B504-BT Unified Wire Ethernet Controller",
             0x570D: "T580-CR Unified Wire Ethernet Controller",
             0x570E: "T540-LP-CR Unified Wire Ethernet Controller",
             0x570F: "T540 [Amsterdam] Unified Wire Ethernet Controller",
             0x5710: "T580-LP-CR Unified Wire Ethernet Controller",
             0x5711: "T520-LL-CR Unified Wire Ethernet Controller",
             0x5712: "T560-CR Unified Wire Ethernet Controller",
             0x5713: "T580-CR Unified Wire Ethernet Controller",
             0x5714: "T580-SO-CR Unified Wire Ethernet Controller",
             0x5715: "T502-BT Unified Wire Ethernet Controller",
             0x5780: "T540-5080 Unified Wire Ethernet Controller",
             0x5781: "T540-5081 Unified Wire Ethernet Controller",
             0x5782: "T504-5082 Unified Wire Ethernet Controller",
             0x5783: "T540-5083 Unified Wire Ethernet Controller",
             0x5784: "T580-5084 Unified Wire Ethernet Controller",
             0x5785: "T580-5085 Unified Wire Ethernet Controller",
             0x5786: "T580-5086 Unified Wire Ethernet Controller",
             0x5787: "T580-5087 Unified Wire Ethernet Controller",
             0x5788: "T570-5088 Unified Wire Ethernet Controller",
             0x5789: "T520-5089 Unified Wire Ethernet Controller",
             0x5790: "T540-5090 Unified Wire Ethernet Controller",
             0x5791: "T522-5091 Unified Wire Ethernet Controller",
             0x5792: "T520-5092 Unified Wire Ethernet Controller",
             0x5793: "T580-5093 Unified Wire Ethernet Controller",
             0x5794: "T540-5094 Unified Wire Ethernet Controller",
             0x5795: "T540-5095 Unified Wire Ethernet Controller",
             0x5796: "T580-5096 Unified Wire Ethernet Controller",
             0x5797: "T520-5097 Unified Wire Ethernet Controller",
             0x5801: "T520-CR Unified Wire Ethernet Controller [VF]",
             0x5802: "T522-CR Unified Wire Ethernet Controller [VF]",
             0x5803: "T540-CR Unified Wire Ethernet Controller [VF]",
             0x5804: "T520-BCH Unified Wire Ethernet Controller [VF]",
             0x5805: "T540-BCH Unified Wire Ethernet Controller [VF]",
             0x5806: "T540-CH Unified Wire Ethernet Controller [VF]",
             0x5807: "T520-SO Unified Wire Ethernet Controller [VF]",
             0x5808: "T520-CX Unified Wire Ethernet Controller [VF]",
             0x5809: "T520-BT Unified Wire Ethernet Controller [VF]",
             0x580A: "T504-BT Unified Wire Ethernet Controller [VF]",
             0x580B: "B520-SR Unified Wire Ethernet Controller [VF]",
             0x580C: "B504-BT Unified Wire Ethernet Controller [VF]",
             0x580D: "T580-CR Unified Wire Ethernet Controller [VF]",
             0x580E: "T540-LP-CR Unified Wire Ethernet Controller [VF]",
             0x580F: "T540 [Amsterdam] Unified Wire Ethernet Controller [VF]",
             0x5810: "T580-LP-CR Unified Wire Ethernet Controller [VF]",
             0x5811: "T520-LL-CR Unified Wire Ethernet Controller [VF]",
             0x5812: "T560-CR Unified Wire Ethernet Controller [VF]",
             0x5813: "T580-CHR Unified Wire Ethernet Controller [VF]",
             0x5814: "T580-SO-CR Unified Wire Ethernet Controller [VF]",
             0x5815: "T502-BT Unified Wire Ethernet Controller [VF]",
             0x5816: "T580-OCP-SO Unified Wire Ethernet Controller [VF]",
             0x5817: "T520-OCP-SO Unified Wire Ethernet Controller [VF]",
             0x5818: "T540-BT Unified Wire Ethernet Controller [VF]",
             0x5819: "T540-LP-BT Unified Wire Ethernet Controller [VF]",
             0x581A: "T540-SO-BT Unified Wire Ethernet Controller [VF]",
             0x581B: "T540-SO-CR Unified Wire Ethernet Controller [VF]",
             0x5880: "T540-5080 Unified Wire Ethernet Controller [VF]",
             0x5881: "T540-5081 Unified Wire Ethernet Controller [VF]",
             0x5882: "T504-5082 Unified Wire Ethernet Controller [VF]",
             0x5883: "T540-5083 Unified Wire Ethernet Controller [VF]",
             0x5884: "T540-5084 Unified Wire Ethernet Controller [VF]",
             0x5885: "T580-5085 Unified Wire Ethernet Controller [VF]",
             0x5886: "T580-5086 Unified Wire Ethernet Controller [VF]",
             0x5887: "T580-5087 Unified Wire Ethernet Controller [VF]",
             0x5888: "T570-5088 Unified Wire Ethernet Controller [VF]",
             0x5889: "T520-5089 Unified Wire Ethernet Controller [VF]",
             0x5890: "T540-5090 Unified Wire Ethernet Controller [VF]",
             0x5891: "T522-5091 Unified Wire Ethernet Controller [VF]",
             0x5892: "T520-5092 Unified Wire Ethernet Controller [VF]",
             0x5893: "T580-5093 Unified Wire Ethernet Controller [VF]",
             0x5894: "T540-5094 Unified Wire Ethernet Controller [VF]",
             0x5895: "T540-5095 Unified Wire Ethernet Controller [VF]",
             0x5896: "T580-5096 Unified Wire Ethernet Controller [VF]",
             0x5897: "T520-5097 Unified Wire Ethernet Controller [VF]",
             0x5898: "T580-5098 Unified Wire Ethernet Controller [VF]",
             0x5899: "T580-5099 Unified Wire Ethernet Controller [VF]",
             0x589A: "T520-509A Unified Wire Ethernet Controller [VF]",
             0x589B: "T540-509B Unified Wire Ethernet Controller [VF]",
             0x589C: "T520-509C Unified Wire Ethernet Controller [VF]",
             0x589D: "T540-509D Unified Wire Ethernet Controller [VF]",
             0x589E: "T520-509E Unified Wire Ethernet Controller [VF]",
             0x589F: "T540-509F Unified Wire Ethernet Controller [VF]",
             0x58A0: "T540-50A0 Unified Wire Ethernet Controller [VF]",
             0x58A1: "T540-50A1 Unified Wire Ethernet Controller [VF]",
             0x58A2: "T580-50A2 Unified Wire Ethernet Controller [VF]",
             0x58A3: "T580-50A3 Unified Wire Ethernet Controller [VF]",
             0x58A4: "T540-50A4 Unified Wire Ethernet Controller [VF]",
             0x58A5: "T522-50A5 Unified Wire Ethernet Controller [VF]",
             0x58A6: "T522-50A6 Unified Wire Ethernet Controller [VF]",
             0x58A7: "T580-50A7 Unified Wire Ethernet Controller [VF]",
             0x58A8: "T580-50A8 Unified Wire Ethernet Controller [VF]",
             0x58A9: "T580-50A9 Unified Wire Ethernet Controller [VF]",
             0x58AA: "T580-50AA Unified Wire Ethernet Controller [VF]",
             0x58AB: "T520-50AB Unified Wire Ethernet Controller [VF]",
             0x58AC: "T540-50AC Unified Wire Ethernet Controller [VF]",
             0x58AD: "T520-50AD Unified Wire Ethernet Controller [VF]",
             0x58AE: "T540-50AE Unified Wire Ethernet Controller [VF]",
             0x58AF: "T580-50AF Unified Wire Ethernet Controller [VF]",
             0x58B0: "T520-50B0 Unified Wire Ethernet Controller [VF]",
             0x6001: "T6225-CR Unified Wire Ethernet Controller",
             0x6002: "T6225-SO-CR Unified Wire Ethernet Controller",
             0x6003: "T6425-CR Unified Wire Ethernet Controller",
             0x6004: "T6425-SO-CR Unified Wire Ethernet Controller",
             0x6005: "T6225-OCP-SO Unified Wire Ethernet Controller",
             0x6006: "T62100-OCP-SO Unified Wire Ethernet Controller",
             0x6007: "T62100-LP-CR Unified Wire Ethernet Controller",
             0x6008: "T62100-SO-CR Unified Wire Ethernet Controller",
             0x6009: "T6210-BT Unified Wire Ethernet Controller",
             0x600D: "T62100-CR Unified Wire Ethernet Controller",
             0x6011: "T6225-LL-CR Unified Wire Ethernet Controller",
             0x6014: "T61100-OCP-SO Unified Wire Ethernet Controller",
             0x6015: "T6201-BT Unified Wire Ethernet Controller",
             0x6080: "T6225-6080 Unified Wire Ethernet Controller",
             0x6081: "T62100-6081 Unified Wire Ethernet Controller",
             0x6082: "T6225-6082 Unified Wire Ethernet Controller",
             0x6083: "T62100-6083 Unified Wire Ethernet Controller",
             0x6084: "T64100-6084 Unified Wire Ethernet Controller",
             0x6085: "T6240-6085 Unified Wire Ethernet Controller",
             0x6086: "T6225-6086 Unified Wire Ethernet Controller",
             0x6087: "T6225-6087 Unified Wire Ethernet Controller",
             0x6088: "T62100-6088 Unified Wire Ethernet Controller",
             0x6089: "T62100-6089 Unified Wire Ethernet Controller",
             0x608A: "T62100-608a Unified Wire Ethernet Controller",
             0x6092: "T62100-KR Unified Wire Ethernet Controller",
             0x6401: "T6225-CR Unified Wire Ethernet Controller",
             0x6402: "T6225-SO-CR Unified Wire Ethernet Controller",
             0x6403: "T6425-CR Unified Wire Ethernet Controller",
             0x6404: "T6425-SO-CR Unified Wire Ethernet Controller",
             0x6405: "T6225-OCP-SO Unified Wire Ethernet Controller",
             0x6406: "T62100-OCP-SO Unified Wire Ethernet Controller",
             0x6407: "T62100-LP-CR Unified Wire Ethernet Controller",
             0x6408: "T62100-SO-CR Unified Wire Ethernet Controller",
             0x6409: "T6210-BT Unified Wire Ethernet Controller",
             0x640D: "T62100-CR Unified Wire Ethernet Controller",
             0x6411: "T6225-LL-CR Unified Wire Ethernet Controller",
             0x6414: "T61100-OCP-SO Unified Wire Ethernet Controller",
             0x6415: "T6201-BT Unified Wire Ethernet Controller",
             0x6480: "T6225-6080 Unified Wire Ethernet Controller",
             0x6481: "T62100-6081 Unified Wire Ethernet Controller",
             0x6482: "T6225-6082 Unified Wire Ethernet Controller",
             0x6483: "T62100-6083 Unified Wire Ethernet Controller",
             0x6484: "T64100-6084 Unified Wire Ethernet Controller",
             0x6485: "T6240-6085 Unified Wire Ethernet Controller",
             0x6486: "T6225-6086 Unified Wire Ethernet Controller",
             0x6487: "T6225-6087 Unified Wire Ethernet Controller",
             0x6488: "T62100-6088 Unified Wire Ethernet Controller",
             0x6489: "T62100-6089 Unified Wire Ethernet Controller",
             0x648A: "T62100-608a Unified Wire Ethernet Controller",
             0x6492: "T62100-KR Unified Wire Ethernet Controller",
             0x6501: "T6225-CR Unified Wire Storage Controller",
             0x6502: "T6225-SO-CR Unified Wire Storage Controller",
             0x6503: "T6425-CR Unified Wire Storage Controller",
             0x6504: "T6425-SO-CR Unified Wire Storage Controller",
             0x6505: "T6225-OCP-SO Unified Wire Storage Controller",
             0x6506: "T62100-OCP-SO Unified Wire Storage Controller",
             0x6507: "T62100-LP-CR Unified Wire Storage Controller",
             0x6508: "T62100-SO-CR Unified Wire Storage Controller",
             0x6509: "T6210-BT Unified Wire Storage Controller",
             0x650D: "T62100-CR Unified Wire Storage Controller",
             0x6511: "T6225-LL-CR Unified Wire Storage Controller",
             0x6514: "T61100-OCP-SO Unified Wire Storage Controller",
             0x6515: "T6201-BT Unified Wire Storage Controller",
             0x6580: "T6225-6080 Unified Wire Storage Controller",
             0x6581: "T62100-6081 Unified Wire Storage Controller",
             0x6582: "T6225-6082 Unified Wire Storage Controller",
             0x6583: "T62100-6083 Unified Wire Storage Controller",
             0x6584: "T64100-6084 Unified Wire Storage Controller",
             0x6585: "T6240-6085 Unified Wire Storage Controller",
             0x6586: "T6225-6086 Unified Wire Storage Controller",
             0x6587: "T6225-6087 Unified Wire Storage Controller",
             0x6588: "T62100-6088 Unified Wire Storage Controller",
             0x6589: "T62100-6089 Unified Wire Storage Controller",
             0x658A: "T62100-608a Unified Wire Storage Controller",
             0x6592: "T62100-KR Unified Wire Storage Controller",
             0x6601: "T6225-CR Unified Wire Storage Controller",
             0x6602: "T6225-SO-CR Unified Wire Storage Controller",
             0x6603: "T6425-CR Unified Wire Storage Controller",
             0x6604: "T6425-SO-CR Unified Wire Storage Controller",
             0x6605: "T6225-OCP-SO Unified Wire Storage Controller",
             0x6606: "T62100-OCP-SO Unified Wire Storage Controller",
             0x6607: "T62100-LP-CR Unified Wire Storage Controller",
             0x6608: "T62100-SO-CR Unified Wire Storage Controller",
             0x6609: "T6210-BT Unified Wire Storage Controller",
             0x660D: "T62100-CR Unified Wire Storage Controller",
             0x6611: "T6225-LL-CR Unified Wire Storage Controller",
             0x6614: "T61100-OCP-SO Unified Wire Storage Controller",
             0x6615: "T6201-BT Unified Wire Storage Controller",
             0x6680: "T6225-6080 Unified Wire Storage Controller",
             0x6681: "T62100-6081 Unified Wire Storage Controller",
             0x6682: "T6225-6082 Unified Wire Storage Controller",
             0x6683: "T62100-6083 Unified Wire Storage Controller",
             0x6684: "T64100-6084 Unified Wire Storage Controller",
             0x6685: "T6240-6085 Unified Wire Storage Controller",
             0x6686: "T6225-6086 Unified Wire Storage Controller",
             0x6687: "T6225-6087 Unified Wire Storage Controller",
             0x6688: "T62100-6088 Unified Wire Storage Controller",
             0x6689: "T62100-6089 Unified Wire Storage Controller",
             0x668A: "T62100-608a Unified Wire Storage Controller",
             0x6692: "T62100-KR Unified Wire Storage Controller",
             0x6801: "T6225-CR Unified Wire Ethernet Controller [VF]",
             0x6802: "T6225-SO-CR Unified Wire Ethernet Controller [VF]",
             0x6803: "T6425-CR Unified Wire Ethernet Controller [VF]",
             0x6804: "T6425-SO-CR Unified Wire Ethernet Controller [VF]",
             0x6805: "T6225-OCP-SO Unified Wire Ethernet Controller [VF]",
             0x6806: "T62100-OCP-SO Unified Wire Ethernet Controller [VF]",
             0x6807: "T62100-LP-CR Unified Wire Ethernet Controller [VF]",
             0x6808: "T62100-SO-CR Unified Wire Ethernet Controller [VF]",
             0x6809: "T6210-BT Unified Wire Ethernet Controller [VF]",
             0x680D: "T62100-CR Unified Wire Ethernet Controller [VF]",
             0x6811: "T6225-LL-CR Unified Wire Ethernet Controller [VF]",
             0x6814: "T61100-OCP-SO Unified Wire Ethernet Controller [VF]",
             0x6815: "T6201-BT Unified Wire Ethernet Controller [VF]",
             0x6880: "T6225-6080 Unified Wire Ethernet Controller [VF]",
             0x6881: "T62100-6081 Unified Wire Ethernet Controller [VF]",
             0x6882: "T6225-6082 Unified Wire Ethernet Controller [VF]",
             0x6883: "T62100-6083 Unified Wire Ethernet Controller [VF]",
             0x6884: "T64100-6084 Unified Wire Ethernet Controller [VF]",
             0x6885: "T6240-6085 Unified Wire Ethernet Controller [VF]",
             0x6886: "T6225-6086 Unified Wire Ethernet Controller [VF]",
             0x6887: "T6225-6087 Unified Wire Ethernet Controller [VF]",
             0x6888: "T62100-6088 Unified Wire Ethernet Controller [VF]",
             0x6889: "T62100-6089 Unified Wire Ethernet Controller [VF]",
             0x688A: "T62100-608a Unified Wire Ethernet Controller [VF]",
             0xA000: "PE10K Unified Wire Ethernet Controller",
             },

    # Vitec Multimedia
    0x142E: {0x4020: "VM2-2 [Video Maker 2] MPEG1/2 Encoder",
             0x4337: "VM2-2-C7 [Video Maker 2 rev. C7] MPEG1/2 Encoder",
             },

    # RTD Embedded Technologies, Inc.
    0x1435: {0x4520: "PCI4520",
             0x6020: "SPM6020",
             0x6030: "SPM6030",
             0x6420: "SPM186420",
             0x6430: "SPM176430",
             0x6431: "SPM176431",
             0x7520: "DM7520",
             0x7540: "SDM7540",
             0x7820: "DM7820",
             },

    # Adlink Technology
    0x144A: {0x6208: "PCI-6208V",
             0x7250: "PCI-7250",
             0x7296: "PCI-7296",
             0x7432: "PCI-7432",
             0x7433: "PCI-7433",
             0x7434: "PCI-7434",
             0x7841: "PCI-7841",
             0x8133: "PCI-8133",
             0x8164: "PCI-8164",
             0x8554: "PCI-8554",
             0x9111: "PCI-9111",
             0x9113: "PCI-9113",
             0x9114: "PCI-9114",
             0xA001: "ADi-BSEC",
             },

    # Samsung Electronics Co Ltd
    0x144D: {0x1600: "Apple PCIe SSD",
             0xA544: "Exynos 8890 PCIe Root Complex",
             0xA575: "Exynos 7420 PCIe Root Complex",
             0xA5E3: "Exynos 5433 PCIe Root Complex",
             0xA800: "XP941 PCIe SSD",
             0xA802: "NVMe SSD Controller SM951/PM951",
             0xA804: "NVMe SSD Controller SM961/PM961/SM963",
             0xA808: "NVMe SSD Controller SM981/PM981/PM983",
             0xA809: "NVMe SSD Controller 980",
             0xA80A: "NVMe SSD Controller PM9A1/PM9A3/980PRO",
             0xA80B: "NVMe SSD Controller PM9B1",
             0xA820: "NVMe SSD Controller 171X",
             0xA821: "NVMe SSD Controller 172X",
             0xA822: "NVMe SSD Controller 172Xa/172Xb",
             0xA824: "NVMe SSD Controller PM173X",
             0xA825: "NVMe SSD Controller PM173Xa",
             0xA826: "NVMe SSD Controller PM174X",
             0xECEC: "Exynos 8895 PCIe Root Complex",
             },

    # Gigabyte Technology Co., Ltd
    0x1458: {0x22E8: "Ellesmere [Radeon RX 480]",
             0x3483: "USB 3.0 Controller (VIA VL80x-based xHCI Controller)",
             },

    # Avermedia Technologies Inc
    0x1461: {0xA3CE: "M179",
             0xA3CF: "M179",
             0xA836: "M115 DVB-T, PAL/SECAM/NTSC Tuner",
             0xE836: "M115S Hybrid Analog/DVB PAL/SECAM/NTSC Tuner",
             0xF436: "AVerTV Hybrid+FM",
             },

    # Micro-Star International Co., Ltd. [MSI]
    0x1462: {0x3483: "MSI USB 3.0 (VIA VL80x-based xHCI USB Controller)",
             0x7C56: "Realtek Ethernet controller RTL8111H",
             0xAAF0: "Radeon RX 580 Gaming X 8G",
             },

    # Aeroflex
    0x146A: {0x3010: "3010 RF Synthesizer",
             0x3A11: "3011A PXI RF Synthesizer",
             },

    # Tul Corporation / PowerColor
    0x148C: {0x2391: "Radeon RX 590 [Red Devil]",
             0x2398: "AXRX 5700 XT 8GBD6-3DHE/OC [PowerColor Red Devil Radeon RX 5700 XT]",
             },

    # TEWS Technologies GmbH
    0x1498: {0x0330: "TPMC816 2 Channel CAN bus controller.",
             0x035D: "TPMC861 4-Channel Isolated Serial Interface RS422/RS485",
             0x0385: "TPMC901 Extended CAN bus with 2/4/6 CAN controller",
             0x21CC: "TCP460 CompactPCI 16 Channel Serial Interface RS232/RS422",
             0x21CD: "TCP461 CompactPCI 8 Channel Serial Interface RS232/RS422",
             0x3064: "TPCI100 (2 Slot IndustryPack PCI Carrier)",
             0x30C8: "TPCI200 4 Slot IndustryPack PCI Carrier",
             0x70C8: "TPCE200 4 Slot IndustryPack PCIe Carrier",
             0x9177: "TXMC375 8 channel RS232/RS422/RS485 programmable serial interface",
             },

    # Lite-On Technology Corporation
    0x14A4: {0x22F1: "M8Pe Series NVMe SSD",
             0x4318: "Broadcom BCM4318 [AirForce One 54g] 802.11g WLAN Controller",
             },

    # Creamware GmBH
    0x14B5: {0x0200: "Scope",
             0x0300: "Pulsar",
             0x0400: "PulsarSRB",
             0x0600: "Pulsar2",
             0x0800: "DSP-Board",
             0x0900: "DSP-Board",
             0x0A00: "DSP-Board",
             0x0B00: "DSP-Board",
             },

    # Cisco Aironet Wireless Communications
    0x14B9: {0x0001: "PC4800",
             0x0340: "PC4800",
             0x0350: "350 series 802.11b Wireless LAN Adapter",
             0x4500: "PC4500",
             0x4800: "Cisco Aironet 340 802.11b Wireless LAN Adapter/Aironet PC4800",
             0xA504: "Cisco Aironet Wireless 802.11b",
             0xA505: "Cisco Aironet CB20a 802.11a Wireless LAN Adapter",
             0xA506: "Cisco Aironet Mini PCI b/g",
             },

    # Globespan Semiconductor Inc.
    0x14BC: {0xD002: "Pulsar [PCI ADSL Card]",
             0xD00F: "Pulsar [PCI ADSL Card]",
             },

    # MYRICOM Inc.
    0x14C1: {0x0008: "Myri-10G Dual-Protocol NIC",
             0x8043: "Myrinet 2000 Scalable Cluster Interconnect",
             },

    # MEDIATEK Corp.
    0x14C3: {0x0608: "MT7921K (RZ608) Wi-Fi 6E 80MHz",
             0x0616: "MT7922 802.11ax PCI Express Wireless Network Adapter",
             0x7612: "MT7612E 802.11acbgn PCI Express Wireless Network Adapter",
             0x7615: "MT7615E 802.11ac PCI Express Wireless Network Adapter",
             0x7630: "MT7630e 802.11bgn Wireless Network Adapter",
             0x7662: "MT7662E 802.11ac PCI Express Wireless Network Adapter",
             0x7915: "MT7915E 802.11ax PCI Express Wireless Network Adapter",
             0x7961: "MT7921 802.11ax PCI Express Wireless Network Adapter",
             },

    # Universal Global Scientific Industrial Co.,Ltd
    0x14CD: {0x0001: "USI-1514-1GbaseT [OCP1]",
             0x0002: "USI-4227-SFP [OCP2]",
             0x0003: "USI-X557-10GbaseT [OCP3]",
             },

    # Titan Electronics Inc
    0x14D2: {0x8001: "VScom 010L 1 port parallel adaptor",
             0x8002: "VScom 020L 2 port parallel adaptor",
             0x8010: "VScom 100L 1 port serial adaptor",
             0x8011: "VScom 110L 1 port serial and 1 port parallel adaptor",
             0x8020: "VScom 200L 1 or 2 port serial adaptor",
             0x8021: "VScom 210L 2 port serial and 1 port parallel adaptor",
             0x8028: "VScom 200I/200I-SI 2-port serial adapter",
             0x8040: "VScom 400L 4 port serial adaptor",
             0x8043: "VScom 430L 4-port serial and 3-port parallel adapter",
             0x8048: "VScom 400I 4-port serial adapter",
             0x8080: "VScom 800L 8 port serial adaptor",
             0x8088: "VScom 800I 8-port serial adapter",
             0xA000: "VScom 010H 1 port parallel adaptor",
             0xA001: "VScom 100H 1 port serial adaptor",
             0xA003: "VScom 400H 4 port serial adaptor",
             0xA004: "VScom 400HF1 4 port serial adaptor",
             0xA005: "VScom 200H 2 port serial adaptor",
             0xA007: "VScom PCI800EH (PCIe) 8-port serial adapter Port 1-4",
             0xA008: "VScom PCI800EH (PCIe) 8-port serial adapter Port 5-8",
             0xA009: "VScom PCI400EH (PCIe) 4-port serial adapter",
             0xE001: "VScom 010HV2 1 port parallel adaptor",
             0xE010: "VScom 100HV2 1 port serial adaptor",
             0xE020: "VScom 200HV2 2 port serial adaptor",
             },

    # CIRTECH (UK) Ltd
    0x14D3: {0x0002: "DTL-T14000 Rev. 1 [PS2 TOOL CD/DVD Emulator]",
             0x0003: "DTL-T14000 Rev. 2 [PS2 TOOL CD/DVD Emulator]",
             0x0004: "DTL-T14000 Rev. 3 [PS2 TOOL CD/DVD Emulator]",
             },

    # Accusys Inc
    0x14D6: {0x6101: "ACS-61xxx, PCIe to SAS/SATA RAID HBA",
             0x6201: "ACS-62xxx, External PCIe to SAS/SATA RAID controller",
             },

    # Alliance Semiconductor Corporation
    0x14D9: {0x0010: "AP1011/SP1011 HyperTransport-PCI Bridge [Sturgeon]",
             0x9000: "AS90L10204/10208 HyperTransport to PCI-X Bridge",
             },

    # AFAVLAB Technology Inc
    0x14DB: {0x2120: "TK9902",
             0x2182: "AFAVLAB Technology Inc. 8-port serial card",
             },

    # Amplicon Liveline Ltd
    0x14DC: {0x0000: "PCI230",
             0x0001: "PCI242",
             0x0002: "PCI244",
             0x0003: "PCI247",
             0x0004: "PCI248",
             0x0005: "PCI249",
             0x0006: "PCI260",
             0x0007: "PCI224",
             0x0008: "PCI234",
             0x0009: "PCI236",
             0x000A: "PCI272",
             0x000B: "PCI215",
             },

    # Broadcom Inc. and subsidiaries
    0x14E4: {0x0576: "BCM43224 802.11a/b/g/n",
             0x0800: "Sentry5 Chipcommon I/O Controller",
             0x0804: "Sentry5 PCI Bridge",
             0x0805: "Sentry5 MIPS32 CPU",
             0x0806: "Sentry5 Ethernet Controller",
             0x080B: "Sentry5 Crypto Accelerator",
             0x080F: "Sentry5 DDR/SDR RAM Controller",
             0x0811: "Sentry5 External Interface Core",
             0x0816: "BCM3302 Sentry5 MIPS32 CPU",
             0x1570: "720p FaceTime HD Camera",
             0x1600: "NetXtreme BCM5752 Gigabit Ethernet PCI Express",
             0x1601: "NetXtreme BCM5752M Gigabit Ethernet PCI Express",
             0x1604: "BCM5745X NetXtreme-E Ethernet Partition",
             0x1605: "BCM5745X NetXtreme-E RDMA Partition",
             0x1606: "BCM5745X NetXtreme-E RDMA Virtual Function",
             0x1609: "BCM5745X NetXtreme-E Ethernet Virtual Function",
             0x1612: "BCM70012 Video Decoder [Crystal HD]",
             0x1614: "BCM57454 NetXtreme-E 10Gb/25Gb/40Gb/50Gb/100Gb Ethernet",
             0x1615: "BCM70015 Video Decoder [Crystal HD]",
             0x1639: "NetXtreme II BCM5709 Gigabit Ethernet",
             0x163A: "NetXtreme II BCM5709S Gigabit Ethernet",
             0x163B: "NetXtreme II BCM5716 Gigabit Ethernet",
             0x163C: "NetXtreme II BCM5716S Gigabit Ethernet",
             0x163D: "NetXtreme II BCM57811 10-Gigabit Ethernet",
             0x163E: "NetXtreme II BCM57811 10 Gigabit Ethernet Multi Function",
             0x163F: "NetXtreme II BCM57811 10-Gigabit Ethernet Virtual Function",
             0x1641: "NetXtreme BCM57787 Gigabit Ethernet PCIe",
             0x1642: "NetXtreme BCM57764 Gigabit Ethernet PCIe",
             0x1643: "NetXtreme BCM5725 Gigabit Ethernet PCIe",
             0x1644: "NetXtreme BCM5700 Gigabit Ethernet",
             0x1645: "NetXtreme BCM5701 Gigabit Ethernet",
             0x1646: "NetXtreme BCM5702 Gigabit Ethernet",
             0x1647: "NetXtreme BCM5703 Gigabit Ethernet",
             0x1648: "NetXtreme BCM5704 Gigabit Ethernet",
             0x1649: "NetXtreme BCM5704S_2 Gigabit Ethernet",
             0x164A: "NetXtreme II BCM5706 Gigabit Ethernet",
             0x164C: "NetXtreme II BCM5708 Gigabit Ethernet",
             0x164D: "NetXtreme BCM5702FE Gigabit Ethernet",
             0x164E: "NetXtreme II BCM57710 10-Gigabit PCIe [Everest]",
             0x164F: "NetXtreme II BCM57711 10-Gigabit PCIe",
             0x1650: "NetXtreme II BCM57711E 10-Gigabit PCIe",
             0x1653: "NetXtreme BCM5705 Gigabit Ethernet",
             0x1654: "NetXtreme BCM5705_2 Gigabit Ethernet",
             0x1655: "NetXtreme BCM5717 Gigabit Ethernet PCIe",
             0x1656: "NetXtreme BCM5718 Gigabit Ethernet PCIe",
             0x1657: "NetXtreme BCM5719 Gigabit Ethernet PCIe",
             0x1659: "NetXtreme BCM5721 Gigabit Ethernet PCI Express",
             0x165A: "NetXtreme BCM5722 Gigabit Ethernet PCI Express",
             0x165B: "NetXtreme BCM5723 Gigabit Ethernet PCIe",
             0x165C: "NetXtreme BCM5724 Gigabit Ethernet PCIe",
             0x165D: "NetXtreme BCM5705M Gigabit Ethernet",
             0x165E: "NetXtreme BCM5705M_2 Gigabit Ethernet",
             0x165F: "NetXtreme BCM5720 Gigabit Ethernet PCIe",
             0x1662: "NetXtreme II BCM57712 10 Gigabit Ethernet",
             0x1663: "NetXtreme II BCM57712 10 Gigabit Ethernet Multi Function",
             0x1665: "NetXtreme BCM5717 Gigabit Ethernet PCIe",
             0x1668: "NetXtreme BCM5714 Gigabit Ethernet",
             0x1669: "NetXtreme 5714S Gigabit Ethernet",
             0x166A: "NetXtreme BCM5780 Gigabit Ethernet",
             0x166B: "NetXtreme BCM5780S Gigabit Ethernet",
             0x166E: "570x 10/100 Integrated Controller",
             0x166F: "NetXtreme II BCM57712 10 Gigabit Ethernet Virtual Function",
             0x1672: "NetXtreme BCM5754M Gigabit Ethernet PCI Express",
             0x1673: "NetXtreme BCM5755M Gigabit Ethernet PCI Express",
             0x1674: "NetXtreme BCM5756ME Gigabit Ethernet PCI Express",
             0x1677: "NetXtreme BCM5751 Gigabit Ethernet PCI Express",
             0x1678: "NetXtreme BCM5715 Gigabit Ethernet",
             0x1679: "NetXtreme BCM5715S Gigabit Ethernet",
             0x167A: "NetXtreme BCM5754 Gigabit Ethernet PCI Express",
             0x167B: "NetXtreme BCM5755 Gigabit Ethernet PCI Express",
             0x167D: "NetXtreme BCM5751M Gigabit Ethernet PCI Express",
             0x167E: "NetXtreme BCM5751F Fast Ethernet PCI Express",
             0x167F: "NetLink BCM5787F Fast Ethernet PCI Express",
             0x1680: "NetXtreme BCM5761e Gigabit Ethernet PCIe",
             0x1681: "NetXtreme BCM5761 Gigabit Ethernet PCIe",
             0x1682: "NetXtreme BCM57762 Gigabit Ethernet PCIe",
             0x1683: "NetXtreme BCM57767 Gigabit Ethernet PCIe",
             0x1684: "NetXtreme BCM5764M Gigabit Ethernet PCIe",
             0x1685: "NetXtreme II BCM57500S Gigabit Ethernet",
             0x1686: "NetXtreme BCM57766 Gigabit Ethernet PCIe",
             0x1687: "NetXtreme BCM5762 Gigabit Ethernet PCIe",
             0x1688: "NetXtreme BCM5761 10/100/1000BASE-T Ethernet",
             0x168A: "NetXtreme II BCM57800 1/10 Gigabit Ethernet",
             0x168D: "NetXtreme II BCM57840 10/20 Gigabit Ethernet",
             0x168E: "NetXtreme II BCM57810 10 Gigabit Ethernet",
             0x1690: "NetXtreme BCM57760 Gigabit Ethernet PCIe",
             0x1691: "NetLink BCM57788 Gigabit Ethernet PCIe",
             0x1692: "NetLink BCM57780 Gigabit Ethernet PCIe",
             0x1693: "NetLink BCM5787M Gigabit Ethernet PCI Express",
             0x1694: "NetLink BCM57790 Gigabit Ethernet PCIe",
             0x1696: "NetXtreme BCM5782 Gigabit Ethernet",
             0x1698: "NetLink BCM5784M Gigabit Ethernet PCIe",
             0x1699: "NetLink BCM5785 Gigabit Ethernet",
             0x169A: "NetLink BCM5786 Gigabit Ethernet PCI Express",
             0x169B: "NetLink BCM5787 Gigabit Ethernet PCI Express",
             0x169C: "NetXtreme BCM5788 Gigabit Ethernet",
             0x169D: "NetLink BCM5789 Gigabit Ethernet PCI Express",
             0x16A0: "NetLink BCM5785 Fast Ethernet",
             0x16A1: "BCM57840 NetXtreme II 10 Gigabit Ethernet",
             0x16A2: "BCM57840 NetXtreme II 10/20-Gigabit Ethernet",
             0x16A3: "NetXtreme BCM57786 Gigabit Ethernet PCIe",
             0x16A4: "BCM57840 NetXtreme II Ethernet Multi Function",
             0x16A5: "NetXtreme II BCM57800 1/10 Gigabit Ethernet Multi Function",
             0x16A6: "NetXtreme BCM5702X Gigabit Ethernet",
             0x16A7: "NetXtreme BCM5703X Gigabit Ethernet",
             0x16A8: "NetXtreme BCM5704S Gigabit Ethernet",
             0x16A9: "NetXtreme II BCM57800 1/10 Gigabit Ethernet Virtual Function",
             0x16AA: "NetXtreme II BCM5706S Gigabit Ethernet",
             0x16AB: "NetXtreme II BCM57840 10/20 Gigabit Ethernet Multi Function",
             0x16AC: "NetXtreme II BCM5708S Gigabit Ethernet",
             0x16AD: "NetXtreme II BCM57840 10/20 Gigabit Ethernet Virtual Function",
             0x16AE: "NetXtreme II BCM57810 10 Gigabit Ethernet Multi Function",
             0x16AF: "NetXtreme II BCM57810 10 Gigabit Ethernet Virtual Function",
             0x16B0: "NetXtreme BCM57761 Gigabit Ethernet PCIe",
             0x16B1: "NetLink BCM57781 Gigabit Ethernet PCIe",
             0x16B2: "NetLink BCM57791 Gigabit Ethernet PCIe",
             0x16B3: "NetXtreme BCM57786 Gigabit Ethernet PCIe",
             0x16B4: "NetXtreme BCM57765 Gigabit Ethernet PCIe",
             0x16B5: "NetLink BCM57785 Gigabit Ethernet PCIe",
             0x16B6: "NetLink BCM57795 Gigabit Ethernet PCIe",
             0x16B7: "NetXtreme BCM57782 Gigabit Ethernet PCIe",
             0x16BC: "BCM57765/57785 SDXC/MMC Card Reader",
             0x16BE: "BCM57765/57785 MS Card Reader",
             0x16BF: "BCM57765/57785 xD-Picture Card Reader",
             0x16C1: "NetXtreme-E RDMA Virtual Function",
             0x16C6: "NetXtreme BCM5702A3 Gigabit Ethernet",
             0x16C7: "NetXtreme BCM5703 Gigabit Ethernet",
             0x16C8: "BCM57301 NetXtreme-C 10Gb Ethernet Controller",
             0x16C9: "BCM57302 NetXtreme-C 10Gb/25Gb Ethernet Controller",
             0x16CA: "BCM57304 NetXtreme-C 10Gb/25Gb/40Gb/50Gb Ethernet Controller",
             0x16CB: "NetXtreme-C Ethernet Virtual Function",
             0x16CC: "BCM57417 NetXtreme-E Ethernet Partition",
             0x16CE: "BCM57311 NetXtreme-C 10Gb RDMA Ethernet Controller",
             0x16CF: "BCM57312 NetXtreme-C 10Gb/25Gb RDMA Ethernet Controller",
             0x16D0: "BCM57402 NetXtreme-E 10Gb Ethernet Controller",
             0x16D1: "BCM57404 NetXtreme-E 10Gb/25Gb Ethernet Controller",
             0x16D2: "BCM57406 NetXtreme-E 10GBASE-T Ethernet Controller",
             0x16D3: "NetXtreme-E Ethernet Virtual Function",
             0x16D4: "BCM57402 NetXtreme-E Ethernet Partition",
             0x16D5: "BCM57407 NetXtreme-E 10GBase-T Ethernet Controller",
             0x16D6: "BCM57412 NetXtreme-E 10Gb RDMA Ethernet Controller",
             0x16D7: "BCM57414 NetXtreme-E 10Gb/25Gb RDMA Ethernet Controller",
             0x16D8: "BCM57416 NetXtreme-E Dual-Media 10G RDMA Ethernet Controller",
             0x16D9: "BCM57417 NetXtreme-E 10GBASE-T RDMA Ethernet Controller",
             0x16DC: "NetXtreme-E Ethernet Virtual Function",
             0x16DD: "NetLink BCM5781 Gigabit Ethernet PCI Express",
             0x16DE: "BCM57412 NetXtreme-E Ethernet Partition",
             0x16DF: "BCM57314 NetXtreme-C 10Gb/25Gb/40Gb/50Gb RDMA Ethernet Controller",
             0x16E1: "NetXtreme-C Ethernet Virtual Function",
             0x16E2: "BCM57417 NetXtreme-E 10Gb/25Gb RDMA Ethernet Controller",
             0x16E3: "BCM57416 NetXtreme-E 10Gb RDMA Ethernet Controller",
             0x16E5: "NetXtreme-C RDMA Virtual Function",
             0x16E7: "BCM57404 NetXtreme-E Ethernet Partition",
             0x16E8: "BCM57406 NetXtreme-E Ethernet Partition",
             0x16E9: "BCM57407 NetXtreme-E 25Gb Ethernet Controller",
             0x16EB: "BCM57412 NetXtreme-E RDMA Partition",
             0x16EC: "BCM57414 NetXtreme-E Ethernet Partition",
             0x16ED: "BCM57414 NetXtreme-E RDMA Partition",
             0x16EE: "BCM57416 NetXtreme-E Ethernet Partition",
             0x16EF: "BCM57416 NetXtreme-E RDMA Partition",
             0x16F1: "BCM57452 NetXtreme-E 10Gb/25Gb/40Gb/50Gb Ethernet",
             0x16F3: "NetXtreme BCM5727 Gigabit Ethernet PCIe",
             0x16F7: "NetXtreme BCM5753 Gigabit Ethernet PCI Express",
             0x16FD: "NetXtreme BCM5753M Gigabit Ethernet PCI Express",
             0x16FE: "NetXtreme BCM5753F Fast Ethernet PCI Express",
             0x170C: "BCM4401-B0 100Base-TX",
             0x170D: "NetXtreme BCM5901 100Base-TX",
             0x170E: "NetXtreme BCM5901 100Base-TX",
             0x1712: "NetLink BCM5906 Fast Ethernet PCI Express",
             0x1713: "NetLink BCM5906M Fast Ethernet PCI Express",
             0x1750: "BCM57508 NetXtreme-E 10Gb/25Gb/40Gb/50Gb/100Gb/200Gb Ethernet",
             0x1751: "BCM57504 NetXtreme-E 10Gb/25Gb/40Gb/50Gb/100Gb/200Gb Ethernet",
             0x1752: "BCM57502 NetXtreme-E 10Gb/25Gb/40Gb/50Gb Ethernet",
             0x1800: "BCM57502 NetXtreme-E Ethernet Partition",
             0x1801: "BCM57504 NetXtreme-E Ethernet Partition",
             0x1802: "BCM57508 NetXtreme-E Ethernet Partition",
             0x1803: "BCM57502 NetXtreme-E RDMA Partition",
             0x1804: "BCM57504 NetXtreme-E RDMA Partition",
             0x1805: "BCM57508 NetXtreme-E RDMA Partition",
             0x1806: "BCM5750X NetXtreme-E Ethernet Virtual Function",
             0x1807: "BCM5750X NetXtreme-E RDMA Virtual Function",
             0x1808: "BCM5750X NetXtreme-E Ethernet Virtual Function",
             0x1809: "BCM5750X NetXtreme-E RDMA Virtual Function",
             0x2711: "BCM2711 PCIe Bridge",
             0x3352: "BCM3352",
             0x3360: "BCM3360",
             0x4210: "BCM4210 iLine10 HomePNA 2.0",
             0x4211: "BCM4211 iLine10 HomePNA 2.0 + V.90 56k modem",
             0x4212: "BCM4212 v.90 56k modem",
             0x4220: "802-11b/g Wireless PCI controller, packaged as a Linksys WPC54G ver 1.2 PCMCIA card",
             0x4222: "NetXtreme BCM5753M Gigabit Ethernet PCI Express",
             0x4301: "BCM4301 802.11b Wireless LAN Controller",
             0x4305: "BCM4307 V.90 56k Modem",
             0x4306: "BCM4306 802.11bg Wireless LAN controller",
             0x4307: "BCM4306 802.11bg Wireless LAN Controller",
             0x4310: "BCM4310 Chipcommon I/OController",
             0x4311: "BCM4311 802.11b/g WLAN",
             0x4312: "BCM4311 802.11a/b/g",
             0x4313: "BCM4311 802.11a",
             0x4315: "BCM4312 802.11b/g LP-PHY",
             0x4318: "BCM4318 [AirForce One 54g] 802.11g Wireless LAN Controller",
             0x4319: "BCM4318 [AirForce 54g] 802.11a/b/g PCI Express Transceiver",
             0x4320: "BCM4306 802.11b/g Wireless LAN Controller",
             0x4321: "BCM4321 802.11a Wireless Network Controller",
             0x4322: "BCM4322 802.11bgn Wireless Network Controller",
             0x4324: "BCM4309 802.11abg Wireless Network Controller",
             0x4325: "BCM4306 802.11bg Wireless Network Controller",
             0x4326: "BCM4307 Chipcommon I/O Controller?",
             0x4328: "BCM4321 802.11a/b/g/n",
             0x4329: "BCM4321 802.11b/g/n",
             0x432A: "BCM4321 802.11an Wireless Network Controller",
             0x432B: "BCM4322 802.11a/b/g/n Wireless LAN Controller",
             0x432C: "BCM4322 802.11b/g/n",
             0x432D: "BCM4322 802.11an Wireless Network Controller",
             0x4331: "BCM4331 802.11a/b/g/n",
             0x4333: "Serial (EDGE/GPRS modem part of Option GT Combo Edge)",
             0x4344: "EDGE/GPRS data and 802.11b/g combo cardbus [GC89]",
             0x4350: "BCM43222 Wireless Network Adapter",
             0x4351: "BCM43222 802.11abgn Wireless Network Adapter",
             0x4353: "BCM43224 802.11a/b/g/n",
             0x4357: "BCM43225 802.11b/g/n",
             0x4358: "BCM43227 802.11b/g/n",
             0x4359: "BCM43228 802.11a/b/g/n",
             0x4360: "BCM4360 802.11ac Wireless Network Adapter",
             0x4365: "BCM43142 802.11b/g/n",
             0x43A0: "BCM4360 802.11ac Wireless Network Adapter",
             0x43A1: "BCM4360 802.11ac Wireless Network Adapter",
             0x43A2: "BCM4360 802.11ac Wireless Network Adapter",
             0x43A3: "BCM4350 802.11ac Wireless Network Adapter",
             0x43A9: "BCM43217 802.11b/g/n",
             0x43AA: "BCM43131 802.11b/g/n",
             0x43AE: "BCM43162 802.11ac Wireless Network Adapter",
             0x43B1: "BCM4352 802.11ac Wireless Network Adapter",
             0x43BA: "BCM43602 802.11ac Wireless LAN SoC",
             0x43BB: "BCM43602 802.11ac Wireless LAN SoC",
             0x43BC: "BCM43602 802.11ac Wireless LAN SoC",
             0x43D3: "BCM43567 802.11ac Wireless Network Adapter",
             0x43D9: "BCM43570 802.11ac Wireless Network Adapter",
             0x43DC: "BCM4355 802.11ac Wireless LAN SoC",
             0x43DF: "BCM4354 802.11ac Wireless LAN SoC",
             0x43E9: "BCM4358 802.11ac Wireless LAN SoC",
             0x43EC: "BCM4356 802.11ac Wireless Network Adapter",
             0x4401: "BCM4401 100Base-T",
             0x4402: "BCM4402 Integrated 10/100BaseT",
             0x4403: "BCM4402 V.90 56k Modem",
             0x4410: "BCM4413 iLine32 HomePNA 2.0",
             0x4411: "BCM4413 V.90 56k modem",
             0x4412: "BCM4412 10/100BaseT",
             0x4415: "BCM4359 802.11ac Dual-Band Wireless Network Controller",
             0x441F: "BCM4361 802.11ac Dual-Band Wireless Network Controller",
             0x4420: "BCM4361 802.11ac 2.4 GHz Wireless Network Controller",
             0x4421: "BCM4361 802.11ac 5 GHz Wireless Network Controller",
             0x4425: "BRCM4378 Wireless Network Adapter",
             0x4430: "BCM44xx CardBus iLine32 HomePNA 2.0",
             0x4432: "BCM4432 CardBus 10/100BaseT",
             0x4464: "BCM4364 802.11ac Wireless Network Adapter",
             0x4488: "BCM4377b Wireless Network Adapter",
             0x4610: "BCM4610 Sentry5 PCI to SB Bridge",
             0x4611: "BCM4610 Sentry5 iLine32 HomePNA 1.0",
             0x4612: "BCM4610 Sentry5 V.90 56k Modem",
             0x4613: "BCM4610 Sentry5 Ethernet Controller",
             0x4614: "BCM4610 Sentry5 External Interface",
             0x4615: "BCM4610 Sentry5 USB Controller",
             0x4704: "BCM4704 PCI to SB Bridge",
             0x4705: "BCM4704 Sentry5 802.11b Wireless LAN Controller",
             0x4706: "BCM4704 Sentry5 Ethernet Controller",
             0x4707: "BCM4704 Sentry5 USB Controller",
             0x4708: "BCM4704 Crypto Accelerator",
             0x4710: "BCM4710 Sentry5 PCI to SB Bridge",
             0x4711: "BCM47xx Sentry5 iLine32 HomePNA 2.0",
             0x4712: "BCM47xx V.92 56k modem",
             0x4713: "Sentry5 Ethernet Controller",
             0x4714: "BCM47xx Sentry5 External Interface",
             0x4715: "BCM47xx Sentry5 USB / Ethernet Controller",
             0x4716: "BCM47xx Sentry5 USB Host Controller",
             0x4717: "BCM47xx Sentry5 USB Device Controller",
             0x4718: "Sentry5 Crypto Accelerator",
             0x4719: "BCM47xx/53xx RoboSwitch Core",
             0x4720: "BCM4712 MIPS CPU",
             0x4727: "BCM4313 802.11bgn Wireless Network Adapter",
             0x5365: "BCM5365P Sentry5 Host Bridge",
             0x5600: "BCM5600 StrataSwitch 24+2 Ethernet Switch Controller",
             0x5605: "BCM5605 StrataSwitch 24+2 Ethernet Switch Controller",
             0x5615: "BCM5615 StrataSwitch 24+2 Ethernet Switch Controller",
             0x5625: "BCM5625 StrataSwitch 24+2 Ethernet Switch Controller",
             0x5645: "BCM5645 StrataSwitch 24+2 Ethernet Switch Controller",
             0x5670: "BCM5670 8-Port 10GE Ethernet Switch Fabric",
             0x5680: "BCM5680 G-Switch 8 Port Gigabit Ethernet Switch Controller",
             0x5690: "BCM5690 12-port Multi-Layer Gigabit Ethernet Switch",
             0x5691: "BCM5691 GE/10GE 8+2 Gigabit Ethernet Switch Controller",
             0x5692: "BCM5692 12-port Multi-Layer Gigabit Ethernet Switch",
             0x5695: "BCM5695 12-port + HiGig Multi-Layer Gigabit Ethernet Switch",
             0x5698: "BCM5698 12-port Multi-Layer Gigabit Ethernet Switch",
             0x5820: "BCM5820 Crypto Accelerator",
             0x5821: "BCM5821 Crypto Accelerator",
             0x5822: "BCM5822 Crypto Accelerator",
             0x5823: "BCM5823 Crypto Accelerator",
             0x5824: "BCM5824 Crypto Accelerator",
             0x5840: "BCM5840 Crypto Accelerator",
             0x5841: "BCM5841 Crypto Accelerator",
             0x5850: "BCM5850 Crypto Accelerator",
             0x5E87: "Valkyrie offload engine",
             0x5E88: "Viper Offload Engine",
             0x5F69: "BRCM4378 Bluetooth Controller",
             0x5F71: "BRCM4387 Bluetooth Controller",
             0x5FA0: "BRCM4377 Bluetooth Controller",
             0x8602: "BCM7400/BCM7405 Serial ATA Controller",
             0x9026: "CN99xx [ThunderX2] Integrated USB 3.0 xHCI Host Controller",
             0x9027: "CN99xx [ThunderX2] Integrated AHCI/SATA 3 Host Controller",
             0xA8D8: "BCM43224/5 Wireless Network Adapter",
             0xAA52: "BCM43602 802.11ac Wireless LAN SoC",
             0xB080: "BCM56080 Firelight2 Switch ASIC",
             0xB302: "BCM56302 StrataXGS 24x1GE 2x10GE Switch Controller",
             0xB334: "BCM56334 StrataXGS 24x1GE 4x10GE Switch Controller",
             0xB370: "BCM56370 Switch ASIC",
             0xB371: "BCM56371 Switch ASIC",
             0xB372: "BCM56372 Switch ASIC",
             0xB375: "BCM56375 Switch ASIC",
             0xB376: "BCM56376 Switch ASIC",
             0xB377: "BCM56377 Switch ASIC",
             0xB379: "Broadcom BCM56379 Switch ASIC",
             0xB470: "BCM56470 SWITCH ASIC",
             0xB471: "BCM56471 SWITCH ASIC",
             0xB472: "BCM56472 SWITCH ASIC",
             0xB800: "BCM56800 StrataXGS 10GE Switch Controller",
             0xB842: "BCM56842 Trident 10GE Switch Controller",
             0xB850: "Broadcom BCM56850 Switch ASIC",
             0xB880: "BCM56880 Switch ASIC",
             0xB960: "Broadcom BCM56960 Switch ASIC",
             0xB990: "BCM56990 Switch ASIC",
             0xB996: "BCM56996 Tomahawk4G 106G Switch ASIC",
             0xB998: "BCM56998 Tomahawk4GT 106G Switch ASIC",
             0xB999: "BCM56999 Tomahawk4D 106G Switch ASIC",
             0xC909: "BCM78909 Switch ASIC",
             0xD802: "BCM58802 Stingray 50Gb Ethernet SoC",
             0xD804: "BCM58804 Stingray 100Gb Ethernet SoC",
             0xF800: "BCM78800 switch ASIC for f800",
             },

    # Planex Communications, Inc
    0x14EA: {0xAB06: "FNW-3603-TX CardBus Fast Ethernet",
             0xAB07: "RTL81xx RealTek Ethernet",
             0xAB08: "FNW-3602-TX CardBus Fast Ethernet",
             },

    # Conexant Systems, Inc.
    0x14F1: {0x1002: "HCF 56k Modem",
             0x1003: "HCF 56k Modem",
             0x1004: "HCF 56k Modem",
             0x1005: "HCF 56k Modem",
             0x1006: "HCF 56k Modem",
             0x1022: "HCF 56k Modem",
             0x1023: "HCF 56k Modem",
             0x1024: "HCF 56k Modem",
             0x1025: "HCF 56k Modem",
             0x1026: "HCF 56k Modem",
             0x1032: "HCF 56k Modem",
             0x1033: "HCF 56k Data/Fax Modem",
             0x1034: "HCF 56k Data/Fax/Voice Modem",
             0x1035: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem",
             0x1036: "HCF 56k Data/Fax/Voice/Spkp Modem",
             0x1052: "HCF 56k Data/Fax Modem (Worldwide)",
             0x1053: "HCF 56k Data/Fax Modem (Worldwide)",
             0x1054: "HCF 56k Data/Fax/Voice Modem (Worldwide)",
             0x1055: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem (Worldwide)",
             0x1056: "HCF 56k Data/Fax/Voice/Spkp Modem (Worldwide)",
             0x1057: "HCF 56k Data/Fax/Voice/Spkp Modem (Worldwide)",
             0x1059: "HCF 56k Data/Fax/Voice Modem (Worldwide)",
             0x1063: "HCF 56k Data/Fax Modem",
             0x1064: "HCF 56k Data/Fax/Voice Modem",
             0x1065: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem",
             0x1066: "HCF 56k Data/Fax/Voice/Spkp Modem",
             0x1085: "HCF V90 56k Data/Fax/Voice/Spkp PCI Modem",
             0x10B6: "CX06834-11 HCF V.92 56k Data/Fax/Voice/Spkp Modem",
             0x1433: "HCF 56k Data/Fax Modem",
             0x1434: "HCF 56k Data/Fax/Voice Modem",
             0x1435: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem",
             0x1436: "HCF 56k Data/Fax Modem",
             0x1453: "HCF 56k Data/Fax Modem",
             0x1454: "HCF 56k Data/Fax/Voice Modem",
             0x1455: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem",
             0x1456: "HCF 56k Data/Fax/Voice/Spkp Modem",
             0x1610: "ADSL AccessRunner PCI Arbitration Device",
             0x1611: "AccessRunner PCI ADSL Interface Device",
             0x1620: "AccessRunner V2 PCI ADSL Arbitration Device",
             0x1621: "AccessRunner V2 PCI ADSL Interface Device",
             0x1622: "AccessRunner V2 PCI ADSL Yukon WAN Adapter",
             0x1803: "HCF 56k Modem",
             0x1811: "MiniPCI Network Adapter",
             0x1815: "HCF 56k Modem",
             0x1830: "CX861xx Integrated Host Bridge",
             0x2003: "HSF 56k Data/Fax Modem",
             0x2004: "HSF 56k Data/Fax/Voice Modem",
             0x2005: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem",
             0x2006: "HSF 56k Data/Fax/Voice/Spkp Modem",
             0x2013: "HSF 56k Data/Fax Modem",
             0x2014: "HSF 56k Data/Fax/Voice Modem",
             0x2015: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem",
             0x2016: "HSF 56k Data/Fax/Voice/Spkp Modem",
             0x2043: "HSF 56k Data/Fax Modem (WorldW SmartDAA)",
             0x2044: "HSF 56k Data/Fax/Voice Modem (WorldW SmartDAA)",
             0x2045: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem (WorldW SmartDAA)",
             0x2046: "HSF 56k Data/Fax/Voice/Spkp Modem (WorldW SmartDAA)",
             0x2063: "HSF 56k Data/Fax Modem (SmartDAA)",
             0x2064: "HSF 56k Data/Fax/Voice Modem (SmartDAA)",
             0x2065: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem (SmartDAA)",
             0x2066: "HSF 56k Data/Fax/Voice/Spkp Modem (SmartDAA)",
             0x2093: "HSF 56k Modem",
             0x2143: "HSF 56k Data/Fax/Cell Modem (Mob WorldW SmartDAA)",
             0x2144: "HSF 56k Data/Fax/Voice/Cell Modem (Mob WorldW SmartDAA)",
             0x2145: "HSF 56k Data/Fax/Voice/Spkp (w/HS)/Cell Modem (Mob WorldW SmartDAA)",
             0x2146: "HSF 56k Data/Fax/Voice/Spkp/Cell Modem (Mob WorldW SmartDAA)",
             0x2163: "HSF 56k Data/Fax/Cell Modem (Mob SmartDAA)",
             0x2164: "HSF 56k Data/Fax/Voice/Cell Modem (Mob SmartDAA)",
             0x2165: "HSF 56k Data/Fax/Voice/Spkp (w/HS)/Cell Modem (Mob SmartDAA)",
             0x2166: "HSF 56k Data/Fax/Voice/Spkp/Cell Modem (Mob SmartDAA)",
             0x2343: "HSF 56k Data/Fax CardBus Modem (Mob WorldW SmartDAA)",
             0x2344: "HSF 56k Data/Fax/Voice CardBus Modem (Mob WorldW SmartDAA)",
             0x2345: "HSF 56k Data/Fax/Voice/Spkp (w/HS) CardBus Modem (Mob WorldW SmartDAA)",
             0x2346: "HSF 56k Data/Fax/Voice/Spkp CardBus Modem (Mob WorldW SmartDAA)",
             0x2363: "HSF 56k Data/Fax CardBus Modem (Mob SmartDAA)",
             0x2364: "HSF 56k Data/Fax/Voice CardBus Modem (Mob SmartDAA)",
             0x2365: "HSF 56k Data/Fax/Voice/Spkp (w/HS) CardBus Modem (Mob SmartDAA)",
             0x2366: "HSF 56k Data/Fax/Voice/Spkp CardBus Modem (Mob SmartDAA)",
             0x2443: "HSF 56k Data/Fax Modem (Mob WorldW SmartDAA)",
             0x2444: "HSF 56k Data/Fax/Voice Modem (Mob WorldW SmartDAA)",
             0x2445: "HSF 56k Data/Fax/Voice/Spkp (w/HS) Modem (Mob WorldW SmartDAA)",
             0x2446: "HSF 56k Data/Fax/Voice/Spkp Modem (Mob WorldW SmartDAA)",
             0x2463: "HSF 56k Data/Fax Modem (Mob SmartDAA)",
             0x2464: "HSF 56k Data/Fax/Voice Modem (Mob SmartDAA)",
             0x2465: "HSF 56k Data/Fax/Voice/Spkp (w/HS) Modem (Mob SmartDAA)",
             0x2466: "HSF 56k Data/Fax/Voice/Spkp Modem (Mob SmartDAA)",
             0x2702: "HSFi modem RD01-D270",
             0x2F00: "HSF 56k HSFi Modem",
             0x2F02: "HSF 56k HSFi Data/Fax",
             0x2F11: "HSF 56k HSFi Modem",
             0x2F20: "HSF 56k Data/Fax Modem",
             0x2F30: "SoftV92 SpeakerPhone SoftRing Modem with SmartSP",
             0x2F50: "Conexant SoftK56 Data/Fax Modem",
             0x510F: "Conexant CX 20751/20752",
             0x5B7A: "CX23418 Single-Chip MPEG-2 Encoder with Integrated Analog Video/Broadcast Audio Decoder",
             0x8200: "CX25850",
             0x8234: "RS8234 ATM SAR Controller [ServiceSAR Plus]",
             0x8800: "CX23880/1/2/3 PCI Video and Audio Decoder",
             0x8801: "CX23880/1/2/3 PCI Video and Audio Decoder [Audio Port]",
             0x8802: "CX23880/1/2/3 PCI Video and Audio Decoder [MPEG Port]",
             0x8804: "CX23880/1/2/3 PCI Video and Audio Decoder [IR Port]",
             0x8811: "CX23880/1/2/3 PCI Video and Audio Decoder [Audio Port]",
             0x8852: "CX23885 PCI Video and Audio Decoder",
             0x8880: "CX23887/8 PCIe Broadcast Audio and Video Decoder with 3D Comb",
             },

    # MOBILITY Electronics
    0x14F2: {0x0120: "EV1000 bridge",
             0x0121: "EV1000 Parallel port",
             0x0122: "EV1000 Serial port",
             0x0123: "EV1000 Keyboard controller",
             0x0124: "EV1000 Mouse controller",
             },

    # BroadLogic
    0x14F3: {0x2030: "2030 DVB-S Satellite Receiver",
             0x2035: "2035 DVB-S Satellite Receiver",
             0x2050: "2050 DVB-T Terrestrial (Cable) Receiver",
             0x2060: "2060 ATSC Terrestrial (Cable) Receiver",
             },

    # Quadrics Ltd
    0x14FC: {0x0000: "QsNet Elan3 Network Adapter",
             0x0001: "QsNetII Elan4 Network Adapter",
             0x0002: "QsNetIII Elan5 Network Adapter",
             },

    # Motorola ?? / HTEC
    0x1507: {0x0001: "MPC105 [Eagle]",
             0x0002: "MPC106 [Grackle]",
             0x0003: "MPC8240 [Kahlua]",
             0x0100: "MC145575 [HFC-PCI]",
             0x0431: "KTI829c 100VG",
             0x4801: "Raven",
             0x4802: "Falcon",
             0x4803: "Hawk",
             0x4806: "CPX8216",
             },

    # MYSON Technology Inc
    0x1516: {0x0800: "MTD-8xx 100/10M Ethernet PCI Adapter",
             0x0803: "SURECOM EP-320X-S 100/10M Ethernet PCI Adapter",
             0x0891: "MTD-8xx 100/10M Ethernet PCI Adapter",
             },

    # Globetek
    0x151A: {0x1002: "PCI-1002",
             0x1004: "PCI-1004",
             0x1008: "PCI-1008",
             },

    # DIGITAL AUDIO LABS Inc
    0x151C: {0x0003: "Prodif T 2496",
             0x4000: "Prodif 88",
             },

    # MainPine Ltd
    0x1522: {0x0100: "PCI <-> IOBus Bridge",
             0x4000: "PCI Express UART",
             },

    # ENE Technology Inc
    0x1524: {0x0510: "CB710 Memory Card Reader Controller",
             0x0520: "FLASH memory: ENE Technology Inc:",
             0x0530: "ENE PCI Memory Stick Card Reader Controller",
             0x0550: "ENE PCI Secure Digital Card Reader Controller",
             0x0551: "SD/MMC Card Reader Controller",
             0x0610: "PCI Smart Card Reader Controller",
             0x0720: "Memory Stick Card Reader Controller",
             0x0730: "ENE PCI Memory Stick Card Reader Controller",
             0x0750: "ENE PCI SmartMedia / xD Card Reader Controller",
             0x0751: "ENE PCI Secure Digital / MMC Card Reader Controller",
             0x1211: "CB1211 Cardbus Controller",
             0x1225: "CB1225 Cardbus Controller",
             0x1410: "CB1410 Cardbus Controller",
             0x1411: "CB-710/2/4 Cardbus Controller",
             0x1412: "CB-712/4 Cardbus Controller",
             0x1420: "CB1420 Cardbus Controller",
             0x1421: "CB-720/2/4 Cardbus Controller",
             0x1422: "CB-722/4 Cardbus Controller",
             },

    # TERRATEC Electronic GmbH
    0x153B: {0x1144: "Aureon 5.1",
             0x1147: "Aureon 5.1 Sky",
             0x1158: "Philips Semiconductors SAA7134 (rev 01) [Terratec Cinergy 600 TV]",
             },

    # Concurrent Real-Time
    0x1542: {0x9260: "RCIM-II Real-Time Clock & Interrupt Module",
             0x9271: "RCIM-III Real-Time Clock & Interrupt Module (PCIe)",
             0x9272: "Pulse Width Modulator Card",
             0x9273: "RCIM-IV Real-Time Clock & Interrupt Module (PCIe)",
             0x9277: "5 Volt Delta Sigma Converter Card",
             0x9278: "10 Volt Delta Sigma Converter Card",
             0x9287: "Analog Output Card",
             0x9290: "FPGA Card",
             0x9300: "Universal Exhaust Gas Oxygen Sensor Simulator",
             0x9310: "Digital Programmable Resistor",
             0x9350: "Analog Input Card",
             },

    # SILICON Laboratories
    0x1543: {0x3052: "Intel 537 [Winmodem]",
             0x4C22: "Si3036 MC'97 DAA",
             },

    # PLDA
    0x1556: {0x1100: "PCI Express Core Reference Design",
             0x110F: "PCI Express Core Reference Design Virtual Function",
             0x1110: "XpressRich Reference Design",
             0x1111: "XpressRich-AXI Ref Design",
             0x1112: "QuickPCIe",
             0x1113: "XpressSwitch",
             0x1114: "Inspector",
             0x1115: "XpressLINK Ref Design",
             0x1116: "XpressLINK-SOC Ref Design",
             0xBE00: "PCI Express Bridge",
             },

    # Contemporary Controls
    0x1571: {0xA001: "CCSI PCI20-485 ARCnet",
             0xA002: "CCSI PCI20-485D ARCnet",
             0xA003: "CCSI PCI20-485X ARCnet",
             0xA004: "CCSI PCI20-CXB ARCnet",
             0xA005: "CCSI PCI20-CXS ARCnet",
             0xA006: "CCSI PCI20-FOG-SMA ARCnet",
             0xA007: "CCSI PCI20-FOG-ST ARCnet",
             0xA008: "CCSI PCI20-TB5 ARCnet",
             0xA009: "CCSI PCI20-5-485 5Mbit ARCnet",
             0xA00A: "CCSI PCI20-5-485D 5Mbit ARCnet",
             0xA00B: "CCSI PCI20-5-485X 5Mbit ARCnet",
             0xA00C: "CCSI PCI20-5-FOG-ST 5Mbit ARCnet",
             0xA00D: "CCSI PCI20-5-FOG-SMA 5Mbit ARCnet",
             0xA201: "CCSI PCI22-485 10Mbit ARCnet",
             0xA202: "CCSI PCI22-485D 10Mbit ARCnet",
             0xA203: "CCSI PCI22-485X 10Mbit ARCnet",
             0xA204: "CCSI PCI22-CHB 10Mbit ARCnet",
             0xA205: "CCSI PCI22-FOG_ST 10Mbit ARCnet",
             0xA206: "CCSI PCI22-THB 10Mbit ARCnet",
             },

    # HITT
    0x1578: {0x4D34: "VPMK4 [Video Processor Mk IV]",
             0x5615: "VPMK3 [Video Processor Mk III]",
             },

    # Atlantek Microsystems Pty Ltd
    0x1589: {0x0008: "Leutron Vision PicPortExpress CL",
             0x0009: "Leutron Vision PicPortExpress CL Stereo",
             },

    # Hewlett Packard Enterprise
    0x1590: {0x0001: "Eagle Cluster Manager",
             0x0002: "Osprey Cluster Manager",
             0x0003: "Harrier Cluster Manager",
             0xA01D: "FC044X Fibre Channel HBA",
             },

    # Syba Tech Ltd
    0x1592: {0x0781: "Multi-IO Card",
             0x0782: "Parallel Port Card 2xEPP",
             0x0783: "Multi-IO Card",
             0x0785: "Multi-IO Card",
             0x0786: "Multi-IO Card",
             0x0787: "Multi-IO Card",
             0x0788: "Multi-IO Card",
             0x078A: "Multi-IO Card",
             },

    # VMware
    0x15AD: {0x0405: "SVGA II Adapter",
             0x0710: "SVGA Adapter",
             0x0720: "VMXNET Ethernet Controller",
             0x0740: "Virtual Machine Communication Interface",
             0x0770: "USB2 EHCI Controller",
             0x0774: "USB1.1 UHCI Controller",
             0x0778: "USB3 xHCI 0.96 Controller",
             0x0779: "USB3 xHCI 1.0 Controller",
             0x0790: "PCI bridge",
             0x07A0: "PCI Express Root Port",
             0x07B0: "VMXNET3 Ethernet Controller",
             0x07C0: "PVSCSI SCSI Controller",
             0x07E0: "SATA AHCI controller",
             0x07F0: "NVMe SSD Controller",
             0x0801: "Virtual Machine Interface",
             0x0820: "Paravirtual RDMA controller",
             0x1977: "HD Audio Controller",
             },

    # Mellanox Technologies
    0x15B3: {0x0191: "MT25408 [ConnectX IB Flash Recovery]",
             0x01F6: "MT27500 Family [ConnectX-3 Flash Recovery]",
             0x01F8: "MT27520 Family [ConnectX-3 Pro Flash Recovery]",
             0x01FF: "MT27600 Family [Connect-IB Flash Recovery]",
             0x0209: "MT27700 Family [ConnectX-4 Flash Recovery]",
             0x020B: "MT27710 Family [ConnectX-4 Lx Flash Recovery]",
             0x020D: "MT28800 Family [ConnectX-5 Flash Recovery]",
             0x020F: "MT28908A0 Family [ConnectX-6 Flash Recovery]",
             0x0210: "MT28908A0 Family [ConnectX-6 Secure Flash Recovery]",
             0x0211: "MT416842 Family [BlueField SoC Flash Recovery]",
             0x0212: "MT2892 Family [ConnectX-6 Dx Flash Recovery]",
             0x0213: "MT2892 Family [ConnectX-6 Dx Secure Flash Recovery]",
             0x0214: "MT42822 Family [BlueField-2 SoC Flash Recovery]",
             0x0215: "MT42822 Family [BlueField-2 Secure Flash Recovery]",
             0x0216: "MT2894 Family [ConnectX-6 Lx Flash Recovery]",
             0x0217: "MT2894 Family [ConnectX-6 Lx Secure Flash Recovery]",
             0x0218: "MT2910 Family [ConnectX-7 Flash Recovery]",
             0x0219: "MT2910 Family [ConnectX-7 Secure Flash Recovery]",
             0x021A: "MT43162 Family [BlueField-3 Lx SoC Flash Recovery]",
             0x021B: "MT43162 Family [BlueField-3 Lx Secure Flash Recovery]",
             0x021C: "MT43244 Family [BlueField-3 SoC Flash Recovery]",
             0x021D: "MT43244 Family [BlueField-3 Secure Flash Recovery]",
             0x021E: "CX8 Family [ConnectX-8 Flash Recovery]",
             0x021F: "CX8 Family [ConnectX-8 Secure Flash Recovery]",
             0x0220: "BF4 Family Flash Recovery [BlueField-4 SoC Flash Recovery]",
             0x0221: "BF4 Family Secure Flash Recovery [BlueField-4 Secure Flash Recovery]",
             0x024E: "MT53100 [Spectrum-2, Flash recovery mode]",
             0x024F: "MT53100 [Spectrum-2, Secure Flash recovery mode]",
             0x0250: "Spectrum-3, Flash recovery mode",
             0x0251: "Spectrum-3, Secure Flash recovery mode",
             0x0252: "Amos chiplet",
             0x0253: "Amos GearBox Manager",
             0x0254: "Spectrum-4, Flash recovery mode",
             0x0255: "Spectrum-4 RMA",
             0x0256: "Abir GearBox",
             0x0257: "Quantum-2 in Flash Recovery Mode",
             0x0258: "Quantum-2 RMA",
             0x0259: "Abir Chiplet",
             0x025B: "Quantum-3 in Flash Recovery Mode",
             0x025C: "Quantum-3 RMA",
             0x025D: "Quantum-3CPO in Flash Recovery Mode",
             0x025E: "Quantum-3CPO RMA",
             0x0262: "MT27710 [ConnectX-4 Lx Programmable] EN",
             0x0263: "MT27710 [ConnectX-4 Lx Programmable Virtual Function] EN",
             0x0264: "Innova-2 Flex Burn image",
             0x0270: "Spectrum-4L, Flash recovery mode",
             0x0271: "Spectrum-4L, RMA",
             0x0274: "Spectrum-4C, Flash recovery mode",
             0x0275: "Spectrum-4C RMA",
             0x0277: "Spectrum-4TOR RMA",
             0x0281: "NPS-600 Flash Recovery",
             0x0282: "ArcusE Flash recovery",
             0x0283: "ArcusE RMA",
             0x0284: "Sagitta",
             0x0285: "Sagitta RMA",
             0x1002: "MT25400 Family [ConnectX-2 Virtual Function]",
             0x1003: "MT27500 Family [ConnectX-3]",
             0x1004: "MT27500/MT27520 Family [ConnectX-3/ConnectX-3 Pro Virtual Function]",
             0x1005: "MT27510 Family",
             0x1006: "MT27511 Family",
             0x1007: "MT27520 Family [ConnectX-3 Pro]",
             0x1009: "MT27530 Family",
             0x100A: "MT27531 Family",
             0x100B: "MT27540 Family",
             0x100C: "MT27541 Family",
             0x100D: "MT27550 Family",
             0x100E: "MT27551 Family",
             0x100F: "MT27560 Family",
             0x1010: "MT27561 Family",
             0x1011: "MT27600 [Connect-IB]",
             0x1012: "MT27600 Family [Connect-IB Virtual Function]",
             0x1013: "MT27700 Family [ConnectX-4]",
             0x1014: "MT27700 Family [ConnectX-4 Virtual Function]",
             0x1015: "MT27710 Family [ConnectX-4 Lx]",
             0x1016: "MT27710 Family [ConnectX-4 Lx Virtual Function]",
             0x1017: "MT27800 Family [ConnectX-5]",
             0x1018: "MT27800 Family [ConnectX-5 Virtual Function]",
             0x1019: "MT28800 Family [ConnectX-5 Ex]",
             0x101A: "MT28800 Family [ConnectX-5 Ex Virtual Function]",
             0x101B: "MT28908 Family [ConnectX-6]",
             0x101C: "MT28908 Family [ConnectX-6 Virtual Function]",
             0x101D: "MT2892 Family [ConnectX-6 Dx]",
             0x101E: "ConnectX Family mlx5Gen Virtual Function",
             0x101F: "MT2894 Family [ConnectX-6 Lx]",
             0x1020: "MT28860",
             0x1021: "MT2910 Family [ConnectX-7]",
             0x1023: "CX8 Family [ConnectX-8]",
             0x1974: "MT28800 Family [ConnectX-5 PCIe Bridge]",
             0x1975: "MT416842 Family [BlueField SoC PCIe Bridge]",
             0x1976: "MT28908 Family [ConnectX-6 PCIe Bridge]",
             0x1977: "MT2892 Family [ConnectX-6 Dx PCIe Bridge]",
             0x1978: "MT42822 Family [BlueField-2 SoC PCIe Bridge]",
             0x1979: "MT2910 Family [ConnectX-7 PCIe Bridge]",
             0x197A: "MT43162 Family [BlueField-3 Lx SoC PCIe Bridge]",
             0x197B: "MT43244 Family [BlueField-3 SoC PCIe Bridge]",
             0x197C: "ConnectX/BlueField Family mlx5Gen PCIe Bridge [PCIe Bridge]",
             0x2020: "MT2892 Family [ConnectX-6 Dx Emulated PCIe Bridge]",
             0x2021: "MT42822 Family [BlueField-2 SoC Emulated PCIe Bridge]",
             0x2023: "MT2910 Family [ConnectX-7 Emulated PCIe Bridge]",
             0x2024: "MT43244 Family [BlueField-3 SoC Emulated PCIe Bridge]",
             0x2025: "ConnectX/BlueField Family mlx5Gen Emulated PCIe Bridge [Emulated PCIe Bridge]",
             0x4117: "MT27712A0-FDCF-AE",
             0x5274: "MT21108 InfiniBridge",
             0x5A44: "MT23108 InfiniHost",
             0x5A45: "MT23108 [Infinihost HCA Flash Recovery]",
             0x5A46: "MT23108 PCI Bridge",
             0x5E8C: "MT24204 [InfiniHost III Lx HCA]",
             0x5E8D: "MT25204 [InfiniHost III Lx HCA Flash Recovery]",
             0x6001: "NVMe SNAP Controller",
             0x6274: "MT25204 [InfiniHost III Lx HCA]",
             0x6278: "MT25208 InfiniHost III Ex (Tavor compatibility mode)",
             0x6279: "MT25208 [InfiniHost III Ex HCA Flash Recovery]",
             0x6282: "MT25208 [InfiniHost III Ex]",
             0x6340: "MT25408A0-FCC-SI ConnectX, Dual Port 10Gb/s InfiniBand / 10GigE Adapter IC with PCIe 2.0 x8 2.5GT/s Interface",
             0x634A: "MT25408A0-FCC-DI ConnectX, Dual Port 20Gb/s InfiniBand / 10GigE Adapter IC with PCIe 2.0 x8 2.5GT/s Interface",
             0x6368: "MT25448 [ConnectX EN 10GigE, PCIe 2.0 2.5GT/s]",
             0x6372: "MT25458 ConnectX EN 10GBASE-T PCIe 2.5 GT/s",
             0x6732: "MT25408A0-FCC-GI ConnectX, Dual Port 20Gb/s InfiniBand / 10GigE Adapter IC with PCIe 2.0 x8 5.0GT/s Interface",
             0x673C: "MT25408A0-FCC-QI ConnectX, Dual Port 40Gb/s InfiniBand / 10GigE Adapter IC with PCIe 2.0 x8 5.0GT/s Interface",
             0x6746: "MT26438 [ConnectX VPI PCIe 2.0 5GT/s - IB QDR / 10GigE Virtualization+]",
             0x6750: "MT26448 [ConnectX EN 10GigE, PCIe 2.0 5GT/s]",
             0x675A: "MT26458 ConnectX EN 10GBASE-T PCIe Gen2 5.0 GT/s",
             0x6764: "MT26468 [ConnectX EN 10GigE, PCIe 2.0 5GT/s Virtualization+]",
             0x676E: "MT26478 [ConnectX EN 40GigE, PCIe 2.0 5GT/s]",
             0x6778: "MT26488 [ConnectX VPI PCIe 2.0 5GT/s - IB DDR / 10GigE Virtualization+]",
             0x7101: "NPS-400 configuration and management interface",
             0x7102: "NPS-400 network interface PF",
             0x7103: "NPS-400 network interface VF",
             0x7121: "NPS-600 configuration and management interface",
             0x7122: "NPS-600 network interface PF",
             0x7123: "NPS-600 network interface VF",
             0x8200: "Innova-2 Flex Shell Logic",
             0xA2D0: "MT416842 BlueField SoC Crypto enabled",
             0xA2D1: "MT416842 BlueField SoC Crypto disabled",
             0xA2D2: "MT416842 BlueField integrated ConnectX-5 network controller",
             0xA2D3: "MT416842 BlueField multicore SoC family VF",
             0xA2D4: "MT42822 BlueField-2 SoC Crypto enabled",
             0xA2D5: "MT42822 BlueField-2 SoC Crypto disabled",
             0xA2D6: "MT42822 BlueField-2 integrated ConnectX-6 Dx network controller",
             0xA2D7: "MT43162 BlueField-3 Lx SoC Crypto enabled",
             0xA2D8: "MT43162 BlueField-3 Lx SoC Crypto disabled",
             0xA2D9: "MT43162 BlueField-3 Lx integrated ConnectX-7 network controller",
             0xA2DA: "MT43244 BlueField-3 SoC Crypto enabled",
             0xA2DB: "MT43244 BlueField-3 SoC Crypto disabled",
             0xA2DC: "MT43244 BlueField-3 integrated ConnectX-7 network controller",
             0xA2DD: "BF4 Family Crypto enabled [BlueField-4 SoC Crypto enabled]",
             0xA2DE: "BF4 Family Crypto disabled [BlueField-4 SoC Crypto disabled]",
             0xA2DF: "BF4 Family integrated network controller [BlueField-4 integrated network controller]",
             0xB200: "ArcusE",
             0xC2D2: "MT416842 BlueField SoC management interfac",
             0xC2D3: "MT42822 BlueField-2 SoC Management Interface",
             0xC2D4: "MT43162 BlueField-3 Lx SoC Management Interface",
             0xC2D5: "MT43244 BlueField-3 SoC Management Interface",
             0xC2D6: "BF4 Family Management Interface [BlueField-4 SoC Management Interface]",
             0xC738: "MT51136",
             0xC739: "MT51136 GW",
             0xC838: "MT52236",
             0xC839: "MT52236 router",
             0xCAF1: "ConnectX-4 CAPI Function",
             0xCB84: "MT52100",
             0xCF08: "Switch-IB2",
             0xCF6C: "MT53100 [Spectrum-2]",
             0xCF70: "Spectrum-3",
             0xCF80: "Spectrum-4",
             0xCF82: "Spectrum-4L",
             0xCF84: "Spectrum-4C",
             0xD2F0: "Quantum HDR (200Gbps) switch",
             0xD2F2: "Quantum-2 NDR (400Gbps) switch",
             0xD2F4: "Quantum-3",
             0xD2F6: "Quantum-3CPO",
             },

    # Texas Memory Systems Inc
    0x15B6: {0x0001: "XP15 DSP Accelerator",
             0x0002: "XP30 DSP Accelerator",
             0x0003: "XP00 Data Acquisition Device",
             0x0004: "XP35 DSP Accelerator",
             0x0007: "XP100 DSP Accelerator [XP100-T0]",
             0x0008: "XP100 DSP Accelerator [XP100-T1]",
             0x0009: "XP100 DSP Accelerator [XP100-E0]",
             0x000A: "XP100 DSP Accelerator [XP100-E1]",
             0x000E: "XP100 DSP Accelerator [XP100-0]",
             0x000F: "XP100 DSP Accelerator [XP100-1]",
             0x0010: "XP100 DSP Accelerator [XP100-P0]",
             0x0011: "XP100 DSP Accelerator [XP100-P1]",
             0x0012: "XP100 DSP Accelerator [XP100-P2]",
             0x0013: "XP100 DSP Accelerator [XP100-P3]",
             0x0014: "RamSan Flash SSD",
             0x0015: "ZBox",
             },

    # Sandisk Corp
    0x15B7: {0x2001: "Skyhawk Series NVME SSD",
             0x5001: "WD Black NVMe SSD",
             0x5002: "WD Black 2018/SN750 / PC SN720 NVMe SSD",
             0x5003: "WD Blue SN500 / PC SN520 NVMe SSD",
             0x5004: "PC SN520 NVMe SSD",
             0x5005: "PC SN520 NVMe SSD",
             0x5006: "WD Black SN750 / PC SN730 NVMe SSD",
             0x5009: "WD Blue SN550 NVMe SSD",
             0x500B: "PC SN530 NVMe SSD",
             0x500D: "WD Ultrastar DC SN340 NVMe SSD",
             0x5011: "WD PC SN810 / Black SN850 NVMe SSD",
             0x501A: "WD Blue SN570 NVMe SSD",
             },

    # ADDI-DATA GmbH
    0x15B8: {0x1001: "APCI1516 SP controller (16 digi outputs)",
             0x1003: "APCI1032 SP controller (32 digi inputs w/ opto coupler)",
             0x1004: "APCI2032 SP controller (32 digi outputs)",
             0x1005: "APCI2200 SP controller (8/16 digi outputs (relay))",
             0x1006: "APCI1564 SP controller (32 digi ins, 32 digi outs)",
             0x100A: "APCI1696 SP controller (96 TTL I/Os)",
             0x3001: "APCI3501 SP controller (analog output board)",
             0x300F: "APCI3600 Noise and vibration measurement board",
             0x7001: "APCI7420 2-port Serial Controller",
             0x7002: "APCI7300 Serial Controller",
             },

    # Agilent Technologies
    0x15BC: {0x0100: "HPFC-5600 Tachyon DX2+ FC",
             0x0103: "QX4 PCI Express quad 4-gigabit Fibre Channel controller",
             0x0105: "Celerity FC-44XS/FC-42XS/FC-41XS/FC-44ES/FC-42ES/FC-41ES",
             0x1100: "E8001-66442 PCI Express CIC",
             0x2922: "64 Bit, 133MHz PCI-X Exerciser & Protocol Checker",
             0x2928: "64 Bit, 66MHz PCI Exerciser & Analyzer",
             0x2929: "64 Bit, 133MHz PCI-X Analyzer & Exerciser",
             },

    # National Datacomm Corp
    0x15E8: {0x0130: "Wireless PCI Card",
             0x0131: "NCP130A2 Wireless NIC",
             },

    # Beckhoff GmbH
    0x15EC: {0x3101: "FC3101 Profibus DP 1 Channel PCI",
             0x5102: "FC5102",
             },

    # Stone Ridge Technology
    0x1618: {0x0001: "RDX 11",
             0x0002: "HFT-01",
             0x0400: "FarSync T2P (2 port X.21/V.35/V.24)",
             0x0440: "FarSync T4P (4 port X.21/V.35/V.24)",
             0x0610: "FarSync T1U (1 port X.21/V.35/V.24)",
             0x0620: "FarSync T2U (2 port X.21/V.35/V.24)",
             0x0640: "FarSync T4U (4 port X.21/V.35/V.24)",
             0x1610: "FarSync TE1 (T1,E1)",
             0x2610: "FarSync DSL-S1 (SHDSL)",
             0x3640: "FarSync T4E (4-port X.21/V.35/V.24)",
             0x4620: "FarSync T2Ue PCI Express (2-port X.21/V.35/V.24)",
             0x4640: "FarSync T4Ue PCI Express (4-port X.21/V.35/V.24)",
             },

    # FarSite Communications Ltd
    0x1619: {0x0400: "FarSync T2P (2 port X.21/V.35/V.24)",
             0x0440: "FarSync T4P (4 port X.21/V.35/V.24)",
             0x0610: "FarSync T1U (1 port X.21/V.35/V.24)",
             0x0620: "FarSync T2U (2 port X.21/V.35/V.24)",
             0x0640: "FarSync T4U (4 port X.21/V.35/V.24)",
             0x1610: "FarSync TE1 (T1,E1)",
             0x1612: "FarSync TE1 PCI Express (T1,E1)",
             0x2610: "FarSync DSL-S1 (SHDSL)",
             0x3640: "FarSync T4E (4-port X.21/V.35/V.24)",
             0x4620: "FarSync T2Ue PCI Express (2-port X.21/V.35/V.24)",
             0x4640: "FarSync T4Ue PCI Express (4-port X.21/V.35/V.24)",
             0x5621: "FarSync T2Ee PCI Express (2 port X.21/V.35/V.24)",
             0x5641: "FarSync T4Ee PCI Express (4 port X.21/V.35/V.24)",
             0x6620: "FarSync T2U-PMC PCI Express (2 port X.21/V.35/V.24)",
             },

    # Lynx Studio Technology, Inc.
    0x1621: {0x0020: "LynxTWO-A",
             0x0021: "LynxTWO-B",
             0x0022: "LynxTWO-C",
             0x0023: "Lynx L22",
             0x0024: "Lynx AES16",
             0x0025: "Lynx AES16-SRC",
             0x0028: "Lynx AES16e",
             },

    # Kongsberg Spacetec AS
    0x1629: {0x1003: "Format synchronizer v3.0",
             0x1006: "Format synchronizer, model 10500",
             0x1007: "Format synchronizer, model 21000",
             0x2002: "Fast Universal Data Output",
             0x3100: "IO31000 Frame Synchronizer and I/O",
             0x3200: "IO32000 Frame Synchronizer and I/O",
             0x4002: "High Rate Demodulator",
             0x5001: "High Rate FEC",
             0x6001: "High Rate Demodulator and FEC",
             },

    # Smart Link Ltd.
    0x163C: {0x3052: "SmartLink SmartPCI562 56K Modem",
             0x5449: "SmartPCI561 Modem",
             },

    # Cavium QLogic
    0x1657: {0x0013: "425/825/42B/82B 4Gbps/8Gbps PCIe dual port FC HBA",
             0x0014: "1010/1020/1007/1741 10Gbps CNA",
             0x0017: "415/815/41B/81B 4Gbps/8Gbps PCIe single port FC HBA",
             0x0021: "804 8Gbps FC HBA for HP Bladesystem c-class",
             0x0022: "BR-1860 Fabric Adapter",
             0x0023: "1867/1869 16Gbps FC HBA",
             0x0646: "400 4Gbps PCIe FC HBA",
             },

    # Epix Inc
    0x165A: {0xC100: "PIXCI(R) CL1 Camera Link Video Capture Board [custom QL5232]",
             0xD200: "PIXCI(R) D2X Digital Video Capture Board [custom QL5232]",
             0xD300: "PIXCI(R) D3X Digital Video Capture Board [custom QL5232]",
             0xEB01: "PIXCI(R) EB1 PCI Camera Link Video Capture Board",
             },

    # Gidel Ltd.
    0x165C: {0x5361: "PROCStarII60-1",
             0x5362: "PROCStarII60-2",
             0x5364: "PROCStarII60-4",
             0x5435: "ProcSparkII",
             0x5661: "ProcE60",
             0x56E1: "ProcE180",
             0x5911: "ProcStarIII110-1",
             0x5912: "ProcStarIII110-2",
             0x5913: "ProcStarIII110-3",
             0x5914: "ProcStarIII110-4",
             0x5921: "ProcStarIII150-1",
             0x5922: "ProcStarIII150-2",
             0x5923: "ProcStarIII150-3",
             0x5924: "ProcStarIII150-4",
             0x5931: "ProcStarIII260-1",
             0x5932: "ProcStarIII260-2",
             0x5933: "ProcStarIII260-3",
             0x5934: "ProcStarIII260-4",
             0x5941: "ProcStarIII340-1",
             0x5942: "ProcStarIII340-2",
             0x5943: "ProcStarIII340-3",
             0x5944: "ProcStarIII340-4",
             0x5A01: "ProceIII80",
             0x5A11: "ProceIII110",
             0x5A21: "ProceIII150",
             0x5A31: "ProceIII260",
             0x5A41: "ProceIII340",
             0x5B51: "ProceIV360",
             0x5B61: "ProceIV530",
             0x5B71: "ProceIV820",
             0x5C01: "ProcStarIV80-1",
             0x5C02: "ProcStarIV80-2",
             0x5C03: "ProcStarIV80-3",
             0x5C04: "ProcStarIV80-4",
             0x5C11: "ProcStarIV110-1",
             0x5C12: "ProcStarIV110-2",
             0x5C13: "ProcStarIV110-3",
             0x5C14: "ProcStarIV110-4",
             0x5C51: "ProcStarIV360-1",
             0x5C52: "ProcStarIV360-2",
             0x5C53: "ProcStarIV360-3",
             0x5C54: "ProcStarIV360-4",
             0x5C61: "ProcStarIV530-1",
             0x5C62: "ProcStarIV530-2",
             0x5C63: "ProcStarIV530-3",
             0x5C64: "ProcStarIV530-4",
             0x5C71: "ProcStarIV820-1",
             0x5C72: "ProcStarIV820-2",
             0x5C73: "ProcStarIV820-3",
             0x5C74: "ProcStarIV820-4",
             0x5D01: "Proc10480",
             0x5D11: "Proc104110",
             0x5F01: "ProceV_A3",
             0x5F11: "ProceV_A7",
             0x5F21: "ProceV_AB",
             0x5F31: "ProceV_D5",
             0x5F41: "ProceV_D8",
             0x6732: "Proc6M",
             0x6832: "Proc12M",
             0x7101: "Proc10a_27",
             0x7111: "Proc10a_48",
             0x7121: "Proc10a_66",
             0x7141: "Proc10a_115",
             0x7181: "Proc10a_27S",
             0x7191: "Proc10a_48S",
             0x71A1: "Proc10a_66S",
             0x71B1: "Proc10A",
             0x72B1: "HawkEye",
             0x73B1: "Proc10s",
             },

    # Broadcom Corporation
    0x166D: {0x0001: "SiByte BCM1125/1125H/1250 System-on-a-Chip PCI",
             0x0002: "SiByte BCM1125H/1250 System-on-a-Chip HyperTransport",
             0x0012: "SiByte BCM1280/BCM1480 System-on-a-Chip PCI-X",
             0x0014: "Sibyte BCM1280/BCM1480 System-on-a-Chip HyperTransport",
             },

    # B&R Industrial Automation GmbH
    0x1677: {0x104E: "5LS172.6 B&R Dual CAN Interface Card",
             0x12D7: "5LS172.61 B&R Dual CAN Interface Card",
             0x20AD: "5ACPCI.MFIO-K01 Profibus DP / K-Feldbus / COM",
             },

    # ZyDAS Technology Corp.
    0x167B: {0x2102: "ZyDAS ZD1202",
             0x2116: "ZD1212B Wireless Adapter",
             },

    # XFX Pine Group Inc.
    0x1682: {0x5701: "Radeon 5700 XT Thicc III Ultra",
             0xC580: "Radeon RX 580",
             },

    # Utimaco IS GmbH
    0x168A: {0x2086: "CryptoServer Se-Series Hardware Security Module",
             0xC040: "CryptoServer CSe-Series Hardware Security Module",
             0xC051: "CryptoServer Se-Series Gen2 Hardware Security Module",
             0xC070: "u.trust Anchor Hardware Security Module cs7.2 Series",
             0xC071: "u.trust Anchor Hardware Security Module cs7.3 Series",
             0xC072: "u.trust Anchor Hardware Security Module cs7.3 Series Virtual Function",
             },

    # Qualcomm Atheros
    0x168C: {0x0007: "AR5210 Wireless Network Adapter [AR5000 802.11a]",
             0x0011: "AR5211 Wireless Network Adapter [AR5001A 802.11a]",
             0x0012: "AR5211 Wireless Network Adapter [AR5001X 802.11ab]",
             0x0013: "AR5212/5213/2414 Wireless Network Adapter",
             0x001A: "AR2413/AR2414 Wireless Network Adapter [AR5005G(S) 802.11bg]",
             0x001B: "AR5413/AR5414 Wireless Network Adapter [AR5006X(S) 802.11abg]",
             0x001C: "AR242x / AR542x Wireless Network Adapter (PCI-Express)",
             0x001D: "AR2417 Wireless Network Adapter [AR5007G 802.11bg]",
             0x0020: "AR5513 802.11abg Wireless NIC",
             0x0023: "AR5416 Wireless Network Adapter [AR5008 802.11(a)bgn]",
             0x0024: "AR5418 Wireless Network Adapter [AR5008E 802.11(a)bgn] (PCI-Express)",
             0x0027: "AR9160 Wireless Network Adapter [AR9001 802.11(a)bgn]",
             0x0029: "AR922X Wireless Network Adapter",
             0x002A: "AR928X Wireless Network Adapter (PCI-Express)",
             0x002B: "AR9285 Wireless Network Adapter (PCI-Express)",
             0x002C: "AR2427 802.11bg Wireless Network Adapter (PCI-Express)",
             0x002D: "AR9227 Wireless Network Adapter",
             0x002E: "AR9287 Wireless Network Adapter (PCI-Express)",
             0x0030: "AR93xx Wireless Network Adapter",
             0x0032: "AR9485 Wireless Network Adapter",
             0x0033: "AR958x 802.11abgn Wireless Network Adapter",
             0x0034: "AR9462 Wireless Network Adapter",
             0x0036: "QCA9565 / AR9565 Wireless Network Adapter",
             0x0037: "AR9485 Wireless Network Adapter",
             0x003C: "QCA986x/988x 802.11ac Wireless Network Adapter",
             0x003E: "QCA6174 802.11ac Wireless Network Adapter",
             0x0040: "QCA9980/9990 802.11ac Wireless Network Adapter",
             0x0041: "QCA6164 802.11ac Wireless Network Adapter",
             0x0042: "QCA9377 802.11ac Wireless Network Adapter",
             0x0046: "QCA9984 802.11ac Wave 2 Wireless Network Adapter",
             0x0050: "QCA9887 802.11ac Wireless Network Adapter",
             0x0207: "AR5210 Wireless Network Adapter [AR5000 802.11a]",
             0x1014: "AR5212 802.11abg NIC",
             0x9013: "AR5002X Wireless Network Adapter",
             0xFF19: "AR5006X Wireless Network Adapter",
             0xFF1B: "AR2425 Wireless Network Adapter [AR5007EG 802.11bg]",
             0xFF1C: "AR5008 Wireless Network Adapter",
             0xFF1D: "AR922x Wireless Network Adapter",
             },

    # Global Sun Technology Inc
    0x16AB: {0x1100: "GL24110P",
             0x1101: "PLX9052 PCMCIA-to-PCI Wireless LAN",
             0x1102: "PCMCIA-to-PCI Wireless Network Bridge",
             0x8501: "WL-8305 Wireless LAN PCI Adapter",
             },

    # SafeNet Inc
    0x16AE: {0x0001: "SafeXcel 1140",
             0x000A: "SafeXcel 1841",
             0x1141: "SafeXcel 1141",
             0x1841: "SafeXcel 1842",
             },

    # Synopsys, Inc.
    0x16C3: {0xABCD: "DWC_usb3 / PCIe bridge",
             0xABCE: "DWC_usb3",
             0xABCF: "DWC_usb31",
             0xEDDA: "EPMockUp",
             },

    # Micrel-Kendin
    0x16C6: {0x8695: "Centaur KS8695 ARM processor",
             0x8842: "KSZ8842-PMQL 2-Port Ethernet Switch",
             },

    # Advantech Co. Ltd
    0x16CD: {0x0101: "DirectPCI SRAM for DPX-11x series",
             0x0102: "DirectPCI SRAM for DPX-S/C/E-series",
             0x0103: "DirectPCI ROM for DPX-11x series",
             0x0104: "DirectPCI ROM for DPX-S/C/E-series",
             0x0105: "DirectPCI I/O for DPX-114/DPX-115",
             0x0106: "DirectPCI I/O for DPX-116",
             0x0107: "DirectPCI I/O for DPX-116U",
             0x0108: "DirectPCI I/O for DPX-117",
             0x0109: "DirectPCI I/O for DPX-112",
             0x010A: "DirectPCI I/O for DPX-C/E-series",
             0x010B: "DirectPCI I/O for DPX-S series",
             },

    # Acromag, Inc.
    0x16D5: {0x0504: "PMC-DX504 Reconfigurable FPGA with LVDS I/O",
             0x0520: "PMC520 Serial Communication, 232 Octal",
             0x0521: "PMC521 Serial Communication, 422/485 Octal",
             0x1020: "PMC-AX1020 Reconfigurable FPGA with A/D & D/A",
             0x1065: "PMC-AX1065 Reconfigurable FPGA with A/D & D/A",
             0x2004: "PMC-DX2004 Reconfigurable FPGA with LVDS I/O",
             0x2020: "PMC-AX2020 Reconfigurable FPGA with A/D & D/A",
             0x2065: "PMC-AX2065 Reconfigurable FPGA with A/D & D/A",
             0x3020: "PMC-AX3020 Reconfigurable FPGA with A/D & D/A",
             0x3065: "PMC-AX3065 Reconfigurable FPGA with A/D & D/A",
             0x4243: "PMC424, APC424, AcPC424 Digital I/O and Counter Timer Module",
             0x4248: "PMC464, APC464, AcPC464 Digital I/O and Counter Timer Module",
             0x424B: "PMC-DX2002 Reconfigurable FPGA with Differential I/O",
             0x4253: "PMC-DX503 Reconfigurable FPGA with TTL and Differential I/O",
             0x4312: "PMC-CX1002 Reconfigurable Conduction-Cooled FPGA Virtex-II with Differential I/O",
             0x4313: "PMC-CX1003 Reconfigurable Conduction-Cooled FPGA Virtex-II with CMOS and Differential I/O",
             0x4322: "PMC-CX2002 Reconfigurable Conduction-Cooled FPGA Virtex-II with Differential I/O",
             0x4323: "PMC-CX2003 Reconfigurable Conduction-Cooled FPGA Virtex-II with CMOS and Differential I/O",
             0x4350: "PMC-DX501 Reconfigurable Digital I/O Module",
             0x4353: "PMC-DX2003 Reconfigurable FPGA with TTL and Differential I/O",
             0x4357: "PMC-DX502 Reconfigurable Differential I/O Module",
             0x4457: "PMC730, APC730, AcPC730 Multifunction Module",
             0x4471: "XMC730 Multi-function I/O module with front I/O",
             0x4473: "XMC730CC Multi-function I/O module with rear I/O Conduction-cooled",
             0x464D: "PMC408 32-Channel Digital Input/Output Module",
             0x4850: "PMC220-16 12-Bit Analog Output Module",
             0x4A42: "PMC483, APC483, AcPC483 Counter Timer Module",
             0x4A50: "PMC484, APC484, AcPC484 Counter Timer Module",
             0x4A56: "PMC230 16-Bit Analog Output Module",
             0x4B47: "PMC330, APC330, AcPC330 Analog Input Module, 16-bit A/D",
             0x4C40: "PMC-LX40 Reconfigurable Virtex-4 FPGA with plug-in I/O",
             0x4C60: "PMC-LX60 Reconfigurable Virtex-4 FPGA with plug-in I/O",
             0x4D4D: "PMC341, APC341, AcPC341 Analog Input Module, Simultaneous Sample & Hold",
             0x4D4E: "PMC482, APC482, AcPC482 Counter Timer Board",
             0x524D: "PMC-DX2001 Reconfigurable FPGA with TTL I/O",
             0x5335: "PMC-SX35 Reconfigurable Virtex-4 FPGA with plug-in I/O",
             0x5456: "PMC470 48-Channel Digital Input/Output Module",
             0x5601: "PMC-VLX85 Reconfigurable Virtex-5 FPGA with plug-in I/O",
             0x5602: "PMC-VLX110 Reconfigurable Virtex-5 FPGA with plug-in I/O",
             0x5603: "PMC-VSX95 Reconfigurable Virtex-5 FPGA with plug-in I/O",
             0x5604: "PMC-VLX155 Reconfigurable Virtex-5 FPGA with plug-in I/O",
             0x5605: "PMC-VFX70 Reconfigurable Virtex-5 FPGA with plug-in I/O",
             0x5606: "PMC-VLX155-1M Reconfigurable Virtex-5 FPGA with plug-in I/O",
             0x5701: "PMC-SLX150: Reconfigurable Spartan-6 FPGA with plug-in I/O",
             0x5702: "PMC-SLX150-1M: Reconfigurable Spartan-6 FPGA with plug-in I/O",
             0x5801: "XMC-VLX85 Reconfigurable Virtex-5 FPGA with plug-in I/O",
             0x5802: "XMC-VLX110 Reconfigurable Virtex-5 FPGA with plug-in I/O",
             0x5803: "XMC-VSX95 Reconfigurable Virtex-5 FPGA with plug-in I/O",
             0x5804: "XMC-VLX155 Reconfigurable Virtex-5 FPGA with plug-in I/O",
             0x5807: "XMC-SLX150: Reconfigurable Spartan-6 FPGA with plug-in I/O",
             0x5808: "XMC-SLX150-1M: Reconfigurable Spartan-6 FPGA with plug-in I/O",
             0x5901: "APCe8650 PCI Express IndustryPack Carrier Card",
             0x6301: "XMC Module with user-configurable Virtex-6 FPGA, 240k logic cells, SFP front I/O",
             0x6302: "XMC Module with user-configurable Virtex-6 FPGA, 365k logic cells, SFP front I/O",
             0x6303: "XMC Module with user-configurable Virtex-6 FPGA, 240k logic cells, no front I/O",
             0x6304: "XMC Module with user-configurable Virtex-6 FPGA, 365k logic cells, no front I/O",
             0x7000: "XMC-7K325F: User-configurable Kintex-7 FPGA, 325k logic cells plus SFP front I/O",
             0x7001: "XMC-7K410F: User-configurable Kintex-7 FPGA, 410k logic cells plus SFP front I/O",
             0x7002: "XMC-7K325AX: User-Configurable Kintex-7 FPGA, 325k logic cells with AXM Plug-In I/O",
             0x7003: "XMC-7K410AX: User-Configurable Kintex-7 FPGA, 410k logic cells with AXM Plug-In I/O",
             0x7004: "XMC-7K325CC: User-Configurable Kintex-7 FPGA, 325k logic cells, conduction-cooled",
             0x7005: "XMC-7K410CC: User-Configurable Kintex-7 FPGA, 410k logic cells, conduction-cooled",
             0x7006: "XMC-7A200: User-Configurable Artix-7 FPGA, 200k logic cells with Plug-In I/O",
             0x7007: "XMC-7A200CC: User-Configurable Conduction-Cooled Artix-7 FPGA, with 200k logic cells",
             0x7011: "AP440-1: 32-Channel Isolated Digital Input Module",
             0x7012: "AP440-2: 32-Channel Isolated Digital Input Module",
             0x7013: "AP440-3: 32-Channel Isolated Digital Input Module",
             0x7014: "AP445: 32-Channel Isolated Digital Output Module",
             0x7015: "AP471 48-Channel TTL Level Digital Input/Output Module",
             0x7016: "AP470 48-Channel TTL Level Digital Input/Output Module",
             0x7017: "AP323 16-bit, 20 or 40 Channel Analog Input Module",
             0x7018: "AP408: 32-Channel Digital I/O Module",
             0x7019: "AP341 14-bit, 16-Channel Simultaneous Conversion Analog Input Module",
             0x701A: "AP220-16 12-Bit, 16-Channel Analog Output Module",
             0x701B: "AP231-16 16-Bit, 16-Channel Analog Output Module",
             0x701C: "AP225 12-Bit, 16-Channel Analog Output Module with Waveform Memory",
             0x701D: "AP235 16-Bit, 16-Channel Analog Output Module with Waveform Memory",
             0x7021: "APA7-201 Reconfigurable Artix-7 FPGA module 48 TTL channels",
             0x7022: "APA7-202 Reconfigurable Artix-7 FPGA module 24 RS485 channels",
             0x7023: "APA7-203 Reconfigurable Artix-7 FPGA module 24 TTL & 12 RS485 channels",
             0x7024: "APA7-204 Reconfigurable Artix-7 FPGA module 24 LVDS channels",
             0x7027: "AP418 16-Channel High Voltage Digital Input/Output Module",
             0x7029: "AP342 14-bit, 12-Channel Isolated Simultaneous Conversion Analog Input Module",
             0x702A: "AP226 12-Bit, 8-Channel Isolated Analog Output Module",
             0x702B: "AP236 16-Bit, 8-Channel Isolated Analog Output Module",
             0x702C: "AP560A Module 4 Independent isolated CAN bus channels",
             0x7031: "AP441-1: 32-Channel Isolated Digital Input Module",
             0x7032: "AP441-2: 32-Channel Isolated Digital Input Module",
             0x7033: "AP441-3: 32-Channel Isolated Digital Input Module",
             0x7042: "AP482 Counter Timer Module with TTL Level Input/Output",
             0x7043: "AP483 Counter Timer Module with TTL Level and RS422 Input/Output",
             0x7044: "AP484 Counter Timer Module with RS422 Input/Output",
             0x7051: "APA7-501 Reconfigurable Artix-7 52,160 Cell FPGA module 48 TTL channels",
             0x7052: "APA7-502 Reconfigurable Artix-7 52,160 Cell FPGA module 24 RS485 channels",
             0x7053: "APA7-503 Reconfigurable Artix-7 52,160 Cell FPGA module 24 TTL & 12 RS485 channels",
             0x7054: "APA7-504 Reconfigurable Artix-7 52,160 Cell FPGA module 24 LVDS channels",
             0x7073: "AP730 Multi-function I/O Module 16 Digital I/O 8 Differential Analog In 4 Analog Out",
             },

    # Marvin Test Solutions
    0x16E2: {0x1034: "GX1034 Certification and Verification Module PXI Board",
             0x1100: "GX1100 Arbitrary Waveform and Function Generator PXI Board",
             0x1120: "GX1120 Arbitrary Waveform and Function Generator PXI Board",
             0x1164: "GX1164 Multi-Channel Programmable Resistor PXI Board",
             0x1632: "GX1632e 32-Channel Arbitrary Analog Output PXIe Board",
             0x1648: "GX1648 64-Channel Analog Output PXI Board",
             0x1649: "GX1649 64-Channel Arbitrary Analog Output PXI Board",
             0x1838: "GX1838 Precision DC Source PXI Board",
             0x2065: "GX2065 Digital Multimeter PXI Board",
             0x2200: "GTX2200 High Resolution Universal Time Interval Counter PXI Board",
             0x2201: "GC2200 High Resolution Universal Time Interval Counter PCI Board",
             0x3104: "GX3104 4-Channel 20V, 250mA Per Channel SMU PXI Board",
             0x3108: "GX3108 4-Channel Source Measure Unit PXI Board",
             0x3116: "GX3116e 16-Channel DUT Power Supply PXIe Board",
             0x3348: "GX3348 Multi-Channel DC Source and Switch Matrix Board",
             0x3500: "GX3500 Digital I/O FLEX FPGA Board",
             0x3700: "GX3700e Digital I/O FLEX FPGA PXIe Board",
             0x3701: "GX3700 Digital I/O FLEX FPGA PXI Board",
             0x3800: "GX3800e Digital I/O FLEX FPGA PXIe Board",
             0x4943: "GX4943 HellFire/Longbow Serial Communication Board",
             0x5050: "GC5050 Dynamic Digital I/O with Algorithmic Sequencer PCI Board",
             0x5055: "GX5055 Dynamic Digital I/O with Pin Electronics PXI Board",
             0x5083: "GX5083 Dynamic Digital I/O with Algorithmic Sequencer PXI Board",
             0x5105: "GX5105 High-Speed Digital I/O Timing (Master) Module PXI Board",
             0x5106: "GX5106 High-Speed Digital I/O Cycle Timing (Master) Module PXI Board",
             0x5151: "GX5150/1 High Speed Digital I/O (50/100MHz) PXI Board",
             0x5152: "GX5152/3 DSR High Speed Digital Stimulus/Response PXI Board",
             0x5250: "GX5250 Digital I/O Streaming PXI Board",
             0x5280: "GX5280 High-Speed Digital I/O PXI Board",
             0x5290: "GX5290 High-Speed Dynamic Digital I/O PXI Board",
             0x5294: "GX5294 High-Speed Digital I/O PXI Board",
             0x5295: "GX5295 Digital I/O with Pin Electronics and PMU PXI Board",
             0x5296: "GX5296 Digital I/O with Pin Electronics and PMU PXI Board",
             0x5550: "GX5050 Dynamic Digital I/O with Algorithmic Sequencer PXI Board",
             0x5641: "GX5641/2 Bi-directional Differential-TTL I/O PXI Board",
             0x5731: "GX5731 Digital I/O with 128 TTL Channels and 3x32 Customizable Channels PXI Board",
             0x5732: "GX5732 224-Channel Static Digital I/O PXI Board",
             0x5733: "GX5733 Digital I/O with 96 TTL Channels and 32 Customizable Channels PXI Board",
             0x5960: "GX5961/4 Digital I/O Timing/Sync with Pin Electronics and PMU PXI Board",
             0x6021: "GX6021 20-Channel RF Multiplexer PXI Board",
             0x6062: "GX6062 60-Channel RF Multiplexer PXI Board",
             0x6115: "GX6115 15-Channel High Current SPDT Form-C Relay PXI Board",
             0x6125: "GX6125 25-Channel High-Density SPDT Form-C Relay PXI Board",
             0x6138: "GX6138 38-Channel SPST Form-A Relay PXI Board",
             0x6188: "GX6188 104-Channel 8x8 Multiplexer/Matrix PXI Board",
             0x6192: "GX6192 16, 16x2 High Frequency, High Density Multiplexer PXI Board",
             0x6196: "GX6196 96-Channel DPST Form-A Relay Carrier PXI Board",
             0x6256: "GX6256 16, 16x2 Low Frequency, High Density Multiplexer PXI Board",
             0x6264: "GX6264 128-Channel Scanner/Multiplexer Board",
             0x6315: "GX6315 45-Channel High Current SPDT Form-C Relay Board",
             0x6325: "GX6325 75-Channel High-Density SPDT Form-C Relay Board",
             0x6338: "GX6338 114-Channel SPST Form-A Relay PXI Board",
             0x6377: "GX6377 Multifunction Switching PXI Board",
             0x6384: "GX6384 Configurable High-Density Switch Matrix PXI Board",
             0x6616: "GX6616 6x2:16 Switch Matrix PXI Board",
             0x6864: "GX6864 Video Switching PXI Board",
             0x7400: "GX7400 Dual-Output Programmable Power Supply PXI Board",
             0x7404: "GX7404 Prototyping and Power Interface PXI Board",
             0x7777: "GX7777 Generic Interface PXI Board",
             0x7779: "GX7779 Backplane Tester PXI Board",
             },

    # Intellon Corp.
    0x16E5: {0x6000: "INT6000 Ethernet-to-Powerline Bridge [HomePlug AV]",
             0x6300: "INT6300 Ethernet-to-Powerline Bridge [HomePlug AV]",
             },

    # U.S. Robotics
    0x16EC: {0x00ED: "USR997900",
             0x0116: "USR997902 10/100/1000 Mbps PCI Network Card",
             0x2F00: "USR5660A (USR265660A, USR5660A-BP) 56K PCI Faxmodem",
             0x3685: "Wireless Access PCI Adapter Model 022415",
             0x4320: "USR997904 10/100/1000 64-bit NIC (Marvell Yukon)",
             0xAB06: "USR997901A 10/100 Cardbus NIC",
             },

    # Linksys
    0x1737: {0x0029: "WPG54G ver. 4 PCI Card",
             0x1032: "Gigabit Network Adapter",
             0x1064: "Gigabit Network Adapter",
             0xAB08: "21x4x DEC-Tulip compatible 10/100 Ethernet",
             0xAB09: "21x4x DEC-Tulip compatible 10/100 Ethernet",
             },

    # Altima (nee Broadcom)
    0x173B: {0x0001: "AC1002 PCI Gigabit Ethernet controller",
             0x03E8: "AC1000 Gigabit Ethernet",
             0x03E9: "AC1001 Gigabit Ethernet",
             0x03EA: "AC9100 Gigabit Ethernet",
             0x03EB: "AC1003 Gigabit Ethernet",
             },

    # ViXS Systems, Inc.
    0x1745: {0x2020: "XCode II Series",
             0x2100: "XCode 2100 Series",
             },

    # TEDIA spol. s r. o.
    0x1760: {0x0101: "PCD-7004 Digital Bi-Directional Ports PCI Card",
             0x0102: "PCD-7104 Digital Input & Output PCI Card",
             0x0121: "PCT-7303A PC card with IRC counters",
             0x0122: "PCT-7408A PC card with counters and timers",
             0x0123: "PCT-7424 PCI card with standard counters",
             0x0141: "PCA7208AL - Analog Inputs/Outputs",
             0x0142: "PCA7208AS - Analog inputs/Outputs",
             0x0143: "PCA7408AL - Analog Inputs/Outputs",
             0x0144: "PCA7408AS - Analog Inputs/Outputs",
             0x0145: "PCA-7228AL Multifunction PCI IO card",
             0x0146: "PCA-7228AS Multifunction PCI IO card",
             0x0147: "PCA7428AL Multifunction PCI IO card",
             0x0148: "PCA7428AS Multifunction PCI IO card",
             0x0149: "PCA7228EL Multifunction PCI IO card with isolated analog inputs",
             0x0150: "PCA7428EL Multifunction PCI IO card with isolated analog inputs",
             0x0151: "PCA7628AL - PCI card with analog inputs, counters and DIO",
             0x0152: "PCA7628AS PCI card with analog inputs, outputs, counters and DIO",
             0x0161: "PCA7288A PCI card with analog outputs, counters and DIO",
             0x0180: "PCI1052 Communication card for MicroUnit network",
             0x0214: "PCT-7424C (F0) PC card with standard counters",
             0x0215: "PCT-7424C (F1) PC card with standard counters",
             0x0216: "PCT-7424E (F0) PC card with standard counters",
             0x0217: "PCT-7424E (F1) PC card with standard counters",
             0x0240: "PCA7428CL_F0 - analog Inputs",
             0x0241: "PCA7428CL_F1 - analog Inputs",
             0x0242: "PCA7428CS_F0 - Analog Inputs/Outputs non isolated",
             0x0243: "PCA7428CS_F1 - Analog Inputs/Outputs non isolated",
             0x0244: "PCA7428CE_F0 - Analog Inputs isolated",
             0x0245: "PCA7428CE_F1 - Analog Inputs isolated",
             0x0303: "PCD-7006C Digital Input & Output PCI Card",
             0x0800: "PCD8006 - PCIe digital Inputs/Outputs",
             0x0840: "PCA-8428 General-purpose multifunctional PCIe card with 8 analog inputs and 2 analog outputs",
             0x0841: "PCA-8429 General-purpose multifunctional PCIe card with 8 analog inputs",
             0x0842: "PCA-8438 General-purpose multifunctional PCIe card with 16 analog inputs and 2 analog outputs",
             0x0843: "PCA-8439 General-purpose multifunctional PCIe card with 16 analog inputs",
             0xFF00: "CTU CAN FD PCIe Card",
             },

    # Cavium, Inc.
    0x177D: {0x0001: "Nitrox XL N1",
             0x0003: "Nitrox XL N1 Lite",
             0x0004: "Octeon (and older) FIPS",
             0x0005: "Octeon CN38XX Network Processor Pass 3.x",
             0x0006: "RoHS",
             0x0010: "CN15XX/CN16XX [Nitrox PX]",
             0x0011: "CNN35XX [Nitrox III]",
             0x0012: "CNN55XX [Nitrox V]",
             0x0020: "Octeon CN31XX Network Processor",
             0x0030: "Octeon CN30XX Network Processor",
             0x0040: "Octeon CN58XX Network Processor",
             0x0050: "Octeon CN57XX Network Processor (CN54XX/CN55XX/CN56XX)",
             0x0070: "Octeon CN50XX Network Processor",
             0x0080: "Octeon CN52XX Network Processor",
             0x0090: "Octeon II CN63XX Network Processor",
             0x0091: "Octeon II CN68XX Network Processor",
             0x0092: "Octeon II CN65XX Network Processor",
             0x0093: "Octeon II CN61XX Network Processor",
             0x0094: "Octeon Fusion CNF71XX Cell processor",
             0x0095: "Octeon III CN78XX Network Processor",
             0x0096: "Octeon III CN70XX Network Processor",
             0x9700: "Octeon III CN73XX Network Processor",
             0x9702: "CN23XX [LiquidIO II] Intelligent Adapter",
             0x9703: "CN23XX [LiquidIO II] NVMe Controller",
             0x9712: "CN23XX [LiquidIO II] SRIOV Virtual Function",
             0x9713: "CN23XX [LiquidIO II] NVMe SRIOV Virtual Function",
             0x9800: "Octeon Fusion CNF75XX Processor",
             0xA001: "ThunderX MRML(Master RML Bridge to RSL devices)",
             0xA002: "THUNDERX PCC Bridge",
             0xA008: "THUNDERX SMMU",
             0xA009: "THUNDERX Generic Interrupt Controller",
             0xA00A: "THUNDERX GPIO Controller",
             0xA00B: "THUNDERX MPI / SPI Controller",
             0xA00C: "THUNDERX MIO-PTP Controller",
             0xA00D: "THUNDERX MIX Network Controller",
             0xA00E: "THUNDERX Reset Controller",
             0xA00F: "THUNDERX UART Controller",
             0xA010: "THUNDERX eMMC/SD Controller",
             0xA011: "THUNDERX MIO-BOOT Controller",
             0xA012: "THUNDERX TWSI / I2C Controller",
             0xA013: "THUNDERX CCPI (Multi-node connect)",
             0xA014: "THUNDERX Voltage Regulator Module",
             0xA015: "THUNDERX PCIe Switch Logic Interface",
             0xA016: "THUNDERX Key Memory",
             0xA017: "THUNDERX GTI (Global System Timers)",
             0xA018: "THUNDERX Random Number Generator",
             0xA019: "THUNDERX DFA",
             0xA01A: "THUNDERX Zip Coprocessor",
             0xA01B: "THUNDERX xHCI USB Controller",
             0xA01C: "THUNDERX AHCI SATA Controller",
             0xA01D: "THUNDERX RAID Coprocessor",
             0xA01E: "THUNDERX Network Interface Controller",
             0xA01F: "THUNDERX Traffic Network Switch",
             0xA020: "THUNDERX PEM (PCI Express Interface)",
             0xA021: "THUNDERX L2C (Level-2 Cache Controller)",
             0xA022: "THUNDERX LMC (DRAM Controller)",
             0xA023: "THUNDERX OCLA (On-Chip Logic Analyzer)",
             0xA024: "THUNDERX OSM",
             0xA025: "THUNDERX GSER (General Serializer/Deserializer)",
             0xA026: "THUNDERX BGX (Common Ethernet Interface)",
             0xA027: "THUNDERX IOBN",
             0xA029: "THUNDERX NCSI (Network Controller Sideband Interface)",
             0xA02A: "ThunderX SGPIO (Serial GPIO controller for SATA disk lights)",
             0xA02B: "THUNDERX SMI / MDIO Controller",
             0xA02C: "THUNDERX DAP (Debug Access Port)",
             0xA02D: "THUNDERX PCIERC (PCIe Root Complex)",
             0xA02E: "ThunderX L2C-TAD (Level 2 cache tag and data)",
             0xA02F: "THUNDERX L2C-CBC",
             0xA030: "THUNDERX L2C-MCI",
             0xA031: "THUNDERX MIO-FUS (Fuse Access Controller)",
             0xA032: "THUNDERX FUSF (Fuse Controller)",
             0xA033: "THUNDERX Random Number Generator virtual function",
             0xA034: "THUNDERX Network Interface Controller virtual function",
             0xA035: "THUNDERX Parallel Bus",
             0xA036: "ThunderX RAD (RAID acceleration engine) virtual function",
             0xA037: "THUNDERX ZIP virtual function",
             0xA040: "THUNDERX CPT Cryptographic Accelerator",
             0xA059: "Octeon TX2 CGX (MAC)",
             0xA060: "Octeon 10 RPM (MAC)",
             0xA061: "Octeon Tx2 Loopback Interface (LBK)",
             0xA063: "Octeon Tx2 RVU Physical Function",
             0xA064: "Octeon Tx2 RVU Virtual Function",
             0xA065: "Octeon Tx2 RVU Admin Function",
             0xA09E: "Octeon 10 PTP controller",
             0xA0F2: "Octeon 10 CPT Cryptographic Accelerator, Physical function",
             0xA0F3: "Octeon 10 CPT Cryptographic Accelerator, Virtual function",
             0xA0F6: "Octeon Tx2 SDP Physical Function",
             0xA0F7: "Octeon Tx2 SDP Virtual Function",
             0xA0F8: "Octeon Tx2 Loopback Interface Virtual Function (LBKVF)",
             0xA0FD: "Octeon Tx2 CPT Cryptographic Accelerator, Physical function",
             0xA0FE: "Octeon Tx2 CPT Cryptographic Accelerator, Virtual function",
             0xA100: "THUNDERX CN88XX 48 core SoC",
             0xA200: "OCTEON TX CN81XX/CN80XX",
             0xA300: "OCTEON TX CN83XX",
             0xAF00: "CN99xx [ThunderX2] Integrated PCI Host bridge",
             0xAF84: "CN99xx [ThunderX2] Integrated PCI Express RP Bridge",
             },

    # Research Centre Juelich
    0x1796: {0x0001: "SIS1100 [Gigabit link]",
             0x0002: "HOTlink",
             0x0003: "Counter Timer",
             0x0004: "CAMAC Controller",
             0x0005: "PROFIBUS",
             0x0006: "AMCC HOTlink",
             0x0007: "LVD Cable Bus",
             0x0008: "100MHz, 64bit Sequence Generator based on VirtexII",
             0x0009: "double 14bit-ADC",
             0x000A: "SIS1100 with N110 TDC",
             0x000B: "double 14bit-ADC with memory",
             0x000D: "Synchronisation Slave",
             0x000E: "SIS1100-eCMC",
             0x000F: "TDC (GPX)",
             0x0010: "PCIe Counter Timer",
             0x0011: "SIS1100-e single link",
             0x0012: "SIS1100-e quad link",
             0x0013: "4x2.5GHz SFP to 4 lane PCIe bridge",
             0x0014: "SIS1100 with GPX piggy back",
             0x0015: "SIS8100 [Gigabit link, MicroTCA]",
             0x0016: "SIS1100e with 4 lanes",
             0x0017: "Quad 14bit, 50MHz ADC with 2.5GHz SFP",
             0x0018: "SIS8300 4-lane PCI Express, Micro TCA for Physics ADC",
             0x0019: "SIS SIS8300-Lx MTCA.4 Digitizer",
             0x001A: "100MHz, 64bit Sequence Generator based on VirtexII",
             0x001C: "Quad 16bit, 150MHz ADC with 2.5GHz SFP",
             0x0030: "100MHz, 64bit Sequence Generator based on Spartan6",
             0x0031: "200MHz 64bit Sequence Generator based on Spartan7",
             },

    # Intersil Techwell
    0x1797: {0x5864: "TW5864 multimedia video controller",
             0x6801: "TW6802 multimedia video card",
             0x6802: "TW6802 multimedia other device",
             0x6810: "TW6816 multimedia video controller",
             0x6811: "TW6816 multimedia video controller",
             0x6812: "TW6816 multimedia video controller",
             0x6813: "TW6816 multimedia video controller",
             0x6814: "TW6816 multimedia video controller",
             0x6815: "TW6816 multimedia video controller",
             0x6816: "TW6816 multimedia video controller",
             0x6817: "TW6816 multimedia video controller",
             0x6864: "TW6864 multimedia video controller",
             },

    # Belkin
    0x1799: {0x6001: "F5D6001 Wireless PCI Card [Realtek RTL8180]",
             0x6020: "F5D6020 v3000 Wireless PCMCIA Card [Realtek RTL8180]",
             0x6060: "F5D6060 Wireless PDA Card",
             0x700F: "F5D7000 v7000 Wireless G Desktop Card [Realtek RTL8185]",
             0x701F: "F5D7010 v7000 Wireless G Notebook Card [Realtek RTL8185]",
             },

    # Data Patterns
    0x179C: {0x0557: "DP-PCI-557 [PCI 1553B]",
             0x0566: "DP-PCI-566 [Intelligent PCI 1553B]",
             0x1152: "DP-cPCI-1152 (8-channel Isolated ADC Module)",
             0x5031: "DP-CPCI-5031-Synchro Module",
             0x5112: "DP-cPCI-5112 [MM-Carrier]",
             0x5121: "DP-CPCI-5121-IP Carrier",
             0x5211: "DP-CPCI-5211-IP Carrier",
             0x5679: "AGE Display Module",
             },

    # Genesys Logic, Inc
    0x17A0: {0x7163: "GL9701 PCIe to PCI Bridge",
             0x8083: "GL880 USB 1.1 UHCI controller",
             0x8084: "GL880 USB 2.0 EHCI controller",
             0x9750: "GL9750 SD Host Controller",
             0x9755: "GL9755 SD Host Controller",
             0xE763: "GL9763E eMMC Controller",
             },

    # Lenovo
    0x17AA: {0x0005: "LENSE30256GMSP34MEAT3TA",
             0x3181: "ThinkCentre M75n IoT",
             0x402B: "Intel 82599ES 10Gb 2-port Server Adapter X520-2",
             },

    # Indra Networks, Inc.
    0x17B4: {0x0011: "WebEnhance 100 GZIP Compression Card",
             0x0012: "WebEnhance 200 GZIP Compression Card",
             0x0015: "WebEnhance 300 GZIP Compression Card",
             0x0016: "StorCompress 300 GZIP Compression Card",
             0x0017: "StorSecure 300 GZIP Compression and AES Encryption Card",
             },

    # Qualcomm Technologies, Inc
    0x17CB: {0x0001: "AGN100 802.11 a/b/g True MIMO Wireless Card",
             0x0002: "AGN300 802.11 a/b/g True MIMO Wireless Card",
             0x0105: "MSM8998 PCIe Root Complex",
             0x0108: "SM8150 PCIe Root Complex",
             0x0109: "SA8195P PCIe Root Complex",
             0x0300: "MDM9x35 LTE Modem [Snapdragon X7]",
             0x0301: "MDM9x45 LTE Modem [Snapdragon X12]",
             0x0302: "MDM9x55 LTE Modem [Snapdragon X16]",
             0x0400: "Datacenter Technologies QDF2432 PCI Express Root Port",
             0x0401: "Datacenter Technologies QDF2400 PCI Express Root Port",
             0x1000: "QCS405 PCIe Root Complex",
             0x1101: "QCA6390 Wireless Network Adapter",
             0x1103: "QCNFA765 Wireless Network Adapter",
             0x1104: "QCN6024/9024/9074 Wireless Network Adapter",
             },

    # Areca Technology Corp.
    0x17D3: {0x1110: "ARC-1110 4-Port PCI-X to SATA RAID Controller",
             0x1120: "ARC-1120 8-Port PCI-X to SATA RAID Controller",
             0x1130: "ARC-1130 12-Port PCI-X to SATA RAID Controller",
             0x1160: "ARC-1160 16-Port PCI-X to SATA RAID Controller",
             0x1170: "ARC-1170 24-Port PCI-X to SATA RAID Controller",
             0x1201: "ARC-1200 2-Port PCI-Express to SATA II RAID Controller",
             0x1203: "ARC-1203 2/4/8 Port PCIe 2.0 to SATA 6Gb RAID Controller",
             0x1210: "ARC-1210 4-Port PCI-Express to SATA RAID Controller",
             0x1214: "ARC-12x4 PCIe 2.0 to SAS/SATA 6Gb RAID Controller",
             0x1220: "ARC-1220 8-Port PCI-Express to SATA RAID Controller",
             0x1222: "ARC-1222 8-Port PCI-Express to SAS/SATA II RAID Controller",
             0x1230: "ARC-1230 12-Port PCI-Express to SATA RAID Controller",
             0x1260: "ARC-1260 16-Port PCI-Express to SATA RAID Controller",
             0x1280: "ARC-1280/1280ML 24-Port PCI-Express to SATA II RAID Controller",
             0x1300: "ARC-1300ix-16 16-Port PCI-Express to SAS Non-RAID Host Adapter",
             0x1320: "ARC-1320 8/16 Port PCIe 2.0 to SAS/SATA 6Gb Non-RAID Host Adapter",
             0x1330: "ARC-1330 16 Port PCIe 3.0 to SAS/SATA 12Gb Non-RAID Host Adapter",
             0x1680: "ARC-1680 series PCIe to SAS/SATA 3Gb RAID Controller",
             0x1880: "ARC-188x series PCIe 2.0/3.0 to SAS/SATA 6/12Gb RAID Controller",
             0x1884: "ARC-1884 series PCIe 3.0 to SAS/SATA 12/6Gb RAID Controller",
             0x1886: "ARC-1886 series PCIe 4.0 to NVMe/SAS/SATA 16/12/6Gb RAID Controller",
             0x188A: "ARC-1886 series PCIe 4.0 to NVMe/SAS/SATA 16/12/6Gb RAID Controller",
             },

    # Exar Corp.
    0x17D5: {0x5731: "Xframe 10-Gigabit Ethernet PCI-X",
             0x5732: "Xframe II 10-Gigabit Ethernet PCI-X 2.0",
             0x5831: "Xframe 10-Gigabit Ethernet PCI-X",
             0x5832: "Xframe II 10-Gigabit Ethernet PCI-X 2.0",
             0x5833: "X3100 Series 10 Gigabit Ethernet PCIe",
             },

    # Dini Group
    0x17DF: {0x1864: "Virtex4 PCI Board w/ QL5064 Bridge [DN7000K10PCI/DN8000K10PCI/DN8000K10PSX/NOTUS]",
             0x1865: "Virtex4 ASIC Emulator [DN8000K10PCIe]",
             0x1866: "Virtex4 ASIC Emulator Cable Connection [DN8000K10PCI]",
             0x1867: "Virtex4 ASIC Emulator Cable Connection [DN8000K10PCIe]",
             0x1868: "Virtex4 ASIC Emulator [DN8000K10PCIe-8]",
             0x1900: "Virtex5 PCIe ASIC Emulator [DN9000K10PCIe8T/DN9002K10PCIe8T/DN9200K10PCIe8T/DN7006K10PCIe8T/DN7406K10PCIe8T]",
             0x1901: "Virtex5 PCIe ASIC Emulator Large BARs [DN9000K10PCIe8T/DN9002K10PCIe8T/DN9200K10PCIe8T/DN7006K10PCIe8T/DN7406K10PCIe8T]",
             0x1902: "Virtex5 PCIe ASIC Emulator Low Power [Interceptor]",
             0x1903: "Spartan6 PCIe FPGA Accelerator Board [DNBFCS12PCIe]",
             0x1904: "Virtex6 PCIe ASIC Emulation Board [DNDUALV6_PCIe4]",
             0x1905: "Virtex6 PCIe ASIC Emulation Board [DNV6F6PCIe]",
             0x1906: "Virtex6 PCIe ASIC Emulation Board [DN2076K10]",
             0x1907: "Virtex6 PCIe ASIC Emulation Board [DNV6F2PCIe]",
             0x1908: "Virtex6 PCIe ASIC Emulation Board Large BARs[DNV6F2PCIe]",
             0x1909: "Kintex7 PCIe FPGA Accelerator Board [DNK7F5PCIe]",
             0x190A: "Virtex7 PCIe ASIC Emulation Board [DNV7F1A]",
             0x190B: "Stratix5 PCIe ASIC Emulation Board [DNS5GXF2]",
             0x190C: "Virtex7 PCIe ASIC Emulation Board [DNV7F2A]",
             0x190D: "Virtex7 PCIe ASIC Emulation Board [DNV7F4A]",
             0x190E: "Virtex7 PCIe ASIC Emulation Board [DNV7F2B]",
             0x190F: "KintexUS PCIe MainRef Design [DNPCIE_40G_KU_LL]",
             0x1910: "VirtexUS ASIC Emulation Board [DNVUF4A]",
             0x1911: "VirtexUS PCIe ASIC Emulation Board [DNVU_F2PCIe]",
             0x1912: "KintexUS PCIe MainRef Design [DNPCIe_40G_KU_LL_QSFP]",
             0x1913: "VirtexUS ASIC Emulation Board [DNVUF1A]",
             0x1914: "VirtexUS ASIC Emulation Board [DNVUF2A]",
             0x1915: "Arria10 PCIe MainRef Design [DNPCIe_80G_A10_LL]",
             0x1916: "VirtexUS PCIe Accelerator Board [DNVUF2_HPC_PCIe]",
             0x1917: "UltrascalePlus PCIe Accelerator Board [DNPCIe_400G_VU_LL]",
             0x1918: "VirtexUS+ ASIC Emulation Board [DNVUPF4A]",
             0x1919: "UltrascalePlus PCIe Accelerator Board [DNPCIe_400G_VUP_HBM_LL]",
             0x1A00: "Virtex6 PCIe DMA Netlist Design",
             0x1A01: "Virtex6 PCIe Darklite Design [DNPCIe_HXT_10G_LL]",
             0x1A02: "Virtex7 PCIe DMA Netlist Design",
             0x1A03: "Kintex7 PCIe Darklite Design [DNPCIe_K7_10G_LL]",
             0x1A05: "Stratix5 PCIe Darklite Design [DNS5GX_F2]",
             0x1A06: "VirtexUS PCIe DMA Netlist Design",
             0x1A07: "KintexUS PCIe Darklite Design [DNPCIe_40G_KU_LL]",
             0x1A08: "KintexUS PCIe Darklite Design [DNPCIe_40G_KU_LL_QSFP]",
             0x1A09: "Arria10 PCIe Darklite Design [DNPCIe_80G_A10_LL]",
             0x1A0A: "VirtexUS PCIe Darklite Design [DNVUF2_HPC_PCIe]",
             0x1A0B: "UltrascalePlus PCIe Darklite Design [DNPCIe_400G_VU_LL]",
             0x1A0C: "KintexUS PCIe DRAM Packet Capture Design [DNPCIe_40G_KU_LL]",
             0x1A0D: "KintexUS PCIe DRAM Packet Capture Design [DNPCIe_40G_KU_LL_2QSFP]",
             0x1A0E: "UltrascalePlus PCIe Darklite Design [DNPCIe_400G_VUP_HBM_LL]",
             },

    # Sectra AB
    0x17E4: {0x0001: "KK671 Cardbus encryption board",
             0x0002: "KK672 Cardbus encryption board",
             },

    # MaxLinear
    0x17E6: {0x0010: "EN2010 [c.Link] MoCA Network Controller (Coax, PCI interface)",
             0x0011: "EN2010 [c.Link] MoCA Network Controller (Coax, MPEG interface)",
             0x0021: "EN2210 [c.Link] MoCA Network Controller (Coax)",
             0x0025: "EN2510 [c.Link] MoCA Network Controller (Coax, PCIe interface)",
             0x0027: "EN2710 [c.Link] MoCA 2.0 Network Controller (Coax, PCIe interface)",
             0x3700: "MoCA 2.0 Network Controller (Coax, PCIe interface)",
             0x3710: "MoCA 2.5 Network Controller (Coax, PCIe interface)",
             },

    # RDC Semiconductor, Inc.
    0x17F3: {0x1010: "R1010 IDE Controller",
             0x1011: "R1011 IDE Controller",
             0x1012: "R1012 IDE Controller",
             0x1031: "PCI/PCI-X to PCI-E Bridge",
             0x1070: "CAN Bus Controller",
             0x1331: "Motion Control Interface",
             0x1930: "Hybrid Function Control Register",
             0x2010: "RDC M2010 VGA-compatible graphics adapter",
             0x2012: "M2012/R3308 VGA-compatible graphics adapter",
             0x2015: "RDC M2015 VGA-compatible graphics adapter",
             0x6011: "R6011 ISA Bridge",
             0x6013: "R6013 ISA Bridge",
             0x6020: "R6020 North Bridge",
             0x6021: "R6021 Host Bridge",
             0x6022: "R6022 Host Bridge",
             0x6023: "R6023 Host Bridge",
             0x6025: "R6025 Host Bridge",
             0x6026: "R6026 Host Bridge",
             0x6030: "R6030 ISA Bridge",
             0x6031: "R6031 ISA Bridge",
             0x6035: "R6035 ISA Bridge",
             0x6036: "R6036 ISA Bridge",
             0x6040: "R6040 MAC Controller",
             0x6060: "R6060 USB 1.1 Controller",
             0x6061: "R6061 USB 2.0 Controller",
             },

    # InProComm Inc.
    0x17FE: {0x2120: "IPN 2120 802.11b",
             0x2220: "IPN 2220 802.11g",
             },

    # Ambient Technologies Inc
    0x1813: {0x4000: "HaM controllerless modem",
             0x4100: "HaM plus Data Fax Modem",
             },

    # Ralink corp.
    0x1814: {0x0101: "Wireless PCI Adapter RT2400 / RT2460",
             0x0200: "RT2500 802.11g PCI [PC54G2]",
             0x0201: "RT2500 Wireless 802.11bg",
             0x0300: "Wireless Adapter Canyon CN-WF511",
             0x0301: "RT2561/RT61 802.11g PCI",
             0x0302: "RT2561/RT61 rev B 802.11g",
             0x0401: "RT2600 802.11 MIMO",
             0x0601: "RT2800 802.11n PCI",
             0x0681: "RT2890 Wireless 802.11n PCIe",
             0x0701: "RT2760 Wireless 802.11n 1T/2R",
             0x0781: "RT2790 Wireless 802.11n 1T/2R PCIe",
             0x3060: "RT3060 Wireless 802.11n 1T/1R",
             0x3062: "RT3062 Wireless 802.11n 2T/2R",
             0x3090: "RT3090 Wireless 802.11n 1T/1R PCIe",
             0x3091: "RT3091 Wireless 802.11n 1T/2R PCIe",
             0x3092: "RT3092 Wireless 802.11n 2T/2R PCIe",
             0x3290: "RT3290 Wireless 802.11n 1T/1R PCIe",
             0x3298: "RT3290 Bluetooth",
             0x3592: "RT3592 Wireless 802.11abgn 2T/2R PCIe",
             0x359F: "RT3592 PCIe Wireless Network Adapter",
             0x5360: "RT5360 Wireless 802.11n 1T/1R",
             0x5362: "RT5362 PCI 802.11n Wireless Network Adapter",
             0x5390: "RT5390 Wireless 802.11n 1T/1R PCIe",
             0x5392: "RT5392 PCIe Wireless Network Adapter",
             0x539B: "RT5390R 802.11bgn PCIe Wireless Network Adapter",
             0x539F: "RT5390 [802.11 b/g/n 1T1R G-band PCI Express Single Chip]",
             0x5592: "RT5592 PCIe Wireless Network Adapter",
             0xE932: "RT2560F 802.11 b/g PCI",
             },

    # SiteCom Europe BV
    0x182D: {0x3069: "ISDN PCI DC-105V2",
             0x9790: "WL-121 Wireless Network Adapter 100g+ [Ver.3]",
             },

    # Credence Systems Corporation
    0x1830: {0x8000: "CPIn",
             0x8001: "CPId",
             0x8002: "CPIx",
             0x8003: "CPIq",
             },

    # MikroM GmbH
    0x183B: {0x08A7: "MVC100 DVI",
             0x08A8: "MVC101 SDI",
             0x08A9: "MVC102 DVI+Audio",
             0x08B0: "MVC200-DC",
             },

    # Topspin Communications
    0x1867: {0x5A44: "MT23108 InfiniHost HCA",
             0x5A45: "MT23108 InfiniHost HCA flash recovery",
             0x5A46: "MT23108 InfiniHost HCA bridge",
             0x6278: "MT25208 InfiniHost III Ex (Tavor compatibility mode)",
             0x6282: "MT25208 InfiniHost III Ex",
             },

    # Humusoft, s.r.o.
    0x186C: {0x0612: "AD612 Data Acquisition Device",
             0x0614: "MF614 Multifunction I/O Card",
             0x0622: "AD622 Data Acquisition Device",
             0x0624: "MF624 Multifunction I/O PCI Card",
             0x0625: "MF625 3-phase Motor Driver",
             0x0634: "MF634 Multifunction I/O PCIe Card",
             0x0644: "MF644 Multifunction I/O Thb Card",
             },

    # L-3 Communications
    0x1876: {0xA101: "VigraWATCH PCI",
             0xA102: "VigraWATCH PMC",
             0xA103: "Vigra I/O",
             },

    # ZyXEL Communications Corporation
    0x187E: {0x3403: "ZyAir G-110 802.11g",
             0x340E: "M-302 802.11g XtremeMIMO",
             },

    # Varisys Ltd
    0x1888: {0x0301: "VMFX1 FPGA PMC module",
             0x0601: "VSM2 dual PMC carrier",
             0x0710: "VS14x series PowerPC PCI board",
             0x0720: "VS24x series PowerPC PCI board",
             },

    # B&B Electronics Manufacturing Company, Inc.
    0x1896: {0x4202: "MIport 3PCIU2 2-port Serial",
             0x4204: "MIport 3PCIU4 4-port Serial",
             0x4208: "MIport 3PCIU8 8-port Serial",
             0x4211: "MIport 3PCIOU1 1-port Isolated Serial",
             0x4212: "MIport 3PCIOU2 2-port Isolated Serial",
             0x4214: "MIport 3PCIOU4 4-port Isolated Serial",
             0xBB10: "3PCI2 2-Port Serial",
             0xBB11: "3PCIO1 1-Port Isolated Serial",
             },

    # DViCO Corporation
    0x18AC: {0xD500: "FusionHDTV 5",
             0xD800: "FusionHDTV 3 Gold",
             0xD810: "FusionHDTV 3 Gold-Q",
             0xD820: "FusionHDTV 3 Gold-T",
             0xDB30: "FusionHDTV DVB-T Pro",
             0xDB40: "FusionHDTV DVB-T Hybrid",
             0xDB78: "FusionHDTV DVB-T Dual Express",
             },

    # XGI Technology Inc. (eXtreme Graphics Innovation)
    0x18CA: {0x0020: "Z7/Z9 (XG20 core)",
             0x0021: "Z9s/Z9m (XG21 core)",
             0x0027: "Z11/Z11M",
             0x0040: "Volari V3XT/V5/V8",
             0x0047: "Volari 8300 (chip: XP10, codename: XG47)",
             },

    # Cesnet, z.s.p.o.
    0x18EC: {0x6D05: "ML555",
             0xC006: "COMBO6",
             0xC032: "COMBO-LXT110",
             0xC045: "COMBO6E",
             0xC050: "COMBO-PTM",
             0xC058: "COMBO6X",
             0xC132: "COMBO-LXT155",
             0xC232: "COMBO-FXT100",
             0xC400: "COMBO-400G1",
             },

    # Napatech A/S
    0x18F4: {0x0031: "NT20X Network Adapter",
             0x0051: "NT20X Capture Card",
             0x0061: "NT20E Capture Card",
             0x0064: "NT20E Inline Card",
             0x0071: "NT4E Capture Card",
             0x0074: "NT4E Inline Card",
             0x0081: "NT4E 4-port Expansion Card",
             0x0091: "NT20X Capture Card [New Rev]",
             0x00A1: "NT4E-STD Capture Card",
             0x00A4: "NT4E-STD Inline Card",
             0x00B1: "NTBPE Optical Bypass Adapter",
             0x00C5: "NT20E2 Network Adapter 2x10Gb",
             0x00D5: "NT40E2-4 Network Adapter 4x10Gb",
             0x00E5: "NT40E2-1 Network Adapter 1x40Gb",
             0x00F5: "NT4E2-4T-BP Network Adapter 4x1Gb with Electrical Bypass",
             0x0105: "NT4E2-4-PTP Network Adapter 4x1Gb",
             0x0115: "NT20E2-PTP Network Adapter 2x10Gb",
             0x0125: "NT4E2-4-PTP Network Adapter 4x1Gb",
             0x0135: "NT20E2-PTP Network Adapter 2x10Gb",
             0x0145: "NT40E3-4-PTP Network Adapter 4x10Gb",
             0x0155: "NT100E3-1-PTP Network Adapter 1x100Gb",
             0x0165: "NT80E3-2-PTP Network Adapter 2x40Gb",
             0x0175: "NT20E3-2-PTP Network Adapter 2x10Gb",
             0x0185: "NT40A01 Network Adapter",
             0x01A5: "NT200A01 Network Adapter",
             0x01C5: "NT200A02 Network Adapter",
             0x01D5: "NT50B01 Network Adapter",
             0x01E5: "NT100A01 Network Adapter",
             0x0225: "NT40A11 Network Adapter",
             },

    # NextIO
    0x18F6: {0x1000: "[Nexsis] Switch Virtual P2P PCIe Bridge",
             0x1001: "[Texsis] Switch Virtual P2P PCIe Bridge",
             0x1050: "[Nexsis] Switch Virtual P2P PCI Bridge",
             0x1051: "[Texsis] Switch Virtual P2P PCI Bridge",
             0x2000: "[Nexsis] Switch Integrated Mgmt. Endpoint",
             0x2001: "[Texsis] Switch Integrated Mgmt. Endpoint",
             },

    # Commtech, Inc.
    0x18F7: {0x0001: "ESCC-PCI-335 Serial PCI Adapter [Fastcom]",
             0x0002: "422/4-PCI-335 Serial PCI Adapter [Fastcom]",
             0x0003: "232/4-1M-PCI Serial PCI Adapter [Fastcom]",
             0x0004: "422/2-PCI-335 Serial PCI Adapter [Fastcom]",
             0x0005: "IGESCC-PCI-ISO/1 Serial PCI Adapter [Fastcom]",
             0x000A: "232/4-PCI-335 Serial PCI Adapter [Fastcom]",
             0x000B: "232/8-PCI-335 Serial PCI Adapter [Fastcom]",
             0x000F: "FSCC Serial PCI Adapter [Fastcom]",
             0x0010: "GSCC Serial PCI Adapter [Fastcom]",
             0x0011: "QSSB Serial PCI Adapter [Fastcom]",
             0x0014: "SuperFSCC Serial PCI Adapter [Fastcom]",
             0x0015: "SuperFSCC-104-LVDS Serial PC/104+ Adapter [Fastcom]",
             0x0016: "FSCC-232 RS-232 Serial PCI Adapter [Fastcom]",
             0x0017: "SuperFSCC-104 Serial PC/104+ Adapter [Fastcom]",
             0x0018: "SuperFSCC/4 Serial PCI Adapter [Fastcom]",
             0x0019: "SuperFSCC Serial PCI Adapter [Fastcom]",
             0x001A: "SuperFSCC-LVDS Serial PCI Adapter [Fastcom]",
             0x001B: "FSCC/4 Serial PCI Adapter [Fastcom]",
             0x001C: "SuperFSCC/4-LVDS Serial PCI Adapter [Fastcom]",
             0x001D: "FSCC Serial PCI Adapter [Fastcom]",
             0x001E: "SuperFSCC/4 Serial PCIe Adapter [Fastcom]",
             0x001F: "SuperFSCC/4 Serial cPCI Adapter [Fastcom]",
             0x0020: "422/4-PCIe Serial PCIe Adapter [Fastcom]",
             0x0021: "422/8-PCIe Serial PCIe Adapter [Fastcom]",
             0x0022: "SuperFSCC/4-LVDS Serial PCIe Adapter [Fastcom]",
             0x0023: "SuperFSCC/4 Serial cPCI Adapter [Fastcom]",
             0x0025: "SuperFSCC/4-LVDS Serial PCI Adapter [Fastcom]",
             0x0026: "SuperFSCC-LVDS Serial PCI Adapter [Fastcom]",
             0x0027: "FSCC/4 Serial PCIe Adapter [Fastcom]",
             },

    # Hangzhou Silan Microelectronics Co., Ltd.
    0x1904: {0x2031: "SC92031 PCI Fast Ethernet Adapter",
             0x8139: "RTL8139D [Realtek] PCI 10/100BaseTX ethernet adaptor",
             },

    # Renesas Technology Corp.
    0x1912: {0x0002: "SH7780 PCI Controller (PCIC)",
             0x0011: "SH7757 PCIe End-Point [PBI]",
             0x0012: "SH7757 PCIe-PCI Bridge [PPB]",
             0x0013: "SH7757 PCIe Switch [PS]",
             0x0014: "uPD720201 USB 3.0 Host Controller",
             0x0015: "uPD720202 USB 3.0 Host Controller",
             0x001A: "SH7758 PCIe-PCI Bridge [PPB]",
             0x001B: "SH7758 PCIe End-Point [PBI]",
             0x001D: "SH7758 PCIe Switch [PS]",
             },

    # Sangoma Technologies Corp.
    0x1923: {0x0040: "A200/Remora FXO/FXS Analog AFT card",
             0x0100: "A104d QUAD T1/E1 AFT card",
             0x0300: "A101 single-port T1/E1",
             0x0400: "A104u Quad T1/E1 AFT",
             },

    # Solarflare Communications
    0x1924: {0x0703: "SFC4000 rev A net [Solarstorm]",
             0x0710: "SFC4000 rev B [Solarstorm]",
             0x0803: "SFC9020 10G Ethernet Controller",
             0x0813: "SFL9021 10GBASE-T Ethernet Controller",
             0x0903: "SFC9120 10G Ethernet Controller",
             0x0923: "SFC9140 10/40G Ethernet Controller",
             0x0A03: "SFC9220 10/40G Ethernet Controller",
             0x0B03: "XtremeScale SFC9250 10/25/40/50/100G Ethernet Controller",
             0x1803: "SFC9020 10G Ethernet Controller (Virtual Function)",
             0x1813: "SFL9021 10GBASE-T Ethernet Controller (Virtual Function)",
             0x1903: "SFC9120 10G Ethernet Controller (Virtual Function)",
             0x1923: "SFC9140 10/40G Ethernet Controller (Virtual Function)",
             0x1A03: "SFC9220 10/40G Ethernet Controller (Virtual Function)",
             0x1B03: "XtremeScale SFC9250 10/25/40/50/100G Ethernet Controller (Virtual Function)",
             0x6703: "SFC4000 rev A iSCSI/Onload [Solarstorm]",
             0xC101: "EF1-21022T [EtherFabric]",
             },

    # AHA Products Group
    0x193F: {0x0001: "AHA36x-PCIX",
             0x0360: "AHA360-PCIe",
             0x0363: "AHA363-PCIe",
             0x0364: "AHA364-PCIe",
             0x0367: "AHA367-PCIe",
             0x0370: "AHA370-PCIe",
             0x0604: "AHA604",
             0x0605: "AHA605",
             0x3641: "AHA3641",
             0x3642: "AHA3642",
             0x6101: "AHA6101",
             0x6102: "AHA6102",
             },

    # ClearSpeed Technology plc
    0x1942: {0xE511: "Advance X620 accelerator card",
             0xE521: "Advance e620 accelerator card",
             },

    # DapTechnology B.V.
    0x194A: {0x1111: "FireSpy3850",
             0x1112: "FireSpy450b",
             0x1113: "FireSpy450bT",
             0x1114: "FireSpy850",
             0x1115: "FireSpy850bT",
             0x1200: "FireTrac 3460bT",
             0x1201: "FireTrac 3460bT (fallback firmware)",
             0x1202: "FireTrac 3460bT",
             0x1203: "FireTrac 3460bT (fallback firmware)",
             },

    # Freescale Semiconductor Inc
    0x1957: {0x0012: "MPC8548E",
             0x0013: "MPC8548",
             0x0014: "MPC8543E",
             0x0015: "MPC8543",
             0x0018: "MPC8547E",
             0x0019: "MPC8545E",
             0x001A: "MPC8545",
             0x0020: "MPC8568E",
             0x0021: "MPC8568",
             0x0022: "MPC8567E",
             0x0023: "MPC8567",
             0x0030: "MPC8533E",
             0x0031: "MPC8533",
             0x0032: "MPC8544E",
             0x0033: "MPC8544",
             0x0040: "MPC8572E",
             0x0041: "MPC8572",
             0x0050: "MPC8536E",
             0x0051: "MPC8536",
             0x0052: "MPC8535E",
             0x0053: "MPC8535",
             0x0060: "MPC8569",
             0x0061: "MPC8569E",
             0x0070: "P2020E",
             0x0071: "P2020",
             0x0078: "P2010E",
             0x0079: "P2010",
             0x0080: "MPC8349E",
             0x0081: "MPC8349",
             0x0082: "MPC8347E TBGA",
             0x0083: "MPC8347 TBGA",
             0x0084: "MPC8347E PBGA",
             0x0085: "MPC8347 PBGA",
             0x0086: "MPC8343E",
             0x0087: "MPC8343",
             0x00B4: "MPC8315E",
             0x00B6: "MPC8314E",
             0x00C2: "MPC8379E",
             0x00C3: "MPC8379",
             0x00C4: "MPC8378E",
             0x00C5: "MPC8378",
             0x00C6: "MPC8377E",
             0x00C7: "MPC8377",
             0x0100: "P1020E",
             0x0101: "P1020",
             0x0102: "P1021E",
             0x0103: "P1021",
             0x0108: "P1011E",
             0x0109: "P1011",
             0x010A: "P1012E",
             0x010B: "P1012",
             0x0110: "P1022E",
             0x0111: "P1022",
             0x0118: "P1013E",
             0x0119: "P1013",
             0x0128: "P1010",
             0x0400: "P4080E",
             0x0401: "P4080",
             0x0408: "P4040E",
             0x0409: "P4040",
             0x041F: "P3041",
             0x0440: "T4240 with security",
             0x0441: "T4240 without security",
             0x0446: "T4160 with security",
             0x0447: "T4160 without security",
             0x0830: "T2080 with security",
             0x0831: "T2080 without security",
             0x0838: "T2081 with security",
             0x0839: "T2081 without security",
             0x580C: "MPC5121e",
             0x7010: "MPC8641 PCI Host Bridge",
             0x7011: "MPC8641D PCI Host Bridge",
             0x7018: "MPC8610",
             0xC006: "MPC8308",
             0xFC02: "RedStone",
             0xFC03: "CFI",
             },

    # PA Semi, Inc
    0x1959: {0xA000: "PA6T Core",
             0xA001: "PWRficient Host Bridge",
             0xA002: "PWRficient PCI-Express Port",
             0xA003: "PWRficient SMBus Controller",
             0xA004: "PWRficient 16550 UART",
             0xA005: "PWRficient Gigabit Ethernet",
             0xA006: "PWRficient 10-Gigabit Ethernet",
             0xA007: "PWRficient DMA Controller",
             0xA008: "PWRficient LPC/Localbus Interface",
             0xA009: "PWRficient L2 Cache",
             0xA00A: "PWRficient DDR2 Memory Controller",
             0xA00B: "PWRficient SERDES",
             0xA00C: "PWRficient System/Debug Controller",
             0xA00D: "PWRficient PCI-Express Internal Endpoint",
             },

    # Orad Hi-Tec Systems
    0x1966: {0x1975: "DVG64 family",
             0x1977: "DVG128 family",
             0x1979: "3DVG/UHD3",
             0x1980: "HDV2/UHD2",
             },

    # Qualcomm Atheros
    0x1969: {0x1026: "AR8121/AR8113/AR8114 Gigabit or Fast Ethernet",
             0x1048: "Attansic L1 Gigabit Ethernet",
             0x1062: "AR8132 Fast Ethernet",
             0x1063: "AR8131 Gigabit Ethernet",
             0x1066: "Attansic L2c Gigabit Ethernet",
             0x1067: "Attansic L1c Gigabit Ethernet",
             0x1073: "AR8151 v1.0 Gigabit Ethernet",
             0x1083: "AR8151 v2.0 Gigabit Ethernet",
             0x1090: "AR8162 Fast Ethernet",
             0x1091: "AR8161 Gigabit Ethernet",
             0x10A0: "QCA8172 Fast Ethernet",
             0x10A1: "QCA8171 Gigabit Ethernet",
             0x2048: "Attansic L2 Fast Ethernet",
             0x2060: "AR8152 v1.1 Fast Ethernet",
             0x2062: "AR8152 v2.0 Fast Ethernet",
             0xE091: "Killer E220x Gigabit Ethernet Controller",
             0xE0A1: "Killer E2400 Gigabit Ethernet Controller",
             0xE0B1: "Killer E2500 Gigabit Ethernet Controller",
             },

    # Sensory Networks Inc.
    0x196A: {0x0101: "NodalCore C-1000 Content Classification Accelerator",
             0x0102: "NodalCore C-2000 Content Classification Accelerator",
             0x0105: "NodalCore C-3000 Content Classification Accelerator",
             },

    # Star Electronics GmbH & Co. KG
    0x1974: {0x0009: "FlexCard PMC-II",
             0x0011: "FlexCard PMC-II Ethernet",
             0x0018: "FlexCard PXIe3",
             0x0019: "FlexCard PCIe3",
             0x001A: "FlexCard PXIe Ethernet",
             0x001B: "FlexCard PCIe Ethernet",
             },

    # JMicron Technology Corp.
    0x197B: {0x0250: "JMC250 PCI Express Gigabit Ethernet Controller",
             0x0260: "JMC260 PCI Express Fast Ethernet Controller",
             0x0368: "JMB368 IDE controller",
             0x0585: "JMB58x AHCI SATA controller",
             0x2360: "JMB360 AHCI Controller",
             0x2361: "JMB361 AHCI/IDE",
             0x2362: "JMB362 SATA Controller",
             0x2363: "JMB363 SATA/IDE Controller",
             0x2364: "JMB364 AHCI Controller",
             0x2365: "JMB365 AHCI/IDE",
             0x2366: "JMB366 AHCI/IDE",
             0x2368: "JMB368 IDE controller",
             0x2369: "JMB369 Serial ATA Controller",
             0x2380: "IEEE 1394 Host Controller",
             0x2381: "Standard SD Host Controller",
             0x2382: "SD/MMC Host Controller",
             0x2383: "MS Host Controller",
             0x2384: "xD Host Controller",
             0x2386: "Standard SD Host Controller",
             0x2387: "SD/MMC Host Controller",
             0x2388: "MS Host Controller",
             0x2389: "xD Host Controller",
             0x2391: "Standard SD Host Controller",
             0x2392: "SD/MMC Host Controller",
             0x2393: "MS Host Controller",
             0x2394: "xD Host Controller",
             },

    # Distant Early Warning Communications Inc
    0x1982: {0x1600: "OX16C954 HOST-A",
             0x16FF: "OX16C954 HOST-B",
             },

    # Phison Electronics Corporation
    0x1987: {0x5007: "E7 NVMe Controller",
             0x5012: "E12 NVMe Controller",
             0x5013: "PS5013 E13 NVMe Controller",
             0x5016: "E16 PCIe4 NVMe Controller",
             0x5018: "E18 PCIe4 NVMe Controller",
             },

    # Montilio Inc.
    0x1989: {0x0001: "RapidFile Bridge",
             0x8001: "RapidFile",
             },

    # Xsigo Systems
    0x199D: {0x8209: "Virtual NIC Device",
             0x890A: "Virtual HBA Device",
             },

    # Auvitek
    0x199F: {0x8501: "AU85X1 PCI REV1.1",
             0x8521: "AU8521 TV card",
             },

    # Emulex Corporation
    0x19A2: {0x0120: "x1 PCIe Gen2 Bridge[Pilot4]",
             0x0200: "BladeEngine 10Gb PCI-E iSCSI adapter",
             0x0201: "BladeEngine 10Gb PCIe Network Adapter",
             0x0211: "BladeEngine2 10Gb Gen2 PCIe Network Adapter",
             0x0212: "BladeEngine2 10Gb Gen2 PCIe iSCSI Adapter",
             0x0221: "BladeEngine3 10Gb Gen2 PCIe Network Adapter",
             0x0222: "BladeEngine3 10Gb Gen2 PCIe iSCSI Adapter",
             0x0700: "OneConnect OCe10100/OCe10102 Series 10 GbE",
             0x0702: "OneConnect 10Gb iSCSI Initiator",
             0x0704: "OneConnect OCe10100/OCe10102 Series 10 GbE CNA",
             0x0710: "OneConnect 10Gb NIC (be3)",
             0x0712: "OneConnect 10Gb iSCSI Initiator (be3)",
             0x0714: "OneConnect 10Gb FCoE Initiator (be3)",
             0x0800: "ServerView iRMC HTI",
             },

    # Progeny Systems Corporation
    0x19AE: {0x0520: "4135 HFT Interface Controller",
             0x0521: "Decimator",
             },

    # DDRdrive LLC
    0x19E3: {0x5801: "DDRdrive X1",
             0x5808: "DDRdrive X8",
             0xDD52: "DDRdrive X1-30",
             },

    # Huawei Technologies Co., Ltd.
    0x19E5: {0x0123: "ES3000 V3 NVMe PCIe SSD",
             0x0200: "Hi1822 Family (2*100GE)",
             0x0202: "Hi1822 Family (2*32G FC)",
             0x0203: "Hi1822 Family (2*16G FC)",
             0x0205: "Hi1822 Family (2*100GE)",
             0x0206: "Hi1822 Family (2*25GE)",
             0x0210: "Hi1822 Family (4*25GE)",
             0x0211: "Hi1822 Family (4*25GE)",
             0x0212: "Hi1822 Family (2*8G FC)",
             0x0222: "Hi1822 Family",
             0x1710: "iBMA Virtual Network Adapter",
             0x1711: "Hi171x Series [iBMC Intelligent Management system chip w/VGA support]",
             0x1822: "Hi1822 Family (4*25GE)",
             0x3714: "ES3000 V5 NVMe PCIe SSD",
             0x371E: "Hi1822 Family Virtual Bridge",
             0x3754: "ES3000 V6 NVMe PCIe SSD",
             0x375E: "Hi1822 Family Virtual Function",
             0x375F: "Hi1822 Family Virtual Function",
             0x379E: "Hi1822 Family Virtual Function",
             0x379F: "Hi1822 Family Virtual Function",
             0xA120: "HiSilicon PCIe Root Port with Gen4",
             0xA121: "HiSilicon PCI-PCI Bridge",
             0xA122: "HiSilicon Embedded DMA Engine",
             0xA124: "HiSilicon Internal SDI Function Engine",
             0xA125: "HiSilicon SDI Network Controller",
             0xA126: "HiSilicon SDI NVMe Storage Controller",
             0xA127: "HiSilicon SDI Accelerator",
             0xA12A: "HiSilicon Add-on PCI-PCI Bridge",
             0xA220: "HNS GE Network Controller",
             0xA221: "HNS GE/10GE/25GE Network Controller",
             0xA222: "HNS GE/10GE/25GE RDMA Network Controller",
             0xA224: "HNS GE/10GE/25GE/50GE RDMA Network Controller",
             0xA226: "HNS GE/10GE/25GE/50GE/100GE RDMA Network Controller",
             0xA22A: "HiSilicon Network For SDI",
             0xA22E: "HNS Network Controller (Virtual Function)",
             0xA22F: "HNS RDMA Network Controller (Virtual Function)",
             0xA230: "HiSilicon SAS 3.0 HBA",
             0xA235: "HiSilicon AHCI HBA",
             0xA238: "HiSilicon USB 3.0 Host Controller",
             0xA239: "HiSilicon USB 2.0 2-port Host Controller",
             0xA23A: "HiSilicon USB 2.0 Host Controller",
             0xA23B: "HiSilicon USB 1.1 Host Controller",
             0xA250: "HiSilicon ZIP Engine",
             0xA251: "HiSilicon ZIP Engine(Virtual Function)",
             0xA255: "HiSilicon SEC Engine",
             0xA256: "HiSilicon SEC Engine(Virtual Function)",
             0xA258: "HiSilicon HPRE Engine",
             0xA259: "HiSilicon HPRE Engine(Virtual Function)",
             0xA25A: "HiSilicon RDE Engine",
             0xA25B: "HiSilicon RDE Engine(Virtual Function)",
             },

    # NET (Network Equipment Technologies)
    0x19E7: {0x1001: "STIX DSP Card",
             0x1002: "STIX - 1 Port T1/E1 Card",
             0x1003: "STIX - 2 Port T1/E1 Card",
             0x1004: "STIX - 4 Port T1/E1 Card",
             0x1005: "STIX - 4 Port FXS Card",
             },

    # ASPEED Technology, Inc.
    0x1A03: {0x1150: "AST1150 PCI-to-PCI Bridge",
             0x2000: "ASPEED Graphics Family",
             },

    # Kvaser AB
    0x1A07: {0x0006: "CAN interface PC104+ HS/HS",
             0x0007: "CAN interface PCIcanx II HS or HS/HS",
             0x0008: "CAN interface PCIEcan HS or HS/HS",
             0x0009: "CAN interface PCI104 HS/HS",
             },

    # Fortinet, Inc.
    0x1A29: {0x4338: "CP8 Content Processor ASIC",
             0x43A0: "CP9 Content Processor ASIC",
             0x4E36: "NP6 Network Processor",
             0x4E37: "NP7 Network Processor",
             },

    # Ascom AG
    0x1A2B: {0x0000: "GESP v1.2",
             0x0001: "GESP v1.3",
             0x0002: "ECOMP v1.3",
             0x0005: "ETP v1.4",
             0x000A: "ETP-104 v1.1",
             0x000E: "DSLP-104 v1.1",
             },

    # Lantiq
    0x1A30: {0x0680: "MtW8171 [Hyperion II]",
             0x0700: "Wave300 PSB8224 [Hyperion III]",
             0x0710: "Wave300 PSB8231 [Hyperion III]",
             },

    # Tilera Corp.
    0x1A41: {0x0001: "TILE64 processor",
             0x0002: "TILEPro processor",
             0x0200: "TILE-Gx processor",
             0x0201: "TILE-Gx Processor Virtual Function",
             0x2000: "TILE-Gx PCI Express Root Port",
             },

    # SLAC National Accelerator Lab TID-AIR
    0x1A4A: {0x1000: "MCOR Power Supply Controller",
             0x1010: "AMC EVR - Stockholm Timing Board",
             0x1020: "PGPCard - Gen3 Cameralink Interface",
             0x1030: "PGPCard - Gen3 GIGe Interface",
             0x2000: "PGPCard - 4 Lane",
             0x2001: "PGPCard - 8 Lane Plus EVR",
             0x2010: "PCI-Express EVR",
             0x2011: "PCI-Express EVR - TPR Version",
             0x2020: "PGP-GEN3 PCIe - 8 Lane Plus EVR",
             0x2030: "AXI Stream DAQ PCIe card",
             0x2040: "EXO PCIe TEM",
             0x3000: "COB DTM V1",
             0x3001: "COB DTM V2",
             },

    # Rohde & Schwarz DVS GmbH
    0x1A55: {0x0010: "SDStationOEM",
             0x0011: "SDStationOEM II",
             0x0020: "Centaurus",
             0x0021: "Centaurus II",
             0x0022: "Centaurus II LT",
             0x0030: "CLIPSTER-VPU 1.x (Hugo)",
             0x0040: "Hydra Cinema (JPEG)",
             0x0050: "CLIPSTER-VPU 2.x (DigiLab)",
             0x0060: "CLIPSTER-DCI 2.x (HydraX)",
             0x0061: "Atomix",
             0x0062: "Atomix LT",
             0x0063: "Atomix HDMI",
             0x0064: "Atomix STAN",
             0x0065: "Atomix HDMI STAN",
             0x0070: "RED Rocket",
             0x0090: "CinePlay",
             },

    # Virident Systems Inc.
    0x1A78: {0x0031: "FlashMAX Drive",
             0x0040: "FlashMAX II",
             0x0041: "FlashMAX II",
             0x0042: "FlashMAX II",
             0x0050: "FlashMAX III",
             },

    # Ciprico, Inc.
    0x1AA8: {0x0009: "RAIDCore Controller",
             0x000A: "RAIDCore Controller",
             },

    # Schweitzer Engineering Laboratories
    0x1AA9: {0x000D: "SEL-3390S8 Serial Adapter",
             0x000E: "SEL-3390E4 Ethernet Adapter",
             0x0014: "SEL-3390T Time and Ethernet Adapter",
             0x0015: "SEL-3350 Mainboard",
             0x0016: "SEL-3350 Serial Expansion Board",
             0x0017: "SEL-3350 GPIO Expansion Board",
             0x0018: "SEL-3390E4 Ethernet Adapter",
             0x001C: "SEL-3390E4 Ethernet Adapter",
             },

    # Parallels, Inc.
    0x1AB8: {0x4000: "Virtual Machine Communication Interface",
             0x4005: "Accelerated Virtual Video Adapter",
             0x4006: "Memory Ballooning Controller",
             },

    # Spectracom Corporation
    0x1AD7: {0x8000: "TSync-PCIe Time Code Processor",
             0x9100: "TPRO-PCI-66U Timecode Reader/Generator",
             },

    # Spin Master Ltd.
    0x1ADE: {0x1501: "Swipetech barcode scanner",
             0x3038: "PCIe Video Bridge",
             },

    # Google, Inc.
    0x1AE0: {0x001F: "NVMe device",
             0x0042: "Compute Engine Virtual Ethernet [gVNIC]",
             0xABCD: "Airbrush Combined Paintbox IPU/Oscar Edge TPU [Pixel Neural Core]",
             },

    # Basler AG
    0x1AE8: {0x0751: "mE5 marathon VCL",
             0x0752: "mE5 marathon AF2",
             0x0753: "mE5 marathon ACX QP",
             0x0754: "mE5 marathon ACL",
             0x0755: "mE5 marathon ACX SP",
             0x0756: "mE5 marathon ACX DP",
             0x0757: "mE5 marathon VCX QP",
             0x0758: "mE5 marathon VF2",
             0x0759: "mE5 marathon VCLx",
             0x0A40: "microEnable IV AD1-CL",
             0x0A41: "microEnable IV VD1-CL",
             0x0A42: "microEnable IV AD4-CL",
             0x0A44: "microEnable IV VD4-CL",
             0x0A45: "microEnable IV AS1-CL",
             0x0A53: "microEnable 5 AQ8-CXP6B",
             0x0A54: "microEnable 5 VQ8-CXP6B",
             0x0A56: "microEnable 5 VQ8-CXP6D",
             0x0A57: "microEnable 5 AQ8-CXP6D",
             0x0A58: "microEnable 5 VD8-CL",
             0x0A5A: "microEnable 5 AD8-CL",
             0x0A64: "imaWorx CXP-12 Quad",
             0x0B52: "mE5 Abacus 4G Base",
             0x0B53: "mE5 Abacus 4G Base II",
             0x0B61: "mE6 Abacus 4TG",
             0x0B63: "CXP-12 Interface Card 1C",
             0x0B64: "CXP-12 Interface Card 4C",
             0x0B65: "CXP-12 Interface Card 2C",
             0x0B66: "CXP-12 LightBridge 2C",
             0x0E42: "microEnable IV AQ4-GE",
             0x0E44: "microEnable IV VQ4-GE",
             },

    # Wilocity Ltd.
    0x1AE9: {0x0101: "Wil6200 PCI Express Upstream Port",
             0x0200: "Wil6200 PCI Express Port",
             0x0201: "Wil6200 Wireless PCI Express Port",
             0x0301: "Wil6200 802.11ad Wireless Network Adapter",
             0x0302: "Wil6200 802.11ad Wireless Network Adapter",
             0x0310: "Wil6200 802.11ad Wireless Network Adapter",
             },

    # Alcor Micro
    0x1AEA: {0x6601: "AU6601 PCI-E Flash card reader controller",
             0x6621: "AU6621 PCI-E Flash card reader controller",
             0x6625: "AU6625 PCI-E Flash card reader controller",
             },

    # SanDisk
    0x1AED: {0x1003: "ioDimm3 (v1.2)",
             0x1005: "ioDimm3",
             0x1006: "ioXtreme",
             0x1007: "ioXtreme Pro",
             0x1008: "ioXtreme-2",
             0x2001: "ioDrive2",
             0x3001: "ioMemory FHHL",
             0x3002: "ioMemory HHHL",
             0x3003: "ioMemory Mezzanine",
             },

    # Red Hat, Inc.
    0x1AF4: {0x1000: "Virtio network device",
             0x1001: "Virtio block device",
             0x1002: "Virtio memory balloon",
             0x1003: "Virtio console",
             0x1004: "Virtio SCSI",
             0x1005: "Virtio RNG",
             0x1009: "Virtio filesystem",
             0x1041: "Virtio network device",
             0x1042: "Virtio block device",
             0x1043: "Virtio console",
             0x1044: "Virtio RNG",
             0x1045: "Virtio memory balloon",
             0x1048: "Virtio SCSI",
             0x1049: "Virtio filesystem",
             0x1050: "Virtio GPU",
             0x1052: "Virtio input",
             0x1053: "Virtio socket",
             0x105A: "Virtio file system",
             0x1110: "Inter-VM shared memory",
             },

    # Magnum Semiconductor, Inc,
    0x1B03: {0x6100: "DXT/DXTPro Multiformat Broadcast HD/SD Encoder/Decoder/Transcoder",
             0x7000: "D7 Multiformat Broadcast HD/SD Encoder/Decoder/Transcoder",
             },

    # ASMedia Technology Inc.
    0x1B21: {0x0611: "ASM1061 SATA IDE Controller",
             0x0612: "ASM1062 Serial ATA Controller",
             0x0625: "106x SATA/RAID Controller",
             0x1040: "ASM1040 XHCI Controller",
             0x1042: "ASM1042 SuperSpeed USB Host Controller",
             0x1080: "ASM1083/1085 PCIe to PCI Bridge",
             0x1142: "ASM1042A USB 3.0 Host Controller",
             0x1166: "ASM1166 Serial ATA Controller",
             0x1182: "ASM1182e 2-Port PCIe x1 Gen2 Packet Switch",
             0x1184: "ASM1184e 4-Port PCIe x1 Gen2 Packet Switch",
             0x1187: "ASM1187e 7-Port PCIe x1 Gen2 Packet Switch",
             0x1242: "ASM1142 USB 3.1 Host Controller",
             0x1343: "ASM1143 USB 3.1 Host Controller",
             0x1812: "ASM1812 6-Port PCIe x4 Gen2 Packet Switch",
             0x2142: "ASM2142/ASM3142 USB 3.1 Host Controller",
             0x2824: "ASM2824 PCIe Gen3 Packet Switch",
             0x3242: "ASM3242 USB 3.2 Host Controller",
             },

    # Netcope Technologies, a.s.
    0x1B26: {0xC132: "COMBO-LXT155",
             0xC1C0: "NFB-100G1-e0",
             0xC1C1: "NFB-100G1-e1",
             0xC250: "NFB-200G2-master",
             0xC251: "NFB-200G2-slave",
             0xC2C0: "NFB-100G2-e0",
             0xC2C1: "NFB-100G2-e1",
             0xCB20: "COMBO-20G",
             0xCB40: "COMBO-40G",
             0xCB80: "NFB-40G2",
             },

    # Red Hat, Inc.
    0x1B36: {0x0001: "QEMU PCI-PCI bridge",
             0x0002: "QEMU PCI 16550A Adapter",
             0x0003: "QEMU PCI Dual-port 16550A Adapter",
             0x0004: "QEMU PCI Quad-port 16550A Adapter",
             0x0005: "QEMU PCI Test Device",
             0x0006: "PCI Rocker Ethernet switch device",
             0x0007: "PCI SD Card Host Controller Interface",
             0x0008: "QEMU PCIe Host bridge",
             0x0009: "QEMU PCI Expander bridge",
             0x000A: "PCI-PCI bridge (multiseat)",
             0x000B: "QEMU PCIe Expander bridge",
             0x000C: "QEMU PCIe Root port",
             0x000D: "QEMU XHCI Host Controller",
             0x0010: "QEMU NVM Express Controller",
             0x0100: "QXL paravirtual graphic card",
             },

    # Signal Processing Devices Sweden AB
    0x1B37: {0x0001: "ADQ214",
             0x0003: "ADQ114",
             0x0005: "ADQ112",
             0x000E: "ADQ108",
             0x000F: "ADQDSP",
             0x0014: "ADQ412",
             0x0015: "ADQ212",
             0x001B: "SDR14",
             0x001C: "ADQ1600",
             0x001E: "ADQ208",
             0x001F: "DSU",
             0x0020: "ADQ14",
             0x0023: "ADQ7",
             0x0026: "ADQ8",
             0x2014: "TX320",
             0x2019: "S6000",
             },

    # Numascale AS
    0x1B47: {0x0601: "NumaChip N601",
             0x0602: "NumaChip N602",
             },

    # Marvell Technology Group Ltd.
    0x1B4B: {0x0100: "88F3700 [Armada 3700 Family] ARM SoC",
             0x0640: "88SE9128 SATA III 6Gb/s RAID Controller",
             0x2241: "88NR2241 Non-Volatile memory controller",
             0x9120: "88SE9120 SATA 6Gb/s Controller",
             0x9123: "88SE9123 PCIe SATA 6.0 Gb/s controller",
             0x9125: "88SE9125 PCIe SATA 6.0 Gb/s controller",
             0x9128: "88SE9128 PCIe SATA 6 Gb/s RAID controller",
             0x9130: "88SE9128 PCIe SATA 6 Gb/s RAID controller with HyperDuo",
             0x9170: "88SE9170 PCIe 2.0 x1 2-port SATA 6 Gb/s Controller",
             0x9172: "88SE9172 SATA 6Gb/s Controller",
             0x9178: "88SE9170 PCIe SATA 6Gb/s Controller",
             0x917A: "88SE9172 SATA III 6Gb/s RAID Controller",
             0x9182: "88SE9182 PCIe 2.0 x2 2-port SATA 6 Gb/s Controller",
             0x9183: "88SS9183 PCIe SSD Controller",
             0x9192: "88SE9172 SATA III 6Gb/s RAID Controller",
             0x91A0: "88SE912x SATA 6Gb/s Controller [IDE mode]",
             0x91A4: "88SE912x IDE Controller",
             0x9215: "88SE9215 PCIe 2.0 x1 4-port SATA 6 Gb/s Controller",
             0x9220: "88SE9220 PCIe 2.0 x2 2-port SATA 6 Gb/s RAID Controller",
             0x9230: "88SE9230 PCIe 2.0 x2 4-port SATA 6 Gb/s RAID Controller",
             0x9235: "88SE9235 PCIe 2.0 x2 4-port SATA 6 Gb/s Controller",
             0x9445: "88SE9445 PCIe 2.0 x4 4-Port SAS/SATA 6 Gbps RAID Controller",
             0x9480: "88SE9480 SAS/SATA 6Gb/s RAID controller",
             0x9485: "88SE9485 SAS/SATA 6Gb/s controller",
             },

    # NetUP Inc.
    0x1B55: {0x18F6: "Dual DVB Universal CI card",
             0x18F7: "Dual DVB Universal CI card rev 1.4",
             0x2A2C: "Dual DVB-S2-CI card",
             0xE2E4: "Dual DVB-T/C-CI RF card",
             0xE5F4: "MPEG2 and H264 Encoder-Transcoder",
             0xF1C4: "Dual ASI-RX/TX-CI card",
             },

    # Etron Technology, Inc.
    0x1B6F: {0x7023: "EJ168 USB 3.0 Host Controller",
             0x7052: "EJ188/EJ198 USB 3.0 Host Controller",
             },

    # Fresco Logic
    0x1B73: {0x1000: "FL1000G USB 3.0 Host Controller",
             0x1009: "FL1009 USB 3.0 Host Controller",
             0x1100: "FL1100 USB 3.0 Host Controller",
             },

    # OpenVox Communication Co. Ltd.
    0x1B74: {0x0115: "D115P/D115E Single-port E1/T1 card",
             0xD130: "D130P/D130E Single-port E1/T1 card (3rd GEN)",
             0xD210: "D210P/D210E Dual-port E1/T1 card(2nd generation)",
             0xD230: "D230 Dual-port E1/T1 card (2nd generation)",
             0xD410: "D410/430 Quad-port E1/T1 card",
             0xD430: "D410/430 Quad-port E1/T1 card",
             },

    # OCZ Technology Group, Inc.
    0x1B85: {0x1041: "RevoDrive 3 X2 PCI-Express SSD 240 GB (Marvell Controller)",
             0x6018: "RD400/400A SSD",
             0x8788: "RevoDrive Hybrid",
             },

    # Western Digital
    0x1B96: {0x2200: "Ultrastar DC SN630 NVMe SSD",
             0x2201: "Ultrastar DC SN630 NVMe SSD",
             0x2300: "Ultrastar DC SN840 NVMe SSD",
             0x2400: "Ultrastar DC SN640 NVMe SSD",
             0x2401: "Ultrastar DC SN640 NVMe SSD",
             0x2402: "Ultrastar DC SN640 NVMe SSD",
             0x2404: "Ultrastar DC SN640 NVMe SSD",
             0x2500: "Ultrastar DC SN840 NVMe SSD",
             0x2600: "Ultrastar DC ZN540 ZNS NVMe SSD",
             0x3714: "PC SN730 NVMe SSD",
             0x3734: "PC SN730 NVMe SSD",
             },

    # ReFLEX CES
    0x1BAD: {0xC001: "XpressGXA10-LP1150",
             0xC002: "XpressGXA10-LP1151",
             },

    # SimpliVity Corporation
    0x1BB0: {0x0002: "OmniCube Accelerator OA-3000",
             0x0010: "OmniCube Accelerator OA-3000-2",
             },

    # Seagate Technology PLC
    0x1BB1: {0x005D: "Nytro PCIe Flash Storage",
             0x0100: "Nytro Flash Storage",
             0x5012: "FireCuda 510 SSD",
             0x5016: "FireCuda 520 SSD",
             0x5018: "FireCuda 530 SSD",
             },

    # Bluecherry
    0x1BB3: {0x4304: "BC-04120A MPEG4 4 port video encoder / decoder",
             0x4309: "BC-08240A MPEG4 4 port video encoder / decoder",
             0x4310: "BC-16480A MPEG4 16 port video encoder / decoder",
             0x4E04: "BC-04120A 4 port MPEG4 video encoder / decoder",
             0x4E09: "BC-08240A 8 port MPEG4 video encoder / decoder",
             0x4E10: "BC-16480A 16 port MPEG4 video encoder / decoder",
             0x5304: "BC-H04120A 4 port H.264 video and audio encoder / decoder",
             0x5308: "BC-H08240A 8 port H.264 video and audio encoder / decoder",
             0x5310: "BC-H16480A 16 port H.264 video and audio encoder / decoder",
             },

    # Maxeler Technologies Ltd.
    0x1BBF: {0x0003: "MAX3",
             0x0004: "MAX4",
             },

    # Innodisk Corporation
    0x1BC0: {0x1001: "PCIe 3TG6-P Controller",
             0x1002: "PCIe 3TE6 Controller",
             0x1160: "PCIe 3TE2 Controller",
             0x1321: "PCIe 4TG-P Controller",
             0x1322: "PCIe 4TE Controller",
             0x2262: "PCIe 3TG3-P Controller",
             0x5208: "PCIe 3TE7 Controller",
             0x5216: "PCIe 3TE8 Controller",
             0x5236: "PCIe 4TG2-P Controller",
             },

    # Astronics Corporation
    0x1BD0: {0x1001: "Mx5 PMC/XMC Databus Interface Card",
             0x1002: "PM1553-5 (PC/104+ MIL-STD-1553 Interface Card)",
             0x1004: "AB3000 Series Rugged Computer",
             0x1005: "PE1000 (Multi-Protocol PCIe/104 Interface Card)",
             0x1006: "webCS Wireless Aircraft Communications Server",
             0x1007: "AB3000 Series Rugged Computer (Series N)",
             0x1008: "ME1000 mPCIe Avionics Interface Card",
             0x100A: "NG1 Series Avionics Converter",
             0x100B: "LE5 429 Databus Interface Card",
             0x100C: "LE5 1553 Databus Interface Card",
             0x1101: "OmniBus II PCIe Multi-Protocol Interface Card",
             0x1102: "OmniBusBox II Multi-Protocol Interface Core",
             0x1103: "OmniBus II cPCIe/PXIe Multi-Protocol Interface Card",
             0x1200: "NG3 Series Mil-Std-1553 Interface",
             0x1201: "NG3 Series ARINC 429 Interface",
             0x1202: "NG3 Series Avionics Discrete & Serial Interface",
             0x1203: "NG3 Series Avionics Discrete Interface",
             },

    # VTI Instruments Corporation
    0x1BF4: {0x0001: "SentinelEX",
             0x7011: "RX0xxx",
             },

    # CSP, Inc.
    0x1C09: {0x4254: "10G-PCIE3-8D-2S",
             0x4255: "10G-PCIE3-8D-Q",
             0x4256: "10G-PCIE3-8D-2S",
             0x4258: "10G-PCIE3-8E-2S Network Adapter",
             0x4260: "10G-PCIE3-8E-4S Network Adapter",
             0x4261: "10G-PCIE3-8E-4S Network Adapter",
             0x4262: "10G-PCIE3-8E-4S Network Adapter",
             0x4263: "10G-PCIE3-8E-4S Network Adapter",
             0x4264: "10G-PCIE3-8E-2S Network Adapter",
             0x4265: "10G-PCIE3-8E-2S Network Adapter",
             0x5000: "25G-PCIE3-8A-2S Security Intelligent Adapter",
             0x5001: "25G-PCIE3-8B-2S Security Intelligent Adapter",
             },

    # SoftLab-NSK
    0x1C1F: {0x0015: "FD842",
             0x0019: "FD722",
             0x001A: "FD788",
             0x001B: "FD720",
             0x001C: "FD922",
             0x001D: "Vega",
             0x001F: "FD940",
             0x0020: "FD2110",
             },

    # Silicom Denmark
    0x1C2C: {0x000A: "Capture",
             0x000F: "SmartNIC",
             0x00A0: "FBC4G Capture 4x1Gb [Herculaneum]",
             0x00A1: "FBC4XG Capture 4x10Gb [Ancona]",
             0x00A2: "FBC8XG Capture 8x10Gb [Livorno]",
             0x00A3: "FBC2XG Capture 2x10Gb [Genoa]",
             0x00A4: "FBC4XGG3 Capture 4x10Gb [Livigno]",
             0x00A5: "FBC2XLG Capture 2x40Gb [Livorno]",
             0x00A6: "FBC1CG Capture 1x100Gb",
             0x00A9: "FBC2XGHH Capture 2x10Gb [Latina]",
             0x00AD: "FBC2CGG3HL Capture 2x100Gb [Padua]",
             0x00AF: "Capture slave device",
             0x00E0: "PacketMover 2x100Gb [Savona]",
             0x00E1: "PacketMover 2x100Gb [Tivoli]",
             0x00E3: "PacketMover 2x10Gb [Tivoli]",
             0x00E5: "PacketMover 2x10Gb [Corfu]",
             0x1000: "SmartNIC N5010 4x100Gb",
             0x1001: "SmartNIC N5011 w/2xE810 4x100Gb",
             0x1002: "SmartNIC N5013 4x100Gb",
             0x1003: "SmartNIC N5014 w/2xE810 4x100Gb",
             0xA000: "FBC2CGG3 Capture 2x40Gb [Mango_02]",
             0xA001: "FBC2CGG3 Capture 2x100Gb [Mango_02]",
             0xA003: "FBC2CGG3 Capture 16x10Gb [Mango]",
             0xA007: "FBC2CGG3 Capture 2x40Gb [Mango]",
             0xA008: "FBC2CGG3 Capture 2x25Gb [Mango]",
             0xA009: "FBC2CGG3 Capture 16x10Gb [Mango]",
             0xA00A: "FBC2CGG3 Capture 8x10Gb [Mango]",
             0xA00E: "FB2CG Capture 2x100Gb [Savona]",
             0xA00F: "FB2CG Capture 2x40Gb [Savona]",
             0xA010: "FB2CGHH Capture 2x40Gb [Tivoli]",
             0xA011: "FB2CG Capture 2x25Gb [Savona]",
             0xA012: "FB2CG Capture 8x10Gb [Savona]",
             0xA013: "FB2CGHH Capture 2x25Gb [Tivoli]",
             0xA014: "FB2CGHH Capture 8x10Gb [Tivoli]",
             0xA015: "FB2CGHH Capture 2x100Gb [Tivoli]",
             },

    # Annapurna Labs Ltd.
    0x1C36: {0x0001: "Gigabit Ethernet Adapter",
             0x0002: "SFP+ 10G Ethernet Adapter",
             },

    # Accensus, LLC
    0x1C3B: {0x0200: "Telas2",
             0x0300: "Telas 2.V",
             },

    # HGST, Inc.
    0x1C58: {0x0003: "Ultrastar SN100 Series NVMe SSD",
             0x0023: "Ultrastar SN200 Series NVMe SSD",
             },

    # SK hynix
    0x1C5C: {0x1283: "PC300 NVMe Solid State Drive 256GB",
             0x1284: "PC300 NVMe Solid State Drive 512GB",
             0x1285: "PC300 NVMe Solid State Drive 1TB",
             0x1327: "BC501 NVMe Solid State Drive",
             0x1339: "BC511",
             0x1504: "PC400 NVMe SSD",
             0x1527: "PC401 NVMe Solid State Drive 256GB",
             0x174A: "Gold P31/PC711 NVMe Solid State Drive",
             0x1959: "Platinum P41 NVMe Solid State Drive 2TB",
             0x2204: "960GB TLC PCIe Gen3 x4 NVMe M.2 22110",
             0x243B: "PE6110 NVMe Solid State Drive",
             0x2839: "PE8000 Series NVMe Solid State Drive",
             0x2849: "PE81x0 U.2/3 NVMe Solid State Drive",
             },

    # Beijing Memblaze Technology Co. Ltd.
    0x1C5F: {0x000D: "PBlaze5 520/526",
             0x000E: "PBlaze6 6530/6531/6541/6630",
             0x003D: "PBlaze5 920/926",
             0x003E: "PBlaze6 6920/6930",
             0x003F: "PBlaze7 7940/7946",
             0x0540: "PBlaze4 NVMe SSD",
             0x0550: "PBlaze5 700/900",
             0x0555: "PBlaze5 510/516",
             0x0557: "PBlaze5 910/916",
             },

    # Shannon Systems
    0x1CB0: {0x8266: "SP4 Series SSD",
             0xD000: "Venice NVMe SSD",
             },

    # ADATA Technology Co., Ltd.
    0x1CC1: {0x33F8: "IM2P33F8ABR1 NVMe SSD",
             0x5350: "XPG GAMMIX S50 NVMe SSD",
             0x5766: "ADATA XPG GAMMIXS1 1L Media",
             0x8201: "XPG SX8200 Pro PCIe Gen3x4 M.2 2280 Solid State Drive",
             },

    # Shenzhen Unionmemory Information System Ltd.
    0x1CC4: {0x1203: "NVMe SSD Controller UHXXXa series",
             0x17AB: "NVMe 256G SSD device",
             0x6303: "AM630 PCIe 4.0 x4 NVMe SSD Controller",
             },

    # Embedded Intelligence, Inc.
    0x1CC5: {0x0100: "PCIe-CAN-02 Dual CAN bus (9-pin male). PCI Express x1.",
             0x0101: "PCIe-CAN-01 Single CAN bus (9-pin male). PCI Express x1.",
             },

    # Radian Memory Systems Inc.
    0x1CC7: {0x0200: "RMS-200",
             0x0250: "RMS-250",
             },

    # SesKion GmbH
    0x1CD2: {0x0301: "Simulyzer-RT CompactPCI Serial DIO-1 card",
             0x0302: "Simulyzer-RT CompactPCI Serial PSI5-ECU-1 card",
             0x0303: "Simulyzer-RT CompactPCI Serial PSI5-SIM-1 card",
             0x0304: "Simulyzer-RT CompactPCI Serial PWR-ANA-1 card",
             0x0305: "Simulyzer-RT CompactPCI Serial CAN-1 card",
             0x0306: "Simulyzer-RT CompactPCI Serial CAN-2 card (CAN-FD)",
             0x0307: "Simulyzer-RT CompactPCI Serial DIO-2 card [Xilinx Zynq UltraScale+]",
             },

    # Nanjing Magewell Electronics Co., Ltd.
    0x1CD7: {0x0010: "Pro Capture Endpoint",
             0x0014: "PRO CAPTURE AIO 4K PLUS",
             0x0017: "PRO CAPTURE AIO 4K",
             0x0051: "Eco Capture Dual HDMI M.2",
             0x0052: "Eco Capture HDMI 4K M.2",
             0x0053: "Eco Capture Dual SDI M.2",
             0x0054: "Eco Capture Quad SDI M.2",
             },

    # Exablaze
    0x1CE4: {0x0001: "ExaNIC X4",
             0x0002: "ExaNIC X2",
             0x0003: "ExaNIC X10",
             0x0004: "ExaNIC X10-GM",
             0x0005: "ExaNIC X40",
             0x0006: "ExaNIC X10-HPT",
             0x0007: "ExaNIC X40",
             0x0008: "ExaNIC V5P",
             0x0009: "ExaNIC X25",
             0x000A: "ExaNIC X100",
             0x000B: "ExaNIC V9P",
             0x000C: "ExaNIC V9P-3",
             0x0100: "ExaDISK FX1",
             },

    # Amazon.com, Inc.
    0x1D0F: {0x7064: "NeuronDevice (Inferentia)",
             0x7164: "NeuronDevice (Trainium)",
             0x7264: "NeuronDevice (Inferentia2)",
             0x8061: "NVMe EBS Controller",
             0xCD01: "NVMe SSD Controller",
             0xEC20: "Elastic Network Adapter (ENA)",
             0xEFA0: "Elastic Fabric Adapter (EFA)",
             0xEFA1: "Elastic Fabric Adapter (EFA)",
             0xEFA2: "Elastic Fabric Adapter (EFA)",
             },

    # Zhaoxin
    0x1D17: {0x070F: "ZX-100 PCI Express Root Port",
             0x0710: "ZX-100/ZX-200 PCI Express Root Port",
             0x0711: "ZX-100/ZX-200 PCI Express Root Port",
             0x0712: "ZX-100/ZX-200 PCI Express Root Port",
             0x0713: "ZX-100/ZX-200 PCI Express Root Port",
             0x0714: "ZX-100/ZX-200 PCI Express Root Port",
             0x0715: "ZX-100/ZX-200 PCI Express Root Port",
             0x0716: "ZX-D PCI Express Root Port",
             0x0717: "KX-5000/KX-6000/KX-6000G Express Root Port",
             0x0718: "KX-5000/KX-6000/KX-6000G Express Root Port",
             0x0719: "KX-5000/KX-6000/KX-6000G Express Root Port",
             0x071A: "KX-5000/KX-6000/KX-6000G Express Root Port",
             0x071B: "KX-5000/KX-6000/KX-6000G Express Root Port",
             0x071C: "KX-5000/KX-6000/KX-6000G Express Root Port",
             0x071D: "KX-5000/KX-6000/KX-6000G Express Root Port",
             0x071E: "KX-5000/KX-6000/KX-6000G Express Root Port",
             0x071F: "ZX-200 Upstream Port of PCI Express Switch",
             0x0720: "ZX-200 PCIE RC6 controller",
             0x0721: "ZX-200 Downstream Port of PCI Express Switch",
             0x0722: "ZX-200 PCIE P2C bridge",
             0x1000: "ZX-D Standard Host Bridge",
             0x1001: "ZX-D/ZX-E Miscellaneous Bus",
             0x1003: "ZX-E Standard Host Bridge",
             0x1006: "KX-6000G Standard Host Bridge",
             0x3001: "ZX-100 Standard Host Bridge",
             0x300A: "ZX-100 Miscellaneous Bus",
             0x3038: "ZX-100/ZX-200/KX-6000/KX-6000G Standard Universal PCI to USB Host Controller",
             0x3104: "ZX-100/ZX-200/KX-6000/KX-6000G Standard Enhanced PCI to USB Host Controller",
             0x31B0: "ZX-100/KX-5000/KX-6000/KX-6000G Standard Host Bridge",
             0x31B1: "ZX-100/KX-5000/KX-6000/KX-6000G Standard Host Bridge",
             0x31B2: "ZX-100/KX-5000/KX-6000/KX-6000G DRAM Controller",
             0x31B3: "ZX-100/KX-5000/KX-6000/KX-6000G Power Management Controller",
             0x31B4: "ZX-100/KX-5000/KX-6000/KX-6000G I/O APIC",
             0x31B5: "ZX-100/KX-5000/KX-6000/KX-6000G Scratch Device",
             0x31B7: "ZX-100/KX-5000/KX-6000/KX-6000G Standard Host Bridge",
             0x31B8: "ZX-100/ZX-D PCI to PCI Bridge",
             0x3288: "ZX-100/KX-5000/KX-6000/KX-6000G High Definition Audio Controller",
             0x345B: "ZX-100/KX-5000/KX-6000/KX-6000G Miscellaneous Bus",
             0x3A02: "ZX-100 C-320 GPU",
             0x3A03: "ZX-D C-860 GPU",
             0x3A04: "ZX-E C-960 GPU",
             0x3C02: "KX-6000G DRAM Controller",
             0x3D01: "KX-6000G C-1080 GPU",
             0x9002: "ZX-100/ZX-200 EIDE Controller",
             0x9003: "ZX-100/KX-6000/KX-6000G EIDE Controller",
             0x9043: "KX-6000G RAID Controller",
             0x9045: "ZX-100/ZX-D/ZX-E RAID Accelerator 0",
             0x9046: "ZX-D/ZX-E RAID Accelerator 1",
             0x9083: "ZX-100/ZX-200/KX-6000/KX-6000G StorX AHCI Controller",
             0x9084: "ZX-100 StorX AHCI Controller",
             0x9100: "ZX-200 Cross bus",
             0x9101: "ZX-200 Traffic Controller",
             0x9141: "ZX-100 High Definition Audio Controller",
             0x9142: "ZX-D High Definition Audio Controller",
             0x9144: "ZX-E High Definition Audio Controller",
             0x9145: "KX-6000G High Definition Audio Controller",
             0x9180: "ZX-200 Networking Gigabit Ethernet Adapter",
             0x9202: "ZX-100 USB eXtensible Host Controller",
             0x9203: "ZX-200 USB eXtensible Host Controller",
             0x9204: "KX-6000/KX-6000G USB eXtensible Host Controller",
             0x9286: "ZX-D eMMC Host Controller",
             0x9300: "ZX-100/KX-5000/KX-6000/KX-6000G eSPI Host Controller",
             0x95D0: "ZX-100 Universal SD Host Controller",
             0xF410: "ZX-100/KX-5000/KX-6000/KX-6000G PCI Com Port",
             },

    # Barefoot Networks, Inc.
    0x1D1C: {0x0001: "Tofino 1",
             0x0010: "Tofino 1",
             0x0100: "Tofino 2",
             0x0110: "Tofino 2",
             },

    # CNEX Labs
    0x1D1D: {0x1F1F: "QEMU NVM Express LightNVM Controller",
             0x2807: "8800 series NVMe SSD",
             },

    # Baidu Technology
    0x1D22: {0x1380: "Cloud Storage Device",
             0x3684: "Kunlun AI Accelerator",
             0x3685: "Kunlun2 AI Accelerator [VF]",
             },

    # Kalray Inc.
    0x1D26: {0x0040: "Turbocard2 Accelerator",
             0x0080: "Open Network Interface Card 80G",
             0x00C0: "Turbocard3 Accelerator",
             0x0140: "Open Network Interface Card 40G",
             0xE004: "AB01/EMB01 Development Board",
             },

    # NovaSparks
    0x1D37: {0x0013: "PM3",
             0x0014: "PM4",
             0x0015: "PM4edge",
             0x0016: "PM4edge User Device",
             },

    # Celeno Communications
    0x1D69: {0x2432: "CL2432",
             0x2440: "CL2440",
             },

    # Aquantia Corp.
    0x1D6A: {0x0001: "AQC107 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]",
             0x00B1: "AQC100 10G Ethernet MAC controller [AQtion]",
             0x07B1: "AQC107 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]",
             0x08B1: "AQC108 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]",
             0x11B1: "AQC111 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]",
             0x12B1: "AQC112 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]",
             0x87B1: "AQC107 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]",
             0x94C0: "AQC113CS NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]",
             0xD107: "AQC107 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]",
             0xD108: "AQC108 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]",
             },

    # Atomic Rules LLC
    0x1D6C: {0x1001: "A5PL-E1",
             0x1002: "A5PL-E7",
             0x1003: "S5PEDS-AB",
             0x1004: "KC705-K325",
             0x1005: "ZC706-Z045",
             0x1006: "KCU105-KU040",
             0x1007: "XUSP3S-VU095 [Jasper]",
             0x1008: "XUSPL4-VU065 [Mustang UltraScale]",
             0x1009: "XUSPL4-VU3P [Mustang UltraScale+]",
             0x100A: "A10PL4-A10GX115",
             0x100B: "K35-2SFP",
             0x100C: "K35-4SFP",
             0x100D: "AR-ARKA-FX0 [Arkville 32B DPDK Data Mover]",
             0x100E: "AR-ARKA-FX1 [Arkville 64B DPDK Data Mover]",
             0x100F: "AR-ARKA-FX1 [Arkville 64B DPDK Data Mover for Versal]",
             0x1010: "AR-ARKA-FX1 [Arkville 64B DPDK Data Mover for Agilex]",
             0x1011: "AR-MAN-U50 [Manitou Class Accelerator for U50]",
             0x1012: "AR-MAN-U200 [Manitou Class Accelerator for U200]",
             0x1013: "AR-MAN-U250 [Manitou Class Accelerator for U250]",
             0x1014: "AR-MAN-U280 [Manitou Class Accelerator for U280]",
             0x1015: "AR-ARK-BBDEV-FX0 [Arkville 32B DPDK Baseband Device]",
             0x1016: "AR-ARK-BBDEV-FX1 [Arkville 64B DPDK Baseband Device]",
             0x1017: "AR-ARK-FX1 [Arkville 64B Multi-Homed Primary Endpoint]",
             0x1018: "AR-ARK-FX1 [Arkville 64B Multi-Homed Secondary Endpoint]",
             0x1019: "AR-ARK-FX1 [Arkville 64B Multi-Homed Tertiary Endpoint]",
             0x101A: "AR-ARK-SRIOV-FX0 [Arkville 32B Primary Physical Function]",
             0x101B: "AR-ARK-SRIOV-FX1 [Arkville 64B Primary Physical Function]",
             0x101C: "AR-ARK-SRIOV-VF [Arkville Virtual Function]",
             0x101D: "AR-ARK-NIC [Arkville ArkNIC Kernel Path Device]",
             0x101E: "AR-ARKA-FX1 [Arkville 64B DPDK Data Mover for Agilex R-Tile]",
             0x101F: "AR-TK242 [2x100GbE Packet Capture Device]",
             0x1020: "AR-GP-PF [General-Purpose Physical Function]",
             0x1021: "AR-MGMT-PF [Board-Generic Management Physical Function]",
             0x1022: "AR-ARKA-FX2 [Arkville 128B DPDK Data Mover for Agilex]",
             0x1023: "AR-BD-FX1 [BufferDirect Zero-Bounce Data Motion Endpoint]",
             0x4200: "A5PL-E1-10GETI [10 GbE Ethernet Traffic Instrument]",
             },

    # DERA Storage
    0x1D78: {0x1512: "TAI NVMe Controller",
             0x1513: "DERA MENG NVMe Controller",
             0x1515: "DERA EMEI NVMe Controller",
             },

    # NETINT Technologies Inc.
    0x1D82: {0x0101: "Codensity D400 SSD",
             0x0102: "Codensity D408 PCIe Gen4 NVMe SSD",
             0x0202: "Codensity T408 Video Encoding-Decoding Accelerator",
             0x0401: "Quadra Video Processing Unit (VPU)",
             },

    # Rockchip Electronics Co., Ltd
    0x1D87: {0x0100: "RK3399 PCI Express Root Port",
             0x1808: "RK1808 Neural Network Processor Card",
             0x3528: "RK3528 PCI Express Root Port",
             0x3562: "RK3562 PCI Express Root Port",
             0x3566: "RK3568 Remote Signal Processor",
             0x3588: "RK3588",
             },

    # Chengdu Haiguang IC Design Co., Ltd.
    0x1D94: {0x1450: "Root Complex",
             0x1451: "I/O Memory Management Unit",
             0x1452: "PCIe Dummy Host Bridge",
             0x1453: "PCIE GPP Bridge",
             0x1454: "Internal PCIe GPP Bridge 0 to Bus B",
             0x1455: "PCIe Dummy Function",
             0x1456: "PSPCCP Command DMA Processor",
             0x1458: "10 Gb Ethernet Controller Port 0/Port1",
             0x1459: "10 Gb Ethernet Controller Port 2/Port3",
             0x145A: "PCIe Dummy Function",
             0x145B: "PCIE Non-Transparent Bridge",
             0x145C: "USB3 XHCI",
             0x145D: "Switch upstream in PCIe",
             0x145E: "Switch downstream in PCIe",
             0x145F: "USB 3.0 Host controller",
             0x1460: "Data Fabric: Device 18h; Function 0",
             0x1461: "Data Fabric: Device 18h; Function 1",
             0x1462: "Data Fabric: Device 18h; Function 2",
             0x1463: "Data Fabric: Device 18h; Function 3",
             0x1464: "Data Fabric: Device 18h; Function 4",
             0x1465: "Data Fabric: Device 18h; Function 5",
             0x1466: "Data Fabric: Device 18h; Function 6",
             0x1467: "Data Fabric: Device 18h; Function 7",
             0x1468: "NTBCCP",
             0x7901: "FCH SATA Controller [AHCI mode]",
             0x7904: "FCH SATA Controller [AHCI mode]",
             0x7906: "FCH SD Flash Controller",
             0x790B: "FCH SMBus Controller",
             0x790E: "FCH LPC Bridge",
             },

    # Graphcore Ltd
    0x1D95: {0x0001: "Colossus GC2 [C2]",
             0x0002: "Colossus GC1 [S1]",
             },

    # Meta Platforms, Inc.
    0x1D9B: {0x0010: "Networking DOM Engine",
             0x0011: "IO Bridge",
             },

    # Sapphire Technology Limited
    0x1DA2: {0xE26A: "Radeon R7 250",
             0xE445: "Sapphire Radeon RX 6700",
             },

    # Habana Labs Ltd.
    0x1DA3: {0x0001: "HL-1000 AI Inference Accelerator [Goya]",
             0x0030: "Greco AI Inference Accelerator",
             0x1000: "HL-2000 AI Training Accelerator [Gaudi]",
             0x1010: "HL-2000 AI Training Accelerator [Gaudi secured]",
             0x1020: "Gaudi2 AI Training Accelerator",
             },

    # Phytium Technology Co., Ltd.
    0x1DB7: {0xDC20: "[X100 Series]",
             0xDC21: "VPU Controller [X100 Series]",
             0xDC22: "DC Controller [X100 Series]",
             0xDC23: "I2S/DMA Controller [X100 Series]",
             0xDC24: "NPU Controller [X100 Series]",
             0xDC26: "SATA Controller [X100 Series]",
             0xDC27: "USB Controller [X100 Series]",
             0xDC29: "NANDFLASH Controller [X100 Series]",
             0xDC2B: "I2S Controller [X100 Series]",
             0xDC2C: "SPIM Controller [X100 Series]",
             0xDC2D: "CAN Controller [X100 Series]",
             0xDC2E: "UART Controller [X100 Series]",
             0xDC2F: "PWM Controller [X100 Series]",
             0xDC30: "MIO Controller [X100 Series]",
             0xDC31: "GPIO Controller [X100 Series]",
             0xDC32: "SMBUS Controller [X100 Series]",
             0xDC34: "PS2 Controller [X100 Series]",
             0xDC35: "LPC Controller [X100 Series]",
             0xDC36: "LDMA Controller [X100 Series]",
             0xDC38: "LSD_CFG Controller [X100 Series]",
             0xDC3A: "SWITCH Controller [X100 Series]",
             0xDC3C: "GPU_DMA Controller [X100 Series]",
             },

    # INNOGRIT Corporation
    0x1DBE: {0x5636: "NVMe DC SSD IG5636",
             0x5638: "NVMe DC SSD IG5638",
             },

    # AMD Pensando Systems
    0x1DD8: {0x0002: "DSC2 Elba Upstream Port",
             0x1000: "DSC Capri Upstream Port",
             0x1001: "DSC Virtual Downstream Port",
             0x1002: "DSC Ethernet Controller",
             0x1003: "DSC Ethernet Controller VF",
             0x1004: "DSC Management Controller",
             0x1005: "DSC NVMe Controller",
             0x1006: "DSC NVMe Controller VF",
             0x1007: "DSC Storage Accelerator",
             0x1009: "DSC Ethernet Controller UPT",
             0x100A: "DSC Serial Port Controller",
             0x100B: "DSC vDPA Network Device VF",
             0x100C: "DSC PDS Core Management",
             0x100D: "DSC Virtio Network Device VF",
             },

    # Tekram Technology Co.,Ltd.
    0x1DE1: {0x0391: "TRM-S1040 [DC-315 / DC-395 series]",
             0x2020: "DC-390 Series SCSI Adapter [AMD Am53C974]",
             0x690C: "690c",
             0xDC29: "DC290",
             },

    # Eideticom, Inc
    0x1DE5: {0x1000: "IO Memory Controller",
             0x2000: "NoLoad Hardware Development Kit",
             0x3000: "eBPF-based PCIe Accelerator",
             },

    # Alibaba (China) Co., Ltd.
    0x1DED: {0x107F: "Elastic RDMA Adapter",
             0x5007: "Elastic RDMA Adapter",
             0x8000: "M1 Root Port",
             0x8001: "ACC-RCiEP",
             0x8002: "RCiEP VF",
             0x8003: "RCEC PF",
             0x8004: "RCEC VF",
             },

    # Ampere Computing, LLC
    0x1DEF: {0xE005: "eMAG PCI Express Root Port 0",
             0xE006: "eMAG PCI Express Root Port 1",
             0xE007: "eMAG PCI Express Root Port 2",
             0xE008: "eMAG PCI Express Root Port 3",
             0xE009: "eMAG PCI Express Root Port 4",
             0xE00A: "eMAG PCI Express Root Port 5",
             0xE00B: "eMAG PCI Express Root Port 6",
             0xE00C: "eMAG PCI Express Root Port 7",
             0xE100: "Altra PCI Express Root Complex A",
             0xE101: "Altra PCI Express Root Port a0",
             0xE102: "Altra PCI Express Root Port a1",
             0xE103: "Altra PCI Express Root Port a2",
             0xE104: "Altra PCI Express Root Port a3",
             0xE105: "Altra PCI Express Root Port a4",
             0xE106: "Altra PCI Express Root Port a5",
             0xE107: "Altra PCI Express Root Port a6",
             0xE108: "Altra PCI Express Root Port a7",
             0xE110: "Altra PCI Express Root Complex B",
             0xE111: "Altra PCI Express Root Port b0",
             0xE112: "Altra PCI Express Root Port b1",
             0xE113: "Altra PCI Express Root Port b2",
             0xE114: "Altra PCI Express Root Port b3",
             0xE115: "Altra PCI Express Root Port b4",
             0xE116: "Altra PCI Express Root Port b5",
             0xE117: "Altra PCI Express Root Port b6",
             0xE118: "Altra PCI Express Root Port b7",
             },

    # Ethernity Networks
    0x1DF3: {0x0201: "ACE-NIC40 Programmable Network Accelerator",
             0x0202: "ACE-NIC50 Programmable Network Accelerator",
             0x0203: "ACE-NIC100 Programmable Network Accelerator",
             0x0204: "ACE-NIC-NID Programmable Network Accelerator",
             0x0205: "ACE-NIC250 Programmable Network Accelerator",
             0x0206: "ACE-NIC200 Programmable Network Accelerator",
             0x0207: "ACE-NIC50RN Programmable Network Accelerator",
             0x0208: "ACE-NIC100RN Programmable Network Accelerator",
             },

    # opencpi.org
    0x1DF7: {0x0001: "ml605",
             0x0002: "alst4",
             0x0003: "alst4x",
             },

    # V&G Information System Co.,Ltd
    0x1DF8: {0x3000: "PC NVMe SSD",
             0xC000: "DC NVMe SSD",
             0xD000: "PC NVMe SSD",
             },

    # KIOXIA Corporation
    0x1E0F: {0x0001: "NVMe SSD Controller BG4",
             0x0007: "NVMe SSD Controller Cx6",
             0x0009: "NVMe SSD",
             0x0011: "NVMe SSD Controller CD7",
             0x001F: "NVMe SSD Controller CD8",
             },

    # Squirrels Research Labs
    0x1E24: {0x0101: "Acorn CLE-101",
             0x0215: "Acorn CLE-215",
             0x021F: "Acorn CLE-215+",
             0x1525: "Xilinx BCU-1525",
             0x1533: "ForestKitten 33",
             0x1633: "JCM33",
             0x1635: "JCM35",
             },

    # Shanghai Enflame Technology Co. Ltd
    0x1E36: {0x0001: "T10 [CloudBlazer]",
             0x0002: "T11 [CloudBlazer]",
             0x0003: "T10(QSFP-DD) [CloudBlazer]",
             0x0021: "T20(32GB) [CloudBlazer]",
             0x0022: "T20(64GB) [CloudBlazer]",
             0x0023: "T21(32GB) [CloudBlazer]",
             0x0024: "T21(64GB) [CloudBlazer]",
             0x8001: "I20 [CloudBlazer]",
             0x8011: "I10 [CloudBlazer]",
             0x8012: "I10L [CloudBlazer]",
             },

    # DapuStor Corporation
    0x1E3B: {0x0600: "NVMe SSD Controller DP600",
             0x1098: "Haishen3 NVMe SSD",
             0x1333: "Haishen5 NVMe SSD",
             },

    # Yangtze Memory Technologies Co.,Ltd
    0x1E49: {0x0021: "ZHITAI TiPro5000 NVMe SSD",
             0x0041: "ZHITAI TiPro7000",
             0x1013: "PC210",
             },

    # MAXIO Technology (Hangzhou) Ltd.
    0x1E4B: {0x1001: "NVMe SSD Controller MAP1001",
             0x1002: "NVMe SSD Controller MAP1002",
             0x1003: "NVMe SSD Controller MAP1003",
             0x1201: "NVMe SSD Controller MAP1201",
             0x1202: "NVMe SSD Controller MAP1202",
             0x1601: "NVMe SSD Controller MAP1601",
             },

    # ASR Microelectronics
    0x1E5D: {0x7000: "AI controller A7000",
             0x7010: "AI controller A7010",
             },

    # ID Quantique SA
    0x1E89: {0x0002: "Quantis-PCIe-40M",
             0x0003: "Quantis-PCIe-240M",
             },

    # Tencent Technology (Shenzhen) Company Limited
    0x1EA0: {0x2A16: "Cloud Intelligent Inference Controller",
             0x2A18: "Video Transcode Controller",
             0x2A20: "Cloud Intelligent Inference and Training Controller",
             },

    # Intelliprop, Inc
    0x1EA7: {0x223A: "Typhon+ PCIe to Gen-Z Bridge",
             0x224A: "IPA-PE224A CXL to Gen-Z Bridge [Sphinx]",
             },

    # Hefei DATANG Storage Technology Co.,LTD.
    0x1EAB: {0x300A: "NVMe SSD Controller 300A",
             0x300B: "NVMe SSD Controller 300B",
             },

    # Quectel Wireless Solutions Co., Ltd.
    0x1EAC: {0x1001: "EM120R-GL LTE Modem",
             0x1002: "EM160R-GL LTE Modem",
             },

    # Innosilicon Co Ltd
    0x1EC8: {0x8800: "Fantasy I",
             0x9800: "Fantasy II",
             0x9802: "Fantasy II",
             0x9804: "Fantasy II",
             },

    # Moore Threads Technology Co.,Ltd
    0x1ED5: {0x0100: "MTT S10",
             0x0101: "MTT S10",
             0x0102: "MTT S30",
             0x0105: "MTT S50",
             0x0106: "MTT S60",
             0x0111: "MTT S100",
             0x0121: "MTT S1000M",
             0x0122: "MTT S1000",
             0x0123: "MTT S2000",
             0x01FF: "MTT HDMI/DP Audio",
             0x0200: "MTT S80 Engineering Sample",
             0x0201: "MTT S80",
             0x0202: "MTT S70",
             0x0203: "MTT S60",
             0x0211: "G2D40",
             0x0221: "G2S80",
             0x0222: "MTT S3000",
             0x0223: "G2S4",
             0x0251: "G2N10",
             0x02FF: "MTT HDMI/DP Audio",
             },

    # Viscore Technologies Ltd
    0x1EEC: {0x0102: "VSE250231S Dual-port 10Gb/25Gb Ethernet PCIe",
             0x1EEC: "VSE250231S Dual-port 10Gb/25Gb Ethernet PCIe",
             },

    # XDX Computing Technology Ltd.
    0x1EED: {0x10A0: "XDX110 Graphic/VGA Controller",
             0x10A1: "XDX110 Audio Controller",
             0x1140: "XDX120 Graphic/VGA Controller",
             0x1141: "XDX120 Audio Controller",
             0x1320: "XDX150 Graphic/VGA Controller",
             0x1321: "XDX150 Audio Controller",
             0x13C0: "XDX160 Graphic/VGA Controller",
             0x13C1: "XDX160 Audio Controller",
             0x13D0: "XDX161 Graphic/VGA Controller",
             0x13D1: "XDX161 Audio Controller",
             0x1500: "XDX180 Graphic/VGA Controller",
             0x1501: "XDX180 Audio Controller",
             0x15A0: "XDX190 Graphic/VGA Controller",
             0x15A1: "XDX190 Audio Controller",
             },

    # Shenzhen Shichuangyi Electronics Co., Ltd
    0x1F03: {0x1202: "MAP1202-Based NVMe SSD",
             0x2262: "SM2262EN-based OEM SSD",
             0x2263: "SM2263XT-Base NVMe SSD",
             0x5216: "IG5216-based NVMe SSD",
             0x5220: "IG5220-Based NVMe SSD",
             0x5236: "IG5236-Based NVMe SSD",
             0x5636: "IG5636-Based NVMe SSD",
             },

    # NebulaMatrix Technology
    0x1F0F: {0x1041: "D1055AS vDPA Ethernet Controller",
             0x1042: "D1055AS vDPA Storage Controller",
             0x1220: "D1055AS Ethernet Controller",
             0x1221: "D1055AS Ethernet Controller",
             0x1222: "D1055AS Ethernet Controller",
             0x1223: "D1055AS Ethernet Controller",
             0x1600: "M16104 Family",
             0x1601: "M16104 Family Virtual Function",
             0x1A00: "M16104 Family",
             0x1A01: "M16104 Family Virtual Function",
             0x2022: "D1055AS PCI Express Switch Upstream Port",
             0x9088: "D1055AS PCI Express Switch Downstream Port",
             },

    # 3SNIC Ltd
    0x1F3F: {0x2100: "SSSHBA SAS/SATA HBA",
             0x2200: "SSSRAID RAID controller",
             0x9001: "SSSNIC Ethernet VF",
             0x9002: "SSSNIC Ethernet VF Hyper-V",
             0x9003: "SSSNIC Ethernet SDI VF",
             0x9004: "SSSNIC Ethernet SDI VF Hyper-V",
             0x9008: "SSSFC VF",
             0x9009: "SSSFC VF Hyper-V",
             0x9010: "SSSFC FC Controller",
             0x9020: "SSSNIC Ethernet Network Adapter",
             0x9030: "SSSNIC IPU",
             0x9031: "SSSNIC SDI5.0",
             0x9032: "SSSNIC SDI5.1",
             },

    # Accelecom
    0x1F60: {0x0001: "XELE-NIC 25K5",
             0x0054: "XELE-NIC 25K5",
             },

    # Hexaflake (Shanghai) Information Technology Co., Ltd.
    0x1FAA: {0x0C10: "Compass C10 PF",
             0x0C11: "Compass C10 VF",
             },

    # Unifabrix Ltd.
    0x1FAB: {0x0000: "Nexus Alpha IVPU",
             0x0100: "NoX Gamma",
             },

    # Ascom (Finland) Oy
    0x1FC0: {0x0300: "E2200 Dual E1/Rawpipe Card",
             0x0301: "C5400 SHDSL/E1 Card",
             },

    # QLogic, Corp.
    0x1FC1: {0x000D: "IBA6110 InfiniBand HCA",
             0x0010: "IBA6120 InfiniBand HCA",
             },

    # Tehuti Networks Ltd.
    0x1FC9: {0x3009: "10-Giga TOE SmartNIC",
             0x3010: "10-Giga TOE SmartNIC",
             0x3014: "10-Giga TOE SmartNIC 2-Port",
             0x3110: "10-Giga TOE Single Port SmartNIC",
             0x3114: "10-Giga TOE Dual Port Low Profile SmartNIC",
             0x3310: "10-Giga TOE SFP+ Single Port SmartNIC",
             0x3314: "10-Giga TOE Dual Port Low Profile SmartNIC",
             0x4010: "TN4010 Clean SROM",
             0x4020: "TN9030 10GbE CX4 Ethernet Adapter",
             0x4022: "TN9310 10GbE SFP+ Ethernet Adapter",
             0x4024: "TN9210 10GBase-T Ethernet Adapter",
             0x4025: "TN9510 10GBase-T/NBASE-T Ethernet Adapter",
             0x4026: "TN9610 10GbE SFP+ Ethernet Adapter",
             0x4027: "TN9710P 10GBase-T/NBASE-T Ethernet Adapter",
             0x4527: "TN9710Q 5GBase-T/NBASE-T Ethernet Adapter",
             },

    # StreamLabs
    0x1FCC: {0xF416: "MS416",
             0xFB01: "MH4LM",
             },

    # SUNIX Co., Ltd.
    0x1FD4: {0x0001: "Matrix multiport serial adapter",
             0x1999: "Multiport serial controller",
             },

    # Kingston Technology Company, Inc.
    0x2646: {0x0010: "HyperX Predator PCIe AHCI SSD",
             0x2262: "KC2000 NVMe SSD",
             0x2263: "A2000 NVMe SSD",
             0x5008: "U-SNS8154P3 NVMe SSD",
             0x500D: "OM3PDP3 NVMe SSD",
             0x500E: "SNVS2000G [NV1 NVMe PCIe SSD 2TB]",
             0x5012: "DC1500M U.2 Enterprise SSD",
             },

    # Hint Corp
    0x3388: {0x0013: "HiNT HC4 PCI to ISDN bridge, Multimedia audio controller",
             0x0014: "HiNT HC4 PCI to ISDN bridge, Network controller",
             0x0020: "HB6 Universal PCI-PCI bridge (transparent mode)",
             0x0021: "HB6 Universal PCI-PCI bridge (non-transparent mode)",
             0x0022: "HiNT HB4 PCI-PCI Bridge (PCI6150)",
             0x0026: "HB2 PCI-PCI Bridge",
             0x1014: "AudioTrak Maya",
             0x1018: "Audiotrak INCA88",
             0x1019: "Miditrak 2120",
             0x101A: "E.Band [AudioTrak Inca88]",
             0x101B: "E.Band [AudioTrak Inca88]",
             0x8011: "VXPro II Chipset",
             0x8012: "VXPro II Chipset",
             0x8013: "VXPro II IDE",
             0xA103: "Blackmagic Design DeckLink HD Pro",
             },

    # Bihl+Wiedemann GmbH
    0x3442: {0x1783: "AS-i 3.0 cPCI Master",
             0x1922: "AS-i 3.0 PCI Master",
             },

    # ITD Firm ltd.
    0x37D9: {0x1138: "SCHD-PH-8 Phase detector",
             0x1140: "VR-12-PCI",
             0x1141: "PCI-485(422)",
             0x1142: "PCI-CAN2",
             },

    # 3DLabs
    0x3D3D: {0x0001: "GLINT 300SX",
             0x0002: "GLINT 500TX",
             0x0003: "GLINT Delta",
             0x0004: "Permedia",
             0x0005: "Permedia",
             0x0006: "GLINT MX",
             0x0007: "3D Extreme",
             0x0008: "GLINT Gamma G1",
             0x0009: "Permedia II 2D+3D",
             0x000A: "GLINT R3",
             0x000C: "GLINT R3 [Oxygen VX1]",
             0x000D: "GLint R4 rev A",
             0x000E: "GLINT Gamma G2",
             0x0011: "GLint R4 rev B",
             0x0012: "GLint R5 rev A",
             0x0013: "GLint R5 rev B",
             0x0020: "VP10 visual processor",
             0x0022: "VP10 visual processor",
             0x0024: "VP9 visual processor",
             0x002C: "Wildcat Realizm 100/200",
             0x0030: "Wildcat Realizm 800",
             0x0032: "Wildcat Realizm 500",
             0x0100: "Permedia II 2D+3D",
             0x07A1: "Wildcat III 6210",
             0x07A2: "Sun XVR-500 Graphics Accelerator",
             0x07A3: "Wildcat IV 7210",
             0x1004: "Permedia",
             0x3D04: "Permedia",
             0xFFFF: "Glint VGA",
             },

    # Avance Logic Inc.
    0x4005: {0x0300: "ALS300 PCI Audio Device",
             0x0308: "ALS300+ PCI Audio Device",
             0x0309: "PCI Input Controller",
             0x1064: "ALG-2064",
             0x2064: "ALG-2064i",
             0x2128: "ALG-2364A GUI Accelerator",
             0x2301: "ALG-2301",
             0x2302: "ALG-2302",
             0x2303: "AVG-2302 GUI Accelerator",
             0x2364: "ALG-2364A",
             0x2464: "ALG-2464",
             0x2501: "ALG-2564A/25128A",
             0x4000: "ALS4000 Audio Chipset",
             0x4710: "ALC200/200P",
             },

    # NetXen Incorporated
    0x4040: {0x0001: "NXB-10GXSR 10-Gigabit Ethernet PCIe Adapter with SR-XFP optical interface",
             0x0002: "NXB-10GCX4 10-Gigabit Ethernet PCIe Adapter with CX4 copper interface",
             0x0003: "NXB-4GCU Quad Gigabit Ethernet PCIe Adapter with 1000-BASE-T interface",
             0x0004: "BladeCenter-H 10-Gigabit Ethernet High Speed Daughter Card",
             0x0005: "NetXen Dual Port 10GbE Multifunction Adapter for c-Class",
             0x0024: "XG Mgmt",
             0x0025: "XG Mgmt",
             0x0100: "NX3031 Multifunction 1/10-Gigabit Server Adapter",
             },

    # ONA Electroerosion
    0x4150: {0x0001: "PCI32TLITE FILSTRUP1 PCI to VME Bridge Controller",
             0x0006: "PCI32TLITE UART 16550 Opencores",
             0x0007: "PCI32TLITE CAN Controller Opencores",
             },

    # Aladdin Knowledge Systems
    0x416C: {0x0100: "AladdinCARD",
             0x0200: "CPC",
             },

    # WCH.CN
    0x4348: {0x2273: "CH351 PCI Dual Serial Port Controller",
             0x3253: "CH352 PCI Dual Serial Port Controller",
             0x3453: "CH353 PCI Quad Serial Port Controller",
             0x5053: "CH352 PCI Serial and Parallel Port Controller",
             0x7053: "CH353 PCI Dual Serial and Parallel Ports Controller",
             0x7073: "CH356 PCI Quad Serial and Parallel Ports Controller",
             0x7173: "CH355 PCI Quad Serial Port Controller",
             },

    # Internext Compression Inc
    0x4444: {0x0016: "iTVC16 (CX23416) Video Decoder",
             0x0803: "iTVC15 (CX23415) Video Decoder",
             },

    # Budker Institute of Nuclear Physics
    0x4624: {0xADC1: "ADC200ME High speed ADC",
             0xDE01: "DL200ME High resolution delay line PCI based card",
             0xDE02: "DL200ME Middle resolution delay line PCI based card",
             },

    # ACCES I/O Products, Inc.
    0x494F: {0x0508: "PCI-IDO-16A FET Output Card",
             0x0518: "PCI-IDO-32A FET Output Card",
             0x0520: "PCI-IDO-48 FET Output Card",
             0x0521: "PCI-IDO-48A FET Output Card",
             0x0703: "PCIe-RO-4 Electromechanical Relay Output Card",
             0x07D0: "PCIe-IDO-24 FET Output Card",
             0x0920: "PCI-IDI-48 Isolated Digital Input Card",
             0x0BD0: "PCIe-IDI-24 Isolated Digital Input Card",
             0x0C50: "PCI-DIO-24H 1x 8255 Digital Input / Output Card",
             0x0C51: "PCI-DIO-24D 1x 8255 Digital Input / Output Card",
             0x0C52: "PCIe-DIO-24 1x 8255 Digital Input / Output Card",
             0x0C53: "PCIe-DIO-24H 8255 Digital Input / Output Card",
             0x0C57: "mPCIe-DIO-24 8255 Digital Input / Output Card",
             0x0C60: "PCI-DIO-48H 8255 Digital Input / Output Card",
             0x0C61: "PCIe-DIO-48 8255 Digital Input / Output Card",
             0x0C62: "P104-DIO-48 8255 Digital Input / Output Card",
             0x0C68: "PCI-DIO-72 8255 Digital Input / Output Card",
             0x0C69: "P104-DIO-96 8255 Digital Input / Output Card",
             0x0C70: "PCI-DIO-96 8255 Digital Input / Output Card",
             0x0C78: "PCI-DIO-120 8255 Digital Input / Output Card",
             0x0DC8: "PCI-IDIO-16 Isolated Digital Input / FET Output Card",
             0x0E50: "PCI-DIO-24S 8255 Digital Input / Output Card",
             0x0E51: "PCI-DIO-24H(C) 8255 Digital Input / Output Card",
             0x0E52: "PCI-DIO-24D(C) 8255 Digital Input / Output Card",
             0x0E53: "PCIe-DIO-24S 8255 Digital Input / Output Card",
             0x0E54: "PCIe-DIO-24HS 8255 Digital Input / Output Card",
             0x0E55: "PCIe-DIO-24DC 8255 Digital Input / Output Card",
             0x0E56: "PCIe-DIO-24DCS 8255 Digital Input / Output Card",
             0x0E57: "mPCIe-DIO-24S 8255 Digital Input / Output Card",
             0x0E60: "PCI-DIO-48S 2x 8255 Digital Input / Output Card",
             0x0E61: "PCIe-DIO-48S 2x 8255 Digital Input / Output Card",
             0x0E62: "P104-DIO-48S 2x 8255 Digital Input / Output Card",
             0x0F00: "PCI-IIRO-8 Isolated Digital / Relay Output Card",
             0x0F01: "LPCI-IIRO-8 Isolated Digital / Relay Output Card",
             0x0F02: "PCIe-IIRO-8 Isolated Digital / Relay Output Card",
             0x0F08: "PCI-IIRO-16 Isolated Digital / Relay Output Card",
             0x0F09: "PCIe-IIRO-16 Isolated Digital / Relay Output Card",
             0x0FC0: "PCIe-IDIO-12 Isolated Digital Input / FET Output Card",
             0x0FC1: "PCIe-IDI-12 Isolated Digital Input Card",
             0x0FC2: "PCIe-IDO-12 FET Output Card",
             0x0FD0: "PCIe-IDIO-24 Isolated Digital Input / FET Output Card",
             0x1050: "PCI-422/485-2 2x RS422/RS484 Card",
             0x1051: "PCIe-COM-2SRJ 2x RS422/RS484 Card w/RJ45 Connectors",
             0x1052: "104I-COM-2S 2x RS422/RS484 PCI/104 Board",
             0x1053: "mPCIe-COM-2S 2x RS422/RS484 PCI Express Mini Card",
             0x1058: "PCI-COM422/4 4x RS422 Card",
             0x1059: "PCI-COM485/4 4x RS485 Card",
             0x105A: "PCIe-COM422-4 4x RS422 Card",
             0x105B: "PCIe-COM485-4 4x RS485 Card",
             0x105C: "PCIe-COM-4SRJ 4x RS422/RS485 Card w/RJ45 Connectors",
             0x105D: "104I-COM-4S 4x RS422/RS484 PCI/104 Board",
             0x105E: "mPCIe-COM-4S 4x RS422/RS484 PCI Express Mini Card",
             0x1068: "PCI-COM422/8 8x RS422 Card",
             0x1069: "PCI-COM485/8 8x RS485 Card",
             0x106A: "PCIe-COM422-8 8x RS422 Card",
             0x106B: "PCIe-COM485-8 8x RS485 Card",
             0x106C: "104I-COM-8S 8x RS422/RS485 PCI/104 Board",
             0x1088: "PCI-COM232/1 1x RS232 Card",
             0x1090: "PCI-COM232/2 2x RS232 Card",
             0x1091: "PCIe-COM232-2RJ 2x RS232 Card w/RJ45 Connectors",
             0x1093: "mPCIe-COM232-2 2x RS232 PCI Express Mini Card",
             0x1098: "PCIe-COM232-4 4x RS232 Card",
             0x1099: "PCIe-COM232-4RJ 4x RS232 Card w/RJ45 Connectors",
             0x109B: "mPCIe-COM232-4 4x RS232 PCI Express Mini Card",
             0x10A8: "P104-COM232-8 8x RS232 PC-104+ Board",
             0x10A9: "PCIe-COM232-8 8x RS232 Card",
             0x10C9: "PCI-COM-1S 1x RS422/RS485 Card",
             0x10D0: "PCI-COM2S 2x RS422/RS485 Card",
             0x10D1: "PCIe-COM-2SMRJ 2x RS232/RS422/RS485 Card w/RJ45 Connectors",
             0x10D2: "104I-COM-2SM 2x RS232/RS422/RS485 PCI/104 Board",
             0x10D3: "mPCIe-COM-2SM 2x RS232/RS422/RS485 PCI Express Mini Card",
             0x10D8: "PCI-COM-4SM 4x RS232/RS422/RS485 Card",
             0x10D9: "PCIe-COM-4SM 4x RS232/RS422/RS485 Card",
             0x10DA: "PCIe-COM-4SMRJ 4x RS232/RS422/RS485 Card w/RJ45 Connectors",
             0x10DB: "104I-COM-4SM 4x RS232/RS422/RS485 PCI/104 Board",
             0x10DC: "mPCIe-COM-4SM 4x RS232/RS422/RS485 PCI Express Mini Card",
             0x10E8: "PCI-COM-8SM 8x RS232/RS422/RS485 Card",
             0x10E9: "PCIe-COM-8SM 8x RS232/RS422/RS485 Card",
             0x10EA: "104I-COM-8SM 8x RS232/RS422/RS485 PCI-104 Board",
             0x1108: "mPCIe-ICM485-1 1x Isolated RS485 PCI Express Mini Card",
             0x1110: "mPCIe-ICM422-2 2x Isolated RS422 PCI Express Mini Card",
             0x1111: "mPCIe-ICM485-2 2x Isolated RS485 PCI Express Mini Card",
             0x1118: "mPCIe-ICM422-4 4x Isolated RS422 PCI Express Mini Card",
             0x1119: "mPCIe-ICM485-4 4x Isolated RS485 PCI Express Mini Card",
             0x1148: "PCI-ICM-1S 1x Isolated RS422/RS485 Card",
             0x1150: "PCI-ICM-2S 2x Isolated RS422/RS485 Card",
             0x1152: "PCIe-ICM-2S 2x Isolated RS422/RS485 Card",
             0x1158: "PCI-ICM422/4 4x Isolated RS422 Card",
             0x1159: "PCI-ICM485/4 4x Isolated RS485 Card",
             0x115A: "PCIe-ICM-4S 4x Isolated RS422/RS485 Card",
             0x1190: "PCIe-ICM232-2 2x Isolated RS232 Card",
             0x1191: "mPCIe-ICM232-2 2x Isolated RS232 PCI Express Mini Card",
             0x1198: "PCIe-ICM232-4 4x Isolated RS232 Card",
             0x1199: "mPCIe-ICM232-4 4x Isolated RS422 PCI Express Mini Card",
             0x11D0: "PCIe-ICM-2SM 2x Isolated RS232/RS422/RS485 Card",
             0x11D8: "PCIe-ICM-4SM 4x Isolated RS232/RS422/RS485 Card",
             0x1250: "PCI-WDG-2S Watchdog and 2x Serial Card",
             0x12D0: "PCI-WDG-IMPAC",
             0x2230: "PCI-QUAD-8 8x Quadrature Input Card",
             0x2231: "PCI-QUAD-4 4x Quadrature Input Card",
             0x22C0: "PCI-WDG-CSM Watchdog Card",
             0x25C0: "P104-WDG-E Watchdog PC/104+ Board",
             0x2C50: "PCI-DIO-96CT 96x Digital Input / Output Card",
             0x2C58: "PCI-DIO-96C3 96x Digital Input / Output Card w/3x 8254 Counter Card",
             0x2EE0: "PCIe-DIO24S-CTR12 24x Digital Input / Output Card w/4x 8254 Counter Card",
             0x2FC0: "P104-WDG-CSM Watchdog PC/104+ Board",
             0x2FC1: "P104-WDG-CSMA Advanced Watchdog PC/104+ Board",
             0x5ED0: "PCI-DAC",
             0x6C90: "PCI-DA12-2 2x 12-bit Analog Output Card",
             0x6C98: "PCI-DA12-4 4x 12-bit Analog Output Card",
             0x6CA0: "PCI-DA12-6 6x 12-bit Analog Output Card",
             0x6CA8: "PCI-DA12-8 8x 12-bit Analog Output Card",
             0x6CA9: "PCI-DA12-8V",
             0x6CB0: "PCI-DA12-16 16x 12-bit Analog Output Card",
             0x6CB1: "PCI-DA12-16V",
             0x8EF0: "P104-FAS16-16",
             0xACA8: "PCI-AI12-16 12-bit 100kHz Analog Input Card",
             0xACA9: "PCI-AI12-16A 12-bit 100kHz Analog Input w/FIFO Card",
             0xECA8: "PCI-AIO12-16 12-bit 100kHz Analog Input w/2x Analog Output and FIFO Card",
             0xECAA: "PCI-A12-16A 12-bit 100kHz Analog Input w/2x Analog Output and FIFO Card",
             0xECE8: "LPCI-A16-16A 16-bit 500kHz Analog Input low-profile Card",
             0xECE9: "LPCI-AIO16A 16-bit 500kHz Analog Input low-profile Card",
             },

    # SBS Technologies
    0x4C53: {0x0000: "PLUSTEST device",
             0x0001: "PLUSTEST-MM device",
             },

    # MATRIX VISION GmbH
    0x4D56: {0x0000: "[mvHYPERION-CLe/CLb] CameraLink PCI Express x1 Frame Grabber",
             0x0001: "[mvHYPERION-CLf/CLm] CameraLink PCI Express x4 Frame Grabber",
             0x0010: "[mvHYPERION-16R16/-32R16] 16 Video Channel PCI Express x4 Frame Grabber",
             0x0020: "[mvHYPERION-HD-SDI] HD-SDI PCI Express x4 Frame Grabber",
             0x0030: "[mvHYPERION-HD-SDI-Merger] HD-SDI PCI Express x4 Frame Grabber",
             0x7012: "[mvBlueNAOS BVS CA-BN] PCIe Gen1 x2 Camera",
             0x7014: "[mvBlueNAOS BVS CA-BN] PCIe Gen1 x4 Camera",
             0x7022: "[mvBlueNAOS BVS CA-BN] PCIe Gen2 x2 Camera",
             0x7024: "[mvBlueNAOS BVS CA-BN] PCIe Gen2 x4 Camera",
             },

    # ILC Data Device Corp
    0x4DDC: {0x0100: "DD-42924I5-300 (ARINC 429 Data Bus)",
             0x0300: "SB-3620 Motion Feedback Device",
             0x0340: "SB-3623 Motion Feedback Device",
             0x0400: "SB-3622 Motion Feedback Device",
             0x0500: "SB-3621 Motion Feedback Device",
             0x0510: "SB-3624 Motion Feedback Device",
             0x0801: "BU-65570I1 MIL-STD-1553 Test and Simulation",
             0x0802: "BU-65570I2 MIL-STD-1553 Test and Simulation",
             0x0811: "BU-65572I1 MIL-STD-1553 Test and Simulation",
             0x0812: "BU-65572I2 MIL-STD-1553 Test and Simulation",
             0x0881: "BU-65570T1 MIL-STD-1553 Test and Simulation",
             0x0882: "BU-65570T2 MIL-STD-1553 Test and Simulation",
             0x0891: "BU-65572T1 MIL-STD-1553 Test and Simulation",
             0x0892: "BU-65572T2 MIL-STD-1553 Test and Simulation",
             0x0901: "BU-65565C1 MIL-STD-1553 Data Bus",
             0x0902: "BU-65565C2 MIL-STD-1553 Data Bus",
             0x0903: "BU-65565C3 MIL-STD-1553 Data Bus",
             0x0904: "BU-65565C4 MIL-STD-1553 Data Bus",
             0x0B01: "BU-65569I1 MIL-STD-1553 Data Bus",
             0x0B02: "BU-65569I2 MIL-STD-1553 Data Bus",
             0x0B03: "BU-65569I3 MIL-STD-1553 Data Bus",
             0x0B04: "BU-65569I4 MIL-STD-1553 Data Bus",
             0x0D01: "SB-3641 Motion Feedback Device",
             0x0D10: "SB-365x Motion Feedback Device",
             0x2F00: "SB-3642 Motion Feedback Device",
             0x3000: "SB-3644 Motion Feedback Device",
             },

    # Animation Technologies Inc.
    0x5168: {0x0300: "FlyDVB-S",
             0x0301: "FlyDVB-T",
             },

    # S3 Graphics Ltd.
    0x5333: {0x0551: "Plato/PX (system)",
             0x5631: "86c325 [ViRGE]",
             0x8800: "86c866 [Vision 866]",
             0x8801: "86c964 [Vision 964]",
             0x8810: "86c764_0 [Trio 32 vers 0]",
             0x8811: "86c764/765 [Trio32/64/64V+]",
             0x8812: "86cM65 [Aurora64V+]",
             0x8813: "86c764_3 [Trio 32/64 vers 3]",
             0x8814: "86c767 [Trio 64UV+]",
             0x8815: "86cM65 [Aurora 128]",
             0x883D: "86c988 [ViRGE/VX]",
             0x8870: "FireGL",
             0x8880: "86c868 [Vision 868 VRAM] vers 0",
             0x8881: "86c868 [Vision 868 VRAM] vers 1",
             0x8882: "86c868 [Vision 868 VRAM] vers 2",
             0x8883: "86c868 [Vision 868 VRAM] vers 3",
             0x88B0: "86c928 [Vision 928 VRAM] vers 0",
             0x88B1: "86c928 [Vision 928 VRAM] vers 1",
             0x88B2: "86c928 [Vision 928 VRAM] vers 2",
             0x88B3: "86c928 [Vision 928 VRAM] vers 3",
             0x88C0: "86c864 [Vision 864 DRAM] vers 0",
             0x88C1: "86c864 [Vision 864 DRAM] vers 1",
             0x88C2: "86c864 [Vision 864-P DRAM] vers 2",
             0x88C3: "86c864 [Vision 864-P DRAM] vers 3",
             0x88D0: "86c964 [Vision 964 VRAM] vers 0",
             0x88D1: "86c964 [Vision 964 VRAM] vers 1",
             0x88D2: "86c964 [Vision 964-P VRAM] vers 2",
             0x88D3: "86c964 [Vision 964-P VRAM] vers 3",
             0x88F0: "86c968 [Vision 968 VRAM] rev 0",
             0x88F1: "86c968 [Vision 968 VRAM] rev 1",
             0x88F2: "86c968 [Vision 968 VRAM] rev 2",
             0x88F3: "86c968 [Vision 968 VRAM] rev 3",
             0x8900: "86c755 [Trio 64V2/DX]",
             0x8901: "86c775/86c785 [Trio 64V2/DX or /GX]",
             0x8902: "Plato/PX",
             0x8903: "Trio 3D business multimedia",
             0x8904: "86c365, 86c366 [Trio 3D]",
             0x8905: "Trio 64V+ family",
             0x8906: "Trio 64V+ family",
             0x8907: "Trio 64V+ family",
             0x8908: "Trio 64V+ family",
             0x8909: "Trio 64V+ family",
             0x890A: "Trio 64V+ family",
             0x890B: "Trio 64V+ family",
             0x890C: "Trio 64V+ family",
             0x890D: "Trio 64V+ family",
             0x890E: "Trio 64V+ family",
             0x890F: "Trio 64V+ family",
             0x8A01: "86c375 [ViRGE/DX] or 86c385 [ViRGE/GX]",
             0x8A10: "ViRGE/GX2",
             0x8A13: "86c360 [Trio 3D/1X], 86c362, 86c368 [Trio 3D/2X]",
             0x8A20: "86c794 [Savage 3D]",
             0x8A21: "86c390 [Savage 3D/MV]",
             0x8A22: "Savage 4",
             0x8A23: "Savage 4",
             0x8A25: "ProSavage PM133",
             0x8A26: "ProSavage KM133",
             0x8C00: "ViRGE/M3",
             0x8C01: "ViRGE/MX",
             0x8C02: "ViRGE/MX+",
             0x8C03: "ViRGE/MX+MV",
             0x8C10: "86C270-294 [SavageMX-MV]",
             0x8C11: "82C270-294 [SavageMX]",
             0x8C12: "86C270-294 [SavageIX-MV]",
             0x8C13: "86C270-294 [SavageIX]",
             0x8C22: "SuperSavage MX/128",
             0x8C24: "SuperSavage MX/64",
             0x8C26: "SuperSavage MX/64C",
             0x8C2A: "SuperSavage IX/128 SDR",
             0x8C2B: "SuperSavage IX/128 DDR",
             0x8C2C: "SuperSavage IX/64 SDR",
             0x8C2D: "SuperSavage IX/64 DDR",
             0x8C2E: "SuperSavage IX/C SDR",
             0x8C2F: "SuperSavage IX/C DDR",
             0x8D01: "86C380 [ProSavageDDR K4M266]",
             0x8D02: "VT8636A [ProSavage KN133] AGP4X VGA Controller (TwisterK)",
             0x8D03: "VT8751 [ProSavageDDR P4M266]",
             0x8D04: "VT8375 [ProSavage8 KM266/KL266]",
             0x8E00: "DeltaChrome",
             0x8E26: "ProSavage",
             0x8E40: "2300E Graphics Processor",
             0x8E48: "Matrix [Chrome S25 / S27]",
             0x9043: "Chrome 430 GT",
             0x9045: "Chrome 430 ULP / 435 ULP / 440 GTX",
             0x9060: "Chrome 530 GT",
             0x9102: "86C410 [Savage 2000]",
             0xCA00: "SonicVibes",
             },

    # Genroco, Inc
    0x5555: {0x0003: "TURBOstor HFP-832 [HiPPI NIC]",
             0x3B00: "Epiphan DVI2PCIe video capture card",
             },

    # Exacq Technologies
    0x5851: {0x8008: "tDVR8008 8-port video capture card",
             0x8016: "tDVR8016 16-chan video capture card",
             0x8032: "tDVR8032 32-chan video capture card",
             },

    # XenSource, Inc.
    0x5853: {0x0001: "Xen Platform Device",
             0xC000: "Citrix XenServer PCI Device for Windows Update",
             0xC110: "Virtualized HID",
             0xC147: "Virtualized Graphics Device",
             0xC200: "XCP-ng Project PCI Device for Windows Update",
             },

    # SmartInfra Ltd
    0x631C: {0x1652: "PXI-1652 Signal Generator",
             0x2504: "PXI-2504 Signal Interrogator",
             },

    # Decision Computer International Co.
    0x6666: {0x0001: "PCCOM4",
             0x0002: "PCCOM8",
             0x0004: "PCCOM2",
             0x0101: "PCI 8255/8254 I/O Card",
             0x0200: "12-bit AD/DA Card",
             0x0201: "14-bit AD/DA Card",
             0x1011: "Industrial Card",
             0x1021: "8 photo couple 8 relay Card",
             0x1022: "4 photo couple 4 relay Card",
             0x1025: "16 photo couple 16 relay Card",
             0x4000: "WatchDog Card",
             },

    # Zycoo Co., Ltd
    0x6688: {0x1200: "CooVox TDM Analog Module",
             0x1400: "CooVOX TDM GSM Module",
             0x1600: "CooVOX TDM E1/T1 Module",
             0x1800: "CooVOX TDM BRI Module",
             },

    # Glenfly Tech Co., Ltd.
    0x6766: {0x3D00: "Arise-GT-10C0",
             0x3D02: "Arise1020",
             0x3D03: "Arise-GT-1040",
             0x3D04: "Arise1010",
             0x3D40: "Arise-GT-10C0 High Definition Audio Controller",
             0x3D41: "Arise1020 High Definition Audio Controller",
             },

    # pcHDTV
    0x7063: {0x2000: "HD-2000",
             0x3000: "HD-3000",
             0x5500: "HD5500 HDTV",
             },

    # HongQin (Beijing) Technology Co., Ltd.
    0x7526: {0x0082: "HQ SSD 1TB",
             0x0083: "HQ SSD 2TB M.2 NVMe",
             },

    # Quancom Electronic GmbH
    0x8008: {0x0010: "WDOG1 [PCI-Watchdog 1]",
             0x0011: "PWDOG2 [PCI-Watchdog 2]",
             0x0015: "Clock77/PCI & Clock77/PCIe (DCF-77 receiver)",
             },

    # Intel Corporation
    0x8086: {0x0007: "82379AB",
             0x0008: "Extended Express System Support Controller",
             0x0039: "21145 Fast Ethernet",
             0x0040: "Core Processor DRAM Controller",
             0x0041: "Core Processor PCI Express x16 Root Port",
             0x0042: "Core Processor Integrated Graphics Controller",
             0x0043: "Core Processor Secondary PCI Express Root Port",
             0x0044: "Core Processor DRAM Controller",
             0x0045: "Core Processor PCI Express x16 Root Port",
             0x0046: "Core Processor Integrated Graphics Controller",
             0x0047: "Core Processor Secondary PCI Express Root Port",
             0x0048: "Core Processor DRAM Controller",
             0x0049: "Core Processor PCI Express x16 Root Port",
             0x004A: "Core Processor Integrated Graphics Controller",
             0x004B: "Core Processor Secondary PCI Express Root Port",
             0x0050: "Core Processor Thermal Management Controller",
             0x0069: "Core Processor DRAM Controller",
             0x0082: "Centrino Advanced-N 6205 [Taylor Peak]",
             0x0083: "Centrino Wireless-N 1000 [Condor Peak]",
             0x0084: "Centrino Wireless-N 1000 [Condor Peak]",
             0x0085: "Centrino Advanced-N 6205 [Taylor Peak]",
             0x0087: "Centrino Advanced-N + WiMAX 6250 [Kilmer Peak]",
             0x0089: "Centrino Advanced-N + WiMAX 6250 [Kilmer Peak]",
             0x008A: "Centrino Wireless-N 1030 [Rainbow Peak]",
             0x008B: "Centrino Wireless-N 1030 [Rainbow Peak]",
             0x0090: "Centrino Advanced-N 6230 [Rainbow Peak]",
             0x0091: "Centrino Advanced-N 6230 [Rainbow Peak]",
             0x0100: "2nd Generation Core Processor Family DRAM Controller",
             0x0101: "Xeon E3-1200/2nd Generation Core Processor Family PCI Express Root Port",
             0x0102: "2nd Generation Core Processor Family Integrated Graphics Controller",
             0x0104: "2nd Generation Core Processor Family DRAM Controller",
             0x0105: "Xeon E3-1200/2nd Generation Core Processor Family PCI Express Root Port",
             0x0106: "2nd Generation Core Processor Family Integrated Graphics Controller",
             0x0108: "Xeon E3-1200 Processor Family DRAM Controller",
             0x0109: "Xeon E3-1200/2nd Generation Core Processor Family PCI Express Root Port",
             0x010A: "Xeon E3-1200 Processor Family Integrated Graphics Controller",
             0x010B: "Xeon E3-1200/2nd Generation Core Processor Family Integrated Graphics Controller",
             0x010C: "Xeon E3-1200/2nd Generation Core Processor Family DRAM Controller",
             0x010D: "Xeon E3-1200/2nd Generation Core Processor Family PCI Express Root Port",
             0x010E: "Xeon E3-1200/2nd Generation Core Processor Family Integrated Graphics Controller",
             0x0112: "2nd Generation Core Processor Family Integrated Graphics Controller",
             0x0116: "2nd Generation Core Processor Family Integrated Graphics Controller",
             0x0122: "2nd Generation Core Processor Family Integrated Graphics Controller",
             0x0126: "2nd Generation Core Processor Family Integrated Graphics Controller",
             0x0150: "Xeon E3-1200 v2/3rd Gen Core processor DRAM Controller",
             0x0151: "Xeon E3-1200 v2/3rd Gen Core processor PCI Express Root Port",
             0x0152: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller",
             0x0153: "3rd Gen Core Processor Thermal Subsystem",
             0x0154: "3rd Gen Core processor DRAM Controller",
             0x0155: "Xeon E3-1200 v2/3rd Gen Core processor PCI Express Root Port",
             0x0156: "3rd Gen Core processor Graphics Controller",
             0x0158: "Xeon E3-1200 v2/Ivy Bridge DRAM Controller",
             0x0159: "Xeon E3-1200 v2/3rd Gen Core processor PCI Express Root Port",
             0x015A: "Xeon E3-1200 v2/Ivy Bridge Graphics Controller",
             0x015C: "Xeon E3-1200 v2/3rd Gen Core processor DRAM Controller",
             0x015D: "Xeon E3-1200 v2/3rd Gen Core processor PCI Express Root Port",
             0x015E: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller",
             0x0162: "IvyBridge GT2 [HD Graphics 4000]",
             0x0166: "3rd Gen Core processor Graphics Controller",
             0x016A: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller",
             0x0172: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller",
             0x0176: "3rd Gen Core processor Graphics Controller",
             0x0201: "Arctic Sound",
             0x0284: "Comet Lake PCH-LP LPC Premium Controller/eSPI Controller",
             0x02A3: "Comet Lake PCH-LP SMBus Host Controller",
             0x02A4: "Comet Lake SPI (flash) Controller",
             0x02A6: "Comet Lake North Peak",
             0x02B0: "Comet Lake PCI Express Root Port #9",
             0x02B1: "Comet Lake PCI Express Root Port #10",
             0x02B3: "Comet Lake PCI Express Root Port #12",
             0x02B4: "Comet Lake PCI Express Root Port #13",
             0x02B8: "Comet Lake PCI Express Root Port #1",
             0x02BC: "Comet Lake PCI Express Root Port #5",
             0x02C5: "Comet Lake Serial IO I2C Host Controller",
             0x02C8: "Comet Lake PCH-LP cAVS",
             0x02D3: "Comet Lake SATA AHCI Controller",
             0x02E0: "Comet Lake Management Engine Interface",
             0x02E8: "Serial IO I2C Host Controller",
             0x02E9: "Comet Lake Serial IO I2C Host Controller",
             0x02EA: "Comet Lake PCH-LP LPSS: I2C Controller #2",
             0x02ED: "Comet Lake PCH-LP USB 3.1 xHCI Host Controller",
             0x02EF: "Comet Lake PCH-LP Shared SRAM",
             0x02F0: "Comet Lake PCH-LP CNVi WiFi",
             0x02F5: "Comet Lake PCH-LP SCS3",
             0x02F9: "Comet Lake Thermal Subsytem",
             0x02FC: "Comet Lake Integrated Sensor Solution",
             0x0309: "80303 I/O Processor PCI-to-PCI Bridge",
             0x030D: "80312 I/O Companion Chip PCI-to-PCI Bridge",
             0x0326: "6700/6702PXH I/OxAPIC Interrupt Controller A",
             0x0327: "6700PXH I/OxAPIC Interrupt Controller B",
             0x0329: "6700PXH PCI Express-to-PCI Bridge A",
             0x032A: "6700PXH PCI Express-to-PCI Bridge B",
             0x032C: "6702PXH PCI Express-to-PCI Bridge A",
             0x0330: "80332 [Dobson] I/O processor (A-Segment Bridge)",
             0x0331: "80332 [Dobson] I/O processor (A-Segment IOAPIC)",
             0x0332: "80332 [Dobson] I/O processor (B-Segment Bridge)",
             0x0333: "80332 [Dobson] I/O processor (B-Segment IOAPIC)",
             0x0334: "80332 [Dobson] I/O processor (ATU)",
             0x0335: "80331 [Lindsay] I/O processor (PCI-X Bridge)",
             0x0336: "80331 [Lindsay] I/O processor (ATU)",
             0x0340: "41210 [Lanai] Serial to Parallel PCI Bridge (A-Segment Bridge)",
             0x0341: "41210 [Lanai] Serial to Parallel PCI Bridge (B-Segment Bridge)",
             0x0370: "80333 Segment-A PCIe Express to PCI-X bridge",
             0x0371: "80333 A-Bus IOAPIC",
             0x0372: "80333 Segment-B PCIe Express to PCI-X bridge",
             0x0373: "80333 B-Bus IOAPIC",
             0x0374: "80333 Address Translation Unit",
             0x0402: "Xeon E3-1200 v3/4th Gen Core Processor Integrated Graphics Controller",
             0x0406: "Haswell Integrated Graphics Controller",
             0x040A: "Xeon E3-1200 v3 Processor Integrated Graphics Controller",
             0x0412: "Xeon E3-1200 v3/4th Gen Core Processor Integrated Graphics Controller",
             0x0416: "4th Gen Core Processor Integrated Graphics Controller",
             0x041A: "Xeon E3-1200 v3 Processor Integrated Graphics Controller",
             0x041E: "4th Generation Core Processor Family Integrated Graphics Controller",
             0x0434: "DH89XXCC Series QAT",
             0x0435: "DH895XCC Series QAT",
             0x0436: "DH8900CC Null Device",
             0x0438: "DH8900CC Series Gigabit Network Connection",
             0x043A: "DH8900CC Series Gigabit Fiber Network Connection",
             0x043C: "DH8900CC Series Gigabit Backplane Network Connection",
             0x0440: "DH8900CC Series Gigabit SFP Network Connection",
             0x0442: "DH89XXCC Series QAT Virtual Function",
             0x0443: "DH895XCC Series QAT Virtual Function",
             0x0482: "82375EB/SB PCI to EISA Bridge",
             0x0483: "82424TX/ZX [Saturn] CPU to PCI bridge",
             0x0484: "82378ZB/IB, 82379AB (SIO, SIO.A) PCI to ISA Bridge",
             0x0486: "82425EX/ZX [Aries] PCIset with ISA bridge",
             0x04A3: "82434LX/NX [Mercury/Neptune] Processor to PCI bridge",
             0x04D0: "82437FX [Triton FX]",
             0x0500: "E8870 Processor bus control",
             0x0501: "E8870 Memory controller",
             0x0502: "E8870 Scalability Port 0",
             0x0503: "E8870 Scalability Port 1",
             0x0510: "E8870IO Hub Interface Port 0 registers (8-bit compatibility port)",
             0x0511: "E8870IO Hub Interface Port 1 registers",
             0x0512: "E8870IO Hub Interface Port 2 registers",
             0x0513: "E8870IO Hub Interface Port 3 registers",
             0x0514: "E8870IO Hub Interface Port 4 registers",
             0x0515: "E8870IO General SIOH registers",
             0x0516: "E8870IO RAS registers",
             0x0530: "E8870SP Scalability Port 0 registers",
             0x0531: "E8870SP Scalability Port 1 registers",
             0x0532: "E8870SP Scalability Port 2 registers",
             0x0533: "E8870SP Scalability Port 3 registers",
             0x0534: "E8870SP Scalability Port 4 registers",
             0x0535: "E8870SP Scalability Port 5 registers",
             0x0536: "E8870SP Interleave registers 0 and 1",
             0x0537: "E8870SP Interleave registers 2 and 3",
             0x0600: "RAID Controller",
             0x061F: "80303 I/O Processor",
             0x0684: "H470 Chipset LPC/eSPI Controller",
             0x0685: "Z490 Chipset LPC/eSPI Controller",
             0x0687: "Q470 Chipset LPC/eSPI Controller",
             0x068D: "Comet Lake LPC Controller",
             0x06A3: "Comet Lake PCH SMBus Controller",
             0x06A4: "Comet Lake PCH SPI Controller",
             0x06A8: "Comet Lake PCH Serial IO UART Host Controller #0",
             0x06A9: "Comet Lake PCH Serial IO UART Host Controller #1",
             0x06AA: "Comet Lake PCH Serial IO SPI Controller #0",
             0x06AB: "Comet Lake PCH Serial IO SPI Controller #1",
             0x06AC: "Comet Lake PCI Express Root Port #21",
             0x06B0: "Comet Lake PCI Express Root Port #9",
             0x06BA: "Comet Lake PCI Express Root Port #1",
             0x06BB: "Comet Lake PCI Express Root Port #4",
             0x06BD: "Comet Lake PCIe Port #6",
             0x06BF: "Comet Lake PCIe Port #8",
             0x06C0: "Comet Lake PCI Express Root Port #17",
             0x06C8: "Comet Lake PCH cAVS",
             0x06D2: "Comet Lake SATA AHCI Controller",
             0x06D6: "Comet Lake PCH-H RAID",
             0x06D7: "Comet Lake PCH-H RAID",
             0x06E0: "Comet Lake HECI Controller",
             0x06E3: "Comet Lake Keyboard and Text (KT) Redirection",
             0x06E8: "Comet Lake PCH Serial IO I2C Controller #0",
             0x06E9: "Comet Lake PCH Serial IO I2C Controller #1",
             0x06EA: "Comet Lake PCH Serial IO I2C Controller #2",
             0x06EB: "Comet Lake PCH Serial IO I2C Controller #3",
             0x06ED: "Comet Lake USB 3.1 xHCI Host Controller",
             0x06EF: "Comet Lake PCH Shared SRAM",
             0x06F0: "Comet Lake PCH CNVi WiFi",
             0x06F9: "Comet Lake PCH Thermal Controller",
             0x06FB: "Comet Lake PCH Serial IO SPI Controller #2",
             0x0700: "CE Media Processor A/V Bridge",
             0x0701: "CE Media Processor NAND Flash Controller",
             0x0703: "CE Media Processor Media Control Unit 1",
             0x0704: "CE Media Processor Video Capture Interface",
             0x0707: "CE Media Processor SPI Slave",
             0x0708: "Atom Processor CE 4100",
             0x0709: "Atom Processor CE 4200",
             0x0800: "Moorestown SPI Ctrl 0",
             0x0801: "Moorestown SPI Ctrl 1",
             0x0802: "Moorestown I2C 0",
             0x0803: "Moorestown I2C 1",
             0x0804: "Moorestown I2C 2",
             0x0805: "Moorestown Keyboard Ctrl",
             0x0806: "Moorestown USB Ctrl",
             0x0807: "Moorestown SD Host Ctrl 0",
             0x0808: "Moorestown SD Host Ctrl 1",
             0x0809: "Moorestown NAND Ctrl",
             0x080A: "Moorestown Audio Ctrl",
             0x080B: "Moorestown ISP",
             0x080C: "Moorestown Security Controller",
             0x080D: "Moorestown External Displays",
             0x080E: "Moorestown SCU IPC",
             0x080F: "Moorestown GPIO Controller",
             0x0810: "Moorestown Power Management Unit",
             0x0811: "Moorestown OTG Ctrl",
             0x0812: "Moorestown SPI Ctrl 2",
             0x0813: "Moorestown SC DMA",
             0x0814: "Moorestown LPE DMA",
             0x0815: "Moorestown SSP0",
             0x0817: "Medfield Serial IO I2C Controller #3",
             0x0818: "Medfield Serial IO I2C Controller #4",
             0x0819: "Medfield Serial IO I2C Controller #5",
             0x081A: "Medfield GPIO Controller [Core]",
             0x081B: "Medfield Serial IO HSUART Controller #1",
             0x081C: "Medfield Serial IO HSUART Controller #2",
             0x081D: "Medfield Serial IO HSUART Controller #3",
             0x081E: "Medfield Serial IO HSUART DMA Controller",
             0x081F: "Medfield GPIO Controller [AON]",
             0x0820: "Medfield SD Host Controller",
             0x0821: "Medfield SDIO Controller #1",
             0x0822: "Medfield SDIO Controller #2",
             0x0823: "Medfield eMMC Controller #0",
             0x0824: "Medfield eMMC Controller #1",
             0x0827: "Medfield Serial IO DMA Controller",
             0x0828: "Medfield Power Management Unit",
             0x0829: "Medfield USB Device Controller (OTG)",
             0x082A: "Medfield SCU IPC",
             0x082C: "Medfield Serial IO I2C Controller #0",
             0x082D: "Medfield Serial IO I2C Controller #1",
             0x082E: "Medfield Serial IO I2C Controller #2",
             0x0885: "Centrino Wireless-N + WiMAX 6150",
             0x0886: "Centrino Wireless-N + WiMAX 6150",
             0x0887: "Centrino Wireless-N 2230",
             0x0888: "Centrino Wireless-N 2230",
             0x088E: "Centrino Advanced-N 6235",
             0x088F: "Centrino Advanced-N 6235",
             0x0890: "Centrino Wireless-N 2200",
             0x0891: "Centrino Wireless-N 2200",
             0x0892: "Centrino Wireless-N 135",
             0x0893: "Centrino Wireless-N 135",
             0x0894: "Centrino Wireless-N 105",
             0x0895: "Centrino Wireless-N 105",
             0x0896: "Centrino Wireless-N 130",
             0x0897: "Centrino Wireless-N 130",
             0x08A7: "Quark SoC X1000 SDIO / eMMC Controller",
             0x08AE: "Centrino Wireless-N 100",
             0x08AF: "Centrino Wireless-N 100",
             0x08B1: "Wireless 7260",
             0x08B2: "Wireless 7260",
             0x08B3: "Wireless 3160",
             0x08B4: "Wireless 3160",
             0x08CF: "Atom Processor Z2760 Integrated Graphics Controller",
             0x0931: "Atom Processor CE 2600 [Puma 6]",
             0x0934: "Quark SoC X1000 I2C Controller and GPIO Controller",
             0x0935: "Quark SoC X1000 SPI Controller",
             0x0936: "Quark SoC X1000 HS-UART",
             0x0937: "Quark SoC X1000 10/100 Ethernet MAC",
             0x0939: "Quark SoC X1000 USB EHCI Host Controller / USB 2.0 Device",
             0x093A: "Quark SoC X1000 USB OHCI Host Controller",
             0x0953: "PCIe Data Center SSD",
             0x0958: "Quark SoC X1000 Host Bridge",
             0x095A: "Wireless 7265",
             0x095B: "Wireless 7265",
             0x095E: "Quark SoC X1000 Legacy Bridge",
             0x0960: "80960RP (i960RP) Microprocessor/Bridge",
             0x0962: "80960RM (i960RM) Bridge",
             0x0964: "80960RP (i960RP) Microprocessor/Bridge",
             0x0998: "Ice Lake IEH",
             0x09A2: "Ice Lake Memory Map/VT-d",
             0x09A3: "Ice Lake RAS",
             0x09A4: "Ice Lake Mesh 2 PCIe",
             0x09A6: "Ice Lake MSM",
             0x09A7: "Ice Lake PMON MSM",
             0x09AB: "RST VMD Managed Controller",
             0x09C4: "PAC with Intel Arria 10 GX FPGA",
             0x0A03: "Haswell-ULT Thermal Subsystem",
             0x0A04: "Haswell-ULT DRAM Controller",
             0x0A06: "Haswell-ULT Integrated Graphics Controller",
             0x0A0C: "Haswell-ULT HD Audio Controller",
             0x0A16: "Haswell-ULT Integrated Graphics Controller",
             0x0A22: "Haswell-ULT Integrated Graphics Controller",
             0x0A26: "Haswell-ULT Integrated Graphics Controller",
             0x0A2A: "Haswell-ULT Integrated Graphics Controller",
             0x0A2E: "Haswell-ULT Integrated Graphics Controller",
             0x0A53: "DC P3520 SSD",
             0x0A54: "NVMe Datacenter SSD [3DNAND, Beta Rock Controller]",
             0x0A55: "NVMe DC SSD [3DNAND, Beta Rock Controller]",
             0x0B00: "Ice Lake CBDMA [QuickData Technology]",
             0x0B26: "Thunderbolt 4 Bridge [Goshen Ridge 2020]",
             0x0B27: "Thunderbolt 4 USB Controller [Goshen Ridge 2020]",
             0x0B2B: "PAC with Intel Stratix 10 SX FPGA [FPGA PAC D5005]",
             0x0B60: "NVMe DC SSD [3DNAND, Sentinel Rock Controller]",
             0x0BD0: "Ponte Vecchio XL (2 Tile)",
             0x0BD5: "Ponte Vecchio XT (2 Tile) [Data Center GPU Max 1550]",
             0x0BD6: "Ponte Vecchio XT (2 Tile) [Data Center GPU Max 1550]",
             0x0BD7: "Ponte Vecchio XT (2 Tile) [Data Center GPU Max 1350]",
             0x0BD8: "Ponte Vecchio XT (2 Tile) [Data Center GPU Max 1350]",
             0x0BD9: "Ponte Vecchio XT (1 Tile) [Data Center GPU Max 1100]",
             0x0BDA: "Ponte Vecchio XT (1 Tile) [Data Center GPU Max 1100]",
             0x0BDB: "Ponte Vecchio XT (1 Tile) [Data Center GPU Max 1100]",
             0x0BE0: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BE1: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BE2: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BE3: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BE4: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BE5: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BE6: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BE7: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BE8: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BE9: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BEA: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BEB: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BEC: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BED: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BEE: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BEF: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller",
             0x0BF0: "Atom Processor D2xxx/N2xxx DRAM Controller",
             0x0BF1: "Atom Processor D2xxx/N2xxx DRAM Controller",
             0x0BF2: "Atom Processor D2xxx/N2xxx DRAM Controller",
             0x0BF3: "Atom Processor D2xxx/N2xxx DRAM Controller",
             0x0BF4: "Atom Processor D2xxx/N2xxx DRAM Controller",
             0x0BF5: "Atom Processor D2xxx/N2xxx DRAM Controller",
             0x0BF6: "Atom Processor D2xxx/N2xxx DRAM Controller",
             0x0BF7: "Atom Processor D2xxx/N2xxx DRAM Controller",
             0x0C00: "4th Gen Core Processor DRAM Controller",
             0x0C01: "Xeon E3-1200 v3/4th Gen Core Processor PCI Express x16 Controller",
             0x0C04: "Xeon E3-1200 v3/4th Gen Core Processor DRAM Controller",
             0x0C05: "Xeon E3-1200 v3/4th Gen Core Processor PCI Express x8 Controller",
             0x0C08: "Xeon E3-1200 v3 Processor DRAM Controller",
             0x0C09: "Xeon E3-1200 v3/4th Gen Core Processor PCI Express x4 Controller",
             0x0C0C: "Xeon E3-1200 v3/4th Gen Core Processor HD Audio Controller",
             0x0C40: "Atom Processor CE 5300",
             0x0C46: "Atom Processor S1200 PCI Express Root Port 1",
             0x0C47: "Atom Processor S1200 PCI Express Root Port 2",
             0x0C48: "Atom Processor S1200 PCI Express Root Port 3",
             0x0C49: "Atom Processor S1200 PCI Express Root Port 4",
             0x0C4E: "Atom Processor S1200 NTB Primary",
             0x0C50: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QuickData Technology Device",
             0x0C51: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QuickData Technology Device",
             0x0C52: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QuickData Technology Device",
             0x0C53: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QuickData Technology Device",
             0x0C54: "Atom Processor S1200 Internal",
             0x0C55: "Atom Processor S1200 DFX 1",
             0x0C56: "Atom Processor S1200 DFX 2",
             0x0C59: "Atom Processor S1200 SMBus 2.0 Controller 0",
             0x0C5A: "Atom Processor S1200 SMBus 2.0 Controller 1",
             0x0C5B: "Atom Processor S1200 SMBus Controller 2",
             0x0C5C: "Atom Processor S1200 SMBus Controller 3",
             0x0C5D: "Atom Processor S1200 SMBus Controller 4",
             0x0C5E: "Atom Processor S1200 SMBus Controller 5",
             0x0C5F: "Atom Processor S1200 UART",
             0x0C60: "Atom Processor S1200 Integrated Legacy Bus",
             0x0C70: "Atom Processor S1200 Internal",
             0x0C71: "Atom Processor S1200 Internal",
             0x0C72: "Atom Processor S1200 Internal",
             0x0C73: "Atom Processor S1200 Internal",
             0x0C74: "Atom Processor S1200 Internal",
             0x0C75: "Atom Processor S1200 Internal",
             0x0C76: "Atom Processor S1200 Internal",
             0x0C77: "Atom Processor S1200 Internal",
             0x0C78: "Atom Processor S1200 Internal",
             0x0C79: "Atom Processor S1200 Internal",
             0x0C7A: "Atom Processor S1200 Internal",
             0x0C7B: "Atom Processor S1200 Internal",
             0x0C7C: "Atom Processor S1200 Internal",
             0x0C7D: "Atom Processor S1200 Internal",
             0x0C7E: "Atom Processor S1200 Internal",
             0x0C7F: "Atom Processor S1200 Internal",
             0x0CF8: "Ethernet Controller X710 Intel(R) FPGA Programmable Acceleration Card N3000 for Networking",
             0x0D00: "Crystal Well DRAM Controller",
             0x0D01: "Crystal Well PCI Express x16 Controller",
             0x0D04: "Crystal Well DRAM Controller",
             0x0D05: "Crystal Well PCI Express x8 Controller",
             0x0D09: "Crystal Well PCI Express x4 Controller",
             0x0D0C: "Crystal Well HD Audio Controller",
             0x0D16: "Crystal Well Integrated Graphics Controller",
             0x0D26: "Crystal Well Integrated Graphics Controller",
             0x0D36: "Crystal Well Integrated Graphics Controller",
             0x0D4C: "Ethernet Connection (11) I219-LM",
             0x0D4D: "Ethernet Connection (11) I219-V",
             0x0D4E: "Ethernet Connection (10) I219-LM",
             0x0D4F: "Ethernet Connection (10) I219-V",
             0x0D53: "Ethernet Connection (12) I219-LM",
             0x0D55: "Ethernet Connection (12) I219-V",
             0x0D58: "Ethernet Controller XXV710 Intel(R) FPGA Programmable Acceleration Card N3000 for Networking",
             0x0D9F: "Ethernet Controller (2) I225-IT",
             0x0DCD: "Ethernet Connection C825-X",
             0x0DD2: "Ethernet Network Adapter I710",
             0x0DD5: "Ethernet Adaptive Virtual Function",
             0x0DDA: "Ethernet Connection X722 for 10GbE SFP+",
             0x0E00: "Xeon E7 v2/Xeon E5 v2/Core i7 DMI2",
             0x0E01: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port in DMI2 Mode",
             0x0E02: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 1a",
             0x0E03: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 1b",
             0x0E04: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 2a",
             0x0E05: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 2b",
             0x0E06: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 2c",
             0x0E07: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 2d",
             0x0E08: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 3a",
             0x0E09: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 3b",
             0x0E0A: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 3c",
             0x0E0B: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 3d",
             0x0E10: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers",
             0x0E13: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers",
             0x0E17: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers",
             0x0E18: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers",
             0x0E1C: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers",
             0x0E1D: "Xeon E7 v2/Xeon E5 v2/Core i7 R2PCIe",
             0x0E1E: "Xeon E7 v2/Xeon E5 v2/Core i7 UBOX Registers",
             0x0E1F: "Xeon E7 v2/Xeon E5 v2/Core i7 UBOX Registers",
             0x0E20: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 0",
             0x0E21: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 1",
             0x0E22: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 2",
             0x0E23: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 3",
             0x0E24: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 4",
             0x0E25: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 5",
             0x0E26: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 6",
             0x0E27: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 7",
             0x0E28: "Xeon E7 v2/Xeon E5 v2/Core i7 VTd/Memory Map/Misc",
             0x0E29: "Xeon E7 v2/Xeon E5 v2/Core i7 Memory Hotplug",
             0x0E2A: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO RAS",
             0x0E2C: "Xeon E7 v2/Xeon E5 v2/Core i7 IOAPIC",
             0x0E2E: "Xeon E7 v2/Xeon E5 v2/Core i7 CBDMA",
             0x0E2F: "Xeon E7 v2/Xeon E5 v2/Core i7 CBDMA",
             0x0E30: "Xeon E7 v2/Xeon E5 v2/Core i7 Home Agent 0",
             0x0E32: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 0",
             0x0E33: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 1",
             0x0E34: "Xeon E7 v2/Xeon E5 v2/Core i7 R2PCIe",
             0x0E36: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Performance Ring Monitoring",
             0x0E37: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Performance Ring Monitoring",
             0x0E38: "Xeon E7 v2/Xeon E5 v2/Core i7 Home Agent 1",
             0x0E3A: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 2",
             0x0E3E: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Performance Ring Monitoring",
             0x0E3F: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Performance Ring Monitoring",
             0x0E40: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 2",
             0x0E41: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Registers",
             0x0E43: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 2",
             0x0E44: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 2",
             0x0E45: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Agent Register",
             0x0E47: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Agent Register",
             0x0E60: "Xeon E7 v2/Xeon E5 v2/Core i7 Home Agent 1",
             0x0E68: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Target Address/Thermal Registers",
             0x0E6A: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder Registers",
             0x0E6B: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder Registers",
             0x0E6C: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder Registers",
             0x0E6D: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder Registers",
             0x0E71: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 RAS Registers",
             0x0E74: "Xeon E7 v2/Xeon E5 v2/Core i7 R2PCIe",
             0x0E75: "Xeon E7 v2/Xeon E5 v2/Core i7 R2PCIe",
             0x0E77: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Registers",
             0x0E79: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 RAS Registers",
             0x0E7D: "Xeon E7 v2/Xeon E5 v2/Core i7 UBOX Registers",
             0x0E7F: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Registers",
             0x0E80: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 0",
             0x0E81: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Registers",
             0x0E83: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 0",
             0x0E84: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 0",
             0x0E85: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Agent Register",
             0x0E87: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Registers",
             0x0E90: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 1",
             0x0E93: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 1",
             0x0E94: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 1",
             0x0E95: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Agent Register",
             0x0EA0: "Xeon E7 v2/Xeon E5 v2/Core i7 Home Agent 0",
             0x0EA8: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Target Address/Thermal Registers",
             0x0EAA: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder Registers",
             0x0EAB: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder Registers",
             0x0EAC: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder Registers",
             0x0EAD: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder Registers",
             0x0EAE: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers",
             0x0EAF: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers",
             0x0EB0: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 Thermal Control 0",
             0x0EB1: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 Thermal Control 1",
             0x0EB2: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 ERROR Registers 0",
             0x0EB3: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 ERROR Registers 1",
             0x0EB4: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 Thermal Control 2",
             0x0EB5: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 Thermal Control 3",
             0x0EB6: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 ERROR Registers 2",
             0x0EB7: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 ERROR Registers 3",
             0x0EBC: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers",
             0x0EBE: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers",
             0x0EBF: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers",
             0x0EC0: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 0",
             0x0EC1: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 1",
             0x0EC2: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 2",
             0x0EC3: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 3",
             0x0EC4: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 4",
             0x0EC8: "Xeon E7 v2/Xeon E5 v2/Core i7 System Address Decoder",
             0x0EC9: "Xeon E7 v2/Xeon E5 v2/Core i7 Broadcast Registers",
             0x0ECA: "Xeon E7 v2/Xeon E5 v2/Core i7 Broadcast Registers",
             0x0ED8: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO",
             0x0ED9: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO",
             0x0EDC: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO",
             0x0EDD: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO",
             0x0EDE: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO",
             0x0EDF: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO",
             0x0EE0: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EE1: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EE2: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EE3: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EE4: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EE5: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EE6: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EE7: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EE8: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EE9: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EEA: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EEB: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EEC: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EED: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EEE: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers",
             0x0EF0: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 Thermal Control 0",
             0x0EF1: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 Thermal Control 1",
             0x0EF2: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 ERROR Registers 0",
             0x0EF3: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 ERROR Registers 1",
             0x0EF4: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 Thermal Control 2",
             0x0EF5: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 Thermal Control 3",
             0x0EF6: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 ERROR Registers 2",
             0x0EF7: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 ERROR Registers 3",
             0x0EF8: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO",
             0x0EF9: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO",
             0x0EFA: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO",
             0x0EFB: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO",
             0x0EFC: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO",
             0x0EFD: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO",
             0x0F00: "Atom Processor Z36xxx/Z37xxx Series SoC Transaction Register",
             0x0F04: "Atom Processor Z36xxx/Z37xxx Series High Definition Audio Controller",
             0x0F06: "Atom Processor Z36xxx/Z37xxx Series LPIO1 DMA Controller",
             0x0F08: "Atom Processor Z36xxx/Z37xxx Series LPIO1 PWM Controller",
             0x0F09: "Atom Processor Z36xxx/Z37xxx Series LPIO1 PWM Controller",
             0x0F0A: "Atom Processor Z36xxx/Z37xxx Series LPIO1 HSUART Controller #1",
             0x0F0C: "Atom Processor Z36xxx/Z37xxx Series LPIO1 HSUART Controller #2",
             0x0F0E: "Atom Processor Z36xxx/Z37xxx Series LPIO1 SPI Controller",
             0x0F12: "Atom Processor E3800/CE2700 Series SMBus Controller",
             0x0F14: "Atom Processor Z36xxx/Z37xxx Series SDIO Controller",
             0x0F15: "Atom Processor Z36xxx/Z37xxx Series SDIO Controller",
             0x0F16: "Atom Processor Z36xxx/Z37xxx Series SDIO Controller",
             0x0F18: "Atom Processor Z36xxx/Z37xxx Series Trusted Execution Engine",
             0x0F1C: "Atom Processor Z36xxx/Z37xxx Series Power Control Unit",
             0x0F20: "Atom Processor E3800 Series SATA IDE Controller",
             0x0F21: "Atom Processor E3800 Series SATA IDE Controller",
             0x0F22: "Atom Processor E3800 Series SATA AHCI Controller",
             0x0F23: "Atom Processor E3800 Series SATA AHCI Controller",
             0x0F28: "Atom Processor Z36xxx/Z37xxx Series LPE Audio Controller",
             0x0F31: "Atom Processor Z36xxx/Z37xxx Series Graphics & Display",
             0x0F34: "Atom Processor Z36xxx/Z37xxx Series USB EHCI",
             0x0F35: "Atom Processor Z36xxx/Z37xxx, Celeron N2000 Series USB xHCI",
             0x0F37: "Atom Processor Z36xxx/Z37xxx Series OTG USB Device",
             0x0F38: "Atom Processor Z36xxx/Z37xxx Series Camera ISP",
             0x0F40: "Atom Processor Z36xxx/Z37xxx Series LPIO2 DMA Controller",
             0x0F41: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #1",
             0x0F42: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #2",
             0x0F43: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #3",
             0x0F44: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #4",
             0x0F45: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #5",
             0x0F46: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #6",
             0x0F47: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #7",
             0x0F48: "Atom Processor E3800 Series PCI Express Root Port 1",
             0x0F4A: "Atom Processor E3800 Series PCI Express Root Port 2",
             0x0F4C: "Atom Processor E3800 Series PCI Express Root Port 3",
             0x0F4E: "Atom Processor E3800 Series PCI Express Root Port 4",
             0x0F50: "Atom Processor E3800 Series eMMC 4.5 Controller",
             0x1000: "82542 Gigabit Ethernet Controller (Fiber)",
             0x1001: "82543GC Gigabit Ethernet Controller (Fiber)",
             0x1002: "Pro 100 LAN+Modem 56 Cardbus II",
             0x1004: "82543GC Gigabit Ethernet Controller (Copper)",
             0x1008: "82544EI Gigabit Ethernet Controller (Copper)",
             0x1009: "82544EI Gigabit Ethernet Controller (Fiber)",
             0x100A: "82540EM Gigabit Ethernet Controller",
             0x100C: "82544GC Gigabit Ethernet Controller (Copper)",
             0x100D: "82544GC Gigabit Ethernet Controller (LOM)",
             0x100E: "82540EM Gigabit Ethernet Controller",
             0x100F: "82545EM Gigabit Ethernet Controller (Copper)",
             0x1010: "82546EB Gigabit Ethernet Controller (Copper)",
             0x1011: "82545EM Gigabit Ethernet Controller (Fiber)",
             0x1012: "82546EB Gigabit Ethernet Controller (Fiber)",
             0x1013: "82541EI Gigabit Ethernet Controller",
             0x1014: "82541ER Gigabit Ethernet Controller",
             0x1015: "82540EM Gigabit Ethernet Controller (LOM)",
             0x1016: "82540EP Gigabit Ethernet Controller (Mobile)",
             0x1017: "82540EP Gigabit Ethernet Controller",
             0x1018: "82541EI Gigabit Ethernet Controller",
             0x1019: "82547EI Gigabit Ethernet Controller",
             0x101A: "82547EI Gigabit Ethernet Controller (Mobile)",
             0x101D: "82546EB Gigabit Ethernet Controller",
             0x101E: "82540EP Gigabit Ethernet Controller (Mobile)",
             0x101F: "Ethernet Controller V710 for 5GBASE-T",
             0x1026: "82545GM Gigabit Ethernet Controller",
             0x1027: "82545GM Gigabit Ethernet Controller",
             0x1028: "82545GM Gigabit Ethernet Controller",
             0x1029: "82559 Ethernet Controller",
             0x1030: "82559 InBusiness 10/100",
             0x1031: "82801CAM (ICH3) PRO/100 VE (LOM) Ethernet Controller",
             0x1032: "82801CAM (ICH3) PRO/100 VE Ethernet Controller",
             0x1033: "82801CAM (ICH3) PRO/100 VM (LOM) Ethernet Controller",
             0x1034: "82801CAM (ICH3) PRO/100 VM Ethernet Controller",
             0x1035: "82801CAM (ICH3)/82562EH (LOM) Ethernet Controller",
             0x1036: "82801CAM (ICH3) 82562EH Ethernet Controller",
             0x1037: "82801CAM (ICH3) Chipset Ethernet Controller",
             0x1038: "82801CAM (ICH3) PRO/100 VM (KM) Ethernet Controller",
             0x1039: "82801DB PRO/100 VE (LOM) Ethernet Controller",
             0x103A: "82801DB PRO/100 VE (CNR) Ethernet Controller",
             0x103B: "82801DB PRO/100 VM (LOM) Ethernet Controller",
             0x103C: "82801DB PRO/100 VM (CNR) Ethernet Controller",
             0x103D: "82801DB PRO/100 VE (MOB) Ethernet Controller",
             0x103E: "82801DB PRO/100 VM (MOB) Ethernet Controller",
             0x1040: "536EP Data Fax Modem",
             0x1043: "PRO/Wireless LAN 2100 3B Mini PCI Adapter",
             0x1048: "82597EX 10GbE Ethernet Controller",
             0x1049: "82566MM Gigabit Network Connection",
             0x104A: "82566DM Gigabit Network Connection",
             0x104B: "82566DC Gigabit Network Connection",
             0x104C: "82562V 10/100 Network Connection",
             0x104D: "82566MC Gigabit Network Connection",
             0x104E: "Ethernet Controller X710 for 10 Gigabit SFP+",
             0x104F: "Ethernet Controller X710 for 10 Gigabit backplane",
             0x1050: "82562EZ 10/100 Ethernet Controller",
             0x1051: "82801EB/ER (ICH5/ICH5R) integrated LAN Controller",
             0x1052: "PRO/100 VM Network Connection",
             0x1053: "PRO/100 VM Network Connection",
             0x1054: "PRO/100 VE Network Connection",
             0x1055: "PRO/100 VM Network Connection",
             0x1056: "PRO/100 VE Network Connection",
             0x1057: "PRO/100 VE Network Connection",
             0x1059: "82551QM Ethernet Controller",
             0x105B: "82546GB Gigabit Ethernet Controller (Copper)",
             0x105E: "82571EB/82571GB Gigabit Ethernet Controller D0/D1 (copper applications)",
             0x105F: "82571EB Gigabit Ethernet Controller",
             0x1060: "82571EB Gigabit Ethernet Controller",
             0x1064: "82562ET/EZ/GT/GZ - PRO/100 VE (LOM) Ethernet Controller",
             0x1065: "82562ET/EZ/GT/GZ - PRO/100 VE Ethernet Controller",
             0x1066: "82562 EM/EX/GX - PRO/100 VM (LOM) Ethernet Controller",
             0x1067: "82562 EM/EX/GX - PRO/100 VM Ethernet Controller",
             0x1068: "82562ET/EZ/GT/GZ - PRO/100 VE (LOM) Ethernet Controller Mobile",
             0x1069: "82562EM/EX/GX - PRO/100 VM (LOM) Ethernet Controller Mobile",
             0x106A: "82562G - PRO/100 VE (LOM) Ethernet Controller",
             0x106B: "82562G - PRO/100 VE Ethernet Controller Mobile",
             0x1075: "82547GI Gigabit Ethernet Controller",
             0x1076: "82541GI Gigabit Ethernet Controller",
             0x1077: "82541GI Gigabit Ethernet Controller",
             0x1078: "82541ER Gigabit Ethernet Controller",
             0x1079: "82546GB Gigabit Ethernet Controller",
             0x107A: "82546GB Gigabit Ethernet Controller",
             0x107B: "82546GB Gigabit Ethernet Controller",
             0x107C: "82541PI Gigabit Ethernet Controller",
             0x107D: "82572EI Gigabit Ethernet Controller (Copper)",
             0x107E: "82572EI Gigabit Ethernet Controller (Fiber)",
             0x107F: "82572EI Gigabit Ethernet Controller",
             0x1080: "FA82537EP 56K V.92 Data/Fax Modem PCI",
             0x1081: "631xESB/632xESB LAN Controller Copper",
             0x1082: "631xESB/632xESB LAN Controller fiber",
             0x1083: "631xESB/632xESB LAN Controller SERDES",
             0x1084: "631xESB/632xESB IDE Redirection",
             0x1085: "631xESB/632xESB Serial Port Redirection",
             0x1086: "631xESB/632xESB IPMI/KCS0",
             0x1087: "631xESB/632xESB UHCI Redirection",
             0x1089: "631xESB/632xESB BT",
             0x108A: "82546GB Gigabit Ethernet Controller",
             0x108B: "82573V Gigabit Ethernet Controller (Copper)",
             0x108C: "82573E Gigabit Ethernet Controller (Copper)",
             0x108E: "82573E KCS (Active Management)",
             0x108F: "Active Management Technology - SOL",
             0x1091: "PRO/100 VM Network Connection",
             0x1092: "PRO/100 VE Network Connection",
             0x1093: "PRO/100 VM Network Connection",
             0x1094: "PRO/100 VE Network Connection",
             0x1095: "PRO/100 VE Network Connection",
             0x1096: "80003ES2LAN Gigabit Ethernet Controller (Copper)",
             0x1097: "631xESB/632xESB DPT LAN Controller (Fiber)",
             0x1098: "80003ES2LAN Gigabit Ethernet Controller (Serdes)",
             0x1099: "82546GB Gigabit Ethernet Controller (Copper)",
             0x109A: "82573L Gigabit Ethernet Controller",
             0x109B: "82546GB PRO/1000 GF Quad Port Server Adapter",
             0x109E: "82597EX 10GbE Ethernet Controller",
             0x10A0: "82571EB PRO/1000 AT Quad Port Bypass Adapter",
             0x10A1: "82571EB PRO/1000 AF Quad Port Bypass Adapter",
             0x10A4: "82571EB Gigabit Ethernet Controller",
             0x10A5: "82571EB Gigabit Ethernet Controller (Fiber)",
             0x10A6: "82599EB 10-Gigabit Dummy Function",
             0x10A7: "82575EB Gigabit Network Connection",
             0x10A9: "82575EB Gigabit Backplane Connection",
             0x10B0: "82573L PRO/1000 PL Network Connection",
             0x10B2: "82573V PRO/1000 PM Network Connection",
             0x10B3: "82573E PRO/1000 PM Network Connection",
             0x10B4: "82573L PRO/1000 PL Network Connection",
             0x10B5: "82546GB Gigabit Ethernet Controller (Copper)",
             0x10B6: "82598 10GbE PCI-Express Ethernet Controller",
             0x10B9: "82572EI Gigabit Ethernet Controller (Copper)",
             0x10BA: "80003ES2LAN Gigabit Ethernet Controller (Copper)",
             0x10BB: "80003ES2LAN Gigabit Ethernet Controller (Serdes)",
             0x10BC: "82571EB/82571GB Gigabit Ethernet Controller (Copper)",
             0x10BD: "82566DM-2 Gigabit Network Connection",
             0x10BF: "82567LF Gigabit Network Connection",
             0x10C0: "82562V-2 10/100 Network Connection",
             0x10C2: "82562G-2 10/100 Network Connection",
             0x10C3: "82562GT-2 10/100 Network Connection",
             0x10C4: "82562GT 10/100 Network Connection",
             0x10C5: "82562G 10/100 Network Connection",
             0x10C6: "82598EB 10-Gigabit AF Dual Port Network Connection",
             0x10C7: "82598EB 10-Gigabit AF Network Connection",
             0x10C8: "82598EB 10-Gigabit AT Network Connection",
             0x10C9: "82576 Gigabit Network Connection",
             0x10CA: "82576 Virtual Function",
             0x10CB: "82567V Gigabit Network Connection",
             0x10CC: "82567LM-2 Gigabit Network Connection",
             0x10CD: "82567LF-2 Gigabit Network Connection",
             0x10CE: "82567V-2 Gigabit Network Connection",
             0x10D3: "82574L Gigabit Network Connection",
             0x10D4: "Matrox Concord GE (customized Intel 82574)",
             0x10D5: "82571PT Gigabit PT Quad Port Server ExpressModule",
             0x10D6: "82575GB Gigabit Network Connection",
             0x10D8: "82599EB 10 Gigabit Unprogrammed",
             0x10D9: "82571EB Dual Port Gigabit Mezzanine Adapter",
             0x10DA: "82571EB Quad Port Gigabit Mezzanine Adapter",
             0x10DB: "82598EB 10-Gigabit Dual Port Network Connection",
             0x10DD: "82598EB 10-Gigabit AT CX4 Network Connection",
             0x10DE: "82567LM-3 Gigabit Network Connection",
             0x10DF: "82567LF-3 Gigabit Network Connection",
             0x10E1: "82598EB 10-Gigabit AF Dual Port Network Connection",
             0x10E2: "82575GB Gigabit Network Connection",
             0x10E5: "82567LM-4 Gigabit Network Connection",
             0x10E6: "82576 Gigabit Network Connection",
             0x10E7: "82576 Gigabit Network Connection",
             0x10E8: "82576 Gigabit Network Connection",
             0x10EA: "82577LM Gigabit Network Connection",
             0x10EB: "82577LC Gigabit Network Connection",
             0x10EC: "82598EB 10-Gigabit AT CX4 Network Connection",
             0x10ED: "82599 Ethernet Controller Virtual Function",
             0x10EF: "82578DM Gigabit Network Connection",
             0x10F0: "82578DC Gigabit Network Connection",
             0x10F1: "82598EB 10-Gigabit AF Dual Port Network Connection",
             0x10F4: "82598EB 10-Gigabit AF Network Connection",
             0x10F5: "82567LM Gigabit Network Connection",
             0x10F6: "82574L Gigabit Network Connection",
             0x10F7: "10 Gigabit BR KX4 Dual Port Network Connection",
             0x10F8: "82599 10 Gigabit Dual Port Backplane Connection",
             0x10F9: "82599 10 Gigabit Dual Port Network Connection",
             0x10FB: "82599ES 10-Gigabit SFI/SFP+ Network Connection",
             0x10FC: "82599 10 Gigabit Dual Port Network Connection",
             0x10FE: "82552 10/100 Network Connection",
             0x1107: "PRO/1000 MF Server Adapter (LX)",
             0x1130: "82815 815 Chipset Host Bridge and Memory Controller Hub",
             0x1131: "82815 815 Chipset AGP Bridge",
             0x1132: "82815 Chipset Graphics Controller (CGC)",
             0x1136: "Thunderbolt 4 Bridge [Maple Ridge 4C 2020]",
             0x1137: "Thunderbolt 4 NHI [Maple Ridge 4C 2020]",
             0x1138: "Thunderbolt 4 USB Controller [Maple Ridge 4C 2020]",
             0x1161: "82806AA PCI64 Hub Advanced Programmable Interrupt Controller",
             0x1162: "Xscale 80200 Big Endian Companion Chip",
             0x1190: "Merrifield SD/SDIO/eMMC Controller",
             0x1191: "Merrifield Serial IO HSUART Controller",
             0x1192: "Merrifield Serial IO HSUART DMA Controller",
             0x1194: "Merrifield Serial IO SPI Controller",
             0x1195: "Merrifield Serial IO I2C Controller",
             0x1196: "Merrifield Serial IO I2C Controller",
             0x1199: "Merrifield GPIO Controller",
             0x119E: "Merrifield USB Device Controller (OTG)",
             0x11A0: "Merrifield SCU IPC",
             0x11A1: "Merrifield Power Management Unit",
             0x11A2: "Merrifield Serial IO DMA Controller",
             0x11A5: "Merrifield Serial IO PWM Controller",
             0x11C3: "Quark SoC X1000 PCIe Root Port 0",
             0x11C4: "Quark SoC X1000 PCIe Root Port 1",
             0x1200: "IXP1200 Network Processor",
             0x1209: "8255xER/82551IT Fast Ethernet Controller",
             0x1221: "82092AA PCI to PCMCIA Bridge",
             0x1222: "82092AA IDE Controller",
             0x1223: "SAA7116",
             0x1225: "82452KX/GX [Orion]",
             0x1226: "82596 PRO/10 PCI",
             0x1227: "82865 EtherExpress PRO/100A",
             0x1228: "82556 EtherExpress PRO/100 Smart",
             0x1229: "82557/8/9/0/1 Ethernet Pro 100",
             0x122D: "430FX - 82437FX TSC [Triton I]",
             0x122E: "82371FB PIIX ISA [Triton I]",
             0x1230: "82371FB PIIX IDE [Triton I]",
             0x1231: "DSVD Modem",
             0x1234: "430MX - 82371MX Mobile PCI I/O IDE Xcelerator (MPIIX)",
             0x1235: "430MX - 82437MX Mob. System Ctrlr (MTSC) & 82438MX Data Path (MTDP)",
             0x1237: "440FX - 82441FX PMC [Natoma]",
             0x1239: "82371FB PIIX IDE Interface",
             0x123B: "82380PB PCI to PCI Docking Bridge",
             0x123C: "82380AB (MISA) Mobile PCI-to-ISA Bridge",
             0x123D: "683053 Programmable Interrupt Device",
             0x123E: "82466GX (IHPC) Integrated Hot-Plug Controller (hidden mode)",
             0x123F: "82466GX Integrated Hot-Plug Controller (IHPC)",
             0x1240: "82752 (752) AGP Graphics Accelerator",
             0x124B: "82380FB (MPCI2) Mobile Docking Controller",
             0x124C: "Ethernet Connection E823-L for backplane",
             0x124D: "Ethernet Connection E823-L for SFP",
             0x124E: "Ethernet Connection E823-L/X557-AT 10GBASE-T",
             0x124F: "Ethernet Connection E823-L 1GbE",
             0x1250: "430HX - 82439HX TXC [Triton II]",
             0x125B: "Ethernet Controller I226-LM",
             0x125C: "Ethernet Controller I226-V",
             0x1360: "82806AA PCI64 Hub PCI Bridge",
             0x1361: "82806AA PCI64 Hub Controller (HRes)",
             0x1460: "82870P2 P64H2 Hub PCI Bridge",
             0x1461: "82870P2 P64H2 I/OxAPIC",
             0x1462: "82870P2 P64H2 Hot Plug Controller",
             0x1501: "82567V-3 Gigabit Network Connection",
             0x1502: "82579LM Gigabit Network Connection (Lewisville)",
             0x1503: "82579V Gigabit Network Connection",
             0x1507: "Ethernet Express Module X520-P2",
             0x1508: "82598EB Gigabit BX Network Connection",
             0x1509: "82580 Gigabit Network Connection",
             0x150A: "82576NS Gigabit Network Connection",
             0x150B: "82598EB 10-Gigabit AT2 Server Adapter",
             0x150C: "82583V Gigabit Network Connection",
             0x150D: "82576 Gigabit Backplane Connection",
             0x150E: "82580 Gigabit Network Connection",
             0x150F: "82580 Gigabit Fiber Network Connection",
             0x1510: "82580 Gigabit Backplane Connection",
             0x1511: "82580 Gigabit SFP Connection",
             0x1513: "CV82524 Thunderbolt Controller [Light Ridge 4C 2010]",
             0x1514: "Ethernet X520 10GbE Dual Port KX4 Mezz",
             0x1515: "X540 Ethernet Controller Virtual Function",
             0x1516: "82580 Gigabit Network Connection",
             0x1517: "82599ES 10 Gigabit Network Connection",
             0x1518: "82576NS SerDes Gigabit Network Connection",
             0x151A: "DSL2310 Thunderbolt Controller [Eagle Ridge 2C 2011]",
             0x151B: "CVL2510 Thunderbolt Controller [Light Peak 2C 2010]",
             0x151C: "82599 10 Gigabit TN Network Connection",
             0x151D: "Ethernet Connection E823-L for QSFP",
             0x1520: "I350 Ethernet Controller Virtual Function",
             0x1521: "I350 Gigabit Network Connection",
             0x1522: "I350 Gigabit Fiber Network Connection",
             0x1523: "I350 Gigabit Backplane Connection",
             0x1524: "I350 Gigabit Connection",
             0x1525: "82567V-4 Gigabit Network Connection",
             0x1526: "82576 Gigabit Network Connection",
             0x1527: "82580 Gigabit Fiber Network Connection",
             0x1528: "Ethernet Controller 10-Gigabit X540-AT2",
             0x1529: "82599 10 Gigabit Dual Port Network Connection with FCoE",
             0x152A: "82599 10 Gigabit Dual Port Backplane Connection with FCoE",
             0x152E: "82599 Virtual Function",
             0x152F: "I350 Virtual Function",
             0x1530: "X540 Virtual Function",
             0x1531: "I210 Gigabit Unprogrammed",
             0x1533: "I210 Gigabit Network Connection",
             0x1536: "I210 Gigabit Fiber Network Connection",
             0x1537: "I210 Gigabit Backplane Connection",
             0x1538: "I210 Gigabit Network Connection",
             0x1539: "I211 Gigabit Network Connection",
             0x153A: "Ethernet Connection I217-LM",
             0x153B: "Ethernet Connection I217-V",
             0x1547: "DSL3510 Thunderbolt Controller [Cactus Ridge 4C 2012]",
             0x1548: "DSL3310 Thunderbolt Controller [Cactus Ridge 2C 2012]",
             0x1549: "DSL2210 Thunderbolt Controller [Port Ridge 1C 2011]",
             0x154A: "Ethernet Server Adapter X520-4",
             0x154C: "Ethernet Virtual Function 700 Series",
             0x154D: "Ethernet 10G 2P X520 Adapter",
             0x1557: "82599 10 Gigabit Network Connection",
             0x1558: "Ethernet Converged Network Adapter X520-Q1",
             0x1559: "Ethernet Connection I218-V",
             0x155A: "Ethernet Connection I218-LM",
             0x155C: "Ethernet Server Bypass Adapter",
             0x155D: "Ethernet Server Bypass Adapter",
             0x1560: "Ethernet Controller X540",
             0x1563: "Ethernet Controller X550",
             0x1564: "X550 Virtual Function",
             0x1565: "X550 Virtual Function",
             0x1566: "DSL4410 Thunderbolt NHI [Redwood Ridge 2C 2013]",
             0x1567: "DSL4410 Thunderbolt Bridge [Redwood Ridge 2C 2013]",
             0x1568: "DSL4510 Thunderbolt NHI [Redwood Ridge 4C 2013]",
             0x1569: "DSL4510 Thunderbolt Bridge [Redwood Ridge 4C 2013]",
             0x156A: "DSL5320 Thunderbolt 2 NHI [Falcon Ridge 2C 2013]",
             0x156B: "DSL5320 Thunderbolt 2 Bridge [Falcon Ridge 2C 2013]",
             0x156C: "DSL5520 Thunderbolt 2 NHI [Falcon Ridge 4C 2013]",
             0x156D: "DSL5520 Thunderbolt 2 Bridge [Falcon Ridge 4C 2013]",
             0x156F: "Ethernet Connection I219-LM",
             0x1570: "Ethernet Connection I219-V",
             0x1571: "Ethernet Virtual Function 700 Series",
             0x1572: "Ethernet Controller X710 for 10GbE SFP+",
             0x1574: "Ethernet Controller XL710 Emulation",
             0x1575: "DSL6340 Thunderbolt 3 NHI [Alpine Ridge 2C 2015]",
             0x1576: "DSL6340 Thunderbolt 3 Bridge [Alpine Ridge 2C 2015]",
             0x1577: "DSL6540 Thunderbolt 3 NHI [Alpine Ridge 4C 2015]",
             0x1578: "DSL6540 Thunderbolt 3 Bridge [Alpine Ridge 4C 2015]",
             0x157B: "I210 Gigabit Network Connection",
             0x157C: "I210 Gigabit Backplane Connection",
             0x157D: "DSL5110 Thunderbolt 2 NHI (Low Power) [Win Ridge 2C 2014]",
             0x157E: "DSL5110 Thunderbolt 2 Bridge (Low Power) [Win Ridge 2C 2014]",
             0x1580: "Ethernet Controller XL710 for 40GbE backplane",
             0x1581: "Ethernet Controller X710 for 10GbE backplane",
             0x1583: "Ethernet Controller XL710 for 40GbE QSFP+",
             0x1584: "Ethernet Controller XL710 for 40GbE QSFP+",
             0x1585: "Ethernet Controller X710 for 10GbE QSFP+",
             0x1586: "Ethernet Controller X710 for 10GBASE-T",
             0x1587: "Ethernet Controller XL710 for 20GbE backplane",
             0x1588: "Ethernet Controller XL710 for 20GbE backplane",
             0x1589: "Ethernet Controller X710/X557-AT 10GBASE-T",
             0x158A: "Ethernet Controller XXV710 for 25GbE backplane",
             0x158B: "Ethernet Controller XXV710 for 25GbE SFP28",
             0x1591: "Ethernet Controller E810-C for backplane",
             0x1592: "Ethernet Controller E810-C for QSFP",
             0x1593: "Ethernet Controller E810-C for SFP",
             0x1599: "Ethernet Controller E810-XXV for backplane",
             0x159A: "Ethernet Controller E810-XXV for QSFP",
             0x159B: "Ethernet Controller E810-XXV for SFP",
             0x15A0: "Ethernet Connection (2) I218-LM",
             0x15A1: "Ethernet Connection (2) I218-V",
             0x15A2: "Ethernet Connection (3) I218-LM",
             0x15A3: "Ethernet Connection (3) I218-V",
             0x15A4: "Ethernet Switch FM10000 Host Interface",
             0x15A5: "Ethernet Switch FM10000 Host Virtual Interface",
             0x15A8: "Ethernet Connection X552 Virtual Function",
             0x15A9: "X552 Virtual Function",
             0x15AA: "Ethernet Connection X552 10 GbE Backplane",
             0x15AB: "Ethernet Connection X552 10 GbE Backplane",
             0x15AC: "Ethernet Connection X552 10 GbE SFP+",
             0x15AD: "Ethernet Connection X552/X557-AT 10GBASE-T",
             0x15AE: "Ethernet Connection X552 1000BASE-T",
             0x15B0: "Ethernet Connection X552 Backplane",
             0x15B4: "X553 Virtual Function",
             0x15B5: "DSL6340 USB 3.1 Controller [Alpine Ridge]",
             0x15B6: "DSL6540 USB 3.1 Controller [Alpine Ridge]",
             0x15B7: "Ethernet Connection (2) I219-LM",
             0x15B8: "Ethernet Connection (2) I219-V",
             0x15B9: "Ethernet Connection (3) I219-LM",
             0x15BB: "Ethernet Connection (7) I219-LM",
             0x15BC: "Ethernet Connection (7) I219-V",
             0x15BD: "Ethernet Connection (6) I219-LM",
             0x15BE: "Ethernet Connection (6) I219-V",
             0x15BF: "JHL6240 Thunderbolt 3 NHI (Low Power) [Alpine Ridge LP 2016]",
             0x15C0: "JHL6240 Thunderbolt 3 Bridge (Low Power) [Alpine Ridge LP 2016]",
             0x15C1: "JHL6240 Thunderbolt 3 USB 3.1 Controller (Low Power) [Alpine Ridge LP 2016]",
             0x15C2: "Ethernet Connection X553 Backplane",
             0x15C3: "Ethernet Connection X553 Backplane",
             0x15C4: "Ethernet Connection X553 10 GbE SFP+",
             0x15C5: "X553 Virtual Function",
             0x15C6: "Ethernet Connection X553 1GbE",
             0x15C7: "Ethernet Connection X553 1GbE",
             0x15C8: "Ethernet Connection X553/X557-AT 10GBASE-T",
             0x15CE: "Ethernet Connection X553 10 GbE SFP+",
             0x15D0: "Ethernet SDI Adapter",
             0x15D1: "Ethernet Controller 10G X550T",
             0x15D2: "JHL6540 Thunderbolt 3 NHI (C step) [Alpine Ridge 4C 2016]",
             0x15D3: "JHL6540 Thunderbolt 3 Bridge (C step) [Alpine Ridge 4C 2016]",
             0x15D4: "JHL6540 Thunderbolt 3 USB Controller (C step) [Alpine Ridge 4C 2016]",
             0x15D5: "Ethernet SDI Adapter FM10420-25GbE-DA2",
             0x15D6: "Ethernet Connection (5) I219-V",
             0x15D7: "Ethernet Connection (4) I219-LM",
             0x15D8: "Ethernet Connection (4) I219-V",
             0x15D9: "JHL6340 Thunderbolt 3 NHI (C step) [Alpine Ridge 2C 2016]",
             0x15DA: "JHL6340 Thunderbolt 3 Bridge (C step) [Alpine Ridge 2C 2016]",
             0x15DB: "JHL6340 Thunderbolt 3 USB 3.1 Controller (C step) [Alpine Ridge 2C 2016]",
             0x15DF: "Ethernet Connection (8) I219-LM",
             0x15E0: "Ethernet Connection (8) I219-V",
             0x15E1: "Ethernet Connection (9) I219-LM",
             0x15E2: "Ethernet Connection (9) I219-V",
             0x15E3: "Ethernet Connection (5) I219-LM",
             0x15E4: "Ethernet Connection X553 1GbE",
             0x15E5: "Ethernet Connection X553 1GbE",
             0x15E7: "JHL7540 Thunderbolt 3 Bridge [Titan Ridge 2C 2018]",
             0x15E8: "JHL7540 Thunderbolt 3 NHI [Titan Ridge 2C 2018]",
             0x15E9: "JHL7540 Thunderbolt 3 USB Controller [Titan Ridge 2C 2018]",
             0x15EA: "JHL7540 Thunderbolt 3 Bridge [Titan Ridge 4C 2018]",
             0x15EB: "JHL7540 Thunderbolt 3 NHI [Titan Ridge 4C 2018]",
             0x15EC: "JHL7540 Thunderbolt 3 USB Controller [Titan Ridge 4C 2018]",
             0x15EF: "JHL7540 Thunderbolt 3 Bridge [Titan Ridge DD 2018]",
             0x15F0: "JHL7540 Thunderbolt 3 USB Controller [Titan Ridge DD 2018]",
             0x15F2: "Ethernet Controller I225-LM",
             0x15F3: "Ethernet Controller I225-V",
             0x15F4: "Ethernet Connection (15) I219-LM",
             0x15F5: "Ethernet Connection (15) I219-V",
             0x15F6: "I210 Gigabit Ethernet Connection",
             0x15F9: "Ethernet Connection (14) I219-LM",
             0x15FA: "Ethernet Connection (14) I219-V",
             0x15FB: "Ethernet Connection (13) I219-LM",
             0x15FC: "Ethernet Connection (13) I219-V",
             0x15FF: "Ethernet Controller X710 for 10GBASE-T",
             0x1600: "Broadwell-U Host Bridge -OPI",
             0x1601: "Broadwell-U PCI Express x16 Controller",
             0x1602: "Broadwell-U Integrated Graphics",
             0x1603: "Broadwell-U Processor Thermal Subsystem",
             0x1604: "Broadwell-U Host Bridge -OPI",
             0x1605: "Broadwell-U PCI Express x8 Controller",
             0x1606: "HD Graphics",
             0x1607: "Broadwell-U CHAPS Device",
             0x1608: "Broadwell-U Host Bridge -OPI",
             0x1609: "Broadwell-U x4 PCIe",
             0x160A: "Broadwell-U Integrated Graphics",
             0x160B: "Broadwell-U Integrated Graphics",
             0x160C: "Broadwell-U Audio Controller",
             0x160D: "Broadwell-U Integrated Graphics",
             0x160E: "Broadwell-U Integrated Graphics",
             0x160F: "Broadwell-U SoftSKU",
             0x1610: "Broadwell-U Host Bridge - DMI",
             0x1612: "HD Graphics 5600",
             0x1614: "Broadwell-U Host Bridge - DMI",
             0x1616: "HD Graphics 5500",
             0x1618: "Broadwell-U Host Bridge - DMI",
             0x161A: "Broadwell-U Integrated Graphics",
             0x161B: "Broadwell-U Integrated Graphics",
             0x161D: "Broadwell-U Integrated Graphics",
             0x161E: "HD Graphics 5300",
             0x1622: "Iris Pro Graphics 6200",
             0x1626: "HD Graphics 6000",
             0x162A: "Iris Pro Graphics P6300",
             0x162B: "Iris Graphics 6100",
             0x162D: "Broadwell-U Integrated Graphics",
             0x162E: "Broadwell-U Integrated Graphics",
             0x1632: "Broadwell-U Integrated Graphics",
             0x1636: "Broadwell-U Integrated Graphics",
             0x163A: "Broadwell-U Integrated Graphics",
             0x163B: "Broadwell-U Integrated Graphics",
             0x163D: "Broadwell-U Integrated Graphics",
             0x163E: "Broadwell-U Integrated Graphics",
             0x1889: "Ethernet Adaptive Virtual Function",
             0x188A: "Ethernet Connection E823-C for backplane",
             0x188B: "Ethernet Connection E823-C for QSFP",
             0x188C: "Ethernet Connection E823-C for SFP",
             0x188D: "Ethernet Connection E823-C/X557-AT 10GBASE-T",
             0x188E: "Ethernet Connection E823-C 1GbE",
             0x1890: "Ethernet Connection E822-C for backplane",
             0x1891: "Ethernet Connection E822-C for QSFP",
             0x1892: "Ethernet Connection E822-C for SFP",
             0x1893: "Ethernet Connection E822-C/X557-AT 10GBASE-T",
             0x1894: "Ethernet Connection E822-C 1GbE",
             0x1897: "Ethernet Connection E822-L for backplane",
             0x1898: "Ethernet Connection E822-L for SFP",
             0x1899: "Ethernet Connection E822-L/X557-AT 10GBASE-T",
             0x189A: "Ethernet Connection E822-L 1GbE",
             0x18A0: "C4xxx Series QAT",
             0x18A1: "C4XXX Series QAT Virtual Function",
             0x18EE: "200xx Series QAT",
             0x18EF: "200xx Series QAT Virtual Function",
             0x1900: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers",
             0x1901: "6th-10th Gen Core Processor PCIe Controller (x16)",
             0x1902: "HD Graphics 510",
             0x1903: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Thermal Subsystem",
             0x1904: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers",
             0x1905: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor PCIe Controller (x8)",
             0x1906: "HD Graphics 510",
             0x1908: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers",
             0x1909: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor PCIe Controller (x4)",
             0x190B: "HD Graphics 510",
             0x190C: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers",
             0x190F: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers",
             0x1910: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers",
             0x1911: "Xeon E3-1200 v5/v6 / E3-1500 v5 / 6th/7th/8th Gen Core Processor Gaussian Mixture Model",
             0x1912: "HD Graphics 530",
             0x1916: "Skylake GT2 [HD Graphics 520]",
             0x1918: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers",
             0x1919: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Imaging Unit",
             0x191B: "HD Graphics 530",
             0x191D: "HD Graphics P530",
             0x191E: "HD Graphics 515",
             0x191F: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers",
             0x1921: "HD Graphics 520",
             0x1923: "HD Graphics 535",
             0x1926: "Iris Graphics 540",
             0x1927: "Iris Graphics 550",
             0x192B: "Iris Graphics 555",
             0x192D: "Iris Graphics P555",
             0x1932: "Iris Pro Graphics 580",
             0x193A: "Iris Pro Graphics P580",
             0x193B: "Iris Pro Graphics 580",
             0x193D: "Iris Pro Graphics P580",
             0x1960: "80960RP (i960RP) Microprocessor",
             0x1962: "80960RM (i960RM) Microprocessor",
             0x1964: "80960RN (i960RN) Microprocessor",
             0x1980: "Atom Processor C3000 Series System Agent",
             0x19A1: "Atom Processor C3000 Series Error Registers",
             0x19A2: "Atom Processor C3000 Series Root Complex Event Collector",
             0x19A3: "Atom Processor C3000 Series Integrated QAT Root Port",
             0x19A4: "Atom Processor C3000 Series PCI Express Root Port #0",
             0x19A5: "Atom Processor C3000 Series PCI Express Root Port #1",
             0x19A6: "Atom Processor C3000 Series PCI Express Root Port #2",
             0x19A7: "Atom Processor C3000 Series PCI Express Root Port #3",
             0x19A8: "Atom Processor C3000 Series PCI Express Root Port #4",
             0x19A9: "Atom Processor C3000 Series PCI Express Root Port #5",
             0x19AA: "Atom Processor C3000 Series PCI Express Root Port #6",
             0x19AB: "Atom Processor C3000 Series PCI Express Root Port #7",
             0x19AC: "Atom Processor C3000 Series SMBus Contoller - Host",
             0x19B0: "Atom Processor C3000 Series SATA Controller 0",
             0x19B1: "Atom Processor C3000 Series SATA Controller 0",
             0x19B2: "Atom Processor C3000 Series SATA Controller 0",
             0x19B3: "Atom Processor C3000 Series SATA Controller 0",
             0x19B4: "Atom Processor C3000 Series SATA Controller 0",
             0x19B5: "Atom Processor C3000 Series SATA Controller 0",
             0x19B6: "Atom Processor C3000 Series SATA Controller 0",
             0x19B7: "Atom Processor C3000 Series SATA Controller 0",
             0x19BE: "Atom Processor C3000 Series SATA Controller 0",
             0x19BF: "Atom Processor C3000 Series SATA Controller 0",
             0x19C0: "Atom Processor C3000 Series SATA Controller 1",
             0x19C1: "Atom Processor C3000 Series SATA Controller 1",
             0x19C2: "Atom Processor C3000 Series SATA Controller 1",
             0x19C3: "Atom Processor C3000 Series SATA Controller 1",
             0x19C4: "Atom Processor C3000 Series SATA Controller 1",
             0x19C5: "Atom Processor C3000 Series SATA Controller 1",
             0x19C6: "Atom Processor C3000 Series SATA Controller 1",
             0x19C7: "Atom Processor C3000 Series SATA Controller 1",
             0x19CE: "Atom Processor C3000 Series SATA Controller 1",
             0x19CF: "Atom Processor C3000 Series SATA Controller 1",
             0x19D0: "Atom Processor C3000 Series USB 3.0 xHCI Controller",
             0x19D1: "Atom Processor C3000 Series Integrated LAN Root Port #0",
             0x19D2: "Atom Processor C3000 Series Integrated LAN Root Port #1",
             0x19D3: "Atom Processor C3000 Series ME HECI 1",
             0x19D4: "Atom Processor C3000 Series ME HECI 2",
             0x19D5: "Atom Processor C3000 Series ME KT Controller",
             0x19D6: "Atom Processor C3000 Series ME HECI 3",
             0x19D8: "Atom Processor C3000 Series HSUART Controller",
             0x19DC: "Atom Processor C3000 Series LPC or eSPI",
             0x19DD: "Atom Processor C3000 Series Primary to Side Band (P2SB) Bridge",
             0x19DE: "Atom Processor C3000 Series Power Management Controller",
             0x19DF: "Atom Processor C3000 Series SMBus controller",
             0x19E0: "Atom Processor C3000 Series SPI Controller",
             0x19E2: "Atom Processor C3000 Series QuickAssist Technology",
             0x19E3: "Atom Processor C3000 Series QuickAssist Technology Virtual Function",
             0x1A1C: "Ethernet Connection (17) I219-LM",
             0x1A1D: "Ethernet Connection (17) I219-V",
             0x1A1E: "Ethernet Connection (16) I219-LM",
             0x1A1F: "Ethernet Connection (16) I219-V",
             0x1A21: "82840 840 [Carmel] Chipset Host Bridge (Hub A)",
             0x1A23: "82840 840 [Carmel] Chipset AGP Bridge",
             0x1A24: "82840 840 [Carmel] Chipset PCI Bridge (Hub B)",
             0x1A30: "82845 845 [Brookdale] Chipset Host Bridge",
             0x1A31: "82845 845 [Brookdale] Chipset AGP Bridge",
             0x1A38: "5000 Series Chipset DMA Engine",
             0x1A48: "82597EX 10GbE Ethernet Controller",
             0x1B48: "82597EX 10GbE Ethernet Controller",
             0x1C00: "6 Series/C200 Series Chipset Family Desktop SATA Controller (IDE mode, ports 0-3)",
             0x1C01: "6 Series/C200 Series Chipset Family Mobile SATA Controller (IDE mode, ports 0-3)",
             0x1C02: "6 Series/C200 Series Chipset Family 6 port Desktop SATA AHCI Controller",
             0x1C03: "6 Series/C200 Series Chipset Family 6 port Mobile SATA AHCI Controller",
             0x1C04: "6 Series/C200 Series Desktop SATA RAID Controller",
             0x1C05: "6 Series/C200 Series Mobile SATA RAID Controller",
             0x1C06: "Z68 Express Chipset SATA RAID Controller",
             0x1C08: "6 Series/C200 Series Chipset Family Desktop SATA Controller (IDE mode, ports 4-5)",
             0x1C09: "6 Series/C200 Series Chipset Family Mobile SATA Controller (IDE mode, ports 4-5)",
             0x1C10: "6 Series/C200 Series Chipset Family PCI Express Root Port 1",
             0x1C12: "6 Series/C200 Series Chipset Family PCI Express Root Port 2",
             0x1C14: "6 Series/C200 Series Chipset Family PCI Express Root Port 3",
             0x1C16: "6 Series/C200 Series Chipset Family PCI Express Root Port 4",
             0x1C18: "6 Series/C200 Series Chipset Family PCI Express Root Port 5",
             0x1C1A: "6 Series/C200 Series Chipset Family PCI Express Root Port 6",
             0x1C1C: "6 Series/C200 Series Chipset Family PCI Express Root Port 7",
             0x1C1E: "6 Series/C200 Series Chipset Family PCI Express Root Port 8",
             0x1C20: "6 Series/C200 Series Chipset Family High Definition Audio Controller",
             0x1C22: "6 Series/C200 Series Chipset Family SMBus Controller",
             0x1C24: "6 Series/C200 Series Chipset Family Thermal Management Controller",
             0x1C25: "6 Series/C200 Series Chipset Family DMI to PCI Bridge",
             0x1C26: "6 Series/C200 Series Chipset Family USB Enhanced Host Controller #1",
             0x1C27: "6 Series/C200 Series Chipset Family USB Universal Host Controller #1",
             0x1C2C: "6 Series/C200 Series Chipset Family USB Universal Host Controller #5",
             0x1C2D: "6 Series/C200 Series Chipset Family USB Enhanced Host Controller #2",
             0x1C33: "6 Series/C200 Series Chipset Family LAN Controller",
             0x1C35: "6 Series/C200 Series Chipset Family VECI Controller",
             0x1C3A: "6 Series/C200 Series Chipset Family MEI Controller #1",
             0x1C3B: "6 Series/C200 Series Chipset Family MEI Controller #2",
             0x1C3C: "6 Series/C200 Series Chipset Family IDE-r Controller",
             0x1C3D: "6 Series/C200 Series Chipset Family KT Controller",
             0x1C40: "6 Series/C200 Series Chipset Family LPC Controller",
             0x1C41: "Mobile SFF 6 Series Chipset Family LPC Controller",
             0x1C42: "6 Series/C200 Series Chipset Family LPC Controller",
             0x1C43: "Mobile 6 Series Chipset Family LPC Controller",
             0x1C44: "Z68 Express Chipset LPC Controller",
             0x1C45: "6 Series/C200 Series Chipset Family LPC Controller",
             0x1C46: "P67 Express Chipset LPC Controller",
             0x1C47: "UM67 Express Chipset LPC Controller",
             0x1C48: "6 Series/C200 Series Chipset Family LPC Controller",
             0x1C49: "HM65 Express Chipset LPC Controller",
             0x1C4A: "H67 Express Chipset LPC Controller",
             0x1C4B: "HM67 Express Chipset LPC Controller",
             0x1C4C: "Q65 Express Chipset LPC Controller",
             0x1C4D: "QS67 Express Chipset LPC Controller",
             0x1C4E: "Q67 Express Chipset LPC Controller",
             0x1C4F: "QM67 Express Chipset LPC Controller",
             0x1C50: "B65 Express Chipset LPC Controller",
             0x1C51: "6 Series/C200 Series Chipset Family LPC Controller",
             0x1C52: "C202 Chipset LPC Controller",
             0x1C53: "6 Series/C200 Series Chipset Family LPC Controller",
             0x1C54: "C204 Chipset LPC Controller",
             0x1C55: "6 Series/C200 Series Chipset Family LPC Controller",
             0x1C56: "C206 Chipset LPC Controller",
             0x1C57: "6 Series/C200 Series Chipset Family LPC Controller",
             0x1C58: "Upgraded B65 Express Chipset LPC Controller",
             0x1C59: "Upgraded HM67 Express Chipset LPC Controller",
             0x1C5A: "Upgraded Q67 Express Chipset LPC Controller",
             0x1C5B: "6 Series/C200 Series Chipset Family LPC Controller",
             0x1C5C: "H61 Express Chipset LPC Controller",
             0x1C5D: "6 Series/C200 Series Chipset Family LPC Controller",
             0x1C5E: "6 Series/C200 Series Chipset Family LPC Controller",
             0x1C5F: "6 Series/C200 Series Chipset Family LPC Controller",
             0x1D00: "C600/X79 series chipset 4-Port SATA IDE Controller",
             0x1D02: "C600/X79 series chipset 6-Port SATA AHCI Controller",
             0x1D04: "C600/X79 series chipset SATA RAID Controller",
             0x1D06: "C600/X79 series chipset SATA Premium RAID Controller",
             0x1D08: "C600/X79 series chipset 2-Port SATA IDE Controller",
             0x1D10: "C600/X79 series chipset PCI Express Root Port 1",
             0x1D11: "C600/X79 series chipset PCI Express Root Port 1",
             0x1D12: "C600/X79 series chipset PCI Express Root Port 2",
             0x1D13: "C600/X79 series chipset PCI Express Root Port 2",
             0x1D14: "C600/X79 series chipset PCI Express Root Port 3",
             0x1D15: "C600/X79 series chipset PCI Express Root Port 3",
             0x1D16: "C600/X79 series chipset PCI Express Root Port 4",
             0x1D17: "C600/X79 series chipset PCI Express Root Port 4",
             0x1D18: "C600/X79 series chipset PCI Express Root Port 5",
             0x1D19: "C600/X79 series chipset PCI Express Root Port 5",
             0x1D1A: "C600/X79 series chipset PCI Express Root Port 6",
             0x1D1B: "C600/X79 series chipset PCI Express Root Port 6",
             0x1D1C: "C600/X79 series chipset PCI Express Root Port 7",
             0x1D1D: "C600/X79 series chipset PCI Express Root Port 7",
             0x1D1E: "C600/X79 series chipset PCI Express Root Port 8",
             0x1D1F: "C600/X79 series chipset PCI Express Root Port 8",
             0x1D20: "C600/X79 series chipset High Definition Audio Controller",
             0x1D22: "C600/X79 series chipset SMBus Host Controller",
             0x1D24: "C600/X79 series chipset Thermal Management Controller",
             0x1D25: "C600/X79 series chipset DMI to PCI Bridge",
             0x1D26: "C600/X79 series chipset USB2 Enhanced Host Controller #1",
             0x1D2D: "C600/X79 series chipset USB2 Enhanced Host Controller #2",
             0x1D33: "C600/X79 series chipset LAN Controller",
             0x1D35: "C600/X79 series chipset VECI Controller",
             0x1D3A: "C600/X79 series chipset MEI Controller #1",
             0x1D3B: "C600/X79 series chipset MEI Controller #2",
             0x1D3C: "C600/X79 series chipset IDE-r Controller",
             0x1D3D: "C600/X79 series chipset KT Controller",
             0x1D3E: "C600/X79 series chipset PCI Express Virtual Root Port",
             0x1D3F: "C608/C606/X79 series chipset PCI Express Virtual Switch Port",
             0x1D40: "C600/X79 series chipset LPC Controller",
             0x1D41: "C600/X79 series chipset LPC Controller",
             0x1D50: "C608 chipset Dual 4-Port SATA/SAS Storage Control Unit",
             0x1D54: "C600/X79 series chipset Dual 4-Port SATA/SAS Storage Control Unit",
             0x1D55: "C600/X79 series chipset 4-Port SATA/SAS Storage Control Unit",
             0x1D58: "C606 chipset Dual 4-Port SATA/SAS Storage Control Unit",
             0x1D59: "C604/X79 series chipset 4-Port SATA/SAS Storage Control Unit",
             0x1D5A: "C600/X79 series chipset Dual 4-Port SATA Storage Control Unit",
             0x1D5B: "C602 chipset 4-Port SATA Storage Control Unit",
             0x1D5C: "C600/X79 series chipset Dual 4-Port SATA/SAS Storage Control Unit",
             0x1D5D: "C600/X79 series chipset 4-Port SATA/SAS Storage Control Unit",
             0x1D5E: "C600/X79 series chipset Dual 4-Port SATA Storage Control Unit",
             0x1D5F: "C600/X79 series chipset 4-Port SATA Storage Control Unit",
             0x1D60: "C608 chipset Dual 4-Port SATA/SAS Storage Control Unit",
             0x1D64: "C600/X79 series chipset Dual 4-Port SATA/SAS Storage Control Unit",
             0x1D65: "C600/X79 series chipset 4-Port SATA/SAS Storage Control Unit",
             0x1D68: "C606 chipset Dual 4-Port SATA/SAS Storage Control Unit",
             0x1D69: "C604/X79 series chipset 4-Port SATA/SAS Storage Control Unit",
             0x1D6A: "C600/X79 series chipset Dual 4-Port SATA Storage Control Unit",
             0x1D6B: "C602 chipset 4-Port SATA Storage Control Unit",
             0x1D6C: "C600/X79 series chipset Dual 4-Port SATA/SAS Storage Control Unit",
             0x1D6D: "C600/X79 series chipset 4-Port SATA/SAS Storage Control Unit",
             0x1D6E: "C600/X79 series chipset Dual 4-Port SATA Storage Control Unit",
             0x1D6F: "C600/X79 series chipset 4-Port SATA Storage Control Unit",
             0x1D70: "C600/X79 series chipset SMBus Controller 0",
             0x1D71: "C608/C606/X79 series chipset SMBus Controller 1",
             0x1D72: "C608 chipset SMBus Controller 2",
             0x1D74: "C608/C606/X79 series chipset PCI Express Upstream Port",
             0x1D76: "C600/X79 series chipset Multi-Function Glue",
             0x1E00: "7 Series/C210 Series Chipset Family 4-port SATA Controller [IDE mode]",
             0x1E01: "7 Series Chipset Family 4-port SATA Controller [IDE mode]",
             0x1E02: "7 Series/C210 Series Chipset Family 6-port SATA Controller [AHCI mode]",
             0x1E03: "7 Series Chipset Family 6-port SATA Controller [AHCI mode]",
             0x1E04: "7 Series/C210 Series Chipset Family SATA Controller [RAID mode]",
             0x1E05: "7 Series Chipset SATA Controller [RAID mode]",
             0x1E06: "7 Series/C210 Series Chipset Family SATA Controller [RAID mode]",
             0x1E07: "7 Series Chipset Family SATA Controller [RAID mode]",
             0x1E08: "7 Series/C210 Series Chipset Family 2-port SATA Controller [IDE mode]",
             0x1E09: "7 Series Chipset Family 2-port SATA Controller [IDE mode]",
             0x1E0E: "7 Series/C210 Series Chipset Family SATA Controller [RAID mode]",
             0x1E10: "7 Series/C216 Chipset Family PCI Express Root Port 1",
             0x1E12: "7 Series/C210 Series Chipset Family PCI Express Root Port 2",
             0x1E14: "7 Series/C210 Series Chipset Family PCI Express Root Port 3",
             0x1E16: "7 Series/C216 Chipset Family PCI Express Root Port 4",
             0x1E18: "7 Series/C210 Series Chipset Family PCI Express Root Port 5",
             0x1E1A: "7 Series/C210 Series Chipset Family PCI Express Root Port 6",
             0x1E1C: "7 Series/C210 Series Chipset Family PCI Express Root Port 7",
             0x1E1E: "7 Series/C210 Series Chipset Family PCI Express Root Port 8",
             0x1E20: "7 Series/C216 Chipset Family High Definition Audio Controller",
             0x1E22: "7 Series/C216 Chipset Family SMBus Controller",
             0x1E24: "7 Series/C210 Series Chipset Family Thermal Management Controller",
             0x1E25: "7 Series/C210 Series Chipset Family DMI to PCI Bridge",
             0x1E26: "7 Series/C216 Chipset Family USB Enhanced Host Controller #1",
             0x1E2D: "7 Series/C216 Chipset Family USB Enhanced Host Controller #2",
             0x1E31: "7 Series/C210 Series Chipset Family USB xHCI Host Controller",
             0x1E33: "7 Series/C210 Series Chipset Family LAN Controller",
             0x1E3A: "7 Series/C216 Chipset Family MEI Controller #1",
             0x1E3B: "7 Series/C210 Series Chipset Family MEI Controller #2",
             0x1E3C: "7 Series/C210 Series Chipset Family IDE-r Controller",
             0x1E3D: "7 Series/C210 Series Chipset Family KT Controller",
             0x1E41: "7 Series Chipset Family LPC Controller",
             0x1E42: "7 Series Chipset Family LPC Controller",
             0x1E43: "7 Series Chipset Family LPC Controller",
             0x1E44: "Z77 Express Chipset LPC Controller",
             0x1E45: "7 Series Chipset Family LPC Controller",
             0x1E46: "Z75 Express Chipset LPC Controller",
             0x1E47: "Q77 Express Chipset LPC Controller",
             0x1E48: "Q75 Express Chipset LPC Controller",
             0x1E49: "B75 Express Chipset LPC Controller",
             0x1E4A: "H77 Express Chipset LPC Controller",
             0x1E4B: "7 Series Chipset Family LPC Controller",
             0x1E4C: "7 Series Chipset Family LPC Controller",
             0x1E4D: "7 Series Chipset Family LPC Controller",
             0x1E4E: "7 Series Chipset Family LPC Controller",
             0x1E4F: "7 Series Chipset Family LPC Controller",
             0x1E50: "7 Series Chipset Family LPC Controller",
             0x1E51: "7 Series Chipset Family LPC Controller",
             0x1E52: "7 Series Chipset Family LPC Controller",
             0x1E53: "C216 Series Chipset LPC Controller",
             0x1E54: "7 Series Chipset Family LPC Controller",
             0x1E55: "QM77 Express Chipset LPC Controller",
             0x1E56: "QS77 Express Chipset LPC Controller",
             0x1E57: "HM77 Express Chipset LPC Controller",
             0x1E58: "UM77 Express Chipset LPC Controller",
             0x1E59: "HM76 Express Chipset LPC Controller",
             0x1E5A: "7 Series Chipset Family LPC Controller",
             0x1E5B: "UM77 Express Chipset LPC Controller",
             0x1E5C: "7 Series Chipset Family LPC Controller",
             0x1E5D: "HM75 Express Chipset LPC Controller",
             0x1E5E: "HM70 Express Chipset LPC Controller",
             0x1E5F: "NM70 Express Chipset LPC Controller",
             0x1F00: "Atom processor C2000 SoC Transaction Router",
             0x1F01: "Atom processor C2000 SoC Transaction Router",
             0x1F02: "Atom processor C2000 SoC Transaction Router",
             0x1F03: "Atom processor C2000 SoC Transaction Router",
             0x1F04: "Atom processor C2000 SoC Transaction Router",
             0x1F05: "Atom processor C2000 SoC Transaction Router",
             0x1F06: "Atom processor C2000 SoC Transaction Router",
             0x1F07: "Atom processor C2000 SoC Transaction Router",
             0x1F08: "Atom processor C2000 SoC Transaction Router",
             0x1F09: "Atom processor C2000 SoC Transaction Router",
             0x1F0A: "Atom processor C2000 SoC Transaction Router",
             0x1F0B: "Atom processor C2000 SoC Transaction Router",
             0x1F0C: "Atom processor C2000 SoC Transaction Router",
             0x1F0D: "Atom processor C2000 SoC Transaction Router",
             0x1F0E: "Atom processor C2000 SoC Transaction Router",
             0x1F0F: "Atom processor C2000 SoC Transaction Router",
             0x1F10: "Atom processor C2000 PCIe Root Port 1",
             0x1F11: "Atom processor C2000 PCIe Root Port 2",
             0x1F12: "Atom processor C2000 PCIe Root Port 3",
             0x1F13: "Atom processor C2000 PCIe Root Port 4",
             0x1F14: "Atom processor C2000 RAS",
             0x1F15: "Atom processor C2000 SMBus 2.0",
             0x1F16: "Atom processor C2000 RCEC",
             0x1F18: "Atom processor C2000 QAT",
             0x1F19: "Atom processor C2000 QAT",
             0x1F20: "Atom processor C2000 4-Port IDE SATA2 Controller",
             0x1F21: "Atom processor C2000 4-Port IDE SATA2 Controller",
             0x1F22: "Atom processor C2000 AHCI SATA2 Controller",
             0x1F23: "Atom processor C2000 AHCI SATA2 Controller",
             0x1F24: "Atom processor C2000 RAID SATA2 Controller",
             0x1F25: "Atom processor C2000 RAID SATA2 Controller",
             0x1F26: "Atom processor C2000 RAID SATA2 Controller",
             0x1F27: "Atom processor C2000 RAID SATA2 Controller",
             0x1F2C: "Atom processor C2000 USB Enhanced Host Controller",
             0x1F2E: "Atom processor C2000 RAID SATA2 Controller",
             0x1F2F: "Atom processor C2000 RAID SATA2 Controller",
             0x1F30: "Atom processor C2000 2-Port IDE SATA3 Controller",
             0x1F31: "Atom processor C2000 2-Port IDE SATA3 Controller",
             0x1F32: "Atom processor C2000 AHCI SATA3 Controller",
             0x1F33: "Atom processor C2000 AHCI SATA3 Controller",
             0x1F34: "Atom processor C2000 RAID SATA3 Controller",
             0x1F35: "Atom processor C2000 RAID SATA3 Controller",
             0x1F36: "Atom processor C2000 RAID SATA3 Controller",
             0x1F37: "Atom processor C2000 RAID SATA3 Controller",
             0x1F38: "Atom processor C2000 PCU",
             0x1F39: "Atom processor C2000 PCU",
             0x1F3A: "Atom processor C2000 PCU",
             0x1F3B: "Atom processor C2000 PCU",
             0x1F3C: "Atom processor C2000 PCU SMBus",
             0x1F3D: "Atom Processor C2000 PECI SMBus",
             0x1F3E: "Atom processor C2000 RAID SATA3 Controller",
             0x1F3F: "Atom processor C2000 RAID SATA3 Controller",
             0x1F40: "Ethernet Connection I354 1.0 GbE Backplane",
             0x1F41: "Ethernet Connection I354",
             0x1F42: "Atom processor C2000 GbE",
             0x1F44: "Atom processor C2000 GbE Virtual Function",
             0x1F45: "Ethernet Connection I354 2.5 GbE Backplane",
             0x2014: "Sky Lake-E Ubox Registers",
             0x2015: "Sky Lake-E Ubox Registers",
             0x2016: "Sky Lake-E Ubox Registers",
             0x2018: "Sky Lake-E M2PCI Registers",
             0x201A: "Sky Lake-E Non-Transparent Bridge Registers",
             0x201C: "Sky Lake-E Non-Transparent Bridge Registers",
             0x201D: "Volume Management Device NVMe RAID Controller",
             0x2020: "Sky Lake-E DMI3 Registers",
             0x2021: "Sky Lake-E CBDMA Registers",
             0x2024: "Sky Lake-E MM/Vt-d Configuration Registers",
             0x2025: "Sky Lake-E RAS",
             0x2026: "Sky Lake-E IOAPIC",
             0x2030: "Sky Lake-E PCI Express Root Port A",
             0x2031: "Sky Lake-E PCI Express Root Port B",
             0x2032: "Sky Lake-E PCI Express Root Port C",
             0x2033: "Sky Lake-E PCI Express Root Port D",
             0x2034: "Sky Lake-E VT-d",
             0x2035: "Sky Lake-E RAS Configuration Registers",
             0x2036: "Sky Lake-E IOxAPIC Configuration Registers",
             0x2040: "Sky Lake-E Integrated Memory Controller",
             0x2041: "Sky Lake-E Integrated Memory Controller",
             0x2042: "Sky Lake-E Integrated Memory Controller",
             0x2043: "Sky Lake-E Integrated Memory Controller",
             0x2044: "Sky Lake-E Integrated Memory Controller",
             0x2045: "Sky Lake-E LM Channel 1",
             0x2046: "Sky Lake-E LMS Channel 1",
             0x2047: "Sky Lake-E LMDP Channel 1",
             0x2048: "Sky Lake-E DECS Channel 2",
             0x2049: "Sky Lake-E LM Channel 2",
             0x204A: "Sky Lake-E LMS Channel 2",
             0x204B: "Sky Lake-E LMDP Channel 2",
             0x204C: "Sky Lake-E M3KTI Registers",
             0x204D: "Sky Lake-E M3KTI Registers",
             0x204E: "Sky Lake-E M3KTI Registers",
             0x2054: "Sky Lake-E CHA Registers",
             0x2055: "Sky Lake-E CHA Registers",
             0x2056: "Sky Lake-E CHA Registers",
             0x2057: "Sky Lake-E CHA Registers",
             0x2058: "Sky Lake-E KTI 0",
             0x2059: "Sky Lake-E UPI Registers",
             0x2066: "Sky Lake-E Integrated Memory Controller",
             0x2068: "Sky Lake-E DDRIO Registers",
             0x2069: "Sky Lake-E DDRIO Registers",
             0x206A: "Sky Lake-E IOxAPIC Configuration Registers",
             0x206E: "Sky Lake-E DDRIO Registers",
             0x206F: "Sky Lake-E DDRIO Registers",
             0x2078: "Sky Lake-E PCU Registers",
             0x207A: "Sky Lake-E PCU Registers",
             0x2080: "Sky Lake-E PCU Registers",
             0x2081: "Sky Lake-E PCU Registers",
             0x2082: "Sky Lake-E PCU Registers",
             0x2083: "Sky Lake-E PCU Registers",
             0x2084: "Sky Lake-E PCU Registers",
             0x2085: "Sky Lake-E PCU Registers",
             0x2086: "Sky Lake-E PCU Registers",
             0x2088: "Sky Lake-E DDRIO Registers",
             0x208D: "Sky Lake-E CHA Registers",
             0x208E: "Sky Lake-E CHA Registers",
             0x2240: "Larrabee",
             0x2241: "Larrabee",
             0x2250: "Xeon Phi coprocessor 5100 series",
             0x225C: "Xeon Phi coprocessor SE10/7120 series",
             0x225D: "Xeon Phi coprocessor 3120 series",
             0x225E: "Xeon Phi coprocessor 31S1",
             0x2262: "Xeon Phi coprocessor 7220",
             0x2280: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SoC Transaction Register",
             0x2284: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series High Definition Audio Controller",
             0x2286: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO1 DMA Controller",
             0x228A: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO1 HSUART Controller #1",
             0x228C: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO1 HSUART Controller #2",
             0x2292: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx SMBus Controller",
             0x2294: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series MMC Controller",
             0x2295: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SDIO Controller",
             0x2296: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SD Controller",
             0x2298: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series Trusted Execution Engine",
             0x229C: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCU",
             0x22A3: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SATA Controller",
             0x22A4: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SATA AHCI Controller",
             0x22A8: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series Low Power Engine Audio",
             0x22B0: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Integrated Graphics Controller",
             0x22B1: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Integrated Graphics Controller",
             0x22B5: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series USB xHCI Controller",
             0x22B8: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series Imaging Unit",
             0x22C0: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 DMA Controller",
             0x22C1: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #1",
             0x22C2: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #2",
             0x22C3: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #3",
             0x22C4: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #4",
             0x22C5: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #5",
             0x22C6: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #6",
             0x22C7: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #7",
             0x22C8: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Express Port #1",
             0x22CA: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Express Port #2",
             0x22CC: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Express Port #3",
             0x22CE: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Express Port #4",
             0x22DC: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series Power Management Controller",
             0x2310: "DH89xxCC LPC Controller",
             0x2323: "DH89xxCC 4 Port SATA AHCI Controller",
             0x2330: "DH89xxCC SMBus Controller",
             0x2331: "DH89xxCC Chap Counter",
             0x2332: "DH89xxCC Thermal Subsystem",
             0x2334: "DH89xxCC USB2 Enhanced Host Controller #1",
             0x2335: "DH89xxCC USB2 Enhanced Host Controller #1",
             0x2342: "DH89xxCC PCI Express Root Port #1",
             0x2343: "DH89xxCC PCI Express Root Port #1",
             0x2344: "DH89xxCC PCI Express Root Port #2",
             0x2345: "DH89xxCC PCI Express Root Port #2",
             0x2346: "DH89xxCC PCI Express Root Port #3",
             0x2347: "DH89xxCC PCI Express Root Port #3",
             0x2348: "DH89xxCC PCI Express Root Port #4",
             0x2349: "DH89xxCC PCI Express Root Port #4",
             0x2360: "DH89xxCC Watchdog Timer",
             0x2364: "DH89xxCC MEI 0",
             0x2365: "DH89xxCC MEI 1",
             0x2390: "DH895XCC Series LPC Controller",
             0x23A1: "DH895XCC Series 2-Port SATA Controller [IDE Mode]",
             0x23A3: "DH895XCC Series 4-Port SATA Controller [AHCI Mode]",
             0x23A6: "DH895XCC Series 2-Port SATA Controller [IDE Mode]",
             0x23B0: "DH895XCC Series SMBus Controller",
             0x23B1: "DH895XCC Series CHAP Counter",
             0x23B2: "DH895XCC Series Thermal Management Controller",
             0x23B4: "DH895XCC Series USB2 Enhanced Host Controller #1",
             0x23B5: "DH895XCC Series USB2 Enhanced Host Controller #1",
             0x23C2: "DH895XCC Series PCI Express Root Port #1",
             0x23C3: "DH895XCC Series PCI Express Root Port #1",
             0x23C4: "DH895XCC Series PCI Express Root Port #2",
             0x23C5: "DH895XCC Series PCI Express Root Port #2",
             0x23C6: "CDH895XCC Series PCI Express Root Port #3",
             0x23C7: "DH895XCC Series PCI Express Root Port #3",
             0x23C8: "DH895XCC Series PCI Express Root Port #4",
             0x23C9: "DH895XCC Series PCI Express Root Port #4",
             0x23E0: "DH895XCC Series Watchdog Timer",
             0x23E4: "DH895XCC Series MEI Controller #1",
             0x23E5: "DH895XCC Series MEI Controller #2",
             0x2410: "82801AA ISA Bridge (LPC)",
             0x2411: "82801AA IDE Controller",
             0x2412: "82801AA USB Controller",
             0x2413: "82801AA SMBus Controller",
             0x2415: "82801AA AC'97 Audio Controller",
             0x2416: "82801AA AC'97 Modem Controller",
             0x2418: "82801AA PCI Bridge",
             0x2420: "82801AB ISA Bridge (LPC)",
             0x2421: "82801AB IDE Controller",
             0x2422: "82801AB USB Controller",
             0x2423: "82801AB SMBus Controller",
             0x2425: "82801AB AC'97 Audio Controller",
             0x2426: "82801AB AC'97 Modem Controller",
             0x2428: "82801AB PCI Bridge",
             0x2440: "82801BA ISA Bridge (LPC)",
             0x2442: "82801BA/BAM UHCI USB 1.1 Controller #1",
             0x2443: "82801BA/BAM SMBus Controller",
             0x2444: "82801BA/BAM UHCI USB 1.1 Controller #2",
             0x2445: "82801BA/BAM AC'97 Audio Controller",
             0x2446: "82801BA/BAM AC'97 Modem Controller",
             0x2448: "82801 Mobile PCI Bridge",
             0x2449: "82801BA/BAM/CA/CAM Ethernet Controller",
             0x244A: "82801BAM IDE U100 Controller",
             0x244B: "82801BA IDE U100 Controller",
             0x244C: "82801BAM ISA Bridge (LPC)",
             0x244E: "82801 PCI Bridge",
             0x2450: "82801E ISA Bridge (LPC)",
             0x2452: "82801E USB Controller",
             0x2453: "82801E SMBus Controller",
             0x2459: "82801E Ethernet Controller 0",
             0x245B: "82801E IDE U100 Controller",
             0x245D: "82801E Ethernet Controller 1",
             0x245E: "82801E PCI Bridge",
             0x2480: "82801CA LPC Interface Controller",
             0x2482: "82801CA/CAM USB Controller #1",
             0x2483: "82801CA/CAM SMBus Controller",
             0x2484: "82801CA/CAM USB Controller #2",
             0x2485: "82801CA/CAM AC'97 Audio Controller",
             0x2486: "82801CA/CAM AC'97 Modem Controller",
             0x2487: "82801CA/CAM USB Controller #3",
             0x248A: "82801CAM IDE U100 Controller",
             0x248B: "82801CA Ultra ATA Storage Controller",
             0x248C: "82801CAM ISA Bridge (LPC)",
             0x24C0: "82801DB/DBL (ICH4/ICH4-L) LPC Interface Bridge",
             0x24C1: "82801DBL (ICH4-L) IDE Controller",
             0x24C2: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) USB UHCI Controller #1",
             0x24C3: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) SMBus Controller",
             0x24C4: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) USB UHCI Controller #2",
             0x24C5: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) AC'97 Audio Controller",
             0x24C6: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) AC'97 Modem Controller",
             0x24C7: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) USB UHCI Controller #3",
             0x24CA: "82801DBM (ICH4-M) IDE Controller",
             0x24CB: "82801DB (ICH4) IDE Controller",
             0x24CC: "82801DBM (ICH4-M) LPC Interface Bridge",
             0x24CD: "82801DB/DBM (ICH4/ICH4-M) USB2 EHCI Controller",
             0x24D0: "82801EB/ER (ICH5/ICH5R) LPC Interface Bridge",
             0x24D1: "82801EB (ICH5) SATA Controller",
             0x24D2: "82801EB/ER (ICH5/ICH5R) USB UHCI Controller #1",
             0x24D3: "82801EB/ER (ICH5/ICH5R) SMBus Controller",
             0x24D4: "82801EB/ER (ICH5/ICH5R) USB UHCI Controller #2",
             0x24D5: "82801EB/ER (ICH5/ICH5R) AC'97 Audio Controller",
             0x24D6: "82801EB/ER (ICH5/ICH5R) AC'97 Modem Controller",
             0x24D7: "82801EB/ER (ICH5/ICH5R) USB UHCI Controller #3",
             0x24DB: "82801EB/ER (ICH5/ICH5R) IDE Controller",
             0x24DC: "82801EB (ICH5) LPC Interface Bridge",
             0x24DD: "82801EB/ER (ICH5/ICH5R) USB2 EHCI Controller",
             0x24DE: "82801EB/ER (ICH5/ICH5R) USB UHCI Controller #4",
             0x24DF: "82801ER (ICH5R) SATA Controller",
             0x24F0: "Omni-Path HFI Silicon 100 Series [discrete]",
             0x24F1: "Omni-Path HFI Silicon 100 Series [integrated]",
             0x24F3: "Wireless 8260",
             0x24F4: "Wireless 8260",
             0x24FB: "Dual Band Wireless-AC 3168NGW [Stone Peak]",
             0x24FD: "Wireless 8265 / 8275",
             0x2500: "82820 820 (Camino) Chipset Host Bridge (MCH)",
             0x2501: "82820 820 (Camino) Chipset Host Bridge (MCH)",
             0x250B: "82820 820 (Camino) Chipset Host Bridge",
             0x250F: "82820 820 (Camino) Chipset AGP Bridge",
             0x2520: "82805AA MTH Memory Translator Hub",
             0x2521: "82804AA MRH-S Memory Repeater Hub for SDRAM",
             0x2522: "NVMe Optane Memory Series",
             0x2526: "Wireless-AC 9260",
             0x2530: "82850 850 (Tehama) Chipset Host Bridge (MCH)",
             0x2531: "82860 860 (Wombat) Chipset Host Bridge (MCH)",
             0x2532: "82850 850 (Tehama) Chipset AGP Bridge",
             0x2533: "82860 860 (Wombat) Chipset AGP Bridge",
             0x2534: "82860 860 (Wombat) Chipset PCI Bridge",
             0x2540: "E7500 Memory Controller Hub",
             0x2541: "E7500/E7501 Host RASUM Controller",
             0x2543: "E7500/E7501 Hub Interface B PCI-to-PCI Bridge",
             0x2544: "E7500/E7501 Hub Interface B RASUM Controller",
             0x2545: "E7500/E7501 Hub Interface C PCI-to-PCI Bridge",
             0x2546: "E7500/E7501 Hub Interface C RASUM Controller",
             0x2547: "E7500/E7501 Hub Interface D PCI-to-PCI Bridge",
             0x2548: "E7500/E7501 Hub Interface D RASUM Controller",
             0x254C: "E7501 Memory Controller Hub",
             0x2550: "E7505 Memory Controller Hub",
             0x2551: "E7505/E7205 Series RAS Controller",
             0x2552: "E7505/E7205 PCI-to-AGP Bridge",
             0x2553: "E7505 Hub Interface B PCI-to-PCI Bridge",
             0x2554: "E7505 Hub Interface B PCI-to-PCI Bridge RAS Controller",
             0x255D: "E7205 Memory Controller Hub",
             0x2560: "82845G/GL[Brookdale-G]/GE/PE DRAM Controller/Host-Hub Interface",
             0x2561: "82845G/GL[Brookdale-G]/GE/PE Host-to-AGP Bridge",
             0x2562: "82845G/GL[Brookdale-G]/GE Chipset Integrated Graphics Device",
             0x2570: "82865G/PE/P DRAM Controller/Host-Hub Interface",
             0x2571: "82865G/PE/P AGP Bridge",
             0x2572: "82865G Integrated Graphics Controller",
             0x2573: "82865G/PE/P PCI to CSA Bridge",
             0x2576: "82865G/PE/P Processor to I/O Memory Interface",
             0x2578: "82875P/E7210 Memory Controller Hub",
             0x2579: "82875P Processor to AGP Controller",
             0x257B: "82875P/E7210 Processor to PCI to CSA Bridge",
             0x257E: "82875P/E7210 Processor to I/O Memory Interface",
             0x2580: "82915G/P/GV/GL/PL/910GL Memory Controller Hub",
             0x2581: "82915G/P/GV/GL/PL/910GL PCI Express Root Port",
             0x2582: "82915G/GV/910GL Integrated Graphics Controller",
             0x2584: "82925X/XE Memory Controller Hub",
             0x2585: "82925X/XE PCI Express Root Port",
             0x2588: "E7220/E7221 Memory Controller Hub",
             0x2589: "E7220/E7221 PCI Express Root Port",
             0x258A: "E7221 Integrated Graphics Controller",
             0x2590: "Mobile 915GM/PM/GMS/910GML Express Processor to DRAM Controller",
             0x2591: "Mobile 915GM/PM Express PCI Express Root Port",
             0x2592: "Mobile 915GM/GMS/910GML Express Graphics Controller",
             0x25A1: "6300ESB LPC Interface Controller",
             0x25A2: "6300ESB PATA Storage Controller",
             0x25A3: "6300ESB SATA Storage Controller",
             0x25A4: "6300ESB SMBus Controller",
             0x25A6: "6300ESB AC'97 Audio Controller",
             0x25A7: "6300ESB AC'97 Modem Controller",
             0x25A9: "6300ESB USB Universal Host Controller",
             0x25AA: "6300ESB USB Universal Host Controller",
             0x25AB: "6300ESB Watchdog Timer",
             0x25AC: "6300ESB I/O Advanced Programmable Interrupt Controller",
             0x25AD: "6300ESB USB2 Enhanced Host Controller",
             0x25AE: "6300ESB 64-bit PCI-X Bridge",
             0x25B0: "6300ESB SATA RAID Controller",
             0x25C0: "5000X Chipset Memory Controller Hub",
             0x25D0: "5000Z Chipset Memory Controller Hub",
             0x25D4: "5000V Chipset Memory Controller Hub",
             0x25D8: "5000P Chipset Memory Controller Hub",
             0x25E2: "5000 Series Chipset PCI Express x4 Port 2",
             0x25E3: "5000 Series Chipset PCI Express x4 Port 3",
             0x25E4: "5000 Series Chipset PCI Express x4 Port 4",
             0x25E5: "5000 Series Chipset PCI Express x4 Port 5",
             0x25E6: "5000 Series Chipset PCI Express x4 Port 6",
             0x25E7: "5000 Series Chipset PCI Express x4 Port 7",
             0x25F0: "5000 Series Chipset FSB Registers",
             0x25F1: "5000 Series Chipset Reserved Registers",
             0x25F3: "5000 Series Chipset Reserved Registers",
             0x25F5: "5000 Series Chipset FBD Registers",
             0x25F6: "5000 Series Chipset FBD Registers",
             0x25F7: "5000 Series Chipset PCI Express x8 Port 2-3",
             0x25F8: "5000 Series Chipset PCI Express x8 Port 4-5",
             0x25F9: "5000 Series Chipset PCI Express x8 Port 6-7",
             0x25FA: "5000X Chipset PCI Express x16 Port 4-7",
             0x2600: "E8500/E8501 Hub Interface 1.5",
             0x2601: "E8500/E8501 PCI Express x4 Port D",
             0x2602: "E8500/E8501 PCI Express x4 Port C0",
             0x2603: "E8500/E8501 PCI Express x4 Port C1",
             0x2604: "E8500/E8501 PCI Express x4 Port B0",
             0x2605: "E8500/E8501 PCI Express x4 Port B1",
             0x2606: "E8500/E8501 PCI Express x4 Port A0",
             0x2607: "E8500/E8501 PCI Express x4 Port A1",
             0x2608: "E8500/E8501 PCI Express x8 Port C",
             0x2609: "E8500/E8501 PCI Express x8 Port B",
             0x260A: "E8500/E8501 PCI Express x8 Port A",
             0x260C: "E8500/E8501 IMI Registers",
             0x2610: "E8500/E8501 FSB Registers",
             0x2611: "E8500/E8501 Address Mapping Registers",
             0x2612: "E8500/E8501 RAS Registers",
             0x2613: "E8500/E8501 Reserved Registers",
             0x2614: "E8500/E8501 Reserved Registers",
             0x2615: "E8500/E8501 Miscellaneous Registers",
             0x2617: "E8500/E8501 Reserved Registers",
             0x2618: "E8500/E8501 Reserved Registers",
             0x2619: "E8500/E8501 Reserved Registers",
             0x261A: "E8500/E8501 Reserved Registers",
             0x261B: "E8500/E8501 Reserved Registers",
             0x261C: "E8500/E8501 Reserved Registers",
             0x261D: "E8500/E8501 Reserved Registers",
             0x261E: "E8500/E8501 Reserved Registers",
             0x2620: "E8500/E8501 eXternal Memory Bridge",
             0x2621: "E8500/E8501 XMB Miscellaneous Registers",
             0x2622: "E8500/E8501 XMB Memory Interleaving Registers",
             0x2623: "E8500/E8501 XMB DDR Initialization and Calibration",
             0x2624: "E8500/E8501 XMB Reserved Registers",
             0x2625: "E8500/E8501 XMB Reserved Registers",
             0x2626: "E8500/E8501 XMB Reserved Registers",
             0x2627: "E8500/E8501 XMB Reserved Registers",
             0x2640: "82801FB/FR (ICH6/ICH6R) LPC Interface Bridge",
             0x2641: "82801FBM (ICH6M) LPC Interface Bridge",
             0x2642: "82801FW/FRW (ICH6W/ICH6RW) LPC Interface Bridge",
             0x2651: "82801FB/FW (ICH6/ICH6W) SATA Controller",
             0x2652: "82801FR/FRW (ICH6R/ICH6RW) SATA Controller",
             0x2653: "82801FBM (ICH6M) SATA Controller",
             0x2658: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB UHCI #1",
             0x2659: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB UHCI #2",
             0x265A: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB UHCI #3",
             0x265B: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB UHCI #4",
             0x265C: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB2 EHCI Controller",
             0x2660: "82801FB/FBM/FR/FW/FRW (ICH6 Family) PCI Express Port 1",
             0x2662: "82801FB/FBM/FR/FW/FRW (ICH6 Family) PCI Express Port 2",
             0x2664: "82801FB/FBM/FR/FW/FRW (ICH6 Family) PCI Express Port 3",
             0x2666: "82801FB/FBM/FR/FW/FRW (ICH6 Family) PCI Express Port 4",
             0x2668: "82801FB/FBM/FR/FW/FRW (ICH6 Family) High Definition Audio Controller",
             0x266A: "82801FB/FBM/FR/FW/FRW (ICH6 Family) SMBus Controller",
             0x266C: "82801FB/FBM/FR/FW/FRW (ICH6 Family) LAN Controller",
             0x266D: "82801FB/FBM/FR/FW/FRW (ICH6 Family) AC'97 Modem Controller",
             0x266E: "82801FB/FBM/FR/FW/FRW (ICH6 Family) AC'97 Audio Controller",
             0x266F: "82801FB/FBM/FR/FW/FRW (ICH6 Family) IDE Controller",
             0x2670: "631xESB/632xESB/3100 Chipset LPC Interface Controller",
             0x2680: "631xESB/632xESB/3100 Chipset SATA IDE Controller",
             0x2681: "631xESB/632xESB SATA AHCI Controller",
             0x2682: "631xESB/632xESB SATA RAID Controller",
             0x2683: "631xESB/632xESB SATA RAID Controller",
             0x2688: "631xESB/632xESB/3100 Chipset UHCI USB Controller #1",
             0x2689: "631xESB/632xESB/3100 Chipset UHCI USB Controller #2",
             0x268A: "631xESB/632xESB/3100 Chipset UHCI USB Controller #3",
             0x268B: "631xESB/632xESB/3100 Chipset UHCI USB Controller #4",
             0x268C: "631xESB/632xESB/3100 Chipset EHCI USB2 Controller",
             0x2690: "631xESB/632xESB/3100 Chipset PCI Express Root Port 1",
             0x2692: "631xESB/632xESB/3100 Chipset PCI Express Root Port 2",
             0x2694: "631xESB/632xESB/3100 Chipset PCI Express Root Port 3",
             0x2696: "631xESB/632xESB/3100 Chipset PCI Express Root Port 4",
             0x2698: "631xESB/632xESB AC '97 Audio Controller",
             0x2699: "631xESB/632xESB AC '97 Modem Controller",
             0x269A: "631xESB/632xESB High Definition Audio Controller",
             0x269B: "631xESB/632xESB/3100 Chipset SMBus Controller",
             0x269E: "631xESB/632xESB IDE Controller",
             0x2700: "Optane SSD 900P Series",
             0x2701: "NVMe Datacenter SSD [Optane]",
             0x2723: "Wi-Fi 6 AX200",
             0x2725: "Wi-Fi 6 AX210/AX211/AX411 160MHz",
             0x2770: "82945G/GZ/P/PL Memory Controller Hub",
             0x2771: "82945G/GZ/P/PL PCI Express Root Port",
             0x2772: "82945G/GZ Integrated Graphics Controller",
             0x2774: "82955X Memory Controller Hub",
             0x2775: "82955X PCI Express Root Port",
             0x2776: "82945G/GZ Integrated Graphics Controller",
             0x2778: "E7230/3000/3010 Memory Controller Hub",
             0x2779: "E7230/3000/3010 PCI Express Root Port",
             0x277A: "82975X/3010 PCI Express Root Port",
             0x277C: "82975X Memory Controller Hub",
             0x277D: "82975X PCI Express Root Port",
             0x2780: "82915G/GV/GL/910GL [Grantsdale] Graphics Device",
             0x2782: "82915G Integrated Graphics Controller",
             0x2792: "Mobile 915GM/GMS/910GML Express Graphics Controller",
             0x27A0: "Mobile 945GM/PM/GMS, 943/940GML and 945GT Express Memory Controller Hub",
             0x27A1: "Mobile 945GM/PM/GMS, 943/940GML and 945GT Express PCI Express Root Port",
             0x27A2: "Mobile 945GM/GMS, 943/940GML Express Integrated Graphics Controller",
             0x27A6: "Mobile 945GM/GMS/GME, 943/940GML Express Integrated Graphics Controller",
             0x27AC: "Mobile 945GSE Express Memory Controller Hub",
             0x27AD: "Mobile 945GSE Express PCI Express Root Port",
             0x27AE: "Mobile 945GSE Express Integrated Graphics Controller",
             0x27B0: "82801GH (ICH7DH) LPC Interface Bridge",
             0x27B8: "82801GB/GR (ICH7 Family) LPC Interface Bridge",
             0x27B9: "82801GBM (ICH7-M) LPC Interface Bridge",
             0x27BC: "NM10 Family LPC Controller",
             0x27BD: "82801GHM (ICH7-M DH) LPC Interface Bridge",
             0x27C0: "NM10/ICH7 Family SATA Controller [IDE mode]",
             0x27C1: "NM10/ICH7 Family SATA Controller [AHCI mode]",
             0x27C3: "82801GR/GDH (ICH7R/ICH7DH) SATA Controller [RAID mode]",
             0x27C4: "82801GBM/GHM (ICH7-M Family) SATA Controller [IDE mode]",
             0x27C5: "82801GBM/GHM (ICH7-M Family) SATA Controller [AHCI mode]",
             0x27C6: "82801GHM (ICH7-M DH) SATA Controller [RAID mode]",
             0x27C8: "NM10/ICH7 Family USB UHCI Controller #1",
             0x27C9: "NM10/ICH7 Family USB UHCI Controller #2",
             0x27CA: "NM10/ICH7 Family USB UHCI Controller #3",
             0x27CB: "NM10/ICH7 Family USB UHCI Controller #4",
             0x27CC: "NM10/ICH7 Family USB2 EHCI Controller",
             0x27D0: "NM10/ICH7 Family PCI Express Port 1",
             0x27D2: "NM10/ICH7 Family PCI Express Port 2",
             0x27D4: "NM10/ICH7 Family PCI Express Port 3",
             0x27D6: "NM10/ICH7 Family PCI Express Port 4",
             0x27D8: "NM10/ICH7 Family High Definition Audio Controller",
             0x27DA: "NM10/ICH7 Family SMBus Controller",
             0x27DC: "NM10/ICH7 Family LAN Controller",
             0x27DD: "82801G (ICH7 Family) AC'97 Modem Controller",
             0x27DE: "82801G (ICH7 Family) AC'97 Audio Controller",
             0x27DF: "82801G (ICH7 Family) IDE Controller",
             0x27E0: "82801GR/GH/GHM (ICH7 Family) PCI Express Port 5",
             0x27E2: "82801GR/GH/GHM (ICH7 Family) PCI Express Port 6",
             0x2810: "82801HB/HR (ICH8/R) LPC Interface Controller",
             0x2811: "82801HEM (ICH8M-E) LPC Interface Controller",
             0x2812: "82801HH (ICH8DH) LPC Interface Controller",
             0x2814: "82801HO (ICH8DO) LPC Interface Controller",
             0x2815: "82801HM (ICH8M) LPC Interface Controller",
             0x2820: "82801H (ICH8 Family) 4 port SATA Controller [IDE mode]",
             0x2821: "82801HR/HO/HH (ICH8R/DO/DH) 6 port SATA Controller [AHCI mode]",
             0x2822: "SATA Controller [RAID mode]",
             0x2823: "C610/X99 series chipset sSATA Controller [RAID mode]",
             0x2824: "82801HB (ICH8) 4 port SATA Controller [AHCI mode]",
             0x2825: "82801HR/HO/HH (ICH8R/DO/DH) 2 port SATA Controller [IDE mode]",
             0x2826: "C600/X79 series chipset SATA RAID Controller",
             0x2827: "C610/X99 series chipset sSATA Controller [RAID mode]",
             0x2828: "82801HM/HEM (ICH8M/ICH8M-E) SATA Controller [IDE mode]",
             0x2829: "82801HM/HEM (ICH8M/ICH8M-E) SATA Controller [AHCI mode]",
             0x282A: "82801 Mobile SATA Controller [RAID mode]",
             0x2830: "82801H (ICH8 Family) USB UHCI Controller #1",
             0x2831: "82801H (ICH8 Family) USB UHCI Controller #2",
             0x2832: "82801H (ICH8 Family) USB UHCI Controller #3",
             0x2833: "82801H (ICH8 Family) USB UHCI Controller #4",
             0x2834: "82801H (ICH8 Family) USB UHCI Controller #4",
             0x2835: "82801H (ICH8 Family) USB UHCI Controller #5",
             0x2836: "82801H (ICH8 Family) USB2 EHCI Controller #1",
             0x283A: "82801H (ICH8 Family) USB2 EHCI Controller #2",
             0x283E: "82801H (ICH8 Family) SMBus Controller",
             0x283F: "82801H (ICH8 Family) PCI Express Port 1",
             0x2841: "82801H (ICH8 Family) PCI Express Port 2",
             0x2843: "82801H (ICH8 Family) PCI Express Port 3",
             0x2845: "82801H (ICH8 Family) PCI Express Port 4",
             0x2847: "82801H (ICH8 Family) PCI Express Port 5",
             0x2849: "82801H (ICH8 Family) PCI Express Port 6",
             0x284B: "82801H (ICH8 Family) HD Audio Controller",
             0x284F: "82801H (ICH8 Family) Thermal Reporting Device",
             0x2850: "82801HM/HEM (ICH8M/ICH8M-E) IDE Controller",
             0x28C0: "Volume Management Device NVMe RAID Controller",
             0x2912: "82801IH (ICH9DH) LPC Interface Controller",
             0x2914: "82801IO (ICH9DO) LPC Interface Controller",
             0x2916: "82801IR (ICH9R) LPC Interface Controller",
             0x2917: "ICH9M-E LPC Interface Controller",
             0x2918: "82801IB (ICH9) LPC Interface Controller",
             0x2919: "ICH9M LPC Interface Controller",
             0x2920: "82801IR/IO/IH (ICH9R/DO/DH) 4 port SATA Controller [IDE mode]",
             0x2921: "82801IB (ICH9) 2 port SATA Controller [IDE mode]",
             0x2922: "82801IR/IO/IH (ICH9R/DO/DH) 6 port SATA Controller [AHCI mode]",
             0x2923: "82801IB (ICH9) 4 port SATA Controller [AHCI mode]",
             0x2925: "82801IR/IO (ICH9R/DO) SATA Controller [RAID mode]",
             0x2926: "82801I (ICH9 Family) 2 port SATA Controller [IDE mode]",
             0x2928: "82801IBM/IEM (ICH9M/ICH9M-E) 2 port SATA Controller [IDE mode]",
             0x2929: "82801IBM/IEM (ICH9M/ICH9M-E) 4 port SATA Controller [AHCI mode]",
             0x292C: "82801IEM (ICH9M-E) SATA Controller [RAID mode]",
             0x292D: "82801IBM/IEM (ICH9M/ICH9M-E) 2 port SATA Controller [IDE mode]",
             0x2930: "82801I (ICH9 Family) SMBus Controller",
             0x2932: "82801I (ICH9 Family) Thermal Subsystem",
             0x2934: "82801I (ICH9 Family) USB UHCI Controller #1",
             0x2935: "82801I (ICH9 Family) USB UHCI Controller #2",
             0x2936: "82801I (ICH9 Family) USB UHCI Controller #3",
             0x2937: "82801I (ICH9 Family) USB UHCI Controller #4",
             0x2938: "82801I (ICH9 Family) USB UHCI Controller #5",
             0x2939: "82801I (ICH9 Family) USB UHCI Controller #6",
             0x293A: "82801I (ICH9 Family) USB2 EHCI Controller #1",
             0x293C: "82801I (ICH9 Family) USB2 EHCI Controller #2",
             0x293E: "82801I (ICH9 Family) HD Audio Controller",
             0x2940: "82801I (ICH9 Family) PCI Express Port 1",
             0x2942: "82801I (ICH9 Family) PCI Express Port 2",
             0x2944: "82801I (ICH9 Family) PCI Express Port 3",
             0x2946: "82801I (ICH9 Family) PCI Express Port 4",
             0x2948: "82801I (ICH9 Family) PCI Express Port 5",
             0x294A: "82801I (ICH9 Family) PCI Express Port 6",
             0x294C: "82566DC-2 Gigabit Network Connection",
             0x2970: "82946GZ/PL/GL Memory Controller Hub",
             0x2971: "82946GZ/PL/GL PCI Express Root Port",
             0x2972: "82946GZ/GL Integrated Graphics Controller",
             0x2973: "82946GZ/GL Integrated Graphics Controller",
             0x2974: "82946GZ/GL HECI Controller",
             0x2975: "82946GZ/GL HECI Controller",
             0x2976: "82946GZ/GL PT IDER Controller",
             0x2977: "82946GZ/GL KT Controller",
             0x2980: "82G35 Express DRAM Controller",
             0x2981: "82G35 Express PCI Express Root Port",
             0x2982: "82G35 Express Integrated Graphics Controller",
             0x2983: "82G35 Express Integrated Graphics Controller",
             0x2984: "82G35 Express HECI Controller",
             0x2990: "82Q963/Q965 Memory Controller Hub",
             0x2991: "82Q963/Q965 PCI Express Root Port",
             0x2992: "82Q963/Q965 Integrated Graphics Controller",
             0x2993: "82Q963/Q965 Integrated Graphics Controller",
             0x2994: "82Q963/Q965 HECI Controller",
             0x2995: "82Q963/Q965 HECI Controller",
             0x2996: "82Q963/Q965 PT IDER Controller",
             0x2997: "82Q963/Q965 KT Controller",
             0x29A0: "82P965/G965 Memory Controller Hub",
             0x29A1: "82P965/G965 PCI Express Root Port",
             0x29A2: "82G965 Integrated Graphics Controller",
             0x29A3: "82G965 Integrated Graphics Controller",
             0x29A4: "82P965/G965 HECI Controller",
             0x29A5: "82P965/G965 HECI Controller",
             0x29A6: "82P965/G965 PT IDER Controller",
             0x29A7: "82P965/G965 KT Controller",
             0x29B0: "82Q35 Express DRAM Controller",
             0x29B1: "82Q35 Express PCI Express Root Port",
             0x29B2: "82Q35 Express Integrated Graphics Controller",
             0x29B3: "82Q35 Express Integrated Graphics Controller",
             0x29B4: "82Q35 Express MEI Controller",
             0x29B5: "82Q35 Express MEI Controller",
             0x29B6: "82Q35 Express PT IDER Controller",
             0x29B7: "82Q35 Express Serial KT Controller",
             0x29C0: "82G33/G31/P35/P31 Express DRAM Controller",
             0x29C1: "82G33/G31/P35/P31 Express PCI Express Root Port",
             0x29C2: "82G33/G31 Express Integrated Graphics Controller",
             0x29C3: "82G33/G31 Express Integrated Graphics Controller",
             0x29C4: "82G33/G31/P35/P31 Express MEI Controller",
             0x29C5: "82G33/G31/P35/P31 Express MEI Controller",
             0x29C6: "82G33/G31/P35/P31 Express PT IDER Controller",
             0x29C7: "82G33/G31/P35/P31 Express Serial KT Controller",
             0x29CF: "Virtual HECI Controller",
             0x29D0: "82Q33 Express DRAM Controller",
             0x29D1: "82Q33 Express PCI Express Root Port",
             0x29D2: "82Q33 Express Integrated Graphics Controller",
             0x29D3: "82Q33 Express Integrated Graphics Controller",
             0x29D4: "82Q33 Express MEI Controller",
             0x29D5: "82Q33 Express MEI Controller",
             0x29D6: "82Q33 Express PT IDER Controller",
             0x29D7: "82Q33 Express Serial KT Controller",
             0x29E0: "82X38/X48 Express DRAM Controller",
             0x29E1: "82X38/X48 Express Host-Primary PCI Express Bridge",
             0x29E4: "82X38/X48 Express MEI Controller",
             0x29E5: "82X38/X48 Express MEI Controller",
             0x29E6: "82X38/X48 Express PT IDER Controller",
             0x29E7: "82X38/X48 Express Serial KT Controller",
             0x29E9: "82X38/X48 Express Host-Secondary PCI Express Bridge",
             0x29F0: "3200/3210 Chipset DRAM Controller",
             0x29F1: "3200/3210 Chipset Host-Primary PCI Express Bridge",
             0x29F4: "3200/3210 Chipset MEI Controller",
             0x29F5: "3200/3210 Chipset MEI Controller",
             0x29F6: "3200/3210 Chipset PT IDER Controller",
             0x29F7: "3200/3210 Chipset Serial KT Controller",
             0x29F9: "3210 Chipset Host-Secondary PCI Express Bridge",
             0x2A00: "Mobile PM965/GM965/GL960 Memory Controller Hub",
             0x2A01: "Mobile PM965/GM965/GL960 PCI Express Root Port",
             0x2A02: "Mobile GM965/GL960 Integrated Graphics Controller (primary)",
             0x2A03: "Mobile GM965/GL960 Integrated Graphics Controller (secondary)",
             0x2A04: "Mobile PM965/GM965 MEI Controller",
             0x2A05: "Mobile PM965/GM965 MEI Controller",
             0x2A06: "Mobile PM965/GM965 PT IDER Controller",
             0x2A07: "Mobile PM965/GM965 KT Controller",
             0x2A10: "Mobile GME965/GLE960 Memory Controller Hub",
             0x2A11: "Mobile GME965/GLE960 PCI Express Root Port",
             0x2A12: "Mobile GME965/GLE960 Integrated Graphics Controller",
             0x2A13: "Mobile GME965/GLE960 Integrated Graphics Controller",
             0x2A14: "Mobile GME965/GLE960 MEI Controller",
             0x2A15: "Mobile GME965/GLE960 MEI Controller",
             0x2A16: "Mobile GME965/GLE960 PT IDER Controller",
             0x2A17: "Mobile GME965/GLE960 KT Controller",
             0x2A40: "Mobile 4 Series Chipset Memory Controller Hub",
             0x2A41: "Mobile 4 Series Chipset PCI Express Graphics Port",
             0x2A42: "Mobile 4 Series Chipset Integrated Graphics Controller",
             0x2A43: "Mobile 4 Series Chipset Integrated Graphics Controller",
             0x2A44: "Mobile 4 Series Chipset MEI Controller",
             0x2A45: "Mobile 4 Series Chipset MEI Controller",
             0x2A46: "Mobile 4 Series Chipset PT IDER Controller",
             0x2A47: "Mobile 4 Series Chipset AMT SOL Redirection",
             0x2A50: "Cantiga MEI Controller",
             0x2A51: "Cantiga MEI Controller",
             0x2A52: "Cantiga PT IDER Controller",
             0x2A53: "Cantiga AMT SOL Redirection",
             0x2B00: "Xeon Processor E7 Product Family System Configuration Controller 1",
             0x2B02: "Xeon Processor E7 Product Family System Configuration Controller 2",
             0x2B04: "Xeon Processor E7 Product Family Power Controller",
             0x2B08: "Xeon Processor E7 Product Family Caching Agent 0",
             0x2B0C: "Xeon Processor E7 Product Family Caching Agent 1",
             0x2B10: "Xeon Processor E7 Product Family QPI Home Agent 0",
             0x2B13: "Xeon Processor E7 Product Family Memory Controller 0c",
             0x2B14: "Xeon Processor E7 Product Family Memory Controller 0a",
             0x2B16: "Xeon Processor E7 Product Family Memory Controller 0b",
             0x2B18: "Xeon Processor E7 Product Family QPI Home Agent 1",
             0x2B1B: "Xeon Processor E7 Product Family Memory Controller 1c",
             0x2B1C: "Xeon Processor E7 Product Family Memory Controller 1a",
             0x2B1E: "Xeon Processor E7 Product Family Memory Controller 1b",
             0x2B20: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 0",
             0x2B22: "Xeon Processor E7 Product Family System Configuration Controller 3",
             0x2B24: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 1",
             0x2B28: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 2",
             0x2B2A: "Xeon Processor E7 Product Family System Configuration Controller 4",
             0x2B2C: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 3",
             0x2B30: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 4",
             0x2B34: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 5",
             0x2B38: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 6",
             0x2B3C: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 7",
             0x2B40: "Xeon Processor E7 Product Family QPI Router Port 0-1",
             0x2B42: "Xeon Processor E7 Product Family QPI Router Port 2-3",
             0x2B44: "Xeon Processor E7 Product Family QPI Router Port 4-5",
             0x2B46: "Xeon Processor E7 Product Family QPI Router Port 6-7",
             0x2B48: "Xeon Processor E7 Product Family Test and Debug 0",
             0x2B4C: "Xeon Processor E7 Product Family Test and Debug 1",
             0x2B50: "Xeon Processor E7 Product Family QPI Physical Port 0: REUT control/status",
             0x2B52: "Xeon Processor E7 Product Family QPI Physical Port 0: Misc. control/status",
             0x2B54: "Xeon Processor E7 Product Family QPI Physical Port 1: REUT control/status",
             0x2B56: "Xeon Processor E7 Product Family QPI Physical Port 1: Misc. control/status",
             0x2B58: "Xeon Processor E7 Product Family QPI Physical Port 2: REUT control/status",
             0x2B5A: "Xeon Processor E7 Product Family QPI Physical Port 2: Misc. control/status",
             0x2B5C: "Xeon Processor E7 Product Family QPI Physical Port 3: REUT control/status",
             0x2B5E: "Xeon Processor E7 Product Family QPI Physical Port 3: Misc. control/status",
             0x2B60: "Xeon Processor E7 Product Family SMI Physical Port 0: REUT control/status",
             0x2B62: "Xeon Processor E7 Product Family SMI Physical Port 0: Misc control/status",
             0x2B64: "Xeon Processor E7 Product Family SMI Physical Port 1: REUT control/status",
             0x2B66: "Xeon Processor E7 Product Family SMI Physical Port 1: Misc control/status",
             0x2B68: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 8",
             0x2B6C: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 9",
             0x2B80: "Atom CE2700 Series [Puma 7]",
             0x2B98: "Puma 7 Trusted Execution Engine",
             0x2BB5: "Puma 7 xHCI Controller",
             0x2BB7: "Puma 7 USB Device Controller (OTG)",
             0x2BDC: "Puma 7 Thermal",
             0x2BE2: "Puma 7 Security Processor",
             0x2C01: "Xeon 5500/Core i7 QuickPath Architecture System Address Decoder",
             0x2C10: "Xeon 5500/Core i7 QPI Link 0",
             0x2C11: "Xeon 5500/Core i7 QPI Physical 0",
             0x2C14: "Xeon 5500/Core i7 QPI Link 1",
             0x2C15: "Xeon 5500/Core i7 QPI Physical 1",
             0x2C18: "Xeon 5500/Core i7 Integrated Memory Controller",
             0x2C19: "Xeon 5500/Core i7 Integrated Memory Controller Target Address Decoder",
             0x2C1A: "Xeon 5500/Core i7 Integrated Memory Controller RAS Registers",
             0x2C1C: "Xeon 5500/Core i7 Integrated Memory Controller Test Registers",
             0x2C20: "Xeon 5500/Core i7 Integrated Memory Controller Channel 0 Control Registers",
             0x2C21: "Xeon 5500/Core i7 Integrated Memory Controller Channel 0 Address Registers",
             0x2C22: "Xeon 5500/Core i7 Integrated Memory Controller Channel 0 Rank Registers",
             0x2C23: "Xeon 5500/Core i7 Integrated Memory Controller Channel 0 Thermal Control Registers",
             0x2C28: "Xeon 5500/Core i7 Integrated Memory Controller Channel 1 Control Registers",
             0x2C29: "Xeon 5500/Core i7 Integrated Memory Controller Channel 1 Address Registers",
             0x2C2A: "Xeon 5500/Core i7 Integrated Memory Controller Channel 1 Rank Registers",
             0x2C2B: "Xeon 5500/Core i7 Integrated Memory Controller Channel 1 Thermal Control Registers",
             0x2C30: "Xeon 5500/Core i7 Integrated Memory Controller Channel 2 Control Registers",
             0x2C31: "Xeon 5500/Core i7 Integrated Memory Controller Channel 2 Address Registers",
             0x2C32: "Xeon 5500/Core i7 Integrated Memory Controller Channel 2 Rank Registers",
             0x2C33: "Xeon 5500/Core i7 Integrated Memory Controller Channel 2 Thermal Control Registers",
             0x2C40: "Xeon 5500/Core i7 QuickPath Architecture Generic Non-Core Registers",
             0x2C41: "Xeon 5500/Core i7 QuickPath Architecture Generic Non-Core Registers",
             0x2C50: "Core Processor QuickPath Architecture Generic Non-Core Registers",
             0x2C51: "Core Processor QuickPath Architecture Generic Non-Core Registers",
             0x2C52: "Core Processor QuickPath Architecture Generic Non-Core Registers",
             0x2C53: "Core Processor QuickPath Architecture Generic Non-Core Registers",
             0x2C54: "Core Processor QuickPath Architecture Generic Non-Core Registers",
             0x2C55: "Core Processor QuickPath Architecture Generic Non-Core Registers",
             0x2C56: "Core Processor QuickPath Architecture Generic Non-Core Registers",
             0x2C57: "Core Processor QuickPath Architecture Generic Non-Core Registers",
             0x2C58: "Xeon C5500/C3500 QPI Generic Non-core Registers",
             0x2C59: "Xeon C5500/C3500 QPI Generic Non-core Registers",
             0x2C5A: "Xeon C5500/C3500 QPI Generic Non-core Registers",
             0x2C5B: "Xeon C5500/C3500 QPI Generic Non-core Registers",
             0x2C5C: "Xeon C5500/C3500 QPI Generic Non-core Registers",
             0x2C5D: "Xeon C5500/C3500 QPI Generic Non-core Registers",
             0x2C5E: "Xeon C5500/C3500 QPI Generic Non-core Registers",
             0x2C5F: "Xeon C5500/C3500 QPI Generic Non-core Registers",
             0x2C61: "Core Processor QuickPath Architecture Generic Non-core Registers",
             0x2C62: "Core Processor QuickPath Architecture Generic Non-core Registers",
             0x2C70: "Xeon 5600 Series QuickPath Architecture Generic Non-core Registers",
             0x2C81: "Core Processor QuickPath Architecture System Address Decoder",
             0x2C90: "Core Processor QPI Link 0",
             0x2C91: "Core Processor QPI Physical 0",
             0x2C98: "Core Processor Integrated Memory Controller",
             0x2C99: "Core Processor Integrated Memory Controller Target Address Decoder",
             0x2C9A: "Core Processor Integrated Memory Controller Test Registers",
             0x2C9C: "Core Processor Integrated Memory Controller Test Registers",
             0x2CA0: "Core Processor Integrated Memory Controller Channel 0 Control Registers",
             0x2CA1: "Core Processor Integrated Memory Controller Channel 0 Address Registers",
             0x2CA2: "Core Processor Integrated Memory Controller Channel 0 Rank Registers",
             0x2CA3: "Core Processor Integrated Memory Controller Channel 0 Thermal Control Registers",
             0x2CA8: "Core Processor Integrated Memory Controller Channel 1 Control Registers",
             0x2CA9: "Core Processor Integrated Memory Controller Channel 1 Address Registers",
             0x2CAA: "Core Processor Integrated Memory Controller Channel 1 Rank Registers",
             0x2CAB: "Core Processor Integrated Memory Controller Channel 1 Thermal Control Registers",
             0x2CC1: "Xeon C5500/C3500 QPI System Address Decoder",
             0x2CD0: "Xeon C5500/C3500 QPI Link 0",
             0x2CD1: "Xeon C5500/C3500 QPI Physical 0",
             0x2CD4: "Xeon C5500/C3500 QPI Link 1",
             0x2CD5: "Xeon C5500/C3500 QPI Physical 1",
             0x2CD8: "Xeon C5500/C3500 Integrated Memory Controller Registers",
             0x2CD9: "Xeon C5500/C3500 Integrated Memory Controller Target Address Decoder",
             0x2CDA: "Xeon C5500/C3500 Integrated Memory Controller RAS Registers",
             0x2CDC: "Xeon C5500/C3500 Integrated Memory Controller Test Registers",
             0x2CE0: "Xeon C5500/C3500 Integrated Memory Controller Channel 0 Control",
             0x2CE1: "Xeon C5500/C3500 Integrated Memory Controller Channel 0 Address",
             0x2CE2: "Xeon C5500/C3500 Integrated Memory Controller Channel 0 Rank",
             0x2CE3: "Xeon C5500/C3500 Integrated Memory Controller Channel 0 Thermal Control",
             0x2CE8: "Xeon C5500/C3500 Integrated Memory Controller Channel 1 Control",
             0x2CE9: "Xeon C5500/C3500 Integrated Memory Controller Channel 1 Address",
             0x2CEA: "Xeon C5500/C3500 Integrated Memory Controller Channel 1 Rank",
             0x2CEB: "Xeon C5500/C3500 Integrated Memory Controller Channel 1 Thermal Control",
             0x2CF0: "Xeon C5500/C3500 Integrated Memory Controller Channel 2 Control",
             0x2CF1: "Xeon C5500/C3500 Integrated Memory Controller Channel 2 Address",
             0x2CF2: "Xeon C5500/C3500 Integrated Memory Controller Channel 2 Rank",
             0x2CF3: "Xeon C5500/C3500 Integrated Memory Controller Channel 2 Thermal Control",
             0x2D01: "Core Processor QuickPath Architecture System Address Decoder",
             0x2D10: "Core Processor QPI Link 0",
             0x2D11: "1st Generation Core i3/5/7 Processor QPI Physical 0",
             0x2D12: "1st Generation Core i3/5/7 Processor Reserved",
             0x2D13: "1st Generation Core i3/5/7 Processor Reserved",
             0x2D81: "Xeon 5600 Series QuickPath Architecture System Address Decoder",
             0x2D90: "Xeon 5600 Series QPI Link 0",
             0x2D91: "Xeon 5600 Series QPI Physical 0",
             0x2D92: "Xeon 5600 Series Mirror Port Link 0",
             0x2D93: "Xeon 5600 Series Mirror Port Link 1",
             0x2D94: "Xeon 5600 Series QPI Link 1",
             0x2D95: "Xeon 5600 Series QPI Physical 1",
             0x2D98: "Xeon 5600 Series Integrated Memory Controller Registers",
             0x2D99: "Xeon 5600 Series Integrated Memory Controller Target Address Decoder",
             0x2D9A: "Xeon 5600 Series Integrated Memory Controller RAS Registers",
             0x2D9C: "Xeon 5600 Series Integrated Memory Controller Test Registers",
             0x2DA0: "Xeon 5600 Series Integrated Memory Controller Channel 0 Control",
             0x2DA1: "Xeon 5600 Series Integrated Memory Controller Channel 0 Address",
             0x2DA2: "Xeon 5600 Series Integrated Memory Controller Channel 0 Rank",
             0x2DA3: "Xeon 5600 Series Integrated Memory Controller Channel 0 Thermal Control",
             0x2DA8: "Xeon 5600 Series Integrated Memory Controller Channel 1 Control",
             0x2DA9: "Xeon 5600 Series Integrated Memory Controller Channel 1 Address",
             0x2DAA: "Xeon 5600 Series Integrated Memory Controller Channel 1 Rank",
             0x2DAB: "Xeon 5600 Series Integrated Memory Controller Channel 1 Thermal Control",
             0x2DB0: "Xeon 5600 Series Integrated Memory Controller Channel 2 Control",
             0x2DB1: "Xeon 5600 Series Integrated Memory Controller Channel 2 Address",
             0x2DB2: "Xeon 5600 Series Integrated Memory Controller Channel 2 Rank",
             0x2DB3: "Xeon 5600 Series Integrated Memory Controller Channel 2 Thermal Control",
             0x2E00: "4 Series Chipset DRAM Controller",
             0x2E01: "4 Series Chipset PCI Express Root Port",
             0x2E02: "4 Series Chipset Integrated Graphics Controller",
             0x2E03: "4 Series Chipset Integrated Graphics Controller",
             0x2E04: "4 Series Chipset HECI Controller",
             0x2E05: "4 Series Chipset HECI Controller",
             0x2E06: "4 Series Chipset PT IDER Controller",
             0x2E07: "4 Series Chipset Serial KT Controller",
             0x2E10: "4 Series Chipset DRAM Controller",
             0x2E11: "4 Series Chipset PCI Express Root Port",
             0x2E12: "4 Series Chipset Integrated Graphics Controller",
             0x2E13: "4 Series Chipset Integrated Graphics Controller",
             0x2E14: "4 Series Chipset HECI Controller",
             0x2E15: "4 Series Chipset HECI Controller",
             0x2E16: "4 Series Chipset PT IDER Controller",
             0x2E17: "4 Series Chipset Serial KT Controller",
             0x2E20: "4 Series Chipset DRAM Controller",
             0x2E21: "4 Series Chipset PCI Express Root Port",
             0x2E22: "4 Series Chipset Integrated Graphics Controller",
             0x2E23: "4 Series Chipset Integrated Graphics Controller",
             0x2E24: "4 Series Chipset HECI Controller",
             0x2E25: "4 Series Chipset HECI Controller",
             0x2E26: "4 Series Chipset PT IDER Controller",
             0x2E27: "4 Series Chipset Serial KT Controller",
             0x2E29: "4 Series Chipset PCI Express Root Port",
             0x2E30: "4 Series Chipset DRAM Controller",
             0x2E31: "4 Series Chipset PCI Express Root Port",
             0x2E32: "4 Series Chipset Integrated Graphics Controller",
             0x2E33: "4 Series Chipset Integrated Graphics Controller",
             0x2E34: "4 Series Chipset HECI Controller",
             0x2E35: "4 Series Chipset HECI Controller",
             0x2E36: "4 Series Chipset PT IDER Controller",
             0x2E37: "4 Series Chipset Serial KT Controller",
             0x2E40: "4 Series Chipset DRAM Controller",
             0x2E41: "4 Series Chipset PCI Express Root Port",
             0x2E42: "4 Series Chipset Integrated Graphics Controller",
             0x2E43: "4 Series Chipset Integrated Graphics Controller",
             0x2E44: "4 Series Chipset HECI Controller",
             0x2E45: "4 Series Chipset HECI Controller",
             0x2E46: "4 Series Chipset PT IDER Controller",
             0x2E47: "4 Series Chipset Serial KT Controller",
             0x2E50: "CE Media Processor CE3100",
             0x2E52: "CE Media Processor Clock and Reset Controller",
             0x2E58: "CE Media Processor Interrupt Controller",
             0x2E5A: "CE Media Processor CE3100 A/V Bridge",
             0x2E5B: "Graphics Media Accelerator 500 Graphics",
             0x2E5C: "CE Media Processor Video Decoder",
             0x2E5D: "CE Media Processor Transport Stream Interface",
             0x2E5E: "CE Media Processor Transport Stream Processor 0",
             0x2E5F: "CE Media Processor Audio DSP",
             0x2E60: "CE Media Processor Audio Interfaces",
             0x2E61: "CE Media Processor Video Display Controller",
             0x2E62: "CE Media Processor Video Processing Unit",
             0x2E63: "CE Media Processor HDMI Tx Interface",
             0x2E64: "Atom CE2600/3100/4100/4200/5300 Security Processor",
             0x2E65: "CE Media Processor Expansion Bus Interface",
             0x2E66: "CE Media Processor UART",
             0x2E67: "CE Media Processor General Purpose I/Os",
             0x2E68: "CE Media Processor I2C Interface",
             0x2E69: "CE Media Processor Smart Card Interface",
             0x2E6A: "CE Media Processor SPI Master Interface",
             0x2E6E: "CE Media Processor Gigabit Ethernet Controller",
             0x2E6F: "CE Media Processor Media Timing Unit",
             0x2E70: "CE Media Processor USB",
             0x2E71: "CE Media Processor SATA",
             0x2E73: "CE Media Processor CE3100 PCI Express",
             0x2E90: "4 Series Chipset DRAM Controller",
             0x2E91: "4 Series Chipset PCI Express Root Port",
             0x2E92: "4 Series Chipset Integrated Graphics Controller",
             0x2E93: "4 Series Chipset Integrated Graphics Controller",
             0x2E94: "4 Series Chipset HECI Controller",
             0x2E95: "4 Series Chipset HECI Controller",
             0x2E96: "4 Series Chipset PT IDER Controller",
             0x2F00: "Xeon E7 v3/Xeon E5 v3/Core i7 DMI2",
             0x2F01: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 0",
             0x2F02: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 1",
             0x2F03: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 1",
             0x2F04: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 2",
             0x2F05: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 2",
             0x2F06: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 2",
             0x2F07: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 2",
             0x2F08: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 3",
             0x2F09: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 3",
             0x2F0A: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 3",
             0x2F0B: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 3",
             0x2F0D: "Haswell Xeon Non-Transparent Bridge (Back-to-back)",
             0x2F0E: "Haswell Xeon Non-Transparent Bridge (Primary Side)",
             0x2F0F: "Haswell Xeon Non-Transparent Bridge (Secondary Side)",
             0x2F10: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F11: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F12: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F13: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F14: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F15: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F16: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F17: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F18: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F19: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F1A: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F1B: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F1C: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug",
             0x2F1D: "Xeon E7 v3/Xeon E5 v3/Core i7 PCIe Ring Interface",
             0x2F1E: "Xeon E7 v3/Xeon E5 v3/Core i7 Scratchpad & Semaphore Registers",
             0x2F1F: "Xeon E7 v3/Xeon E5 v3/Core i7 Scratchpad & Semaphore Registers",
             0x2F20: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 0",
             0x2F21: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 1",
             0x2F22: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 2",
             0x2F23: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 3",
             0x2F24: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 4",
             0x2F25: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 5",
             0x2F26: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 6",
             0x2F27: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 7",
             0x2F28: "Xeon E7 v3/Xeon E5 v3/Core i7 Address Map, VTd_Misc, System Management",
             0x2F29: "Xeon E7 v3/Xeon E5 v3/Core i7 Hot Plug",
             0x2F2A: "Xeon E7 v3/Xeon E5 v3/Core i7 RAS, Control Status and Global Errors",
             0x2F2C: "Xeon E7 v3/Xeon E5 v3/Core i7 I/O APIC",
             0x2F2E: "Xeon E7 v3/Xeon E5 v3/Core i7 RAID 5/6",
             0x2F2F: "Xeon E7 v3/Xeon E5 v3/Core i7 RAID 5/6",
             0x2F30: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 0",
             0x2F32: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0",
             0x2F33: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1",
             0x2F34: "Xeon E7 v3/Xeon E5 v3/Core i7 PCIe Ring Interface",
             0x2F36: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 0 & 1 Monitoring",
             0x2F37: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 0 & 1 Monitoring",
             0x2F38: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 1",
             0x2F39: "Xeon E7 v3/Xeon E5 v3/Core i7 I/O Performance Monitoring",
             0x2F3A: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2",
             0x2F3E: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 2 Monitoring",
             0x2F3F: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 2 Monitoring",
             0x2F40: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2",
             0x2F41: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 2 Monitoring",
             0x2F43: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2",
             0x2F45: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2 Debug",
             0x2F46: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2 Debug",
             0x2F47: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2 Debug",
             0x2F60: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 1",
             0x2F68: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Target Address, Thermal & RAS Registers",
             0x2F6A: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder",
             0x2F6B: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder",
             0x2F6C: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder",
             0x2F6D: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder",
             0x2F6E: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO Channel 2/3 Broadcast",
             0x2F6F: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO Global Broadcast",
             0x2F70: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 0 Debug",
             0x2F71: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Target Address, Thermal & RAS Registers",
             0x2F76: "Xeon E7 v3/Xeon E5 v3/Core i7 E3 QPI Link Debug",
             0x2F78: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 1 Debug",
             0x2F79: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Target Address, Thermal & RAS Registers",
             0x2F7D: "Xeon E7 v3/Xeon E5 v3/Core i7 Scratchpad & Semaphore Registers",
             0x2F7E: "Xeon E7 v3/Xeon E5 v3/Core i7 E3 QPI Link Debug",
             0x2F80: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0",
             0x2F81: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 0 & 1 Monitoring",
             0x2F83: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0",
             0x2F85: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0 Debug",
             0x2F86: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0 Debug",
             0x2F87: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0 Debug",
             0x2F88: "Xeon E7 v3/Xeon E5 v3/Core i7 VCU",
             0x2F8A: "Xeon E7 v3/Xeon E5 v3/Core i7 VCU",
             0x2F90: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1",
             0x2F93: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1",
             0x2F95: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1 Debug",
             0x2F96: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1 Debug",
             0x2F98: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit",
             0x2F99: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit",
             0x2F9A: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit",
             0x2F9C: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit",
             0x2FA0: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 0",
             0x2FA8: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Target Address, Thermal & RAS Registers",
             0x2FAA: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder",
             0x2FAB: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder",
             0x2FAC: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder",
             0x2FAD: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder",
             0x2FAE: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO Channel 0/1 Broadcast",
             0x2FAF: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO Global Broadcast",
             0x2FB0: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 0 Thermal Control",
             0x2FB1: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 1 Thermal Control",
             0x2FB2: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 0 ERROR Registers",
             0x2FB3: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 1 ERROR Registers",
             0x2FB4: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 2 Thermal Control",
             0x2FB5: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 3 Thermal Control",
             0x2FB6: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 2 ERROR Registers",
             0x2FB7: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 3 ERROR Registers",
             0x2FB8: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 2 & 3",
             0x2FB9: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 2 & 3",
             0x2FBA: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 2 & 3",
             0x2FBB: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 2 & 3",
             0x2FBC: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 0 & 1",
             0x2FBD: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 0 & 1",
             0x2FBE: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 0 & 1",
             0x2FBF: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 0 & 1",
             0x2FC0: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit",
             0x2FC1: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit",
             0x2FC2: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit",
             0x2FC3: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit",
             0x2FC4: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit",
             0x2FC5: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit",
             0x2FD0: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 0 Thermal Control",
             0x2FD1: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 1 Thermal Control",
             0x2FD2: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 0 ERROR Registers",
             0x2FD3: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 1 ERROR Registers",
             0x2FD4: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 2 Thermal Control",
             0x2FD5: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 3 Thermal Control",
             0x2FD6: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 2 ERROR Registers",
             0x2FD7: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 3 ERROR Registers",
             0x2FE0: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FE1: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FE2: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FE3: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FE4: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FE5: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FE6: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FE7: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FE8: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FE9: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FEA: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FEB: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FEC: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FED: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FEE: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FEF: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FF0: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FF1: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FF2: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FF3: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FF4: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FF5: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FF6: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FF7: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers",
             0x2FF8: "Xeon E7 v3/Xeon E5 v3/Core i7 Buffered Ring Agent",
             0x2FF9: "Xeon E7 v3/Xeon E5 v3/Core i7 Buffered Ring Agent",
             0x2FFA: "Xeon E7 v3/Xeon E5 v3/Core i7 Buffered Ring Agent",
             0x2FFB: "Xeon E7 v3/Xeon E5 v3/Core i7 Buffered Ring Agent",
             0x2FFC: "Xeon E7 v3/Xeon E5 v3/Core i7 System Address Decoder & Broadcast Registers",
             0x2FFD: "Xeon E7 v3/Xeon E5 v3/Core i7 System Address Decoder & Broadcast Registers",
             0x2FFE: "Xeon E7 v3/Xeon E5 v3/Core i7 System Address Decoder & Broadcast Registers",
             0x3140: "Easel/Monette Hill Image Processor [Pixel Visual Core]",
             0x3165: "Wireless 3165",
             0x3166: "Dual Band Wireless-AC 3165 Plus Bluetooth",
             0x3184: "GeminiLake [UHD Graphics 605]",
             0x3185: "GeminiLake [UHD Graphics 600]",
             0x318C: "Celeron/Pentium Silver Processor Dynamic Platform and Thermal Framework Processor Participant",
             0x318E: "Celeron/Pentium Silver Processor NorthPeak",
             0x3190: "Celeron/Pentium Silver Processor Gaussian Mixture Model",
             0x3192: "Gemini Lake P2SB",
             0x3197: "Celeron/Pentium Silver Processor PCI-default ISA-bridge",
             0x3198: "Celeron/Pentium Silver Processor High Definition Audio",
             0x319A: "Celeron/Pentium Silver Processor Trusted Execution Engine Interface",
             0x31A2: "Celeron/Pentium Silver Processor Integrated Sensor Solution",
             0x31A8: "Celeron/Pentium Silver Processor USB 3.0 xHCI Controller",
             0x31AC: "Celeron/Pentium Silver Processor I2C 0",
             0x31AE: "Celeron/Pentium Silver Processor I2C 1",
             0x31B0: "Celeron/Pentium Silver Processor I2C 2",
             0x31B2: "Celeron/Pentium Silver Processor I2C 3",
             0x31B4: "Celeron/Pentium Silver Processor I2C 4",
             0x31B6: "Celeron/Pentium Silver Processor I2C 5",
             0x31B8: "Celeron/Pentium Silver Processor I2C 6",
             0x31BA: "Celeron/Pentium Silver Processor I2C 7",
             0x31BC: "Celeron/Pentium Silver Processor Serial IO UART Host Controller",
             0x31BE: "Celeron/Pentium Silver Processor Serial IO UART Host Controller",
             0x31C0: "Celeron/Pentium Silver Processor Serial IO UART Host Controller",
             0x31C2: "Celeron/Pentium Silver Processor Serial IO SPI Host Controller",
             0x31C4: "Celeron/Pentium Silver Processor Serial IO SPI Host Controller",
             0x31C6: "Celeron/Pentium Silver Processor Serial IO SPI Host Controller",
             0x31CC: "Celeron/Pentium Silver Processor SDA Standard Compliant SD Host Controller",
             0x31D4: "Celeron/Pentium Silver Processor Gaussian Mixture Model",
             0x31D6: "Gemini Lake PCI Express Root Port",
             0x31D7: "Gemini Lake PCI Express Root Port",
             0x31D8: "Gemini Lake PCI Express Root Port",
             0x31D9: "Gemini Lake PCI Express Root Port",
             0x31DA: "Gemini Lake PCI Express Root Port",
             0x31DB: "Gemini Lake PCI Express Root Port",
             0x31DC: "Gemini Lake PCH CNVi WiFi",
             0x31E3: "Celeron/Pentium Silver Processor SATA Controller",
             0x31E8: "Celeron/Pentium Silver Processor LPC Controller",
             0x31EE: "Celeron/Pentium Silver Processor Serial IO UART Host Controller",
             0x31F0: "Gemini Lake Host Bridge",
             0x3200: "GD31244 PCI-X SATA HBA",
             0x3310: "IOP348 I/O Processor",
             0x3313: "IOP348 I/O Processor (SL8e) in IOC Mode SAS/SATA",
             0x331B: "IOP348 I/O Processor (SL8x) in IOC Mode SAS/SATA",
             0x3331: "IOC340 I/O Controller (VV8e) SAS/SATA",
             0x3339: "IOC340 I/O Controller (VV8x) SAS/SATA",
             0x3340: "82855PM Processor to I/O Controller",
             0x3341: "82855PM Processor to AGP Controller",
             0x3363: "IOC340 I/O Controller in IOC Mode SAS/SATA",
             0x3382: "81342 [Chevelon] I/O Processor (ATUe)",
             0x33C3: "IOP348 I/O Processor (SL8De) in IOC Mode SAS/SATA",
             0x33CB: "IOP348 I/O Processor (SL8Dx) in IOC Mode SAS/SATA",
             0x3400: "5520/5500/X58 I/O Hub to ESI Port",
             0x3401: "5520/5500/X58 I/O Hub to ESI Port",
             0x3402: "5520/5500/X58 I/O Hub to ESI Port",
             0x3403: "5500 I/O Hub to ESI Port",
             0x3404: "5520/5500/X58 I/O Hub to ESI Port",
             0x3405: "5520/5500/X58 I/O Hub to ESI Port",
             0x3406: "5520 I/O Hub to ESI Port",
             0x3407: "5520/5500/X58 I/O Hub to ESI Port",
             0x3408: "5520/5500/X58 I/O Hub PCI Express Root Port 1",
             0x3409: "5520/5500/X58 I/O Hub PCI Express Root Port 2",
             0x340A: "5520/5500/X58 I/O Hub PCI Express Root Port 3",
             0x340B: "5520/X58 I/O Hub PCI Express Root Port 4",
             0x340C: "5520/X58 I/O Hub PCI Express Root Port 5",
             0x340D: "5520/X58 I/O Hub PCI Express Root Port 6",
             0x340E: "5520/5500/X58 I/O Hub PCI Express Root Port 7",
             0x340F: "5520/5500/X58 I/O Hub PCI Express Root Port 8",
             0x3410: "7500/5520/5500/X58 I/O Hub PCI Express Root Port 9",
             0x3411: "7500/5520/5500/X58 I/O Hub PCI Express Root Port 10",
             0x3418: "7500/5520/5500/X58 Physical Layer Port 0",
             0x3419: "7500/5520/5500 Physical Layer Port 1",
             0x3420: "7500/5520/5500/X58 I/O Hub PCI Express Root Port 0",
             0x3421: "7500/5520/5500/X58 I/O Hub PCI Express Root Port 0",
             0x3422: "7500/5520/5500/X58 I/O Hub GPIO and Scratch Pad Registers",
             0x3423: "7500/5520/5500/X58 I/O Hub Control Status and RAS Registers",
             0x3425: "7500/5520/5500/X58 Physical and Link Layer Registers Port 0",
             0x3426: "7500/5520/5500/X58 Routing and Protocol Layer Registers Port 0",
             0x3427: "7500/5520/5500 Physical and Link Layer Registers Port 1",
             0x3428: "7500/5520/5500 Routing & Protocol Layer Register Port 1",
             0x3429: "5520/5500/X58 Chipset QuickData Technology Device",
             0x342A: "5520/5500/X58 Chipset QuickData Technology Device",
             0x342B: "5520/5500/X58 Chipset QuickData Technology Device",
             0x342C: "5520/5500/X58 Chipset QuickData Technology Device",
             0x342D: "7500/5520/5500/X58 I/O Hub I/OxAPIC Interrupt Controller",
             0x342E: "7500/5520/5500/X58 I/O Hub System Management Registers",
             0x342F: "7500/5520/5500/X58 Trusted Execution Technology Registers",
             0x3430: "5520/5500/X58 Chipset QuickData Technology Device",
             0x3431: "5520/5500/X58 Chipset QuickData Technology Device",
             0x3432: "5520/5500/X58 Chipset QuickData Technology Device",
             0x3433: "5520/5500/X58 Chipset QuickData Technology Device",
             0x3438: "7500/5520/5500/X58 I/O Hub Throttle Registers",
             0x3440: "Ice Lake UPI Misc",
             0x3441: "Ice Lake UPI Link/Phy0",
             0x3456: "Ice Lake NorthPeak",
             0x347E: "Ice Lake Xeon Non-Transparent Bridge",
             0x3482: "Ice Lake-LP LPC Controller",
             0x34A3: "Ice Lake-LP SMBus Controller",
             0x34A4: "Ice Lake-LP SPI Controller",
             0x34A8: "Ice Lake-LP Serial IO UART Controller #0",
             0x34A9: "Ice Lake-LP Serial IO UART Controller #1",
             0x34AA: "Ice Lake-LP Serial IO SPI Controller #0",
             0x34AB: "Ice Lake-LP Serial IO SPI Controller #1",
             0x34B0: "Ice Lake-LP PCI Express Root Port #9",
             0x34B7: "Ice Lake-LP PCI Express Root Port #16",
             0x34BA: "Ice Lake-LP PCI Express Root Port #3",
             0x34BC: "Ice Lake-LP PCI Express Root Port #5",
             0x34C4: "Ice Lake-LP SD Host Controller",
             0x34C5: "Ice Lake-LP Serial IO I2c Controller #4",
             0x34C6: "Ice Lake-LP Serial IO I2c Controller #5",
             0x34C8: "Ice Lake-LP Smart Sound Technology Audio Controller",
             0x34D3: "Ice Lake-LP SATA Controller [AHCI mode]",
             0x34E0: "Ice Lake-LP Management Engine",
             0x34E8: "Ice Lake-LP Serial IO I2C Controller #0",
             0x34E9: "Ice Lake-LP Serial IO I2C Controller #1",
             0x34EA: "Ice Lake-LP Serial IO I2C Controller #2",
             0x34EB: "Ice Lake-LP Serial IO I2C Controller #3",
             0x34ED: "Ice Lake-LP USB 3.1 xHCI Host Controller",
             0x34EF: "Ice Lake-LP DRAM Controller",
             0x34F0: "Ice Lake-LP PCH CNVi WiFi",
             0x34F8: "Ice Lake-LP SD Controller",
             0x34FC: "Ice Lake-LP Integrated Sensor Solution",
             0x3500: "6311ESB/6321ESB PCI Express Upstream Port",
             0x3501: "6310ESB PCI Express Upstream Port",
             0x3504: "6311ESB/6321ESB I/OxAPIC Interrupt Controller",
             0x3505: "6310ESB I/OxAPIC Interrupt Controller",
             0x350C: "6311ESB/6321ESB PCI Express to PCI-X Bridge",
             0x350D: "6310ESB PCI Express to PCI-X Bridge",
             0x3510: "6311ESB/6321ESB PCI Express Downstream Port E1",
             0x3511: "6310ESB PCI Express Downstream Port E1",
             0x3514: "6311ESB/6321ESB PCI Express Downstream Port E2",
             0x3515: "6310ESB PCI Express Downstream Port E2",
             0x3518: "6311ESB/6321ESB PCI Express Downstream Port E3",
             0x3519: "6310ESB PCI Express Downstream Port E3",
             0x3575: "82830M/MG/MP Host Bridge",
             0x3576: "82830M/MP AGP Bridge",
             0x3577: "82830M/MG Integrated Graphics Controller",
             0x3578: "82830M/MG/MP Host Bridge",
             0x3580: "82852/82855 GM/GME/PM/GMV Processor to I/O Controller",
             0x3581: "82852/82855 GM/GME/PM/GMV Processor to AGP Controller",
             0x3582: "82852/855GM Integrated Graphics Device",
             0x3584: "82852/82855 GM/GME/PM/GMV Processor to I/O Controller",
             0x3585: "82852/82855 GM/GME/PM/GMV Processor to I/O Controller",
             0x358C: "82854 GMCH",
             0x358E: "82854 GMCH Integrated Graphics Device",
             0x3590: "E7520 Memory Controller Hub",
             0x3591: "E7525/E7520 Error Reporting Registers",
             0x3592: "E7320 Memory Controller Hub",
             0x3593: "E7320 Error Reporting Registers",
             0x3594: "E7520 DMA Controller",
             0x3595: "E7525/E7520/E7320 PCI Express Port A",
             0x3596: "E7525/E7520/E7320 PCI Express Port A1",
             0x3597: "E7525/E7520 PCI Express Port B",
             0x3598: "E7520 PCI Express Port B1",
             0x3599: "E7520 PCI Express Port C",
             0x359A: "E7520 PCI Express Port C1",
             0x359B: "E7525/E7520/E7320 Extended Configuration Registers",
             0x359E: "E7525 Memory Controller Hub",
             0x35B0: "3100 Chipset Memory I/O Controller Hub",
             0x35B1: "3100 DRAM Controller Error Reporting Registers",
             0x35B5: "3100 Chipset Enhanced DMA Controller",
             0x35B6: "3100 Chipset PCI Express Port A",
             0x35B7: "3100 Chipset PCI Express Port A1",
             0x35C8: "3100 Extended Configuration Test Overflow Registers",
             0x3600: "7300 Chipset Memory Controller Hub",
             0x3604: "7300 Chipset PCI Express Port 1",
             0x3605: "7300 Chipset PCI Express Port 2",
             0x3606: "7300 Chipset PCI Express Port 3",
             0x3607: "7300 Chipset PCI Express Port 4",
             0x3608: "7300 Chipset PCI Express Port 5",
             0x3609: "7300 Chipset PCI Express Port 6",
             0x360A: "7300 Chipset PCI Express Port 7",
             0x360B: "7300 Chipset QuickData Technology Device",
             0x360C: "7300 Chipset FSB Registers",
             0x360D: "7300 Chipset Snoop Filter Registers",
             0x360E: "7300 Chipset Debug and Miscellaneous Registers",
             0x360F: "7300 Chipset FBD Branch 0 Registers",
             0x3610: "7300 Chipset FBD Branch 1 Registers",
             0x3700: "Xeon C5500/C3500 DMI",
             0x3701: "Xeon C5500/C3500 DMI",
             0x3702: "Xeon C5500/C3500 DMI",
             0x3703: "Xeon C5500/C3500 DMI",
             0x3704: "Xeon C5500/C3500 DMI",
             0x3705: "Xeon C5500/C3500 DMI",
             0x3706: "Xeon C5500/C3500 DMI",
             0x3707: "Xeon C5500/C3500 DMI",
             0x3708: "Xeon C5500/C3500 DMI",
             0x3709: "Xeon C5500/C3500 DMI",
             0x370A: "Xeon C5500/C3500 DMI",
             0x370B: "Xeon C5500/C3500 DMI",
             0x370C: "Xeon C5500/C3500 DMI",
             0x370D: "Xeon C5500/C3500 DMI",
             0x370E: "Xeon C5500/C3500 DMI",
             0x370F: "Xeon C5500/C3500 DMI",
             0x3710: "Xeon C5500/C3500 CB3 DMA",
             0x3711: "Xeon C5500/C3500 CB3 DMA",
             0x3712: "Xeon C5500/C3500 CB3 DMA",
             0x3713: "Xeon C5500/C3500 CB3 DMA",
             0x3714: "Xeon C5500/C3500 CB3 DMA",
             0x3715: "Xeon C5500/C3500 CB3 DMA",
             0x3716: "Xeon C5500/C3500 CB3 DMA",
             0x3717: "Xeon C5500/C3500 CB3 DMA",
             0x3718: "Xeon C5500/C3500 CB3 DMA",
             0x3719: "Xeon C5500/C3500 CB3 DMA",
             0x371A: "Xeon C5500/C3500 QPI Link",
             0x371B: "Xeon C5500/C3500 QPI Routing and Protocol",
             0x371D: "Xeon C5500/C3500 QPI Routing and Protocol",
             0x3720: "Xeon C5500/C3500 PCI Express Root Port 0",
             0x3721: "Xeon C5500/C3500 PCI Express Root Port 1",
             0x3722: "Xeon C5500/C3500 PCI Express Root Port 2",
             0x3723: "Xeon C5500/C3500 PCI Express Root Port 3",
             0x3724: "Xeon C5500/C3500 PCI Express Root Port 4",
             0x3725: "Xeon C5500/C3500 NTB Primary",
             0x3726: "Xeon C5500/C3500 NTB Primary",
             0x3727: "Xeon C5500/C3500 NTB Secondary",
             0x3728: "Xeon C5500/C3500 Core",
             0x3729: "Xeon C5500/C3500 Core",
             0x372A: "Xeon C5500/C3500 Core",
             0x372B: "Xeon C5500/C3500 Core",
             0x372C: "Xeon C5500/C3500 Reserved",
             0x373F: "Xeon C5500/C3500 IOxAPIC",
             0x37C8: "C62x Chipset QuickAssist Technology",
             0x37C9: "C62x Chipset QuickAssist Technology Virtual Function",
             0x37CC: "Ethernet Connection X722",
             0x37CD: "Ethernet Virtual Function 700 Series",
             0x37CE: "Ethernet Connection X722 for 10GbE backplane",
             0x37CF: "Ethernet Connection X722 for 10GbE QSFP+",
             0x37D0: "Ethernet Connection X722 for 10GbE SFP+",
             0x37D1: "Ethernet Connection X722 for 1GbE",
             0x37D2: "Ethernet Connection X722 for 10GBASE-T",
             0x37D3: "Ethernet Connection X722 for 10GbE SFP+",
             0x37D4: "Ethernet Connection X722 for 10GbE QSFP+",
             0x37D9: "X722 Hyper-V Virtual Function",
             0x3882: "Ice Lake LPC Controller",
             0x38A4: "Ice Lake SPI Controller",
             0x38E0: "Ice Lake Management Engine Interface",
             0x3A00: "82801JD/DO (ICH10 Family) 4-port SATA IDE Controller",
             0x3A02: "82801JD/DO (ICH10 Family) SATA AHCI Controller",
             0x3A05: "82801JD/DO (ICH10 Family) SATA RAID Controller",
             0x3A06: "82801JD/DO (ICH10 Family) 2-port SATA IDE Controller",
             0x3A14: "82801JDO (ICH10DO) LPC Interface Controller",
             0x3A16: "82801JIR (ICH10R) LPC Interface Controller",
             0x3A18: "82801JIB (ICH10) LPC Interface Controller",
             0x3A1A: "82801JD (ICH10D) LPC Interface Controller",
             0x3A20: "82801JI (ICH10 Family) 4 port SATA IDE Controller #1",
             0x3A22: "82801JI (ICH10 Family) SATA AHCI Controller",
             0x3A25: "82801JIR (ICH10R) SATA RAID Controller",
             0x3A26: "82801JI (ICH10 Family) 2 port SATA IDE Controller #2",
             0x3A30: "82801JI (ICH10 Family) SMBus Controller",
             0x3A32: "82801JI (ICH10 Family) Thermal Subsystem",
             0x3A34: "82801JI (ICH10 Family) USB UHCI Controller #1",
             0x3A35: "82801JI (ICH10 Family) USB UHCI Controller #2",
             0x3A36: "82801JI (ICH10 Family) USB UHCI Controller #3",
             0x3A37: "82801JI (ICH10 Family) USB UHCI Controller #4",
             0x3A38: "82801JI (ICH10 Family) USB UHCI Controller #5",
             0x3A39: "82801JI (ICH10 Family) USB UHCI Controller #6",
             0x3A3A: "82801JI (ICH10 Family) USB2 EHCI Controller #1",
             0x3A3C: "82801JI (ICH10 Family) USB2 EHCI Controller #2",
             0x3A3E: "82801JI (ICH10 Family) HD Audio Controller",
             0x3A40: "82801JI (ICH10 Family) PCI Express Root Port 1",
             0x3A42: "82801JI (ICH10 Family) PCI Express Port 2",
             0x3A44: "82801JI (ICH10 Family) PCI Express Root Port 3",
             0x3A46: "82801JI (ICH10 Family) PCI Express Root Port 4",
             0x3A48: "82801JI (ICH10 Family) PCI Express Root Port 5",
             0x3A4A: "82801JI (ICH10 Family) PCI Express Root Port 6",
             0x3A4C: "82801JI (ICH10 Family) Gigabit Ethernet Controller",
             0x3A51: "82801JDO (ICH10DO) VECI Controller",
             0x3A55: "82801JD/DO (ICH10 Family) Virtual SATA Controller",
             0x3A60: "82801JD/DO (ICH10 Family) SMBus Controller",
             0x3A62: "82801JD/DO (ICH10 Family) Thermal Subsystem",
             0x3A64: "82801JD/DO (ICH10 Family) USB UHCI Controller #1",
             0x3A65: "82801JD/DO (ICH10 Family) USB UHCI Controller #2",
             0x3A66: "82801JD/DO (ICH10 Family) USB UHCI Controller #3",
             0x3A67: "82801JD/DO (ICH10 Family) USB UHCI Controller #4",
             0x3A68: "82801JD/DO (ICH10 Family) USB UHCI Controller #5",
             0x3A69: "82801JD/DO (ICH10 Family) USB UHCI Controller #6",
             0x3A6A: "82801JD/DO (ICH10 Family) USB2 EHCI Controller #1",
             0x3A6C: "82801JD/DO (ICH10 Family) USB2 EHCI Controller #2",
             0x3A6E: "82801JD/DO (ICH10 Family) HD Audio Controller",
             0x3A70: "82801JD/DO (ICH10 Family) PCI Express Port 1",
             0x3A72: "82801JD/DO (ICH10 Family) PCI Express Port 2",
             0x3A74: "82801JD/DO (ICH10 Family) PCI Express Port 3",
             0x3A76: "82801JD/DO (ICH10 Family) PCI Express Port 4",
             0x3A78: "82801JD/DO (ICH10 Family) PCI Express Port 5",
             0x3A7A: "82801JD/DO (ICH10 Family) PCI Express Port 6",
             0x3A7C: "82801JD/DO (ICH10 Family) Gigabit Ethernet Controller",
             0x3B00: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B01: "Mobile 5 Series Chipset LPC Interface Controller",
             0x3B02: "P55 Chipset LPC Interface Controller",
             0x3B03: "PM55 Chipset LPC Interface Controller",
             0x3B04: "5 Series Chipset LPC Interface Controller",
             0x3B05: "Mobile 5 Series Chipset LPC Interface Controller",
             0x3B06: "H55 Chipset LPC Interface Controller",
             0x3B07: "QM57 Chipset LPC Interface Controller",
             0x3B08: "H57 Chipset LPC Interface Controller",
             0x3B09: "HM55 Chipset LPC Interface Controller",
             0x3B0A: "Q57 Chipset LPC Interface Controller",
             0x3B0B: "HM57 Chipset LPC Interface Controller",
             0x3B0C: "5 Series Chipset LPC Interface Controller",
             0x3B0D: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B0E: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B0F: "QS57 Chipset LPC Interface Controller",
             0x3B10: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B11: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B12: "3400 Series Chipset LPC Interface Controller",
             0x3B13: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B14: "3420 Chipset LPC Interface Controller",
             0x3B15: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B16: "3450 Chipset LPC Interface Controller",
             0x3B17: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B18: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B19: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B1A: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B1B: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B1C: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B1D: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B1E: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B1F: "5 Series/3400 Series Chipset LPC Interface Controller",
             0x3B20: "5 Series/3400 Series Chipset 4 port SATA IDE Controller",
             0x3B21: "5 Series/3400 Series Chipset 2 port SATA IDE Controller",
             0x3B22: "5 Series/3400 Series Chipset 6 port SATA AHCI Controller",
             0x3B23: "5 Series/3400 Series Chipset 4 port SATA AHCI Controller",
             0x3B25: "5 Series/3400 Series Chipset SATA RAID Controller",
             0x3B26: "5 Series/3400 Series Chipset 2 port SATA IDE Controller",
             0x3B28: "5 Series/3400 Series Chipset 4 port SATA IDE Controller",
             0x3B29: "5 Series/3400 Series Chipset 4 port SATA AHCI Controller",
             0x3B2C: "5 Series/3400 Series Chipset SATA RAID Controller",
             0x3B2D: "5 Series/3400 Series Chipset 2 port SATA IDE Controller",
             0x3B2E: "5 Series/3400 Series Chipset 4 port SATA IDE Controller",
             0x3B2F: "5 Series/3400 Series Chipset 6 port SATA AHCI Controller",
             0x3B30: "5 Series/3400 Series Chipset SMBus Controller",
             0x3B32: "5 Series/3400 Series Chipset Thermal Subsystem",
             0x3B34: "5 Series/3400 Series Chipset USB2 Enhanced Host Controller",
             0x3B36: "5 Series/3400 Series Chipset USB Universal Host Controller",
             0x3B37: "5 Series/3400 Series Chipset USB Universal Host Controller",
             0x3B38: "5 Series/3400 Series Chipset USB Universal Host Controller",
             0x3B39: "5 Series/3400 Series Chipset USB Universal Host Controller",
             0x3B3A: "5 Series/3400 Series Chipset USB Universal Host Controller",
             0x3B3B: "5 Series/3400 Series Chipset USB Universal Host Controller",
             0x3B3C: "5 Series/3400 Series Chipset USB2 Enhanced Host Controller",
             0x3B3E: "5 Series/3400 Series Chipset USB Universal Host Controller",
             0x3B3F: "5 Series/3400 Series Chipset USB Universal Host Controller",
             0x3B40: "5 Series/3400 Series Chipset USB Universal Host Controller",
             0x3B41: "5 Series/3400 Series Chipset LAN Controller",
             0x3B42: "5 Series/3400 Series Chipset PCI Express Root Port 1",
             0x3B44: "5 Series/3400 Series Chipset PCI Express Root Port 2",
             0x3B46: "5 Series/3400 Series Chipset PCI Express Root Port 3",
             0x3B48: "5 Series/3400 Series Chipset PCI Express Root Port 4",
             0x3B4A: "5 Series/3400 Series Chipset PCI Express Root Port 5",
             0x3B4C: "5 Series/3400 Series Chipset PCI Express Root Port 6",
             0x3B4E: "5 Series/3400 Series Chipset PCI Express Root Port 7",
             0x3B50: "5 Series/3400 Series Chipset PCI Express Root Port 8",
             0x3B53: "5 Series/3400 Series Chipset VECI Controller",
             0x3B56: "5 Series/3400 Series Chipset High Definition Audio",
             0x3B57: "5 Series/3400 Series Chipset High Definition Audio",
             0x3B64: "5 Series/3400 Series Chipset HECI Controller",
             0x3B65: "5 Series/3400 Series Chipset HECI Controller",
             0x3B66: "5 Series/3400 Series Chipset PT IDER Controller",
             0x3B67: "5 Series/3400 Series Chipset KT Controller",
             0x3C00: "Xeon E5/Core i7 DMI2",
             0x3C01: "Xeon E5/Core i7 DMI2 in PCI Express Mode",
             0x3C02: "Xeon E5/Core i7 IIO PCI Express Root Port 1a",
             0x3C03: "Xeon E5/Core i7 IIO PCI Express Root Port 1b",
             0x3C04: "Xeon E5/Core i7 IIO PCI Express Root Port 2a",
             0x3C05: "Xeon E5/Core i7 IIO PCI Express Root Port 2b",
             0x3C06: "Xeon E5/Core i7 IIO PCI Express Root Port 2c",
             0x3C07: "Xeon E5/Core i7 IIO PCI Express Root Port 2d",
             0x3C08: "Xeon E5/Core i7 IIO PCI Express Root Port 3a in PCI Express Mode",
             0x3C09: "Xeon E5/Core i7 IIO PCI Express Root Port 3b",
             0x3C0A: "Xeon E5/Core i7 IIO PCI Express Root Port 3c",
             0x3C0B: "Xeon E5/Core i7 IIO PCI Express Root Port 3d",
             0x3C0D: "Xeon E5/Core i7 Non-Transparent Bridge",
             0x3C0E: "Xeon E5/Core i7 Non-Transparent Bridge",
             0x3C0F: "Xeon E5/Core i7 Non-Transparent Bridge",
             0x3C20: "Xeon E5/Core i7 DMA Channel 0",
             0x3C21: "Xeon E5/Core i7 DMA Channel 1",
             0x3C22: "Xeon E5/Core i7 DMA Channel 2",
             0x3C23: "Xeon E5/Core i7 DMA Channel 3",
             0x3C24: "Xeon E5/Core i7 DMA Channel 4",
             0x3C25: "Xeon E5/Core i7 DMA Channel 5",
             0x3C26: "Xeon E5/Core i7 DMA Channel 6",
             0x3C27: "Xeon E5/Core i7 DMA Channel 7",
             0x3C28: "Xeon E5/Core i7 Address Map, VTd_Misc, System Management",
             0x3C2A: "Xeon E5/Core i7 Control Status and Global Errors",
             0x3C2C: "Xeon E5/Core i7 I/O APIC",
             0x3C2E: "Xeon E5/Core i7 DMA",
             0x3C2F: "Xeon E5/Core i7 DMA",
             0x3C40: "Xeon E5/Core i7 IIO Switch and IRP Performance Monitor",
             0x3C43: "Xeon E5/Core i7 Ring to PCI Express Performance Monitor",
             0x3C44: "Xeon E5/Core i7 Ring to QuickPath Interconnect Link 0 Performance Monitor",
             0x3C45: "Xeon E5/Core i7 Ring to QuickPath Interconnect Link 1 Performance Monitor",
             0x3C46: "Xeon E5/Core i7 Processor Home Agent Performance Monitoring",
             0x3C71: "Xeon E5/Core i7 Integrated Memory Controller RAS Registers",
             0x3C80: "Xeon E5/Core i7 QPI Link 0",
             0x3C83: "Xeon E5/Core i7 QPI Link Reut 0",
             0x3C84: "Xeon E5/Core i7 QPI Link Reut 0",
             0x3C90: "Xeon E5/Core i7 QPI Link 1",
             0x3C93: "Xeon E5/Core i7 QPI Link Reut 1",
             0x3C94: "Xeon E5/Core i7 QPI Link Reut 1",
             0x3CA0: "Xeon E5/Core i7 Processor Home Agent",
             0x3CA8: "Xeon E5/Core i7 Integrated Memory Controller Registers",
             0x3CAA: "Xeon E5/Core i7 Integrated Memory Controller Target Address Decoder 0",
             0x3CAB: "Xeon E5/Core i7 Integrated Memory Controller Target Address Decoder 1",
             0x3CAC: "Xeon E5/Core i7 Integrated Memory Controller Target Address Decoder 2",
             0x3CAD: "Xeon E5/Core i7 Integrated Memory Controller Target Address Decoder 3",
             0x3CAE: "Xeon E5/Core i7 Integrated Memory Controller Target Address Decoder 4",
             0x3CB0: "Xeon E5/Core i7 Integrated Memory Controller Channel 0-3 Thermal Control 0",
             0x3CB1: "Xeon E5/Core i7 Integrated Memory Controller Channel 0-3 Thermal Control 1",
             0x3CB2: "Xeon E5/Core i7 Integrated Memory Controller ERROR Registers 0",
             0x3CB3: "Xeon E5/Core i7 Integrated Memory Controller ERROR Registers 1",
             0x3CB4: "Xeon E5/Core i7 Integrated Memory Controller Channel 0-3 Thermal Control 2",
             0x3CB5: "Xeon E5/Core i7 Integrated Memory Controller Channel 0-3 Thermal Control 3",
             0x3CB6: "Xeon E5/Core i7 Integrated Memory Controller ERROR Registers 2",
             0x3CB7: "Xeon E5/Core i7 Integrated Memory Controller ERROR Registers 3",
             0x3CB8: "Xeon E5/Core i7 DDRIO",
             0x3CC0: "Xeon E5/Core i7 Power Control Unit 0",
             0x3CC1: "Xeon E5/Core i7 Power Control Unit 1",
             0x3CC2: "Xeon E5/Core i7 Power Control Unit 2",
             0x3CD0: "Xeon E5/Core i7 Power Control Unit 3",
             0x3CE0: "Xeon E5/Core i7 Interrupt Control Registers",
             0x3CE3: "Xeon E5/Core i7 Semaphore and Scratchpad Configuration Registers",
             0x3CE4: "Xeon E5/Core i7 R2PCIe",
             0x3CE6: "Xeon E5/Core i7 QuickPath Interconnect Agent Ring Registers",
             0x3CE8: "Xeon E5/Core i7 Unicast Register 0",
             0x3CE9: "Xeon E5/Core i7 Unicast Register 5",
             0x3CEA: "Xeon E5/Core i7 Unicast Register 1",
             0x3CEB: "Xeon E5/Core i7 Unicast Register 6",
             0x3CEC: "Xeon E5/Core i7 Unicast Register 3",
             0x3CED: "Xeon E5/Core i7 Unicast Register 7",
             0x3CEE: "Xeon E5/Core i7 Unicast Register 4",
             0x3CEF: "Xeon E5/Core i7 Unicast Register 8",
             0x3CF4: "Xeon E5/Core i7 Integrated Memory Controller System Address Decoder 0",
             0x3CF5: "Xeon E5/Core i7 Integrated Memory Controller System Address Decoder 1",
             0x3CF6: "Xeon E5/Core i7 System Address Decoder",
             0x3E10: "8th Gen Core 4-core Processor Host Bridge/DRAM Registers [Coffee Lake H]",
             0x3E18: "8th Gen Core 4-core Workstation Processor Host Bridge/DRAM Registers [Coffee Lake S]",
             0x3E1F: "8th Gen Core 4-core Desktop Processor Host Bridge/DRAM Registers [Coffee Lake S]",
             0x3E30: "8th/9th Gen Core 8-core Desktop Processor Host Bridge/DRAM Registers [Coffee Lake S]",
             0x3E33: "8th/9th Gen Core Processor Host Bridge/DRAM Registers [Coffee Lake]",
             0x3E34: "Coffee Lake HOST and DRAM Controller",
             0x3E35: "Coffee Lake Host Bridge/DRAM Registers",
             0x3E81: "8th Gen Core Processor PCIe Controller (x16)",
             0x3E85: "8th Gen Core Processor PCIe Controller (x8)",
             0x3E89: "8th Gen Core Processor PCIe Controller (x4)",
             0x3E90: "CoffeeLake-S GT1 [UHD Graphics 610]",
             0x3E91: "CoffeeLake-S GT2 [UHD Graphics 630]",
             0x3E92: "CoffeeLake-S GT2 [UHD Graphics 630]",
             0x3E93: "CoffeeLake-S GT1 [UHD Graphics 610]",
             0x3E94: "Coffee Lake-S GT2 [UHD Graphics P630]",
             0x3E96: "CoffeeLake-S GT2 [UHD Graphics P630]",
             0x3E98: "CoffeeLake-S GT2 [UHD Graphics 630]",
             0x3E9A: "Coffee Lake-S GT2 [UHD Graphics P630]",
             0x3E9B: "CoffeeLake-H GT2 [UHD Graphics 630]",
             0x3E9C: "Coffee Lake-S GT1 [UHD Graphics 610]",
             0x3EA0: "WhiskeyLake-U GT2 [UHD Graphics 620]",
             0x3EA1: "Whiskey Lake-U GT1 [UHD Graphics 610]",
             0x3EA5: "CoffeeLake-U GT3e [Iris Plus Graphics 655]",
             0x3EA6: "Coffee Lake-U GT3 [Iris Plus Graphics 645]",
             0x3EA8: "Coffee Lake-U GT3 [Iris Plus Graphics 655]",
             0x3EA9: "Coffee Lake-U GT2 [UHD Graphics 620]",
             0x3EC2: "8th Gen Core Processor Host Bridge/DRAM Registers",
             0x3EC4: "8th Gen Core Processor Host Bridge/DRAM Registers",
             0x3EC6: "8th Gen Core Processor Host Bridge/DRAM Registers",
             0x3ECA: "8th Gen Core Processor Host Bridge/DRAM Registers",
             0x3ED0: "8th Gen Core Processor Host Bridge/DRAM Registers",
             0x4000: "5400 Chipset Memory Controller Hub",
             0x4001: "5400 Chipset Memory Controller Hub",
             0x4003: "5400 Chipset Memory Controller Hub",
             0x4021: "5400 Chipset PCI Express Port 1",
             0x4022: "5400 Chipset PCI Express Port 2",
             0x4023: "5400 Chipset PCI Express Port 3",
             0x4024: "5400 Chipset PCI Express Port 4",
             0x4025: "5400 Chipset PCI Express Port 5",
             0x4026: "5400 Chipset PCI Express Port 6",
             0x4027: "5400 Chipset PCI Express Port 7",
             0x4028: "5400 Chipset PCI Express Port 8",
             0x4029: "5400 Chipset PCI Express Port 9",
             0x402D: "5400 Chipset IBIST Registers",
             0x402E: "5400 Chipset IBIST Registers",
             0x402F: "5400 Chipset QuickData Technology Device",
             0x4030: "5400 Chipset FSB Registers",
             0x4031: "5400 Chipset CE/SF Registers",
             0x4032: "5400 Chipset IOxAPIC",
             0x4035: "5400 Chipset FBD Registers",
             0x4036: "5400 Chipset FBD Registers",
             0x4041: "NVMe Datacenter SSD [Optane]",
             0x4100: "Moorestown Graphics and Video",
             0x4108: "Atom Processor E6xx Integrated Graphics Controller",
             0x4109: "Atom Processor E6xx Integrated Graphics Controller",
             0x410A: "Atom Processor E6xx Integrated Graphics Controller",
             0x410B: "Atom Processor E6xx Integrated Graphics Controller",
             0x410C: "Atom Processor E6xx Integrated Graphics Controller",
             0x410D: "Atom Processor E6xx Integrated Graphics Controller",
             0x410E: "Atom Processor E6xx Integrated Graphics Controller",
             0x410F: "Atom Processor E6xx Integrated Graphics Controller",
             0x4114: "Atom Processor E6xx PCI Host Bridge #1",
             0x4115: "Atom Processor E6xx PCI Host Bridge #2",
             0x4116: "Atom Processor E6xx PCI Host Bridge #3",
             0x4117: "Atom Processor E6xx PCI Host Bridge #4",
             0x4140: "NVMe Datacenter SSD [Optane]",
             0x4220: "PRO/Wireless 2200BG [Calexico2] Network Connection",
             0x4222: "PRO/Wireless 3945ABG [Golan] Network Connection",
             0x4223: "PRO/Wireless 2915ABG [Calexico2] Network Connection",
             0x4224: "PRO/Wireless 2915ABG [Calexico2] Network Connection",
             0x4227: "PRO/Wireless 3945ABG [Golan] Network Connection",
             0x4229: "PRO/Wireless 4965 AG or AGN [Kedron] Network Connection",
             0x422B: "Centrino Ultimate-N 6300",
             0x422C: "Centrino Advanced-N 6200",
             0x4230: "PRO/Wireless 4965 AG or AGN [Kedron] Network Connection",
             0x4232: "WiFi Link 5100",
             0x4235: "Ultimate N WiFi Link 5300",
             0x4236: "Ultimate N WiFi Link 5300",
             0x4237: "PRO/Wireless 5100 AGN [Shiloh] Network Connection",
             0x4238: "Centrino Ultimate-N 6300",
             0x4239: "Centrino Advanced-N 6200",
             0x423A: "PRO/Wireless 5350 AGN [Echo Peak] Network Connection",
             0x423B: "PRO/Wireless 5350 AGN [Echo Peak] Network Connection",
             0x423C: "WiMAX/WiFi Link 5150",
             0x423D: "WiMAX/WiFi Link 5150",
             0x438B: "Tiger Lake-H LPC/eSPI Controller",
             0x43A3: "Tiger Lake-H SMBus Controller",
             0x43A4: "Tiger Lake-H SPI Controller",
             0x43B0: "Tiger Lake-H PCI Express Root Port #9",
             0x43BC: "Tiger Lake-H PCI Express Root Port #5",
             0x43C8: "Tiger Lake-H HD Audio Controller",
             0x43E0: "Tiger Lake-H Management Engine Interface",
             0x43E8: "Tiger Lake-H Serial IO I2C Controller #0",
             0x43E9: "Tiger Lake-H Serial IO I2C Controller #1",
             0x43ED: "Tiger Lake-H USB 3.2 Gen 2x1 xHCI Host Controller",
             0x43EF: "Tiger Lake-H Shared SRAM",
             0x43F0: "Tiger Lake PCH CNVi WiFi",
             0x43FC: "Tiger Lake-H Integrated Sensor Hub",
             0x444E: "Turbo Memory Controller",
             0x4511: "Elkhart Lake Gaussian and Neural Accelerator",
             0x4538: "Elkhart Lake PCI-e Root Complex",
             0x4555: "Elkhart Lake [UHD Graphics Gen11 16EU]",
             0x4571: "Elkhart Lake [UHD Graphics Gen11 32EU]",
             0x460D: "12th Gen Core Processor PCI Express x16 Controller #1",
             0x461D: "Alder Lake Innovation Platform Framework Processor Participant",
             0x461E: "Alder Lake-P Thunderbolt 4 USB Controller",
             0x461F: "Alder Lake-P Thunderbolt 4 PCI Express Root Port #3",
             0x4626: "Alder Lake-P Integrated Graphics Controller",
             0x4628: "Alder Lake-UP3 GT2 [UHD Graphics]",
             0x4629: "12th Gen Core Processor Host Bridge/DRAM Registers",
             0x462A: "AlderLake-P [UHD Graphics]",
             0x462F: "Alder Lake-P Thunderbolt 4 PCI Express Root Port #2",
             0x4636: "AlderLake-P [UHD Graphics]",
             0x4638: "AlderLake-P [UHD Graphics]",
             0x463A: "AlderLake-P [UHD Graphics]",
             0x463D: "12th Gen Core Processor PCI Express x4 Controller #2",
             0x463E: "Alder Lake-P Thunderbolt 4 NHI #0",
             0x463F: "Alder Lake-P Thunderbolt 4 PCI Express Root Port #1",
             0x4641: "12th Gen Core Processor Host Bridge/DRAM Registers",
             0x464D: "12th Gen Core Processor PCI Express x4 Controller #0",
             0x464F: "12th Gen Core Processor Gaussian & Neural Accelerator",
             0x4660: "12th Gen Core Processor Host Bridge/DRAM Registers",
             0x4668: "12th Gen Core Processor Host Bridge/DRAM Registers",
             0x466D: "Alder Lake-P Thunderbolt 4 NHI #1",
             0x466E: "Alder Lake-P Thunderbolt 4 PCI Express Root Port #0",
             0x467D: "Platform Monitoring Technology",
             0x467F: "Volume Management Device NVMe RAID Controller",
             0x4680: "AlderLake-S GT1",
             0x4682: "Alder Lake-S GT1 [UHD Graphics 730]",
             0x4688: "Alder Lake-HX GT1 [UHD Graphics 770]",
             0x468A: "Alder Lake-S [UHD Graphics]",
             0x468B: "Alder Lake-S [UHD Graphics]",
             0x4690: "Alder Lake-S GT1 [UHD Graphics 770]",
             0x4692: "Alder Lake-S GT1 [UHD Graphics 730]",
             0x4693: "Alder Lake-S GT1 [UHD Graphics 710]",
             0x46A0: "AlderLake-P GT2",
             0x46A1: "UHD Graphics",
             0x46A3: "Alder Lake-P GT1 [UHD Graphics]",
             0x46A6: "Alder Lake-P Integrated Graphics Controller",
             0x46A8: "Alder Lake-UP3 GT2 [Iris Xe Graphics]",
             0x46AA: "Alder Lake-UP4 GT2 [Iris Xe Graphics]",
             0x46B0: "AlderLake-P [Iris Xe Graphics]",
             0x46B1: "AlderLake-P [Iris Xe Graphics]",
             0x46B3: "Alder Lake-UP3 GT1 [UHD Graphics]",
             0x46B6: "AlderLake-P [Iris Xe Graphics]",
             0x46B8: "AlderLake-P [Iris Xe Graphics]",
             0x46BA: "AlderLake-P [Iris Xe Graphics]",
             0x46C0: "AlderLake-M GT1",
             0x46C1: "AlderLake-M [Iris Xe Graphics]",
             0x46C3: "Alder Lake-UP4 GT1 [UHD Graphics]",
             0x46D0: "Alder Lake-N [UHD Graphics]",
             0x46D1: "Alder Lake-N [UHD Graphics]",
             0x46D2: "Alder Lake-N [UHD Graphics]",
             0x4905: "DG1 [Iris Xe MAX Graphics]",
             0x4906: "DG1 [Iris Xe Pod]",
             0x4907: "SG1 [Server GPU SG-18M]",
             0x4908: "DG1 [Iris Xe Graphics]",
             0x4909: "DG1 [Iris Xe MAX 100]",
             0x4B00: "Elkhart Lake eSPI Controller",
             0x4B23: "Elkhart Lake SMBus Controller",
             0x4B24: "Elkhart Lake SPI (Flash) Controller",
             0x4B38: "Elkhart Lake PCH PCI Express Root Port #0",
             0x4B39: "Elkhart Lake PCH PCI Express Root Port #1",
             0x4B3E: "Elkhart Lake PCH PCI Express Root Port #6",
             0x4B58: "Elkhart Lake High Density Audio bus interface",
             0x4B63: "Elkhart Lake SATA AHCI",
             0x4B70: "Elkhart Lake Management Engine Interface",
             0x4B7D: "Elkhart Lake USB 3.10 XHCI",
             0x4B7F: "Elkhart Lake PMC SRAM",
             0x4C3D: "Volume Management Device NVMe RAID Controller",
             0x4C8A: "RocketLake-S GT1 [UHD Graphics 750]",
             0x4C8B: "RocketLake-S GT1 [UHD Graphics 730]",
             0x4C90: "RocketLake-S GT1 [UHD Graphics P750]",
             0x4C9A: "RocketLake-S [UHD Graphics]",
             0x4DA3: "Jasper Lake SMBus",
             0x4DA4: "Jasper Lake SPI Controller",
             0x4DC8: "Jasper Lake HD Audio",
             0x4DE0: "Management Engine Interface",
             0x4DE8: "Serial IO I2C Host Controller",
             0x4DE9: "Serial IO I2C Host Controller",
             0x4DF0: "Wi-Fi 6 AX201 160MHz",
             0x4E03: "Dynamic Tuning service",
             0x4E19: "JasperLake IPU",
             0x4E55: "JasperLake [UHD Graphics]",
             0x4E61: "JasperLake [UHD Graphics]",
             0x4E71: "JasperLake [UHD Graphics]",
             0x4F80: "DG2",
             0x4F81: "DG2",
             0x4F82: "DG2",
             0x4F90: "DG2 Audio Controller",
             0x4F91: "DG2 Audio Controller",
             0x4F92: "DG2 Audio Controller",
             0x5001: "LE80578",
             0x5002: "LE80578 Graphics Processor Unit",
             0x5009: "LE80578 Video Display Controller",
             0x500D: "LE80578 Expansion Bus",
             0x500E: "LE80578 UART Controller",
             0x500F: "LE80578 General Purpose IO",
             0x5010: "LE80578 I2C Controller",
             0x5012: "LE80578 Serial Peripheral Interface Bus",
             0x5020: "EP80579 Memory Controller Hub",
             0x5021: "EP80579 DRAM Error Reporting Registers",
             0x5023: "EP80579 EDMA Controller",
             0x5024: "EP80579 PCI Express Port PEA0",
             0x5025: "EP80579 PCI Express Port PEA1",
             0x5028: "EP80579 S-ATA IDE",
             0x5029: "EP80579 S-ATA AHCI",
             0x502A: "EP80579 S-ATA Reserved",
             0x502B: "EP80579 S-ATA Reserved",
             0x502C: "EP80579 Integrated Processor ASU",
             0x502D: "EP80579 Integrated Processor with QuickAssist ASU",
             0x502E: "EP80579 Reserved",
             0x502F: "EP80579 Reserved",
             0x5030: "EP80579 Reserved",
             0x5031: "EP80579 LPC Bus",
             0x5032: "EP80579 SMBus Controller",
             0x5033: "EP80579 USB 1.1 Controller",
             0x5035: "EP80579 USB 2.0 Controller",
             0x5037: "EP80579 PCI-PCI Bridge (transparent mode)",
             0x5039: "EP80579 Controller Area Network (CAN) interface #1",
             0x503A: "EP80579 Controller Area Network (CAN) interface #2",
             0x503B: "EP80579 Synchronous Serial Port (SPP)",
             0x503C: "EP80579 IEEE 1588 Hardware Assist",
             0x503D: "EP80579 Local Expansion Bus",
             0x503E: "EP80579 Global Control Unit (GCU)",
             0x503F: "EP80579 Reserved",
             0x5040: "EP80579 Integrated Processor Gigabit Ethernet MAC",
             0x5041: "EP80579 Integrated Processor with QuickAssist Gigabit Ethernet MAC",
             0x5042: "EP80579 Reserved",
             0x5043: "EP80579 Reserved",
             0x5044: "EP80579 Integrated Processor Gigabit Ethernet MAC",
             0x5045: "EP80579 Integrated Processor with QuickAssist Gigabit Ethernet MAC",
             0x5046: "EP80579 Reserved",
             0x5047: "EP80579 Reserved",
             0x5048: "EP80579 Integrated Processor Gigabit Ethernet MAC",
             0x5049: "EP80579 Integrated Processor with QuickAssist Gigabit Ethernet MAC",
             0x504A: "EP80579 Reserved",
             0x504B: "EP80579 Reserved",
             0x504C: "EP80579 Integrated Processor with QuickAssist TDM",
             0x5181: "Alder Lake PCH-P LPC/eSPI Controller",
             0x5182: "Alder Lake PCH eSPI Controller",
             0x51A3: "Alder Lake PCH-P SMBus Host Controller",
             0x51A4: "Alder Lake-P PCH SPI Controller",
             0x51A8: "Alder Lake PCH UART #0",
             0x51A9: "Alder Lake PCH UART #1",
             0x51B1: "Alder Lake PCI Express x1 Root Port #10",
             0x51BF: "Alder Lake PCH-P PCI Express Root Port #9",
             0x51C5: "Alder Lake-P Serial IO I2C Controller #0",
             0x51C6: "Alder Lake-P Serial IO I2C Controller #1",
             0x51C8: "Alder Lake PCH-P High Definition Audio Controller",
             0x51D3: "Alder Lake-P SATA AHCI Controller",
             0x51D8: "Alder Lake-P Serial IO I2C Controller #2",
             0x51D9: "Alder Lake-P Serial IO I2C Controller #3",
             0x51E0: "Alder Lake PCH HECI Controller",
             0x51E3: "Alder Lake AMT SOL Redirection",
             0x51E8: "Alder Lake PCH Serial IO I2C Controller #0",
             0x51E9: "Alder Lake PCH Serial IO I2C Controller #1",
             0x51EA: "Alder Lake PCH Serial IO I2C Controller #2",
             0x51EB: "Alder Lake PCH Serial IO I2C Controller #3",
             0x51ED: "Alder Lake PCH USB 3.2 xHCI Host Controller",
             0x51EF: "Alder Lake PCH Shared SRAM",
             0x51F0: "Alder Lake-P PCH CNVi WiFi",
             0x51FC: "Alder Lake-P Integrated Sensor Hub",
             0x5200: "EtherExpress PRO/100 Intelligent Server PCI Bridge",
             0x5201: "EtherExpress PRO/100 Intelligent Server Fast Ethernet Controller",
             0x530D: "80310 (IOP) IO Processor",
             0x5502: "Ethernet Controller (2) I225-LMvP",
             0x5690: "DG2 [Arc A770M]",
             0x5691: "DG2 [Arc A730M]",
             0x5692: "DG2 [Arc A550M]",
             0x5693: "DG2 [Arc A370M]",
             0x5694: "DG2 [Arc A350M]",
             0x5695: "DG2 [Iris Xe MAX A200M]",
             0x56A0: "DG2 [Arc A770]",
             0x56A1: "DG2 [Arc A750]",
             0x56A2: "DG2 [Arc A580]",
             0x56A5: "DG2 [Arc A380]",
             0x56A6: "DG2 [Arc A310]",
             0x56B0: "DG2 [Arc Pro A30M]",
             0x56B1: "DG2 [Arc Pro A40/A50]",
             0x56C0: "Data Center GPU Flex 170",
             0x56C1: "Data Center GPU Flex 140",
             0x579C: "Ethernet Connection E825-C for backplane",
             0x579D: "Ethernet Connection E825-C for QSFP",
             0x579E: "Ethernet Connection E825-C for SFP",
             0x57B1: "Ethernet Controller E610 1GBASE T",
             0x5845: "QEMU NVM Express Controller",
             0x5900: "Xeon E3-1200 v6/7th Gen Core Processor Host Bridge/DRAM Registers",
             0x5901: "Xeon E3-1200 v6/7th Gen Core Processor PCIe Controller (x16)",
             0x5902: "HD Graphics 610",
             0x5904: "Xeon E3-1200 v6/7th Gen Core Processor Host Bridge/DRAM Registers",
             0x5905: "Xeon E3-1200 v6/7th Gen Core Processor PCIe Controller (x8)",
             0x5906: "HD Graphics 610",
             0x5909: "Xeon E3-1200 v6/7th Gen Core Processor PCIe Controller (x4)",
             0x590B: "HD Graphics 610",
             0x590C: "Xeon E3-1200 v6/7th Gen Core Processor Host Bridge/DRAM Registers",
             0x590F: "Xeon E3-1200 v6/7th Gen Core Processor Host Bridge/DRAM Registers",
             0x5910: "Xeon E3-1200 v6/7th Gen Core Processor Host Bridge/DRAM Registers",
             0x5911: "Xeon E3-1200 v6/7th Gen Core Processor Gaussian Mixture Model",
             0x5912: "HD Graphics 630",
             0x5914: "Xeon E3-1200 v6/7th Gen Core Processor Host Bridge/DRAM Registers",
             0x5916: "HD Graphics 620",
             0x5917: "UHD Graphics 620",
             0x5918: "Xeon E3-1200 v6/7th Gen Core Processor Host Bridge/DRAM Registers",
             0x591B: "HD Graphics 630",
             0x591C: "UHD Graphics 615",
             0x591D: "HD Graphics P630",
             0x591E: "HD Graphics 615",
             0x591F: "Xeon E3-1200 v6/7th Gen Core Processor Host Bridge/DRAM Registers",
             0x5921: "HD Graphics 620",
             0x5923: "HD Graphics 635",
             0x5926: "Iris Plus Graphics 640",
             0x5927: "Iris Plus Graphics 650",
             0x5A84: "Apollo Lake [HD Graphics 505]",
             0x5A85: "HD Graphics 500",
             0x5A88: "Celeron N3350/Pentium N4200/Atom E3900 Series Imaging Unit",
             0x5A98: "Celeron N3350/Pentium N4200/Atom E3900 Series Audio Cluster",
             0x5A9A: "Celeron N3350/Pentium N4200/Atom E3900 Series Trusted Execution Engine",
             0x5AA2: "Celeron N3350/Pentium N4200/Atom E3900 Series Integrated Sensor Hub",
             0x5AA8: "Celeron N3350/Pentium N4200/Atom E3900 Series USB xHCI",
             0x5AAC: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #1",
             0x5AAE: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #2",
             0x5AB0: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #3",
             0x5AB2: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #4",
             0x5AB4: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #5",
             0x5AB6: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #6",
             0x5AB8: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #7",
             0x5ABA: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #8",
             0x5ABC: "Celeron N3350/Pentium N4200/Atom E3900 Series HSUART Controller #1",
             0x5ABE: "Celeron N3350/Pentium N4200/Atom E3900 Series HSUART Controller #2",
             0x5AC0: "Celeron N3350/Pentium N4200/Atom E3900 Series HSUART Controller #3",
             0x5AC2: "Celeron N3350/Pentium N4200/Atom E3900 Series SPI Controller #1",
             0x5AC4: "Celeron N3350/Pentium N4200/Atom E3900 Series SPI Controller #2",
             0x5AC6: "Celeron N3350/Pentium N4200/Atom E3900 Series SPI Controller #3",
             0x5AC8: "Celeron N3350/Pentium N4200/Atom E3900 Series PWM Pin Controller",
             0x5ACA: "Celeron N3350/Pentium N4200/Atom E3900 Series SDXC/MMC Host Controller",
             0x5ACC: "Celeron N3350/Pentium N4200/Atom E3900 Series eMMC Controller",
             0x5AD0: "Celeron N3350/Pentium N4200/Atom E3900 Series SDIO Controller",
             0x5AD4: "Celeron N3350/Pentium N4200/Atom E3900 Series SMBus Controller",
             0x5AD6: "Celeron N3350/Pentium N4200/Atom E3900 Series PCI Express Port B #1",
             0x5AD7: "Celeron N3350/Pentium N4200/Atom E3900 Series PCI Express Port B #2",
             0x5AD8: "Celeron N3350/Pentium N4200/Atom E3900 Series PCI Express Port A #1",
             0x5AD9: "Celeron N3350/Pentium N4200/Atom E3900 Series PCI Express Port A #2",
             0x5ADA: "Celeron N3350/Pentium N4200/Atom E3900 Series PCI Express Port A #3",
             0x5ADB: "Celeron N3350/Pentium N4200/Atom E3900 Series PCI Express Port A #4",
             0x5AE3: "Celeron N3350/Pentium N4200/Atom E3900 Series SATA AHCI Controller",
             0x5AE8: "Celeron N3350/Pentium N4200/Atom E3900 Series Low Pin Count Interface",
             0x5AEE: "Celeron N3350/Pentium N4200/Atom E3900 Series HSUART Controller #4",
             0x5AF0: "Celeron N3350/Pentium N4200/Atom E3900 Series Host Bridge",
             0x65C0: "5100 Chipset Memory Controller Hub",
             0x65E2: "5100 Chipset PCI Express x4 Port 2",
             0x65E3: "5100 Chipset PCI Express x4 Port 3",
             0x65E4: "5100 Chipset PCI Express x4 Port 4",
             0x65E5: "5100 Chipset PCI Express x4 Port 5",
             0x65E6: "5100 Chipset PCI Express x4 Port 6",
             0x65E7: "5100 Chipset PCI Express x4 Port 7",
             0x65F0: "5100 Chipset FSB Registers",
             0x65F1: "5100 Chipset Reserved Registers",
             0x65F3: "5100 Chipset Reserved Registers",
             0x65F5: "5100 Chipset DDR Channel 0 Registers",
             0x65F6: "5100 Chipset DDR Channel 1 Registers",
             0x65F7: "5100 Chipset PCI Express x8 Port 2-3",
             0x65F8: "5100 Chipset PCI Express x8 Port 4-5",
             0x65F9: "5100 Chipset PCI Express x8 Port 6-7",
             0x65FA: "5100 Chipset PCI Express x16 Port 4-7",
             0x65FF: "5100 Chipset DMA Engine",
             0x6F00: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DMI2",
             0x6F01: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D PCI Express Root Port 0",
             0x6F02: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D PCI Express Root Port 1",
             0x6F03: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D PCI Express Root Port 1",
             0x6F04: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D PCI Express Root Port 2",
             0x6F05: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D PCI Express Root Port 2",
             0x6F06: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D PCI Express Root Port 2",
             0x6F07: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D PCI Express Root Port 2",
             0x6F08: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D PCI Express Root Port 3",
             0x6F09: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D PCI Express Root Port 3",
             0x6F0A: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D PCI Express Root Port 3",
             0x6F0B: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D PCI Express Root Port 3",
             0x6F10: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F11: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F12: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F13: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F14: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F15: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F16: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F17: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F18: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F19: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F1A: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F1B: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F1C: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Debug",
             0x6F1D: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D R2PCIe Agent",
             0x6F1E: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Ubox",
             0x6F1F: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Ubox",
             0x6F20: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Crystal Beach DMA Channel 0",
             0x6F21: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Crystal Beach DMA Channel 1",
             0x6F22: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Crystal Beach DMA Channel 2",
             0x6F23: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Crystal Beach DMA Channel 3",
             0x6F24: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Crystal Beach DMA Channel 4",
             0x6F25: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Crystal Beach DMA Channel 5",
             0x6F26: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Crystal Beach DMA Channel 6",
             0x6F27: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Crystal Beach DMA Channel 7",
             0x6F28: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Map/VTd_Misc/System Management",
             0x6F29: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO Hot Plug",
             0x6F2A: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IIO RAS/Control Status/Global Errors",
             0x6F2C: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D I/O APIC",
             0x6F30: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Home Agent 0",
             0x6F32: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 0",
             0x6F33: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 1",
             0x6F34: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D R2PCIe Agent",
             0x6F36: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D R3 QPI Link 0/1",
             0x6F37: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D R3 QPI Link 0/1",
             0x6F38: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Home Agent 1",
             0x6F39: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D IO Performance Monitoring",
             0x6F3A: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 2",
             0x6F3E: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D R3 QPI Link 2",
             0x6F3F: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D R3 QPI Link 2",
             0x6F40: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 2",
             0x6F41: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D R3 QPI Link 2",
             0x6F43: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 2",
             0x6F45: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 2 Debug",
             0x6F46: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 2 Debug",
             0x6F47: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 2 Debug",
             0x6F50: "Xeon Processor D Family QuickData Technology Register DMA Channel 0",
             0x6F51: "Xeon Processor D Family QuickData Technology Register DMA Channel 1",
             0x6F52: "Xeon Processor D Family QuickData Technology Register DMA Channel 2",
             0x6F53: "Xeon Processor D Family QuickData Technology Register DMA Channel 3",
             0x6F54: "Xeon Processor D Family QuickAssist Technology",
             0x6F55: "Xeon Processor D Family QuickAssist Technology Virtual Fuction",
             0x6F60: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Home Agent 1",
             0x6F68: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Target Address/Thermal/RAS",
             0x6F6A: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Channel Target Address Decoder",
             0x6F6B: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Channel Target Address Decoder",
             0x6F6C: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Channel Target Address Decoder",
             0x6F6D: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Channel Target Address Decoder",
             0x6F6E: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DDRIO Channel 2/3 Broadcast",
             0x6F6F: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DDRIO Global Broadcast",
             0x6F70: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Home Agent 0 Debug",
             0x6F71: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Target Address/Thermal/RAS",
             0x6F76: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D R3 QPI Link Debug",
             0x6F78: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Home Agent 1 Debug",
             0x6F79: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Target Address/Thermal/RAS",
             0x6F7D: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Ubox",
             0x6F7E: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D R3 QPI Link Debug",
             0x6F80: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 0",
             0x6F81: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D R3 QPI Link 0/1",
             0x6F83: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 0",
             0x6F85: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 0 Debug",
             0x6F86: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 0 Debug",
             0x6F87: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 0 Debug",
             0x6F88: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6F8A: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6F90: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 1",
             0x6F93: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 1",
             0x6F95: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 1 Debug",
             0x6F96: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QPI Link 1 Debug",
             0x6F98: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6F99: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6F9A: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6F9C: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FA0: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Home Agent 0",
             0x6FA8: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Target Address/Thermal/RAS",
             0x6FAA: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Channel Target Address Decoder",
             0x6FAB: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Channel Target Address Decoder",
             0x6FAC: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Channel Target Address Decoder",
             0x6FAD: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Channel Target Address Decoder",
             0x6FAE: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DDRIO Channel 0/1 Broadcast",
             0x6FAF: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DDRIO Global Broadcast",
             0x6FB0: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Channel 0 Thermal Control",
             0x6FB1: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Channel 1 Thermal Control",
             0x6FB2: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Channel 0 Error",
             0x6FB3: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Channel 1 Error",
             0x6FB4: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Channel 2 Thermal Control",
             0x6FB5: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Channel 3 Thermal Control",
             0x6FB6: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Channel 2 Error",
             0x6FB7: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 0 - Channel 3 Error",
             0x6FB8: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DDRIO Channel 2/3 Interface",
             0x6FB9: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DDRIO Channel 2/3 Interface",
             0x6FBA: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DDRIO Channel 2/3 Interface",
             0x6FBB: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DDRIO Channel 2/3 Interface",
             0x6FBC: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DDRIO Channel 0/1 Interface",
             0x6FBD: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DDRIO Channel 0/1 Interface",
             0x6FBE: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DDRIO Channel 0/1 Interface",
             0x6FBF: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D DDRIO Channel 0/1 Interface",
             0x6FC0: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FC1: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FC2: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FC3: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FC4: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FC5: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FC6: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FC7: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FC8: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FC9: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FCA: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FCB: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FCC: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FCD: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FCE: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FCF: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Power Control Unit",
             0x6FD0: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 1 - Channel 0 Thermal Control",
             0x6FD1: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 1 - Channel 1 Thermal Control",
             0x6FD2: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 1 - Channel 0 Error",
             0x6FD3: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 1 - Channel 1 Error",
             0x6FD4: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 1 - Channel 2 Thermal Control",
             0x6FD5: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 1 - Channel 3 Thermal Control",
             0x6FD6: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 1 - Channel 2 Error",
             0x6FD7: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Memory Controller 1 - Channel 3 Error",
             0x6FE0: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FE1: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FE2: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FE3: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FE4: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FE5: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FE6: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FE7: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FE8: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FE9: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FEA: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FEB: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FEC: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FED: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FEE: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FEF: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FF0: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FF1: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FF8: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FF9: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FFA: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FFB: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FFC: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FFD: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x6FFE: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D Caching Agent",
             0x7000: "82371SB PIIX3 ISA [Natoma/Triton II]",
             0x7010: "82371SB PIIX3 IDE [Natoma/Triton II]",
             0x7020: "82371SB PIIX3 USB [Natoma/Triton II]",
             0x7030: "430VX - 82437VX TVX [Triton VX]",
             0x7050: "Intercast Video Capture Card",
             0x7051: "PB 642365-003 (Business Video Conferencing Card)",
             0x7100: "430TX - 82439TX MTXC",
             0x7110: "82371AB/EB/MB PIIX4 ISA",
             0x7111: "82371AB/EB/MB PIIX4 IDE",
             0x7112: "82371AB/EB/MB PIIX4 USB",
             0x7113: "82371AB/EB/MB PIIX4 ACPI",
             0x7120: "82810 GMCH (Graphics Memory Controller Hub)",
             0x7121: "82810 (CGC) Chipset Graphics Controller",
             0x7122: "82810 DC-100 (GMCH) Graphics Memory Controller Hub",
             0x7123: "82810 DC-100 (CGC) Chipset Graphics Controller",
             0x7124: "82810E DC-133 (GMCH) Graphics Memory Controller Hub",
             0x7125: "82810E DC-133 (CGC) Chipset Graphics Controller",
             0x7126: "82810 DC-133 System and Graphics Controller",
             0x7128: "82810-M DC-100 System and Graphics Controller",
             0x712A: "82810-M DC-133 System and Graphics Controller",
             0x7180: "440LX/EX - 82443LX/EX Host bridge",
             0x7181: "440LX/EX - 82443LX/EX AGP bridge",
             0x7190: "440BX/ZX/DX - 82443BX/ZX/DX Host bridge",
             0x7191: "440BX/ZX/DX - 82443BX/ZX/DX AGP bridge",
             0x7192: "440BX/ZX/DX - 82443BX/ZX/DX Host bridge (AGP disabled)",
             0x7194: "82440MX Host Bridge",
             0x7195: "82440MX AC'97 Audio Controller",
             0x7196: "82440MX AC'97 Modem Controller",
             0x7198: "82440MX ISA Bridge",
             0x7199: "82440MX EIDE Controller",
             0x719A: "82440MX USB Universal Host Controller",
             0x719B: "82440MX Power Management Controller",
             0x71A0: "440GX - 82443GX Host bridge",
             0x71A1: "440GX - 82443GX AGP bridge",
             0x71A2: "440GX - 82443GX Host bridge (AGP disabled)",
             0x7360: "XMM7360 LTE Advanced Modem",
             0x7560: "XMM7560 LTE Advanced Pro Modem",
             0x7600: "82372FB PIIX5 ISA",
             0x7601: "82372FB PIIX5 IDE",
             0x7602: "82372FB PIIX5 USB",
             0x7603: "82372FB PIIX5 SMBus",
             0x7800: "82740 (i740) AGP Graphics Accelerator",
             0x7A84: "Z690 Chipset LPC/eSPI Controller",
             0x7AA3: "Alder Lake-S PCH SMBus Controller",
             0x7AA4: "Alder Lake-S PCH SPI Controller",
             0x7AA7: "Alder Lake-S PCH Shared SRAM",
             0x7AA8: "Alder Lake-S PCH Serial IO UART #0",
             0x7AAB: "Alder Lake-S PCH Serial IO SPI Controller #1",
             0x7AB0: "Alder Lake-S PCH PCI Express Root Port #9",
             0x7AB4: "Alder Lake-S PCH PCI Express Root Port #13",
             0x7AB8: "Alder Lake-S PCH PCI Express Root Port #1",
             0x7AB9: "Alder Lake-S PCH PCI Express Root Port #2",
             0x7ABC: "Alder Lake-S PCH PCI Express Root Port #5",
             0x7ABD: "Alder Lake-S PCH PCI Express Root Port #6",
             0x7ABF: "Alder Lake-S PCH PCI Express Root Port #8",
             0x7AC8: "Alder Lake-S PCH PCI Express Root Port #25",
             0x7A