"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.tablesSASTokenPolicyName = void 0;
exports.tablesSASTokenPolicy = tablesSASTokenPolicy;
exports.signURLWithSAS = signURLWithSAS;
/**
 * The programmatic identifier of the tablesSASTokenPolicy.
 */
exports.tablesSASTokenPolicyName = "tablesSASTokenPolicy";
/**
 * tablesSASTokenPolicy is a policy used to sign HTTP request with a shared key.
 */
function tablesSASTokenPolicy(credential) {
    return {
        name: exports.tablesSASTokenPolicyName,
        async sendRequest(request, next) {
            signURLWithSAS(request, credential);
            return next(request);
        },
    };
}
function signURLWithSAS(request, credential) {
    const sasParams = new URLSearchParams(credential.signature);
    const url = new URL(request.url);
    for (const [name, value] of sasParams) {
        url.searchParams.append(name, value);
    }
    request.url = url.toString();
}
//# sourceMappingURL=tablesSASTokenPolicy.js.map