/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

'use strict';

/**
 * @class
 * Initializes a new instance of the SubscriptionPolicies class.
 * @constructor
 * Subscription policies.
 *
 * @member {string} [locationPlacementId] The subscription location placement
 * ID. The ID indicates which regions are visible for a subscription. For
 * example, a subscription with a location placement Id of Public_2014-09-01
 * has access to Azure public regions.
 *
 * @member {string} [quotaId] The subscription quota ID.
 *
 * @member {string} [spendingLimit] The subscription spending limit. Possible
 * values include: 'On', 'Off', 'CurrentPeriodOff'
 *
 */
class SubscriptionPolicies {
  constructor() {
  }

  /**
   * Defines the metadata of SubscriptionPolicies
   *
   * @returns {object} metadata of SubscriptionPolicies
   *
   */
  mapper() {
    return {
      required: false,
      serializedName: 'SubscriptionPolicies',
      type: {
        name: 'Composite',
        className: 'SubscriptionPolicies',
        modelProperties: {
          locationPlacementId: {
            required: false,
            readOnly: true,
            serializedName: 'locationPlacementId',
            type: {
              name: 'String'
            }
          },
          quotaId: {
            required: false,
            readOnly: true,
            serializedName: 'quotaId',
            type: {
              name: 'String'
            }
          },
          spendingLimit: {
            required: false,
            readOnly: true,
            serializedName: 'spendingLimit',
            type: {
              name: 'Enum',
              allowedValues: [ 'On', 'Off', 'CurrentPeriodOff' ]
            }
          }
        }
      }
    };
  }
}

module.exports = SubscriptionPolicies;
