/**
 * Builds a transaction change set boundary to be added to the transaction request body
 * @param changesetId - Id of the transaction changeset
 */
export declare function getChangeSetBoundary(changesetId: string): string;
/**
 * Builds a transaction boundary to be added to the transaction request body
 * @param transactionId - Id of the transaction
 */
export declare function getTransactionBoundary(transactionId: string): string;
/**
 * Returns an initial representation of the Transaction body.
 * @param transactionId - Id of the transaction
 * @param changesetId - Id of the transaction changeset
 */
export declare function getInitialTransactionBody(transactionId: string, changesetId: string): string[];
/**
 * Build the Transaction http request body to send to the service.
 * @param bodyParts - Parts of the transaction body, containing information about the actions to be included in the transaction request
 * @param transactionId - Id of the transaction
 * @param changesetId - Id of the transaction changeset
 */
export declare function getTransactionHttpRequestBody(bodyParts: string[], transactionId: string, changesetId: string): string;
//# sourceMappingURL=transactionHelpers.d.ts.map