/**
 * Parse initializes the AccountSASPermissions fields from a string.
 *
 * @param permissions -
 */
export declare function accountSasPermissionsFromString(permissions: string): AccountSasPermissions;
/**
 * Produces the SAS permissions string for an Azure Storage account.
 * Call this method to set AccountSASSignatureValues Permissions field.
 *
 * Using this method will guarantee the resource types are in
 * an order accepted by the service.
 *
 * @see https://learn.microsoft.com/rest/api/storageservices/constructing-an-account-sas
 *
 */
export declare function accountSasPermissionsToString(permissions: AccountSasPermissions): string;
/**
 * A type that looks like an account SAS permission.
 * Used in {@link AccountSasPermissions} to parse SAS permissions from raw objects.
 */
export interface AccountSasPermissions {
    /**
     * Grants permission to list entities.
     */
    query?: boolean;
    /**
     * Grants permission to create tables
     */
    write?: boolean;
    /**
     * Grants permission to delete tables and entities
     */
    delete?: boolean;
    /**
     * Grants permission to list tables
     */
    list?: boolean;
    /**
     * Grants permission to create entities
     */
    add?: boolean;
    /**
     * Permissions to update messages and table entities granted.
     */
    update?: boolean;
}
//# sourceMappingURL=accountSasPermissions.d.ts.map