/**
 * Creates a {@link TableSasPermissions} from the specified permissions string. This method will throw an
 * Error if it encounters a character that does not correspond to a valid permission.
 *
 * @param permissions -
 */
export declare function tableSasPermissionsFromString(permissions: string): TableSasPermissions;
/**
 * Converts the given permissions to a string. Using this method will guarantee the permissions are in an
 * order accepted by the service.
 *
 * @returns A string which represents the TableSasPermissions
 */
export declare function tableSasPermissionsToString(permissions?: TableSasPermissions): string;
/**
 * A type that looks like a Table SAS permission.
 * Used in {@link TableSasPermissions} to parse SAS permissions from raw objects.
 */
export interface TableSasPermissions {
    /**
     * Specifies Query access granted.
     */
    query?: boolean;
    /**
     * Specifies Add access granted.
     */
    add?: boolean;
    /**
     * Specifies Update access granted.
     */
    update?: boolean;
    /**
     * Specifies Delete access granted.
     */
    delete?: boolean;
}
//# sourceMappingURL=tableSasPermisions.d.ts.map