// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * Generate SasIPRange format string. For example:
 *
 * "8.8.8.8" or "1.1.1.1-255.255.255.255"
 *
 * @param ipRange -
 */
export function ipRangeToString(ipRange) {
    if (!ipRange) {
        return "";
    }
    return ipRange.end ? `${ipRange.start}-${ipRange.end}` : ipRange.start;
}
//# sourceMappingURL=sasIPRange.js.map