"use strict";
/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageClient = void 0;
const tslib_1 = require("tslib");
const coreHttpCompat = tslib_1.__importStar(require("@azure/core-http-compat"));
const index_js_1 = require("./operations/index.js");
class StorageClient extends coreHttpCompat.ExtendedServiceClient {
    url;
    version;
    /**
     * Initializes a new instance of the StorageClient class.
     * @param url The URL of the service account, container, or blob that is the target of the desired
     *            operation.
     * @param options The parameter options
     */
    constructor(url, options) {
        if (url === undefined) {
            throw new Error("'url' cannot be null");
        }
        // Initializing default values for options
        if (!options) {
            options = {};
        }
        const defaults = {
            requestContentType: "application/json; charset=utf-8",
        };
        const packageDetails = `azsdk-js-azure-storage-blob/12.29.1`;
        const userAgentPrefix = options.userAgentOptions && options.userAgentOptions.userAgentPrefix
            ? `${options.userAgentOptions.userAgentPrefix} ${packageDetails}`
            : `${packageDetails}`;
        const optionsWithDefaults = {
            ...defaults,
            ...options,
            userAgentOptions: {
                userAgentPrefix,
            },
            endpoint: options.endpoint ?? options.baseUri ?? "{url}",
        };
        super(optionsWithDefaults);
        // Parameter assignments
        this.url = url;
        // Assigning values to Constant parameters
        this.version = options.version || "2025-11-05";
        this.service = new index_js_1.ServiceImpl(this);
        this.container = new index_js_1.ContainerImpl(this);
        this.blob = new index_js_1.BlobImpl(this);
        this.pageBlob = new index_js_1.PageBlobImpl(this);
        this.appendBlob = new index_js_1.AppendBlobImpl(this);
        this.blockBlob = new index_js_1.BlockBlobImpl(this);
    }
    service;
    container;
    blob;
    pageBlob;
    appendBlob;
    blockBlob;
}
exports.StorageClient = StorageClient;
//# sourceMappingURL=storageClient.js.map