/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
import { QueueServiceProperties as QueueServicePropertiesMapper, QueueMessage as QueueMessageMapper } from "../models/mappers.js";
export const contentType = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
export const properties = {
    parameterPath: "properties",
    mapper: QueueServicePropertiesMapper
};
export const accept = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
export const url = {
    parameterPath: "url",
    mapper: {
        serializedName: "url",
        required: true,
        xmlName: "url",
        type: {
            name: "String"
        }
    },
    skipEncoding: true
};
export const restype = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "service",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String"
        }
    }
};
export const comp = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "properties",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
export const timeoutInSeconds = {
    parameterPath: ["options", "timeoutInSeconds"],
    mapper: {
        constraints: {
            InclusiveMinimum: 0
        },
        serializedName: "timeout",
        xmlName: "timeout",
        type: {
            name: "Number"
        }
    }
};
export const version = {
    parameterPath: "version",
    mapper: {
        defaultValue: "2025-11-05",
        isConstant: true,
        serializedName: "x-ms-version",
        type: {
            name: "String"
        }
    }
};
export const requestId = {
    parameterPath: ["options", "requestId"],
    mapper: {
        serializedName: "x-ms-client-request-id",
        xmlName: "x-ms-client-request-id",
        type: {
            name: "String"
        }
    }
};
export const accept1 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
export const comp1 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "stats",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
export const comp2 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "list",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
export const prefix = {
    parameterPath: ["options", "prefix"],
    mapper: {
        serializedName: "prefix",
        xmlName: "prefix",
        type: {
            name: "String"
        }
    }
};
export const marker = {
    parameterPath: ["options", "marker"],
    mapper: {
        serializedName: "marker",
        xmlName: "marker",
        type: {
            name: "String"
        }
    }
};
export const maxPageSize = {
    parameterPath: ["options", "maxPageSize"],
    mapper: {
        constraints: {
            InclusiveMinimum: 1
        },
        serializedName: "maxresults",
        xmlName: "maxresults",
        type: {
            name: "Number"
        }
    }
};
export const include = {
    parameterPath: ["options", "include"],
    mapper: {
        serializedName: "include",
        xmlName: "include",
        xmlElementName: "ListQueuesIncludeType",
        type: {
            name: "Sequence",
            element: {
                defaultValue: "metadata",
                isConstant: true,
                type: {
                    name: "String"
                }
            }
        }
    },
    collectionFormat: "CSV"
};
export const metadata = {
    parameterPath: ["options", "metadata"],
    mapper: {
        serializedName: "x-ms-meta",
        xmlName: "x-ms-meta",
        headerCollectionPrefix: "x-ms-meta-",
        type: {
            name: "Dictionary",
            value: { type: { name: "String" } }
        }
    }
};
export const comp3 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "metadata",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
export const comp4 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "acl",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
export const queueAcl = {
    parameterPath: ["options", "queueAcl"],
    mapper: {
        serializedName: "queueAcl",
        xmlName: "SignedIdentifiers",
        xmlIsWrapped: true,
        xmlElementName: "SignedIdentifier",
        type: {
            name: "Sequence",
            element: {
                type: {
                    name: "Composite",
                    className: "SignedIdentifier"
                }
            }
        }
    }
};
export const numberOfMessages = {
    parameterPath: ["options", "numberOfMessages"],
    mapper: {
        constraints: {
            InclusiveMinimum: 1
        },
        serializedName: "numofmessages",
        xmlName: "numofmessages",
        type: {
            name: "Number"
        }
    }
};
export const visibilityTimeout = {
    parameterPath: ["options", "visibilityTimeout"],
    mapper: {
        constraints: {
            InclusiveMaximum: 604800,
            InclusiveMinimum: 0
        },
        serializedName: "visibilitytimeout",
        xmlName: "visibilitytimeout",
        type: {
            name: "Number"
        }
    }
};
export const queueMessage = {
    parameterPath: "queueMessage",
    mapper: QueueMessageMapper
};
export const messageTimeToLive = {
    parameterPath: ["options", "messageTimeToLive"],
    mapper: {
        constraints: {
            InclusiveMinimum: -1
        },
        serializedName: "messagettl",
        xmlName: "messagettl",
        type: {
            name: "Number"
        }
    }
};
export const peekonly = {
    parameterPath: "peekonly",
    mapper: {
        defaultValue: "true",
        isConstant: true,
        serializedName: "peekonly",
        type: {
            name: "String"
        }
    }
};
export const queueMessage1 = {
    parameterPath: ["options", "queueMessage"],
    mapper: QueueMessageMapper
};
export const popReceipt = {
    parameterPath: "popReceipt",
    mapper: {
        serializedName: "popreceipt",
        required: true,
        xmlName: "popreceipt",
        type: {
            name: "String"
        }
    }
};
export const visibilityTimeout1 = {
    parameterPath: "visibilityTimeout",
    mapper: {
        constraints: {
            InclusiveMaximum: 604800,
            InclusiveMinimum: 0
        },
        serializedName: "visibilitytimeout",
        required: true,
        xmlName: "visibilitytimeout",
        type: {
            name: "Number"
        }
    }
};
//# sourceMappingURL=parameters.js.map