# Legacy Azure Storage SDK for JavaScript

[![NPM version](https://badge.fury.io/js/azure-storage.svg)](http://badge.fury.io/js/azure-storage) [![Build Status](https://travis-ci.org/Azure/azure-storage-node.svg?branch=master)](https://travis-ci.org/Azure/azure-storage-node/branches) [![Coverage Status](https://coveralls.io/repos/Azure/azure-storage-node/badge.svg?branch=master&service=github)](https://coveralls.io/github/Azure/azure-storage-node?branch=master)

This project provides the **legacy** Node.js package `azure-storage` which is browser compatible to consume and manage Microsoft Azure Storage Services like [Azure Blob Storage](https://azure.microsoft.com/services/storage/blobs/), [Azure Queue Storage](https://azure.microsoft.com/services/storage/queues/), [Azure Files](https://azure.microsoft.com/services/storage/files) and [Azure Table Storage](https://azure.microsoft.com/services/storage/tables/)

> Please note, newer packages `@azure/storage-blob`, `@azure/storage-queue` and `@azure/storage-file` are available as of November 2019 and `@azure/data-tables` is available as of June 2021 for the individual services. While the legacy `azure-storage` package will continue to receive critical bug fixes, we strongly encourage you to upgrade.

Below are a set of links with information on both the latest and legacy packages for the different Storage services from Azure. For more, please read [State of the Azure SDK 2021](https://devblogs.microsoft.com/azure-sdk/state-of-the-azure-sdk-2021/)

| Package                                                                                 | Version     | Description                                                                              | API Reference Links                                          |  Migration Guide Links                                                                    |
|------------------------------------------------------------------------------------------|-------------|------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------|
| [@azure/storage-blob](https://www.npmjs.com/package/@azure/storage-blob)              | v12         | The next generation SDK for Azure Blob Storage             |  [API Reference for Blob SDK](https://docs.microsoft.com/javascript/api/@azure/storage-blob) | [Migration Guide from `azure-storage` to `@azure/storage-blob`](https://github.com/Azure/azure-sdk-for-js/blob/main/sdk/storage/storage-blob/MigrationGuide.md) |
| [@azure/storage-queue](https://www.npmjs.com/package/@azure/storage-queue)              | v12         | The next generation SDK for Azure Queue Storage             |  [API Reference for Queues SDK](https://docs.microsoft.com/javascript/api/@azure/storage-queue) | [Migration Guide from `azure-storage` to `@azure/storage-queue`](https://github.com/Azure/azure-sdk-for-js/blob/main/sdk/storage/storage-queue/MigrationGuide.md)  |
| [@azure/storage-file-share](https://www.npmjs.com/package/@azure/storage-file-share)              | v12         | The next generation SDK for Azure Files             |  [API Reference for Files SDK](https://docs.microsoft.com/javascript/api/@azure/storage-file-share) | [Migration Guide from `azure-storage` to `@azure/storage-file-share`](https://github.com/Azure/azure-sdk-for-js/blob/main/sdk/storage/storage-file-share/MigrationGuide.md)  |
| [@azure/data-tables](https://www.npmjs.com/package/@azure/data-tables)              | v12         | The next generation SDK for Azure Table Storage             |  [API Reference for Tables SDK](https://docs.microsoft.com/javascript/api/@azure/data-tables) | [Migration Guide from `azure-storage` to `@azure/data-tables`](https://github.com/Azure/azure-sdk-for-js/blob/main/sdk/tables/data-tables/MigrationGuide.md)  |
| [azure-storage](https://www.npmjs.com/package/azure-storage)             | v2          | Legacy Storage SDK in this repository (Blob/Queue/File/Table, callback style)            | [API Reference for legacy Storage SDK](https://docs.microsoft.com/javascript/api/azure-storage) | |
| [@azure/arm-storage](https://www.npmjs.com/package/@azure/arm-storage)      | v7 & above          | Management SDKs including Storage Resource Provider APIs                                 | [API Reference for Storage Management SDK](https://docs.microsoft.com/javascript/api/@azure/arm-storage) | |
