/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

'use strict';

/**
 * @class
 * Initializes a new instance of the TenantIdDescription class.
 * @constructor
 * Tenant Id information.
 *
 * @member {string} [id] The fully qualified ID of the tenant. For example,
 * /tenants/00000000-0000-0000-0000-000000000000.
 *
 * @member {string} [tenantId] The tenant ID. For example,
 * 00000000-0000-0000-0000-000000000000.
 *
 */
class TenantIdDescription {
  constructor() {
  }

  /**
   * Defines the metadata of TenantIdDescription
   *
   * @returns {object} metadata of TenantIdDescription
   *
   */
  mapper() {
    return {
      required: false,
      serializedName: 'TenantIdDescription',
      type: {
        name: 'Composite',
        className: 'TenantIdDescription',
        modelProperties: {
          id: {
            required: false,
            readOnly: true,
            serializedName: 'id',
            type: {
              name: 'String'
            }
          },
          tenantId: {
            required: false,
            readOnly: true,
            serializedName: 'tenantId',
            type: {
              name: 'String'
            }
          }
        }
      }
    };
  }
}

module.exports = TenantIdDescription;
