// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * The programmatic identifier of the tablesSASTokenPolicy.
 */
export const tablesSASTokenPolicyName = "tablesSASTokenPolicy";
/**
 * tablesSASTokenPolicy is a policy used to sign HTTP request with a shared key.
 */
export function tablesSASTokenPolicy(credential) {
    return {
        name: tablesSASTokenPolicyName,
        async sendRequest(request, next) {
            signURLWithSAS(request, credential);
            return next(request);
        },
    };
}
export function signURLWithSAS(request, credential) {
    const sasParams = new URLSearchParams(credential.signature);
    const url = new URL(request.url);
    for (const [name, value] of sasParams) {
        url.searchParams.append(name, value);
    }
    request.url = url.toString();
}
//# sourceMappingURL=tablesSASTokenPolicy.js.map