// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { base64Decode, base64Encode } from "./bufferSerializer.js";
/**
 * Encodes the nextPartitionKey and nextRowKey into a single continuation token
 */
export function encodeContinuationToken(nextPartitionKey, nextRowKey) {
    if (!nextPartitionKey) {
        return undefined;
    }
    const continuationToken = {
        nextPartitionKey,
        // Only add nextRowKey if the value is not null, undefined or empty string.
        ...(nextRowKey && { nextRowKey }),
    };
    return base64Encode(JSON.stringify(continuationToken));
}
/**
 * Decodes a continuationToken into an object containing a nextPartitionKey and nextRowKey
 */
export function decodeContinuationToken(encodedToken) {
    const decodedToken = base64Decode(encodedToken);
    let tokenStr = "";
    for (const byte of decodedToken) {
        tokenStr += String.fromCharCode(byte);
    }
    const continuationToken = JSON.parse(tokenStr);
    return continuationToken;
}
//# sourceMappingURL=continuationToken.js.map