"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.encodeContinuationToken = encodeContinuationToken;
exports.decodeContinuationToken = decodeContinuationToken;
const bufferSerializer_js_1 = require("./bufferSerializer.js");
/**
 * Encodes the nextPartitionKey and nextRowKey into a single continuation token
 */
function encodeContinuationToken(nextPartitionKey, nextRowKey) {
    if (!nextPartitionKey) {
        return undefined;
    }
    const continuationToken = {
        nextPartitionKey,
        // Only add nextRowKey if the value is not null, undefined or empty string.
        ...(nextRowKey && { nextRowKey }),
    };
    return (0, bufferSerializer_js_1.base64Encode)(JSON.stringify(continuationToken));
}
/**
 * Decodes a continuationToken into an object containing a nextPartitionKey and nextRowKey
 */
function decodeContinuationToken(encodedToken) {
    const decodedToken = (0, bufferSerializer_js_1.base64Decode)(encodedToken);
    let tokenStr = "";
    for (const byte of decodedToken) {
        tokenStr += String.fromCharCode(byte);
    }
    const continuationToken = JSON.parse(tokenStr);
    return continuationToken;
}
//# sourceMappingURL=continuationToken.js.map