import type { ClientParamsFromConnectionString, ConnectionString } from "./internalModels.js";
import type { TableServiceClientOptions } from "../models.js";
/**
 * This function parses a connection string into a set of
 * parameters to pass to be passed to TableClientService,
 * depending on the connection string type these parameter would
 * contain:
 * - Account Connection String:  A pipeline to sign the request with a SharedKey
 * - SAS Connection String: Attach a SAS token to the storage account url for authentication
 * @param connectionString - Connection string to parse
 * @param options - TableService client options
 */
export declare function getClientParamsFromConnectionString(connectionString: string, options?: TableServiceClientOptions): ClientParamsFromConnectionString;
/**
 * Extracts the parts of an Storage account connection string.
 *
 * @param connectionString - Connection string.
 * @returns String key value pairs of the storage account's url and credentials.
 */
export declare function extractConnectionStringParts(connectionString: string): ConnectionString;
//# sourceMappingURL=connectionString.d.ts.map