import type { OperationOptions } from "@azure/core-client";
import type { PipelinePolicy } from "@azure/core-rest-pipeline";
/**
 * The programmatic identifier of the tablesSecondaryEndpointPolicy.
 */
export declare const tablesSecondaryEndpointPolicyName = "tablesSecondaryEndpointPolicy";
export declare const SecondaryLocationHeaderName = "tables-secondary-endpoint";
/**
 * Policy that would replace the Primary Endpoint with the secondary endpoint
 * when the `tables-secondary-endpoint` is set in the request
 */
export declare const tablesSecondaryEndpointPolicy: PipelinePolicy;
/**
 * Utility function that injects the SecondaryEndpointHeader into an operation options
 */
export declare function injectSecondaryEndpointHeader(options: OperationOptions): OperationOptions;
//# sourceMappingURL=secondaryEndpointPolicy.d.ts.map