import type { StorageClient as StorageClientContext } from "./generated/src/index.js";
import type { PipelineLike } from "./Pipeline.js";
import type { AnonymousCredential, StorageSharedKeyCredential } from "@azure/storage-common";
import type { TokenCredential } from "@azure/core-auth";
import type { OperationTracingOptions } from "@azure/core-tracing";
/**
 * An interface for options common to every remote operation.
 */
export interface CommonOptions {
    /**
     * Options to configure spans created when tracing is enabled.
     */
    tracingOptions?: OperationTracingOptions;
}
/**
 * A StorageClient represents a based URL class for {@link BlobServiceClient}, {@link ContainerClient}
 * and etc.
 */
export declare abstract class StorageClient {
    /**
     * Encoded URL string value.
     */
    readonly url: string;
    readonly accountName: string;
    /**
     * Request policy pipeline.
     *
     * @internal
     */
    protected readonly pipeline: PipelineLike;
    /**
     * Such as AnonymousCredential, StorageSharedKeyCredential or any credential from the `@azure/identity` package to authenticate requests to the service. You can also provide an object that implements the TokenCredential interface. If not specified, AnonymousCredential is used.
     */
    readonly credential: StorageSharedKeyCredential | AnonymousCredential | TokenCredential;
    /**
     * StorageClient is a reference to protocol layer operations entry, which is
     * generated by AutoRest generator.
     */
    protected readonly storageClientContext: StorageClientContext;
    /**
     */
    protected readonly isHttps: boolean;
    /**
     * Creates an instance of StorageClient.
     * @param url - url to resource
     * @param pipeline - request policy pipeline.
     */
    protected constructor(url: string, pipeline: PipelineLike);
}
//# sourceMappingURL=StorageClient.d.ts.map