"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShareClientInternal = void 0;
const StorageClient_js_1 = require("./StorageClient.js");
/**
 * ShareClientInternal is the thin wrapper for Share which contains internal helper methods.
 */
class ShareClientInternal extends StorageClient_js_1.StorageClient {
    context;
    constructor(url, pipeline) {
        super(url, pipeline);
        this.context = this.storageClientContext.share;
    }
    async restore(options = {}) {
        return this.context.restore(options);
    }
}
exports.ShareClientInternal = ShareClientInternal;
//# sourceMappingURL=ShareClientInternal.js.map