"use strict";
/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DirectoryImpl = void 0;
const tslib_1 = require("tslib");
const coreClient = tslib_1.__importStar(require("@azure/core-client"));
const Mappers = tslib_1.__importStar(require("../models/mappers.js"));
const Parameters = tslib_1.__importStar(require("../models/parameters.js"));
/** Class containing Directory operations. */
class DirectoryImpl {
    client;
    /**
     * Initialize a new instance of the class Directory class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * Creates a new directory under the specified share or parent directory.
     * @param options The options parameters.
     */
    create(options) {
        return this.client.sendOperationRequest({ options }, createOperationSpec);
    }
    /**
     * Returns all system properties for the specified directory, and can also be used to check the
     * existence of a directory. The data returned does not include the files in the directory or any
     * subdirectories.
     * @param options The options parameters.
     */
    getProperties(options) {
        return this.client.sendOperationRequest({ options }, getPropertiesOperationSpec);
    }
    /**
     * Removes the specified empty directory. Note that the directory must be empty before it can be
     * deleted.
     * @param options The options parameters.
     */
    delete(options) {
        return this.client.sendOperationRequest({ options }, deleteOperationSpec);
    }
    /**
     * Sets properties on the directory.
     * @param options The options parameters.
     */
    setProperties(options) {
        return this.client.sendOperationRequest({ options }, setPropertiesOperationSpec);
    }
    /**
     * Updates user defined metadata for the specified directory.
     * @param options The options parameters.
     */
    setMetadata(options) {
        return this.client.sendOperationRequest({ options }, setMetadataOperationSpec);
    }
    /**
     * Returns a list of files or directories under the specified share or directory. It lists the contents
     * only for a single level of the directory hierarchy.
     * @param options The options parameters.
     */
    listFilesAndDirectoriesSegment(options) {
        return this.client.sendOperationRequest({ options }, listFilesAndDirectoriesSegmentOperationSpec);
    }
    /**
     * Lists handles for directory.
     * @param options The options parameters.
     */
    listHandles(options) {
        return this.client.sendOperationRequest({ options }, listHandlesOperationSpec);
    }
    /**
     * Closes all handles open for given directory.
     * @param handleId Specifies handle ID opened on the file or directory to be closed. Asterisk (‘*’) is
     *                 a wildcard that specifies all handles.
     * @param options The options parameters.
     */
    forceCloseHandles(handleId, options) {
        return this.client.sendOperationRequest({ handleId, options }, forceCloseHandlesOperationSpec);
    }
    /**
     * Renames a directory
     * @param renameSource Required. Specifies the URI-style path of the source file, up to 2 KB in length.
     * @param options The options parameters.
     */
    rename(renameSource, options) {
        return this.client.sendOperationRequest({ renameSource, options }, renameOperationSpec);
    }
}
exports.DirectoryImpl = DirectoryImpl;
// Operation Specifications
const xmlSerializer = coreClient.createSerializer(Mappers, /* isXml */ true);
const createOperationSpec = {
    path: "/{shareName}/{directory}",
    httpMethod: "PUT",
    responses: {
        201: {
            headersMapper: Mappers.DirectoryCreateHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.DirectoryCreateExceptionHeaders,
        },
    },
    queryParameters: [Parameters.timeoutInSeconds, Parameters.restype2],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.fileRequestIntent,
        Parameters.accept1,
        Parameters.metadata,
        Parameters.filePermissionFormat,
        Parameters.allowTrailingDot,
        Parameters.filePermission,
        Parameters.filePermissionKey1,
        Parameters.fileAttributes,
        Parameters.fileCreatedOn,
        Parameters.fileLastWriteOn,
        Parameters.fileChangeOn,
        Parameters.owner,
        Parameters.group,
        Parameters.fileMode,
        Parameters.filePropertySemantics,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
const getPropertiesOperationSpec = {
    path: "/{shareName}/{directory}",
    httpMethod: "GET",
    responses: {
        200: {
            headersMapper: Mappers.DirectoryGetPropertiesHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.DirectoryGetPropertiesExceptionHeaders,
        },
    },
    queryParameters: [
        Parameters.timeoutInSeconds,
        Parameters.shareSnapshot,
        Parameters.restype2,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.fileRequestIntent,
        Parameters.accept1,
        Parameters.allowTrailingDot,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
const deleteOperationSpec = {
    path: "/{shareName}/{directory}",
    httpMethod: "DELETE",
    responses: {
        202: {
            headersMapper: Mappers.DirectoryDeleteHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.DirectoryDeleteExceptionHeaders,
        },
    },
    queryParameters: [Parameters.timeoutInSeconds, Parameters.restype2],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.fileRequestIntent,
        Parameters.accept1,
        Parameters.allowTrailingDot,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
const setPropertiesOperationSpec = {
    path: "/{shareName}/{directory}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: Mappers.DirectorySetPropertiesHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.DirectorySetPropertiesExceptionHeaders,
        },
    },
    queryParameters: [
        Parameters.comp,
        Parameters.timeoutInSeconds,
        Parameters.restype2,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.fileRequestIntent,
        Parameters.accept1,
        Parameters.filePermissionFormat,
        Parameters.allowTrailingDot,
        Parameters.filePermission,
        Parameters.filePermissionKey1,
        Parameters.fileAttributes,
        Parameters.fileCreatedOn,
        Parameters.fileLastWriteOn,
        Parameters.fileChangeOn,
        Parameters.owner,
        Parameters.group,
        Parameters.fileMode,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
const setMetadataOperationSpec = {
    path: "/{shareName}/{directory}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: Mappers.DirectorySetMetadataHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.DirectorySetMetadataExceptionHeaders,
        },
    },
    queryParameters: [
        Parameters.timeoutInSeconds,
        Parameters.comp6,
        Parameters.restype2,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.fileRequestIntent,
        Parameters.accept1,
        Parameters.metadata,
        Parameters.allowTrailingDot,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
const listFilesAndDirectoriesSegmentOperationSpec = {
    path: "/{shareName}/{directory}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.ListFilesAndDirectoriesSegmentResponse,
            headersMapper: Mappers.DirectoryListFilesAndDirectoriesSegmentHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.DirectoryListFilesAndDirectoriesSegmentExceptionHeaders,
        },
    },
    queryParameters: [
        Parameters.timeoutInSeconds,
        Parameters.comp1,
        Parameters.prefix,
        Parameters.marker,
        Parameters.maxResults,
        Parameters.shareSnapshot,
        Parameters.restype2,
        Parameters.include1,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.fileRequestIntent,
        Parameters.accept1,
        Parameters.allowTrailingDot,
        Parameters.includeExtendedInfo,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
const listHandlesOperationSpec = {
    path: "/{shareName}/{directory}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.ListHandlesResponse,
            headersMapper: Mappers.DirectoryListHandlesHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.DirectoryListHandlesExceptionHeaders,
        },
    },
    queryParameters: [
        Parameters.timeoutInSeconds,
        Parameters.marker,
        Parameters.maxResults,
        Parameters.shareSnapshot,
        Parameters.comp10,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.fileRequestIntent,
        Parameters.accept1,
        Parameters.allowTrailingDot,
        Parameters.recursive,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
const forceCloseHandlesOperationSpec = {
    path: "/{shareName}/{directory}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: Mappers.DirectoryForceCloseHandlesHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.DirectoryForceCloseHandlesExceptionHeaders,
        },
    },
    queryParameters: [
        Parameters.timeoutInSeconds,
        Parameters.marker,
        Parameters.shareSnapshot,
        Parameters.comp11,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.fileRequestIntent,
        Parameters.accept1,
        Parameters.allowTrailingDot,
        Parameters.recursive,
        Parameters.handleId,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
const renameOperationSpec = {
    path: "/{shareName}/{directory}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: Mappers.DirectoryRenameHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.DirectoryRenameExceptionHeaders,
        },
    },
    queryParameters: [
        Parameters.timeoutInSeconds,
        Parameters.restype2,
        Parameters.comp12,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.fileRequestIntent,
        Parameters.accept1,
        Parameters.metadata,
        Parameters.filePermissionFormat,
        Parameters.allowTrailingDot,
        Parameters.filePermission,
        Parameters.filePermissionKey1,
        Parameters.renameSource,
        Parameters.replaceIfExists,
        Parameters.ignoreReadOnly,
        Parameters.sourceLeaseId,
        Parameters.destinationLeaseId,
        Parameters.fileAttributes1,
        Parameters.fileCreationTime,
        Parameters.fileLastWriteTime,
        Parameters.fileChangeTime,
        Parameters.allowSourceTrailingDot,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
//# sourceMappingURL=directory.js.map