import * as coreHttpCompat from "@azure/core-http-compat";
import { Service, Share, Directory, File } from "./operationsInterfaces/index.js";
import { StorageClientOptionalParams } from "./models/index.js";
export declare class StorageClient extends coreHttpCompat.ExtendedServiceClient {
    url: string;
    version: string;
    fileRangeWriteFromUrl: string;
    /**
     * Initializes a new instance of the StorageClient class.
     * @param url The URL of the service account, share, directory or file that is the target of the
     *            desired operation.
     * @param options The parameter options
     */
    constructor(url: string, options?: StorageClientOptionalParams);
    service: Service;
    share: Share;
    directory: Directory;
    file: File;
}
//# sourceMappingURL=storageClient.d.ts.map