"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.logger = exports.RestError = exports.StorageOAuthScopes = exports.newPipeline = exports.isPipelineLike = exports.Pipeline = exports.getFileServiceAccountAudience = exports.StorageFileAudience = exports.StorageBrowserPolicyFactory = exports.StorageSharedKeyCredentialPolicy = exports.StorageRetryPolicyFactory = exports.StorageRetryPolicy = exports.StorageRetryPolicyType = exports.CredentialPolicy = exports.AnonymousCredentialPolicy = exports.BaseRequestPolicy = exports.StorageSharedKeyCredential = exports.Credential = exports.AnonymousCredential = exports.generateFileSASQueryParameters = exports.toSymbolicFileMode = exports.parseSymbolicFileMode = exports.toOctalFileMode = exports.parseOctalFileMode = exports.generateAccountSASQueryParameters = void 0;
const tslib_1 = require("tslib");
const core_rest_pipeline_1 = require("@azure/core-rest-pipeline");
Object.defineProperty(exports, "RestError", { enumerable: true, get: function () { return core_rest_pipeline_1.RestError; } });
tslib_1.__exportStar(require("./AccountSASPermissions.js"), exports);
tslib_1.__exportStar(require("./AccountSASResourceTypes.js"), exports);
tslib_1.__exportStar(require("./AccountSASServices.js"), exports);
var AccountSASSignatureValues_js_1 = require("./AccountSASSignatureValues.js");
Object.defineProperty(exports, "generateAccountSASQueryParameters", { enumerable: true, get: function () { return AccountSASSignatureValues_js_1.generateAccountSASQueryParameters; } });
tslib_1.__exportStar(require("./FileSASPermissions.js"), exports);
var utils_common_js_1 = require("./utils/utils.common.js");
Object.defineProperty(exports, "parseOctalFileMode", { enumerable: true, get: function () { return utils_common_js_1.parseOctalFileMode; } });
Object.defineProperty(exports, "toOctalFileMode", { enumerable: true, get: function () { return utils_common_js_1.toOctalFileMode; } });
Object.defineProperty(exports, "parseSymbolicFileMode", { enumerable: true, get: function () { return utils_common_js_1.parseSymbolicFileMode; } });
Object.defineProperty(exports, "toSymbolicFileMode", { enumerable: true, get: function () { return utils_common_js_1.toSymbolicFileMode; } });
var FileSASSignatureValues_js_1 = require("./FileSASSignatureValues.js");
Object.defineProperty(exports, "generateFileSASQueryParameters", { enumerable: true, get: function () { return FileSASSignatureValues_js_1.generateFileSASQueryParameters; } });
tslib_1.__exportStar(require("./Clients.js"), exports);
tslib_1.__exportStar(require("./ShareSASPermissions.js"), exports);
var storage_common_1 = require("@azure/storage-common");
Object.defineProperty(exports, "AnonymousCredential", { enumerable: true, get: function () { return storage_common_1.AnonymousCredential; } });
Object.defineProperty(exports, "Credential", { enumerable: true, get: function () { return storage_common_1.Credential; } });
Object.defineProperty(exports, "StorageSharedKeyCredential", { enumerable: true, get: function () { return storage_common_1.StorageSharedKeyCredential; } });
Object.defineProperty(exports, "BaseRequestPolicy", { enumerable: true, get: function () { return storage_common_1.BaseRequestPolicy; } });
Object.defineProperty(exports, "AnonymousCredentialPolicy", { enumerable: true, get: function () { return storage_common_1.AnonymousCredentialPolicy; } });
Object.defineProperty(exports, "CredentialPolicy", { enumerable: true, get: function () { return storage_common_1.CredentialPolicy; } });
Object.defineProperty(exports, "StorageRetryPolicyType", { enumerable: true, get: function () { return storage_common_1.StorageRetryPolicyType; } });
Object.defineProperty(exports, "StorageRetryPolicy", { enumerable: true, get: function () { return storage_common_1.StorageRetryPolicy; } });
Object.defineProperty(exports, "StorageRetryPolicyFactory", { enumerable: true, get: function () { return storage_common_1.StorageRetryPolicyFactory; } });
Object.defineProperty(exports, "StorageSharedKeyCredentialPolicy", { enumerable: true, get: function () { return storage_common_1.StorageSharedKeyCredentialPolicy; } });
Object.defineProperty(exports, "StorageBrowserPolicyFactory", { enumerable: true, get: function () { return storage_common_1.StorageBrowserPolicyFactory; } });
var models_js_1 = require("./models.js");
Object.defineProperty(exports, "StorageFileAudience", { enumerable: true, get: function () { return models_js_1.StorageFileAudience; } });
Object.defineProperty(exports, "getFileServiceAccountAudience", { enumerable: true, get: function () { return models_js_1.getFileServiceAccountAudience; } });
tslib_1.__exportStar(require("./FileSystemAttributes.js"), exports);
var Pipeline_js_1 = require("./Pipeline.js");
Object.defineProperty(exports, "Pipeline", { enumerable: true, get: function () { return Pipeline_js_1.Pipeline; } });
Object.defineProperty(exports, "isPipelineLike", { enumerable: true, get: function () { return Pipeline_js_1.isPipelineLike; } });
Object.defineProperty(exports, "newPipeline", { enumerable: true, get: function () { return Pipeline_js_1.newPipeline; } });
Object.defineProperty(exports, "StorageOAuthScopes", { enumerable: true, get: function () { return Pipeline_js_1.StorageOAuthScopes; } });
tslib_1.__exportStar(require("./ShareServiceClient.js"), exports);
tslib_1.__exportStar(require("./SASQueryParameters.js"), exports);
tslib_1.__exportStar(require("./generatedModels.js"), exports);
var log_js_1 = require("./log.js");
Object.defineProperty(exports, "logger", { enumerable: true, get: function () { return log_js_1.logger; } });
//# sourceMappingURL=index.js.map