import { StorageSharedKeyCredential, UserDelegationKey } from "@azure/storage-common";
import { FileSASPermissions } from "./FileSASPermissions.js";
import type { SasIPRange } from "./SasIPRange.js";
import type { SASProtocol } from "./SASQueryParameters.js";
import { SASQueryParameters } from "./SASQueryParameters.js";
import { ShareSASPermissions } from "./ShareSASPermissions.js";
import { UserDelegationKeyCredential } from "@azure/storage-common";
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * FileSASSignatureValues is used to help generating File service SAS tokens for shares or files.
 */
export interface FileSASSignatureValues {
    /**
     * The version of the service this SAS will target. If not specified, it will default to the version targeted by the
     * library.
     */
    version?: string;
    /**
     * Optional. SAS protocols, HTTPS only or HTTPSandHTTP
     */
    protocol?: SASProtocol;
    /**
     * Optional. When the SAS will take effect.
     */
    startsOn?: Date;
    /**
     * Optional only when identifier is provided. The time after which the SAS will no longer work.
     */
    expiresOn?: Date;
    /**
     * Optional only when identifier is provided.
     * Please refer to either {@link ShareSASPermissions} or {@link FileSASPermissions} depending on the resource
     * being accessed for help constructing the permissions string.
     */
    permissions?: FileSASPermissions | ShareSASPermissions;
    /**
     * Optional. IP ranges allowed in this SAS.
     */
    ipRange?: SasIPRange;
    /**
     * The name of the share the SAS user may access.
     */
    shareName: string;
    /**
     * Optional. The path of the file like, "directory/FileName" or "FileName".
     */
    filePath?: string;
    /**
     * Optional. The name of the access policy on the share this SAS references if any.
     *
     * @see https://learn.microsoft.com/rest/api/storageservices/establishing-a-stored-access-policy
     */
    identifier?: string;
    /**
     * Optional. Beginning in version 2025-07-05, this value specifies the Entra ID of the user who is authorized to
     * use the resulting SAS URL.  The resulting SAS URL must be used in conjunction with an Entra ID token that has been
     * issued to the user specified in this value.
     */
    delegatedUserObjectId?: string;
    /**
     * Optional. The cache-control header for the SAS.
     */
    cacheControl?: string;
    /**
     * Optional. The content-disposition header for the SAS.
     */
    contentDisposition?: string;
    /**
     * Optional. The content-encoding header for the SAS.
     */
    contentEncoding?: string;
    /**
     * Optional. The content-language header for the SAS.
     */
    contentLanguage?: string;
    /**
     * Optional. The content-type header for the SAS.
     */
    contentType?: string;
}
export declare function generateFileSASQueryParameters(fileSASSignatureValues: FileSASSignatureValues, userDelegationKey: UserDelegationKey, accountName: string): SASQueryParameters;
export declare function generateFileSASQueryParameters(fileSASSignatureValues: FileSASSignatureValues, sharedKeyCredential: StorageSharedKeyCredential): SASQueryParameters;
export declare function generateFileSASQueryParametersInternal(fileSASSignatureValues: FileSASSignatureValues, sharedKeyCredentialOrUserDelegationKey: StorageSharedKeyCredential | UserDelegationKey, accountName?: string): {
    sasQueryParameters: SASQueryParameters;
    stringToSign: string;
};
export declare function generateFileSASQueryParametersDefault(fileSASSignatureValues: FileSASSignatureValues, sharedKeyCredential: StorageSharedKeyCredential): {
    sasQueryParameters: SASQueryParameters;
    stringToSign: string;
};
export declare function generateFileSASQueryParametersUDK20250705(fileSASSignatureValues: FileSASSignatureValues, userDelegationKeyCredential: UserDelegationKeyCredential, accountName: string): {
    sasQueryParameters: SASQueryParameters;
    stringToSign: string;
};
//# sourceMappingURL=FileSASSignatureValues.d.ts.map