/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
import { FileServiceProperties as FileServicePropertiesMapper, KeyInfo as KeyInfoMapper, SharePermission as SharePermissionMapper, } from "../models/mappers.js";
export const contentType = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String",
        },
    },
};
export const properties = {
    parameterPath: "properties",
    mapper: FileServicePropertiesMapper,
};
export const accept = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String",
        },
    },
};
export const url = {
    parameterPath: "url",
    mapper: {
        serializedName: "url",
        required: true,
        xmlName: "url",
        type: {
            name: "String",
        },
    },
    skipEncoding: true,
};
export const restype = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "service",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String",
        },
    },
};
export const comp = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "properties",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const timeoutInSeconds = {
    parameterPath: ["options", "timeoutInSeconds"],
    mapper: {
        constraints: {
            InclusiveMinimum: 0,
        },
        serializedName: "timeout",
        xmlName: "timeout",
        type: {
            name: "Number",
        },
    },
};
export const version = {
    parameterPath: "version",
    mapper: {
        defaultValue: "2026-02-06",
        isConstant: true,
        serializedName: "x-ms-version",
        type: {
            name: "String",
        },
    },
};
export const fileRequestIntent = {
    parameterPath: ["options", "fileRequestIntent"],
    mapper: {
        serializedName: "x-ms-file-request-intent",
        xmlName: "x-ms-file-request-intent",
        type: {
            name: "String",
        },
    },
};
export const accept1 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String",
        },
    },
};
export const comp1 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "list",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const prefix = {
    parameterPath: ["options", "prefix"],
    mapper: {
        serializedName: "prefix",
        xmlName: "prefix",
        type: {
            name: "String",
        },
    },
};
export const marker = {
    parameterPath: ["options", "marker"],
    mapper: {
        serializedName: "marker",
        xmlName: "marker",
        type: {
            name: "String",
        },
    },
};
export const maxResults = {
    parameterPath: ["options", "maxResults"],
    mapper: {
        constraints: {
            InclusiveMinimum: 1,
        },
        serializedName: "maxresults",
        xmlName: "maxresults",
        type: {
            name: "Number",
        },
    },
};
export const include = {
    parameterPath: ["options", "include"],
    mapper: {
        serializedName: "include",
        xmlName: "include",
        xmlElementName: "ListSharesIncludeType",
        type: {
            name: "Sequence",
            element: {
                type: {
                    name: "Enum",
                    allowedValues: ["snapshots", "metadata", "deleted"],
                },
            },
        },
    },
    collectionFormat: "CSV",
};
export const keyInfo = {
    parameterPath: "keyInfo",
    mapper: KeyInfoMapper,
};
export const comp2 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "userdelegationkey",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const requestId = {
    parameterPath: ["options", "requestId"],
    mapper: {
        serializedName: "x-ms-client-request-id",
        xmlName: "x-ms-client-request-id",
        type: {
            name: "String",
        },
    },
};
export const restype1 = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "share",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String",
        },
    },
};
export const metadata = {
    parameterPath: ["options", "metadata"],
    mapper: {
        serializedName: "x-ms-meta",
        xmlName: "x-ms-meta",
        headerCollectionPrefix: "x-ms-meta-",
        type: {
            name: "Dictionary",
            value: { type: { name: "String" } },
        },
    },
};
export const quota = {
    parameterPath: ["options", "quota"],
    mapper: {
        constraints: {
            InclusiveMinimum: 1,
        },
        serializedName: "x-ms-share-quota",
        xmlName: "x-ms-share-quota",
        type: {
            name: "Number",
        },
    },
};
export const accessTier = {
    parameterPath: ["options", "accessTier"],
    mapper: {
        serializedName: "x-ms-access-tier",
        xmlName: "x-ms-access-tier",
        type: {
            name: "Enum",
            allowedValues: ["TransactionOptimized", "Hot", "Cool", "Premium"],
        },
    },
};
export const enabledProtocols = {
    parameterPath: ["options", "enabledProtocols"],
    mapper: {
        serializedName: "x-ms-enabled-protocols",
        xmlName: "x-ms-enabled-protocols",
        type: {
            name: "String",
        },
    },
};
export const rootSquash = {
    parameterPath: ["options", "rootSquash"],
    mapper: {
        serializedName: "x-ms-root-squash",
        xmlName: "x-ms-root-squash",
        type: {
            name: "Enum",
            allowedValues: ["NoRootSquash", "RootSquash", "AllSquash"],
        },
    },
};
export const enableSnapshotVirtualDirectoryAccess = {
    parameterPath: ["options", "enableSnapshotVirtualDirectoryAccess"],
    mapper: {
        serializedName: "x-ms-enable-snapshot-virtual-directory-access",
        xmlName: "x-ms-enable-snapshot-virtual-directory-access",
        type: {
            name: "Boolean",
        },
    },
};
export const paidBurstingEnabled = {
    parameterPath: ["options", "paidBurstingEnabled"],
    mapper: {
        serializedName: "x-ms-share-paid-bursting-enabled",
        xmlName: "x-ms-share-paid-bursting-enabled",
        type: {
            name: "Boolean",
        },
    },
};
export const paidBurstingMaxBandwidthMibps = {
    parameterPath: ["options", "paidBurstingMaxBandwidthMibps"],
    mapper: {
        serializedName: "x-ms-share-paid-bursting-max-bandwidth-mibps",
        xmlName: "x-ms-share-paid-bursting-max-bandwidth-mibps",
        type: {
            name: "Number",
        },
    },
};
export const paidBurstingMaxIops = {
    parameterPath: ["options", "paidBurstingMaxIops"],
    mapper: {
        serializedName: "x-ms-share-paid-bursting-max-iops",
        xmlName: "x-ms-share-paid-bursting-max-iops",
        type: {
            name: "Number",
        },
    },
};
export const shareProvisionedIops = {
    parameterPath: ["options", "shareProvisionedIops"],
    mapper: {
        serializedName: "x-ms-share-provisioned-iops",
        xmlName: "x-ms-share-provisioned-iops",
        type: {
            name: "Number",
        },
    },
};
export const shareProvisionedBandwidthMibps = {
    parameterPath: ["options", "shareProvisionedBandwidthMibps"],
    mapper: {
        serializedName: "x-ms-share-provisioned-bandwidth-mibps",
        xmlName: "x-ms-share-provisioned-bandwidth-mibps",
        type: {
            name: "Number",
        },
    },
};
export const shareSnapshot = {
    parameterPath: ["options", "shareSnapshot"],
    mapper: {
        serializedName: "sharesnapshot",
        xmlName: "sharesnapshot",
        type: {
            name: "String",
        },
    },
};
export const leaseId = {
    parameterPath: ["options", "leaseAccessConditions", "leaseId"],
    mapper: {
        serializedName: "x-ms-lease-id",
        xmlName: "x-ms-lease-id",
        type: {
            name: "String",
        },
    },
};
export const deleteSnapshots = {
    parameterPath: ["options", "deleteSnapshots"],
    mapper: {
        serializedName: "x-ms-delete-snapshots",
        xmlName: "x-ms-delete-snapshots",
        type: {
            name: "Enum",
            allowedValues: ["include", "include-leased"],
        },
    },
};
export const comp3 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "lease",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const action = {
    parameterPath: "action",
    mapper: {
        defaultValue: "acquire",
        isConstant: true,
        serializedName: "x-ms-lease-action",
        type: {
            name: "String",
        },
    },
};
export const duration = {
    parameterPath: ["options", "duration"],
    mapper: {
        serializedName: "x-ms-lease-duration",
        xmlName: "x-ms-lease-duration",
        type: {
            name: "Number",
        },
    },
};
export const proposedLeaseId = {
    parameterPath: ["options", "proposedLeaseId"],
    mapper: {
        serializedName: "x-ms-proposed-lease-id",
        xmlName: "x-ms-proposed-lease-id",
        type: {
            name: "String",
        },
    },
};
export const action1 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "release",
        isConstant: true,
        serializedName: "x-ms-lease-action",
        type: {
            name: "String",
        },
    },
};
export const leaseId1 = {
    parameterPath: "leaseId",
    mapper: {
        serializedName: "x-ms-lease-id",
        required: true,
        xmlName: "x-ms-lease-id",
        type: {
            name: "String",
        },
    },
};
export const action2 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "change",
        isConstant: true,
        serializedName: "x-ms-lease-action",
        type: {
            name: "String",
        },
    },
};
export const action3 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "renew",
        isConstant: true,
        serializedName: "x-ms-lease-action",
        type: {
            name: "String",
        },
    },
};
export const action4 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "break",
        isConstant: true,
        serializedName: "x-ms-lease-action",
        type: {
            name: "String",
        },
    },
};
export const breakPeriod = {
    parameterPath: ["options", "breakPeriod"],
    mapper: {
        serializedName: "x-ms-lease-break-period",
        xmlName: "x-ms-lease-break-period",
        type: {
            name: "Number",
        },
    },
};
export const comp4 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "snapshot",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const contentType1 = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String",
        },
    },
};
export const sharePermission = {
    parameterPath: "sharePermission",
    mapper: SharePermissionMapper,
};
export const comp5 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "filepermission",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const accept2 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String",
        },
    },
};
export const filePermissionKey = {
    parameterPath: "filePermissionKey",
    mapper: {
        serializedName: "x-ms-file-permission-key",
        required: true,
        xmlName: "x-ms-file-permission-key",
        type: {
            name: "String",
        },
    },
};
export const filePermissionFormat = {
    parameterPath: ["options", "filePermissionFormat"],
    mapper: {
        serializedName: "x-ms-file-permission-format",
        xmlName: "x-ms-file-permission-format",
        type: {
            name: "Enum",
            allowedValues: ["Sddl", "Binary"],
        },
    },
};
export const comp6 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "metadata",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const comp7 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "acl",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const shareAcl = {
    parameterPath: ["options", "shareAcl"],
    mapper: {
        serializedName: "shareAcl",
        xmlName: "SignedIdentifiers",
        xmlIsWrapped: true,
        xmlElementName: "SignedIdentifier",
        type: {
            name: "Sequence",
            element: {
                type: {
                    name: "Composite",
                    className: "SignedIdentifier",
                },
            },
        },
    },
};
export const comp8 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "stats",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const comp9 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "undelete",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const deletedShareName = {
    parameterPath: ["options", "deletedShareName"],
    mapper: {
        serializedName: "x-ms-deleted-share-name",
        xmlName: "x-ms-deleted-share-name",
        type: {
            name: "String",
        },
    },
};
export const deletedShareVersion = {
    parameterPath: ["options", "deletedShareVersion"],
    mapper: {
        serializedName: "x-ms-deleted-share-version",
        xmlName: "x-ms-deleted-share-version",
        type: {
            name: "String",
        },
    },
};
export const restype2 = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "directory",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String",
        },
    },
};
export const allowTrailingDot = {
    parameterPath: ["options", "allowTrailingDot"],
    mapper: {
        serializedName: "x-ms-allow-trailing-dot",
        xmlName: "x-ms-allow-trailing-dot",
        type: {
            name: "Boolean",
        },
    },
};
export const filePermission = {
    parameterPath: ["options", "filePermission"],
    mapper: {
        serializedName: "x-ms-file-permission",
        xmlName: "x-ms-file-permission",
        type: {
            name: "String",
        },
    },
};
export const filePermissionKey1 = {
    parameterPath: ["options", "filePermissionKey"],
    mapper: {
        serializedName: "x-ms-file-permission-key",
        xmlName: "x-ms-file-permission-key",
        type: {
            name: "String",
        },
    },
};
export const fileAttributes = {
    parameterPath: ["options", "fileAttributes"],
    mapper: {
        serializedName: "x-ms-file-attributes",
        xmlName: "x-ms-file-attributes",
        type: {
            name: "String",
        },
    },
};
export const fileCreatedOn = {
    parameterPath: ["options", "fileCreatedOn"],
    mapper: {
        serializedName: "x-ms-file-creation-time",
        xmlName: "x-ms-file-creation-time",
        type: {
            name: "String",
        },
    },
};
export const fileLastWriteOn = {
    parameterPath: ["options", "fileLastWriteOn"],
    mapper: {
        serializedName: "x-ms-file-last-write-time",
        xmlName: "x-ms-file-last-write-time",
        type: {
            name: "String",
        },
    },
};
export const fileChangeOn = {
    parameterPath: ["options", "fileChangeOn"],
    mapper: {
        serializedName: "x-ms-file-change-time",
        xmlName: "x-ms-file-change-time",
        type: {
            name: "String",
        },
    },
};
export const owner = {
    parameterPath: ["options", "owner"],
    mapper: {
        serializedName: "x-ms-owner",
        xmlName: "x-ms-owner",
        type: {
            name: "String",
        },
    },
};
export const group = {
    parameterPath: ["options", "group"],
    mapper: {
        serializedName: "x-ms-group",
        xmlName: "x-ms-group",
        type: {
            name: "String",
        },
    },
};
export const fileMode = {
    parameterPath: ["options", "fileMode"],
    mapper: {
        serializedName: "x-ms-mode",
        xmlName: "x-ms-mode",
        type: {
            name: "String",
        },
    },
};
export const filePropertySemantics = {
    parameterPath: ["options", "filePropertySemantics"],
    mapper: {
        serializedName: "x-ms-file-property-semantics",
        xmlName: "x-ms-file-property-semantics",
        type: {
            name: "String",
        },
    },
};
export const include1 = {
    parameterPath: ["options", "include"],
    mapper: {
        serializedName: "include",
        xmlName: "include",
        xmlElementName: "ListFilesIncludeType",
        type: {
            name: "Sequence",
            element: {
                type: {
                    name: "Enum",
                    allowedValues: ["Timestamps", "Etag", "Attributes", "PermissionKey"],
                },
            },
        },
    },
    collectionFormat: "CSV",
};
export const includeExtendedInfo = {
    parameterPath: ["options", "includeExtendedInfo"],
    mapper: {
        serializedName: "x-ms-file-extended-info",
        xmlName: "x-ms-file-extended-info",
        type: {
            name: "Boolean",
        },
    },
};
export const comp10 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "listhandles",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const recursive = {
    parameterPath: ["options", "recursive"],
    mapper: {
        serializedName: "x-ms-recursive",
        xmlName: "x-ms-recursive",
        type: {
            name: "Boolean",
        },
    },
};
export const comp11 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "forceclosehandles",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const handleId = {
    parameterPath: "handleId",
    mapper: {
        serializedName: "x-ms-handle-id",
        required: true,
        xmlName: "x-ms-handle-id",
        type: {
            name: "String",
        },
    },
};
export const comp12 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "rename",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const renameSource = {
    parameterPath: "renameSource",
    mapper: {
        serializedName: "x-ms-file-rename-source",
        required: true,
        xmlName: "x-ms-file-rename-source",
        type: {
            name: "String",
        },
    },
};
export const replaceIfExists = {
    parameterPath: ["options", "replaceIfExists"],
    mapper: {
        serializedName: "x-ms-file-rename-replace-if-exists",
        xmlName: "x-ms-file-rename-replace-if-exists",
        type: {
            name: "Boolean",
        },
    },
};
export const ignoreReadOnly = {
    parameterPath: ["options", "ignoreReadOnly"],
    mapper: {
        serializedName: "x-ms-file-rename-ignore-readonly",
        xmlName: "x-ms-file-rename-ignore-readonly",
        type: {
            name: "Boolean",
        },
    },
};
export const sourceLeaseId = {
    parameterPath: ["options", "sourceLeaseAccessConditions", "sourceLeaseId"],
    mapper: {
        serializedName: "x-ms-source-lease-id",
        xmlName: "x-ms-source-lease-id",
        type: {
            name: "String",
        },
    },
};
export const destinationLeaseId = {
    parameterPath: [
        "options",
        "destinationLeaseAccessConditions",
        "destinationLeaseId",
    ],
    mapper: {
        serializedName: "x-ms-destination-lease-id",
        xmlName: "x-ms-destination-lease-id",
        type: {
            name: "String",
        },
    },
};
export const fileAttributes1 = {
    parameterPath: ["options", "copyFileSmbInfo", "fileAttributes"],
    mapper: {
        serializedName: "x-ms-file-attributes",
        xmlName: "x-ms-file-attributes",
        type: {
            name: "String",
        },
    },
};
export const fileCreationTime = {
    parameterPath: ["options", "copyFileSmbInfo", "fileCreationTime"],
    mapper: {
        serializedName: "x-ms-file-creation-time",
        xmlName: "x-ms-file-creation-time",
        type: {
            name: "String",
        },
    },
};
export const fileLastWriteTime = {
    parameterPath: ["options", "copyFileSmbInfo", "fileLastWriteTime"],
    mapper: {
        serializedName: "x-ms-file-last-write-time",
        xmlName: "x-ms-file-last-write-time",
        type: {
            name: "String",
        },
    },
};
export const fileChangeTime = {
    parameterPath: ["options", "copyFileSmbInfo", "fileChangeTime"],
    mapper: {
        serializedName: "x-ms-file-change-time",
        xmlName: "x-ms-file-change-time",
        type: {
            name: "String",
        },
    },
};
export const allowSourceTrailingDot = {
    parameterPath: ["options", "allowSourceTrailingDot"],
    mapper: {
        serializedName: "x-ms-source-allow-trailing-dot",
        xmlName: "x-ms-source-allow-trailing-dot",
        type: {
            name: "Boolean",
        },
    },
};
export const contentType2 = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/octet-stream",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String",
        },
    },
};
export const body = {
    parameterPath: ["options", "body"],
    mapper: {
        serializedName: "body",
        xmlName: "body",
        type: {
            name: "Stream",
        },
    },
};
export const accept3 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String",
        },
    },
};
export const fileContentLength = {
    parameterPath: "fileContentLength",
    mapper: {
        serializedName: "x-ms-content-length",
        required: true,
        xmlName: "x-ms-content-length",
        type: {
            name: "Number",
        },
    },
};
export const fileTypeConstant = {
    parameterPath: "fileTypeConstant",
    mapper: {
        defaultValue: "file",
        isConstant: true,
        serializedName: "x-ms-type",
        type: {
            name: "String",
        },
    },
};
export const fileContentType = {
    parameterPath: ["options", "fileHttpHeaders", "fileContentType"],
    mapper: {
        serializedName: "x-ms-content-type",
        xmlName: "x-ms-content-type",
        type: {
            name: "String",
        },
    },
};
export const fileContentEncoding = {
    parameterPath: ["options", "fileHttpHeaders", "fileContentEncoding"],
    mapper: {
        serializedName: "x-ms-content-encoding",
        xmlName: "x-ms-content-encoding",
        type: {
            name: "String",
        },
    },
};
export const fileContentLanguage = {
    parameterPath: ["options", "fileHttpHeaders", "fileContentLanguage"],
    mapper: {
        serializedName: "x-ms-content-language",
        xmlName: "x-ms-content-language",
        type: {
            name: "String",
        },
    },
};
export const fileCacheControl = {
    parameterPath: ["options", "fileHttpHeaders", "fileCacheControl"],
    mapper: {
        serializedName: "x-ms-cache-control",
        xmlName: "x-ms-cache-control",
        type: {
            name: "String",
        },
    },
};
export const fileContentMD5 = {
    parameterPath: ["options", "fileHttpHeaders", "fileContentMD5"],
    mapper: {
        serializedName: "x-ms-content-md5",
        xmlName: "x-ms-content-md5",
        type: {
            name: "ByteArray",
        },
    },
};
export const fileContentDisposition = {
    parameterPath: ["options", "fileHttpHeaders", "fileContentDisposition"],
    mapper: {
        serializedName: "x-ms-content-disposition",
        xmlName: "x-ms-content-disposition",
        type: {
            name: "String",
        },
    },
};
export const nfsFileType = {
    parameterPath: ["options", "nfsFileType"],
    mapper: {
        serializedName: "x-ms-file-file-type",
        xmlName: "x-ms-file-file-type",
        type: {
            name: "String",
        },
    },
};
export const contentMD5 = {
    parameterPath: ["options", "contentMD5"],
    mapper: {
        serializedName: "Content-MD5",
        xmlName: "Content-MD5",
        type: {
            name: "ByteArray",
        },
    },
};
export const contentLength = {
    parameterPath: ["options", "contentLength"],
    mapper: {
        serializedName: "Content-Length",
        xmlName: "Content-Length",
        type: {
            name: "Number",
        },
    },
};
export const range = {
    parameterPath: ["options", "range"],
    mapper: {
        serializedName: "x-ms-range",
        xmlName: "x-ms-range",
        type: {
            name: "String",
        },
    },
};
export const rangeGetContentMD5 = {
    parameterPath: ["options", "rangeGetContentMD5"],
    mapper: {
        serializedName: "x-ms-range-get-content-md5",
        xmlName: "x-ms-range-get-content-md5",
        type: {
            name: "Boolean",
        },
    },
};
export const fileContentLength1 = {
    parameterPath: ["options", "fileContentLength"],
    mapper: {
        serializedName: "x-ms-content-length",
        xmlName: "x-ms-content-length",
        type: {
            name: "Number",
        },
    },
};
export const comp13 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "range",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const range1 = {
    parameterPath: "range",
    mapper: {
        serializedName: "x-ms-range",
        required: true,
        xmlName: "x-ms-range",
        type: {
            name: "String",
        },
    },
};
export const fileRangeWrite = {
    parameterPath: "fileRangeWrite",
    mapper: {
        defaultValue: "update",
        serializedName: "x-ms-write",
        required: true,
        xmlName: "x-ms-write",
        type: {
            name: "Enum",
            allowedValues: ["update", "clear"],
        },
    },
};
export const contentLength1 = {
    parameterPath: "contentLength",
    mapper: {
        serializedName: "Content-Length",
        required: true,
        xmlName: "Content-Length",
        type: {
            name: "Number",
        },
    },
};
export const fileLastWrittenMode = {
    parameterPath: ["options", "fileLastWrittenMode"],
    mapper: {
        serializedName: "x-ms-file-last-write-time",
        xmlName: "x-ms-file-last-write-time",
        type: {
            name: "Enum",
            allowedValues: ["Now", "Preserve"],
        },
    },
};
export const copySource = {
    parameterPath: "copySource",
    mapper: {
        serializedName: "x-ms-copy-source",
        required: true,
        xmlName: "x-ms-copy-source",
        type: {
            name: "String",
        },
    },
};
export const sourceRange = {
    parameterPath: ["options", "sourceRange"],
    mapper: {
        serializedName: "x-ms-source-range",
        xmlName: "x-ms-source-range",
        type: {
            name: "String",
        },
    },
};
export const fileRangeWriteFromUrl = {
    parameterPath: "fileRangeWriteFromUrl",
    mapper: {
        defaultValue: "update",
        isConstant: true,
        serializedName: "x-ms-write",
        type: {
            name: "String",
        },
    },
};
export const sourceContentCrc64 = {
    parameterPath: ["options", "sourceContentCrc64"],
    mapper: {
        serializedName: "x-ms-source-content-crc64",
        xmlName: "x-ms-source-content-crc64",
        type: {
            name: "ByteArray",
        },
    },
};
export const sourceIfMatchCrc64 = {
    parameterPath: [
        "options",
        "sourceModifiedAccessConditions",
        "sourceIfMatchCrc64",
    ],
    mapper: {
        serializedName: "x-ms-source-if-match-crc64",
        xmlName: "x-ms-source-if-match-crc64",
        type: {
            name: "ByteArray",
        },
    },
};
export const sourceIfNoneMatchCrc64 = {
    parameterPath: [
        "options",
        "sourceModifiedAccessConditions",
        "sourceIfNoneMatchCrc64",
    ],
    mapper: {
        serializedName: "x-ms-source-if-none-match-crc64",
        xmlName: "x-ms-source-if-none-match-crc64",
        type: {
            name: "ByteArray",
        },
    },
};
export const copySourceAuthorization = {
    parameterPath: ["options", "copySourceAuthorization"],
    mapper: {
        serializedName: "x-ms-copy-source-authorization",
        xmlName: "x-ms-copy-source-authorization",
        type: {
            name: "String",
        },
    },
};
export const comp14 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "rangelist",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const prevsharesnapshot = {
    parameterPath: ["options", "prevsharesnapshot"],
    mapper: {
        serializedName: "prevsharesnapshot",
        xmlName: "prevsharesnapshot",
        type: {
            name: "String",
        },
    },
};
export const supportRename = {
    parameterPath: ["options", "supportRename"],
    mapper: {
        serializedName: "x-ms-file-support-rename",
        xmlName: "x-ms-file-support-rename",
        type: {
            name: "Boolean",
        },
    },
};
export const filePermissionCopyMode = {
    parameterPath: ["options", "copyFileSmbInfo", "filePermissionCopyMode"],
    mapper: {
        serializedName: "x-ms-file-permission-copy-mode",
        xmlName: "x-ms-file-permission-copy-mode",
        type: {
            name: "Enum",
            allowedValues: ["source", "override"],
        },
    },
};
export const ignoreReadOnly1 = {
    parameterPath: ["options", "copyFileSmbInfo", "ignoreReadOnly"],
    mapper: {
        serializedName: "x-ms-file-copy-ignore-readonly",
        xmlName: "x-ms-file-copy-ignore-readonly",
        type: {
            name: "Boolean",
        },
    },
};
export const setArchiveAttribute = {
    parameterPath: ["options", "copyFileSmbInfo", "setArchiveAttribute"],
    mapper: {
        serializedName: "x-ms-file-copy-set-archive",
        xmlName: "x-ms-file-copy-set-archive",
        type: {
            name: "Boolean",
        },
    },
};
export const fileModeCopyMode = {
    parameterPath: ["options", "fileModeCopyMode"],
    mapper: {
        serializedName: "x-ms-file-mode-copy-mode",
        xmlName: "x-ms-file-mode-copy-mode",
        type: {
            name: "Enum",
            allowedValues: ["source", "override"],
        },
    },
};
export const fileOwnerCopyMode = {
    parameterPath: ["options", "fileOwnerCopyMode"],
    mapper: {
        serializedName: "x-ms-file-owner-copy-mode",
        xmlName: "x-ms-file-owner-copy-mode",
        type: {
            name: "Enum",
            allowedValues: ["source", "override"],
        },
    },
};
export const comp15 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "copy",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String",
        },
    },
};
export const copyId = {
    parameterPath: "copyId",
    mapper: {
        serializedName: "copyid",
        required: true,
        xmlName: "copyid",
        type: {
            name: "String",
        },
    },
};
export const copyActionAbortConstant = {
    parameterPath: "copyActionAbortConstant",
    mapper: {
        defaultValue: "abort",
        isConstant: true,
        serializedName: "x-ms-copy-action",
        type: {
            name: "String",
        },
    },
};
export const restype3 = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "symboliclink",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String",
        },
    },
};
export const linkText = {
    parameterPath: "linkText",
    mapper: {
        serializedName: "x-ms-link-text",
        required: true,
        xmlName: "x-ms-link-text",
        type: {
            name: "String",
        },
    },
};
export const restype4 = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "hardlink",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String",
        },
    },
};
export const targetFile = {
    parameterPath: "targetFile",
    mapper: {
        serializedName: "x-ms-file-target-file",
        required: true,
        xmlName: "x-ms-file-target-file",
        type: {
            name: "String",
        },
    },
};
//# sourceMappingURL=parameters.js.map